/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.BatchOptRoute;
import app.freerouting.autoroute.BoardUpdateStrategy;
import app.freerouting.autoroute.ItemRouteResult;
import app.freerouting.autoroute.ItemSelectionStrategy;
import app.freerouting.autoroute.OptimizeRouteTask;
import app.freerouting.board.Item;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.logger.FRLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BatchOptRouteMT
extends BatchOptRoute {
    private final BoardUpdateStrategy board_update_strategy;
    private final ItemSelectionStrategy item_selection_strategy;
    private ThreadPoolExecutor pool;
    private ItemRouteResult best_route_result;
    private OptimizeRouteTask winning_candidate;
    private final int thread_pool_size;
    private int num_tasks_finished = 0;
    private int update_count = 0;
    private final ArrayList<Integer> item_ids = new ArrayList();
    private final HashMap<Integer, ItemRouteResult> result_map = new HashMap();
    private CountDownLatch task_completion_signal = new CountDownLatch(1);
    private final ArrayList<BoardUpdateStrategy> hybrid_list = new ArrayList();
    private int hybrid_index = -1;

    public BatchOptRouteMT(InteractiveActionThread p_thread, int p_thread_pool_size, BoardUpdateStrategy p_board_update_strategy, ItemSelectionStrategy p_item_selection_strategy, String p_hrid_ratio) {
        super(p_thread);
        this.thread_pool_size = p_thread_pool_size;
        this.board_update_strategy = p_board_update_strategy;
        this.item_selection_strategy = p_board_update_strategy == BoardUpdateStrategy.GLOBAL_OPTIMAL ? ItemSelectionStrategy.SEQUENTIAL : p_item_selection_strategy;
        this.best_route_result = new ItemRouteResult(-1);
        this.winning_candidate = null;
        if (this.board_update_strategy == BoardUpdateStrategy.HYBRID) {
            int num_optimal = 1;
            int num_prioritized = 1;
            if (p_hrid_ratio != null && p_hrid_ratio.indexOf(":") > 0) {
                int i;
                String[] ratio = p_hrid_ratio.split(":");
                try {
                    num_optimal = Integer.parseInt(ratio[0], 10);
                    num_prioritized = Integer.parseInt(ratio[1], 10);
                }
                catch (NumberFormatException e) {
                    FRLogger.error("Invalid hybrid ratio", e);
                    num_optimal = 1;
                    num_prioritized = 1;
                }
                for (i = 0; i < num_optimal; ++i) {
                    this.hybrid_list.add(BoardUpdateStrategy.GLOBAL_OPTIMAL);
                }
                for (i = 0; i < num_prioritized; ++i) {
                    this.hybrid_list.add(BoardUpdateStrategy.GREEDY);
                }
            }
        }
    }

    public int get_num_tasks() {
        return this.item_ids.size();
    }

    public int get_num_tasks_finished() {
        return this.num_tasks_finished;
    }

    private BoardUpdateStrategy current_board_update_strategy() {
        if (this.board_update_strategy == BoardUpdateStrategy.HYBRID) {
            return this.hybrid_list.get(this.hybrid_index);
        }
        return this.board_update_strategy;
    }

    private ItemSelectionStrategy current_item_selection_strategy() {
        return this.current_board_update_strategy() == BoardUpdateStrategy.GLOBAL_OPTIMAL ? ItemSelectionStrategy.SEQUENTIAL : this.item_selection_strategy;
    }

    synchronized void prepare_task_completion_signal() {
        if (this.task_completion_signal.getCount() <= 0L) {
            this.task_completion_signal = new CountDownLatch(1);
        }
    }

    public synchronized boolean is_winning_candidate(OptimizeRouteTask task) {
        ++this.num_tasks_finished;
        ItemRouteResult r = task.getRouteResult();
        this.result_map.put(r.item_id(), r);
        boolean won = false;
        if (r.improved()) {
            if (this.winning_candidate == null) {
                won = true;
                this.winning_candidate = task;
                this.best_route_result = r;
            } else if (r.improved_over(this.best_route_result)) {
                won = true;
                this.winning_candidate.clean();
                this.winning_candidate = task;
                this.best_route_result = r;
            }
        }
        if (won && this.current_board_update_strategy() == BoardUpdateStrategy.GREEDY) {
            this.update_master_routing_board();
        }
        this.task_completion_signal.countDown();
        return won;
    }

    private void update_master_routing_board() {
        this.thread.hdlg.update_routing_board(this.winning_candidate.routing_board);
        this.routing_board = this.thread.hdlg.get_routing_board();
        this.min_cumulative_trace_length_before = BatchOptRouteMT.calc_weighted_trace_length(this.routing_board);
        double new_trace_length = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
        this.thread.hdlg.screen_messages.set_post_route_info(this.routing_board.get_vias().size(), new_trace_length, this.thread.hdlg.coordinate_transform.user_unit);
        ++this.update_count;
    }

    private void prepare_next_round_of_route_items() {
        if (this.board_update_strategy == BoardUpdateStrategy.HYBRID) {
            this.hybrid_index = (this.hybrid_index + 1) % this.hybrid_list.size();
        }
        this.item_ids.clear();
        this.sorted_route_items = new BatchOptRoute.ReadSortedRouteItems();
        if (this.current_item_selection_strategy() == ItemSelectionStrategy.PRIORITIZED && !this.result_map.isEmpty()) {
            ArrayList<Integer> new_item_ids = new ArrayList<Integer>();
            PriorityQueue<ItemRouteResult> pq = new PriorityQueue<ItemRouteResult>();
            Item item = this.sorted_route_items.next();
            while (item != null) {
                ItemRouteResult r = this.result_map.get(item.get_id_no());
                if (r != null) {
                    pq.add(r);
                } else {
                    new_item_ids.add(item.get_id_no());
                }
                item = this.sorted_route_items.next();
            }
            ItemRouteResult r = (ItemRouteResult)pq.poll();
            while (r != null) {
                this.item_ids.add(r.item_id());
                r = (ItemRouteResult)pq.poll();
            }
            this.item_ids.addAll(new_item_ids);
        } else {
            Item item = this.sorted_route_items.next();
            while (item != null) {
                this.item_ids.add(item.get_id_no());
                item = this.sorted_route_items.next();
            }
            if (this.current_item_selection_strategy() == ItemSelectionStrategy.RANDOM) {
                Collections.shuffle(this.item_ids);
            }
        }
        this.sorted_route_items = null;
        this.result_map.clear();
    }

    @Override
    protected float opt_route_pass(int p_pass_no, boolean p_with_preferred_directions) {
        String us;
        long startTime = System.currentTimeMillis();
        this.update_count = 0;
        this.num_tasks_finished = 0;
        if (this.winning_candidate != null) {
            this.winning_candidate.clean();
            this.winning_candidate = null;
        }
        int via_count_before = this.routing_board.get_vias().size();
        double user_trace_length_before = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
        this.thread.hdlg.screen_messages.set_post_route_info(via_count_before, user_trace_length_before, this.thread.hdlg.coordinate_transform.user_unit);
        this.min_cumulative_trace_length_before = BatchOptRouteMT.calc_weighted_trace_length(this.routing_board);
        String optimizationPassId = "BatchOptRouteMT.opt_route_pass #" + p_pass_no + " with " + this.item_ids.size() + " items, " + via_count_before + " vias and " + String.format("%(,.2f", user_trace_length_before) + " trace length running on " + this.thread_pool_size + " threads.";
        FRLogger.traceEntry(optimizationPassId);
        this.prepare_next_round_of_route_items();
        this.best_route_result = new ItemRouteResult(-1);
        this.winning_candidate = null;
        this.pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.thread_pool_size, r -> {
            Thread t = new Thread(r);
            t.setUncaughtExceptionHandler((t1, e) -> FRLogger.error("Exception in thread pool worker thread: " + t1, e));
            return t;
        });
        for (int t = 0; t < this.item_ids.size(); ++t) {
            int item_id = this.item_ids.get(t);
            FRLogger.debug("Scheduling task #" + (t + 1) + " of " + this.item_ids.size() + " for item #" + item_id + ".");
            this.pool.execute(new OptimizeRouteTask(this, item_id, p_pass_no, p_with_preferred_directions, this.min_cumulative_trace_length_before));
        }
        FRLogger.debug("All items are queued for execution, waiting for the tasks to finish.");
        this.pool.shutdown();
        boolean interrupted = false;
        try {
            boolean i = false;
            while (!this.pool.awaitTermination(1L, TimeUnit.SECONDS)) {
                FRLogger.debug("Running route optimizer on " + this.pool.getActiveCount() + " thread(s). Completed " + this.pool.getCompletedTaskCount() + " of " + this.pool.getTaskCount() + " tasks.");
                if (!this.thread.is_stop_requested()) continue;
                this.pool.shutdownNow();
                return this.best_route_result.improvement_percentage();
            }
        }
        catch (InterruptedException ie) {
            FRLogger.error("Exception with pool.awaitTermination", ie);
            interrupted = true;
            this.pool.shutdownNow();
        }
        this.pool = null;
        if (!interrupted && this.best_route_result.improved() && this.current_board_update_strategy() == BoardUpdateStrategy.GLOBAL_OPTIMAL) {
            this.update_master_routing_board();
        }
        float route_improved = this.best_route_result.improvement_percentage();
        if (this.use_increased_ripup_costs && !this.best_route_result.improved()) {
            this.use_increased_ripup_costs = false;
            route_improved = -1.0f;
        }
        long duration = System.currentTimeMillis() - startTime;
        long minutes = duration / 60000L;
        float sec = (float)(duration % 60000L) / 1000.0f;
        String string = us = this.current_board_update_strategy() == BoardUpdateStrategy.GLOBAL_OPTIMAL ? "Global Optimal" : "Greedy";
        String is = this.current_item_selection_strategy() == ItemSelectionStrategy.SEQUENTIAL ? "Sequential" : (this.current_item_selection_strategy() == ItemSelectionStrategy.RANDOM ? "Random" : "Prioritized");
        double user_trace_length_after = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
        FRLogger.debug("Finished pass #" + p_pass_no + " in " + minutes + " minutes " + sec + " seconds with " + this.update_count + " board updates using " + this.thread_pool_size + " thread(s) with '" + us + "' strategy and '" + is + "' item selection strategy.");
        FRLogger.debug("Route optimizer pass summary - Improved: " + this.best_route_result.improved() + ", interrupted: " + interrupted + ", via count: " + this.best_route_result.via_count() + ", trace length: " + (int)user_trace_length_after + ", via count delta: " + (via_count_before - this.best_route_result.via_count()) + ", trace length delta: " + (int)(user_trace_length_before - user_trace_length_after) + ".");
        FRLogger.traceExit(optimizationPassId);
        return route_improved;
    }
}

