/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.BatchAutorouter;
import app.freerouting.autoroute.ItemRouteResult;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.TestLevel;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.interactive.RatsNest;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.BoardRules;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public class BatchOptRoute {
    protected static int MAX_AUTOROUTE_PASSES = 6;
    protected static int ADDITIONAL_RIPUP_COST_FACTOR_AT_START = 10;
    protected final InteractiveActionThread thread;
    protected boolean clone_board;
    protected RoutingBoard routing_board;
    protected ReadSortedRouteItems sorted_route_items;
    protected boolean use_increased_ripup_costs;
    protected double min_cumulative_trace_length_before = 0.0;

    public BatchOptRoute(InteractiveActionThread p_thread) {
        this(p_thread, false);
    }

    public BatchOptRoute(InteractiveActionThread p_thread, boolean p_clone_board) {
        this.thread = p_thread;
        this.clone_board = p_clone_board;
        this.routing_board = p_clone_board ? p_thread.hdlg.deep_copy_routing_board() : p_thread.hdlg.get_routing_board();
    }

    static boolean contains_only_unfixed_traces(Collection<Item> p_item_list) {
        for (Item curr_item : p_item_list) {
            if (!curr_item.is_user_fixed() && curr_item instanceof Trace) continue;
            return false;
        }
        return true;
    }

    protected static double calc_weighted_trace_length(RoutingBoard p_board) {
        UndoableObjects.Storable curr_item;
        double result = 0.0;
        int default_clearance_class = BoardRules.default_clearance_class();
        Iterator<UndoableObjects.UndoableObjectNode> it = p_board.item_list.start_read_object();
        while ((curr_item = p_board.item_list.read_object(it)) != null) {
            Trace curr_trace;
            FixedState fixed_state;
            if (!(curr_item instanceof Trace) || (fixed_state = (curr_trace = (Trace)curr_item).get_fixed_state()) != FixedState.UNFIXED && fixed_state != FixedState.SHOVE_FIXED) continue;
            double weighted_trace_length = curr_trace.get_length() * (double)(curr_trace.get_half_width() + p_board.clearance_value(curr_trace.clearance_class_no(), default_clearance_class, curr_trace.get_layer()));
            if (fixed_state == FixedState.SHOVE_FIXED) {
                weighted_trace_length /= 2.0;
            }
            result += weighted_trace_length;
        }
        return result;
    }

    public void optimize_board(boolean save_intermediate_stages, float optimization_improvement_threshold, InteractiveActionThread isStopRequested) {
        if (this.routing_board.get_test_level() != TestLevel.RELEASE_VERSION) {
            FRLogger.warn("Before optimize: Via count: " + this.routing_board.get_vias().size() + ", trace length: " + Math.round(this.routing_board.cumulative_trace_length()));
        }
        double route_improved = -1.0;
        int curr_pass_no = 0;
        this.use_increased_ripup_costs = true;
        while ((route_improved >= (double)optimization_improvement_threshold || route_improved < 0.0) && !isStopRequested.is_stop_requested()) {
            boolean bl = ++curr_pass_no % 2 != 0;
            boolean with_preferred_directions = bl;
            route_improved = this.opt_route_pass(curr_pass_no, with_preferred_directions);
            if (!(route_improved > (double)optimization_improvement_threshold) || !save_intermediate_stages) continue;
            this.thread.hdlg.get_panel().board_frame.save_intermediate_stage_file();
        }
    }

    protected float opt_route_pass(int p_pass_no, boolean p_with_preferred_directions) {
        float route_improved = 0.0f;
        int via_count_before = this.routing_board.get_vias().size();
        double trace_length_before = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
        this.thread.hdlg.screen_messages.set_post_route_info(via_count_before, trace_length_before, this.thread.hdlg.coordinate_transform.user_unit);
        this.sorted_route_items = new ReadSortedRouteItems();
        this.min_cumulative_trace_length_before = BatchOptRoute.calc_weighted_trace_length(this.routing_board);
        String optimizationPassId = "BatchOptRoute.opt_route_pass #" + p_pass_no + " with " + via_count_before + " vias and " + String.format("%(,.2f", trace_length_before) + " trace length.";
        FRLogger.traceEntry(optimizationPassId);
        while (true) {
            if (this.thread.is_stop_requested()) {
                FRLogger.traceExit(optimizationPassId);
                return route_improved;
            }
            Item curr_item = this.sorted_route_items.next();
            if (curr_item == null) break;
            if (!this.opt_route_item(curr_item, p_pass_no, p_with_preferred_directions).improved()) continue;
            int via_count_after = this.routing_board.get_vias().size();
            double trace_length_after = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
            route_improved = (float)(via_count_before != 0 && trace_length_before != 0.0 ? 1.0 - ((double)(via_count_after / via_count_before) + trace_length_after / trace_length_before) / 2.0 : 0.0);
        }
        this.sorted_route_items = null;
        if (this.use_increased_ripup_costs && route_improved == 0.0f) {
            this.use_increased_ripup_costs = false;
            route_improved = -1.0f;
        }
        FRLogger.traceExit(optimizationPassId);
        return route_improved;
    }

    protected void remove_ratsnest() {
        this.thread.hdlg.remove_ratsnest();
    }

    protected RatsNest get_ratsnest() {
        return this.thread.hdlg.get_ratsnest();
    }

    protected ItemRouteResult opt_route_item(Item p_item, int p_pass_no, boolean p_with_preferred_directions) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.interactive.InteractiveState", this.thread.hdlg.get_locale());
        String start_message = resources.getString("batch_optimizer") + " " + resources.getString("stop_message") + "        " + resources.getString("routeoptimizer_pass") + p_pass_no;
        this.thread.hdlg.screen_messages.set_status_message(start_message);
        this.remove_ratsnest();
        int incomplete_count_before = this.get_ratsnest().incomplete_count();
        int via_count_before = this.routing_board.get_vias().size();
        TreeSet<Item> ripped_items = new TreeSet<Item>();
        ripped_items.add(p_item);
        if (p_item instanceof Trace) {
            Trace curr_trace = (Trace)p_item;
            Object curr_contact_list = curr_trace.get_start_contacts();
            for (int i = 0; i < 2; ++i) {
                if (BatchOptRoute.contains_only_unfixed_traces((Collection<Item>)curr_contact_list)) {
                    ripped_items.addAll((Collection<Item>)curr_contact_list);
                }
                curr_contact_list = curr_trace.get_end_contacts();
            }
        }
        TreeSet<Item> ripped_connections = new TreeSet<Item>();
        for (Item curr_item : ripped_items) {
            ripped_connections.addAll(curr_item.get_connection_items(Item.StopConnectionOption.NONE));
        }
        for (Item curr_item : ripped_connections) {
            if (!curr_item.is_user_fixed()) continue;
            return new ItemRouteResult(p_item.get_id_no());
        }
        if (!this.clone_board) {
            this.routing_board.generate_snapshot();
        }
        this.routing_board.remove_items(ripped_connections, false);
        for (int i = 0; i < p_item.net_count(); ++i) {
            this.routing_board.combine_traces(p_item.get_net_no(i));
        }
        int ripup_costs = this.thread.hdlg.get_settings().autoroute_settings.get_start_ripup_costs();
        if (this.use_increased_ripup_costs) {
            ripup_costs *= ADDITIONAL_RIPUP_COST_FACTOR_AT_START;
        }
        if (p_item instanceof Trace) {
            ripup_costs = (int)Math.round(0.6 * (double)ripup_costs);
        }
        BatchAutorouter.autoroute_passes_for_optimizing_item(this.thread, MAX_AUTOROUTE_PASSES, ripup_costs, p_with_preferred_directions, this.clone_board ? this.routing_board : null);
        this.remove_ratsnest();
        int incomplete_count_after = this.get_ratsnest().incomplete_count();
        int via_count_after = this.routing_board.get_vias().size();
        double trace_length_after = BatchOptRoute.calc_weighted_trace_length(this.routing_board);
        ItemRouteResult result = new ItemRouteResult(p_item.get_id_no(), via_count_before, via_count_after, this.min_cumulative_trace_length_before, trace_length_after, incomplete_count_before, incomplete_count_after);
        boolean route_improved = !this.thread.is_stop_requested() && result.improved();
        result.update_improved(route_improved);
        if (route_improved) {
            this.min_cumulative_trace_length_before = incomplete_count_after < incomplete_count_before || incomplete_count_after == incomplete_count_before && via_count_after < via_count_before ? trace_length_after : Math.min(this.min_cumulative_trace_length_before, trace_length_after);
            if (!this.clone_board) {
                this.routing_board.pop_snapshot();
            }
            double new_trace_length = this.thread.hdlg.coordinate_transform.board_to_user(this.routing_board.cumulative_trace_length());
            this.thread.hdlg.screen_messages.set_post_route_info(via_count_after, new_trace_length, this.thread.hdlg.coordinate_transform.user_unit);
        } else if (!this.clone_board) {
            this.routing_board.undo(null);
        }
        return result;
    }

    public FloatPoint get_current_position() {
        if (this.sorted_route_items == null) {
            return null;
        }
        return this.sorted_route_items.get_current_position();
    }

    protected class ReadSortedRouteItems {
        protected FloatPoint min_item_coor = new FloatPoint(-2.147483648E9, -2.147483648E9);
        protected int min_item_layer = -1;

        ReadSortedRouteItems() {
        }

        Item next() {
            UndoableObjects.Storable curr_item;
            Item result = null;
            FloatPoint curr_min_coor = new FloatPoint(2.147483647E9, 2.147483647E9);
            int curr_min_layer = Integer.MAX_VALUE;
            Iterator<UndoableObjects.UndoableObjectNode> it = BatchOptRoute.this.routing_board.item_list.start_read_object();
            while ((curr_item = BatchOptRoute.this.routing_board.item_list.read_object(it)) != null) {
                Via curr_via;
                if (!(curr_item instanceof Via) || (curr_via = (Via)curr_item).is_user_fixed()) continue;
                FloatPoint curr_via_center = curr_via.get_center().to_float();
                int curr_via_min_layer = curr_via.first_layer();
                if (!(curr_via_center.x > this.min_item_coor.x) && (curr_via_center.x != this.min_item_coor.x || !(curr_via_center.y > this.min_item_coor.y) && (curr_via_center.y != this.min_item_coor.y || curr_via_min_layer <= this.min_item_layer)) || !(curr_via_center.x < curr_min_coor.x) && (curr_via_center.x != curr_min_coor.x || !(curr_via_center.y < curr_min_coor.y) && (curr_via_center.y != curr_min_coor.y || curr_via_min_layer >= curr_min_layer))) continue;
                curr_min_coor = curr_via_center;
                curr_min_layer = curr_via_min_layer;
                result = curr_via;
            }
            it = BatchOptRoute.this.routing_board.item_list.start_read_object();
            while ((curr_item = BatchOptRoute.this.routing_board.item_list.read_object(it)) != null) {
                Trace curr_trace;
                if (!(curr_item instanceof Trace) || (curr_trace = (Trace)curr_item).is_shove_fixed()) continue;
                FloatPoint first_corner = curr_trace.first_corner().to_float();
                FloatPoint last_corner = curr_trace.last_corner().to_float();
                FloatPoint compare_corner = first_corner.x < last_corner.x || first_corner.x == last_corner.x && first_corner.y < last_corner.y ? last_corner : first_corner;
                int curr_trace_layer = curr_trace.get_layer();
                if (!(compare_corner.x > this.min_item_coor.x) && (compare_corner.x != this.min_item_coor.x || !(compare_corner.y > this.min_item_coor.y) && (compare_corner.y != this.min_item_coor.y || curr_trace_layer <= this.min_item_layer)) || !(compare_corner.x < curr_min_coor.x) && (compare_corner.x != curr_min_coor.x || !(compare_corner.y < curr_min_coor.y) && (compare_corner.y != curr_min_coor.y || curr_trace_layer >= curr_min_layer))) continue;
                boolean is_connected_to_via = false;
                Set<Item> trace_contacts = curr_trace.get_normal_contacts();
                for (Item curr_contact : trace_contacts) {
                    if (!(curr_contact instanceof Via) || curr_contact.is_user_fixed()) continue;
                    is_connected_to_via = true;
                    break;
                }
                if (is_connected_to_via) continue;
                curr_min_coor = compare_corner;
                curr_min_layer = curr_trace_layer;
                result = curr_trace;
            }
            this.min_item_coor = curr_min_coor;
            this.min_item_layer = curr_min_layer;
            return result;
        }

        FloatPoint get_current_position() {
            return this.min_item_coor;
        }
    }
}

