/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteEngine;
import app.freerouting.board.Pin;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.TestLevel;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

public class BatchFanout {
    private final InteractiveActionThread thread;
    private final RoutingBoard routing_board;
    private final SortedSet<Component> sorted_components;

    private BatchFanout(InteractiveActionThread p_thread) {
        this.thread = p_thread;
        this.routing_board = p_thread.hdlg.get_routing_board();
        Collection<Pin> board_smd_pin_list = this.routing_board.get_smd_pins();
        this.sorted_components = new TreeSet<Component>();
        for (int i = 1; i <= this.routing_board.components.count(); ++i) {
            app.freerouting.board.Component curr_board_component = this.routing_board.components.get(i);
            Component curr_component = new Component(curr_board_component, board_smd_pin_list);
            if (curr_component.smd_pin_count <= 0) continue;
            this.sorted_components.add(curr_component);
        }
    }

    public static void fanout_board(InteractiveActionThread p_thread) {
        int routed_count;
        BatchFanout fanout_instance = new BatchFanout(p_thread);
        int MAX_PASS_COUNT = 20;
        for (int i = 0; i < 20 && (routed_count = fanout_instance.fanout_pass(i)) != 0; ++i) {
        }
    }

    private int fanout_pass(int p_pass_no) {
        int components_to_go = this.sorted_components.size();
        int routed_count = 0;
        int not_routed_count = 0;
        int insert_error_count = 0;
        int ripup_costs = this.thread.hdlg.get_settings().autoroute_settings.get_start_ripup_costs() * (p_pass_no + 1);
        for (Component curr_component : this.sorted_components) {
            this.thread.hdlg.screen_messages.set_batch_fanout_info(p_pass_no + 1, components_to_go);
            for (Component.Pin curr_pin : curr_component.smd_pins) {
                double max_milliseconds = 10000 * (p_pass_no + 1);
                TimeLimit time_limit = new TimeLimit((int)max_milliseconds);
                this.routing_board.start_marking_changed_area();
                AutorouteEngine.AutorouteResult curr_result = this.routing_board.fanout(curr_pin.board_pin, this.thread.hdlg.get_settings(), ripup_costs, this.thread, time_limit);
                switch (curr_result) {
                    case ROUTED: {
                        ++routed_count;
                        break;
                    }
                    case NOT_ROUTED: {
                        ++not_routed_count;
                        break;
                    }
                    case INSERT_ERROR: {
                        ++insert_error_count;
                    }
                }
                if (curr_result != AutorouteEngine.AutorouteResult.NOT_ROUTED) {
                    this.thread.hdlg.repaint();
                }
                if (!this.thread.is_stop_requested()) continue;
                return routed_count;
            }
            --components_to_go;
        }
        if (this.routing_board.get_test_level() != TestLevel.RELEASE_VERSION) {
            FRLogger.warn("fanout pass: " + (p_pass_no + 1) + ", routed: " + routed_count + ", not routed: " + not_routed_count + ", errors: " + insert_error_count);
        }
        return routed_count;
    }

    private static class Component
    implements Comparable<Component> {
        final app.freerouting.board.Component board_component;
        final int smd_pin_count;
        final SortedSet<Pin> smd_pins;
        final FloatPoint gravity_center_of_smd_pins;

        Component(app.freerouting.board.Component p_board_component, Collection<app.freerouting.board.Pin> p_board_smd_pin_list) {
            this.board_component = p_board_component;
            LinkedList<app.freerouting.board.Pin> curr_pin_list = new LinkedList<app.freerouting.board.Pin>();
            int cmp_no = p_board_component.no;
            for (app.freerouting.board.Pin curr_board_pin : p_board_smd_pin_list) {
                if (curr_board_pin.get_component_no() != cmp_no) continue;
                curr_pin_list.add(curr_board_pin);
            }
            double x = 0.0;
            double y = 0.0;
            for (app.freerouting.board.Pin curr_pin : curr_pin_list) {
                FloatPoint curr_point = curr_pin.get_center().to_float();
                x += curr_point.x;
                y += curr_point.y;
            }
            this.smd_pin_count = curr_pin_list.size();
            this.gravity_center_of_smd_pins = new FloatPoint(x /= (double)this.smd_pin_count, y /= (double)this.smd_pin_count);
            this.smd_pins = new TreeSet<Pin>();
            for (app.freerouting.board.Pin curr_board_pin : curr_pin_list) {
                this.smd_pins.add(new Pin(curr_board_pin));
            }
        }

        @Override
        public int compareTo(Component p_other) {
            int compare_value = this.smd_pin_count - p_other.smd_pin_count;
            int result = compare_value > 0 ? -1 : (compare_value < 0 ? 1 : this.board_component.no - p_other.board_component.no);
            return result;
        }

        class Pin
        implements Comparable<Pin> {
            final app.freerouting.board.Pin board_pin;
            final double distance_to_component_center;

            Pin(app.freerouting.board.Pin p_board_pin) {
                this.board_pin = p_board_pin;
                FloatPoint pin_location = p_board_pin.get_center().to_float();
                this.distance_to_component_center = pin_location.distance(Component.this.gravity_center_of_smd_pins);
            }

            @Override
            public int compareTo(Pin p_other) {
                double delta_dist = this.distance_to_component_center - p_other.distance_to_component_center;
                int result = delta_dist > 0.0 ? 1 : (delta_dist < 0.0 ? -1 : this.board_pin.pin_no - p_other.board_pin.pin_no);
                return result;
            }
        }
    }
}

