/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.CompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.DrillPageArray;
import app.freerouting.autoroute.ExpansionDoor;
import app.freerouting.autoroute.ExpansionRoom;
import app.freerouting.autoroute.IncompleteFreeSpaceExpansionRoom;
import app.freerouting.autoroute.InsertFoundConnectionAlgo;
import app.freerouting.autoroute.ItemAutorouteInfo;
import app.freerouting.autoroute.LocateFoundConnectionAlgo;
import app.freerouting.autoroute.MazeSearchAlgo;
import app.freerouting.autoroute.ObstacleExpansionRoom;
import app.freerouting.autoroute.Sorted45DegreeRoomNeighbours;
import app.freerouting.autoroute.SortedOrthogonalRoomNeighbours;
import app.freerouting.autoroute.SortedRoomNeighbours;
import app.freerouting.autoroute.TargetItemExpansionDoor;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.ShapeSearchTree45Degree;
import app.freerouting.board.ShapeSearchTree90Degree;
import app.freerouting.board.TestLevel;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.Stoppable;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Simplex;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AutorouteEngine {
    static final int TRACE_WIDTH_TOLERANCE = 2;
    public final ShapeSearchTree autoroute_search_tree;
    public final boolean maintain_database;
    final DrillPageArray drill_page_array;
    final RoutingBoard board;
    Stoppable stoppable_thread;
    private int net_no;
    private TimeLimit time_limit;
    private List<IncompleteFreeSpaceExpansionRoom> incomplete_expansion_rooms;
    private List<CompleteFreeSpaceExpansionRoom> complete_expansion_rooms;
    private int expansion_room_instance_count = 0;

    public AutorouteEngine(RoutingBoard p_board, int p_trace_clearance_class_no, boolean p_maintain_database) {
        this.board = p_board;
        this.maintain_database = p_maintain_database;
        this.net_no = -1;
        this.autoroute_search_tree = p_board.search_tree_manager.get_autoroute_tree(p_trace_clearance_class_no);
        int max_drill_page_width = (int)(5.0 * p_board.rules.get_default_via_diameter());
        max_drill_page_width = Math.max(max_drill_page_width, 10000);
        this.drill_page_array = new DrillPageArray(this.board, max_drill_page_width);
        this.stoppable_thread = null;
    }

    public void init_connection(int p_net_no, Stoppable p_stoppable_thread, TimeLimit p_time_limit) {
        if (this.maintain_database && p_net_no != this.net_no) {
            if (this.complete_expansion_rooms != null) {
                LinkedList<CompleteFreeSpaceExpansionRoom> rooms_to_remove = new LinkedList<CompleteFreeSpaceExpansionRoom>();
                for (CompleteFreeSpaceExpansionRoom curr_room : this.complete_expansion_rooms) {
                    if (!curr_room.is_net_dependent()) continue;
                    rooms_to_remove.add(curr_room);
                }
                for (CompleteFreeSpaceExpansionRoom curr_room : rooms_to_remove) {
                    this.remove_complete_expansion_room(curr_room);
                }
            }
            Collection<Item> item_list = this.board.get_items();
            for (Item curr_item : item_list) {
                if (!curr_item.contains_net(p_net_no)) continue;
                this.board.additional_update_after_change(curr_item);
            }
        }
        this.net_no = p_net_no;
        this.stoppable_thread = p_stoppable_thread;
        this.time_limit = p_time_limit;
    }

    public AutorouteResult autoroute_connection(Set<Item> p_start_set, Set<Item> p_dest_set, AutorouteControl p_ctrl, SortedSet<Item> p_ripped_item_list) {
        boolean observers_activated;
        MazeSearchAlgo maze_search_algo;
        try {
            maze_search_algo = MazeSearchAlgo.get_instance(p_start_set, p_dest_set, this, p_ctrl);
        }
        catch (Exception e) {
            FRLogger.error("AutorouteEngine.autoroute_connection: Exception in MazeSearchAlgo.get_instance", e);
            maze_search_algo = null;
        }
        MazeSearchAlgo.Result search_result = null;
        if (maze_search_algo != null) {
            try {
                search_result = maze_search_algo.find_connection();
            }
            catch (Exception e) {
                FRLogger.error("AutorouteEngine.autoroute_connection: Exception in maze_search_algo.find_connection", e);
            }
        }
        LocateFoundConnectionAlgo autoroute_result = null;
        if (search_result != null) {
            try {
                autoroute_result = LocateFoundConnectionAlgo.get_instance(search_result, p_ctrl, this.autoroute_search_tree, this.board.rules.get_trace_angle_restriction(), p_ripped_item_list, this.board.get_test_level());
            }
            catch (Exception e) {
                FRLogger.error("AutorouteEngine.autoroute_connection: Exception in LocateFoundConnectionAlgo.get_instance", e);
            }
        }
        if (!this.maintain_database) {
            this.clear();
        } else {
            this.reset_all_doors();
        }
        if (autoroute_result == null) {
            return AutorouteResult.NOT_ROUTED;
        }
        if (!p_ctrl.layer_active[autoroute_result.start_layer] || !p_ctrl.layer_active[autoroute_result.target_layer]) {
            return AutorouteResult.NOT_ROUTED;
        }
        if (autoroute_result.connection_items == null) {
            if (this.board.get_test_level().ordinal() >= TestLevel.CRITICAL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("AutorouteEngine.autoroute_connection: result_items != null expected");
            }
            return AutorouteResult.ALREADY_CONNECTED;
        }
        TreeSet<Item> ripped_connections = new TreeSet<Item>();
        TreeSet<Integer> changed_nets = new TreeSet<Integer>();
        Item.StopConnectionOption stop_connection_option = p_ctrl.remove_unconnected_vias ? Item.StopConnectionOption.NONE : Item.StopConnectionOption.FANOUT_VIA;
        for (Item item : p_ripped_item_list) {
            ripped_connections.addAll(item.get_connection_items(stop_connection_option));
            for (int i = 0; i < item.net_count(); ++i) {
                changed_nets.add(item.get_net_no(i));
            }
        }
        boolean bl = observers_activated = !this.board.observers_active();
        if (observers_activated) {
            this.board.start_notify_observers();
        }
        this.board.remove_items(ripped_connections, false);
        Iterator iterator = changed_nets.iterator();
        while (iterator.hasNext()) {
            int curr_net_no = (Integer)iterator.next();
            this.board.remove_trace_tails(curr_net_no, stop_connection_option);
        }
        InsertFoundConnectionAlgo insertFoundConnectionAlgo = InsertFoundConnectionAlgo.get_instance(autoroute_result, this.board, p_ctrl);
        if (observers_activated) {
            this.board.end_notify_observers();
        }
        if (insertFoundConnectionAlgo == null) {
            return AutorouteResult.INSERT_ERROR;
        }
        return AutorouteResult.ROUTED;
    }

    public int get_net_no() {
        return this.net_no;
    }

    public boolean is_stop_requested() {
        if (this.time_limit != null && this.time_limit.limit_exceeded()) {
            return true;
        }
        if (this.stoppable_thread == null) {
            return false;
        }
        return this.stoppable_thread.is_stop_requested();
    }

    public void clear() {
        if (this.complete_expansion_rooms != null) {
            for (CompleteFreeSpaceExpansionRoom curr_room : this.complete_expansion_rooms) {
                curr_room.remove_from_tree(this.autoroute_search_tree);
            }
        }
        this.complete_expansion_rooms = null;
        this.incomplete_expansion_rooms = null;
        this.expansion_room_instance_count = 0;
        this.board.clear_all_item_temporary_autoroute_data();
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, double p_intensity) {
        if (this.complete_expansion_rooms == null) {
            return;
        }
        for (CompleteFreeSpaceExpansionRoom curr_room : this.complete_expansion_rooms) {
            curr_room.draw(p_graphics, p_graphics_context, p_intensity);
        }
        Collection<Item> item_list = this.board.get_items();
        for (Item curr_item : item_list) {
            ItemAutorouteInfo autoroute_info = curr_item.get_autoroute_info();
            if (autoroute_info == null) continue;
            autoroute_info.draw(p_graphics, p_graphics_context, p_intensity);
        }
    }

    public IncompleteFreeSpaceExpansionRoom add_incomplete_expansion_room(TileShape p_shape, int p_layer, TileShape p_contained_shape) {
        IncompleteFreeSpaceExpansionRoom new_room = new IncompleteFreeSpaceExpansionRoom(p_shape, p_layer, p_contained_shape);
        if (this.incomplete_expansion_rooms == null) {
            this.incomplete_expansion_rooms = new LinkedList<IncompleteFreeSpaceExpansionRoom>();
        }
        this.incomplete_expansion_rooms.add(new_room);
        return new_room;
    }

    public IncompleteFreeSpaceExpansionRoom get_first_incomplete_expansion_room() {
        if (this.incomplete_expansion_rooms == null) {
            return null;
        }
        if (this.incomplete_expansion_rooms.isEmpty()) {
            return null;
        }
        Iterator<IncompleteFreeSpaceExpansionRoom> it = this.incomplete_expansion_rooms.iterator();
        return it.next();
    }

    public void remove_incomplete_expansion_room(IncompleteFreeSpaceExpansionRoom p_room) {
        this.remove_all_doors(p_room);
        this.incomplete_expansion_rooms.remove(p_room);
    }

    public void remove_complete_expansion_room(CompleteFreeSpaceExpansionRoom p_room) {
        TileShape room_shape = p_room.get_shape();
        int room_layer = p_room.get_layer();
        List<ExpansionDoor> room_doors = p_room.get_doors();
        for (ExpansionDoor curr_door : room_doors) {
            CompleteExpansionRoom curr_neighbour = curr_door.other_room(p_room);
            if (curr_neighbour == null) continue;
            curr_neighbour.remove_door(curr_door);
            TileShape neighbour_shape = curr_neighbour.get_shape();
            TileShape intersection = room_shape.intersection(neighbour_shape);
            if (intersection.dimension() != 1) continue;
            int[] touching_sides = room_shape.touching_sides(neighbour_shape);
            Line[] line_arr = new Line[]{neighbour_shape.border_line(touching_sides[1]).opposite()};
            Simplex new_incomplete_room_shape = Simplex.get_instance(line_arr);
            IncompleteFreeSpaceExpansionRoom new_incomplete_room = this.add_incomplete_expansion_room(new_incomplete_room_shape, room_layer, intersection);
            ExpansionDoor new_door = new ExpansionDoor(curr_neighbour, new_incomplete_room, 1);
            curr_neighbour.add_door(new_door);
            new_incomplete_room.add_door(new_door);
        }
        this.remove_all_doors(p_room);
        p_room.remove_from_tree(this.autoroute_search_tree);
        if (this.complete_expansion_rooms != null) {
            this.complete_expansion_rooms.remove(p_room);
        } else {
            FRLogger.warn("AutorouteEngine.remove_complete_expansion_room: this.complete_expansion_rooms is null");
        }
        this.drill_page_array.invalidate(room_shape);
    }

    public Collection<CompleteFreeSpaceExpansionRoom> complete_expansion_room(IncompleteFreeSpaceExpansionRoom p_room) {
        try {
            LinkedList<CompleteFreeSpaceExpansionRoom> result = new LinkedList<CompleteFreeSpaceExpansionRoom>();
            TileShape from_door_shape = null;
            CompleteFreeSpaceExpansionRoom ignore_object = null;
            List<ExpansionDoor> room_doors = p_room.get_doors();
            for (ExpansionDoor curr_door : room_doors) {
                ExpansionRoom other_room = curr_door.other_room(p_room);
                if (!(other_room instanceof CompleteFreeSpaceExpansionRoom) || curr_door.dimension != 2) continue;
                from_door_shape = curr_door.get_shape();
                ignore_object = (CompleteFreeSpaceExpansionRoom)other_room;
                break;
            }
            Collection<IncompleteFreeSpaceExpansionRoom> completed_shapes = this.autoroute_search_tree.complete_shape(p_room, this.net_no, ignore_object, from_door_shape);
            this.remove_incomplete_expansion_room(p_room);
            boolean is_first_completed_room = true;
            for (IncompleteFreeSpaceExpansionRoom curr_incomplete_room : completed_shapes) {
                if (curr_incomplete_room.get_shape().dimension() != 2) continue;
                if (is_first_completed_room) {
                    is_first_completed_room = false;
                    CompleteFreeSpaceExpansionRoom completed_room = this.add_complete_room(curr_incomplete_room);
                    if (completed_room == null) continue;
                    result.add(completed_room);
                    continue;
                }
                Collection<IncompleteFreeSpaceExpansionRoom> curr_completed_shapes = this.autoroute_search_tree.complete_shape(curr_incomplete_room, this.net_no, ignore_object, from_door_shape);
                for (IncompleteFreeSpaceExpansionRoom tmp_room : curr_completed_shapes) {
                    CompleteFreeSpaceExpansionRoom completed_room = this.add_complete_room(tmp_room);
                    if (completed_room == null) continue;
                    result.add(completed_room);
                }
            }
            return result;
        }
        catch (Exception e) {
            FRLogger.error("AutorouteEngine.complete_expansion_room: ", e);
            return new LinkedList<CompleteFreeSpaceExpansionRoom>();
        }
    }

    private CompleteFreeSpaceExpansionRoom add_complete_room(IncompleteFreeSpaceExpansionRoom p_room) {
        CompleteFreeSpaceExpansionRoom completed_room = (CompleteFreeSpaceExpansionRoom)this.calculate_doors(p_room);
        if (completed_room == null || completed_room.get_shape().dimension() != 2) {
            return null;
        }
        if (this.complete_expansion_rooms == null) {
            this.complete_expansion_rooms = new LinkedList<CompleteFreeSpaceExpansionRoom>();
        }
        this.complete_expansion_rooms.add(completed_room);
        this.autoroute_search_tree.insert(completed_room);
        return completed_room;
    }

    private CompleteExpansionRoom calculate_doors(ExpansionRoom p_room) {
        CompleteExpansionRoom result = this.autoroute_search_tree instanceof ShapeSearchTree90Degree ? SortedOrthogonalRoomNeighbours.calculate(p_room, this) : (this.autoroute_search_tree instanceof ShapeSearchTree45Degree ? Sorted45DegreeRoomNeighbours.calculate(p_room, this) : SortedRoomNeighbours.calculate(p_room, this));
        return result;
    }

    public void complete_neighbour_rooms(CompleteExpansionRoom p_room) {
        if (p_room.get_doors() == null) {
            return;
        }
        Iterator<ExpansionDoor> it = p_room.get_doors().iterator();
        while (it.hasNext()) {
            ObstacleExpansionRoom obstacle_neighbour_room;
            ExpansionDoor curr_door = it.next();
            ExpansionRoom neighbour_room = curr_door.other_room((ExpansionRoom)p_room);
            if (neighbour_room == null) continue;
            if (neighbour_room instanceof IncompleteFreeSpaceExpansionRoom) {
                this.complete_expansion_room((IncompleteFreeSpaceExpansionRoom)neighbour_room);
                it = p_room.get_doors().iterator();
                continue;
            }
            if (!(neighbour_room instanceof ObstacleExpansionRoom) || (obstacle_neighbour_room = (ObstacleExpansionRoom)neighbour_room).all_doors_calculated()) continue;
            this.calculate_doors(obstacle_neighbour_room);
            obstacle_neighbour_room.set_doors_calculated(true);
        }
    }

    public void invalidate_drill_pages(TileShape p_shape) {
        this.drill_page_array.invalidate(p_shape);
    }

    void remove_all_doors(ExpansionRoom p_room) {
        for (ExpansionDoor curr_door : p_room.get_doors()) {
            ExpansionRoom other_room = curr_door.other_room(p_room);
            if (other_room == null) continue;
            other_room.remove_door(curr_door);
            if (!(other_room instanceof IncompleteFreeSpaceExpansionRoom)) continue;
            this.remove_incomplete_expansion_room((IncompleteFreeSpaceExpansionRoom)other_room);
        }
        p_room.clear_doors();
    }

    Set<CompleteFreeSpaceExpansionRoom> get_rooms_with_target_items(Set<Item> p_items) {
        TreeSet<CompleteFreeSpaceExpansionRoom> result = new TreeSet<CompleteFreeSpaceExpansionRoom>();
        if (this.complete_expansion_rooms != null) {
            for (CompleteFreeSpaceExpansionRoom curr_room : this.complete_expansion_rooms) {
                Collection<TargetItemExpansionDoor> target_door_list = curr_room.get_target_doors();
                for (TargetItemExpansionDoor curr_target_door : target_door_list) {
                    Item curr_target_item = curr_target_door.item;
                    if (!p_items.contains(curr_target_item)) continue;
                    result.add(curr_room);
                }
            }
        }
        return result;
    }

    public boolean validate() {
        if (this.complete_expansion_rooms == null) {
            return true;
        }
        boolean result = true;
        for (CompleteFreeSpaceExpansionRoom curr_room : this.complete_expansion_rooms) {
            if (curr_room.validate(this)) continue;
            result = false;
        }
        return result;
    }

    private void reset_all_doors() {
        if (this.complete_expansion_rooms != null) {
            for (ExpansionRoom expansionRoom : this.complete_expansion_rooms) {
                expansionRoom.reset_doors();
            }
        }
        Collection<Item> item_list = this.board.get_items();
        for (Item curr_item : item_list) {
            ItemAutorouteInfo curr_autoroute_info = curr_item.get_autoroute_info_pur();
            if (curr_autoroute_info == null) continue;
            curr_autoroute_info.reset_doors();
            curr_autoroute_info.set_precalculated_connection(null);
        }
        this.drill_page_array.reset();
    }

    protected int generate_room_id_no() {
        return ++this.expansion_room_instance_count;
    }

    public static enum AutorouteResult {
        ALREADY_CONNECTED,
        ROUTED,
        NOT_ROUTED,
        INSERT_ERROR;

    }
}

