/*
 * This file is part of the TrinityCore Project. See AUTHORS file for Copyright information
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
Name: Boss_the_ravenian
%Complete: 100
Comment:
Category: Scholomance
*/

#include "scholomance.h"
#include "ScriptMgr.h"
#include "ScriptedCreature.h"

enum Spells
{
    SPELL_TRAMPLE                   = 15550,
    SPELL_CLEAVE                    = 20691,
    SPELL_SUNDERINCLEAVE            = 25174,
    SPELL_KNOCKAWAY                 = 10101
};

enum Events
{
    EVENT_TRAMPLE                   = 1,
    EVENT_CLEAVE                    = 2,
    EVENT_SUNDERINCLEAVE            = 3,
    EVENT_KNOCKAWAY                 = 4
};

class boss_the_ravenian : public CreatureScript
{
    public: boss_the_ravenian() : CreatureScript("boss_the_ravenian") { }

        struct boss_theravenianAI : public BossAI
        {
            boss_theravenianAI(Creature* creature) : BossAI(creature, DATA_THERAVENIAN) { }

            void JustEngagedWith(Unit* who) override
            {
                BossAI::JustEngagedWith(who);
                events.ScheduleEvent(EVENT_TRAMPLE, 24s);
                events.ScheduleEvent(EVENT_CLEAVE, 15s);
                events.ScheduleEvent(EVENT_SUNDERINCLEAVE, 40s);
                events.ScheduleEvent(EVENT_KNOCKAWAY, 32s);
            }

            void UpdateAI(uint32 diff) override
            {
                if (!UpdateVictim())
                    return;

                events.Update(diff);

                if (me->HasUnitState(UNIT_STATE_CASTING))
                    return;

                while (uint32 eventId = events.ExecuteEvent())
                {
                    switch (eventId)
                    {
                        case EVENT_TRAMPLE:
                            DoCastVictim(SPELL_TRAMPLE, true);
                            events.ScheduleEvent(EVENT_TRAMPLE, 10s);
                            break;
                        case EVENT_CLEAVE:
                            DoCastVictim(SPELL_CLEAVE, true);
                            events.ScheduleEvent(EVENT_CLEAVE, 7s);
                            break;
                        case EVENT_SUNDERINCLEAVE:
                            DoCastVictim(SPELL_SUNDERINCLEAVE, true);
                            events.ScheduleEvent(EVENT_SUNDERINCLEAVE, 20s);
                            break;
                        case EVENT_KNOCKAWAY:
                            DoCastVictim(SPELL_KNOCKAWAY, true);
                            events.ScheduleEvent(EVENT_KNOCKAWAY, 12s);
                            break;
                        default:
                            break;
                    }

                    if (me->HasUnitState(UNIT_STATE_CASTING))
                        return;
                }

                DoMeleeAttackIfReady();
            }
        };

        CreatureAI* GetAI(Creature* creature) const override
        {
            return GetScholomanceAI<boss_theravenianAI>(creature);
        }
};

void AddSC_boss_theravenian()
{
    new boss_the_ravenian();
}
