-- Adds pathing for Lieutenant Valorcall and his guards
-- Path is between Stromgarde Keep, Arathi and Refuge Point, Arathi (and back)
-- NPCs are always spawned (unless killed) since there was no confirmation otherwise
-- 
-- NOTES:
--   * Valorcall is for Horde quest "Sigil of Arathor" (http://www.wowhead.com/quest=26032)
--   * It is proper that Valorcall will occasionally fight with the Forsaken Courier when their patrols cross.
--     Adjusted respawn allows for players to complete related quests.
--   * Could not confirm if NPC is only spawned when a player accepts the quest or is always spawned. Will require
--     c++ script if "quest accept" causes spawn / pathing.
--   * Could not confirm if NPC despawns once destination is reached or returns to spawn.

-- Lieutenant Valorcall
SET @npcLeaderId=14572;

-- Stromgarde Cavalryman
SET @npcFollowerId_1=14574;
SET @npcFollowerId_2=14575;
SET @wpPathId=(@npcLeaderId * 10);

-- Fix spawn info in Arathi Highlands
-- NOTE: Changed respawn to 1 minute because Valorcall is a quest NPC that can enter combat with (killed by) 
--       Forsaken Courier (another quest NPC) when their paths cross (which happens occasionally). Also, quest
--       research turned up comments that indicated these NPCs have a fast respawn.

DELETE FROM `creature` WHERE `guid` IN (@npcLeaderId,@npcFollowerId_1,@npcFollowerId_2);

INSERT INTO `creature` (`guid`, `id`, `map`, `zoneId`, `areaId`, `spawnMask`, `phaseMask`, `modelid`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `spawndist`, `currentwaypoint`, `curhealth`, `curmana`, `MovementType`, `npcflag`, `unit_flags`, `dynamicflags`, `VerifiedBuild`) VALUES 
(@npcLeaderId,2612,0,0,0,1,1,4141,1,-1528.313843,-1843.296265,67.789253,1.530442,400,0,1,1135,1779,2,0,0,0,0),
(@npcFollowerId_1,2738,0,0,0,1,1,4145,1,-1525.899780,-1845.876465,67.764687,1.530442,400,0,0,958,0,0,0,0,0,0),
(@npcFollowerId_2,2738,0,0,0,1,1,4145,1,-1531.197144,-1845.848755,67.875923,1.530442,400,0,0,958,0,0,0,0,0,0);

-- Delete existing waypoints (if any)
DELETE FROM `waypoint_data` WHERE `id`=@wpPathId;

-- Add new waypoints
-- NOTE: It is unclear if the NPC should despawn when reaching the end of the path. For now, just have it pause
--       at end before starting the path back.

INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(@wpPathId,1,-1528.31,-1843.30,67.79,1.530442,60000,0,0,100,0), -- 1 minute delay before starting
(@wpPathId,2,-1528.23,-1824.05,68.34,0,0,0,0,100,0),
(@wpPathId,3,-1528.32,-1820.46,68.9602,0,0,0,0,100,0),
(@wpPathId,4,-1528.37,-1818.28,69.5115,0,0,0,0,100,0),
(@wpPathId,5,-1528.64,-1808.76,71.3902,0,0,0,0,100,0),
(@wpPathId,6,-1528.77,-1800.37,71.2294,0,0,0,0,100,0),
(@wpPathId,7,-1528.82,-1795.04,70.1311,0,0,0,0,100,0),
(@wpPathId,8,-1528.84,-1793.37,69.5099,0,0,0,0,100,0),
(@wpPathId,9,-1528.87,-1790.61,68.9584,0,0,0,0,100,0),
(@wpPathId,10,-1528.82,-1785.05,68.3404,0,0,0,0,100,0),
(@wpPathId,11,-1527.51,-1762.21,67.0403,0,0,0,0,100,0),
(@wpPathId,12,-1529.35,-1746.33,66.8509,0,0,0,0,100,0),
(@wpPathId,13,-1529.5,-1732.3,66.2708,0,0,0,0,100,0),
(@wpPathId,14,-1539.93,-1714.01,66.363,0,0,0,0,100,0),
(@wpPathId,15,-1555.47,-1702.87,66.1763,0,0,0,0,100,0),
(@wpPathId,16,-1570.19,-1696.83,66.2239,0,0,0,0,100,0),
(@wpPathId,17,-1576.23,-1695.24,65.9776,0,0,0,0,100,0),
(@wpPathId,18,-1581.84,-1696.44,66.1376,0,0,0,0,100,0),
(@wpPathId,19,-1584.78,-1700.91,66.5301,0,0,0,0,100,0),
(@wpPathId,20,-1586.19,-1710.78,66.9607,0,0,0,0,100,0),
(@wpPathId,21,-1586.08,-1728.19,67.4567,0,0,0,0,100,0),
(@wpPathId,22,-1582.99,-1743.81,66.8545,0,0,0,0,100,0),
(@wpPathId,23,-1577.8,-1763.7,67.0782,0,0,0,0,100,0),
(@wpPathId,24,-1576.49,-1777.64,67.2815,0,0,0,0,100,0),
(@wpPathId,25,-1574.01,-1787.45,67.1901,0,0,0,0,100,0),
(@wpPathId,26,-1565.38,-1798.76,67.5678,0,0,0,0,100,0),
(@wpPathId,27,-1557.03,-1803.77,67.5158,0,0,0,0,100,0),
(@wpPathId,28,-1540,-1805.78,66.432,0,0,0,0,100,0),
(@wpPathId,29,-1513.43,-1805.73,66.1469,0,0,0,0,100,0),
(@wpPathId,30,-1490.95,-1805.66,68.0658,0,0,0,0,100,0),
(@wpPathId,31,-1466.56,-1803.87,67.7702,0,0,0,0,100,0),
(@wpPathId,32,-1452.87,-1800.94,65.4412,0,0,0,0,100,0),
(@wpPathId,33,-1438.86,-1799.91,61.945,0,0,0,0,100,0),
(@wpPathId,34,-1425.38,-1803.61,60.9587,0,0,0,0,100,0),
(@wpPathId,35,-1395.89,-1814.67,59.1394,0,0,0,0,100,0),
(@wpPathId,36,-1363.65,-1828.28,60.0694,0,0,0,0,100,0),
(@wpPathId,37,-1337.27,-1839.82,62.1984,0,0,0,0,100,0),
(@wpPathId,38,-1330.7,-1845.84,62.5435,0,0,0,0,100,0),
(@wpPathId,39,-1328.27,-1851.3,62.5249,0,0,0,0,100,0),
(@wpPathId,40,-1329.52,-1861.33,62.0214,0,0,0,0,100,0),
(@wpPathId,41,-1342.83,-1896.34,59.2707,0,0,0,0,100,0),
(@wpPathId,42,-1358.08,-1935.47,58.4276,0,0,0,0,100,0),
(@wpPathId,43,-1375.19,-1977.63,58.5289,0,0,0,0,100,0),
(@wpPathId,44,-1381.06,-2026.16,60.5442,0,0,0,0,100,0),
(@wpPathId,45,-1383.41,-2071.59,62.5124,0,0,0,0,100,0),
(@wpPathId,46,-1386.02,-2110,64.2494,0,0,0,0,100,0),
(@wpPathId,47,-1393.31,-2158.42,64.1111,0,0,0,0,100,0),
(@wpPathId,48,-1404.24,-2206.13,63.8535,0,0,0,0,100,0),
(@wpPathId,49,-1417.1,-2243.68,63.7514,0,0,0,0,100,0),
(@wpPathId,50,-1420.49,-2249.98,63.6904,0,0,0,0,100,0),
(@wpPathId,51,-1430.49,-2263.3,63.329,0,0,0,0,100,0),
(@wpPathId,52,-1441.13,-2277.2,62.7836,0,0,0,0,100,0),
(@wpPathId,53,-1446.84,-2287.53,61.9325,0,0,0,0,100,0),
(@wpPathId,54,-1449.19,-2299.55,61.8796,0,0,0,0,100,0),
(@wpPathId,55,-1449.73,-2327.53,61.7191,0,0,0,0,100,0),
(@wpPathId,56,-1450.03,-2355.53,61.5528,0,0,0,0,100,0),
(@wpPathId,57,-1450.15,-2380.03,61.4055,0,0,0,0,100,0),
(@wpPathId,58,-1450.49,-2397.53,61.0555,0,0,0,0,100,0),
(@wpPathId,59,-1453.92,-2410.52,60.03,0,0,0,0,100,0),
(@wpPathId,60,-1464.35,-2426.89,57.8205,0,0,0,0,100,0),
(@wpPathId,61,-1462.44,-2436.38,58.0342,0,0,0,0,100,0),
(@wpPathId,62,-1453.73,-2438.5,58.342,0,0,0,0,100,0),
(@wpPathId,63,-1440.72,-2440.2,58.9664,0,0,0,0,100,0),
(@wpPathId,64,-1424.83,-2453.5,59.0382,0,0,0,0,100,0),
(@wpPathId,65,-1412.62,-2462.65,57.2066,0,0,0,0,100,0),
(@wpPathId,66,-1396.91,-2462.16,57.0177,0,0,0,0,100,0),
(@wpPathId,67,-1380.78,-2455.37,55.0267,0,0,0,0,100,0),
(@wpPathId,68,-1364.89,-2450.51,52.0455,0,0,0,0,100,0),
(@wpPathId,69,-1351.11,-2448.04,49.9138,0,0,0,0,100,0),
(@wpPathId,70,-1336.2,-2448.68,46.4684,0,0,0,0,100,0),
(@wpPathId,71,-1319.9,-2455.01,43.1772,0,0,0,0,100,0),
(@wpPathId,72,-1304.21,-2462.75,39.1337,0,0,0,0,100,0),
(@wpPathId,73,-1289.01,-2471.38,33.4891,0,0,0,0,100,0),
(@wpPathId,74,-1275.46,-2482.79,26.7595,0,0,0,0,100,0),
(@wpPathId,75,-1267.01,-2493.63,22.4559,0,0,0,0,100,0),
(@wpPathId,76,-1254.69,-2512.44,20.5413,0,0,0,0,100,0),
(@wpPathId,77,-1250.21,-2521.37,20.4269,0,0,0,0,100,0),
(@wpPathId,78,-1246.19,-2529.78,20.6058,0,0,0,0,100,0),
(@wpPathId,79,-1242.05,-2535.15,21.0179,0,0,0,0,100,0),
(@wpPathId,80,-1242.99,-2526.84,20.9146,0,0,0,0,100,0),
(@wpPathId,81,-1250.83,-2520.96,20.426,0,60000,0,0,100,0), -- destination reached, 1 minute delay before pathing back
(@wpPathId,82,-1254.85,-2513.19,20.5112,0,0,0,0,100,0),
(@wpPathId,83,-1267.24,-2493.93,22.3988,0,0,0,0,100,0),
(@wpPathId,84,-1273.85,-2485.78,25.5707,0,0,0,0,100,0),
(@wpPathId,85,-1289.24,-2471.59,33.4718,0,0,0,0,100,0),
(@wpPathId,86,-1303.98,-2462.99,39.0339,0,0,0,0,100,0),
(@wpPathId,87,-1316.64,-2457,42.604,0,0,0,0,100,0),
(@wpPathId,88,-1335.67,-2449.4,46.2431,0,0,0,0,100,0),
(@wpPathId,89,-1349.51,-2448.47,49.503,0,0,0,0,100,0),
(@wpPathId,90,-1363.26,-2451.05,51.8257,0,0,0,0,100,0),
(@wpPathId,91,-1379.15,-2455.53,54.7104,0,0,0,0,100,0),
(@wpPathId,92,-1395.58,-2461.5,57.1067,0,0,0,0,100,0),
(@wpPathId,93,-1411.2,-2463.61,56.9774,0,0,0,0,100,0),
(@wpPathId,94,-1424.18,-2454.31,59.0152,0,0,0,0,100,0),
(@wpPathId,95,-1440.89,-2442.08,58.7537,0,0,0,0,100,0),
(@wpPathId,96,-1452.92,-2439.49,58.3243,0,0,0,0,100,0),
(@wpPathId,97,-1461.72,-2436.45,58.0823,0,0,0,0,100,0),
(@wpPathId,98,-1463.37,-2427.9,57.8549,0,0,0,0,100,0),
(@wpPathId,99,-1454.66,-2411.75,59.8753,0,0,0,0,100,0),
(@wpPathId,100,-1451.1,-2399.07,60.9648,0,0,0,0,100,0),
(@wpPathId,101,-1450.14,-2381.61,61.3911,0,0,0,0,100,0),
(@wpPathId,102,-1450.12,-2357.11,61.5426,0,0,0,0,100,0),
(@wpPathId,103,-1449.95,-2329.11,61.7066,0,0,0,0,100,0),
(@wpPathId,104,-1449.43,-2301.13,61.84,0,0,0,0,100,0),
(@wpPathId,105,-1446.58,-2287.66,61.9711,0,0,0,0,100,0),
(@wpPathId,106,-1442.44,-2279.13,62.5159,0,0,0,0,100,0),
(@wpPathId,107,-1431.93,-2265.15,63.3205,0,0,0,0,100,0),
(@wpPathId,108,-1421.36,-2251.22,63.6684,0,0,0,0,100,0),
(@wpPathId,109,-1418.07,-2245.04,63.7351,0,0,0,0,100,0),
(@wpPathId,110,-1405.35,-2208.74,63.8461,0,0,0,0,100,0),
(@wpPathId,111,-1394.01,-2161.12,64.1057,0,0,0,0,100,0),
(@wpPathId,112,-1386.65,-2112.7,64.4159,0,0,0,0,100,0),
(@wpPathId,113,-1383.82,-2074.31,62.6099,0,0,0,0,100,0),
(@wpPathId,114,-1381.54,-2028.88,60.6584,0,0,0,0,100,0),
(@wpPathId,115,-1375.91,-1979.41,58.5366,0,0,0,0,100,0),
(@wpPathId,116,-1358.95,-1937.19,58.4249,0,0,0,0,100,0),
(@wpPathId,117,-1343.72,-1898.05,59.126,0,0,0,0,100,0),
(@wpPathId,118,-1329.89,-1863.08,61.9069,0,0,0,0,100,0),
(@wpPathId,119,-1328.35,-1850.86,62.5391,0,0,0,0,100,0),
(@wpPathId,120,-1330.65,-1846.29,62.5257,0,0,0,0,100,0),
(@wpPathId,121,-1335.96,-1841.73,62.249,0,0,0,0,100,0),
(@wpPathId,122,-1361.59,-1829.16,60.2512,0,0,0,0,100,0),
(@wpPathId,123,-1393.84,-1815.58,59.0036,0,0,0,0,100,0),
(@wpPathId,124,-1423.47,-1804.92,60.7771,0,0,0,0,100,0),
(@wpPathId,125,-1438.32,-1800.12,61.8788,0,0,0,0,100,0),
(@wpPathId,126,-1450.61,-1800.69,64.7219,0,0,0,0,100,0),
(@wpPathId,127,-1464.33,-1803.5,67.6348,0,0,0,0,100,0),
(@wpPathId,128,-1488.18,-1805.87,68.074,0,0,0,0,100,0),
(@wpPathId,129,-1512.68,-1805.73,66.2104,0,0,0,0,100,0),
(@wpPathId,130,-1537.17,-1805.95,66.1776,0,0,0,0,100,0),
(@wpPathId,131,-1557.65,-1804.11,67.4839,0,0,0,0,100,0),
(@wpPathId,132,-1565.61,-1798.65,67.5617,0,0,0,0,100,0),
(@wpPathId,133,-1574.15,-1787.07,67.1787,0,0,0,0,100,0),
(@wpPathId,134,-1576.5,-1778.67,67.2749,0,0,0,0,100,0),
(@wpPathId,135,-1578.05,-1765.2,67.1097,0,0,0,0,100,0),
(@wpPathId,136,-1582.3,-1746.61,66.6746,0,0,0,0,100,0),
(@wpPathId,137,-1585.78,-1729.49,67.4793,0,0,0,0,100,0),
(@wpPathId,138,-1586.16,-1712.03,67.0329,0,0,0,0,100,0),
(@wpPathId,139,-1584.72,-1701.41,66.5389,0,0,0,0,100,0),
(@wpPathId,140,-1581.69,-1696.92,66.1604,0,0,0,0,100,0),
(@wpPathId,141,-1576.71,-1695.36,65.9892,0,0,0,0,100,0),
(@wpPathId,142,-1570.6,-1696.58,66.1985,0,0,0,0,100,0),
(@wpPathId,143,-1555.01,-1703.09,66.1586,0,0,0,0,100,0),
(@wpPathId,144,-1540.2,-1714.01,66.3447,0,0,0,0,100,0),
(@wpPathId,145,-1529.35,-1731.15,66.2182,0,0,0,0,100,0),
(@wpPathId,146,-1529.12,-1745.12,66.8033,0,0,0,0,100,0),
(@wpPathId,147,-1527.21,-1763.24,67.0823,0,0,0,0,100,0),
(@wpPathId,148,-1528.8,-1786.19,68.3406,0,0,0,0,100,0),
(@wpPathId,149,-1528.78,-1791.07,68.9602,0,0,0,0,100,0),
(@wpPathId,150,-1528.77,-1793.2,69.5115,0,0,0,0,100,0),
(@wpPathId,151,-1528.76,-1795.29,70.1611,0,0,0,0,100,0),
(@wpPathId,152,-1528.74,-1800.29,71.2228,0,0,0,0,100,0),
(@wpPathId,153,-1528.67,-1807.79,71.4654,0,0,0,0,100,0),
(@wpPathId,154,-1528.38,-1819.6,68.9567,0,0,0,0,100,0),
(@wpPathId,155,-1528.32,-1822.06,68.3404,0,0,0,0,100,0),
(@wpPathId,156,-1528.25,-1824.82,68.3404,0,0,0,0,100,0),
(@wpPathId,157,-1528.2,-1828.96,68.0658,0,0,0,0,100,0),
(@wpPathId,158,-1533.15,-1841.45,68.09,0,0,0,0,100,0),
(@wpPathId,159,-1528.19,-1853.83,67.62,0,0,0,0,100,0),
(@wpPathId,160,-1528.31,-1843.30,67.79,1.530442,0,0,0,100,0); -- ends at same coords as WP 1

-- Assign path and formation info
DELETE FROM `creature_formations` WHERE `leaderGUID`=@npcLeaderId;
INSERT INTO creature_formations  (`leaderGUID`,`memberGUID`,`dist`,`angle`,`groupAI`,`point_1`,`point_2`) VALUES 
(@npcLeaderId,@npcLeaderId,0,0,2,0,0),
(@npcLeaderId,@npcFollowerId_1,3,45,2,0,0), -- slightly behind and to the right
(@npcLeaderId,@npcFollowerId_2,3,315,2,0,0); -- slightly behind and to the left

DELETE FROM `creature_addon` WHERE `guid`=@npcLeaderId;
INSERT INTO `creature_addon` (`guid`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `auras`) VALUES
(@npcLeaderId,@wpPathId,229,0,4097,0,NULL);
