--
SET @CGUID := 147175; -- 22

/*
Videos: https://www.youtube.com/watch?v=cuQCL7z9fMc https://www.youtube.com/watch?v=VBiapet3a9g
https://www.youtube.com/watch?v=i8BJ2mlnP5g

Not used spells:
34369 Drek'Thar Root
34371 Despawn Drek'Thar
34377 Thrall's Memories

Not used creatures:
19590 Thrall Event Generator (see TO-DO)
19597 Thrall's Hero Music (see TO-DO)
18228 Garadar Event Controller (Farseer) (used as spell target only, however he should handle more things probably)

Missing features:
Search for TO-DO

To test whole event:

 Grid should be loaded here or event will not start by turning quest at Garadar, so first load grid, then turn in quest at Garadar or at
 .go x -1372.66 6329.23 43.4236 5.634656
 .npc add tem 18141
 .q a 10212

To test mini scene with Grom Hellscream and Mannoroth (https://www.youtube.com/watch?v=b-YMR6l7h4g):

 .go x -1422.789  7280.642  25.68812  5.358161
 .npc add tem 19647

 .go x -1425.996  7276.042  25.80751  5.88176
 .npc add tem 18076

 .go x -1415.731  7271.584  25.49314  2.408554
 .npc add tem 19647

*/

DELETE FROM `conditions` WHERE `SourceTypeOrReferenceId` = 13 AND `SourceEntry` IN (34378,34395);
INSERT INTO `conditions` (`SourceTypeOrReferenceId`,`SourceGroup`,`SourceEntry`,`SourceId`,`ElseGroup`,`ConditionTypeOrReference`,`ConditionTarget`,`ConditionValue1`,`ConditionValue2`,`ConditionValue3`,`NegativeCondition`,`ErrorType`,`ErrorTextId`,`ScriptName`,`Comment`) VALUES
(13,1,34378,0,0,31,0,3,18228,0,0,0,0,"","Group 0: Spell 'Thrall Calls Thunder' (Effect 0) targets creature 'Garadar Event Controller (Farseer)'"),
(13,2,34395,0,0,31,0,3,18076,0,0,0,0,"","Group 0: Spell 'Mannoroth Dies' (Effect 1) targets creature 'Grom Hellscream'");

-- Remove invisible model
UPDATE `creature_model_info` SET `DisplayID_Other_Gender` = 0 WHERE `DisplayID` = 19015; -- Thrall

-- TO-DO: More things may be missing here
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.38571428571, `unit_flags` = 320, `flags_extra` = `flags_extra` &~ 1 WHERE `entry` = 19604; -- Drek'thar
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.38571428571, `unit_flags` = 320 WHERE `entry` = 19556; -- Thrall
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.38571428571, `unit_flags` = 320 WHERE `entry` = 19592; -- Korkron Warrior
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.38571428571, `unit_flags` = 320 WHERE `entry` = 19594; -- Korkron Honor Guard
UPDATE `creature_template` SET `speed_walk` = 1, `unit_flags` = 33555264 WHERE `entry` = 19647; -- Mini Thrall
UPDATE `creature_template` SET `unit_flags` = 33555200 WHERE `entry` = 18075; -- Mannoroth
UPDATE `creature_template` SET `unit_flags` = 33555200 WHERE `entry` = 18076; -- Grom Hellscream
UPDATE `creature_template` SET `unit_flags` = 33554752 WHERE `entry` = 19597; -- Thrall's Hero Music
UPDATE `creature_template` SET `speed_walk` = 1 WHERE `entry` = 18063; -- Garrosh

DELETE FROM `creature_template_addon` WHERE `entry` IN (19647,18076,19556,19604);
INSERT INTO `creature_template_addon` (`entry`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `visibilityDistanceType`, `auras`) VALUES
(19647,0,0,0,1,375,0,""), -- Mini Thrall
(18076,0,0,0,1,375,0,""), -- Grom Hellscream
(19556,0,19014,0,0,0,0,""), -- Thrall
(19604,0,19040,0,1,0,0,""); -- Drek'thar

--
DELETE FROM `spawn_group_template` WHERE `groupId` BETWEEN 102 AND 104;
INSERT INTO `spawn_group_template` (`groupId`, `groupName`, `groupFlags`) VALUES
(102,"Nagrand - Hero of the Mag'har - Drek'Thar",4),
(103,"Nagrand - Hero of the Mag'har - Thrall",4),
(104,"Nagrand - Hero of the Mag'har - Kor'kron Warrior / Honor Guard",4);

DELETE FROM `spawn_group` WHERE `groupId` BETWEEN 102 AND 104 AND `spawnType` = 0;
INSERT INTO `spawn_group` (`groupId`, `spawnType`, `spawnId`) VALUES
(102,0,@CGUID+00),
(103,0,@CGUID+01),
(104,0,@CGUID+02),
(104,0,@CGUID+03),
(104,0,@CGUID+04),
(104,0,@CGUID+05),
(104,0,@CGUID+06),
(104,0,@CGUID+07),
(104,0,@CGUID+08),
(104,0,@CGUID+09),
(104,0,@CGUID+10),
(104,0,@CGUID+11),
(104,0,@CGUID+12),
(104,0,@CGUID+13),
(104,0,@CGUID+14),
(104,0,@CGUID+15),
(104,0,@CGUID+16),
(104,0,@CGUID+17),
(104,0,@CGUID+18),
(104,0,@CGUID+19),
(104,0,@CGUID+20),
(104,0,@CGUID+21);

DELETE FROM `creature` WHERE `guid` BETWEEN @CGUID+00 AND @CGUID+21 AND `id` IN (19604,19556,19594,19592);
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `modelid`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(@CGUID+00, 19604, 530, 1, 1, 0, 0, -1352.526, 6329.687, 43.60197, 2.426008, 300, 0, 0, 0),

(@CGUID+01, 19556, 530, 1, 1, 0, 1, -1349.914, 6332.778, 43.74491, 2.426008, 300, 0, 0, 0),

(@CGUID+02, 19594, 530, 1, 1, 0, 0, -1335.208, 6313.925, 45.51422, 2.391101, 300, 0, 2, 0),
(@CGUID+03, 19594, 530, 1, 1, 0, 0, -1346.921, 6327.715, 43.98703, 2.373648, 300, 0, 2, 0),

(@CGUID+04, 19592, 530, 1, 1, 0, 0, -1333.763, 6317.533, 44.76424, 2.356194, 300, 0, 2, 0),
(@CGUID+05, 19592, 530, 1, 1, 0, 0, -1329.355, 6321.17, 44.81275, 2.478368, 300, 0, 2, 0),
(@CGUID+06, 19592, 530, 1, 1, 0, 0, -1325.298, 6324.27, 43.78838, 2.600541, 300, 0, 2, 0),
(@CGUID+07, 19592, 530, 1, 1, 0, 0, -1321.754, 6328.901, 41.62631, 2.513274, 300, 0, 2, 0),
(@CGUID+08, 19592, 530, 1, 1, 0, 0, -1336.72, 6309.458, 46.23232, 2.373648, 300, 0, 2, 0),
(@CGUID+09, 19592, 530, 1, 1, 0, 0, -1339.819, 6305.84, 45.90306, 2.373648, 300, 0, 2, 0),
(@CGUID+10, 19592, 530, 1, 1, 0, 0, -1341.407, 6302.393, 45.42799, 2.356194, 300, 0, 2, 0),
(@CGUID+11, 19592, 530, 1, 1, 0, 0, -1313.597, 6337.389, 37.4875, 2.373648, 300, 0, 2, 0),
(@CGUID+12, 19592, 530, 1, 1, 0, 0, -1317.676, 6332.954, 39.39396, 2.565634, 300, 0, 2, 0),
(@CGUID+13, 19592, 530, 1, 1, 0, 0, -1346.398, 6323.436, 44.13105, 2.303835, 300, 0, 2, 0),
(@CGUID+14, 19592, 530, 1, 1, 0, 0, -1343.658, 6326.059, 44.25003, 2.513274, 300, 0, 2, 0),
(@CGUID+15, 19592, 530, 1, 1, 0, 0, -1341.659, 6328.948, 44.39948, 2.408554, 300, 0, 2, 0),
(@CGUID+16, 19592, 530, 1, 1, 0, 0, -1342.175, 6320.706, 44.54397, 2.600541, 300, 0, 2, 0),
(@CGUID+17, 19592, 530, 1, 1, 0, 0, -1339.956, 6323.307, 44.4758, 2.251475, 300, 0, 2, 0),
(@CGUID+18, 19592, 530, 1, 1, 0, 0, -1337.861, 6326.29, 44.63207, 2.530727, 300, 0, 2, 0),
(@CGUID+19, 19592, 530, 1, 1, 0, 0, -1338.36, 6318.153, 45.01073, 2.600541, 300, 0, 2, 0),
(@CGUID+20, 19592, 530, 1, 1, 0, 0, -1336.097, 6321.046, 44.63943, 2.565634, 300, 0, 2, 0),
(@CGUID+21, 19592, 530, 1, 1, 0, 0, -1333.939, 6323.755, 44.85339, 2.513274, 300, 0, 2, 0);

-- Greatmother Geyah SAI
DELETE FROM `smart_scripts` WHERE `entryorguid` = 18141 AND `source_type` = 0 AND `id` BETWEEN 3 AND 5;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
-- In original script author summoned here Thrall Event Generator and that NPC spawned other creatures
-- Thing is Thrall Event Generator looks more like permanent spawn because in sniffs he's spawned even if event is not active
-- Looks more like a way to prevent double summon
(18141,0,3,4,20,0,100,0,10212,0,0,0,0,131,102,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Greatmother Geyah - On Quest 'Hero of the Mag'har' Finished - Spawn SpawnGroup 102"),
(18141,0,4,5,61,0,100,0,0,0,0,0,0,131,103,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Greatmother Geyah - On Link - Spawn SpawnGroup 103"),
(18141,0,5,0,61,0,100,0,0,0,0,0,0,131,104,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Greatmother Geyah - On Link - Spawn SpawnGroup 104");

-- TO-DO: Instead we should not spawn all 3 spawn groups if any of them are spawned
-- Currently last active creature is Drek'Thar, he will despawn after Thrall while originally Thrall should sit near Greatmother for 6 hours
-- And if Thrall is still spawned, event should not be triggered
-- However probably we will never let him be active for 6 hours
DELETE FROM `conditions` WHERE `SourceTypeOrReferenceId` = 22 AND `SourceEntry` = 18141 AND `SourceId` = 0;
INSERT INTO `conditions` (`SourceTypeOrReferenceId`,`SourceGroup`,`SourceEntry`,`SourceId`,`ElseGroup`,`ConditionTypeOrReference`,`ConditionTarget`,`ConditionValue1`,`ConditionValue2`,`ConditionValue3`,`NegativeCondition`,`ErrorType`,`ErrorTextId`,`ScriptName`,`Comment`) VALUES
(22,4,18141,0,0,29,0,19604,300,0,1,0,0,"","Group 0: Execute SAI (Action 3) if alive creature 'Drek'Thar' is not within 300 yards");

-- Thrall SAI
SET @ID := 19556;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
DELETE FROM `smart_scripts` WHERE `entryorguid` BETWEEN @ID*100+0 AND @ID*100+9 AND `source_type` = 9;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,1,37,0,100,0,0,0,0,0,0,48,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On AI Initialize - Set Active"),

(@ID,0,1,0,61,0,100,0,0,0,0,0,0,80,@ID*100+0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Link - Run Script"),

-- Force Garadar Defender to perform actions
-- TO-DO: Personally I think it's not related to waypoints

-- "Garadar Wolf Riders should possibly stop and greet Thrall if they run into him inside Garadar. I've been unable to confirm or witness"
-- "this myself, and I'm not sure how that would be possible to implement anyways so it's left out for now."
-- I remember I've seen something like this but can't find screenshots or videos anymore
(@ID,0,2,0,40,0,100,0,28,0,0,0,0,80,1848900,0,0,0,0,0,19,18489,15,0,0,0,0,0,0,"Thrall - On Waypoint 28 Reached - Run Script (Garadar Defender)"),
(@ID,0,3,0,40,0,100,0,31,0,0,0,0,80,1848900,0,0,0,0,0,19,18489,15,0,0,0,0,0,0,"Thrall - On Waypoint 31 Reached - Run Script (Garadar Defender)"),
(@ID,0,4,0,40,0,100,0,34,0,0,0,0,80,1848900,0,0,0,0,0,19,18489,15,0,0,0,0,0,0,"Thrall - On Waypoint 34 Reached - Run Script (Garadar Defender)"),
(@ID,0,5,0,40,0,100,0,36,0,0,0,0,80,1848900,0,0,0,0,0,19,18489,15,0,0,0,0,0,0,"Thrall - On Waypoint 36 Reached - Run Script (Garadar Defender)"),
(@ID,0,6,0,40,0,100,0,40,0,0,0,0,80,1848900,0,0,0,0,0,19,18489,15,0,0,0,0,0,0,"Thrall - On Waypoint 40 Reached - Run Script (Garadar Defender)"),
(@ID,0,7,0,40,0,100,0,48,0,0,0,0,80,1848900,0,0,0,0,0,19,18489,15,0,0,0,0,0,0,"Thrall - On Waypoint 48 Reached - Run Script (Garadar Defender)"),

(@ID,0,8,0,40,0,100,0,25,0,0,0,0,80,@ID*100+1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 25 Reached - Run Script"),
(@ID,0,9,0,40,0,100,0,47,0,0,0,0,80,@ID*100+2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 47 Reached - Run Script"),
(@ID,0,10,0,40,0,100,0,50,0,0,0,0,80,@ID*100+3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 50 Reached - Run Script"),
(@ID,0,11,0,40,0,100,0,63,0,0,0,0,80,@ID*100+4,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 63 Reached - Run Script"),
(@ID,0,12,0,40,0,100,0,65,0,0,0,0,80,@ID*100+5,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 65 Reached - Run Script"),
(@ID,0,13,0,40,0,100,0,74,0,0,0,0,80,@ID*100+6,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 74 Reached - Run Script"),
(@ID,0,14,0,40,0,100,0,80,0,0,0,0,80,@ID*100+7,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 80 Reached - Run Script"),
(@ID,0,15,0,40,0,100,0,91,0,0,0,0,80,@ID*100+9,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 91 Reached - Run Script"),
(@ID,0,16,0,38,0,100,0,0,1,0,0,0,80,@ID*100+8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Data Set 0 1 - Run Script"),

-- At spawn area
(@ID*100+0,9,0,0,0,0,100,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 0"),
-- TO-DO: "The music should change to id 6146 when the event starts and stay that way until Thrall reaches Garrosh."
-- "Most likely this should be triggered by the NPC named Thrall's Hero Music (19597)."
-- "However it is currently not possible to change the music zonewide, so for now Thrall is changing the music for those near him only."
-- https://github.com/cmangos/tbc-db/pull/63#issuecomment-284270385

-- Also since music plays 4 times, this means it will be interrupted by second action list
-- because otherwise we will be not able to trigger second action list at all since creature arrives before music stops playing
-- (before action list finish)
(@ID*100+0,9,1,0,0,0,100,0,1000,1000,0,0,0,4,6146,1,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Sound 6146"),
(@ID*100+0,9,2,0,0,0,100,0,6000,6000,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 1"),
(@ID*100+0,9,3,0,0,0,100,0,4000,4000,0,0,0,5,25,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 25"),
(@ID*100+0,9,4,0,0,0,100,0,6000,6000,0,0,0,45,0,1,0,0,0,0,19,19604,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 1 (Drek'Thar)"),
(@ID*100+0,9,5,0,0,0,100,0,8000,8000,0,0,0,53,1,19556,0,0,0,2,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Start Waypoint"),
(@ID*100+0,9,6,0,0,0,100,0,38000,38000,0,0,0,4,6146,1,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Sound 6146"),
(@ID*100+0,9,7,0,0,0,100,0,62000,62000,0,0,0,4,6146,1,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Sound 6146"),
(@ID*100+0,9,8,0,0,0,100,0,62000,62000,0,0,0,4,6146,1,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Sound 6146"),

-- At gates
(@ID*100+1,9,0,0,0,0,100,0,0,0,0,0,0,59,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Run Off"),
(@ID*100+1,9,1,0,0,0,100,0,1000,1000,0,0,0,43,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Dismount"),
-- Inform Drek'Thar to resume waypoint
-- TO-DO: It more looks like Drek'thar should form temp formation with Thrall here
(@ID*100+1,9,2,0,0,0,100,0,4000,4000,0,0,0,45,0,2,0,0,0,0,19,19604,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 2 (Drek'Thar)"),

-- Stop at bonfire and point at Garrosh
(@ID*100+2,9,0,0,0,0,100,0,0,0,0,0,0,59,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Run On"),
(@ID*100+2,9,1,0,0,0,100,0,2000,2000,0,0,0,66,0,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Orientation Closest Creature 'Garrosh'"),
(@ID*100+2,9,2,0,0,0,100,0,2000,2000,0,0,0,1,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 2"),
(@ID*100+2,9,3,0,0,0,100,0,3000,3000,0,0,0,5,5,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 5"),

-- First interaction with Garrosh
(@ID*100+3,9,0,0,0,0,100,0,1000,1000,0,0,0,66,0,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Orientation Closest Creature 'Garrosh'"),
(@ID*100+3,9,1,0,0,0,100,0,2000,2000,0,0,0,5,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 2"),
(@ID*100+3,9,2,0,0,0,100,0,0,0,0,0,0,45,0,1,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 1 (Garrosh)"),
(@ID*100+3,9,3,0,0,0,100,0,2000,2000,0,0,0,1,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 3"),
(@ID*100+3,9,4,0,0,0,100,0,4000,4000,0,0,0,5,5,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 5"),
(@ID*100+3,9,5,0,0,0,100,0,3000,3000,0,0,0,1,0,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 0 (Garrosh)"),
(@ID*100+3,9,6,0,0,0,100,0,2000,2000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+3,9,7,0,0,0,100,0,4000,4000,0,0,0,45,0,2,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 2 (Garrosh)"),
(@ID*100+3,9,8,0,0,0,100,0,1000,1000,0,0,0,1,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 1 (Garrosh)"),
(@ID*100+3,9,9,0,0,0,100,0,2000,2000,0,0,0,45,0,1,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 1 (Garrosh)"),
(@ID*100+3,9,10,0,0,0,100,0,2000,2000,0,0,0,1,4,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 4"),
(@ID*100+3,9,11,0,0,0,100,0,3000,3000,0,0,0,5,273,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 273"),
(@ID*100+3,9,12,0,0,0,100,0,0,0,0,0,0,59,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Run Off"),

-- Stop before reaching Greatmother
(@ID*100+4,9,0,0,0,0,100,0,2000,2000,0,0,0,66,0,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Set Orientation Closest Creature 'Greatmother Geyah'"),
(@ID*100+4,9,1,0,0,0,100,0,2000,2000,0,0,0,1,5,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 5"),
(@ID*100+4,9,2,0,0,0,100,0,1000,1000,0,0,0,1,0,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 0 (Greatmother Geyah)"),
(@ID*100+4,9,3,0,0,0,100,0,0,0,0,0,0,59,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Run On"),

-- First talk with Greatmother
(@ID*100+5,9,0,0,0,0,100,0,0,0,0,0,0,54,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Pause Waypoint"),
(@ID*100+5,9,1,0,0,0,100,0,1000,1000,0,0,0,66,0,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Set Orientation Closest Creature 'Greatmother Geyah'"),
(@ID*100+5,9,2,0,0,0,100,0,2000,2000,0,0,0,90,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Flag Standstate Sit Down"),
(@ID*100+5,9,3,0,0,0,100,0,3000,3000,0,0,0,1,1,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 1 (Greatmother Geyah)"),
(@ID*100+5,9,4,0,0,0,100,0,7000,7000,0,0,0,1,6,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 6"),
(@ID*100+5,9,5,0,0,0,100,0,3000,3000,0,0,0,1,2,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 2 (Greatmother Geyah)"),
(@ID*100+5,9,6,0,0,0,100,0,10000,10000,0,0,0,5,274,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 274"),
(@ID*100+5,9,7,0,0,0,100,0,2000,2000,0,0,0,1,7,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 7"),
(@ID*100+5,9,8,0,0,0,100,0,11000,11000,0,0,0,1,3,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 3 (Greatmother Geyah)"),
(@ID*100+5,9,9,0,0,0,100,0,8000,8000,0,0,0,1,4,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 4 (Greatmother Geyah)"),
(@ID*100+5,9,10,0,0,0,100,0,3000,3000,0,0,0,1,5,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 5 (Greatmother Geyah)"),
(@ID*100+5,9,11,0,0,0,100,0,9000,9000,0,0,0,91,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Remove Flag Standstate Sit Down"),
(@ID*100+5,9,12,0,0,0,100,0,2000,2000,0,0,0,90,8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Flag Standstate Kneel"),
(@ID*100+5,9,13,0,0,0,100,0,5000,5000,0,0,0,1,8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 8"),
(@ID*100+5,9,14,0,0,0,100,0,13000,13000,0,0,0,1,6,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 6 (Greatmother Geyah)"),
(@ID*100+5,9,15,0,0,0,100,0,8000,8000,0,0,0,1,9,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 9"),
(@ID*100+5,9,16,0,0,0,100,0,6000,6000,0,0,0,1,7,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 7 (Greatmother Geyah)"),
(@ID*100+5,9,17,0,0,0,100,0,6000,6000,0,0,0,1,10,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 10"),
(@ID*100+5,9,18,0,0,0,100,0,6000,6000,0,0,0,5,18,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 18 (Greatmother Geyah)"),
(@ID*100+5,9,19,0,0,0,100,0,4000,4000,0,0,0,1,8,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 8 (Greatmother Geyah)"),
(@ID*100+5,9,20,0,0,0,100,0,15000,15000,0,0,0,5,1,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Greatmother Geyah)"),
(@ID*100+5,9,21,0,0,0,100,0,5000,5000,0,0,0,1,9,0,0,0,0,0,19,18141,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 9 (Greatmother Geyah)"),
(@ID*100+5,9,22,0,0,0,100,0,5000,5000,0,0,0,91,8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Remove Flag Standstate Kneel"),
(@ID*100+5,9,23,0,0,0,100,0,1000,1000,0,0,0,1,11,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 11"),
(@ID*100+5,9,24,0,0,0,100,0,5000,5000,0,0,0,5,5,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 5"),
(@ID*100+5,9,25,0,0,0,100,0,4000,4000,0,0,0,5,15,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 15"),
(@ID*100+5,9,26,0,0,0,100,0,4000,4000,0,0,0,1,12,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 12"),
(@ID*100+5,9,27,0,0,0,100,0,3000,3000,0,0,0,65,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Resume Waypoint"),

-- Second talk with Garrosh
(@ID*100+6,9,0,0,0,0,100,0,1000,1000,0,0,0,66,0,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Orientation Closest Creature 'Garrosh'"),
(@ID*100+6,9,1,0,0,0,100,0,0,0,0,0,0,45,0,1,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 1 (Garrosh)"),
(@ID*100+6,9,2,0,0,0,100,0,2000,2000,0,0,0,1,13,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 13"),
(@ID*100+6,9,3,0,0,0,100,0,4000,4000,0,0,0,5,5,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 5"),
(@ID*100+6,9,4,0,0,0,100,0,5000,5000,0,0,0,5,273,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 273 (Garrosh)"),
(@ID*100+6,9,5,0,0,0,100,0,3000,3000,0,0,0,1,2,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 2 (Garrosh)"),
(@ID*100+6,9,6,0,0,0,100,0,2000,2000,0,0,0,45,0,3,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 3 (Garrosh)"),

-- Event at the blue circle 1
(@ID*100+7,9,0,0,0,0,100,0,0,0,0,0,0,54,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Pause Waypoint"),
(@ID*100+7,9,1,0,0,0,100,0,0,0,0,0,0,66,0,0,0,0,0,0,8,0,0,0,0,0,0,0,3.682645,"Thrall - On Script - Set Orientation"),
(@ID*100+7,9,2,0,0,0,100,0,0,0,0,0,0,59,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Run Off"),
(@ID*100+7,9,3,0,0,0,100,0,2000,2000,0,0,0,1,14,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 14"),
(@ID*100+7,9,4,0,0,0,100,0,5000,5000,0,0,0,5,15,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 15"),
(@ID*100+7,9,5,0,0,0,100,0,4000,4000,0,0,0,11,34378,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Cast 'Thrall Calls Thunder'"),
(@ID*100+7,9,6,0,0,0,100,0,0,0,0,0,0,86,33271,0,11,19646,300,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Cross Cast 'Internal Shake Camera w/ rumble sound' (Thrall Event Dummy)"),
(@ID*100+7,9,7,0,0,0,100,0,15000,15000,0,0,0,107,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Summon Group 0"),

-- Event at the blue circle 2
(@ID*100+8,9,0,0,0,0,100,0,0,0,0,0,0,90,8,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Flag Standstate Kneel (Garrosh)"),
(@ID*100+8,9,1,0,0,0,100,0,0,0,0,0,0,1,3,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 3 (Garrosh)"),
(@ID*100+8,9,2,0,0,0,100,0,4000,4000,0,0,0,1,4,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 4 (Garrosh)"),
(@ID*100+8,9,3,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,4,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,5,0,0,0,100,0,2000,2000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,6,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,7,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,8,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,9,0,0,0,100,0,1500,1500,0,0,0,1,5,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 5 (Garrosh)"),
(@ID*100+8,9,10,0,0,0,100,0,1500,1500,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,11,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,12,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,13,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,14,0,0,0,100,0,1000,1000,0,0,0,1,6,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 6 (Garrosh)"),
(@ID*100+8,9,15,0,0,0,100,0,2000,2000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,16,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,17,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,18,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,19,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,20,0,0,0,100,0,2000,2000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,21,0,0,0,100,0,1000,1000,0,0,0,1,7,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 7 (Garrosh)"),
(@ID*100+8,9,22,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,23,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,24,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,25,0,0,0,100,0,2000,2000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,26,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,27,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1 (Garrosh)"),
(@ID*100+8,9,28,0,0,0,100,0,0,0,0,0,0,91,8,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Remove Flag Standstate Kneel (Garrosh)"),
(@ID*100+8,9,29,0,0,0,100,0,0,0,0,0,0,1,8,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 8 (Garrosh)"),
(@ID*100+8,9,30,0,0,0,100,0,0,0,0,0,0,86,34410,0,11,19660,300,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Cross Cast 'Hellscream's Warsong' (Garrosh's Buff Bots)"),
(@ID*100+8,9,31,0,0,0,100,0,2000,2000,0,0,0,1,9,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 9 (Garrosh)"),
(@ID*100+8,9,32,0,0,0,100,0,5000,5000,0,0,0,66,0,0,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Orientation Closest Creature 'Garrosh'"),
(@ID*100+8,9,33,0,0,0,100,0,1000,1000,0,0,0,1,15,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 15"),
(@ID*100+8,9,34,0,0,0,100,0,0,0,0,0,0,1,16,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 16"),
(@ID*100+8,9,35,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1"),
(@ID*100+8,9,36,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1"),
(@ID*100+8,9,37,0,0,0,100,0,2000,2000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1"),
(@ID*100+8,9,38,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1"),
(@ID*100+8,9,39,0,0,0,100,0,1000,1000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 1"),
(@ID*100+8,9,40,0,0,0,100,0,3000,3000,0,0,0,45,0,4,0,0,0,0,19,18063,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 4 (Garrosh)"),
(@ID*100+8,9,41,0,0,0,100,0,0,0,0,0,0,65,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Resume Waypoint"),

-- Second talk with Greatmother
(@ID*100+9,9,0,0,0,0,100,0,1000,1000,0,0,0,1,17,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 17"),
(@ID*100+9,9,1,0,0,0,100,0,0,0,0,0,0,90,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Flag Standstate Sit Down"),
-- TO-DO: Author: he despawns after 6 hours
-- But we have to leave creature active or timer will not tick
-- Despawn after 5 minutes and leave Drek'thar active, he also prevents double summon and will despawn ~10 minutes later
(@ID*100+9,9,2,0,0,0,100,0,300000,300000,0,0,0,132,103,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Despawn SpawnGroup 103");



-- Mini scene scripted separately for better result
DELETE FROM `creature_summon_groups` WHERE `summonerId` = 19556 AND `summonerType` = 0;
INSERT INTO `creature_summon_groups` (`summonerId`,`summonerType`,`groupId`,`entry`,`position_x`,`position_y`,`position_z`,`orientation`,`summonType`,`summonTime`,`Comment`) VALUES
(19556,0,0,19647,-1422.789,7280.642,25.68812,5.358161,8,0,"Thrall - Group 0 - Thrall"),
(19556,0,0,18075,-1415.731,7271.584,25.49314,2.408554,8,0,"Thrall - Group 0 - Mannoroth"),
(19556,0,0,18076,-1425.996,7276.042,25.80751,5.88176,8,0,"Thrall - Group 0 - Grom Hellscream");

-- Mannoroth SAI
SET @ID := 18075;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
DELETE FROM `smart_scripts` WHERE `entryorguid` BETWEEN @ID*100+0 AND @ID*100+1 AND `source_type` = 9;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,0,63,0,100,0,0,0,0,0,0,80,@ID*100+0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Just Created - Run Script"),
(@ID,0,1,0,40,0,100,0,1,0,0,0,0,80,@ID*100+1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Waypoint 1 Reached - Run Script"),

(@ID*100+0,9,0,0,0,0,100,0,5000,5000,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 0"),
(@ID*100+0,9,1,0,0,0,100,0,6000,6000,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 1"),
(@ID*100+0,9,2,0,0,0,100,0,20000,20000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Play Emote 1"),
(@ID*100+0,9,3,0,0,0,100,0,3000,3000,0,0,0,1,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 2"),
(@ID*100+0,9,4,0,0,0,100,0,12000,12000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Play Emote 1"),
(@ID*100+0,9,5,0,0,0,100,0,7000,7000,0,0,0,1,0,0,0,0,0,0,19,19647,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 0 (Thrall)"),
(@ID*100+0,9,6,0,0,0,100,0,2000,2000,0,0,0,86,34388,0,19,19647,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Cross Cast 'Thunderstomp' (Thrall)"),
(@ID*100+0,9,7,0,0,0,100,0,2000,2000,0,0,0,86,34389,0,19,19647,0,0,19,18075,0,0,0,0,0,0,0,"Mannoroth - On Script - Cross Cast 'Throw Doomhammer' (Thrall)"),
(@ID*100+0,9,8,0,0,0,100,0,1500,1500,0,0,0,71,0,0,0,0,0,0,19,19647,0,0,0,0,0,0,0,"Mannoroth - On Script - Change Equipment (Thrall)"),
(@ID*100+0,9,9,0,0,0,100,0,0,0,0,0,0,17,27,0,0,0,0,0,19,19647,0,0,0,0,0,0,0,"Mannoroth - On Script - Set Emote State 27 (Thrall)"),
(@ID*100+0,9,10,0,0,0,100,0,0,0,0,0,0,1,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 3"),
-- Seems like Mannoroth Charges Thrall spell is not used, sadly
(@ID*100+0,9,11,0,0,0,100,0,5000,5000,0,0,0,53,1,18075,0,0,0,2,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Start Waypoint"),

(@ID*100+1,9,0,0,0,0,100,0,0,0,0,0,0,11,34391,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Cast 'Mannoroth Attacks'"),
(@ID*100+1,9,1,0,0,0,100,0,0,0,0,0,0,45,0,1,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Mannoroth - On Script - Set Data 0 1 (Grom Hellscream)"),
(@ID*100+1,9,2,0,0,0,100,0,0,0,0,0,0,90,7,0,0,0,0,0,19,19647,0,0,0,0,0,0,0,"Mannoroth - On Script - Set Flag Standstate Dead (Thrall)"),
(@ID*100+1,9,3,0,0,0,100,0,2000,2000,0,0,0,1,4,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 4"),
(@ID*100+1,9,4,0,0,0,100,0,2000,2000,0,0,0,66,0,0,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Mannoroth - On Script - Set Orientation Closest Creature 'Grom Hellscream'"),
(@ID*100+1,9,5,0,0,0,100,0,2000,2000,0,0,0,1,5,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 5"),
(@ID*100+1,9,6,0,0,0,100,0,18000,18000,0,0,0,5,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Mannoroth - On Script - Play Emote 1"),
(@ID*100+1,9,7,0,0,0,100,0,5000,5000,0,0,0,1,0,0,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Mannoroth - On Script - Say Line 0 (Grom Hellscream)"),
-- Jump to next part
(@ID*100+1,9,8,0,0,0,100,0,2000,2000,0,0,0,45,0,2,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Mannoroth - On Script - Set Data 0 2 (Grom Hellscream)");

DELETE FROM `waypoints` WHERE `entry` = 18075;
INSERT INTO `waypoints` (`entry`,`pointid`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`point_comment`) VALUES
(18075,1,-1421.56,7279.064,25.67705,0,0,"Mannoroth");

-- Grom Hellscream SAI
SET @ID := 18076;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID*100+0 AND `source_type` = 9;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,0,38,0,100,0,0,1,0,0,0,66,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,"Grom Hellscream - On Data Set 0 1 - Set Orientation Invoker"),
(@ID,0,1,0,38,0,100,0,0,2,0,0,0,53,1,18076,0,0,0,2,1,0,0,0,0,0,0,0,0,"Grom Hellscream - On Data Set 0 2 - Start Waypoint"),
(@ID,0,2,0,40,0,100,0,1,0,0,0,0,80,@ID*100+0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Grom Hellscream - On Waypoint 1 Reached - Run Script"),

(@ID*100+0,9,0,0,0,0,100,0,1000,1000,0,0,0,5,37,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Grom Hellscream - On Script - Play Emote 37"),
(@ID*100+0,9,1,0,0,0,100,0,0,0,0,0,0,86,34395,0,19,18075,0,0,1,0,0,0,0,0,0,0,0,"Grom Hellscream - On Script - Cross Cast 'Mannoroth Dies' (Mannoroth)"),
(@ID*100+0,9,2,0,0,0,100,0,500,500,0,0,0,90,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Grom Hellscream - On Script - Set Flag Standstate Sleep"),
-- Jump to next part
(@ID*100+0,9,3,0,0,0,100,0,0,0,0,0,0,45,0,1,0,0,0,0,19,19647,0,0,0,0,0,0,0,"Grom Hellscream - On Script - Set Data 0 1 (Thrall)");

DELETE FROM `waypoints` WHERE `entry` = 18076;
INSERT INTO `waypoints` (`entry`,`pointid`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`point_comment`) VALUES
(18076,1,-1423.213,7277.938,25.67705,0,0,"Grom Hellscream");

-- Thrall SAI
SET @ID := 19647;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
DELETE FROM `smart_scripts` WHERE `entryorguid` BETWEEN @ID*100+0 AND @ID*100+1 AND `source_type` = 9;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,0,38,0,100,0,0,1,0,0,0,80,@ID*100+0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Data Set 0 1 - Run Script"),
(@ID,0,1,0,40,0,100,0,1,0,0,0,0,80,@ID*100+1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Waypoint 1 Reached - Run Script"),

(@ID*100+0,9,0,0,0,0,100,0,5000,5000,0,0,0,17,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Emote State 0"),
(@ID*100+0,9,1,0,0,0,100,0,0,0,0,0,0,91,7,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Remove Flag Standstate Dead"),
(@ID*100+0,9,2,0,0,0,100,0,0,0,0,0,0,90,8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Set Flag Standstate Kneel"),
(@ID*100+0,9,3,0,0,0,100,0,3000,3000,0,0,0,53,0,19647,0,0,0,2,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Start Waypoint"),

(@ID*100+1,9,0,0,0,0,100,0,1500,1500,0,0,0,1,1,0,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 1 (Grom Hellscream)"),
(@ID*100+1,9,1,0,0,0,100,0,0,0,0,0,0,1,2,0,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 2 (Grom Hellscream)"),
(@ID*100+1,9,2,0,0,0,100,0,7000,7000,0,0,0,41,0,0,0,0,0,0,19,18075,0,1,0,0,0,0,0,"Thrall - On Script - Despawn Instant (Mannoroth)"),
(@ID*100+1,9,3,0,0,0,100,0,1000,1000,0,0,0,1,3,0,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 3 (Grom Hellscream)"),
(@ID*100+1,9,4,0,0,0,100,0,18000,18000,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Say Line 1"),
(@ID*100+1,9,5,0,0,0,100,0,9000,9000,0,0,0,91,8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Remove Flag Standstate Kneel"),
(@ID*100+1,9,6,0,0,0,100,0,0,0,0,0,0,5,15,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Play Emote 15"),
(@ID*100+1,9,7,0,0,0,100,0,5000,5000,0,0,0,41,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Thrall - On Script - Despawn Instant"),
(@ID*100+1,9,8,0,0,0,100,0,0,0,0,0,0,41,0,0,0,0,0,0,19,18076,0,0,0,0,0,0,0,"Thrall - On Script - Despawn Instant (Grom Hellscream)"),
-- Inform big Thrall and jump to next part, see above
(@ID*100+1,9,9,0,0,0,100,0,0,0,0,0,0,45,0,1,0,0,0,0,19,19556,0,0,0,0,0,0,0,"Thrall - On Script - Set Data 0 1 (Thrall)");

DELETE FROM `waypoints` WHERE `entry` = 19647;
INSERT INTO `waypoints` (`entry`,`pointid`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`point_comment`) VALUES
(19647,1,-1422.903,7279.915,25.67705,0,0,"Thrall");

SET @POINT := 0;
DELETE FROM `waypoints` WHERE `entry` = 19556;
INSERT INTO `waypoints` (`entry`,`pointid`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`point_comment`) VALUES
(19556,@POINT := @POINT + 1,-1349.914,6332.778,43.74491,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1376.285,6354.012,41.92145,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1395.761,6371.578,39.37491,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1416.581,6393.08,36.97689,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1437.672,6413.039,34.79077,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1461.674,6437.356,32.08894,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1490.398,6468.24,28.98989,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1505.137,6496.36,25.37372,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1512.865,6527.001,22.66885,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1518.474,6552.888,21.60993,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1521.708,6568.282,20.96366,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1512.913,6632.7,22.39752,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1507.126,6655.43,23.85226,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1504.92,6662.7,24.48247,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1494.251,6690.354,24.47311,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1474.878,6730.709,24.92821,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1455.4,6765.879,27.22983,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1442.034,6784.493,28.29723,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1425.776,6805.609,27.78597,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1409.667,6827.436,27.14842,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1389.377,6852.119,29.1224,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1354.932,6887.59,30.6786,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1331.892,6912.893,31.86545,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1322.652,6923.154,31.96082,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1303.386,6958.170,32.13569,0,3000,"Thrall"), -- 25
(19556,@POINT := @POINT + 1,-1298.432,6965.858,32.94059,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1293.26,6975.769,32.75947,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1286.796,6986.640,32.85235,0,0,"Thrall"), -- 28
(19556,@POINT := @POINT + 1,-1294.618,6995.853,32.5695,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1313.708,7015.143,33.21278,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1329.178,7025.363,33.85265,0,0,"Thrall"), -- 31
(19556,@POINT := @POINT + 1,-1330.332,7026.19,33.9671,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1346.047,7031.633,33.79149,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1364.008,7041.4,34.14558,0,0,"Thrall"), -- 34
(19556,@POINT := @POINT + 1,-1377.8,7054.752,34.563,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1389.566,7071.121,34.33751,0,0,"Thrall"), -- 36
(19556,@POINT := @POINT + 1,-1394.765,7085.715,33.5165,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1397.299,7094.352,33.29916,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1400.27,7112.666,33.44453,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1401.772,7126.559,33.73253,0,0,"Thrall"), -- 40
(19556,@POINT := @POINT + 1,-1387.934,7139.022,34.12173,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1375.81,7152.083,34.76439,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1371.634,7156.53,34.37251,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1363.432,7166.782,33.74737,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1357.394,7173.279,33.81808,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1343.675,7202.677,33.50021,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1342.671,7205.199,33.11827,0,12000,"Thrall"), -- 47 12000
(19556,@POINT := @POINT + 1,-1353.912,7233.381,33.27534,0,0,"Thrall"), -- 48
(19556,@POINT := @POINT + 1,-1351.352,7235.671,33.12692,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1347.005,7234.933,33.40887,0,29000,"Thrall"), -- 50
(19556,@POINT := @POINT + 1,-1348.088,7241.893,33.00979,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1337.396,7244.912,33.15238,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1329.12,7243.791,33.08465,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1325.884,7241.624,33.29979,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1319.027,7225.425,33.70268,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1317.728,7215.848,33.89096,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1307.45,7212.678,36.13881,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1292.464,7206.452,41.56324,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1276.794,7193.433,51.69974,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1268.383,7186.156,56.23711,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1266.264,7184.318,56.86266,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1254.841,7178.258,57.42343,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1239.085,7171.389,57.26868,0,6000,"Thrall"), -- 63
(19556,@POINT := @POINT + 1,-1225.519,7166.836,57.57937,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1223.953,7164.284,57.39006,0,0,"Thrall"), -- 65
(19556,@POINT := @POINT + 1,-1233.731,7174.257,57.32937,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1279.026,7195.141,50.25358,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1294.919,7206.255,40.83135,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1315.554,7213.983,34.63311,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1320.284,7215.999,34.15732,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1318.225,7233.313,33.19328,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1326.275,7243.778,33.27525,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1343.156,7245.558,33.18895,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1347.993,7235.135,33.38955,5.635268,16000,"Thrall"), -- 74
(19556,@POINT := @POINT + 1,-1371.615,7232.133,32.4465,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1386.802,7236.177,27.61976,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1394.828,7251.646,26.03636,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1395.564,7253.929,25.8459,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1397.073,7265.799,25.74383,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1413.108,7284.411,25.42705,0,0,"Thrall"), -- 80
(19556,@POINT := @POINT + 1,-1392.792,7241.064,26.05975,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1371.25,7232.395,32.27535,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1364.153,7229.902,33.38591,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1343.806,7212.792,32.92739,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1319.785,7213.119,33.79593,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1295.407,7206.193,41.04809,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1270.321,7188.29,55.51945,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1262.263,7183.662,57.41998,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1246.086,7175.857,57.5472,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1223.763,7174.583,57.60546,0,0,"Thrall"),
(19556,@POINT := @POINT + 1,-1223.883,7164.478,57.39006,5.574559,1,"Thrall"); -- 91

-- Drek'Thar SAI
SET @ID := 19604;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID*100+0 AND `source_type` = 9;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,0,37,0,100,0,0,0,0,0,0,48,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On AI Initialize - Set Active"),
(@ID,0,1,0,38,0,100,0,0,1,0,0,0,53,1,19604,0,0,0,2,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Data Set 0 1 - Start Waypoint"),
(@ID,0,2,0,40,0,100,0,24,0,0,0,0,59,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Waypoint 24 Reached - Set Run Off"),
(@ID,0,3,0,40,0,100,0,26,0,0,0,0,80,@ID*100+0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Waypoint 26 Reached - Run Script"),

(@ID*100+0,9,0,0,0,0,100,0,0,0,0,0,0,54,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Script - Pause Waypoint"),
(@ID*100+0,9,1,0,0,0,100,0,0,0,0,0,0,43,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Script - Dismount"),
(@ID*100+0,9,2,0,0,0,100,0,1000,1000,0,0,0,66,0,0,0,0,0,0,8,0,0,0,0,0,0,0,4.328416,"Drek'Thar - On Script - Set Orientation"),
-- Author: here starts despawn timer and after 30 minutes he and all guards despawns
(@ID*100+0,9,3,0,0,0,100,0,1800000,1800000,0,0,0,132,102,0,0,4,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Script - Despawn SpawnGroup 102"),
(@ID*100+0,9,4,0,0,0,100,0,0,0,0,0,0,132,104,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Script - Despawn SpawnGroup 104"),

(@ID,0,4,0,38,0,100,0,0,2,0,0,0,65,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Drek'Thar - On Data Set 0 2 - Resume Waypoint");

SET @POINT := 0;
DELETE FROM `waypoints` WHERE `entry` = 19604;
INSERT INTO `waypoints` (`entry`,`pointid`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`point_comment`) VALUES
(19604,@POINT := @POINT+1,-1379.341,6356.216,41.59998,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1395.792,6371.465,39.58159,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1416.514,6393.018,36.98659,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1437.613,6412.975,34.79754,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1461.614,6437.551,32.09557,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1490.277,6468.115,29.00541,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1504.959,6496.419,25.39698,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1512.75,6527.013,22.70193,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1518.42,6552.887,21.62595,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1521.663,6568.327,20.96966,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1512.938,6632.651,22.39684,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1507.196,6655.35,24.0721,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1505.012,6662.614,24.45829,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1494.345,6690.549,24.45761,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1475.062,6730.891,24.92339,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1455.289,6765.832,27.25725,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1442.161,6784.633,28.08929,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1425.53,6805.518,27.79475,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1409.624,6827.367,27.13184,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1389.318,6852.164,29.07919,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1355.029,6887.561,30.71885,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1332.001,6912.789,31.89273,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1322.774,6923.111,31.98964,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1302.877,6958.549,32.20076,0,0,"Drek'Thar"), -- 24
(19604,@POINT := @POINT+1,-1302.877,6958.549,32.20076,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1300.874,6966.982,32.62271,0,0,"Drek'Thar"), -- 26
(19604,@POINT := @POINT+1,-1299.381,6969.558,32.77773,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1297.687,6974.454,32.50555,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1292.62,6980.152,32.60894,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1288.638,6984.105,32.85603,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1289.818,6987.569,32.64879,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1292.822,6991.643,32.63162,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1299.464,6997.273,32.3705,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1305.716,7004.623,32.50484,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1317.576,7016.176,33.53638,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1319.509,7018.285,33.6684,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1324.291,7021.535,33.94361,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1330.862,7025.661,33.89574,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1343.045,7027.846,33.59311,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1354.73,7033.678,33.77676,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1367.055,7040.773,34.13885,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1378.019,7051.014,34.56979,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1388.98,7063.224,34.51899,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1398.752,7089.976,33.52263,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1399.983,7095.379,33.30988,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1403.015,7114.424,33.53225,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1402.203,7127.854,33.56348,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1387.106,7138.031,34.09302,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1373.571,7158.026,34.36966,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1364.84,7166.027,33.91392,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1364.164,7167.939,33.84708,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1349.336,7199.349,33.86401,0,100000,"Drek'Thar"), -- 52
(19604,@POINT := @POINT+1,-1348.172,7212.101,32.80852,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1360.009,7228.346,33.11093,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1387.203,7234.722,27.29422,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1406.162,7259.292,26.40471,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1413.271,7262.43,26.42888,0,0,"Drek'Thar"),
(19604,@POINT := @POINT+1,-1418.196,7265.354,25.66155,1.902409,1,"Drek'Thar");

-- Garrosh SAI
SET @ID := 18063;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,0,38,0,100,0,0,1,0,0,0,66,0,0,0,0,0,0,19,19556,0,0,0,0,0,0,0,"Garrosh - On Data Set 0 1 - Set Orientation Closest Creature 'Thrall'"),
(@ID,0,1,0,38,0,100,0,0,2,0,0,0,66,0,0,0,0,0,0,8,0,0,0,0,0,0,0,5.72468,"Garrosh - On Data Set 0 2 - Set Orientation"),
(@ID,0,2,0,38,0,100,0,0,3,0,0,0,53,1,18063,0,0,0,2,1,0,0,0,0,0,0,0,0,"Garrosh - On Data Set 0 3 - Start Waypoint"),
(@ID,0,3,0,38,0,100,0,0,3,0,0,0,83,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garrosh - On Data Set 0 3 - Remove NPC Flags Gossip & Questgiver"),
(@ID,0,4,0,40,0,100,0,7,0,0,0,0,54,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garrosh - On Waypoint 7 Reached - Pause Waypoint"),
(@ID,0,5,0,40,0,100,0,7,0,0,0,0,66,0,0,0,0,0,0,8,0,0,0,0,0,0,0,3.612832,"Garrosh - On Waypoint 7 Reached - Set Orientation"),
(@ID,0,6,0,40,0,100,0,7,0,0,0,0,59,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garrosh - On Waypoint 7 Reached - Set Run Off"),
(@ID,0,7,0,38,0,100,0,0,4,0,0,0,65,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garrosh - On Data Set 0 4 - Resume Waypoint"),
(@ID,0,8,0,40,0,100,0,9,0,0,0,0,82,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garrosh - On Waypoint 9 Reached - Add NPC Flags Gossip & Questgiver");

DELETE FROM `waypoints` WHERE `entry` = 18063;
INSERT INTO `waypoints` (`entry`,`pointid`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`point_comment`) VALUES
(18063,1,-1367.4,7230.706,32.98071,0,0,"Garrosh"),
(18063,2,-1379.76,7232.02,30.05685,0,0,"Garrosh"),
(18063,3,-1386.526,7234.678,27.79641,0,0,"Garrosh"),
(18063,4,-1391.604,7241.841,26.46104,0,0,"Garrosh"),
(18063,5,-1396.907,7256.348,25.74905,0,0,"Garrosh"),
(18063,6,-1399.196,7265.486,25.62899,0,0,"Garrosh"),
(18063,7,-1410.123,7281.435,25.55205,0,0,"Garrosh"),
(18063,8,-1357.148,7242.278,33.77266,0,0,"Garrosh"),
(18063,9,-1344.67,7232.62,33.5608,5.55015,1,"Garrosh");

-- Kor'kron Warrior SAI
SET @ID := 19592;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,0,11,0,100,0,0,0,0,0,0,43,19596,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Kor'kron Warrior - On Respawn - Mount To Creature 'Kor'kron Mount'");

-- Kor'kron Honor Guard SAI
SET @ID := 19594;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID AND `source_type` = 0;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ID,0,0,0,11,0,100,0,0,0,0,0,0,43,19596,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Kor'kron Honor Guard - On Respawn - Mount To Creature 'Kor'kron Mount'"),
-- At least these are active so other can move safely
(@ID,0,1,0,37,0,100,0,0,0,0,0,0,48,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Kor'kron Honor Guard - On AI Initialize - Set Active");

-- Garadar Defender SAI
SET @ID := 18489;
UPDATE `creature_template` SET `AIName` = "SmartAI" WHERE `entry` = @ID;
DELETE FROM `smart_scripts` WHERE `entryorguid` = @ID*100+0 AND `source_type` = 9;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`event_param5`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_param4`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
-- Let them finish all actions
(@ID*100+0,9,0,0,0,0,100,0,0,0,0,0,0,48,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garadar Defender - On Script - Set Active On"),
(@ID*100+0,9,1,0,0,0,100,0,0,0,0,0,0,66,0,0,0,0,0,0,19,19556,0,0,0,0,0,0,0,"Garadar Defender - On Script - Set Orientation Closest Creature 'Thrall'"),
(@ID*100+0,9,2,0,0,0,100,0,1000,1000,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garadar Defender - On Script - Say Line 0"),
(@ID*100+0,9,3,0,0,0,100,0,3500,3500,0,0,0,90,8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garadar Defender - On Script - Set Flag Standstate Kneel"),
(@ID*100+0,9,4,0,0,0,100,0,40000,40000,0,0,0,91,8,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garadar Defender - On Script - Remove Flag Standstate Kneel"),
(@ID*100+0,9,5,0,0,0,100,0,0,0,0,0,0,66,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garadar Defender - On Script - Set Orientation Home Position"),
(@ID*100+0,9,6,0,0,0,100,0,0,0,0,0,0,48,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,"Garadar Defender - On Script - Set Active Off");



-- Texts
DELETE FROM `creature_text` WHERE `CreatureID` IN (19556,18063,18141,18075,19647,18076,18489);
INSERT INTO `creature_text` (`CreatureID`,`GroupID`,`ID`,`Text`,`Type`,`Language`,`Probability`,`Emote`,`Duration`,`Sound`,`BroadcastTextId`,`TextRange`,`comment`) VALUES
(19556,0,0,"War drums echo in the distance.",16,0,100,0,0,0,16980,2,"Thrall"),
(19556,1,0,"At long last, I am home...",14,0,100,22,0,0,16996,2,"Thrall"),
(19556,2,0,"Hellscream! Blessed ancestors! He is the mirrored reflection of Grom, Drek'Thar.",12,1,100,25,0,0,17080,0,"Thrall"),
(19556,3,0,"I am sorry that I did not come sooner, young Hellscream. There is so much that I have to tell you about your father, but first you must tell me where I may find the Greatmother.",12,0,100,1,0,0,17096,0,"Thrall"),
(18063,0,0,"We are honored by your presence, son of Durotan. The Greatmother awaits you at the hospice.",12,1,100,2,0,0,17098,0,"Garrosh"),
(18063,1,0,"%s points towards the hospice.",16,1,100,25,0,0,17099,0,"Garrosh"),
(19556,4,0,"I thank you, Garrosh. We have much to discuss when I return from my visit with the Greatmother.",12,1,100,1,0,0,17100,0,"Thrall"),
(19556,5,0,"Greatmother...",12,1,100,1,0,0,17102,0,"Thrall"),
(18141,0,0,"I have been expecting you, young one. Come closer - my eyes are not as sharp as they once were.
",12,1,100,273,0,0,17101,0,"Greatmother Geyah"),
(18141,1,0,"Yes, you move like my son. You have his broad shoulders - ahh, and your mother's fierce eyes.
",12,1,100,1,0,0,17120,0,"Greatmother Geyah"),
(19556,6,0,"Greatmother...Am I...
",12,1,100,6,0,0,17113,0,"Thrall"),
(18141,2,0,"There is no doubt - you are the heir of Durotan... my grandson. Draka told me she was with child before she and your father left our world, but I never dared dream that they would survive...
",12,1,100,1,0,0,17123,0,"Greatmother Geyah"),
(19556,7,0,"They... did not, Greatmother. They were killed shortly after I was born. I never knew them. I was raised as a slave. To this day, I carry the name of Thrall.
",12,1,100,1,0,0,17122,0,"Thrall"),
(18141,3,0,"Thrall? You've been a slave only to the past, grandson! But no more! When last I saw him, Durotan told me the name he would give his unborn son... He was... so proud...",12,1,100,1,0,0,17126,0,"Greatmother Geyah"),
(18141,4,0,"%s wipes a tear away.",16,1,100,0,0,0,17926,0,"Greatmother Geyah"),
(18141,5,0,"Go'el. You are Go'el, son of Durotan - rightful chieftain of the Frostwolves. This day, grandson - you are the great joy of my heart.
",12,1,100,0,0,0,17927,0,"Greatmother Geyah"),
(19556,8,0,"I have dreamed of this moment all my life, Greatmother. 'Till now, all I've had were Orgrim's stories about my parents and their adventures on Draenor. He was my greatest teacher and dearest friend. He died a hero... They all died as heroes - and for all of them, a song of honor remains.
",12,1,100,1,0,0,17928,0,"Thrall"),
(18141,6,0,"I see that you hold the Doomhammer. Have all of our greatest heroes fallen, grandson?
",12,1,100,0,0,0,17929,0,"Greatmother Geyah"),
(19556,9,0,"They died honorably, Greatmother.",12,1,100,273,0,0,17124,0,"Thrall"),
(18141,7,0,"What of Grommash? What of Hellscream?
",12,1,100,6,0,0,17930,0,"Greatmother Geyah"),
(19556,10,0,"He died our greatest hero. It was Grom who freed us all... I was by his side when he struck down Mannoroth and ended the curse forever.",12,1,100,1,0,0,17128,0,"Thrall"),
(18141,8,0,"Blessed spirits! For twenty years, all we knew was that Grom was the first to drink from the cursed chalice and bring damnation down upon our people... It is the only truth his son, Garrosh has ever known.
",12,1,100,1,0,0,17129,0,"Greatmother Geyah"),
(18141,9,0,"Grandson, will you... Will you tell Garrosh what you have told me about his father?",12,1,100,1,0,0,17131,0,"Greatmother Geyah"),
(19556,11,0,"Tell him? Greatmother, that boy's father died so that all of us could live free of the blood curse. I will tell him nothing. I will show him! Show him and any that would doubt Hellscream's resolve exactly what Grom Hellscream did for all orcs!",12,1,100,1,0,0,17132,0,"Thrall"),
(19556,12,0,"Please excuse me, Greatmother. I will return soon.",12,1,100,2,0,0,17133,0,"Thrall"),
(19556,13,0,"Garrosh, son of Hellscream, your father lived and died as our greatest hero. Honor me by allowing me to show you what your father sacrificed so that we could live free of the demon's grasp.",12,1,100,25,0,0,17134,0,"Thrall"),
(18063,2,0,"As you wish, Thrall, son of Durotan.",12,1,100,1,0,0,17135,0,"Garrosh"),

(19556,14,0,"Spirits give me strength! Take from my soul these old wounds and expose them for all to see! Let this child know his father! Let these people know their savior!",14,1,100,22,0,0,17136,0,"Thrall"),

(18075,0,0,"%s laughs.",16,0,100,0,0,10624,17137,0,"Mannoroth"),
(18075,1,0,"So predictable. I knew you would come. And I see you've brought the mighty Hellscream.",12,0,100,1,0,10625,17138,0,"Mannoroth"),
(18075,2,0,"His blood is mine, as is your whole misbegotten race.",12,0,100,1,0,10626,17139,0,"Mannoroth"),
(19647,0,0,"%s roars in defiance.",16,0,100,15,0,0,17140,0,"Thrall"),
(18075,3,0,"A worthy effort, but futile.",12,0,100,1,0,10627,17141,0,"Mannoroth"),
(18075,4,0,"%s laughs.",16,0,100,0,0,0,17137,0,"Mannoroth"),
(18075,5,0,"The boy believed you could be saved, but he didn't know what burns within your soul when in your heart, you know we are the same.
",12,0,100,1,0,10628,17142,0,"Mannoroth"),
(18076,0,0,"NOOOO!",12,0,100,15,0,0,17144,0,"Grom Hellscream"),
(18076,1,0,"Thrall... The blood haze has lifted.",12,0,100,0,0,10629,17150,0,"Grom Hellscream"),
(18076,2,0,"Grom's eyes go dim as the blood curse is lifted.",16,0,100,0,0,0,17151,0,"Grom Hellscream"),
(18076,3,0,"The demon's fire has burnt out in my veins. I have... freed myself.
",12,0,100,0,0,10630,17152,0,"Grom Hellscream"),
(19647,1,0,"No, old friend. You've freed us all...",12,0,100,0,0,10631,17153,0,"Thrall"),

(18063,3,0,"%s collapses.",16,1,100,0,0,0,17163,0,"Garrosh"),
(18063,4,0,"For my entire life I have thought my bloodline cursed. I have lived beneath the shadow of my father's greatest failure.",12,1,100,1,0,0,17164,0,"Garrosh"),
(18063,5,0,"I hated him for what he had done. I hated him for the burden he left me. But now...",12,1,100,1,0,0,17166,0,"Garrosh"),
(18063,6,0,"You have shown me truths that I would have never known. You and your allies have gifted me with something that cannot bear a price: Redemption. Thrall, redeemer of the Mag'har, you honor me as none ever have...",12,1,100,1,0,0,17167,0,"Garrosh"),
(18063,7,0,"On this day, a great burden has been lifted from my chest. My heart swells with pride. And for the first time, I can proudly proclaim who I am. I can finally unleash the fury in my heart.",12,1,100,1,0,0,17168,0,"Garrosh"),
(18063,8,0,"I am Garrosh Hellscream, son of Grom, chieftain of the Mag'har! Let the battle call of Hellscream give you courage and strength! Be lifted by my rallying cry.",14,1,100,15,0,0,17169,0,"Garrosh"),
(18063,9,0,"Thank you, son of Durotan.",12,1,100,2,0,0,17171,0,"Garrosh"),

(19556,15,0,"%s places a hand on Garrosh's shoulder.",16,1,100,0,0,0,17172,0,"Thrall"),
(19556,16,0,"You need not thank me, Garrosh. Your father was a brother to me. I would do anything for you and the Mag'har. I must now return to the Greatmother.",12,1,100,1,0,0,17173,0,"Thrall"),
(19556,17,0,"I have returned, Greatmother. Garrosh has found his heart and his fury.",12,1,100,1,0,0,17175,0,"Thrall"),

(18489,0,0,"Who is he? He looks so familiar.",12,1,100,1,0,0,17005,0,"Garadar Defender"),
(18489,0,1,"Are the rumors true? Does he truly carry the Greatmother's bloodline?",12,1,100,1,0,0,17006,0,"Garadar Defender"),
(18489,0,2,"Could it really be? The son of Durotan?",12,1,100,1,0,0,17007,0,"Garadar Defender"),
(18489,0,3,"Has he come to lead us?",12,1,100,1,0,0,17008,0,"Garadar Defender"),
(18489,0,4,"I have never felt such strength radiate from an orc. Is he... mortal...",12,1,100,1,0,0,17009,0,"Garadar Defender"),
(18489,0,5,"He carries the Doomhammer!",12,1,100,1,0,0,17010,0,"Garadar Defender"),
(18489,0,6,"For the first time, I feel safe. I do not know you, stranger, but I know that I would lay down my life for you if only you asked.",12,1,100,1,0,0,17011,0,"Garadar Defender"),
(18489,0,7,"Son of Durotan... Grandson of Garad and Geyah... Bow your heads for a Warchief is among us...",12,1,100,1,0,0,17012,0,"Garadar Defender"),
(18489,0,8,"I am unworthy, son of Durotan. We are all unworthy...",12,1,100,1,0,0,17013,0,"Garadar Defender");



-- Kor'kron Warrior / Honor Guard
-- TO-DO: Only two Honor Guard (02 & 03) should have waypoints, warriors just follows them in circle formation, once leaders reaches gates,
-- they changes formation type or disbands formations and allows members to reach final points(not likely, it requires unique waypoints for
-- each member instead of simple formation type change)
-- https://cloud.githubusercontent.com/assets/22568446/23335989/1a5324a4-fbc2-11e6-9e09-73d1e3aa90d0.png

-- TO-DO: Looks like timers on which waypoints starts are wrong, here https://i.imgur.com/nQEMPQD.jpg and here http://i.imgur.com/Nwi9nIC.jpg
-- Thrall and Drek'thar already started to move but guards still not + in movie guards definitely arrives after Thrall and Drek'thar
DELETE FROM `creature_addon` WHERE `guid` BETWEEN @CGUID+02 AND @CGUID+21;
INSERT INTO `creature_addon` (`guid`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `visibilityDistanceType`, `auras`) VALUES
(@CGUID+02,(@CGUID+02)*10,0,0,1,0,0,""),
(@CGUID+03,(@CGUID+03)*10,0,0,1,0,0,""),
(@CGUID+04,(@CGUID+04)*10,0,0,1,0,0,""),
(@CGUID+05,(@CGUID+05)*10,0,0,1,0,0,""),
(@CGUID+06,(@CGUID+06)*10,0,0,1,0,0,""),
(@CGUID+07,(@CGUID+07)*10,0,0,1,0,0,""),
(@CGUID+08,(@CGUID+08)*10,0,0,1,0,0,""),
(@CGUID+09,(@CGUID+09)*10,0,0,1,0,0,""),
(@CGUID+10,(@CGUID+10)*10,0,0,1,0,0,""),
(@CGUID+11,(@CGUID+11)*10,0,0,1,0,0,""),
(@CGUID+12,(@CGUID+12)*10,0,0,1,0,0,""),
(@CGUID+13,(@CGUID+13)*10,0,0,1,0,0,""),
(@CGUID+14,(@CGUID+14)*10,0,0,1,0,0,""),
(@CGUID+15,(@CGUID+15)*10,0,0,1,0,0,""),
(@CGUID+16,(@CGUID+16)*10,0,0,1,0,0,""),
(@CGUID+17,(@CGUID+17)*10,0,0,1,0,0,""),
(@CGUID+18,(@CGUID+18)*10,0,0,1,0,0,""),
(@CGUID+19,(@CGUID+19)*10,0,0,1,0,0,""),
(@CGUID+20,(@CGUID+20)*10,0,0,1,0,0,""),
(@CGUID+21,(@CGUID+21)*10,0,0,1,0,0,"");

DELETE FROM `waypoint_data` WHERE `id` BETWEEN (@CGUID+02)*10 AND (@CGUID+21)*10;
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
((@CGUID+02)*10,1,-1335.208, 6313.925, 45.51422,0,20000,1,0,0,0),
((@CGUID+02)*10,2,-1370.963,6349.604,42.44443,0,0,1,0,0,0),
((@CGUID+02)*10,3,-1388.865,6366.901,40.37408,0,0,1,0,0,0),
((@CGUID+02)*10,4,-1412.882,6389.243,37.57892,0,0,1,0,0,0),
((@CGUID+02)*10,5,-1439.271,6416.663,34.78931,0,0,1,0,0,0),
((@CGUID+02)*10,6,-1461.663,6438.391,32.23282,0,0,1,0,0,0),
((@CGUID+02)*10,7,-1477.928,6453.506,30.47572,0,0,1,0,0,0),
((@CGUID+02)*10,8,-1492.937,6469.55,28.93468,0,0,1,0,0,0),
((@CGUID+02)*10,9,-1506.934,6498.086,25.10762,0,0,1,0,0,0),
((@CGUID+02)*10,10,-1511.489,6515.687,23.48201,0,0,1,0,0,0),
((@CGUID+02)*10,11,-1513.084,6527.153,22.48186,0,0,1,0,0,0),
((@CGUID+02)*10,12,-1517.572,6552.807,21.63368,0,0,1,0,0,0),
((@CGUID+02)*10,13,-1520.962,6580.408,20.6239,0,0,1,0,0,0),
((@CGUID+02)*10,14,-1513.673,6622.252,21.37939,0,0,1,0,0,0),
((@CGUID+02)*10,15,-1505.733,6653.425,23.88755,0,0,1,0,0,0),
((@CGUID+02)*10,16,-1503.204,6662.354,24.24408,0,0,1,0,0,0),
((@CGUID+02)*10,17,-1489.222,6698.047,24.55171,0,0,1,0,0,0),
((@CGUID+02)*10,18,-1472.453,6733.013,25.15502,0,0,1,0,0,0),
((@CGUID+02)*10,19,-1456.333,6762.938,26.8497,0,0,1,0,0,0),
((@CGUID+02)*10,20,-1447.986,6777.398,28.01004,0,0,1,0,0,0),
((@CGUID+02)*10,21,-1430.961,6801.701,28.01143,0,0,1,0,0,0),
((@CGUID+02)*10,22,-1417.353,6824.057,27.24986,0,0,1,0,0,0),
((@CGUID+02)*10,23,-1401.949,6847.906,27.6743,0,0,1,0,0,0),
((@CGUID+02)*10,24,-1374.873,6866.761,30.08648,0,0,1,0,0,0),
((@CGUID+02)*10,25,-1364.208,6876.673,30.61027,0,0,1,0,0,0),
((@CGUID+02)*10,26,-1352.93,6886.95,30.93086,0,0,1,0,0,0),
((@CGUID+02)*10,27,-1322.323,6914.781,32.49161,0,0,1,0,0,0),
((@CGUID+02)*10,28,-1317.948,6917.533,32.90894,2.513274,50000000,1,0,0,0),

((@CGUID+03)*10,1,-1346.921, 6327.715, 43.98703,0,18000,1,0,0,0),
((@CGUID+03)*10,2,-1385.748,6361.829,40.84011,0,0,1,0,0,0),
((@CGUID+03)*10,3,-1399.725,6375.522,39.03989,0,0,1,0,0,0),
((@CGUID+03)*10,4,-1414.304,6390.69,37.17965,0,0,1,0,0,0),
((@CGUID+03)*10,5,-1428.223,6404.804,36.00574,0,0,1,0,0,0),
((@CGUID+03)*10,6,-1452.067,6426.114,33.09519,0,0,1,0,0,0),
((@CGUID+03)*10,7,-1464.908,6440.203,31.77184,0,0,1,0,0,0),
((@CGUID+03)*10,8,-1490.506,6468.814,28.84116,0,0,1,0,0,0),
((@CGUID+03)*10,9,-1506.089,6501.073,24.8507,0,0,1,0,0,0),
((@CGUID+03)*10,10,-1512.866,6529.669,22.53263,0,0,1,0,0,0),
((@CGUID+03)*10,11,-1519.981,6574.273,21.05044,0,0,1,0,0,0),
((@CGUID+03)*10,12,-1516.592,6602.926,21.30149,0,0,1,0,0,0),
((@CGUID+03)*10,13,-1507.95,6655.633,23.95883,0,0,1,0,0,0),
((@CGUID+03)*10,14,-1505.954,6664.893,24.49434,0,0,1,0,0,0),
((@CGUID+03)*10,15,-1490.85,6696.347,24.39755,0,0,1,0,0,0),
((@CGUID+03)*10,16,-1467.245,6747.524,25.85784,0,0,1,0,0,0),
((@CGUID+03)*10,17,-1455.335,6767.127,27.21014,0,0,1,0,0,0),
((@CGUID+03)*10,18,-1441.818,6786.843,28.33891,0,0,1,0,0,0),
((@CGUID+03)*10,19,-1428.624,6802.308,27.77453,0,0,1,0,0,0),
((@CGUID+03)*10,20,-1418.503,6822.202,27.28543,0,0,1,0,0,0),
((@CGUID+03)*10,21,-1409.673,6844.438,27.4851,0,0,1,0,0,0),
((@CGUID+03)*10,22,-1392.207,6855.187,28.61077,0,0,1,0,0,0),
((@CGUID+03)*10,23,-1366.374,6876.586,30.37937,0,0,1,0,0,0),
((@CGUID+03)*10,24,-1333.158,6911.208,31.68118,0,0,1,0,0,0),
((@CGUID+03)*10,25,-1331.007,6913.661,31.89906,0,0,1,0,0,0),
((@CGUID+03)*10,26,-1329.025,6928.554,32.16651,5.689773,50000000,1,0,0,0),

((@CGUID+04)*10,@POINT := @POINT+1,-1333.763, 6317.533, 44.76424,0,20000,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1363.905,6343.13,42.91702,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1370.023,6348.561,42.31838,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1378.516,6356.66,41.4787,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1390.295,6368.313,40.27466,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1399.076,6376.377,39.21536,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1408.187,6384.929,38.12248,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1417.009,6392.926,37.11723,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1420.307,6396.715,36.50815,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1433.707,6410.693,35.37553,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1436.64,6413.748,34.57877,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1450.413,6427.477,33.34807,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1458.148,6434.958,32.6637,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1461.805,6438.347,32.01699,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1471.092,6446.86,30.9089,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1484.458,6459.56,29.76557,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1491.493,6467.949,28.84589,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1499.084,6476.817,28.1244,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1502.818,6487.976,26.59095,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1507.241,6498.776,25.0731,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1509.246,6507.414,24.03932,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1511.655,6515.82,23.08534,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1513.323,6527.424,22.3445,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1516.321,6546.909,21.60966,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1519.096,6558.417,21.15165,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1521.865,6569.838,20.69001,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1521.074,6580.762,20.57644,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1521.409,6593.634,20.6136,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1518.83,6604.96,20.96532,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1515.401,6616.24,21.21825,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1512.263,6626.467,22.02513,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1509.62,6637.625,23.04537,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1508.07,6643.548,23.31059,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1505.011,6655.951,24.2037,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1499.99,6670.876,24.71427,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1495.02,6683.651,24.56915,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1490.671,6694.655,24.31915,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1485.896,6705.44,24.31023,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1480.961,6716.088,24.24273,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1476.005,6726.78,24.58745,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1473.608,6730.999,24.95835,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1468.324,6741.463,25.38992,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1464.55,6748.065,25.98542,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1458.849,6758.314,26.61341,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1453.858,6767.143,27.12453,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1444.201,6783.815,28.18245,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1437.69,6794.885,28.26914,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1431.503,6801.295,27.90124,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1421.835,6812.321,27.47453,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1417.677,6823.269,26.97453,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1412.783,6834.058,26.78658,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1405.642,6843.262,27.14766,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1399.677,6850.853,27.89092,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1395.241,6853.676,28.38161,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1381.865,6862.517,29.2046,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1375.528,6867.126,29.80379,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1364.123,6876.721,30.63628,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1352.062,6887.736,30.68115,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1344.626,6896.469,30.88867,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1341.484,6900.029,31.53562,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1329.528,6909.881,31.87608,0,0,1,0,0,0),
((@CGUID+04)*10,@POINT := @POINT+1,-1320.009,6914.573,32.7706,2.513227,50000000,1,0,0,0),

((@CGUID+05)*10,@POINT := @POINT+1,-1329.355, 6321.17, 44.81275,0,20000,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1361.635,6336.36,43.08705,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1372.819,6346.113,42.01437,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1384.142,6356.921,40.8881,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1388.693,6361.057,40.47346,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1399.952,6371.858,39.02798,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1407.791,6379.146,38.0183,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1419.109,6389.892,36.66923,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1423.201,6394.178,36.01923,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1434.259,6405.518,35.04535,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1439.697,6411.308,34.23424,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1447.909,6419.515,33.35559,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1455.809,6426.935,32.38613,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1464.235,6435.105,31.66226,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1474.721,6445.096,30.66137,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1481.802,6451.782,29.92131,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1491.77,6462.492,29.19061,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1501.547,6473.975,28.09883,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1505.847,6485.064,26.83763,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1509.41,6493.93,25.15765,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1511.947,6502.635,23.95799,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1516.025,6518.239,22.95268,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1517.373,6533.151,22.13318,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1519.741,6544.64,21.32426,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1521.564,6553.415,21.1659,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1525.302,6567.618,20.69001,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1525.084,6580.297,20.44001,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1525.247,6592.177,20.43892,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1522.817,6593.657,20.63129,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1519.499,6616.019,21.0576,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1516.541,6625.611,21.77748,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1513.549,6637.813,22.7097,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1512.125,6643.132,23.04766,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1509.588,6653.51,23.81737,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1505.081,6667.459,24.41676,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1499.122,6683.763,24.44415,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1494.774,6694.767,24.25445,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1489.985,6705.788,24.63848,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1485.05,6716.437,24.32402,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1480.095,6727.128,24.5125,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1476.938,6733.173,24.82853,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1472.807,6741.392,25.30933,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1466.335,6753.203,26.52328,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1463.646,6757.479,26.76385,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1456.647,6770.112,27.49985,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1451.989,6777.806,28.08868,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1441.726,6795.631,28.46372,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1436.475,6801.089,28.19376,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1427.71,6811.352,27.80988,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1421.77,6823.58,27.14934,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1416.875,6834.373,26.91182,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1409.534,6844.566,27.13716,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1402.18,6853.799,27.7806,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1392.777,6860.603,28.95402,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1385.382,6864.938,29.17112,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1373.838,6873.02,29.70639,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1364.647,6881.427,30.05615,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1356.832,6888.598,30.68036,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1348.453,6897.952,30.87292,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1342.007,6905.345,31.53397,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1330.482,6914.278,31.69605,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1327.207,6915.976,32.05476,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1319.087,6921.402,32.82956,0,0,1,0,0,0),
((@CGUID+05)*10,@POINT := @POINT+1,-1316.287,6921.044,32.98755,2.590019,50000000,1,0,0,0),

((@CGUID+06)*10,@POINT := @POINT+1,-1325.298, 6324.27, 43.78838,0,20000,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1361.908,6333.863,42.91473,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1374.653,6345.039,42.23245,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1380.988,6351.012,41.40088,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1386.777,6356.614,40.50622,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1401.021,6369.923,39.22643,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1405.866,6374.74,38.51777,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1417.919,6385.975,37.13863,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1420.83,6388.933,36.39534,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1432.503,6400.78,35.28744,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1438.209,6406.566,34.57018,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1448.355,6417.047,33.47414,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1458.702,6427.233,32.2258,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1466.381,6434.671,31.23962,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1475.041,6442.662,30.76212,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1482.087,6449.107,30.03783,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1492.048,6460.012,29.59447,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1498.249,6466.949,29.06971,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1505.504,6479.773,27.49609,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1510.314,6490.878,25.71376,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1513.284,6500.401,23.8247,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1517.095,6514.258,23.00713,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1519.037,6529.052,22.07376,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1519.89,6532.946,21.64196,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1523.678,6552.211,20.64897,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1526.459,6563.681,20.64311,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1527.088,6576.715,20.44001,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1527.25,6588.595,20.49604,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1522.972,6593.719,20.72314,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1519.17,6604.853,21.03719,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1519.057,6623.997,21.66499,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1517.823,6626.511,21.79336,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1515.169,6637.853,22.81165,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1512.427,6650.387,23.70753,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1508.854,6662.672,24.46819,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1502.337,6681.211,24.6262,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1497.989,6692.215,24.5152,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1493.342,6703.426,24.63262,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1488.407,6714.075,24.44316,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1483.451,6724.766,24.39556,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1479.773,6731.986,24.80669,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1474.442,6742.433,25.19432,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1472.166,6746.609,25.7476,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1467.675,6754.612,26.72865,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1458.197,6771.545,27.48715,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1452.299,6781.779,28.68779,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1446.893,6790.88,29.0572,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1437.404,6803.47,28.13591,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1436.547,6803.941,28.29537,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1427.776,6816.596,27.67589,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1420.213,6831.984,27.09953,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1413.353,6843.065,27.26216,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1406,6852.297,27.6003,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1396.472,6860.553,28.81346,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1391.937,6862.945,28.96782,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1378.505,6871.798,29.84812,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1368.653,6880.533,29.83139,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1363.03,6885.771,30.37303,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1355.941,6892.935,31.19475,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1345.186,6904.807,31.7437,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1334.584,6914.144,31.65829,0,0,1,0,0,0),
((@CGUID+06)*10,@POINT := @POINT+1,-1322.627,6911.815,32.51368,2.703437,50000000,1,0,0,0),

((@CGUID+07)*10,@POINT := @POINT+1,-1321.754, 6328.901, 41.62631,0,20000,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1363.824,6335.642,43.18006,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1367.532,6339.687,42.49469,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1380.589,6351.53,41.40108,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1384.635,6355.611,40.75982,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1394.609,6365.187,39.9352,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1406.167,6375.746,38.3701,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1413.226,6382.483,37.68437,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1422.299,6391.198,36.60815,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1431.174,6400.623,35.34938,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1437.401,6406.901,34.66608,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1442.998,6412.431,34.03405,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1455.305,6424.911,32.85349,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1464.485,6433.617,31.67649,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1466.622,6435.914,31.27636,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1478.637,6446.881,30.35589,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1484.988,6453.343,29.77198,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1496.301,6465.876,29.07766,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1504.334,6478.234,27.72208,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1509.015,6489.258,26.03633,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1512.598,6499.547,24.256,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1513.652,6503.067,23.52419,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1517.402,6521.195,22.66558,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1518.43,6528.76,21.92763,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1522.037,6548.449,20.92362,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1524.814,6559.92,20.59037,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1526.32,6572.684,20.53047,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1526.482,6584.563,20.43049,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1526.42,6597.86,20.69001,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1519.963,6605.205,21.00993,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1519.591,6620.319,21.0576,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1517.531,6626.107,21.74467,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1515.495,6634.917,22.55741,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1512.44,6647.406,23.40374,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1509.398,6658.883,24.10394,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1503.16,6677.19,24.61741,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1498.812,6688.194,24.48883,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1494.395,6699.459,24.31915,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1489.46,6710.108,24.41777,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1484.505,6720.799,24.35967,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1480.978,6728.063,24.67559,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1476.514,6736.513,25.30963,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1472.124,6745.334,25.66236,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1466.02,6756.479,26.92971,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1458.721,6769.361,27.14414,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1453.228,6778.674,28.32249,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1450.315,6783.542,28.74957,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1439.5,6800.013,28.5634,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1436.334,6803.384,28.27963,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1427.068,6816.092,27.68509,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1421.5,6827.609,27.3265,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1415.314,6839.459,27.16231,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1407.96,6848.691,27.38716,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1401.463,6855.691,28.08788,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1389.879,6863.914,29.1686,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1382.767,6867.549,29.61892,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1371.147,6877.273,29.73129,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1362.207,6885.481,30.25134,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1355.52,6892.045,30.93396,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1351.276,6896.914,31.4434,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1339.372,6909.605,31.79743,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1327.955,6917.349,32.14788,0,0,1,0,0,0),
((@CGUID+07)*10,@POINT := @POINT+1,-1314.081,6923.662,33.38514,2.331536,50000000,1,0,0,0),

((@CGUID+08)*10,@POINT := @POINT+1,-1336.72, 6309.458, 46.23232,0,20000,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1356.145,6332.302,43.40115,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1364.42,6340.505,42.69855,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1371.569,6347.124,42.21515,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1380.569,6356.029,41.34633,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1392.035,6366.903,40.15483,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1399.837,6374.239,39.07078,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1409.898,6383.486,37.99396,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1418.975,6392.333,36.75255,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1423.055,6396.651,36.05185,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1435.306,6409.424,35.18626,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1438.91,6412.784,34.33749,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1451.973,6426.07,33.13849,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1459.658,6433.544,32.40159,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1468.793,6442.378,31.23444,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1473.118,6446.19,30.62062,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1480.416,6453.123,29.88379,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1490.209,6463.719,29.06587,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1499.841,6476.373,28.08873,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1505.097,6488.159,26.31472,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1508.56,6497.284,24.97636,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1511.203,6506.818,23.98714,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1514.122,6520.388,22.96544,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1514.864,6527.256,22.52153,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1518.363,6546.622,21.38066,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1520.082,6554.287,21.28659,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1523.14,6570.088,20.69001,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1522.832,6579.914,20.5603,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1524.179,6594.422,20.7082,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1520.75,6605.702,20.9326,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1517.351,6616.88,21.0576,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1514.478,6626.123,21.90445,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1511.412,6638.479,22.90358,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1510.284,6642.396,23.00464,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1507.214,6655.433,23.98821,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1502.887,6668.721,24.71677,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1496.857,6684.585,24.37945,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1492.652,6695.744,24.19415,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1487.717,6706.392,24.35918,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1482.761,6717.083,24.02666,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1479.379,6724.283,24.27056,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1474.643,6733.743,25.07562,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1469.978,6743.022,25.55116,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1466.778,6748.466,26.04319,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1460.668,6759.355,26.73457,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1455.618,6768.268,27.25087,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1447.447,6782.421,28.36941,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1438.87,6795.957,28.37095,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1434.356,6800.853,28.01996,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1424.343,6813.511,27.45817,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1419.461,6824.308,26.97453,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1414.499,6835.437,26.9521,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1407.145,6844.669,27.09224,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1401.381,6852.377,27.69153,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1391.105,6859.356,28.94751,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1383.203,6863.225,29.20696,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1377.708,6867.614,29.69486,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1362.461,6881.135,30.49602,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1353.834,6889.062,30.55615,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1346.1,6897.9,30.8667,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1344.104,6900.306,31.19846,0,0,1,0,0,0),
((@CGUID+08)*10,@POINT := @POINT+1,-1325.029,6908.24,32.16651,2.752744,50000000,1,0,0,0),

((@CGUID+09)*10,@POINT := @POINT+1,-1339.819, 6305.84, 45.90306,0,20000,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1353.48,6334.996,43.66293,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1362.379,6343.898,42.91652,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1367.995,6349.569,42.41758,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1377.233,6358.242,41.58788,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1388.462,6369.133,40.42139,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1399.024,6379.229,39.05355,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1406.374,6386.012,38.21695,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1414.845,6394.005,37.23859,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1420.882,6400.272,36.36848,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1430.344,6410.01,35.60098,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1440.757,6420.681,34.60674,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1445.65,6425.55,34.0351,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1452.061,6431.742,33.1847,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1461.734,6441.119,32.12207,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1468.27,6447.396,31.4397,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1482.441,6460.692,29.94483,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1488.617,6467.914,29.13134,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1493.086,6474.166,28.36966,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1501.126,6489.077,26.41469,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1504.175,6497.065,25.4574,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1507.244,6508.102,24.20155,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1509.338,6516.578,23.3781,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1510.842,6531.006,22.51495,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1514.373,6547.584,21.8433,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1516.34,6556.983,21.71647,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1518.615,6568.801,21.1698,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1518.762,6576.452,20.7382,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1520.253,6593.228,20.56501,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1517.116,6602.806,21.31131,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1513.424,6615.687,20.98766,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1510.267,6626.063,22.00375,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1508.344,6634.278,23.1557,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1507.029,6645.714,23.42168,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1503.431,6656.319,24.25469,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1499.531,6666.327,24.6426,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1493.04,6683.077,24.71661,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1488.928,6694.018,24.46026,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1483.993,6704.666,24.63152,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1479.038,6715.357,24.42681,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1475.725,6722.415,24.52056,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1472.728,6728.397,25.43655,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1465.142,6743.202,25.48757,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1460.47,6751.648,26.24237,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1456.114,6759.298,26.59552,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1451.801,6766.744,27.27498,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1441.826,6783.814,28.01914,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1435.78,6793.256,28.14414,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1427.951,6802.209,27.77189,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1420.604,6811.819,27.59953,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1416.269,6821.467,27.32209,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1411.288,6832.88,26.89982,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1404.953,6840.652,27.33624,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1402.676,6843.914,27.67545,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1393.608,6852.47,28.47785,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1381.98,6859.235,29.29785,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1374.512,6865.038,30.02347,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1361.955,6876.102,30.91434,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1350.745,6886.359,31.10339,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1343.011,6895.198,31.09607,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1339.523,6899.669,31.71791,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1329.859,6907.137,32.01398,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1323.755,6911.395,32.40355,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1316.075,6920.817,33.43444,0,0,1,0,0,0),
((@CGUID+09)*10,@POINT := @POINT+1,-1310.894,6927.241,33.46534,2.397198,50000000,1,0,0,0),

((@CGUID+10)*10,@POINT := @POINT+1,-1341.407, 6302.393, 45.42799,0,20000,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1356.481,6342.938,43.68281,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1363.912,6349.947,42.85905,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1366.549,6352.468,42.10332,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1380.979,6366.597,41.29876,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1386.748,6372.003,40.48656,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1398.057,6382.577,39.40562,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1405.383,6389.329,38.26128,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1409.753,6393.589,37.33056,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1423.213,6407.106,36.67622,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1428.669,6412.862,35.93699,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1433.392,6417.77,35.1549,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1448.793,6433.094,33.939,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1457.254,6441.08,32.99157,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1465.784,6449.263,32.03704,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1468.854,6452.028,31.38842,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1480.479,6463.497,30.03848,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1488.483,6472.706,29.03189,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1492.575,6479.296,28.29099,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1498.857,6492.003,26.45962,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1503.028,6503.524,24.94066,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1505.62,6514.442,24.0824,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1506.442,6518.199,23.33497,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1509.159,6539.377,22.88285,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1511.308,6548.729,22.50923,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1514.715,6562.369,22.19242,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1515.34,6570.028,21.6797,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1515.469,6574.358,21.28422,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1516.477,6594.837,20.65022,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1516.902,6604.506,21.0576,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1514.445,6616.547,21.24002,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1508.058,6625.792,21.91331,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1506.093,6631.804,23.22029,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1503.04,6642.187,23.83239,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1499.573,6656.231,24.7088,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1493.495,6673.371,25.03741,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1489.146,6684.375,25.18414,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1484.966,6695.089,24.83734,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1480.031,6705.738,24.9793,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1480.376,6710.648,24.69341,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1471.724,6723.333,25.10112,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1470.277,6726.524,25.60709,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1461.107,6743.953,25.84206,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1455.313,6754.208,26.23757,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1453.078,6758.27,26.84344,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1448.506,6765.93,27.46867,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1437.778,6784.493,27.84568,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1431.677,6793.172,28.20726,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1423.848,6802.126,27.98259,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1416.842,6812.671,27.47453,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1414.297,6818.924,27.30181,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1407.185,6832.984,26.72453,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1400.904,6840.816,28.24083,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1400.227,6841.266,28.28441,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1386.227,6853.785,29.51977,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1374.765,6860.334,30.52347,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1366.714,6869.74,30.79688,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1357.342,6876.917,31.34941,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1352.119,6882.848,31.68382,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1338.908,6895.112,31.57471,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1332.152,6902.58,31.87061,0,0,1,0,0,0),
((@CGUID+10)*10,@POINT := @POINT+1,-1326.822,6904.981,32.16651,2.455589,50000000,1,0,0,0),

((@CGUID+11)*10,@POINT := @POINT+1,-1313.597, 6337.389, 37.4875,0,20000,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1359.693,6346.81,43.19638,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1364.922,6352.55,42.59476,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1369.896,6357.029,41.85905,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1381.821,6368.407,40.9967,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1391.916,6377.785,39.96706,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1400.53,6385.863,39.10284,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1406.36,6391.117,37.89444,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1413.876,6398.687,37.02804,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1424.018,6409.253,36.37014,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1433.688,6419,35.56779,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1437.977,6423.128,34.93929,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1446.935,6432.176,33.93854,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1456.124,6440.876,33.02568,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1466.673,6450.998,31.70663,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1475.548,6459.017,30.87277,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1484.04,6468.685,29.51413,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1487.605,6472.462,29.06737,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1495.546,6485.818,27.76912,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1498.868,6494.208,26.57964,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1502.378,6505.083,25.10668,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1505.957,6518.528,23.62728,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1506.435,6521.307,23.20864,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1509.414,6543.474,22.99638,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1510.507,6547.068,22.54298,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1514.974,6566.465,21.8892,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1514.887,6574.351,21.43412,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1515.179,6579.391,20.93638,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1514.619,6598.497,21.06501,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1516.263,6604.566,21.04718,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1514.327,6616.664,21.30777,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1507.054,6628.653,22.35204,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1502.045,6643.439,23.70916,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1501.096,6647.112,24.02633,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1497.411,6660.161,24.85114,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1492.361,6674.188,25.39454,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1486.998,6687.872,25.31915,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1482.62,6698.457,25.09234,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1477.685,6709.105,25.07549,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1476.32,6716.775,24.97911,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1470.686,6724.645,25.53253,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1469.197,6727.644,25.71964,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1458.498,6747.121,26.23098,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1453.149,6756.342,26.57982,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1447.825,6766.161,27.63328,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1443.567,6773.123,27.92666,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1435.113,6787.614,28.14414,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1428.479,6795.746,28.33226,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1420.651,6804.699,27.93254,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1415.639,6814.097,27.74125,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1412.37,6821.203,27.2022,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1404.11,6835.702,26.98396,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1399.67,6841.119,28.38387,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1389.798,6851.24,28.69209,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1383.237,6854.666,29.92945,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1374.695,6860.173,30.43272,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1360.469,6870.775,31.4648,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1364.687,6855.429,32.22691,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1343.444,6888.847,31.55615,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1335.71,6897.685,31.68115,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1328.344,6904.109,31.89698,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1319.173,6909.735,32.70131,0,0,1,0,0,0),
((@CGUID+11)*10,@POINT := @POINT+1,-1308.543,6930.477,33.48413,2.578252,50000000,1,0,0,0),

((@CGUID+12)*10,@POINT := @POINT+1,-1317.676, 6332.954, 39.39396,0,20000,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1359.257,6345.074,43.34771,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1368.19,6352.651,42.49956,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1375.154,6358.975,41.6422,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1383.779,6367.35,40.95704,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1396.65,6379.477,39.46555,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1403.281,6385.548,38.55353,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1412.604,6394.293,37.48947,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1418.6,6400.475,36.68916,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1427.218,6409.628,35.92756,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1437.633,6420.145,35.16815,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1445.191,6427.698,34.26686,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1450.923,6433.204,33.47472,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1458.861,6440.643,32.50407,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1468.669,6449.949,31.56035,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1480.044,6460.676,30.33904,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1485.207,6466.816,29.43354,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1495.248,6478.29,28.2853,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1497.596,6485.762,27.17497,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1503.672,6500.326,25.22203,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1504.671,6504.808,24.54926,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1509.076,6522.18,23.12732,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1510.112,6534.35,22.4539,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1512.242,6546.448,22.09916,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1514.545,6556.838,22.00279,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1517.014,6566.905,21.35402,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1517.121,6576.429,20.90148,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1517.534,6592.283,20.56501,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1518.955,6593.444,20.68521,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1512.585,6611.89,21.36403,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1508.72,6624.953,21.73949,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1506.413,6634.521,23.35396,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1507.465,6638.425,23.13417,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1500.776,6656.853,24.52659,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1499.383,6658.492,24.59208,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1491.949,6680.928,24.94891,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1487.6,6691.932,24.61969,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1482.987,6702.544,24.90264,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1478.052,6713.193,24.7166,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1473.097,6723.884,24.85259,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1470.751,6728.055,25.65412,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1464.127,6741.162,25.6028,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1458.537,6751.225,25.98757,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1455.162,6756.965,26.59436,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1451.703,6763.026,27.24188,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1441.028,6781.611,27.76914,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1435.079,6791.719,28.14414,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1427.685,6799.772,28.08226,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1419.856,6808.726,27.72453,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1416.225,6817.652,27.46122,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1410.866,6829.031,26.88726,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1403.508,6839.725,27.26216,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1401.932,6841.426,27.75581,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1390.278,6852.666,28.81154,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1384.662,6856.315,29.36012,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1369.815,6866.48,30.70022,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1363.649,6872.149,31.21793,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1350.489,6883.946,31.42383,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1342.648,6892.873,31.25073,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1334.913,6901.711,31.64841,0,0,1,0,0,0),
((@CGUID+12)*10,@POINT := @POINT+1,-1329.679,6901.374,32.04248,2.519927,50000000,1,0,0,0),

((@CGUID+13)*10,@POINT := @POINT+1,-1346.398, 6323.436, 44.13105,0,18000,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1375.75,6352.643,41.81343,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1386.413,6362.125,40.76291,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1394.859,6370.748,39.64816,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1402.946,6378.722,38.64111,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1408.646,6384.408,37.85543,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1416.046,6392.416,36.95772,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1424.231,6400.856,35.89214,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1438.505,6414.223,34.73194,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1447.235,6422.037,33.93885,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1455.295,6429.046,32.72091,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1458.611,6432.946,32.30492,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1467.951,6443.736,31.22492,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1475.274,6451.741,30.49423,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1487.13,6465.033,29.41993,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1494.225,6473.047,28.60011,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1498.577,6483.967,27.50839,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1502.863,6493.575,25.85901,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1508.28,6506.335,24.16001,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1509.035,6510.974,23.54728,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1511.6,6522.404,22.68517,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1514.619,6536.917,22.02852,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1517.407,6553.438,21.25566,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1519.008,6565.207,21.03715,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1519.755,6571.952,20.86309,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1519.178,6588.365,20.44001,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1517.295,6600.117,20.9326,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1515.428,6611.833,21.1826,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1513.559,6623.591,21.45103,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1512.845,6627.281,21.88989,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1510.815,6637.101,22.88312,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1508.53,6651.39,23.69955,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1506.259,6664.806,24.5883,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1498.989,6679.93,24.34894,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1493.872,6690.641,24.31915,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1488.799,6701.26,24.39556,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1484.892,6712.443,24.14556,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1480.606,6723.452,24.27056,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1475.714,6732.932,24.9554,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1470.24,6742.168,25.22824,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1463.485,6753.477,26.435,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1461.195,6757.306,26.60432,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1454.66,6768.044,27.35494,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1446.97,6779.56,28.1712,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1439.703,6790.031,28.26914,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1431.824,6798.763,27.95726,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1425.258,6805.846,27.74768,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1419.951,6818.376,27.18107,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1415.991,6828.374,27.02785,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1411.301,6840.22,27.01216,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1406.986,6850.981,27.51216,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1395.876,6852.983,28.06596,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1386.497,6858.125,29.04535,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1377.48,6865.975,29.5562,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1369.061,6873.784,30.05341,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1359.177,6883.299,30.66475,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1350.448,6892.708,30.55615,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1343.185,6900.402,31.31773,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1334.397,6909.835,31.33322,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1332.969,6914.566,31.75934,0,0,1,0,0,0),
((@CGUID+13)*10,@POINT := @POINT+1,-1327.05,6931.745,31.9987,-0.4967001,50000000,1,0,0,0),

((@CGUID+14)*10,@POINT := @POINT+1,-1343.658, 6326.059, 44.25003,0,18000,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1378.534,6350.313,41.66693,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1388.357,6359.078,40.54196,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1398.773,6369.112,39.55496,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1406.175,6376.542,38.37215,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1412.92,6383.467,37.59019,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1418.568,6389.211,36.75541,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1431.257,6402.656,35.61509,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1439.397,6409.976,34.48,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1445,6414.716,33.94336,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1456.038,6424.469,32.72306,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1459.961,6429.107,32.03804,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1468.075,6438.094,31.00072,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1478.442,6449.612,30.19709,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1486.321,6458.416,29.59192,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1492.912,6465.67,28.97868,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1500.022,6478.217,27.64638,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1506.207,6491.387,25.75857,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1510.741,6502.491,24.13481,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1511.523,6505.471,23.73208,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1515.01,6520.876,22.84591,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1517.076,6529.952,21.94379,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1520.715,6551.218,21.36644,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1522.64,6563.296,20.85136,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1524.231,6575,20.56501,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1523.208,6587.589,20.44001,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1521.325,6599.341,20.81501,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1519.458,6611.052,21.0576,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1517.589,6622.81,21.25951,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1516.886,6626.5,21.74069,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1514.855,6638.132,22.83069,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1511.569,6656.433,24.13942,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1510.797,6661.103,24.48184,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1503.074,6680.326,24.60838,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1497.957,6691.036,24.38653,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1492.884,6701.656,24.49053,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1488.996,6712.535,24.32927,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1484.71,6723.543,24.39556,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1479.312,6734.657,24.96642,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1474.186,6743.023,25.43917,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1468.801,6752.157,26.63392,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1466.015,6756.524,26.82364,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1457.199,6771.321,27.56836,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1452.714,6778,28.1131,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1443.589,6791.209,28.56992,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1435.599,6800.373,28.09538,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1431.061,6805.124,27.90274,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1424.054,6818.486,27.32915,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1419.752,6829.417,26.97453,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1415.403,6840.348,27.17305,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1411.088,6851.117,27.51216,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1398.206,6856.158,28.38711,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1395.161,6857.694,28.75363,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1382.798,6866.727,29.61779,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1370.541,6877.841,29.67905,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1362.016,6885.826,30.30615,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1356.169,6892.381,30.76448,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1351.74,6897.006,31.26509,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1338.171,6911.449,31.49594,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1334.682,6918.354,32.19947,0,0,1,0,0,0),
((@CGUID+14)*10,@POINT := @POINT+1,-1331.262,6925.238,32.00757,-0.4495628,50000000,1,0,0,0),

((@CGUID+15)*10,@POINT := @POINT+1,-1341.659, 6328.948, 44.39948,0,18000,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1380.612,6349.274,41.58778,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1385.343,6353.736,40.93915,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1397.229,6364.835,40.12361,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1403.984,6371.511,39.07477,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1412.692,6380.291,37.90898,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1420.837,6389.006,36.80255,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1430.494,6398.682,35.75403,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1436.734,6404.804,34.78491,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1442.952,6410.318,33.9302,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1456.231,6421.826,32.75629,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1464.758,6431.269,31.73908,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1466.817,6433.488,31.08584,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1480.376,6448.64,30.41516,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1484.741,6453.449,29.78321,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1494.131,6463.981,29.18576,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1501.111,6475.72,28.12764,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1506.504,6487.33,26.4983,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1511.44,6498.415,24.56813,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1513.386,6505.983,23.74737,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1516.659,6518.935,22.72642,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1519.553,6532.539,21.69878,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1521.607,6544.357,21.18198,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1524.195,6559.498,20.66459,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1525.786,6571.201,20.56501,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1525.797,6584.404,20.44001,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1523.914,6596.157,20.66633,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1519.333,6600.693,20.9326,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1520.173,6619.622,21.0576,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1518.731,6626.779,21.80373,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1517.421,6633.771,22.55753,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1514.69,6651.229,24.08424,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1513.437,6656.185,24.46212,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1506.458,6678.003,24.86069,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1501.341,6688.714,24.69895,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1496.268,6699.333,24.43365,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1492.893,6708.465,25.2211,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1487.911,6720.975,24.91521,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1482.895,6732.655,25.03032,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1476.822,6742.843,25.44615,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1473.385,6748.403,26.21559,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1469.606,6754.548,27.15837,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1465.293,6766.604,27.83254,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1455.3,6778.652,28.62343,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1453.138,6781.721,28.85696,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1439.526,6799.18,28.53892,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1436.493,6802.1,28.2517,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1427.267,6815.933,27.50004,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1422.961,6826.859,27.2924,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1418.628,6837.809,27.28462,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1413.37,6841.077,27.26216,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1403.026,6854.753,27.89473,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1391.112,6862.237,28.9684,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1385.771,6866.773,29.46068,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1378.875,6873.118,29.87896,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1365.895,6885.013,29.97705,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1363.382,6887.824,30.50175,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1354.931,6896.595,31.29555,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1343.919,6902.882,31.2645,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1336.662,6915.724,31.84787,0,0,1,0,0,0),
((@CGUID+15)*10,@POINT := @POINT+1,-1325.15,6934.722,31.59662,-0.7155372,50000000,1,0,0,0),

((@CGUID+16)*10,@POINT := @POINT+1,-1342.175, 6320.706, 44.54397,0,18000,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1372.273,6342.793,42.46829,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1383.514,6352.7,41.29501,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1387.597,6356.548,40.48121,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1401.675,6370.026,39.38797,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1406.577,6375.133,38.40147,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1418.743,6387.831,36.8916,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1427.17,6396.301,35.9618,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1435.577,6404.816,34.91903,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1438.604,6407.3,34.29092,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1449.016,6416.472,33.43275,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1458.147,6425.441,32.39808,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1465.064,6432.76,31.51849,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1477.103,6446.082,30.67208,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1481.972,6451.62,29.98962,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1490.895,6461.439,29.24962,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1499.37,6473.488,28.39513,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1502.818,6481.416,27.19888,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1508.669,6494.02,25.3214,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1513.487,6508.12,23.68432,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1515.776,6518.226,23.12634,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1518.476,6530.767,21.98259,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1518.956,6532.777,21.61776,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1522.944,6555.589,20.74931,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1524.535,6567.292,20.69001,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1525.733,6580.3,20.44001,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1523.849,6592.053,20.56501,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1521.973,6603.761,20.8076,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1520.104,6615.518,21.0576,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1518.202,6626.26,21.83834,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1516.171,6638.447,22.79996,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1515.399,6643.262,23.21204,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1512.422,6658.966,24.61795,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1508.42,6670.814,25.09698,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1502.44,6684.759,24.70554,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1497.367,6695.379,24.44073,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1493,6705.942,24.89348,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1488.714,6716.95,24.95012,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1484.352,6728.818,25.10112,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1480.346,6735.334,25.34388,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1473.339,6747.305,25.85029,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1467.821,6756.479,27.10916,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1465.279,6766.771,27.75237,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1455.377,6777.396,28.34966,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1456.42,6776.755,28.24479,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1441.767,6795.742,28.64548,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1435.939,6801.635,28.20957,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1428.646,6811.188,27.97573,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1423.775,6822.836,27.34953,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1419.466,6833.791,27.13716,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1415.164,6844.568,27.38716,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1404.544,6854.381,27.60042,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1398.603,6856.841,28.29176,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1388.402,6863.486,29.21328,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1381.444,6869.968,29.5867,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1368.356,6881.729,29.81626,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1362.995,6887.222,30.43941,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1357.201,6893.19,31.05112,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1346.377,6904.452,31.80281,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1336.479,6911.624,31.3558,0,0,1,0,0,0),
((@CGUID+16)*10,@POINT := @POINT+1,-1333.499,6921.922,32.06613,-0.647477,50000000,1,0,0,0),

((@CGUID+17)*10,@POINT := @POINT+1,-1339.956, 6323.307, 44.4758,0,18000,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1368.229,6343.505,42.38843,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1376.405,6350.433,41.51878,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1385.077,6358.317,40.85873,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1396.861,6369.953,39.58881,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1404.479,6377.443,38.51379,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1414.66,6388.139,37.20406,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1418.349,6391.627,36.76189,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1431.219,6405.005,35.39329,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1438.439,6411.544,34.69069,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1444.181,6416.549,34.01598,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1456.311,6427.807,32.57023,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1464.313,6436.554,31.73014,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1469,6441.723,30.99605,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1477.396,6451.247,30.28961,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1485.232,6460.004,29.57026,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1495.834,6472.948,28.39309,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1499.167,6480.516,27.4149,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1505.23,6493.864,25.51022,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1509.711,6505.815,24.04025,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1510.595,6509.879,23.64782,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1513.831,6524.116,22.76105,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1515.901,6532.979,21.90339,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1519.473,6553.398,21.25566,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1521.064,6565.102,20.88066,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1522.507,6575.797,20.70988,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1521.163,6588.951,20.44001,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1519.275,6600.605,20.9326,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1517.413,6612.419,21.0576,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1515.518,6624.047,21.50572,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1514.58,6628.744,21.90982,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1512.566,6640.292,22.85365,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1510.559,6652.706,23.68124,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1507.507,6664.105,24.4008,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1500.74,6681.023,24.50169,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1495.667,6691.643,24.31915,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1491.027,6702.343,24.39556,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1486.741,6713.351,24.15691,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1483.002,6724.942,24.72393,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1476.963,6735.037,24.9149,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1473.484,6740.938,25.39617,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1466.005,6753.583,26.57142,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1462.96,6758.391,26.76372,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1455.813,6770.197,27.49258,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1451.966,6775.794,27.83999,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1441.275,6791.667,28.26914,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1433.286,6800.193,27.90617,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1428.875,6805.096,27.80177,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1421.812,6819.231,27.22453,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1417.525,6830.174,26.82341,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1413.23,6840.947,27.13716,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1405.411,6850.369,27.51216,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1398.093,6853.629,28.15615,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1392.859,6856.943,28.67517,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1380.59,6866.38,29.42494,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1368.13,6877.631,29.83994,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1359.903,6885.618,30.30615,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1351.923,6894.134,30.61035,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1345.898,6900.377,31.35025,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1333.704,6908.6,31.27341,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1333.241,6917.5,31.90567,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1332.708,6919.739,32.08533,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1324.533,6934.592,31.75507,0,0,1,0,0,0),
((@CGUID+17)*10,@POINT := @POINT+1,-1322.315,6938.502,31.12214,-0.647477,50000000,1,0,0,0),

((@CGUID+18)*10,@POINT := @POINT+1,-1337.861, 6326.29, 44.63207,0,18000,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1364.772,6345.735,42.80714,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1373.721,6353.521,41.99775,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1387.278,6366.063,40.59365,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1392.797,6371.437,39.77093,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1403.06,6381.823,38.73808,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1410.467,6389.75,37.63493,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1414.636,6393.965,36.7886,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1423.64,6402.972,36.05109,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1432.655,6411.805,35.17282,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1445.957,6423.377,33.95522,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1454.444,6431.731,33.02517,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1462.44,6440.473,32.03544,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1470.026,6449.052,31.41499,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1475.17,6454.822,30.95397,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1483.699,6464.271,29.8011,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1491.675,6474.137,28.81781,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1496.74,6485.046,27.3991,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1499.738,6492.024,26.34745,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1505.32,6505.56,24.59105,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1508.117,6517.336,23.43144,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1509.333,6522.255,23.00387,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1512.363,6536.441,22.17827,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1515.406,6553.952,21.59428,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1516.998,6565.655,21.27836,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1517.698,6570.252,21.03073,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1517.11,6588.301,20.57429,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1515.579,6598.076,21.34782,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1514.088,6610.3,21.32484,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1511.476,6623.333,21.54515,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1509.906,6632.761,22.80927,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1509.058,6635.81,23.06611,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1506.276,6652.978,23.78559,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1502.883,6666.354,24.59722,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1497.037,6679.254,24.66412,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1491.964,6689.874,24.31915,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1487.203,6700.854,24.3687,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1482.917,6711.862,24.02227,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1479.477,6722.841,24.27056,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1473.851,6732.225,25.08501,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1470.531,6737.682,25.33077,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1464.446,6748.051,25.89157,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1459.438,6756.29,26.52866,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1452.879,6767.207,27.27745,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1449.322,6772.238,27.66038,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1438.278,6788.863,28.14414,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1430.284,6797.393,28.08263,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1422.313,6806.797,27.60637,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1417.992,6817.732,27.1591,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1414.596,6826.728,27.01875,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1409.422,6839.417,27.01216,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1403.775,6846.313,27.63791,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1396.692,6849.87,28.08527,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1385.115,6857.051,29.32163,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1375.624,6865.091,29.95016,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1370.572,6869.667,30.18852,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1356.908,6882.812,30.66455,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1348.929,6891.328,30.60046,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1341.654,6899.07,31.40217,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1333.316,6905.102,31.73031,0,0,1,0,0,0),
((@CGUID+18)*10,@POINT := @POINT+1,-1335.736,6918.606,32.00241,-0.7702758,50000000,1,0,0,0),

((@CGUID+19)*10,@POINT := @POINT+1,-1338.36, 6318.153, 45.01073,0,18000,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1366.543,6351.105,42.68403,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1371.533,6355.523,42.09822,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1385.443,6368.981,40.6408,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1395.111,6378.121,39.68797,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1401.881,6385.123,38.72647,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1408.552,6392.328,37.76111,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1416.718,6400.788,36.93539,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1425.904,6409.821,36.24522,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1434.806,6417.924,35.38934,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1443.599,6425.717,34.32959,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1449.083,6431.053,33.56381,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1457.52,6439.897,32.70525,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1465.884,6449.283,31.82249,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1475.257,6459.549,30.88913,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1482.354,6467.568,29.99044,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1490.457,6478.491,28.95247,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1495.564,6489.765,27.24007,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1498.951,6497.493,26.42055,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1502.904,6509.288,24.59679,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1504.438,6515.886,24.09046,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1508.089,6532.022,22.93646,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1511.046,6545.221,22.47978,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1511.188,6547.367,22.46651,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1513.87,6567.742,22.36155,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1514.555,6574.309,21.56895,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1513.588,6590.408,20.8719,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1511.71,6602.129,21.02513,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1515.465,6610.355,21.32606,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1508.023,6624.962,21.99387,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1507.305,6630.812,22.88379,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1502.065,6645.726,23.84869,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1501.956,6648.019,24.02696,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1498.538,6668.55,24.92349,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1493.063,6680.28,24.91315,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1487.99,6690.899,24.63922,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1483.316,6702.171,24.94744,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1479.03,6713.18,24.42827,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1475.426,6723.497,24.52056,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1472.072,6728.462,25.23941,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1463.461,6743.594,25.55983,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1457.324,6753.719,26.04616,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1453.892,6759.395,26.72756,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1449.559,6766.19,27.40085,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1440.567,6779.784,27.76914,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1434.18,6788.641,28.14414,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1426.186,6797.178,28.27855,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1418.42,6808.097,27.79228,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1415.963,6815.124,27.51456,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1411.446,6825.967,26.9746,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1405.521,6840.692,27.03707,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1402.425,6841.922,27.65872,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1392.36,6848.608,28.49327,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1383.227,6854.804,29.80693,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1373.103,6863.215,30.30895,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1365.268,6870.637,30.89865,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1352.81,6882.587,31.15894,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1344.83,6891.103,31.11914,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1336.76,6899.715,31.68115,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1326.483,6909.889,32.31619,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1325.027,6921.406,31.72394,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1321.302,6936.862,31.40089,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1320.953,6938.078,31.34834,0,0,1,0,0,0),
((@CGUID+19)*10,@POINT := @POINT+1,-1320.078,6941.819,31.07783,-0.4417686,50000000,1,0,0,0),

((@CGUID+20)*10,@POINT := @POINT+1,-1336.097, 6321.046, 44.63943,0,18000,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1370.502,6355.803,42.25064,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1380.13,6364.811,41.54261,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1386.938,6371.178,40.70809,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1397.002,6380.986,39.58918,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1403.385,6387.948,38.50368,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1413.577,6398.449,37.25796,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1422.063,6406.963,36.73124,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1430.369,6414.89,35.83902,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1433.165,6417.463,35.16513,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1447.673,6430.199,34.06244,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1450.407,6433.349,33.52631,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1460.509,6444.11,32.54182,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1467.069,6451.264,31.76574,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1475.899,6461.506,30.59028,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1486.507,6473.29,29.33908,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1491.514,6482.734,28.33359,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1496.431,6493.94,26.91046,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1500.691,6503.52,25.34488,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1502.961,6512.604,24.74237,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1506.207,6525.995,23.50779,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1508.052,6535.492,22.99776,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1510.246,6546.973,22.54517,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1512.071,6560.218,22.83521,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1513.472,6569.841,22.21292,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1513.806,6575.564,21.33661,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1512.245,6594.287,21.09675,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1510.371,6606.009,20.98973,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1509.369,6612.409,21.33319,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1506.946,6625.794,21.89964,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1504.622,6639.592,23.56047,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1503.587,6646.04,23.87176,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1501.306,6658.846,24.68228,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1497.472,6668.724,24.93933,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1490.677,6683.62,25.0003,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1485.604,6694.239,24.86297,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1481.185,6705.679,24.84087,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1476.899,6716.688,24.66521,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1472.744,6726.604,24.97881,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1471.711,6727.618,25.49656,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1460.75,6746.675,25.84645,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1456.739,6753.44,26.31558,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1452.209,6760.691,26.80779,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1445.248,6771.42,27.56945,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1437.656,6782.677,27.76914,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1430.971,6791.019,28.33226,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1429.988,6797.279,28.09618,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1417.094,6810.665,27.86192,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1414.659,6817.459,27.35814,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1409.454,6829.344,26.97355,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1404.38,6841.547,27.32084,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1401.402,6842.54,27.87748,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1389.501,6849.632,29.05975,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1375.869,6859.638,30.38395,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1372.46,6862.975,30.57833,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1357.812,6876.392,31.20166,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1349.526,6885.049,31.4071,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1341.547,6893.565,31.34277,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1333.476,6902.177,31.64841,0,0,1,0,0,0),
((@CGUID+20)*10,@POINT := @POINT+1,-1337.2,6915.83,31.86057,-0.5087496,50000000,1,0,0,0),

((@CGUID+21)*10,@POINT := @POINT+1,-1333.939, 6323.755, 44.85339,0,18000,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1372.985,6355.595,42.17725,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1380.701,6362.483,41.38876,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1393.165,6374.485,39.9179,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1402.02,6383.17,38.7765,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1406.116,6387.854,38.10735,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1412.967,6394.518,37.09569,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1421.718,6403.776,36.40208,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1433.083,6414.556,35.46972,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1443.613,6423.717,34.36494,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1452.461,6431.774,33.27463,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1456.169,6436.205,32.68983,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1467.681,6449.085,31.61221,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1468.975,6450.537,31.22228,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1480.555,6463.545,30.09472,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1489.658,6473.817,28.77167,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1493.37,6481.848,28.15433,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1499.813,6495.99,26.26503,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1503.464,6504.888,24.87642,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1504.956,6512.256,23.917,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1506.791,6519.463,23.35355,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1511.303,6540.132,22.49645,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1513.397,6552.567,21.83549,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1514.997,6564.336,22.05741,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1515.498,6569.117,21.4177,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1515.803,6579.856,20.84326,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1513.709,6598.121,21.06501,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1515.313,6600.002,21.0576,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1514.25,6616.754,21.18175,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1508.643,6631.316,22.7814,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1510.231,6634.844,22.60852,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1505.241,6651.351,23.9668,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1503.262,6661.042,24.23788,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1497.549,6674.138,24.95181,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1490.997,6687.711,24.55401,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1485.924,6698.331,24.56915,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1481.808,6709.736,24.41008,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1477.522,6720.744,24.40557,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1472.883,6730.477,25.19499,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1468.464,6737.824,25.67717,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1460.654,6750.778,25.8965,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1457.139,6756.591,26.43946,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1452.093,6764.842,27.14405,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1442.268,6779.769,27.95688,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1437.285,6786.764,27.85752,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1429.967,6795.103,28.20726,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1421.984,6803.646,28.02373,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1418.864,6812.066,27.69678,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1413.823,6823.541,27.11336,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1408.24,6837.485,26.88716,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1404.643,6846.632,27.44936,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1396.571,6848.583,27.98872,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1387.114,6853.479,29.23651,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1375.791,6862.607,29.83341,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1373.306,6864.989,30.35759,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1361.352,6876.015,31.13771,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1348.593,6889.046,30.91431,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1340.614,6897.562,31.35022,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1332.543,6906.174,31.57373,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1327.795,6915.716,32.14365,0,0,1,0,0,0),
((@CGUID+21)*10,@POINT := @POINT+1,-1318.258,6944.237,31.36799,-0.3588311,50000000,1,0,0,0);
