-- Update stats
-- 20905,21414,21290 still requires updates
UPDATE `creature_template` SET `speed_run` = 1.42857 WHERE `entry` = 20908; -- Akkiris Lightning-Waker
UPDATE `creature_template` SET `speed_run` = 1.42857 WHERE `entry` = 21617; -- Akkiris Lightning-Waker (1)
UPDATE `creature_template` SET `RangeAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 20869; -- Arcatraz Sentinel
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857, `BaseAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 21586; -- Arcatraz Sentinel (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 0.857143 WHERE `entry` = 21587; -- Arcatraz Warder (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 20911; -- Blackwing Drakonaar
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21588; -- Blackwing Drakonaar (1)
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.42857 WHERE `entry` = 21590; -- Dalliah the Doomsayer (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 20867; -- Death Watcher
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21591; -- Death Watcher (1)
UPDATE `creature_template` SET `minlevel` = 68, `maxlevel` = 69, `speed_walk` = 1, `speed_run` = 0.857143, `BaseAttackTime` = 2000 WHERE `entry` = 21592; -- Defender Corpse (1)
UPDATE `creature_template` SET `speed_walk` = 1 WHERE `entry` = 21761; -- Destroyed Sentinel
UPDATE `creature_template` SET `unit_flags` = 64 WHERE `entry` = 20868; -- Entropic Eye
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857, `BaseAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 21593; -- Entropic Eye (1)
UPDATE `creature_template` SET `unit_flags` = 64 WHERE `entry` = 20880; -- Eredar Deathbringer
UPDATE `creature_template` SET `speed_walk` = 0.888888, `speed_run` = 1.42857, `BaseAttackTime` = 3000, `unit_flags` = 64 WHERE `entry` = 21594; -- Eredar Deathbringer (1)
UPDATE `creature_template` SET `unit_flags` = 64 WHERE `entry` = 20879; -- Eredar Soul-Eater
UPDATE `creature_template` SET `speed_walk` = 0.888888, `speed_run` = 1.42857, `BaseAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 21595; -- Eredar Soul-Eater (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 22346; -- Ethereum Life-Binder (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21596; -- Ethereum Slayer (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21597; -- Ethereum Wave-Caster (1)
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.71429 WHERE `entry` = 21598; -- Gargantuan Abyssal (1)
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.71429 WHERE `entry` = 21599; -- Harbinger Skyriss (1)
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.71429 WHERE `entry` = 21466; -- Harbinger Skyriss
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.71429 WHERE `entry` = 21600; -- Harbinger Skyriss (1)
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.71429 WHERE `entry` = 21467; -- Harbinger Skyriss
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.71429 WHERE `entry` = 21601; -- Harbinger Skyriss (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 0.857143 WHERE `entry` = 21602; -- Millhouse Manastorm (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21604; -- Negaton Screamer (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21605; -- Negaton Warp-Master (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21606; -- Phase-Hunter (1)
UPDATE `creature_template` SET `minlevel` = 68, `maxlevel` = 69, `speed_walk` = 1.2, `speed_run` = 1.42857 WHERE `entry` = 21607; -- Protean Horror (1)
UPDATE `creature_template` SET `speed_walk` = 1.2, `speed_run` = 1.42857 WHERE `entry` = 21608; -- Protean Nightmare (1)
UPDATE `creature_template` SET `speed_walk` = 1.2, `speed_run` = 1.42857 WHERE `entry` = 21395; -- Protean Spawn
UPDATE `creature_template` SET `minlevel` = 68, `maxlevel` = 69, `speed_walk` = 1.2, `speed_run` = 1.42857 WHERE `entry` = 21609; -- Protean Spawn (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21610; -- Sargeron Archer (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21611; -- Sargeron Hellcaller (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 2.42857 WHERE `entry` = 21346; -- Sightless Eye
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 2.42857 WHERE `entry` = 21612; -- Sightless Eye (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21613; -- Skulking Witch (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21614; -- Soul Devourer (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21615; -- Spiteful Temptress (1)
UPDATE `creature_template` SET `BaseAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 20909; -- Sulfuron Magma-Thrower
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857, `BaseAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 21616; -- Sulfuron Magma-Thrower (1)
UPDATE `creature_template` SET `BaseAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 20910; -- Twilight Drakonaar
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857, `BaseAttackTime` = 2000, `unit_flags` = 64 WHERE `entry` = 21618; -- Twilight Drakonaar (1)
UPDATE `creature_template` SET `BaseAttackTime` = 2000 WHERE `entry` = 21962; -- Udalo
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21619; -- Unbound Devastator (1)
UPDATE `creature_template` SET `minlevel` = 70, `maxlevel` = 70, `speed_walk` = 2.4, `speed_run` = 1.42857 WHERE `entry` = 21101; -- Unbound Void Zone
UPDATE `creature_template` SET `minlevel` = 70, `maxlevel` = 70, `speed_walk` = 2.4, `speed_run` = 1.42857 WHERE `entry` = 21620; -- Unbound Void Zone (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 1.42857 WHERE `entry` = 21621; -- Unchained Doombringer (1)
UPDATE `creature_template` SET `speed_walk` = 1, `speed_run` = 0.857143 WHERE `entry` = 21622; -- Warden Mellichar (1)
UPDATE `creature_template` SET `minlevel` = 68, `maxlevel` = 69, `speed_walk` = 1, `speed_run` = 0.857143, `BaseAttackTime` = 2000 WHERE `entry` = 21623; -- Warder Corpse (1)
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.42857 WHERE `entry` = 21624; -- Wrath-Scryer Soccothrates (1)
UPDATE `creature_template` SET `speed_walk` = 4, `speed_run` = 1.42857 WHERE `entry` = 21030; -- Wrath-Scryer's Charge Target
UPDATE `creature_template` SET `minlevel` = 69, `maxlevel` = 69, `speed_walk` = 8, `speed_run` = 2.85714 WHERE `entry` = 21625; -- Wrath-Scryer's Felfire (1)
UPDATE `creature_template` SET `speed_walk` = 1.6, `speed_run` = 1.71429 WHERE `entry` = 21626; -- Zereketh the Unbound (1)

-- Sightless Eye / Unbound Void Zone. Too old to figure out why it was added in first place
-- Definitely not needed in second case since creature even can't attack
UPDATE `creature_template` SET `dmgschool` = 0 WHERE `entry` IN (21346,21612,21101,21620);

-- Equipment corrections
UPDATE `creature_equip_template` SET `ItemID2` = 0, `VerifiedBuild` = 14007 WHERE `CreatureID` = 20896 AND `ID` = 1;

-- VerifiedBuild & positions
UPDATE `creature` SET `VerifiedBuild` = 14007 WHERE `map` = 552 AND `id` IN (15384,20859,20869,20885,20886,20901,20902,20904,20978,21186,21436,21437,21438,21439,21440);

UPDATE `creature` SET `position_z` = -10.0188, `VerifiedBuild` = 14007 WHERE `guid` = 79400 AND `id` = 20857;
UPDATE `creature` SET `position_x` = 101.683, `position_y` = -3.04769, `position_z` = -10.0188, `VerifiedBuild` = 14007 WHERE `guid` = 79395 AND `id` = 20857;
UPDATE `creature` SET `position_z` = -10.0188, `orientation` = 0.0174533, `VerifiedBuild` = 14007 WHERE `guid` = 79399 AND `id` = 20857;
UPDATE `creature` SET `position_x` = 468.652, `position_y` = 12.2102, `position_z` = 49.3853, `orientation` = 1.29154, `VerifiedBuild` = 14007 WHERE `guid` = 10997 AND `id` = 21962;

-- Protean Nightmare
UPDATE `creature` SET `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79452 AND `id` = 20864;
UPDATE `creature` SET `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79444 AND `id` = 20864;

-- Looks like they don't have angles
DELETE FROM `creature_formations` WHERE `leaderGUID` IN (79452,79444);
INSERT INTO `creature_formations` (`leaderGUID`, `memberGUID`, `dist`, `angle`, `groupAI`, `point_1`, `point_2`) VALUES
(79452,79452,0,0,515,0,0),
(79452,79455,5,45,515,0,0),
(79452,79453,5,315,515,0,0),
(79444,79444,0,0,515,0,0),
(79444,79432,5,45,515,0,0),
(79444,79434,5,315,515,0,0);

DELETE FROM `creature_addon` WHERE `guid` IN (79452,79444);
INSERT INTO `creature_addon` (`guid`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `visibilityDistanceType`, `auras`) VALUES
(79452,794520,0,0,1,0,0,""),
(79444,794440,0,0,1,0,0,"");

DELETE FROM `waypoint_data` WHERE `id` IN (794520,794440);
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
-- Members too moves randomly during pause
(794520,1,202.77959,-41.40766,-10.095723,5.846852,25000,0,0,0,0), -- Instantly start random movement (3) for pause time (25 sec)
(794520,2,203.17947,-32.20689,-10.1013775,0,0,0,0,0,0),
(794520,3,203.19337,-20.843853,-10.093281,0,30000,0,0,0,0), -- Instantly start random movement (3) for pause time (30 sec)
(794440,1,208.34787,9.844978,-7.4684005,0,25000,0,0,0,0), -- Instantly start random movement (4) for pause time (25 sec)
(794440,2,217.09438,9.082261,-7.4683995,0,0,0,0,0,0),
(794440,3,224.82596,-1.105318,-8.197451,0,0,0,0,0,0),
(794440,4,223.71288,-13.408787,-9.599375,0,0,0,0,0,0),
(794440,5,212.49054,-17.97817,-10.091022,0,0,0,0,0,0),
(794440,6,198.7105,-5.965413,-10.102092,0,0,0,0,0,0),
(794440,7,192.63458,6.129091,-10.10528,0,25000,0,0,0,0), -- Instantly start random movement (4) for pause time (25 sec)
(794440,8,183.20636,12.026545,-10.096576,0,0,0,0,0,0),
(794440,9,187.25227,20.871046,-9.640596,0,0,0,0,0,0),
(794440,10,196.87997,22.969841,-8.600537,0,0,0,0,0,0),
(794440,11,205.79718,18.459171,-7.6264877,0,0,0,0,0,0);

-- Protean Horror
-- First group
DELETE FROM `waypoint_data` WHERE `id` IN (794560,7945600);
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(794560,1,183.84764,17.15893,-10.106732,0,0,0,0,0,0),
(794560,2,186.73946,2.564413,-10.102718,0,0,0,0,0,0),
(794560,3,197.93507,-17.824755,-10.097534,0,0,0,0,0,0),
(794560,4,197.42511,-56.04032,-10.106724,0,0,0,0,0,0),
(794560,5,202.3496,-61.534344,-10.108492,0,0,0,0,0,0),
(794560,6,208.22867,-57.986126,-10.064104,0,0,0,0,0,0),
(794560,7,208.07149,-29.18059,-10.091506,0,0,0,0,0,0),
(794560,8,210.0403,-21.635162,-10.089756,0,0,0,0,0,0),
(794560,9,223.61438,-13.931542,-9.6416445,0,0,0,0,0,0),
(794560,10,223.23763,3.027244,-7.9025264,0,0,0,0,0,0),
(794560,11,201.15256,21.943642,-8.097452,0,0,0,0,0,0);

UPDATE `creature_addon` SET `path_id` = 794560 WHERE `guid` = 79456;

DELETE FROM `creature_formations` WHERE `leaderGUID` IN (79456);
INSERT INTO `creature_formations` (`leaderGUID`, `memberGUID`, `dist`, `angle`, `groupAI`, `point_1`, `point_2`) VALUES
(79456,79456,0,0,515,0,0),
(79456,79427,2,180,515,0,0),
(79456,79458,2,110,515,0,0),
(79456,79454,2,250,515,0,0),
(79456,79445,2,40,515,0,0),
(79456,131091,2,320,515,0,0);

DELETE FROM `creature` WHERE `guid` = 131091 AND `id` = 20865;
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(131091, 20865, 552, 3, 1, 0, 183.84764, 17.15893, -10.106732, 6.02139, 7200, 0, 0, 0);

UPDATE `creature` SET `position_x` = 183.84764, `position_y` = 17.15893, `position_z` = -10.106732 WHERE `guid` IN (79456,79427,79458,79454,79445) AND `id` = 20865;

-- Second group
DELETE FROM `waypoint_data` WHERE `id` IN (794800);
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(794800,1,272.83566,-175.49477,-10.104805,0,0,0,0,0,0),
(794800,2,278.45392,-153.14717,-10.1086855,0,0,0,0,0,0),
(794800,3,280.5827,-136.87622,-10.121723,0,0,0,0,0,0),
(794800,4,261.5679,-119.71741,-10.123238,0,0,0,0,0,0),
(794800,5,245.82552,-122.29325,-10.123243,0,0,0,0,0,0),
(794800,6,220.30566,-121.72503,-10.117749,0,0,0,0,0,0),
(794800,7,202.52419,-114.3171,-10.123289,0,0,0,0,0,0),
(794800,8,195.13905,-118.79325,-10.12332,0,0,0,0,0,0),
(794800,9,195.03548,-145.50099,-10.116195,0,0,0,0,0,0),
(794800,10,212.1964,-157.94833,-10.113149,0,0,0,0,0,0),
(794800,11,231.8269,-157.86928,-10.112798,0,0,0,0,0,0),
(794800,12,235.90848,-164.12933,-10.106403,0,0,0,0,0,0),
(794800,13,235.05792,-181.03023,-10.108897,0,0,0,0,0,0),
(794800,14,223.98999,-186.03038,-10.10672,0,0,0,0,0,0),
(794800,15,230.39694,-194.16634,-10.107081,0,0,0,0,0,0),
(794800,16,259.7843,-195.02864,-10.10507,0,0,0,0,0,0);

DELETE FROM `creature_addon` WHERE `guid` = 79480;
INSERT INTO `creature_addon` (`guid`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `visibilityDistanceType`, `auras`) VALUES
(79480,794800,0,0,1,0,0,"");

UPDATE `creature` SET `position_x` = 272.83566, `position_y` = -175.49477, `position_z` = -10.104805, `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79480 AND `id` = 20865;
UPDATE `creature` SET `position_x` = 272.83566, `position_y` = -175.49477, `position_z` = -10.104805, `wander_distance` = 0, `MovementType` = 0 WHERE `guid` IN (79479,79478) AND `id` = 20865;

DELETE FROM `creature_formations` WHERE `leaderGUID` IN (79480);
INSERT INTO `creature_formations` (`leaderGUID`, `memberGUID`, `dist`, `angle`, `groupAI`, `point_1`, `point_2`) VALUES
(79480,79480,0,0,515,0,0),
(79480,79479,2,180,515,0,0),
(79480,79478,2,110,515,0,0),
(79480,131092,2,250,515,0,0),
(79480,131093,2,40,515,0,0),
(79480,131096,2,320,515,0,0);

DELETE FROM `creature` WHERE `guid` IN (131092,131093,131096) AND `id` = 20865;
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(131092, 20865, 552, 3, 1, 0, 272.83566,-175.49477,-10.104805, 6.02139, 7200, 0, 0, 0),
(131093, 20865, 552, 3, 1, 0, 272.83566,-175.49477,-10.104805, 6.02139, 7200, 0, 0, 0),
(131096, 20865, 552, 3, 1, 0, 272.83566,-175.49477,-10.104805, 6.02139, 7200, 0, 0, 0);

-- Rest
UPDATE `creature` SET `position_x` = 273.68204, `position_y` = -175.49477, `position_z` = -10.104805, `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79485 AND `id` = 20865;
UPDATE `creature` SET `position_x` = 220.80006, `position_y` = -160.14894, `position_z` = -10.113282, `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79484 AND `id` = 20865;
UPDATE `creature` SET `position_x` = 276.4392, `position_y` = -23.589931, `position_z` = 22.449287, `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79467 AND `id` = 20865;
UPDATE `creature` SET `position_x` = 283.78665, `position_y` = 39.46318, `position_z` = 22.441086, `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79466 AND `id` = 20865;
UPDATE `creature` SET `position_x` = 300.1723, `position_y` = 132.34288, `position_z` = 22.228413, `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79520 AND `id` = 20865;
UPDATE `creature` SET `position_x` = 326.98926, `position_y` = 22.717283, `position_z` = 48.35042, `wander_distance` = 0, `MovementType` = 2 WHERE `guid` = 79459 AND `id` = 20865;

DELETE FROM `creature_addon` WHERE `guid` IN (79485,79484,79467,79466,79520,79459);
INSERT INTO `creature_addon` (`guid`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `visibilityDistanceType`, `auras`) VALUES
(79485,794850,0,0,1,0,0,""),
(79484,794840,0,0,1,0,0,""),
(79467,794670,0,0,1,0,0,""),
(79466,794660,0,0,1,0,0,""),
(79520,795200,0,0,1,0,0,""),
(79459,794590,0,0,1,0,0,"");

DELETE FROM `waypoint_data` WHERE `id` IN (794850,794840,794670,794660,795200,794590);
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(794850,1,273.68204,-161.13853,-10.110326,0,0,1,0,0,0),
(794850,2,261.6127,-189.98672,-10.10487,0,0,1,0,0,0),
(794850,3,227.53447,-192.88065,-10.105654,0,0,1,0,0,0),
(794850,4,234.71745,-166.73166,-10.107577,0,0,1,0,0,0),
(794850,5,273.68204,-161.13853,-10.110326,0,0,1,0,0,0),
(794850,6,246.39204,-144.1044,-10.109891,0,0,1,0,0,0),
(794850,7,216.76047,-123.82127,-10.108683,0,0,1,0,0,0),
(794850,8,202.98213,-110.55506,-10.123076,0,0,1,0,0,0),
(794850,9,194.93211,-130.28767,-10.12011,0,0,1,0,0,0),
(794850,10,194.4479,-140.82317,-10.118726,0,0,1,0,0,0),
(794850,11,224.49347,-142.0825,-10.110895,0,0,1,0,0,0),
(794850,12,253.40977,-160.71367,-10.1047535,0,0,1,0,0,0),
(794850,13,274.55026,-161.28899,-10.110443,0,0,1,0,0,0),
(794840,1,220.80006,-160.14894,-10.113282,0,0,1,0,0,0),
(794840,2,202.58867,-149.75804,-10.114253,0,0,1,0,0,0),
(794840,3,202.54631,-119.9808,-10.119678,0,0,1,0,0,0),
(794840,4,235.29565,-126.66605,-10.1168585,0,0,1,0,0,0),
(794840,5,260.4425,-120.10798,-10.123239,0,0,1,0,0,0),
(794840,6,261.34445,-148.69566,-10.109158,0,0,1,0,0,0),
(794840,7,220.35661,-161.02452,-10.113402,0,0,1,0,0,0),
(794840,8,236.75801,-193.39262,-10.107179,0,0,1,0,0,0),
(794840,9,260.3886,-194.68185,-10.105082,0,0,1,0,0,0),
(794840,10,268.60522,-158.09924,-10.105517,0,0,1,0,0,0),
(794840,11,237.7268,-160.15494,-10.101749,0,0,1,0,0,0),
(794840,12,220.80006,-160.14894,-10.113282,0,0,1,0,0,0),
(794840,13,202.58867,-149.75804,-10.114253,0,0,1,0,0,0),
(794840,14,202.54631,-119.9808,-10.119678,0,0,1,0,0,0),
(794840,15,235.29565,-126.66605,-10.1168585,0,0,1,0,0,0),
(794840,16,260.4425,-120.10798,-10.123239,0,0,1,0,0,0),
(794840,17,261.34445,-148.69566,-10.109158,0,0,1,0,0,0),
(794840,18,220.35661,-161.02452,-10.113402,0,0,1,0,0,0),
(794840,19,228.45674,-182.32353,-0.40475544,0,0,1,0,0,0),
(794840,20,242.84274,-189.01254,6.2220387,0,0,1,0,0,0),
(794840,21,258.3724,-185.33528,13.020767,0,0,1,0,0,0),
(794840,22,267.94284,-170.10384,20.863707,0,0,1,0,0,0),
(794840,23,267.90543,-139.87071,22.630384,0,0,1,0,0,0),
(794840,24,267.39816,-90.36618,22.49772,0,0,1,0,0,0),
(794840,25,267.34595,-139.87727,22.63598,0,0,1,0,0,0),
(794840,26,267.20602,-169.32367,21.112095,0,0,1,0,0,0),
(794840,27,258.33258,-183.84918,13.519743,0,0,1,0,0,0),
(794840,28,243.24022,-187.99068,6.2865577,0,0,1,0,0,0),
(794840,29,229.67354,-182.05469,-0.16981332,0,0,1,0,0,0),
(794840,30,220.87141,-168.25581,-7.492826,0,0,1,0,0,0),
(794840,31,220.35635,-160.70712,-10.113361,0,0,1,0,0,0),
(794670,1,276.4392,-23.589931,22.449287,0,0,1,0,0,0),
(794670,2,284.8662,-20.331745,22.445856,0,0,1,0,0,0),
(794670,3,275.97946,-25.994663,22.449488,0,0,1,0,0,0),
(794670,4,278.467,-4.585575,22.446081,0,0,1,0,0,0),
(794670,5,276.94437,3.6205244,22.444227,0,0,1,0,0,0),
(794670,6,271.7107,-7.5634804,22.446835,0,0,1,0,0,0),
(794670,7,276.7531,-24.76564,22.449074,0,0,1,0,0,0),
(794670,8,281.2609,-8.890097,22.447031,0,0,1,0,0,0),
(794670,9,278.9107,-2.8623986,22.445684,0,0,1,0,0,0),
(794670,10,280.12787,-30.186117,22.430586,0,0,1,0,0,0),
(794670,11,282.7683,-7.431388,22.446682,0,0,1,0,0,0),
(794670,12,275.8196,-12.023283,22.447807,0,0,1,0,0,0),
(794670,13,282.85126,-5.0972505,22.44615,0,0,1,0,0,0),
(794670,14,257.8145,3.0183382,22.441166,0,0,1,0,0,0),
(794670,15,275.333,-2.5464544,22.445652,0,0,1,0,0,0),
(794670,16,285.18887,-4.337166,22.441162,0,0,1,0,0,0),
(794670,17,276.24606,-26.133457,22.44933,0,0,1,0,0,0),
(794670,18,276.20782,-23.538082,22.449423,0,0,1,0,0,0),
(794670,19,258.27386,3.444697,22.441166,0,0,1,0,0,0),
(794670,20,278.39316,-4.91434,22.446157,0,0,1,0,0,0),
(794670,21,271.1627,1.8598738,22.444693,0,0,1,0,0,0),
(794670,22,278.24026,-21.817663,22.448296,0,0,1,0,0,0),
(794670,23,283.51904,-5.514213,22.446238,0,0,1,0,0,0),
(794660,1,283.78665,39.46318,22.441086,0,0,1,0,0,0),
(794660,2,277.30872,38.26871,22.441082,0,0,1,0,0,0),
(794660,3,295.61484,36.48447,22.441162,0,0,1,0,0,0),
(794660,4,293.22427,56.27017,22.442139,0,0,1,0,0,0),
(794660,5,295.50162,44.398216,22.441164,0,0,1,0,0,0),
(794660,6,280.8974,40.24502,22.441093,0,0,1,0,0,0),
(794660,7,302.46295,45.353622,22.441164,0,0,1,0,0,0),
(794660,8,296.90112,59.738018,22.442732,0,0,1,0,0,0),
(794660,9,284.173,39.591846,22.441088,0,0,1,0,0,0),
(794660,10,281.12805,39.367397,22.441088,0,0,1,0,0,0),
(794660,11,294.55634,63.242043,22.443241,0,0,1,0,0,0),
(794660,12,303.1696,43.752716,22.441164,0,0,1,0,0,0),
(794660,13,294.01703,58.9194,22.442562,0,0,1,0,0,0),
(794660,14,298.5196,41.986217,22.441164,0,0,1,0,0,0),
(794660,15,298.6117,57.53909,22.442415,0,0,1,0,0,0),
(794660,16,277.83807,40.900494,22.441101,0,0,1,0,0,0),
(794660,17,282.45096,39.652325,22.44109,0,0,1,0,0,0),
(795200,1,300.1723,132.34288,22.228413,0,0,1,0,0,0),
(795200,2,284.58438,144.91377,22.22117,0,0,1,0,0,0),
(795200,3,244.56267,147.19673,22.280977,0,0,1,0,0,0),
(795200,4,228.7991,147.2889,22.307953,0,0,1,0,0,0),
(795200,5,206.13211,147.52689,22.540571,0,0,1,0,0,0),
(795200,6,176.72488,163.51595,22.441147,0,0,1,0,0,0),
(795200,7,166.14273,146.77989,22.441147,0,0,1,0,0,0),
(795200,8,176.24336,130.70343,22.441147,0,0,1,0,0,0),
(795200,9,206.13625,147.05757,22.540552,0,0,1,0,0,0),
(795200,10,244.60933,146.82315,22.280828,0,0,1,0,0,0),
(795200,11,284.55133,144.52907,22.221207,0,0,1,0,0,0),
(795200,12,301.51114,107.04327,22.224655,0,0,1,0,0,0),
(795200,13,301.12772,67.612755,22.438244,0,0,1,0,0,0),
(794590,1,326.98926,22.717283,48.35042,0,0,1,0,0,0),
(794590,2,280.14618,22.75021,48.35042,0,0,1,0,0,0),
(794590,3,233.10696,22.53368,48.33978,0,0,1,0,0,0),
(794590,4,208.37445,22.330988,48.193367,0,0,1,0,0,0),
(794590,5,233.10588,22.271296,48.33915,0,0,1,0,0,0),
(794590,6,280.1424,22.352137,48.35042,0,0,1,0,0,0),
(794590,7,326.83463,22.414886,48.35042,0,0,1,0,0,0),
(794590,8,365.33887,22.197266,48.212692,0,0,1,0,0,0),
(794590,9,414.51904,22.458496,48.214485,0,0,1,0,0,0),
(794590,10,458.984,1.867482,48.221653,0,0,1,0,0,0),
(794590,11,465.1369,22.774263,50.290604,0,0,1,0,0,0),
(794590,12,434.82935,44.72688,49.352238,0,0,1,0,0,0),
(794590,13,414.516,22.780737,48.215786,0,0,1,0,0,0),
(794590,14,365.25113,22.579336,48.212692,0,0,1,0,0,0);

-- Ethereum creatures
-- First pack
DELETE FROM `waypoint_data` WHERE `id` = 795660;
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(795660,1,449.4046,1.538476,48.219746,0,0,0,0,0,0),
(795660,2,463.29834,5.452207,48.305122,0,0,0,0,0,0),
(795660,3,466.79602,19.510277,49.992313,0,0,0,0,0,0),
(795660,4,460.21735,36.802353,50.84645,0,0,0,0,0,0),
(795660,5,439.6564,44.632866,49.72284,0,0,0,0,0,0),
(795660,6,427.544,41.33546,48.411606,0,0,0,0,0,0),
(795660,7,426.6427,32.553425,48.206787,0,0,0,0,0,0),
(795660,8,436.76343,19.38034,48.21401,0,0,0,0,0,0),
(795660,9,442.88638,11.988906,48.23025,0,0,0,0,0,0),
(795660,10,442.4002,-20.45843,48.212788,0,0,0,0,0,0),
(795660,11,449.3031,-20.429773,48.238365,0,0,0,0,0,0);

UPDATE `creature` SET `position_x` = 449.4046, `position_y` = 1.538476, `position_z` = 48.219746 WHERE `guid` IN (79566,79567) AND `id` = 20896;
UPDATE `creature` SET `position_x` = 449.4046, `position_y` = 1.538476, `position_z` = 48.219746 WHERE `guid` = 79568 AND `id` = 21702;
UPDATE `creature` SET `position_x` = 449.4046, `position_y` = 1.538476, `position_z` = 48.219746 WHERE `guid` = 79569 AND `id` = 20897;

DELETE FROM `creature_formations` WHERE `leaderGUID` = 79566;
INSERT INTO `creature_formations` (`leaderGUID`, `memberGUID`, `dist`, `angle`, `groupAI`, `point_1`, `point_2`) VALUES
(79566,79566,0,0,515,0,0),
(79566,79569,3,60,515,0,0),
(79566,79568,3,300,515,0,0),
(79566,79567,3,180,515,0,0);

-- Second pack
UPDATE `creature` SET `VerifiedBuild` = 14007 WHERE `guid` IN (79563,79562,79565,79564);

-- Last boss room
-- Unchained Doombringer
UPDATE `creature` SET `VerifiedBuild` = 14007 WHERE `guid` = 79406 AND `id` = 20900;
UPDATE `creature` SET `position_x` = 430.349, `position_y` = -159.246, `position_z` = 43.2067, `orientation` = 1.5708, `wander_distance` = 10, `MovementType` = 1, `VerifiedBuild` = 14007 WHERE `guid` = 79405 AND `id` = 20900;

-- Gargantuan Abyssal
DELETE FROM `creature` WHERE `guid` = 131097 AND `id` = 20898;
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(131097, 20898, 552, 3, 1, 0, 454.082, -136.423, 43.1834, 3.92699, 7200, 5, 1, 14007);

-- Second & third boss room
-- Skulking Witch
-- Was unable to check if position of second spawn is correct - creature was aggroed before default position was sent
-- Pretty sure current position is slightly incorrect
-- Same in 3 sniffs
UPDATE `creature` SET `position_x` = 160.808, `position_y` = 126.532, `position_z` = 22.5245, `orientation` = 0.942478, `VerifiedBuild` = 14007 WHERE `guid` = 79553 AND `id` = 20882;

-- Spiteful Temptress / Unbound Devastator
UPDATE `creature` SET `VerifiedBuild` = 14007 WHERE `guid` = 79542 AND `id` = 20883;

DELETE FROM `creature` WHERE `guid` = 131099 AND `id` = 20881;
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(131099, 20881, 552, 3, 1, 1, 148.05, 146.994, 20.8982, 6.26573, 7200, 0, 0, 14007);

DELETE FROM `pool_template` WHERE `entry` = 780;
INSERT INTO `pool_template` (`entry`, `max_limit`, `description`) VALUES
(780, 1, "The Arcatraz - Spiteful Temptress / Unbound Devastator");

DELETE FROM `pool_members` WHERE `type` = 0 AND `spawnId` IN (79542,131099);
INSERT INTO `pool_members` (`type`, `spawnId`, `poolSpawnId`, `chance`, `description`) VALUES
(0, 79542, 780, 0, "The Arcatraz - Spiteful Temptress / Unbound Devastator - Spiteful Temptress"),
(0, 131099, 780, 0, "The Arcatraz - Spiteful Temptress / Unbound Devastator - Unbound Devastator");

-- Room with eredars
UPDATE `creature` SET `VerifiedBuild` = 14007 WHERE `guid` = 213223 AND `id` = 20880;
UPDATE `creature` SET `position_x` = 285.519, `position_y` = 146.155, `position_z` = 22.3118, `orientation` = 5.79449, `VerifiedBuild` = 14007 WHERE `guid` = 52355 AND `id` = 20879;
UPDATE `creature` SET `VerifiedBuild` = 14007 WHERE `guid` = 213224 AND `id` = 20880;
UPDATE `creature` SET `position_x` = 305.736, `position_y` = 148.059, `position_z` = 24.8633, `orientation` = 3.97935, `VerifiedBuild` = 14007 WHERE `guid` = 52356 AND `id` = 20879;

-- Remove old incorrect pool too
DELETE FROM `pool_template` WHERE `entry` IN (368,781);
INSERT INTO `pool_template` (`entry`, `max_limit`, `description`) VALUES
(781, 1, "The Arcatraz - Eredar Soul-Eater / Eredar Deathbringer");

DELETE FROM `pool_members` WHERE `type` = 0 AND `spawnId` IN (52355,52356,213224);
INSERT INTO `pool_members` (`type`, `spawnId`, `poolSpawnId`, `chance`, `description`) VALUES
(0, 52356, 781, 0, "The Arcatraz - Eredar Soul-Eater / Eredar Deathbringer - Eredar Soul-Eater"),
(0, 213224, 781, 0, "The Arcatraz - Eredar Soul-Eater / Eredar Deathbringer - Eredar Deathbringer");

-- Fix addon data
-- Fix sheath
UPDATE `creature_addon` SET `bytes2` = 1 WHERE `guid` IN (79534);
-- Empty / not needed
DELETE FROM `creature_addon` WHERE `guid` IN (SELECT `guid` FROM `creature` WHERE `id` IN (15384) AND `path_id` = 0);
DELETE FROM `creature_template_addon` WHERE `entry` IN (15384,21186);
