-- Change respawn time of triggers to default
UPDATE `creature` SET `spawntimesecs` = 300 WHERE `id` IN (22517,30298) AND `map` = 604;

-- VerifiedBuild
UPDATE `creature` SET `VerifiedBuild` = 12340 WHERE `map` = 604 AND `id` IN (29307,29832,29874,29838,29931,29306,30298,29305,29304,29682,22517);

-- Update stats
-- 30537 requires checks
UPDATE `creature_template` SET `speed_run` = 1.42857 WHERE `entry` = 31365; -- Drakkari Colossus (1)
-- Default faction is 16, only two (sparring) creatures changes their faction. First to 1692 and second to 1693
-- They changes faction back to 16 after sparring is over so we can't change faction in creature table
UPDATE `creature_template` SET `faction` = 16 WHERE `entry` = 29829; -- Drakkari Earthshaker
UPDATE `creature_template` SET `faction` = 16, `speed_walk` = 0.666668 WHERE `entry` = 30926; -- Drakkari Earthshaker (1)
UPDATE `creature_template` SET `speed_run` = 1.71428, `unit_flags` = 32832 WHERE `entry` = 29573; -- Drakkari Elemental
UPDATE `creature_template` SET `speed_run` = 1.71428, `unit_flags` = 32832 WHERE `entry` = 31367; -- Drakkari Elemental (1)
UPDATE `creature_template` SET `minlevel` = 80 WHERE `entry` = 30927; -- Drakkari Fire Weaver (1)
UPDATE `creature_template` SET `speed_walk` = 1.6 WHERE `entry` = 30928; -- Drakkari Frenzy (1)
UPDATE `creature_template` SET `minlevel` = 80 WHERE `entry` = 30929; -- Drakkari God Hunter (1)
UPDATE `creature_template` SET `speed_run` = 0.992063 WHERE `entry` = 30930; -- Drakkari Golem (1)
UPDATE `creature_template` SET `minlevel` = 80 WHERE `entry` = 30932; -- Drakkari Lancer (1)
UPDATE `creature_template` SET `minlevel` = 80 WHERE `entry` = 30933; -- Drakkari Medicine Man (1)
UPDATE `creature_template` SET `speed_run` = 0.99206 WHERE `entry` = 29838; -- Drakkari Rhino
UPDATE `creature_template` SET `minlevel` = 80, `speed_run` = 0.99206 WHERE `entry` = 30935; -- Drakkari Rhino (1)
UPDATE `creature_template` SET `minlevel` = 80, `speed_run` = 0.99206 WHERE `entry` = 30936; -- Drakkari Rhino (1)
UPDATE `creature_template` SET `speed_run` = 1.42857 WHERE `entry` = 29306; -- Gal'darah
UPDATE `creature_template` SET `speed_run` = 1.42857 WHERE `entry` = 31368; -- Gal'darah (1)
UPDATE `creature_template` SET `speed_run` = 1.28968 WHERE `entry` = 30938; -- Living Mojo (1)
UPDATE `creature_template` SET `speed_run` = 1.42857 WHERE `entry` = 30530; -- Moorabi (1)
UPDATE `creature_template` SET `speed_walk` = 0.66666, `speed_run` = 2.14285 WHERE `entry` = 29748; -- Phantom Mammoth
UPDATE `creature_template` SET `minlevel` = 78, `maxlevel` = 78 WHERE `entry` = 29791; -- Rhino Spirit
UPDATE `creature_template` SET `minlevel` = 78, `maxlevel` = 78 WHERE `entry` = 29920; -- Ruins Dweller
UPDATE `creature_template` SET `minlevel` = 80, `speed_run` = 1.19048 WHERE `entry` = 30939; -- Ruins Dweller (1)
UPDATE `creature_template` SET `speed_run` = 1.42857 WHERE `entry` = 31370; -- Slad'ran (1)
UPDATE `creature_template` SET `unit_flags` = 32768 WHERE `entry` = 29713; -- Slad'ran Constrictor
UPDATE `creature_template` SET `minlevel` = 80, `unit_flags` = 32768 WHERE `entry` = 30943; -- Slad'ran Constrictor (1)
UPDATE `creature_template` SET `unit_flags` = 32768 WHERE `entry` = 29680; -- Slad'ran Viper
UPDATE `creature_template` SET `minlevel` = 80, `unit_flags` = 32768 WHERE `entry` = 30940; -- Slad'ran Viper (1)
UPDATE `creature_template` SET `minlevel` = 80 WHERE `entry` = 30941; -- Spitting Cobra (1)
UPDATE `creature_template` SET `minlevel` = 80 WHERE `entry` = 30942; -- Unyielding Constrictor (1)

-- Crafty Snake
UPDATE `creature` SET `position_x` = 1781.97, `position_y` = 613.835, `position_z` = 124.47, `orientation` = 0.86942, `wander_distance` = 0, `MovementType` = 2, `VerifiedBuild` = 11723 WHERE `guid` = 127200 AND `id` = 29637;
UPDATE `creature_addon` SET `path_id` = 1272000 WHERE `guid` = 127200;

DELETE FROM `waypoint_data` WHERE `id` = 1272000;
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(1272000,1,1789.6013,631.2603,124.46857,0,0,0,0,0,0),
(1272000,2,1788.3529,637.70996,124.46532,0,0,0,0,0,0),
(1272000,3,1786.7833,643.3662,124.4708,0,0,0,0,0,0),
(1272000,4,1782.1758,647.4296,124.39418,0,0,0,0,0,0),
(1272000,5,1774.8467,649.6526,124.469955,0,0,0,0,0,0),
(1272000,6,1767.0548,647.31024,124.46762,0,0,0,0,0,0),
(1272000,7,1761.9337,640.552,124.55954,0,0,0,0,0,0),
(1272000,8,1759.2557,632.60187,124.47385,0,0,0,0,0,0),
(1272000,9,1761.7975,624.5855,124.37506,0,0,0,0,0,0),
(1272000,10,1765.0846,616.11426,124.47247,0,0,0,0,0,0),
(1272000,11,1769.5145,611.6437,124.469086,0,0,0,0,0,0),
(1272000,12,1773.8217,608.76184,124.45199,0,0,0,0,0,0),
(1272000,13,1780.1171,611.64496,124.47011,0,0,0,0,0,0),
(1272000,14,1786.2731,618.9333,124.473694,0,0,0,0,0,0),
(1272000,15,1788.9342,626.22156,124.47196,0,0,0,0,0,0);

-- Drakkari Earthshaker
-- Let's move two of them to default positions and remove emotes since it's handled in sparring
UPDATE `creature` SET `position_x` = 1772.78, `position_y` = 843.851, `position_z` = 123.275, `orientation` = 1.57079 WHERE `guid` = 127067 AND `id` = 29829;
UPDATE `creature` SET `position_x` = 1772.72, `position_y` = 857.481, `position_z` = 123.275, `orientation` = 4.72984 WHERE `guid` = 127068 AND `id` = 29829;
DELETE FROM `creature_addon` WHERE `guid` IN (127067,127068);

UPDATE `creature` SET `position_x` = 1614.48, `position_y` = 801.368, `position_z` = 144.561 WHERE `guid` = 127069 AND `id` = 29829;
UPDATE `creature` SET `position_x` = 1706.62, `position_y` = 852.321, `position_z` = 129.611 WHERE `guid` = 127070 AND `id` = 29829;

DELETE FROM `waypoint_data` WHERE `id` IN (1270690,1270700);
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(1270690,1,1614.4899,801.3685,144.5617,0,0,0,0,0,0),
(1270690,2,1624.4312,793.83295,143.31413,0,0,0,0,0,0),
(1270690,3,1614.4899,801.3685,144.5617,0,0,0,0,0,0),
(1270690,4,1603.3579,803.6435,145.66626,0,0,0,0,0,0),
(1270690,5,1593.387,814.429,148.97008,0,0,0,0,0,0),
(1270690,6,1590.2843,829.53436,151.6608,0,0,0,0,0,0),
(1270690,7,1584.7394,843.7164,154.08716,0,0,0,0,0,0),
(1270690,8,1590.2843,829.53436,151.6608,0,0,0,0,0,0),
(1270690,9,1593.387,814.429,148.97008,0,0,0,0,0,0),
(1270690,10,1603.0887,803.8016,145.71576,0,0,0,0,0,0),
(1270700,1,1706.625,852.3212,129.6112,0,0,0,0,0,0),
(1270700,2,1707.4381,870.38544,130.3954,0,0,0,0,0,0),
(1270700,3,1701.4728,885.41266,131.29222,0,0,0,0,0,0),
(1270700,4,1689.2217,893.7978,133.17715,0,0,0,0,0,0),
(1270700,5,1676.365,891.2794,134.78046,0,0,0,0,0,0),
(1270700,6,1666.4783,880.1216,137.88535,0,0,0,0,0,0),
(1270700,7,1676.2814,891.18506,134.76265,0,0,0,0,0,0),
(1270700,8,1689.2217,893.7978,133.17715,0,0,0,0,0,0),
(1270700,9,1701.4192,885.54755,131.46597,0,0,0,0,0,0),
(1270700,10,1707.4381,870.38544,130.3954,0,0,0,0,0,0);

-- Living Mojo
UPDATE `creature` SET `position_x` = 1579.79, `position_y` = 726.052, `position_z` = 142.783, `orientation` = 3.14485, `VerifiedBuild` = 12340 WHERE `guid` = 127079 AND `id` = 29830;
UPDATE `creature` SET `position_x` = 1615.96, `position_y` = 760.211, `position_z` = 142.788, `orientation` = 3.20148, `VerifiedBuild` = 12340 WHERE `guid` = 127078 AND `id` = 29830;
UPDATE `creature` SET `position_x` = 1619.69, `position_y` = 743.911, `position_z` = 142.786, `orientation` = 3.13403, `VerifiedBuild` = 12340 WHERE `guid` = 127077 AND `id` = 29830;
UPDATE `creature` SET `position_x` = 1646.74, `position_y` = 738.065, `position_z` = 142.786, `orientation` = 4.70707, `wander_distance` = 0, `MovementType` = 2, `VerifiedBuild` = 12340 WHERE `guid` = 127076 AND `id` = 29830;
UPDATE `creature` SET `VerifiedBuild` = 12340 WHERE `id` = 29830;

DELETE FROM `creature_addon` WHERE `guid` = 127076;
INSERT INTO `creature_addon` (`guid`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `visibilityDistanceType`, `auras`) VALUES
(127076,1270760,0,0,1,0,0,"");

DELETE FROM `waypoint_data` WHERE `id` IN (1270790,1270780,1270770,1270760);
INSERT INTO `waypoint_data` (`id`, `point`, `position_x`, `position_y`, `position_z`, `orientation`, `delay`, `move_type`, `action`, `action_chance`, `wpguid`) VALUES
(1270790,1,1611.9076,726.15686,142.78287,0,0,0,0,0,0),
(1270790,2,1576.1443,726.04047,142.78294,0,0,0,0,0,0),
(1270780,1,1615.817,751.9009,142.78598,0,0,0,0,0,0),
(1270780,2,1612.4216,745.6228,142.78598,0,0,0,0,0,0),
(1270780,3,1612.4713,741.7882,142.78598,0,0,0,0,0,0),
(1270780,4,1616.5194,733.9635,142.78598,0,0,0,0,0,0),
(1270780,5,1616.6116,726.8234,142.79187,0,0,0,0,0,0),
(1270780,6,1616.5194,733.9635,142.78598,0,0,0,0,0,0),
(1270780,7,1612.4713,741.7882,142.78598,0,0,0,0,0,0),
(1270780,8,1612.4216,745.6228,142.78598,0,0,0,0,0,0),
(1270780,9,1615.817,751.9009,142.78598,0,0,0,0,0,0),
(1270780,10,1615.9574,760.2114,142.78761,0,0,0,0,0,0),
(1270780,11,1624.8319,760.74304,142.78598,0,0,0,0,0,0),
(1270780,12,1624.8828,767.4497,142.78644,0,0,0,0,0,0),
(1270780,13,1624.8319,760.74304,142.78598,0,0,0,0,0,0),
(1270780,14,1615.9574,760.2114,142.78761,0,0,0,0,0,0),
(1270780,15,1624.8319,760.74304,142.78598,0,0,0,0,0,0),
(1270780,16,1624.8828,767.4497,142.78644,0,0,0,0,0,0),
(1270780,17,1624.8319,760.74304,142.78598,0,0,0,0,0,0),
(1270780,18,1615.9574,760.2114,142.78761,0,0,0,0,0,0),
(1270770,1,1641.7659,743.74426,142.78598,0,0,0,0,0,0),
(1270770,2,1619.6891,743.91144,142.78598,0,0,0,0,0,0),
(1270760,1,1634.2941,738.2811,142.78598,0,0,0,0,0,0),
(1270760,2,1634.2074,728.41003,142.76462,0,0,0,0,0,0),
(1270760,3,1625.2333,727.8482,142.78598,0,0,0,0,0,0),
(1270760,4,1625.0392,720.0653,142.78317,0,0,0,0,0,0),
(1270760,5,1625.0919,727.8393,142.78598,0,0,0,0,0,0),
(1270760,6,1634.2074,728.41003,142.76462,0,0,0,0,0,0),
(1270760,7,1634.2941,738.2811,142.78598,0,0,0,0,0,0),
(1270760,8,1646.7443,738.063,142.78598,0,0,0,0,0,0),
(1270760,9,1646.8032,749.10443,142.79655,0,0,0,0,0,0),
(1270760,10,1634.2952,749.07544,142.78598,0,0,0,0,0,0),
(1270760,11,1646.8032,749.10443,142.79655,0,0,0,0,0,0),
(1270760,12,1646.7443,738.063,142.78598,0,0,0,0,0,0);

-- Snake
DELETE FROM `creature` WHERE `guid` IN (131069) AND `id` = 2914;
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(131069, 2914, 604, 3, 1, 0, 1560.21, 605.678, 133.555, 2.97078, 300, 3, 1, 12340);
UPDATE `creature` SET `wander_distance` = 3, `MovementType` = 1 WHERE `map` = 604 AND `id` = 2914;

-- Frog
UPDATE `creature` SET `wander_distance` = 2, `MovementType` = 1 WHERE `map` = 604 AND `id` = 13321;

-- Drakkari Frenzy
UPDATE `creature` SET `wander_distance` = 10, `MovementType` = 1 WHERE `map` = 604 AND `id` = 29834;

-- Fanged Pit Viper, way much easier to respawn them all rather than checking which ones are missing
DELETE FROM `creature` WHERE (`guid` BETWEEN 127114 AND 127199 OR `guid` IN (131070,131074,131076,131082)) AND `id` = 29630;
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(127114, 29630, 604, 3, 1, 0, 1755.32, 634.633, 124.488, 4.06272, 3600, 3, 1, 12340),
(127115, 29630, 604, 3, 1, 0, 1756.06, 628.32, 124.493, 5.44439, 3600, 3, 1, 12340),
(127116, 29630, 604, 3, 1, 0, 1756.47, 633.388, 124.483, 2.6996, 3600, 3, 1, 12340),
(127117, 29630, 604, 3, 1, 0, 1757.88, 640.201, 124.481, 4.43356, 3600, 3, 1, 12340),
(127118, 29630, 604, 3, 1, 0, 1758.73, 624.37, 124.482, 4.34082, 3600, 3, 1, 12340),
(127119, 29630, 604, 3, 1, 0, 1760.61, 629.351, 124.486, 3.80619, 3600, 3, 1, 12340),
(127120, 29630, 604, 3, 1, 0, 1761.56, 621.405, 124.462, 4.11234, 3600, 3, 1, 12340),
(127121, 29630, 604, 3, 1, 0, 1761.63, 632.274, 124.576, 3.26728, 3600, 3, 1, 12340),
(127122, 29630, 604, 3, 1, 0, 1761.77, 624.827, 124.379, 3.65492, 3600, 3, 1, 12340),
(127123, 29630, 604, 3, 1, 0, 1762.24, 634.597, 124.496, 4.3896, 3600, 3, 1, 12340),
(127124, 29630, 604, 3, 1, 0, 1762.98, 645.495, 124.472, 0.500856, 3600, 3, 1, 12340),
(127125, 29630, 604, 3, 1, 0, 1763.31, 609.75, 124.486, 5.0222, 3600, 3, 1, 12340),
(127126, 29630, 604, 3, 1, 0, 1763.53, 647.051, 124.472, 2.63274, 3600, 3, 1, 12340),
(127127, 29630, 604, 3, 1, 0, 1763.88, 614.826, 124.573, 4.47993, 3600, 3, 1, 12340),
(127128, 29630, 604, 3, 1, 0, 1763.93, 618.26, 124.618, 3.63315, 3600, 3, 1, 12340),
(127129, 29630, 604, 3, 1, 0, 1764.27, 608.199, 124.486, 4.52033, 3600, 3, 1, 12340),
(127130, 29630, 604, 3, 1, 0, 1765.04, 640.113, 124.363, 3.71596, 3600, 3, 1, 12340),
(127131, 29630, 604, 3, 1, 0, 1765.5, 632.734, 124.11, 1.97962, 3600, 3, 1, 12340),
(127132, 29630, 604, 3, 1, 0, 1765.65, 617.346, 124.654, 6.05583, 3600, 3, 1, 12340),
(127133, 29630, 604, 3, 1, 0, 1765.92, 640.884, 124.305, 4.04201, 3600, 3, 1, 12340),
(127134, 29630, 604, 3, 1, 0, 1766, 620.791, 124.466, 0.634216, 3600, 3, 1, 12340),
(127135, 29630, 604, 3, 1, 0, 1766.45, 648.177, 124.469, 4.21631, 3600, 3, 1, 12340),
(127136, 29630, 604, 3, 1, 0, 1766.68, 637.408, 124.108, 5.22323, 3600, 3, 1, 12340),
(127137, 29630, 604, 3, 1, 0, 1766.97, 614.093, 124.498, 3.07292, 3600, 3, 1, 12340),
(127138, 29630, 604, 3, 1, 0, 1767.32, 628.727, 124.159, 5.73762, 3600, 3, 1, 12340),
(127139, 29630, 604, 3, 1, 0, 1767.68, 618.528, 124.712, 4.86251, 3600, 3, 1, 12340),
(127140, 29630, 604, 3, 1, 0, 1768.01, 610.906, 124.474, 0.943899, 3600, 3, 1, 12340),
(127141, 29630, 604, 3, 1, 0, 1768.18, 628.236, 124.175, 4.6923, 3600, 3, 1, 12340),
(127142, 29630, 604, 3, 1, 0, 1768.21, 635.958, 124.141, 5.33997, 3600, 3, 1, 12340),
(127143, 29630, 604, 3, 1, 0, 1769.65, 640.113, 124.146, 1.86974, 3600, 3, 1, 12340),
(127144, 29630, 604, 3, 1, 0, 1769.97, 604.332, 124.468, 1.0725, 3600, 3, 1, 12340),
(127145, 29630, 604, 3, 1, 0, 1770.06, 617.684, 124.209, 2.13991, 3600, 3, 1, 12340),
(127146, 29630, 604, 3, 1, 0, 1770.21, 642.187, 124.146, 4.86136, 3600, 3, 1, 12340),
(127147, 29630, 604, 3, 1, 0, 1770.62, 624.752, 124.233, 6.18573, 3600, 3, 1, 12340),
(127148, 29630, 604, 3, 1, 0, 1770.77, 608.133, 124.434, 3.45164, 3600, 3, 1, 12340),
(127149, 29630, 604, 3, 1, 0, 1771.65, 614.722, 124.38, 2.20579, 3600, 3, 1, 12340),
(127150, 29630, 604, 3, 1, 0, 1771.7, 614.838, 124.209, 4.09612, 3600, 3, 1, 12340),
(127151, 29630, 604, 3, 1, 0, 1772.25, 635.97, 124.209, 3.59454, 3600, 3, 1, 12340),
(127152, 29630, 604, 3, 1, 0, 1772.5, 631.625, 124.233, 5.95785, 3600, 3, 1, 12340),
(127153, 29630, 604, 3, 1, 0, 1772.79, 618.334, 124.238, 3.7313, 3600, 3, 1, 12340),
(127154, 29630, 604, 3, 1, 0, 1772.98, 646.652, 124.523, 3.53304, 3600, 3, 1, 12340),
(127155, 29630, 604, 3, 1, 0, 1773.18, 621.093, 124.218, 2.98927, 3600, 3, 1, 12340),
(127156, 29630, 604, 3, 1, 0, 1773.45, 611.732, 124.472, 3.30679, 3600, 3, 1, 12340),
(127157, 29630, 604, 3, 1, 0, 1773.52, 629.578, 124.26, 5.20172, 3600, 3, 1, 12340),
(127158, 29630, 604, 3, 1, 0, 1774.37, 607.566, 124.445, 0.428698, 3600, 3, 1, 12340),
(127159, 29630, 604, 3, 1, 0, 1775.1, 627.582, 124.262, 0.693416, 3600, 3, 1, 12340),
(127160, 29630, 604, 3, 1, 0, 1775.19, 634.478, 124.408, 0.572892, 3600, 3, 1, 12340),
(127161, 29630, 604, 3, 1, 0, 1775.38, 624.996, 124.351, 1.48915, 3600, 3, 1, 12340),
(127162, 29630, 604, 3, 1, 0, 1775.55, 616.143, 124.209, 6.14397, 3600, 3, 1, 12340),
(127163, 29630, 604, 3, 1, 0, 1775.88, 639.901, 124.356, 1.54188, 3600, 3, 1, 12340),
(127164, 29630, 604, 3, 1, 0, 1776.1, 612.057, 124.307, 4.38664, 3600, 3, 1, 12340),
(127165, 29630, 604, 3, 1, 0, 1776.1, 608.581, 124.47, 6.13198, 3600, 3, 1, 12340),
(127166, 29630, 604, 3, 1, 0, 1776.37, 621.283, 124.33, 3.45676, 3600, 3, 1, 12340),
(127167, 29630, 604, 3, 1, 0, 1776.78, 617.24, 124.293, 2.08767, 3600, 3, 1, 12340),
(127168, 29630, 604, 3, 1, 0, 1777.12, 642.278, 124.321, 0.337474, 3600, 3, 1, 12340),
(127169, 29630, 604, 3, 1, 0, 1777.46, 646.468, 124.54, 4.47191, 3600, 3, 1, 12340),
(127170, 29630, 604, 3, 1, 0, 1777.82, 627.604, 124.335, 1.77085, 3600, 3, 1, 12340),
(127171, 29630, 604, 3, 1, 0, 1777.98, 619.287, 124.277, 0.214523, 3600, 3, 1, 12340),
(127172, 29630, 604, 3, 1, 0, 1778.34, 644.76, 124.285, 2.67503, 3600, 3, 1, 12340),
(127173, 29630, 604, 3, 1, 0, 1778.75, 636.656, 124.343, 5.68044, 3600, 3, 1, 12340),
(127174, 29630, 604, 3, 1, 0, 1779.29, 614.474, 124.542, 3.44442, 3600, 3, 1, 12340),
(127175, 29630, 604, 3, 1, 0, 1779.51, 608.325, 124.475, 2.92296, 3600, 3, 1, 12340),
(127176, 29630, 604, 3, 1, 0, 1779.76, 635.624, 124.337, 1.42147, 3600, 3, 1, 12340),
(127177, 29630, 604, 3, 1, 0, 1779.94, 631.854, 124.364, 4.0391, 3600, 3, 1, 12340),
(127178, 29630, 604, 3, 1, 0, 1780.45, 647.699, 124.465, 2.71358, 3600, 3, 1, 12340),
(127179, 29630, 604, 3, 1, 0, 1780.48, 618.845, 124.408, 1.26915, 3600, 3, 1, 12340),
(127180, 29630, 604, 3, 1, 0, 1781.27, 621.212, 124.501, 0.93217, 3600, 3, 1, 12340),
(127181, 29630, 604, 3, 1, 0, 1781.65, 651.504, 124.477, 1.87387, 3600, 3, 1, 12340),
(127182, 29630, 604, 3, 1, 0, 1782.13, 624.315, 124.2, 4.01465, 3600, 3, 1, 12340),
(127183, 29630, 604, 3, 1, 0, 1782.63, 637.238, 124.285, 3.93426, 3600, 3, 1, 12340),
(127184, 29630, 604, 3, 1, 0, 1782.67, 616.523, 124.466, 3.73405, 3600, 3, 1, 12340),
(127185, 29630, 604, 3, 1, 0, 1782.87, 638.108, 124.275, 4.62721, 3600, 3, 1, 12340),
(127186, 29630, 604, 3, 1, 0, 1783.23, 610.104, 124.479, 6.05261, 3600, 3, 1, 12340),
(127187, 29630, 604, 3, 1, 0, 1785.33, 647.93, 124.471, 5.82058, 3600, 3, 1, 12340),
(127188, 29630, 604, 3, 1, 0, 1785.53, 606.06, 124.592, 2.33453, 3600, 3, 1, 12340),
(127189, 29630, 604, 3, 1, 0, 1785.73, 626.187, 124.534, 4.0773, 3600, 3, 1, 12340),
(127190, 29630, 604, 3, 1, 0, 1785.95, 637.734, 124.333, 5.24175, 3600, 3, 1, 12340),
(127191, 29630, 604, 3, 1, 0, 1785.97, 632.102, 124.272, 4.62741, 3600, 3, 1, 12340),
(127192, 29630, 604, 3, 1, 0, 1786.11, 616.807, 124.473, 1.52202, 3600, 3, 1, 12340),
(127193, 29630, 604, 3, 1, 0, 1786.24, 645.366, 124.469, 3.17668, 3600, 3, 1, 12340),
(127194, 29630, 604, 3, 1, 0, 1786.25, 620.146, 124.473, 0.549983, 3600, 3, 1, 12340),
(127195, 29630, 604, 3, 1, 0, 1786.47, 635.198, 124.595, 6.26547, 3600, 3, 1, 12340),
(127196, 29630, 604, 3, 1, 0, 1787.06, 638.964, 124.472, 2.4788, 3600, 3, 1, 12340),
(127197, 29630, 604, 3, 1, 0, 1787.41, 634.924, 124.508, 4.38103, 3600, 3, 1, 12340),
(127198, 29630, 604, 3, 1, 0, 1788.7, 624.401, 124.475, 5.06169, 3600, 3, 1, 12340),
(127199, 29630, 604, 3, 1, 0, 1789.04, 628.566, 124.606, 2.65171, 3600, 3, 1, 12340),
-- New
(131070, 29630, 604, 3, 1, 0, 1789.35, 648.052, 124.487, 4.072, 3600, 3, 1, 12340),
(131074, 29630, 604, 3, 1, 0, 1791.69, 635.941, 124.476, 4.73741, 3600, 3, 1, 12340),
(131076, 29630, 604, 3, 1, 0, 1792.78, 622.872, 124.583, 3.022, 3600, 3, 1, 12340),
(131082, 29630, 604, 3, 1, 0, 1794.95, 639.011, 124.53, 1.68395, 3600, 3, 1, 12340);

-- Ruins Dweller
DELETE FROM `creature` WHERE (`guid` BETWEEN 127201 AND 127206 OR `guid` IN (131084,131085,131086)) AND `id` = 29920;
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `wander_distance`, `MovementType`, `VerifiedBuild`) VALUES
(127201, 29920, 604, 3, 1, 0, 1651.26, 936.455, 107.277, 6.02139, 3600, 10, 1, 0),
(127202, 29920, 604, 3, 1, 0, 1643.2, 943.617, 107.276, 0.087266, 3600, 10, 1, 0),
(127203, 29920, 604, 3, 1, 0, 1644.73, 936.472, 107.288, 1.58825, 3600, 10, 1, 0),
(127204, 29920, 604, 3, 1, 0, 1705.06, 932.755, 116.670, 5.25918, 3600, 10, 1, 12340),
(127205, 29920, 604, 3, 1, 0, 1701.37, 953.039, 115.920, 4.77390, 3600, 10, 1, 12340),
(127206, 29920, 604, 3, 1, 0, 1712.55, 947.897, 116.977, 1.89526, 3600, 10, 1, 12340),
(131084, 29920, 604, 3, 1, 0, 1730.20, 947.692, 116.205, 2.10299, 3600, 10, 1, 12340),
(131085, 29920, 604, 3, 1, 0, 1751.98, 967.356, 115.964, 0.46397, 3600, 10, 1, 12340),
(131086, 29920, 604, 3, 1, 0, 1730.49, 972.948, 116.201, 5.76990, 3600, 10, 1, 12340);

-- Fix addon data
-- Drakkari Battle Rider - Abandon Vehicle on Poly
UPDATE `creature_template_addon` SET `bytes2` = 1, `auras` = "54775" WHERE `entry` IN (29836,30925);

DELETE FROM `creature_addon` WHERE `guid` IN (SELECT `guid` FROM `creature` WHERE `id` = 29307);
DELETE FROM `creature_template_addon` WHERE `entry` IN (29307,31365,30928);
INSERT INTO `creature_template_addon` (`entry`, `path_id`, `mount`, `bytes1`, `bytes2`, `emote`, `visibilityDistanceType`, `auras`) VALUES
-- Drakkari Colossus - Freeze Anim, Mortal Strikes
(29307,0,0,0,1,0,0,"16245 54715"),
(31365,0,0,0,1,0,0,"16245 59454"),
-- Drakkari Frenzy - Thrash
(30928,0,0,0,1,0,0,"54913");

-- Fix sheath
UPDATE `creature_template_addon` SET `bytes2` = 1 WHERE `entry` IN (29573,31367,29982,30934,29838,30935,29931,30936,29306,31368,30298,22517);
-- Empty / not needed
DELETE FROM `creature_addon` WHERE `guid` IN (SELECT `guid` FROM `creature` WHERE `id` IN (29874,13321,29306,29304,2914,22517,29768) AND `path_id` = 0);
DELETE FROM `creature_template_addon` WHERE `entry` IN (13321,2914);
-- Moorabi, emote handled by spell he casts OOC
DELETE FROM `creature_addon` WHERE `guid` IN (SELECT `guid` FROM `creature` WHERE `id` = 29305);
