-- Caverns of Time: Stratholme rework
SET @DAY = 86400;
SET @CGUID = 700300; -- creature GUIDs (4 creature);
DELETE FROM `creature` WHERE `guid` BETWEEN @CGUID+00 AND @CGUID+03;

-- Move additional Chromie spawns to DB
INSERT INTO `creature` (`guid`,`id`,`map`,`spawnMask`,`phaseMask`,`position_x`,`position_y`,`position_z`,`orientation`,`spawntimesecs`,`spawndist`,`movementtype`) VALUES
(@CGUID+00, 27915, 595, 3, 1, 1813.298, 1283.578, 142.3258, 3.878161, @DAY, 0, 0);

-- Chromie AI
UPDATE `creature_template` SET `ScriptName`="npc_chromie_start" WHERE `entry`=26527;
UPDATE `creature_template` SET `ScriptName`="npc_chromie_middle" WHERE `entry`=27915;
-- Chromie whispers
DELETE FROM `creature_text` WHERE `creatureid`=27915 AND `groupid`=1;
INSERT INTO `creature_text` (`creatureid`,`groupid`,`id`,`text`,`type`,`probability`,`BroadcastTextId`,`TextRange`,`emote`,`comment`) VALUES
(27915, 1, 0, "Come over here time traveller, we need to talk!", 15, 100, 29167, 0, 70, "Chromie - WHISPER_COME_TALK"),
(27915, 1, 1, "Quick, over here!", 15, 100, 29169, 0, 70, "Chromie - WHISPER_COME_TALK"),
(27915, 1, 2, "We meet again, time traveller!", 15, 100, 29168, 0, 70, "Chromie - WHISPER_COME_TALK");

-- Corruptor of Time
DELETE FROM `conditions` WHERE `SourceTypeOrReferenceId` = 13 AND `SourceEntry`=60422;
INSERT INTO `conditions` (`SourceTypeOrReferenceId`, `SourceGroup`, `SourceEntry`, `ConditionTypeOrReference`, `ConditionTarget`, `ConditionValue1`, `ConditionValue2`, `Comment`) VALUES
(13, 1, 60422, 31, 0, 3, 32281, "Corruption of Time - Implicitly target Guardian of Time");

-- Starting inn RP fluff
DELETE FROM `areatrigger_scripts` WHERE `entry`=5291;
INSERT INTO `areatrigger_scripts` (`entry`,`ScriptName`) VALUES (5291,"at_stratholme_inn_stairs_cot");
UPDATE `creature` SET `movementtype`=0,`spawndist`=0 WHERE `id`=30571;
UPDATE `creature_addon` SET `bytes1`=0 WHERE `guid` IN (SELECT guid FROM `creature` WHERE `id`=30571);
UPDATE `creature_template` SET `ScriptName`="",`AIName`="SmartAI" WHERE `entry`=30571;
UPDATE `creature_template` SET `ScriptName`="npc_hearthsinger_forresten_cot",`AIName`="" WHERE `entry`=30551;
DELETE FROM `smart_scripts` WHERE `entryorguid` = 30571 AND `source_type`=0;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`action_type`,`action_param1`,`action_param2`,`target_type`,`target_param1`,`target_param2`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(30571, 0, 0, 1, 72, 100, 1, 100,  0, 17,  0, 0,  1,     0,   0,        0,        0,        0,        0, "Michael Belfast - On Action 100 - Set Emote State None (No Repeat)"),
(30571, 0, 1, 2, 61, 100, 1,   0,  0, 59,  0, 0,  0,     0,   0,        0,        0,        0,        0, "Michael Belfast - On Action 100 - Set Run (false) (No Repeat)"),
(30571, 0, 2, 0, 61, 100, 1,   0,  0, 69, 42, 0,  8,     0,   0, 1554.371, 587.4865, 99.77525, 1.107272, "Michael Belfast - On Action 100 - Move Position (ID 42) (No Repeat)"),
(30571, 0, 3, 0, 34, 100, 1,   8, 42, 45,  1, 1, 11, 30551, 100,        0,        0,        0,        0, "Michael Belfast - On Movement Inform (ID 42) - Set Data 1-1 on Hearthsinger Forresten (within 100yd) (No Repeat)");
DELETE FROM `creature_text` WHERE `creatureid` IN (30551,30552,30553,30561,30571,31017);
INSERT INTO `creature_text` (`creatureid`,`groupid`,`id`,`text`,`type`,`probability`,`BroadcastTextId`,`emote`,`comment`) VALUES
(30571, 0, 0, "What were you doing in my cellar? There's a food scare going on, and the last thing I need is strangers rummaging around in my goods! Shoo!", 12, 100, 31323, 5, "Michael Belfast - SAY_CELLAR"),
(30571, 0, 1, "Hey! Stop rooting around in my cellar! Clear out!", 12, 100, 31322, 5, "Michael Belfast - SAY_CELLAR"),
(30551, 0, 0, "This whole situation seems a bit paranoid, don't you think?", 12, 100, 31324, 1, "Hearthsinger Forresten - LINE_FORREST_1"),
(30553, 0, 0, "Orders are orders. If the Prince says jump...", 12, 100, 31325, 1, "Footman James - LINE_JAMES_1"),
(30552, 0, 0, "It's a strange order, you can't deny. Suspicious food? Under that definition, you should arrest Belfast!", 12, 100, 31326, 1, "Fras Siabi - LINE_FRAS_1"),
(30571, 1, 0, "I HEARD THAT! No more ale for you! Not a drop!", 12, 100, 31327, 22, "Michael Belfast - LINE_BELFAST_1"),
(31017, 0, 0, "Enough, Michael. Business is hurting enough with this scare as it is. We can use every copper.", 12, 100, 32560, 1, "Mal Corricks - LINE_MAL_1"),
(30561, 0, 0, "The soldiers are doing important work. The safety of the people is more important, Mal, if you're interested in your customers living to spend another day.", 12, 100, 32571, 1, "Gryan Stoutmantle - LINE_GRYAN_1"),
(31017, 1, 0, "%s grudgingly nods.", 16, 100, 32569, 273, "Mal Corricks - LINE_MAL_2"),
(31017, 2, 0, "I can't argue with that.", 12, 100, 32570, 1, "Mal Corricks - LINE_MAL_3"),
(30553, 1, 0, "Don't worry too much. By the time I went off duty, we hadn't found a scrap of befouled grain here.", 12, 100, 32572, 1, "Footman James - LINE_JAMES_2"),
(30551, 1, 0, "Thank the Light for that.", 12, 100, 32573, 1, "Hearthsinger Forresten - LINE_FORREST_2"),
(30552, 1, 0, "%s nods.", 16, 100, 32574, 273, "Fras Siabi - LINE_FRAS_2");

-- Fix a random typo in AI name for Grain Crate Helper
UPDATE `creature_template` SET `ScriptName`="npc_crate_helper_cot" WHERE `entry`=27827;

-- Arcane Disruption: Require active grain crate within 8yd, and implicitly target the helper for that crate
DELETE FROM `conditions` WHERE `SourceTypeOrReferenceId` IN (13,17) AND `SourceEntry`=49590;
INSERT INTO `conditions` (`SourceTypeOrReferenceId`, `SourceGroup`, `SourceEntry`, `ConditionTypeOrReference`, `ConditionTarget`, `ConditionValue1`, `ConditionValue2`, `ErrorType`, `Comment`) VALUES
(13, 1, 49590, 31, 0, 3,  27827,  0, "Arcane Disruption - Implicitly target Grain Crate Helper"),
(17, 0, 49590, 30, 0, 190094, 8, 11, "Arcane Disruption - Must be within 8yd of Suspicious Grain Crate"),
(17, 0, 49590, 29, 0,  27827, 8, 11, "Arcane Disruption - Must be within 8yd of Grain Crate Helper");

-- Arcane Disruption should ignore Line of Sight because the helper NPC is spawned inside the crates
DELETE FROM `disables` WHERE `sourceType`=0 AND `entry`=49590;
INSERT INTO `disables` (`sourceType`, `entry`, `flags`) VALUES
(0, 49590, 64);

-- Make Suspicious Grain Crate and Grain Crate Helper never respawn
UPDATE `creature` SET `spawntimesecs`=@DAY WHERE `id`=27827;
UPDATE `gameobject` SET `spawntimesecs`=@DAY WHERE `id`=190094;

-- Grain Crate reaction fluff
UPDATE `creature` SET `movementtype`=0,`spawndist`=0 WHERE `id` IN (27884,27885,27891,27892,27907);
-- Event #1:
UPDATE `creature_template` SET `AIName`="",`ScriptName`="npc_jena_anderson" WHERE `entry`=27885;
UPDATE `creature_template` SET `AIName`="",`ScriptName`="npc_martha_goslin" WHERE `entry`=27884;
UPDATE `creature` SET `position_x`=1635.827,`position_y`=723.0861,`position_z`=113.6452,`orientation`=3.089233 WHERE `id`=27884;
DELETE FROM `creature_text` WHERE `creatureid` IN (27884,27885);
INSERT INTO `creature_text` (`creatureid`,`groupid`,`text`,`type`,`probability`,`emote`,`BroadcastTextId`,`comment`) VALUES
(27884,0,"Oh hello, Jena. Of course you can borrow some grain. Help yourself.",12,100,1,27232,"LINE_MARTHA1"),
(27884,1,"Oh, my.",12,100,1,27235,"LINE_MARTHA2"),
(27885,0,"Let's see, we had chicken last night.",12,100,0,27219,"LINE_JENA1"),
(27885,1,"I've got plenty of cured bacon, but he had some for breakfast.",12,100,0,27220,"LINE_JENA2"),
(27885,2,"I need to make something healthy for him, he's still not recovered from that illness from last week.",12,100,0,27221,"LINE_JENA3"),
(27885,3,"Strawberries! Oh wait, they're not in season.",12,100,0,27222,"LINE_JENA4"),
(27885,4,"Ah, I'll make him some fresh bread! I need to get some flour from Martha!",12,100,0,27223,"LINE_JENA5"),
(27885,5,"Martha, I'm out of flour for bread. You wouldn't happen to have any grain from that recent shipment, would you?",12,100,6,27224,"LINE_JENA6"),
(27885,6,"Thanks, Martha! I owe you one.",12,100,1,27229,"LINE_JENA7"),
(27885,7,"Oh, dear.",12,100,0,27230,"LINE_JENA8"),
(27885,8,"Martha, something's wrong with this grain! Some of the Prince's soldiers were looking for this. I'm going to go look for one.",12,100,5,27231,"LINE_JENA9");
-- Event #2:
UPDATE `creature` SET `position_x`=1670.256, `position_y`=872.8734, `position_z`=120.0351, `orientation`=0.418879 WHERE `id`=27907;
UPDATE `creature_template` SET `AIName`="",`ScriptName`="npc_bartleby_battson" WHERE `entry`=27907;
DELETE FROM `creature_text` WHERE `creatureid`=27907;
INSERT INTO `creature_text` (`creatureid`,`groupid`,`id`,`text`,`type`,`probability`,`emote`,`BroadcastTextId`,`comment`) VALUES
(27907,0,0,"I'm going to lose my on time bonus because of this!",12,10,0,27255,"LINE_BARTLEBY_IDLE 1"),
(27907,0,1,"I wasn't even supposed to be here today!",12,10,0,27256,"LINE_BARTLEBY_IDLE 2"),
(27907,1,0,"Well, guess I should load everything back into the cart.",12,100,0,27257,"LINE_BARTLEBY1"),
(27907,2,0,"Oh, come on! My cart broke, my horse lost a shoe, and now the cargo goes bad!",12,100,5,27258,"LINE_BARTLEBY2"),
(27907,3,0,"I guess I'll go find the authorities. If I'm lucky they'll tell me it's the plague and that we're all going to die.",12,100,0,27259,"LINE_BARTLEBY3");
-- Event #3:
UPDATE `creature_template` SET `AIName`="",`ScriptName`="npc_malcolm_moore" WHERE `entry`=27891;
UPDATE `creature_template` SET `AIName`="",`ScriptName`="npc_stratholme_rp_dummy" WHERE `entry`=27892;
DELETE FROM `creature_text` WHERE `creatureid` IN (27891,27892);
INSERT INTO `creature_text` (`creatureid`,`groupid`,`text`,`type`,`probability`,`emote`,`BroadcastTextId`,`comment`) VALUES
(27891,0,"Looks like a storm's coming in, Scruffy...",12,100,0,27236,"LINE_MALCOLM1"),
(27892,0,"%s begins to growl...",16,100,0,27237,"LINE_SCRUFFY1"),
(27891,1,"What's wrong, pal?",12,100,1,27238,"LINE_MALCOLM2"),
(27891,2,"What did you find, boy?",12,100,16,27240,"LINE_MALCOLM3"),
(27891,3,"This is no good, Scruffy. Stay here and guard the house, I need to go find a soldier.",12,100,0,27241,"LINE_MALCOLM4");
-- Event #4:
UPDATE `creature` SET `position_x`=1563.337, `position_y`=671.6413, `position_z`=102.1412, `orientation`=4.2586040 WHERE `id`=27876;
UPDATE `creature` SET `position_x`=1561.571, `position_y`=670.3199, `position_z`=102.1444, `orientation`=0.5759587 WHERE `id`=27877;
UPDATE `creature_template` SET `AIName`="", `ScriptName`="npc_sergeant_morigan" WHERE `entry`=27877;
DELETE FROM `creature_text` WHERE `creatureid` IN (27876,27877);
INSERT INTO `creature_text` (`creatureid`,`groupid`,`id`,`text`,`type`,`probability`,`emote`,`BroadcastTextId`,`comment`) VALUES
(27876,0,0,"No, Sergeant.",12,100,274,27198,"LINE_PERELLI_NO #1"),
(27876,0,1,"No, sir.",12,100,274,27199,"LINE_PERELLI_NO #2"),
(27876,0,2,"Nope.",12,100,274,27200,"LINE_PERELLI_NO #3"),
(27876,1,0,"Yes, sir.",12,100,1,27201,"LINE_PERELLI_YES #1"),
(27876,1,1,"Yes, Sergeant Morigan.",12,100,1,27202,"LINE_PERELLI_YES #2"),
(27876,1,2,"Absolutely.",12,100,1,27203,"LINE_PERELLI_YES #3"),
(27876,2,0,"What are you talking about, Sergeant!",12,100,5,27208,"LINE_PERELLI1"),
(27876,3,0,"You have to believe me, I'm innocent!",12,100,20,27213,"LINE_PERELLI2"),
(27877,0,0,"Mr. Perelli, have you seen any suspicious activity by men wearing dark robes in the last few weeks?",12,100,6,27190,"LINE_SERGEANT_ASK_NO #1"),
(27877,0,1,"Mr. Perelli, have you seen any signs of the undead? Any information you can provide would be appreciated by Prince Arthas.",12,100,1,27191,"LINE_SERGEANT_ASK_NO #2"),
(27877,0,2,"Mr. Perelli, I know you travel around quite a bit hawking your goods. Surely you've heard rumors or information about the Scourge?",12,100,1,27192,"LINE_SERGEANT_ASK_NO #3"),
(27877,0,3,"Do you plan on leaving the area soon if we have further questions?",12,100,1,27193,"LINE_SERGEANT_ASK_NO #4"),
(27877,1,0,"Mr. Perelli, have these goods been under your supervision at all times?",12,100,6,27194,"LINE_SERGEANT_ASK_YES #1"),
(27877,1,1,"You wouldn't happen to have any canned turtle soup from Hillsbrad, would you?",12,100,1,27195,"LINE_SERGEANT_ASK_YES #2"),
(27877,1,2,"Mr. Perelli, if you happen across any signs of Scourge activity or shady dealings in your travels, let the nearest Lordaeron soldier know.",12,100,1,27197,"LINE_SERGEANT_ASK_YES #3"),
(27877,2,0,"You don't mind me checking out your merchandise for signs of tampering, do you?",12,100,1,27205,"LINE_SERGEANT_START"),
(27877,3,0,"Wait, what is this? You've been holding out on me, Perelli!",12,100,0,27206,"LINE_SERGEANT1"),
(27877,4,0,"I'm confiscating this suspicious grain, Perelli. We were looking for signs of tampered food, and it would be in your best interest to stay put while Prince Arthas checks this out.",12,100,1,27210,"LINE_SERGEANT2"),
(27877,5,0,"We'll see about that, Perelli. We'll see about that.",12,100,25,27216,"LINE_SERGEANT3");
-- Event #5:
UPDATE `creature` SET `position_x`=1588.942, `position_y`=597.9799, `position_z`=99.37262, `orientation`=2.80998 WHERE `id`=27903;
UPDATE `creature_template` SET `AIName`="", `ScriptName`="npc_roger_owens" WHERE `entry`=27903;
DELETE FROM `creature_text` WHERE `creatureid`=27903;
INSERT INTO `creature_text` (`creatureid`,`groupid`,`text`,`type`,`probability`,`emote`,`BroadcastTextId`,`comment`) VALUES
(27903,0,"Ok, enough work for now. Time for refreshments and a little conversation in the inn.",12,100,1,27247,"LINE_ROGER1"),
(27903,1,"Wait, what's that smell?",12,100,1,27248,"LINE_ROGER2"),
(27903,2,"Can't be me, I took a bath 3 days ago!",12,100,5,27249,"LINE_ROGER3"),
(27903,3,"Oh, close call. It's just the grain here.",12,100,5,27250,"LINE_ROGER4"),
(27903,4,"Wait a second. Grain isn't supposed to smell like THAT! I better go find a guard.",12,100,0,27252,"LINE_ROGER5");

-- Arthas AI
UPDATE `creature_template` SET `ScriptName`="npc_arthas_stratholme",`AIName`="" WHERE `entry`=26499;
UPDATE `creature_template` SET `unit_flags`=0x8000, `unit_flags2`=0x800 WHERE `entry` IN (26499,31210);
DELETE FROM `creature` WHERE `id`=26499;

-- Missing Arthas lines
DELETE FROM `creature_text` WHERE `creatureid`=26499 AND `groupid`>38;
INSERT INTO `creature_text` (`creatureid`,`groupid`,`id`,`text`,`type`,`probability`,`BroadcastTextId`,`TextRange`,`comment`) VALUES
(26499,39,0,"I can't afford to spare you.",12,100,31355,0,"Arthas SAY_AGGRO_ZOMBIE"),
(26499,40,0,"All officers should check in with me when their squads are ready. We'll enter Stratholme on my order.",12,100,27517,3,"Arthas RP1_LINE_ARTHAS11");

-- Dummy spell scripts
DELETE FROM `spell_script_names` WHERE `spell_id`=50773;
INSERT INTO `spell_script_names` (`spell_id`,`scriptname`) VALUES (50773,"spell_stratholme_crusader_strike");

-- Arthas/Uther RP data
UPDATE `creature_template` SET `ScriptName`="npc_stratholme_rp_dummy",`AIName`="" WHERE `entry` IN (26528,26497);
UPDATE `creature_text` SET `TextRange`=3 WHERE `creatureid` IN (26499,26528,26497,26529,26530,26532,26533,32273);
UPDATE `creature_text` SET `emote`=396 WHERE
	(`creatureid` = 26499 AND `groupid` IN (0,3,5)) OR
	(`creatureid` = 26528 AND `groupid`=3) OR
	(`creatureid` = 26497 AND `groupid` IN (0,1));
UPDATE `creature_text` SET `emote`=1 WHERE `creatureid`=26499 AND `groupid`=7;
UPDATE `creature_text` SET `emote`=5 WHERE
	(`creatureid` = 26499 AND `groupid` IN (2,4)) OR
	(`creatureid` = 26528 AND `groupid` IN (1,4));
UPDATE `creature_text` SET `emote`=6 WHERE `creatureid`=26528 AND `groupid`=2;
UPDATE `creature_text` SET `emote`=397 WHERE
	(`creatureid` = 26528 AND `groupid` IN (0,5));

-- Arthas/Mal'ganis RP data
DELETE FROM `creature_text` WHERE `creatureid` IN (28167,28169);
INSERT INTO `creature_text` (`creatureid`,`groupid`,`text`,`type`,`probability`,`BroadcastTextId`,`TextRange`,`emote`,`comment`) VALUES
(28167, 0, "Prince Arthas, may the light be praised! Many people in the town have begun to fall seriously ill, can you help us?", 12, 100, 27547, 0, 1, "RP2_LINE_CITIZEN1"),
(28167, 1, "What? This can't be!", 12, 100, 27549, 0, 274, "RP2_LINE_CITIZEN2"),
(28169, 0, "Oh, no...", 12, 100, 27552, 0, 0, "RP2_LINE_RESIDENT1");
UPDATE `creature_text` SET `emote`=1 WHERE
	(`creatureid` = 26499 AND `groupid` IN (12,14)) OR
	(`creatureid` = 26533 AND `groupid`=0);
UPDATE `creature_text` SET `emote`=397 WHERE
	(`creatureid` = 26499 AND `groupid`=13);
	
-- Town Hall/Gauntlet RP data
UPDATE `creature_text` SET `emote`=1 WHERE
	(`creatureid`=26499 AND `groupid` IN (16,19,22,38)) OR
	(`creatureid`=28340 AND `groupid`=1);
UPDATE `creature_text` SET `emote`=5 WHERE
	(`creatureid`=26499 AND `groupid`=36);
UPDATE `creature_text` SET `emote`=396 WHERE
	(`creatureid`=26499 AND `groupid` IN (21,24,25,26,27,31,32,33,34));
UPDATE `creature_text` SET `emote`=432 WHERE
	(`creatureid`=26499 AND `groupid` IN (29));
	
-- Clean up some incorrect spawns in wave area
DELETE FROM `creature` WHERE `guid` BETWEEN 143949 AND 143952;

-- spawn group data
DELETE FROM `spawn_group` WHERE `groupId` BETWEEN 52 and 56;
-- middle chromie
INSERT INTO `spawn_group` (`groupId`,`spawnType`,`spawnId`) VALUES (52, 0, 700300);
-- crate helpers
INSERT INTO `spawn_group` SELECT 53 as `groupId`, 0 as `spawnType`, `guid` as `spawnId` FROM `creature` WHERE `id`=27827;
-- Blanket apply a spawn group to all "live stratholme" mobs that prevents them respawning after the purge begins
UPDATE `creature_template` SET `ScriptName`="",`AIName`="", `flags_extra`=(`flags_extra`|2) WHERE `entry` IN (28167,31126,31019,28169,31127,31023,31020,31018,31028);
UPDATE `creature_template` SET `ScriptName`="",`AIName`="SmartAI" WHERE `entry` IN (31057,30570,31027,31021,30994);
INSERT INTO `spawn_group` SELECT 56 as `groupId`, 0 as `spawnType`, `guid` as `spawnId` FROM `creature` WHERE `id` IN (28167,28169,30570,30994,31018,31019,31020,31021,31023,31027,31028,31057,31126,31127);
-- Do the same for undead stratholme mobs
UPDATE `creature_template` SET `ScriptName`="",`AIName`="SmartAI" WHERE `entry` IN (28249,27729,28200,27734,27731,28199,27736,28201);
INSERT INTO `spawn_group` SELECT 55 as `groupId`, 0 as `spawnType`, `guid` as `spawnId` FROM `creature` WHERE `id` IN (27729,27731,27734,27736,27737,28199,28200,28201,28249);
-- Gauntlet trash gets its own spawn group...
UPDATE `spawn_group` sg LEFT JOIN `creature` c on sg.`spawnId`=c.`guid` SET sg.`groupId`=54 WHERE (sg.`groupId`=55) AND (c.`position_x` BETWEEN 2028.0 AND 2372.0) AND (c.`position_y` BETWEEN 1115.0 AND 1355.0);

-- City fluff
DELETE FROM `smart_scripts` WHERE `entryorguid` IN (30570,31027,31021) AND `source_type`=0;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`event_type`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`action_type`,`target_type`,`comment`) VALUES
(30570,0,0,10,100,7,1,10,1,1,"Emery Neill - Within 1-10 Range Out of Combat LoS - Say Line 0"),
(31027,0,0,10,100,7,1,10,1,1,"Leeka Turner - Within 1-10 Range Out of Combat LoS - Say Line 0"),
(31021,0,0,10,100,7,1,10,1,1,"Sophie Aaren - Within 1-10 Range Out of Combat LoS - Say Line 0");

DELETE FROM `creature_text` WHERE `creatureid` IN (30570,31027,31021);
INSERT INTO `creature_text` (`creatureid`,`groupid`,`id`,`text`,`type`,`probability`,`BroadcastTextId`,`emote`,`comment`) VALUES
(30570,0,0,"The Stone Crow's closed today, sorry. There are too many health concerns, and I'm not about to have Ed under fire for supposedly making people sick.",12,100,31724,1,"Emery Neill TALK_FLUFF 1"),
(30570,0,1,"I hate to disappoint people, but the Stone Crow's closed. If the kids from the orphanage were evacuated, I don't see why we should be open, either.",12,100,31729,1,"Emery Neill TALK_FLUFF 2"),
(31027,0,0,"Look, I'll sell you shields today, but no maces. The last thing I want is for some innocent to get brained by one of my weapons.",12,100,31721,1,"Leeka Turner TALK_FLUFF 1"),
(31027,0,1,"I don't know how much longer I'll be open today with all the commotion outside. If you need something repaired, I'll take a quick look.",12,100,31722,1,"Leeka Turner TALK_FLUFF 2"),
(31027,0,2,"I hope you're not coming in here fixing for a fight. There are too many angry people on the streets today.",12,100,31720,1,"Leeka Turner TALK_FLUFF 3"),
(31021,0,0,"What's the commotion outside?",12,100,31730,1,"Sophie Aaren TALK_FLUFF 1"),
(31021,0,1,"Is something going on? I hear angry voices.",12,100,31731,1,"Sophie Aaren TALK_FLUFF 2"),
(31021,0,2,"Everything's been so strange lately...",12,100,31732,1,"Sophie Aaren TALK_FLUFF 3");

-- SmartAI fixes for wave creatures
UPDATE `smart_scripts` SET `event_param3`=3100, `event_param4`=3400 WHERE `entryorguid`=28200 AND `source_type`=0 AND `id` IN (0,1);

-- Lordaeron Crier yells
DELETE FROM `creature_text` WHERE `creatureid` = 27913;
INSERT INTO `creature_text` (`creatureid`,`groupid`,`text`,`type`,`probability`,`BroadcastTextId`,`TextRange`,`comment`) VALUES
(27913, 0, "All soldiers of Lordaeron should immediately report to the entrance of Stratholme, and await further orders from Prince Arthas.", 14, 100, 27263, 3, "Lordaeron Crier CALL_TO_GATES"),
(27913, 1, "Scourge forces have been spotted near the King's Square fountain!", 14, 100, 27642, 3, "Lordaeron Crier KINGS_SQUARE"),
(27913, 2, "Scourge forces have been spotted near the Market Row Gate!", 14, 100, 27643, 3, "Lordaeron Crier MARKET_ROW"),
(27913, 3, "Scourge forces have been spotted near the Festival Lane Gate!", 14, 100, 27644, 3, "Lordaeron Crier FESTIVAL_LANE"),
(27913, 4, "Scourge forces have been spotted near the Elder's Square Gate!", 14, 100, 27645, 3, "Lordaeron Crier ELDERS_SQUARE"),
(27913, 5, "Scourge forces have been spotted near the Town Hall!", 14, 100, 27646, 3, "Lordaeron Crier TOWN_HALL");

-- Get rid of the colossal mess that is Risen Zombie SmartAI
UPDATE `creature_template` SET `AIName`="" WHERE `entry` = 27737;
DELETE FROM `smart_scripts` WHERE -`entryorguid` IN (SELECT `guid` FROM `creature` WHERE `id`=27737 AND `map`=595);
DELETE FROM `conditions` WHERE `SourceTypeOrReferenceId`=22 AND -`SourceEntry` IN (SELECT `guid` FROM `creature` WHERE `id`=27737 AND `map`=595);

-- Town Hall infinite spawns
INSERT INTO `creature` (`guid`,`id`,`map`,`spawnMask`,`phaseMask`,`position_x`,`position_y`,`position_z`,`orientation`,`spawntimesecs`,`spawndist`,`movementtype`) VALUES
(@CGUID+01, 28340, 595, 3, 1, 2398.715, 1207.334, 134.1223, 5.270895, @DAY, 0, 0),
(@CGUID+02, 28340, 595, 3, 1, 2401.265, 1202.789, 134.1039, 1.466077, @DAY, 0, 0),
(@CGUID+03, 28341, 595, 3, 1, 2402.654, 1205.786, 134.1223, 2.897247, @DAY, 0, 0);
UPDATE `creature_template` SET `unit_flags`=(`unit_flags`|0x100|0x200) WHERE `entry` IN (27742,27743,27744,31202,31203,31206,26532,31215,26533);

-- Town Hall RP event
DELETE FROM `creature_text` WHERE `creatureid`=28340;
INSERT INTO `creature_text` (`creatureid`,`groupid`,`text`,`type`,`probability`,`BroadcastTextId`,`TextRange`,`comment`) VALUES
(28340, 0, "Ah, you've finally arrived Prince Arthas. You're here just in the nick of time.", 12, 100, 27811, 3, "Stratholme Citizen (Disguised Infinite) RP3_LINE_CITIZEN1"),
(28340, 1, "There's no need for you to understand, Arthas. All you need to do is die.", 12, 100, 27815, 3, "Stratholme Citizen (Disguised Infinite) RP3_LINE_CITIZEN2");

-- Difficulty data for trash mobs
DELETE FROM `spelldifficulty_dbc` WHERE `id` IN (52660,52657,52635,52634);
INSERT INTO `spelldifficulty_dbc` (`id`,`spellid0`,`spellid1`) VALUES
(52660,52660,58817),
(52657,52657,58816),
(52635,52635,58820),
(52634,52634,58813);

-- SAI fixes for Town Hall trash
DELETE FROM `smart_scripts` WHERE `entryorguid` IN (28340,28341) AND `source_type`=0 AND `event_flags`=4;
UPDATE `smart_scripts` SET `id`=CEIL(`id`/2)+1 WHERE `entryorguid`=28340 AND `source_type`=0 AND `event_flags`=2;
UPDATE `smart_scripts` SET `id`=CEIL(`id`/2) WHERE `entryorguid`=28341 AND `source_type`=0 AND `event_flags`=2;
UPDATE `smart_scripts` SET `event_flags`=`event_flags`|4 WHERE `entryorguid` IN (28340,28341) AND `source_type`=0;
UPDATE `smart_scripts` SET `event_param3`=500, `event_param4`=750 WHERE `entryorguid`=28340 AND `source_type`=0 AND `id`=3;
DELETE FROM `conditions` WHERE `sourcetypeorreferenceid`=22 AND `sourceentry`=28340 AND `sourceid`=0;
INSERT INTO `conditions` (`sourcetypeorreferenceid`,`sourcegroup`,`sourceentry`,`sourceid`,`conditiontypeorreference`,`conditiontarget`,`conditionvalue1`,`conditionvalue2`,`comment`) VALUES
(22,4,28340,0,31,1,3,27743,"Stratholme Citizen - Only execute SAI if entry is 27743 (Infinite Agent)");

-- Chromie #3 data
DELETE FROM `creature_template_addon` WHERE `entry`=30997;
INSERT INTO `creature_template_addon` (`entry`,`bytes1`) VALUES
(30997,50331648);
DELETE FROM `creature_template_movement` WHERE `creatureid`=30997;
INSERT INTO `creature_template_movement` (`creatureid`,`ground`,`flight`) VALUES (30997,1,2);
DELETE FROM `creature_text` WHERE `creatureid`=30997;
INSERT INTO `creature_text` (`creatureid`,`groupid`,`text`,`type`,`probability`,`BroadcastTextId`,`comment`) VALUES
(30997,0,"Why, hello again!",12,100,32022,"Chromie #3 RP5_LINE_CHROMIE0");

-- Meathook
DELETE FROM `spelldifficulty_dbc` WHERE `id` IN (52696,52666);
INSERT INTO `spelldifficulty_dbc` (`id`,`spellid0`,`spellid1`) VALUES
(52696,52696,58823),
(52666,52666,58824);

-- Salramm the Fleshcrafter
DELETE FROM `spell_script_names` WHERE `ScriptName`='spell_salramm_steal_flesh';
INSERT INTO `spell_script_names` (`spell_id`,`ScriptName`) VALUES
(52708,'spell_salramm_steal_flesh');
DELETE FROM `spelldifficulty_dbc` WHERE `id` IN (52480,57725);
INSERT INTO `spelldifficulty_dbc` (`id`,`spellid0`,`spellid1`) VALUES
(52480,52480,58825),
(57725,57725,58827);

-- Chrono-Lord Epoch
DELETE FROM `spelldifficulty_dbc` WHERE `id` IN (52737,52771);
INSERT INTO `spelldifficulty_dbc` (`id`,`spellid0`,`spellid1`) VALUES
(52737,52737,58829),
(52771,52771,58830);

-- Mal'ganis
DELETE FROM `spelldifficulty_dbc` WHERE `id` IN (52720,52722,52721);
INSERT INTO `spelldifficulty_dbc` (`id`,`spellid0`,`spellid1`) VALUES
(52720,52720,58852),
(52722,52722,58850),
(52721,52721,58849);

-- Spline chain data
DELETE FROM `script_spline_chain_meta` WHERE `entry` IN (26499,26497,26528,28167,26532,27742,27907,27891,27892,27884,27885,27877,27903);
INSERT INTO `script_spline_chain_meta` (`entry`,`chainId`,`splineId`,`expectedDuration`,`msUntilNext`) VALUES
(26499, 1, 0, 3341, 2391),
(26499, 1, 1, 3167, 2453),
(26499, 1, 2, 2548, 1218),
(26499, 1, 3, 2864, 1204),
(26499, 1, 4, 2870, 0),
(26497, 1, 0, 4710, 3641),
(26497, 1, 1, 3684, 2422),
(26497, 1, 2, 3639, 0),
(26528, 1, 0, 5743, 4641),
(26528, 1, 1, 5579, 4844),
(26528, 1, 2, 4219, 3578),
(26528, 1, 3, 1549, 0),
(26499, 2, 0, 4113, 2438),
(26499, 2, 1, 4586, 3641),
(26499, 2, 2, 3298, 0),
(26528, 2, 0, 3930, 0),
(26497, 2, 0, 2598, 0),
(26528, 3, 0, 11271, 9703),
(26528, 3, 1, 6575, 4860),
(26528, 3, 2, 9893, 8469),
(26528, 3, 3, 8798, 7171),
(26528, 3, 4, 9000, 0),
(26497, 3, 0, 2911, 0),
(26497, 4, 0, 12325, 11047),
(26497, 4, 1, 8166, 7296),
(26497, 4, 2, 8154, 7266),
(26497, 4, 3, 6745, 6063),
(26497, 4, 4, 9386, 0),
(26499, 3, 0, 6366, 4813),
(26499, 3, 1, 4957, 3671),
(26499, 3, 2, 3972, 2344),
(26499, 3, 3, 4644, 0),
(26499, 4, 0, 2855, 1156),
(26499, 4, 1, 3214, 2578),
(26499, 4, 2, 2427, 1203),
(26499, 4, 3, 2663, 1219),
(26499, 4, 4, 3016, 2437),
(26499, 4, 5, 1825, 1204),
(26499, 4, 6, 3126, 2406),
(26499, 4, 7, 2751, 1234),
(26499, 4, 8, 2849, 1219),
(26499, 4, 9, 4704, 3578),
(26499, 4, 10, 2073, 1266),
(26499, 4, 11, 1860, 1218),
(26499, 4, 12, 1928, 0),
(26499, 5, 0, 4032, 2266),
(26499, 5, 1, 4170, 2594),
(26499, 5, 2, 4925, 3453),
(26499, 5, 3, 5560, 0),
(26499, 6, 0, 3285, 0),
(26499, 7, 0, 2247, 0),
(28167, 1, 0, 2109, 0),
(26499, 91, 0, 1862, 812),
(26499, 91, 1, 1990, 1219),
(26499, 91, 2, 1831, 0),
(26499, 92, 0, 2007, 0),
(26499, 95, 0, 2801, 1203),
(26499, 95, 1, 3454, 2406),
(26499, 95, 2, 2278, 1203),
(26499, 95, 3, 3222, 2453),
(26499, 95, 4, 2819, 0),
(26499, 96, 0, 1770, 0),
(26499, 97, 0, 2572, 1203),
(26499, 97, 1, 2696, 1203),
(26499, 97, 2, 2289, 1219),
(26499, 97, 3, 2102, 1219),
(26499, 97, 4, 2940, 1219),
(26499, 97, 5, 3202, 0),
(26499, 98, 0, 1838, 1219),
(26499, 98, 1, 1843, 1015),
(26499, 98, 2, 2029, 1391),
(26499, 98, 3, 1645, 0),
(26532, 1, 0, 2677, 0),
(27742, 1, 0, 2871, 0),
(27742, 2, 0, 2662, 0),
(27742, 3, 0, 2454, 0),
(27742, 4, 0, 2259, 0),
(27742, 5, 0, 1884, 0),
(27742, 6, 0, 3268, 0),
(27742, 7, 0, 2100, 0),
(27742, 8, 0, 3187, 0),
(27742, 9, 0, 2649, 0),
(27742, 10, 0, 888, 0),
(27742, 11, 0, 871, 0),
(27742, 12, 0, 844, 0),
(26499, 101, 0, 3239, 2031),
(26499, 101, 1, 2072, 1406),
(26499, 101, 2, 2380, 1219),
(26499, 101, 3, 1975, 0),
(26499, 128, 0, 1934, 1157),
(26499, 128, 1, 1843, 1078),
(26499, 128, 2, 2542, 1422),
(26499, 128, 3, 2651, 1203),
(26499, 128, 4, 4784, 3547),
(26499, 128, 5, 2204, 1281),
(26499, 128, 6, 2250, 1250),
(26499, 128, 7, 3174, 2297),
(26499, 128, 8, 1604, 0),
(26499, 1024, 0, 3268, 2422),
(26499, 1024, 1, 3636, 2422),
(26499, 1024, 2, 4245, 3640),
(26499, 1024, 3, 3058, 2469),
(26499, 1024, 4, 3931, 2390),
(26499, 1024, 5, 5062, 3656),
(26499, 1024, 6, 4970, 3844),
(26499, 1024, 7, 3764, 2375),
(26499, 1024, 8, 4819, 0),
(26499, 1025, 0, 4244, 3500),
(26499, 1025, 1, 4211, 2422),
(26499, 1025, 2, 5342, 4031),
(26499, 1025, 3, 5534, 4797),
(26499, 1025, 4, 4503, 2421),
(26499, 1025, 5, 5721, 4766),
(26499, 1025, 6, 4335, 0),
(26499, 121, 0, 3065, 2282),
(26499, 121, 1, 1871, 1203),
(26499, 121, 2, 2231, 1219),
(26499, 121, 3, 4427, 3828),
(26499, 121, 4, 3740, 2250),
(26499, 121, 5, 2766, 0),
(26499, 124, 0, 3499, 0),
(26499, 125, 0, 7907, 7266),
(26499, 125, 1, 8079, 7297),
(26499, 125, 2, 8198, 0),
(26499, 127, 0, 7779, 6265),
(26499, 127, 1, 10397, 9719),
(26499, 127, 2, 7018, 0),
(27907, 1, 0, 1260, 0),
(27907, 2, 0, 2395, 1125),
(27907, 2, 1, 3378, 2515),
(27907, 2, 2, 4259, 3516),
(27907, 2, 3, 3997, 2531),
(27907, 2, 4, 6453, 4844),
(27907, 2, 5, 8822, 7281),
(27907, 2, 6, 5655, 4844),
(27907, 2, 7, 6149, 4859),
(27907, 2, 8, 10645, 9688),
(27907, 2, 9, 4624, 3640),
(27907, 2, 10, 7230, 6079),
(27907, 2, 11, 7563, 6062),
(27907, 2, 12, 6819, 6047),
(27907, 2, 13, 10112, 8469),
(27907, 2, 14, 7902, 7281),
(27907, 2, 15, 4819, 3625),
(27907, 2, 16, 8246, 7172),
(27907, 2, 17, 6200, 4750),
(27907, 2, 18, 2828, 1312),
(27907, 2, 19, 4017, 2516),
(27907, 2, 20, 5094, 3500),
(27907, 2, 21, 5351, 0),
(27891, 1, 0, 3239, 2625),
(27891, 1, 1, 2755, 0),
(27891, 2, 0, 4320, 3235),
(27891, 2, 1, 3531, 2422),
(27891, 2, 2, 2835, 0),
(27891, 3, 0, 1964, 1218),
(27891, 3, 1, 1879, 1203),
(27891, 3, 2, 1555, 0),
(27891, 4, 0, 3004, 1250),
(27891, 4, 1, 4201, 2438),
(27891, 4, 2, 4956, 3640),
(27891, 4, 3, 4015, 2422),
(27891, 4, 4, 5920, 4844),
(27891, 4, 5, 5607, 4875),
(27891, 4, 6, 5841, 4687),
(27891, 4, 7, 7269, 6250),
(27891, 4, 8, 6402, 4797),
(27891, 4, 9, 8083, 7297),
(27891, 4, 10, 5750, 4750),
(27891, 4, 11, 3990, 2531),
(27891, 4, 12, 5397, 3500),
(27891, 4, 13, 5269, 3750),
(27891, 4, 14, 6169, 4860),
(27891, 4, 15, 5497, 4828),
(27891, 4, 16, 5084, 3625),
(27891, 4, 17, 5681, 4844),
(27891, 4, 18, 6803, 6062),
(27891, 4, 19, 5758, 4844),
(27891, 4, 20, 4319, 3625),
(27891, 4, 21, 4710, 3641),
(27891, 4, 22, 7181, 6062),
(27891, 4, 23, 8723, 7125),
(27891, 4, 24, 6300, 5000),
(27891, 4, 25, 6074, 4828),
(27891, 4, 26, 6394, 4844),
(27891, 4, 27, 4809, 3641),
(27891, 4, 28, 6276, 4750),
(27891, 4, 29, 6886, 6031),
(27891, 4, 30, 6358, 4969),
(27891, 4, 31, 6506, 0),
(27892, 1, 0, 3242, 2219),
(27892, 1, 1, 2553, 1234),
(27892, 1, 2, 3071, 2406),
(27892, 1, 3, 2449, 1188),
(27892, 1, 4, 2974, 1234),
(27892, 1, 5, 3961, 2422),
(27892, 1, 6, 2884, 1203),
(27892, 1, 7, 3427, 0),
(27892, 2, 0, 2022, 0),
(27884, 1, 0, 2596, 0),
(27884, 2, 0, 2381, 0),
(27885, 70, 0, 5363, 3640),
(27885, 70, 1, 4216, 3500),
(27885, 70, 2, 5501, 4969),
(27885, 70, 3, 2752, 1062),
(27885, 70, 4, 3472, 0),
(27885, 71, 0, 3757, 0),
(27885, 72, 0, 3004, 1218),
(27885, 72, 1, 3927, 2282),
(27885, 72, 2, 3491, 2562),
(27885, 72, 3, 3020, 2422),
(27885, 72, 4, 2334, 1063),
(27885, 72, 5, 3425, 2562),
(27885, 72, 6, 3055, 2422),
(27885, 72, 7, 2369, 1031),
(27885, 72, 8, 1804, 1375),
(27885, 72, 9, 1215, 0),
(27885, 1, 0, 2514, 0),
(27885, 2, 0, 2443, 0),
(27885, 3, 0, 2443, 0),
(27877, 1, 0, 1877, 1359),
(27877, 1, 1, 2104, 0),
(27877, 2, 0, 4870, 3641),
(27877, 2, 1, 5372, 3625),
(27877, 2, 2, 4919, 3453),
(27877, 2, 3, 6343, 5016),
(27877, 2, 4, 7111, 6031),
(27877, 2, 5, 7063, 6016),
(27877, 2, 6, 6610, 0),
(27903, 1, 0, 4337, 3640),
(27903, 1, 1, 3730, 2407),
(27903, 1, 2, 3116, 2437),
(27903, 1, 3, 3533, 0),
(27903, 2, 0, 1975, 0),
(27903, 3, 0, 4685, 3625),
(27903, 3, 1, 4437, 3625),
(27903, 3, 2, 5367, 3672),
(27903, 3, 3, 5862, 0);

DELETE FROM `script_spline_chain_waypoints` WHERE `entry` IN (26499,26497,26528,28167,26532,27742,27907,27891,27892,27884,27885,27877,27903);
INSERT INTO `script_spline_chain_waypoints` (`entry`,`chainId`,`splineId`,`wpId`,`x`,`y`,`z`) VALUES
(26499, 1, 0, 0, 1983.857, 1287.043, 145.5596),
(26499, 1, 0, 1, 1957.138, 1287.436, 145.6538),
(26499, 1, 1, 0, 1964.463, 1287.328, 145.6280),
(26499, 1, 1, 1, 1957.067, 1287.571, 145.8101),
(26499, 1, 1, 2, 1941.817, 1288.071, 145.8101),
(26499, 1, 1, 3, 1939.171, 1288.315, 145.4922),
(26499, 1, 2, 0, 1945.112, 1288.024, 145.7216),
(26499, 1, 2, 1, 1941.497, 1288.348, 145.7976),
(26499, 1, 2, 2, 1939.247, 1288.598, 145.5476),
(26499, 1, 2, 3, 1926.247, 1289.098, 144.5476),
(26499, 1, 2, 4, 1924.883, 1289.172, 143.8736),
(26499, 1, 3, 0, 1935.320, 1288.546, 145.0998),
(26499, 1, 3, 1, 1926.090, 1289.288, 144.4456),
(26499, 1, 3, 2, 1924.840, 1289.288, 143.9456),
(26499, 1, 3, 3, 1915.340, 1290.038, 142.1956),
(26499, 1, 3, 4, 1912.860, 1290.030, 142.2913),
(26499, 1, 4, 0, 1925.639, 1289.127, 144.0508),
(26499, 1, 4, 1, 1924.946, 1289.347, 143.9687),
(26499, 1, 4, 2, 1915.196, 1290.347, 142.2187),
(26499, 1, 4, 3, 1913.196, 1290.347, 142.7187),
(26499, 1, 4, 4, 1909.196, 1290.597, 143.2187),
(26499, 1, 4, 5, 1904.196, 1291.347, 143.7187),
(26499, 1, 4, 6, 1903.254, 1291.568, 143.3867),
(26497, 1, 0, 0, 1876.788, 1305.723, 146.2474),
(26497, 1, 0, 1, 1883.386, 1300.033, 145.7733),
(26497, 1, 0, 2, 1885.484, 1297.844, 145.2992),
(26497, 1, 1, 0, 1883.513, 1299.635, 145.5760),
(26497, 1, 1, 1, 1885.626, 1297.811, 145.3729),
(26497, 1, 1, 2, 1889.126, 1296.311, 144.8729),
(26497, 1, 1, 3, 1891.239, 1294.988, 144.1697),
(26497, 1, 2, 0, 1888.441, 1296.377, 144.6055),
(26497, 1, 2, 1, 1889.347, 1296.104, 144.6718),
(26497, 1, 2, 2, 1891.597, 1295.104, 144.4218),
(26497, 1, 2, 3, 1896.754, 1292.831, 143.7381),
(26528, 1, 0, 0, 1783.843, 1267.481, 139.7800),
(26528, 1, 0, 1, 1782.336, 1267.000, 139.7406),
(26528, 1, 0, 2, 1783.282, 1267.326, 139.7406),
(26528, 1, 0, 3, 1790.993, 1269.459, 140.2811),
(26528, 1, 0, 4, 1798.704, 1271.592, 140.9061),
(26528, 1, 0, 5, 1804.487, 1273.191, 141.4359),
(26528, 1, 0, 6, 1814.126, 1275.857, 142.0609),
(26528, 1, 0, 7, 1824.729, 1278.790, 142.6859),
(26528, 1, 0, 8, 1827.434, 1279.528, 142.9155),
(26528, 1, 0, 9, 1827.434, 1279.528, 142.9155),
(26528, 1, 1, 0, 1817.973, 1276.922, 142.2877),
(26528, 1, 1, 1, 1824.995, 1279.099, 142.9928),
(26528, 1, 1, 2, 1827.745, 1279.849, 143.2428),
(26528, 1, 1, 3, 1833.745, 1280.099, 143.7428),
(26528, 1, 1, 4, 1846.245, 1281.349, 144.2428),
(26528, 1, 1, 5, 1862.016, 1282.776, 144.1979),
(26528, 1, 2, 0, 1856.154, 1282.227, 144.1979),
(26528, 1, 2, 1, 1862.171, 1283.084, 144.4533),
(26528, 1, 2, 2, 1888.921, 1285.834, 143.9533),
(26528, 1, 2, 3, 1889.687, 1285.941, 143.7088),
(26528, 1, 3, 0, 1887.511, 1285.683, 143.7328),
(26528, 1, 3, 1, 1889.049, 1286.004, 143.7950),
(26528, 1, 3, 2, 1890.049, 1286.254, 143.7950),
(26528, 1, 3, 3, 1899.588, 1288.324, 143.3571),
(26499, 2, 0, 0, 1903.254, 1291.568, 143.3867),
(26499, 2, 0, 1, 1905.293, 1301.579, 144.5444),
(26499, 2, 1, 0, 1904.456, 1297.470, 144.0693),
(26499, 2, 1, 1, 1905.458, 1301.860, 144.8994),
(26499, 2, 1, 2, 1905.958, 1302.610, 145.6494),
(26499, 2, 1, 3, 1905.958, 1303.360, 146.6494),
(26499, 2, 1, 4, 1906.458, 1304.360, 147.1494),
(26499, 2, 1, 5, 1906.958, 1306.360, 148.1494),
(26499, 2, 1, 6, 1907.461, 1307.250, 148.2295),
(26499, 2, 2, 0, 1906.671, 1305.182, 147.4275),
(26499, 2, 2, 1, 1907.312, 1306.470, 148.3720),
(26499, 2, 2, 2, 1907.812, 1307.470, 148.6220),
(26499, 2, 2, 3, 1908.312, 1308.970, 149.1220),
(26499, 2, 2, 4, 1909.812, 1311.720, 150.1220),
(26499, 2, 2, 5, 1909.953, 1312.258, 149.8164),
(26528, 2, 0, 0, 1899.588, 1288.324, 143.3571),
(26528, 2, 0, 1, 1903.980, 1297.110, 143.5117),
(26497, 2, 0, 0, 1896.754, 1292.831, 143.7381),
(26497, 2, 0, 1, 1899.490, 1298.720, 143.8324),
(26528, 3, 0, 0, 1903.980, 1297.110, 143.5117),
(26528, 3, 0, 1, 1878.339, 1285.441, 144.0609),
(26528, 3, 1, 0, 1881.913, 1287.067, 143.9844),
(26528, 3, 1, 1, 1878.267, 1285.418, 144.3411),
(26528, 3, 1, 2, 1866.120, 1282.769, 144.1979),
(26528, 3, 2, 0, 1870.356, 1283.695, 144.1504),
(26528, 3, 2, 1, 1866.068, 1282.754, 144.3617),
(26528, 3, 2, 2, 1845.780, 1281.313, 144.0729),
(26528, 3, 3, 0, 1849.295, 1281.565, 144.0945),
(26528, 3, 3, 1, 1845.886, 1281.369, 144.2576),
(26528, 3, 3, 2, 1833.136, 1280.119, 143.5076),
(26528, 3, 3, 3, 1827.477, 1279.173, 142.9207),
(26528, 3, 4, 0, 1831.271, 1279.616, 143.2832),
(26528, 3, 4, 1, 1827.359, 1279.084, 143.2076),
(26528, 3, 4, 2, 1819.859, 1277.084, 142.4576),
(26528, 3, 4, 3, 1809.446, 1274.552, 141.6319),
(26497, 3, 0, 0, 1899.490, 1298.720, 143.8324),
(26497, 3, 0, 1, 1894.122, 1293.809, 143.8338),
(26497, 4, 0, 0, 1894.122, 1293.809, 143.8338),
(26497, 4, 0, 1, 1871.234, 1287.862, 144.6408),
(26497, 4, 0, 2, 1864.347, 1285.916, 144.4479),
(26497, 4, 1, 0, 1867.776, 1286.831, 144.4536),
(26497, 4, 1, 1, 1864.450, 1286.037, 144.5757),
(26497, 4, 1, 2, 1847.624, 1283.743, 144.1979),
(26497, 4, 2, 0, 1849.860, 1284.034, 144.2313),
(26497, 4, 2, 1, 1847.545, 1283.791, 144.4611),
(26497, 4, 2, 2, 1834.045, 1281.791, 143.7111),
(26497, 4, 2, 3, 1829.730, 1281.048, 143.1909),
(26497, 4, 3, 0, 1831.906, 1281.373, 143.3964),
(26497, 4, 3, 1, 1829.835, 1281.172, 143.3008),
(26497, 4, 3, 2, 1823.085, 1280.172, 142.8008),
(26497, 4, 3, 3, 1815.265, 1278.970, 142.2052),
(26497, 4, 4, 0, 1816.958, 1279.213, 142.2851),
(26497, 4, 4, 1, 1815.281, 1278.945, 142.2650),
(26497, 4, 4, 2, 1804.781, 1276.695, 141.7650),
(26497, 4, 4, 3, 1799.781, 1275.695, 141.5150),
(26497, 4, 4, 4, 1794.105, 1274.177, 140.7448),
(26499, 3, 0, 0, 1909.953, 1312.258, 149.8164),
(26499, 3, 0, 1, 1908.551, 1309.692, 149.4765),
(26499, 3, 0, 2, 1907.551, 1307.942, 148.7265),
(26499, 3, 0, 3, 1906.551, 1306.192, 147.7265),
(26499, 3, 0, 4, 1905.551, 1303.692, 146.7265),
(26499, 3, 0, 5, 1905.051, 1302.942, 145.9765),
(26499, 3, 0, 6, 1904.551, 1301.942, 145.2265),
(26499, 3, 0, 7, 1904.051, 1300.942, 144.2265),
(26499, 3, 0, 8, 1903.149, 1299.625, 143.6367),
(26499, 3, 1, 0, 1904.679, 1302.469, 145.4152),
(26499, 3, 1, 1, 1904.199, 1301.766, 144.8384),
(26499, 3, 1, 2, 1903.949, 1300.766, 144.3384),
(26499, 3, 1, 3, 1903.449, 1299.516, 144.0884),
(26499, 3, 1, 4, 1903.718, 1291.063, 143.2617),
(26499, 3, 2, 0, 1903.495, 1294.415, 143.4085),
(26499, 3, 2, 1, 1904.043, 1291.134, 143.5083),
(26499, 3, 2, 2, 1907.793, 1288.384, 143.0083),
(26499, 3, 2, 3, 1909.091, 1287.353, 142.6082),
(26499, 3, 3, 0, 1905.888, 1289.565, 142.9981),
(26499, 3, 3, 1, 1910.904, 1288.431, 142.5031),
(26499, 3, 3, 2, 1914.904, 1287.181, 142.0031),
(26499, 3, 3, 3, 1916.920, 1287.297, 142.0080),
(26499, 4, 0, 0, 1916.920, 1287.297, 142.0080),
(26499, 4, 0, 1, 1926.420, 1287.426, 144.2628),
(26499, 4, 0, 2, 1929.170, 1287.676, 144.5128),
(26499, 4, 0, 3, 1939.420, 1287.554, 145.5176),
(26499, 4, 1, 0, 1926.350, 1287.513, 144.1856),
(26499, 4, 1, 1, 1929.405, 1287.518, 144.9343),
(26499, 4, 1, 2, 1939.405, 1287.518, 145.6843),
(26499, 4, 1, 3, 1941.655, 1287.518, 145.9343),
(26499, 4, 1, 4, 1951.959, 1287.524, 145.6830),
(26499, 4, 2, 0, 1945.664, 1287.539, 145.7185),
(26499, 4, 2, 1, 1952.117, 1287.516, 145.9138),
(26499, 4, 2, 2, 1965.071, 1287.494, 145.6091),
(26499, 4, 3, 0, 1955.347, 1287.516, 145.6639),
(26499, 4, 3, 1, 1965.244, 1287.470, 145.8539),
(26499, 4, 3, 2, 1976.641, 1287.424, 145.5438),
(26499, 4, 4, 0, 1965.047, 1287.494, 145.6092),
(26499, 4, 4, 1, 1976.853, 1287.353, 145.7835),
(26499, 4, 4, 2, 1988.603, 1287.353, 145.5335),
(26499, 4, 4, 3, 1989.159, 1287.212, 145.4577),
(26499, 4, 5, 0, 1985.305, 1287.277, 145.4950),
(26499, 4, 5, 1, 1988.890, 1287.511, 145.7352),
(26499, 4, 5, 2, 1989.140, 1287.511, 145.7352),
(26499, 4, 5, 3, 1992.975, 1297.245, 145.4753),
(26499, 4, 6, 0, 1991.095, 1292.302, 145.4666),
(26499, 4, 6, 1, 1993.198, 1297.473, 145.7460),
(26499, 4, 6, 2, 1993.948, 1300.723, 145.7460),
(26499, 4, 6, 3, 1997.198, 1313.223, 143.7460),
(26499, 4, 6, 4, 1997.800, 1316.144, 143.0254),
(26499, 4, 7, 0, 1996.410, 1310.698, 143.7020),
(26499, 4, 7, 1, 1997.232, 1313.538, 143.3433),
(26499, 4, 7, 2, 1997.982, 1316.288, 143.3433),
(26499, 4, 7, 3, 1998.732, 1317.288, 143.3433),
(26499, 4, 7, 4, 2003.232, 1322.538, 143.3433),
(26499, 4, 7, 5, 2009.732, 1326.038, 143.3433),
(26499, 4, 7, 6, 2010.055, 1326.378, 142.9847),
(26499, 4, 8, 0, 2000.474, 1319.478, 142.9744),
(26499, 4, 8, 1, 2003.205, 1322.562, 143.2088),
(26499, 4, 8, 2, 2009.955, 1326.062, 143.2088),
(26499, 4, 8, 3, 2009.955, 1326.312, 143.2088),
(26499, 4, 8, 4, 2019.437, 1321.146, 142.9432),
(26499, 4, 9, 0, 2008.504, 1325.558, 142.9917),
(26499, 4, 9, 1, 2009.963, 1326.276, 143.2323),
(26499, 4, 9, 2, 2010.213, 1326.276, 143.2323),
(26499, 4, 9, 3, 2019.463, 1321.026, 143.2323),
(26499, 4, 9, 4, 2021.963, 1311.526, 143.2323),
(26499, 4, 9, 5, 2022.713, 1309.026, 143.2323),
(26499, 4, 9, 6, 2023.213, 1307.526, 143.7323),
(26499, 4, 9, 7, 2025.921, 1296.995, 143.4729),
(26499, 4, 10, 0, 2023.620, 1305.563, 143.4979),
(26499, 4, 10, 1, 2026.268, 1297.151, 143.5187),
(26499, 4, 10, 2, 2028.768, 1293.401, 143.5187),
(26499, 4, 10, 3, 2030.417, 1290.740, 143.5395),
(26499, 4, 11, 0, 2026.428, 1296.289, 143.4703),
(26499, 4, 11, 1, 2028.844, 1293.166, 143.6114),
(26499, 4, 11, 2, 2030.594, 1290.916, 143.6114),
(26499, 4, 11, 3, 2032.094, 1290.416, 143.8614),
(26499, 4, 11, 4, 2033.594, 1289.666, 143.6114),
(26499, 4, 11, 5, 2035.344, 1288.916, 143.6114),
(26499, 4, 11, 6, 2037.759, 1287.544, 143.2525),
(26499, 4, 12, 0, 2032.995, 1289.617, 143.4461),
(26499, 4, 12, 1, 2033.722, 1289.358, 143.6375),
(26499, 4, 12, 2, 2035.472, 1288.608, 143.3875),
(26499, 4, 12, 3, 2037.972, 1287.858, 143.3875),
(26499, 4, 12, 4, 2045.222, 1287.858, 143.1375),
(26499, 4, 12, 5, 2047.948, 1287.598, 142.8289),
(26499, 5, 0, 0, 2047.948, 1287.598, 142.8289),
(26499, 5, 0, 1, 2050.976, 1287.708, 142.7941),
(26499, 5, 0, 2, 2058.005, 1287.819, 142.2593),
(26499, 5, 1, 0, 2053.991, 1287.731, 142.4832),
(26499, 5, 1, 1, 2058.194, 1287.743, 142.4689),
(26499, 5, 1, 2, 2060.694, 1287.743, 142.2189),
(26499, 5, 1, 3, 2064.398, 1287.755, 141.9545),
(26499, 5, 2, 0, 2060.053, 1287.799, 142.1414),
(26499, 5, 2, 1, 2060.704, 1287.717, 142.1683),
(26499, 5, 2, 2, 2064.704, 1287.717, 142.1683),
(26499, 5, 2, 3, 2070.454, 1287.717, 141.9183),
(26499, 5, 2, 4, 2072.355, 1287.635, 141.6951),
(26499, 5, 3, 0, 2069.130, 1287.684, 141.8000),
(26499, 5, 3, 1, 2070.820, 1287.637, 141.9955),
(26499, 5, 3, 2, 2072.570, 1287.637, 141.7455),
(26499, 5, 3, 3, 2075.820, 1287.637, 141.7455),
(26499, 5, 3, 4, 2083.011, 1287.590, 141.1909),
(26499, 6, 0, 0, 2083.011, 1287.590, 141.1909),
(26499, 6, 0, 1, 2084.617, 1285.493, 141.1684),
(26499, 6, 0, 2, 2087.367, 1281.493, 140.9184),
(26499, 6, 0, 3, 2087.722, 1280.896, 140.6459),
(26499, 7, 0, 0, 2087.722, 1280.896, 140.6459),
(26499, 7, 0, 1, 2091.994, 1277.257, 140.4254),
(28167, 1, 0, 0, 2092.018, 1275.036, 140.8330),
(28167, 1, 0, 1, 2090.446, 1277.398, 141.0078),
(28167, 1, 0, 2, 2088.873, 1279.260, 140.6826),
(26499, 91, 0, 0, 2366.240, 1195.253, 132.0441),
(26499, 91, 0, 1, 2366.501, 1196.756, 132.5435),
(26499, 91, 0, 2, 2366.501, 1198.006, 132.5435),
(26499, 91, 0, 3, 2370.251, 1199.006, 134.2935),
(26499, 91, 0, 4, 2371.501, 1199.256, 134.7935),
(26499, 91, 0, 5, 2373.251, 1199.756, 134.7935),
(26499, 91, 0, 6, 2375.251, 1200.256, 134.2935),
(26499, 91, 0, 7, 2376.251, 1200.506, 134.2935),
(26499, 91, 0, 8, 2377.262, 1200.759, 134.0428),
(26499, 91, 1, 0, 2368.773, 1198.629, 133.4956),
(26499, 91, 1, 1, 2370.306, 1199.143, 134.2684),
(26499, 91, 1, 2, 2371.556, 1199.393, 135.0184),
(26499, 91, 1, 3, 2373.556, 1199.893, 135.0184),
(26499, 91, 1, 4, 2375.306, 1200.393, 134.2684),
(26499, 91, 1, 5, 2376.306, 1200.393, 134.2684),
(26499, 91, 1, 6, 2377.306, 1200.643, 134.2684),
(26499, 91, 1, 7, 2382.556, 1201.893, 134.2684),
(26499, 91, 1, 8, 2383.839, 1202.156, 134.0411),
(26499, 91, 2, 0, 2377.760, 1200.865, 134.0427),
(26499, 91, 2, 1, 2382.930, 1202.066, 134.2909),
(26499, 91, 2, 2, 2384.180, 1202.316, 134.2909),
(26499, 91, 2, 3, 2386.180, 1202.566, 134.2909),
(26499, 91, 2, 4, 2392.101, 1203.767, 134.0390),
(26499, 92, 0, 0, 2392.101, 1203.767, 134.0390),
(26499, 92, 0, 1, 2396.516, 1206.148, 134.0383),
(26499, 95, 0, 0, 2396.516, 1206.148, 134.0383),
(26499, 95, 0, 1, 2404.866, 1207.302, 134.2841),
(26499, 95, 0, 2, 2408.366, 1207.552, 134.0341),
(26499, 95, 0, 3, 2418.716, 1208.955, 134.0299),
(26499, 95, 1, 0, 2406.147, 1207.366, 133.9344),
(26499, 95, 1, 1, 2408.496, 1207.973, 133.9710),
(26499, 95, 1, 2, 2418.996, 1209.223, 134.2210),
(26499, 95, 1, 3, 2419.746, 1209.723, 134.2210),
(26499, 95, 1, 4, 2428.246, 1213.973, 134.2210),
(26499, 95, 1, 5, 2431.845, 1216.079, 134.0077),
(26499, 95, 2, 0, 2424.443, 1212.063, 134.0150),
(26499, 95, 2, 1, 2428.300, 1214.332, 134.2638),
(26499, 95, 2, 2, 2432.050, 1216.082, 134.2638),
(26499, 95, 2, 3, 2441.157, 1219.101, 134.0126),
(26499, 95, 3, 0, 2433.054, 1216.472, 134.0083),
(26499, 95, 3, 1, 2441.192, 1219.025, 134.4917),
(26499, 95, 3, 2, 2441.692, 1216.775, 134.4917),
(26499, 95, 3, 3, 2442.192, 1215.025, 134.2417),
(26499, 95, 3, 4, 2442.442, 1213.525, 135.9917),
(26499, 95, 3, 5, 2444.330, 1205.078, 141.9751),
(26499, 95, 4, 0, 2443.168, 1210.214, 138.0827),
(26499, 95, 4, 1, 2444.703, 1205.028, 142.3293),
(26499, 95, 4, 2, 2446.203, 1198.028, 147.5793),
(26499, 95, 4, 3, 2447.738, 1191.342, 148.0759),
(26499, 96, 0, 0, 2447.738, 1191.342, 148.0759),
(26499, 96, 0, 1, 2443.461, 1190.214, 148.0759),
(26499, 97, 0, 0, 2443.461, 1190.214, 148.0759),
(26499, 97, 0, 1, 2442.500, 1190.911, 148.3259),
(26499, 97, 0, 2, 2432.500, 1193.911, 148.3259),
(26499, 97, 0, 3, 2425.250, 1194.411, 148.3259),
(26499, 97, 0, 4, 2423.539, 1194.608, 148.0759),
(26499, 97, 1, 0, 2434.366, 1193.263, 148.0759),
(26499, 97, 1, 1, 2432.421, 1193.916, 148.3259),
(26499, 97, 1, 2, 2424.921, 1194.416, 148.3259),
(26499, 97, 1, 3, 2423.671, 1194.666, 148.3259),
(26499, 97, 1, 4, 2412.975, 1194.068, 148.0759),
(26499, 97, 2, 0, 2424.781, 1194.516, 148.0759),
(26499, 97, 2, 1, 2423.638, 1194.570, 148.3259),
(26499, 97, 2, 2, 2413.138, 1194.070, 148.3259),
(26499, 97, 2, 3, 2410.888, 1193.070, 148.3259),
(26499, 97, 2, 4, 2408.138, 1192.320, 148.3259),
(26499, 97, 2, 5, 2406.995, 1191.624, 148.0759),
(26499, 97, 3, 0, 2415.113, 1194.177, 148.0759),
(26499, 97, 3, 1, 2413.069, 1194.000, 148.3259),
(26499, 97, 3, 2, 2410.569, 1193.000, 148.3259),
(26499, 97, 3, 3, 2408.069, 1192.000, 148.3259),
(26499, 97, 3, 4, 2407.319, 1191.500, 148.3259),
(26499, 97, 3, 5, 2406.069, 1188.250, 148.3259),
(26499, 97, 3, 6, 2404.526, 1183.823, 148.0759),
(26499, 97, 4, 0, 2406.700, 1190.692, 148.0759),
(26499, 97, 4, 1, 2406.134, 1187.959, 148.3256),
(26499, 97, 4, 2, 2404.884, 1183.709, 148.3256),
(26499, 97, 4, 3, 2405.634, 1177.709, 148.3256),
(26499, 97, 4, 4, 2407.067, 1167.727, 148.0753),
(26499, 97, 5, 0, 2404.814, 1181.384, 148.0758),
(26499, 97, 5, 1, 2405.542, 1177.282, 148.3256),
(26499, 97, 5, 2, 2407.042, 1168.032, 148.3256),
(26499, 97, 5, 3, 2407.542, 1165.782, 148.3256),
(26499, 97, 5, 4, 2409.271, 1156.181, 148.0755),
(26499, 98, 0, 0, 2409.271, 1156.181, 148.0755),
(26499, 98, 0, 1, 2412.297, 1141.795, 148.0757),
(26499, 98, 1, 0, 2411.266, 1146.695, 148.0757),
(26499, 98, 1, 1, 2412.604, 1141.814, 148.3258),
(26499, 98, 1, 2, 2414.943, 1132.433, 148.0759),
(26499, 98, 2, 0, 2413.564, 1137.311, 148.0758),
(26499, 98, 2, 1, 2415.143, 1132.356, 148.3259),
(26499, 98, 2, 2, 2417.143, 1129.106, 148.3259),
(26499, 98, 2, 3, 2420.722, 1122.901, 148.0759),
(26499, 98, 3, 0, 2417.318, 1128.516, 148.0760),
(26499, 98, 3, 1, 2420.858, 1123.179, 148.3259),
(26499, 98, 3, 2, 2422.608, 1121.679, 148.3259),
(26499, 98, 3, 3, 2424.108, 1120.429, 148.3259),
(26499, 98, 3, 4, 2425.898, 1118.842, 148.0759),
(26532, 1, 0, 0, 2457.008, 1113.929, 150.0776),
(26532, 1, 0, 1, 2458.388, 1114.085, 150.0917),
(26532, 1, 0, 2, 2457.393, 1113.980, 150.0917),
(26532, 1, 0, 3, 2455.168, 1113.687, 150.0104),
(26532, 1, 0, 4, 2450.874, 1113.122, 149.0170),
(26532, 1, 0, 5, 2450.874, 1113.122, 149.0170),
(27742, 1, 0, 0, 2432.824, 1191.816, 148.1556),
(27742, 1, 0, 1, 2432.566, 1193.102, 148.1593),
(27742, 1, 0, 2, 2432.757, 1192.121, 148.1593),
(27742, 1, 0, 3, 2434.290, 1185.112, 148.0759),
(27742, 1, 0, 4, 2434.290, 1185.112, 148.0759),
(27742, 2, 0, 0, 2432.990, 1192.760, 148.1474),
(27742, 2, 0, 1, 2432.270, 1191.664, 148.1593),
(27742, 2, 0, 2, 2432.829, 1192.493, 148.1593),
(27742, 2, 0, 3, 2433.960, 1194.363, 148.0759),
(27742, 2, 0, 4, 2436.273, 1198.183, 148.0759),
(27742, 2, 0, 5, 2436.273, 1198.183, 148.0759),
(27742, 3, 0, 0, 2432.711, 1192.857, 148.1550),
(27742, 3, 0, 1, 2431.399, 1192.900, 148.1593),
(27742, 3, 0, 2, 2432.398, 1192.865, 148.1593),
(27742, 3, 0, 3, 2438.529, 1192.707, 148.0759),
(27742, 3, 0, 4, 2438.529, 1192.707, 148.0759),
(27742, 4, 0, 0, 2433.154, 1192.572, 148.1547),
(27742, 4, 0, 1, 2432.087, 1193.326, 148.1593),
(27742, 4, 0, 2, 2432.926, 1192.781, 148.1593),
(27742, 4, 0, 3, 2437.091, 1188.969, 148.0759),
(27742, 4, 0, 4, 2437.091, 1188.969, 148.0759),
(27742, 5, 0, 0, 2414.349, 1136.075, 148.1592),
(27742, 5, 0, 1, 2414.383, 1135.073, 148.1593),
(27742, 5, 0, 2, 2414.348, 1136.073, 148.1593),
(27742, 5, 0, 3, 2415.398, 1140.661, 148.0758),
(27742, 5, 0, 4, 2415.398, 1140.661, 148.0758),
(27742, 6, 0, 0, 2403.961, 1180.299, 148.1587),
(27742, 6, 0, 1, 2404.736, 1179.674, 148.1587),
(27742, 6, 0, 2, 2403.959, 1180.304, 148.1587),
(27742, 6, 0, 3, 2407.341, 1172.870, 148.0755),
(27742, 6, 0, 4, 2407.341, 1172.870, 148.0755),
(27742, 7, 0, 0, 2414.671, 1136.262, 148.1592),
(27742, 7, 0, 1, 2415.404, 1135.578, 148.1593),
(27742, 7, 0, 2, 2414.673, 1136.260, 148.1593),
(27742, 7, 0, 3, 2411.154, 1140.153, 148.0757),
(27742, 7, 0, 4, 2411.154, 1140.153, 148.0757),
(27742, 8, 0, 0, 2403.908, 1179.994, 148.1586),
(27742, 8, 0, 1, 2403.891, 1180.996, 148.1587),
(27742, 8, 0, 2, 2403.908, 1179.996, 148.1587),
(27742, 8, 0, 3, 2403.444, 1172.043, 148.0753),
(27742, 8, 0, 4, 2403.444, 1172.043, 148.0753),
(27742, 9, 0, 0, 2429.026, 1102.693, 148.1499),
(27742, 9, 0, 1, 2429.742, 1101.104, 148.1593),
(27742, 9, 0, 2, 2429.303, 1102.002, 148.1593),
(27742, 9, 0, 3, 2426.836, 1108.146, 148.0759),
(27742, 9, 0, 4, 2426.836, 1108.146, 148.0759),
(27742, 10, 0, 0, 2441.173, 1115.225, 148.1264),
(27742, 10, 0, 1, 2442.718, 1112.450, 148.1593),
(27742, 10, 0, 2, 2442.771, 1113.448, 148.1593),
(27742, 10, 0, 3, 2438.715, 1117.960, 148.0759),
(27742, 10, 0, 4, 2438.027, 1118.726, 148.0759),
(27742, 10, 0, 5, 2438.027, 1118.726, 148.0759),
(27742, 11, 0, 0, 2430.645, 1104.685, 148.1306),
(27742, 11, 0, 1, 2429.549, 1101.521, 148.1593),
(27742, 11, 0, 2, 2429.636, 1102.517, 148.1593),
(27742, 11, 0, 3, 2432.575, 1108.833, 148.0759),
(27742, 11, 0, 4, 2432.575, 1108.833, 148.0759),
(27742, 12, 0, 0, 2439.649, 1113.719, 148.1298),
(27742, 12, 0, 1, 2442.992, 1113.372, 148.1593),
(27742, 12, 0, 2, 2442.031, 1113.648, 148.1593),
(27742, 12, 0, 3, 2435.285, 1113.849, 148.0759),
(27742, 12, 0, 4, 2435.285, 1113.849, 148.0759),
(26499, 101, 0, 0, 2425.898, 1118.842, 148.0759),
(26499, 101, 0, 1, 2429.949, 1117.980, 148.5604),
(26499, 101, 0, 2, 2434.449, 1116.980, 148.5604),
(26499, 101, 0, 3, 2443.699, 1114.980, 148.5604),
(26499, 101, 0, 4, 2448.199, 1113.980, 148.5604),
(26499, 101, 0, 5, 2451.000, 1113.117, 149.0450),
(26499, 101, 1, 0, 2442.638, 1115.024, 148.0759),
(26499, 101, 1, 1, 2443.851, 1114.990, 148.5444),
(26499, 101, 1, 2, 2448.351, 1113.990, 148.5444),
(26499, 101, 1, 3, 2451.101, 1113.490, 149.2944),
(26499, 101, 1, 4, 2454.351, 1116.990, 150.2944),
(26499, 101, 1, 5, 2456.064, 1118.955, 150.0128),
(26499, 101, 2, 0, 2451.617, 1113.829, 149.2187),
(26499, 101, 2, 1, 2454.655, 1117.209, 150.1194),
(26499, 101, 2, 2, 2456.405, 1119.209, 150.1194),
(26499, 101, 2, 3, 2457.155, 1121.959, 150.1194),
(26499, 101, 2, 4, 2457.905, 1125.959, 150.1194),
(26499, 101, 2, 5, 2459.655, 1125.959, 150.1194),
(26499, 101, 2, 6, 2462.692, 1126.088, 150.0201),
(26499, 101, 3, 0, 2456.778, 1121.774, 150.0144),
(26499, 101, 3, 1, 2458.201, 1126.067, 150.2717),
(26499, 101, 3, 2, 2459.701, 1126.067, 150.2717),
(26499, 101, 3, 3, 2462.701, 1126.067, 150.2717),
(26499, 101, 3, 4, 2466.451, 1124.317, 150.2717),
(26499, 101, 3, 5, 2468.624, 1123.360, 150.0291),
(26499, 128, 0, 0, 2468.624, 1123.360, 150.0291),
(26499, 128, 0, 1, 2472.084, 1123.195, 150.2172),
(26499, 128, 0, 2, 2474.334, 1122.945, 150.2172),
(26499, 128, 0, 3, 2482.584, 1122.945, 149.9672),
(26499, 128, 0, 4, 2484.045, 1122.531, 149.9052),
(26499, 128, 1, 0, 2478.336, 1122.838, 149.9668),
(26499, 128, 1, 1, 2482.680, 1122.492, 150.1883),
(26499, 128, 1, 2, 2483.930, 1122.492, 150.1883),
(26499, 128, 1, 3, 2484.430, 1119.742, 150.1883),
(26499, 128, 1, 4, 2485.523, 1113.646, 149.9099),
(26499, 128, 2, 0, 2484.691, 1118.652, 149.9061),
(26499, 128, 2, 1, 2485.738, 1113.734, 150.1313),
(26499, 128, 2, 2, 2485.988, 1111.734, 150.1313),
(26499, 128, 2, 3, 2486.488, 1108.234, 148.3813),
(26499, 128, 2, 4, 2487.238, 1103.734, 145.6313),
(26499, 128, 2, 5, 2487.738, 1100.484, 145.3813),
(26499, 128, 2, 6, 2487.785, 1099.816, 144.8566),
(26499, 128, 3, 0, 2486.230, 1109.323, 148.7373),
(26499, 128, 3, 1, 2486.708, 1108.068, 148.1735),
(26499, 128, 3, 2, 2487.458, 1103.568, 145.6735),
(26499, 128, 3, 3, 2487.958, 1100.568, 145.1735),
(26499, 128, 3, 4, 2487.958, 1100.068, 145.1735),
(26499, 128, 3, 5, 2491.458, 1100.818, 145.1735),
(26499, 128, 3, 6, 2492.958, 1101.068, 144.9235),
(26499, 128, 3, 7, 2498.185, 1101.812, 144.6096),
(26499, 128, 4, 0, 2487.662, 1100.566, 144.8941),
(26499, 128, 4, 1, 2488.134, 1100.141, 144.9309),
(26499, 128, 4, 2, 2491.134, 1100.641, 144.9309),
(26499, 128, 4, 3, 2492.884, 1101.141, 144.6809),
(26499, 128, 4, 4, 2498.134, 1102.141, 144.6809),
(26499, 128, 4, 5, 2497.884, 1103.141, 144.6809),
(26499, 128, 4, 6, 2497.384, 1105.891, 144.1809),
(26499, 128, 4, 7, 2496.134, 1110.891, 143.9309),
(26499, 128, 4, 8, 2495.134, 1115.891, 143.9309),
(26499, 128, 4, 9, 2494.384, 1119.641, 142.4309),
(26499, 128, 4, 10, 2493.134, 1124.641, 140.4309),
(26499, 128, 4, 11, 2492.605, 1127.216, 139.9677),
(26499, 128, 5, 0, 2494.477, 1118.697, 142.5221),
(26499, 128, 5, 1, 2494.635, 1119.844, 142.2594),
(26499, 128, 5, 2, 2493.385, 1124.594, 140.5094),
(26499, 128, 5, 3, 2492.885, 1127.094, 140.2594),
(26499, 128, 5, 4, 2500.794, 1128.992, 139.9966),
(26499, 128, 6, 0, 2492.862, 1127.271, 139.9686),
(26499, 128, 6, 1, 2500.889, 1128.872, 140.2229),
(26499, 128, 6, 2, 2503.416, 1119.473, 139.9773),
(26499, 128, 7, 0, 2501.195, 1127.536, 139.9936),
(26499, 128, 7, 1, 2503.719, 1119.759, 140.0309),
(26499, 128, 7, 2, 2506.469, 1120.259, 140.0309),
(26499, 128, 7, 3, 2510.969, 1121.009, 136.7809),
(26499, 128, 7, 4, 2516.469, 1122.009, 133.0309),
(26499, 128, 7, 5, 2517.743, 1121.981, 132.0681),
(26499, 128, 8, 0, 2512.749, 1121.107, 135.3008),
(26499, 128, 8, 1, 2516.539, 1122.018, 132.9387),
(26499, 128, 8, 2, 2518.039, 1122.268, 132.4387),
(26499, 128, 8, 3, 2521.539, 1123.768, 132.4387),
(26499, 128, 8, 4, 2523.830, 1124.929, 132.0767),
(26499, 1024, 0, 0, 2534.988, 1126.163, 130.8621),
(26499, 1024, 0, 1, 2539.021, 1128.049, 130.8222),
(26499, 1024, 0, 2, 2540.271, 1128.549, 131.0722),
(26499, 1024, 0, 3, 2540.771, 1128.799, 131.0722),
(26499, 1024, 0, 4, 2543.521, 1130.299, 130.8222),
(26499, 1024, 0, 5, 2546.771, 1132.299, 130.3222),
(26499, 1024, 0, 6, 2549.521, 1134.049, 130.0722),
(26499, 1024, 0, 7, 2552.771, 1136.049, 129.8222),
(26499, 1024, 0, 8, 2557.554, 1138.935, 128.7824),
(26499, 1024, 1, 0, 2551.887, 1135.368, 129.6870),
(26499, 1024, 1, 1, 2553.038, 1136.289, 129.6371),
(26499, 1024, 1, 2, 2557.788, 1139.289, 128.8871),
(26499, 1024, 1, 3, 2561.038, 1147.039, 128.3871),
(26499, 1024, 1, 4, 2564.288, 1153.789, 127.8871),
(26499, 1024, 1, 5, 2566.688, 1159.210, 127.0872),
(26499, 1024, 2, 0, 2562.721, 1150.404, 127.8784),
(26499, 1024, 2, 1, 2564.198, 1153.856, 127.5824),
(26499, 1024, 2, 2, 2566.698, 1159.356, 127.3324),
(26499, 1024, 2, 3, 2565.698, 1169.606, 127.0824),
(26499, 1024, 2, 4, 2564.448, 1180.356, 126.8324),
(26499, 1024, 2, 5, 2564.175, 1183.308, 126.2864),
(26499, 1024, 3, 0, 2564.675, 1178.508, 126.4328),
(26499, 1024, 3, 1, 2564.468, 1180.668, 126.6039),
(26499, 1024, 3, 2, 2564.218, 1183.668, 126.3539),
(26499, 1024, 3, 3, 2562.968, 1197.168, 126.1039),
(26499, 1024, 3, 4, 2562.718, 1199.418, 126.1039),
(26499, 1024, 3, 5, 2562.261, 1202.828, 125.7751),
(26499, 1024, 4, 0, 2562.752, 1197.818, 125.9246),
(26499, 1024, 4, 1, 2562.524, 1199.785, 126.0767),
(26499, 1024, 4, 2, 2562.274, 1203.035, 125.8267),
(26499, 1024, 4, 3, 2560.274, 1207.785, 125.8267),
(26499, 1024, 4, 4, 2556.774, 1217.035, 126.0767),
(26499, 1024, 4, 5, 2555.774, 1219.285, 125.8267),
(26499, 1024, 4, 6, 2552.295, 1227.253, 125.7289),
(26499, 1024, 5, 0, 2556.829, 1216.141, 125.7983),
(26499, 1024, 5, 1, 2556.463, 1217.164, 126.0613),
(26499, 1024, 5, 2, 2555.463, 1219.414, 126.0613),
(26499, 1024, 5, 3, 2552.213, 1227.414, 126.0613),
(26499, 1024, 5, 4, 2549.213, 1234.164, 126.0613),
(26499, 1024, 5, 5, 2543.963, 1246.414, 126.3113),
(26499, 1024, 5, 6, 2543.463, 1247.414, 126.3113),
(26499, 1024, 5, 7, 2540.597, 1253.188, 126.3242),
(26499, 1024, 6, 0, 2545.010, 1243.115, 126.0662),
(26499, 1024, 6, 1, 2543.567, 1246.399, 126.5910),
(26499, 1024, 6, 2, 2543.067, 1247.899, 126.5910),
(26499, 1024, 6, 3, 2540.567, 1253.399, 126.8410),
(26499, 1024, 6, 4, 2538.817, 1257.399, 126.8410),
(26499, 1024, 6, 5, 2536.067, 1263.649, 127.0910),
(26499, 1024, 6, 6, 2535.317, 1265.149, 127.0910),
(26499, 1024, 6, 7, 2534.567, 1267.149, 127.0910),
(26499, 1024, 6, 8, 2531.067, 1274.399, 127.5910),
(26499, 1024, 6, 9, 2528.624, 1279.184, 128.1158),
(26499, 1024, 7, 0, 2533.040, 1269.595, 127.1209),
(26499, 1024, 7, 1, 2530.740, 1274.671, 127.9136),
(26499, 1024, 7, 2, 2528.740, 1279.421, 128.4136),
(26499, 1024, 7, 3, 2527.490, 1282.671, 128.9136),
(26499, 1024, 7, 4, 2524.490, 1290.671, 130.4136),
(26499, 1024, 7, 5, 2523.990, 1292.171, 130.6636),
(26499, 1024, 7, 6, 2521.939, 1297.247, 130.7063),
(26499, 1024, 8, 0, 2525.589, 1287.386, 129.5040),
(26499, 1024, 8, 1, 2524.339, 1290.960, 130.4446),
(26499, 1024, 8, 2, 2523.839, 1292.460, 130.6946),
(26499, 1024, 8, 3, 2521.839, 1297.460, 130.9446),
(26499, 1024, 8, 4, 2521.339, 1299.210, 130.9446),
(26499, 1024, 8, 5, 2518.839, 1307.210, 130.9446),
(26499, 1024, 8, 6, 2517.089, 1312.460, 130.4446),
(26499, 1024, 8, 7, 2514.589, 1319.460, 131.6946),
(26499, 1024, 8, 8, 2513.089, 1323.535, 131.8852),
(26499, 1025, 0, 0, 2513.089, 1323.535, 131.8852),
(26499, 1025, 0, 1, 2511.017, 1328.168, 132.1075),
(26499, 1025, 0, 2, 2508.267, 1334.418, 132.6075),
(26499, 1025, 0, 3, 2505.767, 1339.918, 133.1075),
(26499, 1025, 0, 4, 2502.517, 1347.168, 133.1075),
(26499, 1025, 0, 5, 2499.267, 1353.918, 132.6075),
(26499, 1025, 0, 6, 2498.945, 1354.302, 132.3298),
(26499, 1025, 1, 0, 2500.686, 1350.516, 132.6903),
(26499, 1025, 1, 1, 2499.187, 1354.250, 132.4188),
(26499, 1025, 1, 2, 2498.937, 1354.500, 132.4188),
(26499, 1025, 1, 3, 2495.687, 1361.500, 131.4188),
(26499, 1025, 1, 4, 2492.187, 1369.500, 130.9188),
(26499, 1025, 1, 5, 2491.687, 1370.750, 130.9188),
(26499, 1025, 1, 6, 2486.688, 1380.985, 130.1472),
(26499, 1025, 2, 0, 2492.489, 1368.358, 130.5943),
(26499, 1025, 2, 1, 2491.867, 1369.797, 130.6554),
(26499, 1025, 2, 2, 2491.367, 1370.797, 130.6554),
(26499, 1025, 2, 3, 2486.617, 1381.297, 130.6554),
(26499, 1025, 2, 4, 2485.867, 1382.297, 130.4054),
(26499, 1025, 2, 5, 2485.367, 1383.297, 130.6554),
(26499, 1025, 2, 6, 2479.617, 1392.547, 130.4054),
(26499, 1025, 2, 7, 2474.117, 1401.297, 130.6554),
(26499, 1025, 2, 8, 2473.117, 1402.797, 130.9054),
(26499, 1025, 2, 9, 2472.617, 1403.547, 130.9054),
(26499, 1025, 2, 10, 2471.245, 1405.236, 130.7164),
(26499, 1025, 3, 0, 2478.698, 1393.532, 129.9635),
(26499, 1025, 3, 1, 2473.843, 1401.439, 130.7012),
(26499, 1025, 3, 2, 2472.843, 1402.939, 130.9512),
(26499, 1025, 3, 3, 2472.343, 1403.939, 130.7012),
(26499, 1025, 3, 4, 2471.343, 1405.439, 130.9512),
(26499, 1025, 3, 5, 2469.343, 1407.439, 130.9512),
(26499, 1025, 3, 6, 2467.343, 1409.439, 130.9512),
(26499, 1025, 3, 7, 2466.593, 1410.189, 130.9512),
(26499, 1025, 3, 8, 2460.343, 1416.439, 130.7012),
(26499, 1025, 3, 9, 2459.343, 1417.689, 130.7012),
(26499, 1025, 3, 10, 2455.843, 1420.939, 130.7012),
(26499, 1025, 3, 11, 2453.593, 1423.439, 130.7012),
(26499, 1025, 3, 12, 2449.988, 1426.845, 130.9390),
(26499, 1025, 4, 0, 2453.816, 1422.953, 130.6408),
(26499, 1025, 4, 1, 2453.290, 1423.434, 130.9224),
(26499, 1025, 4, 2, 2450.040, 1426.934, 131.1724),
(26499, 1025, 4, 3, 2441.790, 1424.934, 130.9224),
(26499, 1025, 4, 4, 2433.790, 1422.934, 130.9224),
(26499, 1025, 4, 5, 2429.540, 1421.934, 130.9224),
(26499, 1025, 4, 6, 2424.290, 1420.934, 130.9224),
(26499, 1025, 4, 7, 2420.263, 1419.915, 130.7039),
(26499, 1025, 5, 0, 2434.533, 1421.207, 130.5855),
(26499, 1025, 5, 1, 2424.042, 1420.156, 131.0255),
(26499, 1025, 5, 2, 2420.292, 1419.906, 130.7755),
(26499, 1025, 5, 3, 2414.792, 1418.406, 130.7755),
(26499, 1025, 5, 4, 2413.292, 1418.156, 130.7755),
(26499, 1025, 5, 5, 2411.042, 1417.406, 130.7755),
(26499, 1025, 5, 6, 2409.542, 1417.156, 130.7755),
(26499, 1025, 5, 7, 2407.292, 1416.656, 130.7755),
(26499, 1025, 5, 8, 2405.292, 1416.156, 130.7755),
(26499, 1025, 5, 9, 2404.042, 1415.906, 131.0255),
(26499, 1025, 5, 10, 2402.042, 1415.406, 131.0255),
(26499, 1025, 5, 11, 2392.542, 1412.906, 129.5255),
(26499, 1025, 5, 12, 2390.052, 1412.106, 128.9655),
(26499, 1025, 6, 0, 2396.684, 1413.820, 130.0156),
(26499, 1025, 6, 1, 2392.062, 1412.613, 129.3716),
(26499, 1025, 6, 2, 2390.062, 1412.113, 129.3716),
(26499, 1025, 6, 3, 2384.812, 1410.613, 128.8716),
(26499, 1025, 6, 4, 2383.312, 1410.363, 128.6216),
(26499, 1025, 6, 5, 2377.312, 1408.863, 128.3716),
(26499, 1025, 6, 6, 2373.562, 1407.863, 128.1216),
(26499, 1025, 6, 7, 2372.312, 1407.613, 128.1216),
(26499, 1025, 6, 8, 2367.312, 1406.113, 129.1216),
(26499, 1025, 6, 9, 2363.440, 1404.906, 128.7275),
(26499, 121, 0, 0, 2363.440, 1404.906, 128.7275),
(26499, 121, 0, 1, 2358.990, 1405.489, 128.6729),
(26499, 121, 0, 2, 2348.990, 1406.239, 128.4229),
(26499, 121, 0, 3, 2340.740, 1406.989, 128.4229),
(26499, 121, 0, 4, 2339.039, 1407.072, 128.1182),
(26499, 121, 1, 0, 2345.191, 1406.526, 128.2732),
(26499, 121, 1, 1, 2340.630, 1407.124, 128.2652),
(26499, 121, 1, 2, 2339.130, 1407.374, 128.2652),
(26499, 121, 1, 3, 2333.380, 1409.624, 128.0152),
(26499, 121, 1, 4, 2331.068, 1410.722, 127.7572),
(26499, 121, 2, 0, 2335.882, 1408.518, 127.9085),
(26499, 121, 2, 1, 2333.191, 1409.975, 127.8890),
(26499, 121, 2, 2, 2331.191, 1410.975, 127.8890),
(26499, 121, 2, 3, 2330.441, 1412.725, 127.8890),
(26499, 121, 2, 4, 2328.191, 1417.225, 127.8890),
(26499, 121, 2, 5, 2325.941, 1421.225, 128.1390),
(26499, 121, 2, 6, 2325.501, 1421.931, 127.8694),
(26499, 121, 3, 0, 2329.097, 1414.691, 127.6474),
(26499, 121, 3, 1, 2327.793, 1417.433, 127.7593),
(26499, 121, 3, 2, 2325.793, 1421.683, 128.0093),
(26499, 121, 3, 3, 2325.543, 1422.183, 128.0093),
(26499, 121, 3, 4, 2320.793, 1432.433, 128.0093),
(26499, 121, 3, 5, 2318.043, 1438.433, 128.0093),
(26499, 121, 3, 6, 2313.990, 1446.675, 127.8712),
(26499, 121, 4, 0, 2316.703, 1440.844, 127.9002),
(26499, 121, 4, 1, 2314.089, 1446.997, 127.9399),
(26499, 121, 4, 2, 2312.339, 1449.997, 127.9399),
(26499, 121, 4, 3, 2308.589, 1457.747, 127.9399),
(26499, 121, 4, 4, 2307.589, 1460.247, 127.9399),
(26499, 121, 4, 5, 2305.589, 1463.997, 127.9399),
(26499, 121, 4, 6, 2303.476, 1467.651, 127.4796),
(26499, 121, 5, 0, 2308.176, 1458.273, 127.8228),
(26499, 121, 5, 1, 2307.366, 1460.375, 127.9764),
(26499, 121, 5, 2, 2305.366, 1464.375, 127.9764),
(26499, 121, 5, 3, 2303.616, 1467.875, 127.9764),
(26499, 121, 5, 4, 2303.366, 1469.125, 127.7264),
(26499, 121, 5, 5, 2301.055, 1478.977, 128.1299),
(26499, 124, 0, 0, 2301.055, 1478.977, 128.1299),
(26499, 124, 0, 1, 2300.165, 1482.206, 128.4268),
(26499, 124, 0, 2, 2297.415, 1493.456, 128.4268),
(26499, 124, 0, 3, 2294.415, 1504.456, 128.4268),
(26499, 124, 0, 4, 2293.774, 1505.934, 128.7237),
(26499, 125, 0, 0, 2293.774, 1505.934, 128.7237),
(26499, 125, 0, 1, 2294.480, 1504.757, 128.7930),
(26499, 125, 0, 2, 2297.480, 1494.007, 128.5430),
(26499, 125, 0, 3, 2299.687, 1487.080, 128.3622),
(26499, 125, 1, 0, 2299.220, 1488.567, 128.3622),
(26499, 125, 1, 1, 2299.924, 1487.100, 128.6501),
(26499, 125, 1, 2, 2301.424, 1482.600, 128.6501),
(26499, 125, 1, 3, 2305.924, 1470.350, 127.9001),
(26499, 125, 1, 4, 2306.127, 1469.633, 127.4379),
(26499, 125, 2, 0, 2305.861, 1470.353, 127.4057),
(26499, 125, 2, 1, 2306.282, 1469.703, 127.6345),
(26499, 125, 2, 2, 2306.782, 1468.453, 127.6345),
(26499, 125, 2, 3, 2309.282, 1460.953, 127.8845),
(26499, 125, 2, 4, 2309.782, 1459.953, 127.8845),
(26499, 125, 2, 5, 2312.532, 1451.703, 128.1345),
(26499, 125, 2, 6, 2312.702, 1451.052, 127.8632),
(26499, 127, 0, 0, 2312.702, 1451.052, 127.8632),
(26499, 127, 0, 1, 2317.856, 1438.543, 128.1186),
(26499, 127, 0, 2, 2320.011, 1433.034, 127.8741),
(26499, 127, 1, 0, 2318.402, 1436.999, 127.8968),
(26499, 127, 1, 1, 2320.325, 1432.932, 128.0935),
(26499, 127, 1, 2, 2323.075, 1420.182, 128.0935),
(26499, 127, 1, 3, 2323.325, 1418.432, 127.8435),
(26499, 127, 1, 4, 2324.075, 1415.432, 127.8435),
(26499, 127, 1, 5, 2324.748, 1411.865, 127.7902),
(26499, 127, 2, 0, 2324.370, 1413.555, 127.6901),
(26499, 127, 2, 1, 2324.838, 1411.816, 128.0130),
(26499, 127, 2, 2, 2324.088, 1409.566, 128.2630),
(26499, 127, 2, 3, 2322.588, 1404.066, 128.2630),
(26499, 127, 2, 4, 2322.588, 1402.816, 128.2630),
(26499, 127, 2, 5, 2320.807, 1396.578, 128.3358),
(27907, 1, 0, 0, 1670.256, 872.8734, 120.0351),
(27907, 1, 0, 1, 1671.586, 872.1134, 120.4314),
(27907, 1, 0, 2, 1672.917, 871.3535, 120.3277),
(27907, 2, 0, 0, 1672.917, 871.3535, 120.3277),
(27907, 2, 0, 1, 1667.076, 870.0946, 119.9527),
(27907, 2, 1, 0, 1669.969, 870.7180, 120.1384),
(27907, 2, 1, 1, 1667.148, 870.1765, 120.0045),
(27907, 2, 1, 2, 1662.828, 866.6351, 119.8706),
(27907, 2, 2, 0, 1664.689, 868.1503, 119.9065),
(27907, 2, 2, 1, 1662.898, 866.5289, 120.0467),
(27907, 2, 2, 2, 1658.108, 859.9075, 119.1869),
(27907, 2, 3, 0, 1659.009, 861.1918, 119.3174),
(27907, 2, 3, 1, 1658.206, 859.9042, 119.4396),
(27907, 2, 3, 2, 1653.903, 852.6165, 119.0619),
(27907, 2, 4, 0, 1655.873, 856.0323, 119.1204),
(27907, 2, 4, 1, 1654.021, 852.6975, 119.3411),
(27907, 2, 4, 2, 1648.169, 841.8626, 119.0619),
(27907, 2, 5, 0, 1650.059, 845.4074, 119.0619),
(27907, 2, 5, 1, 1648.144, 841.8294, 119.5816),
(27907, 2, 5, 2, 1644.644, 832.8294, 119.8316),
(27907, 2, 5, 3, 1641.229, 825.2514, 120.1012),
(27907, 2, 6, 0, 1642.712, 828.8032, 119.8451),
(27907, 2, 6, 1, 1641.215, 825.3640, 120.1445),
(27907, 2, 6, 2, 1638.217, 815.4248, 119.9439),
(27907, 2, 7, 0, 1638.808, 817.3542, 119.9748),
(27907, 2, 7, 1, 1638.145, 815.3091, 120.1469),
(27907, 2, 7, 2, 1633.981, 802.7640, 119.8189),
(27907, 2, 8, 0, 1635.010, 805.8387, 119.8493),
(27907, 2, 8, 1, 1633.980, 802.8589, 119.8655),
(27907, 2, 8, 2, 1630.980, 791.6089, 119.3655),
(27907, 2, 8, 3, 1628.730, 783.8589, 119.1155),
(27907, 2, 8, 4, 1627.451, 780.3792, 118.3817),
(27907, 2, 9, 0, 1628.106, 782.6379, 118.5758),
(27907, 2, 9, 1, 1627.364, 780.3354, 118.5013),
(27907, 2, 9, 2, 1626.114, 774.8354, 118.0013),
(27907, 2, 9, 3, 1625.122, 771.5330, 117.4269),
(27907, 2, 10, 0, 1625.746, 773.9089, 117.7027),
(27907, 2, 10, 1, 1625.181, 771.5463, 117.5337),
(27907, 2, 10, 2, 1623.431, 765.7963, 117.0337),
(27907, 2, 10, 3, 1621.931, 760.2963, 116.7837),
(27907, 2, 10, 4, 1620.617, 756.6836, 115.8646),
(27907, 2, 11, 0, 1621.453, 759.4308, 116.1794),
(27907, 2, 11, 1, 1620.671, 756.5874, 116.0332),
(27907, 2, 11, 2, 1619.671, 752.8374, 115.5332),
(27907, 2, 11, 3, 1618.921, 749.0874, 115.0332),
(27907, 2, 11, 4, 1617.421, 742.3374, 114.5332),
(27907, 2, 11, 5, 1616.889, 741.2440, 113.8870),
(27907, 2, 12, 0, 1617.759, 744.8360, 114.2508),
(27907, 2, 12, 1, 1617.185, 742.1613, 114.0811),
(27907, 2, 12, 2, 1616.935, 741.1613, 114.0811),
(27907, 2, 12, 3, 1615.685, 736.6613, 113.3311),
(27907, 2, 12, 4, 1614.935, 732.6613, 113.0811),
(27907, 2, 12, 5, 1614.185, 729.9113, 112.5811),
(27907, 2, 12, 6, 1613.611, 728.4866, 111.9114),
(27907, 2, 13, 0, 1614.082, 730.3239, 112.2263),
(27907, 2, 13, 1, 1613.991, 729.7391, 112.3380),
(27907, 2, 13, 2, 1613.491, 728.4891, 112.0880),
(27907, 2, 13, 3, 1612.741, 725.7391, 111.5880),
(27907, 2, 13, 4, 1611.741, 722.7391, 110.8380),
(27907, 2, 13, 5, 1610.491, 718.9891, 110.0880),
(27907, 2, 13, 6, 1609.491, 715.4891, 109.5880),
(27907, 2, 13, 7, 1608.241, 711.7391, 109.0880),
(27907, 2, 13, 8, 1606.400, 706.6543, 107.9497),
(27907, 2, 14, 0, 1607.669, 710.4952, 108.4556),
(27907, 2, 14, 1, 1606.452, 706.7616, 108.1364),
(27907, 2, 14, 2, 1604.952, 702.7616, 107.3864),
(27907, 2, 14, 3, 1603.702, 698.5116, 106.8864),
(27907, 2, 14, 4, 1602.202, 694.7616, 106.3864),
(27907, 2, 14, 5, 1601.236, 692.0279, 105.8172),
(27907, 2, 15, 0, 1601.766, 693.5259, 105.9085),
(27907, 2, 15, 1, 1601.327, 692.0245, 105.8733),
(27907, 2, 15, 2, 1600.077, 687.5245, 105.3733),
(27907, 2, 15, 3, 1598.388, 682.0231, 104.8380),
(27907, 2, 16, 0, 1599.201, 684.8760, 105.0273),
(27907, 2, 16, 1, 1598.270, 681.9597, 105.0760),
(27907, 2, 16, 2, 1596.020, 675.4597, 104.3260),
(27907, 2, 16, 3, 1593.770, 669.2097, 103.8260),
(27907, 2, 16, 4, 1592.339, 665.5434, 103.1246),
(27907, 2, 17, 0, 1593.179, 667.8270, 103.3361),
(27907, 2, 17, 1, 1592.436, 665.4673, 103.2942),
(27907, 2, 17, 2, 1588.686, 658.7173, 102.5442),
(27907, 2, 17, 3, 1586.192, 654.1075, 101.7524),
(27907, 2, 18, 0, 1587.781, 657.0647, 102.1362),
(27907, 2, 18, 1, 1586.085, 654.3907, 101.8541),
(27907, 2, 18, 2, 1583.389, 651.7168, 101.5720),
(27907, 2, 19, 0, 1586.359, 654.4169, 101.7926),
(27907, 2, 19, 1, 1586.304, 654.0751, 101.8038),
(27907, 2, 19, 2, 1583.304, 652.0751, 101.8038),
(27907, 2, 19, 3, 1577.749, 653.7333, 101.8150),
(27907, 2, 20, 0, 1581.581, 652.3631, 101.6499),
(27907, 2, 20, 1, 1577.755, 654.0015, 101.9234),
(27907, 2, 20, 2, 1571.428, 659.6400, 102.1970),
(27907, 2, 21, 0, 1574.082, 657.1602, 102.0366),
(27907, 2, 21, 1, 1571.396, 659.9266, 102.3597),
(27907, 2, 21, 2, 1564.711, 666.6931, 102.1827),
(27891, 1, 0, 0, 1605.242, 805.4160, 122.9956),
(27891, 1, 0, 1, 1604.245, 806.4799, 123.0291),
(27891, 1, 0, 2, 1604.988, 805.8108, 123.0291),
(27891, 1, 0, 3, 1608.775, 799.9248, 122.5304),
(27891, 1, 0, 4, 1609.356, 799.0145, 122.5348),
(27891, 1, 0, 5, 1609.356, 799.0145, 122.5348),
(27891, 1, 1, 0, 1608.523, 800.3172, 122.5636),
(27891, 1, 1, 1, 1609.076, 799.8616, 122.6980),
(27891, 1, 1, 2, 1609.576, 799.1116, 122.6980),
(27891, 1, 1, 3, 1612.576, 796.8616, 122.1980),
(27891, 1, 1, 4, 1613.629, 795.9061, 121.8324),
(27891, 2, 0, 0, 1613.629, 795.9061, 121.8324),
(27891, 2, 0, 1, 1619.153, 798.0073, 121.4171),
(27891, 2, 0, 2, 1622.903, 799.2573, 120.9171),
(27891, 2, 0, 3, 1623.677, 799.6086, 120.5017),
(27891, 2, 1, 0, 1621.165, 798.6823, 120.8382),
(27891, 2, 1, 1, 1622.956, 799.5746, 120.9384),
(27891, 2, 1, 2, 1623.706, 799.8246, 120.9384),
(27891, 2, 1, 3, 1624.456, 802.0746, 120.9384),
(27891, 2, 1, 4, 1624.456, 803.0746, 120.9384),
(27891, 2, 1, 5, 1623.956, 804.3246, 121.1884),
(27891, 2, 1, 6, 1624.747, 804.9668, 121.0387),
(27891, 2, 2, 0, 1624.479, 802.8323, 120.4636),
(27891, 2, 2, 1, 1624.002, 804.5530, 121.3668),
(27891, 2, 2, 2, 1624.752, 805.3030, 121.1168),
(27891, 2, 2, 3, 1623.752, 805.5530, 121.3668),
(27891, 2, 2, 4, 1623.526, 808.2736, 121.2700),
(27891, 3, 0, 0, 1623.526, 808.2736, 121.2700),
(27891, 3, 0, 1, 1626.520, 807.8563, 120.7418),
(27891, 3, 0, 2, 1628.014, 806.9391, 120.2136),
(27891, 3, 1, 0, 1626.385, 807.8394, 120.3929),
(27891, 3, 1, 1, 1628.291, 807.2866, 120.3352),
(27891, 3, 1, 2, 1630.197, 808.7338, 120.2776),
(27891, 3, 2, 0, 1628.905, 807.6716, 120.2397),
(27891, 3, 2, 1, 1630.320, 809.0569, 120.5691),
(27891, 3, 2, 2, 1630.235, 810.9423, 120.3985),
(27891, 4, 0, 0, 1630.235, 810.9423, 120.3985),
(27891, 4, 0, 1, 1637.624, 809.6946, 119.9439),
(27891, 4, 1, 0, 1633.221, 810.4380, 120.2148),
(27891, 4, 1, 1, 1637.633, 810.0463, 120.0794),
(27891, 4, 1, 2, 1641.046, 814.6545, 119.9439),
(27891, 4, 2, 0, 1638.513, 810.9830, 119.9439),
(27891, 4, 2, 1, 1641.174, 815.0283, 120.1939),
(27891, 4, 2, 2, 1643.836, 822.0737, 119.9439),
(27891, 4, 3, 0, 1642.674, 818.9854, 119.9439),
(27891, 4, 3, 1, 1644.072, 822.2241, 120.1545),
(27891, 4, 3, 2, 1645.969, 828.4629, 119.8652),
(27891, 4, 4, 0, 1644.710, 824.6933, 119.9116),
(27891, 4, 4, 1, 1646.290, 828.7598, 120.0492),
(27891, 4, 4, 2, 1650.040, 837.5098, 119.5492),
(27891, 4, 4, 3, 1650.369, 838.3262, 119.1869),
(27891, 4, 5, 0, 1649.444, 836.2549, 119.2863),
(27891, 4, 5, 1, 1650.179, 837.8422, 119.4052),
(27891, 4, 5, 2, 1650.679, 838.5922, 119.4052),
(27891, 4, 5, 3, 1655.414, 848.9295, 119.0240),
(27891, 4, 6, 0, 1654.576, 847.1667, 119.0511),
(27891, 4, 6, 1, 1655.585, 849.0662, 119.1610),
(27891, 4, 6, 2, 1660.595, 860.4657, 119.2708),
(27891, 4, 7, 0, 1659.596, 858.2399, 119.2232),
(27891, 4, 7, 1, 1660.843, 860.6360, 119.5880),
(27891, 4, 7, 2, 1666.843, 872.8860, 120.0880),
(27891, 4, 7, 3, 1667.591, 874.5321, 119.9527),
(27891, 4, 8, 0, 1666.319, 871.9752, 119.7821),
(27891, 4, 8, 1, 1667.038, 873.1796, 119.9924),
(27891, 4, 8, 2, 1667.788, 874.6796, 120.2424),
(27891, 4, 8, 3, 1673.258, 886.3840, 119.7027),
(27891, 4, 9, 0, 1671.561, 882.8347, 119.7776),
(27891, 4, 9, 1, 1673.602, 886.5914, 119.8583),
(27891, 4, 9, 2, 1679.643, 901.3481, 119.9391),
(27891, 4, 10, 0, 1678.839, 899.4649, 119.9093),
(27891, 4, 10, 1, 1679.969, 901.5616, 120.2496),
(27891, 4, 10, 2, 1683.098, 913.1584, 120.5898),
(27891, 4, 11, 0, 1682.465, 910.9940, 120.4706),
(27891, 4, 11, 1, 1683.396, 913.5186, 120.7802),
(27891, 4, 11, 2, 1685.327, 920.5432, 120.5898),
(27891, 4, 12, 0, 1684.195, 916.7935, 120.5898),
(27891, 4, 12, 1, 1685.654, 920.6906, 120.8133),
(27891, 4, 12, 2, 1689.612, 929.0876, 120.0367),
(27891, 4, 13, 0, 1687.636, 925.1472, 120.2918),
(27891, 4, 13, 1, 1689.939, 929.3484, 120.2842),
(27891, 4, 13, 2, 1693.242, 937.0495, 119.7766),
(27891, 4, 14, 0, 1691.542, 933.3212, 119.8984),
(27891, 4, 14, 1, 1693.478, 937.1957, 119.9730),
(27891, 4, 14, 2, 1697.413, 947.5701, 120.0476),
(27891, 4, 15, 0, 1696.199, 944.5081, 119.9687),
(27891, 4, 15, 1, 1697.549, 947.8503, 120.3882),
(27891, 4, 15, 2, 1700.049, 954.1003, 120.8882),
(27891, 4, 15, 3, 1701.398, 957.1926, 120.8076),
(27891, 4, 16, 0, 1700.771, 955.6768, 120.7328),
(27891, 4, 16, 1, 1701.678, 957.3701, 121.1093),
(27891, 4, 16, 2, 1702.178, 962.1201, 121.6093),
(27891, 4, 16, 3, 1703.085, 968.0635, 121.9858),
(27891, 4, 17, 0, 1702.531, 964.4929, 121.6341),
(27891, 4, 17, 1, 1703.102, 968.4348, 122.2155),
(27891, 4, 17, 2, 1699.173, 977.8768, 122.2970),
(27891, 4, 18, 0, 1699.959, 975.9057, 122.2345),
(27891, 4, 18, 1, 1699.201, 978.1485, 122.5168),
(27891, 4, 18, 2, 1692.942, 991.3913, 122.2992),
(27891, 4, 19, 0, 1693.720, 989.7047, 122.2989),
(27891, 4, 19, 1, 1692.886, 991.5643, 122.7157),
(27891, 4, 19, 2, 1688.386, 1000.314, 122.9657),
(27891, 4, 19, 3, 1687.053, 1002.424, 123.1325),
(27891, 4, 20, 0, 1688.126, 1000.414, 122.9252),
(27891, 4, 20, 1, 1686.979, 1002.745, 123.5141),
(27891, 4, 20, 2, 1685.729, 1008.245, 124.0141),
(27891, 4, 20, 3, 1684.832, 1010.575, 124.1030),
(27891, 4, 21, 0, 1685.289, 1008.901, 123.9621),
(27891, 4, 21, 1, 1684.719, 1010.909, 124.5019),
(27891, 4, 21, 2, 1683.969, 1017.409, 125.0019),
(27891, 4, 21, 3, 1683.149, 1020.417, 125.0417),
(27891, 4, 22, 0, 1683.598, 1017.778, 124.8063),
(27891, 4, 22, 1, 1683.211, 1020.651, 125.4366),
(27891, 4, 22, 2, 1682.461, 1025.651, 125.9366),
(27891, 4, 22, 3, 1681.325, 1035.525, 126.0669),
(27891, 4, 23, 0, 1681.661, 1032.742, 125.9537),
(27891, 4, 23, 1, 1681.260, 1035.870, 126.1730),
(27891, 4, 23, 2, 1680.360, 1054.498, 125.8924),
(27891, 4, 24, 0, 1680.544, 1050.879, 125.9257),
(27891, 4, 24, 1, 1680.535, 1054.749, 125.9715),
(27891, 4, 24, 2, 1680.526, 1066.620, 126.0174),
(27891, 4, 25, 0, 1680.476, 1062.975, 125.9798),
(27891, 4, 25, 1, 1680.652, 1066.777, 126.1676),
(27891, 4, 25, 2, 1681.828, 1078.079, 126.3554),
(27891, 4, 26, 0, 1681.482, 1075.029, 126.2654),
(27891, 4, 26, 1, 1682.196, 1078.414, 126.6603),
(27891, 4, 26, 2, 1683.446, 1087.914, 127.1603),
(27891, 4, 26, 3, 1683.910, 1090.798, 127.0551),
(27891, 4, 27, 0, 1683.277, 1086.956, 126.8661),
(27891, 4, 27, 1, 1683.617, 1088.229, 127.3948),
(27891, 4, 27, 2, 1684.117, 1090.979, 127.3948),
(27891, 4, 27, 3, 1687.117, 1094.729, 127.8948),
(27891, 4, 27, 4, 1688.957, 1097.002, 128.4234),
(27891, 4, 28, 0, 1687.148, 1094.779, 127.8260),
(27891, 4, 28, 1, 1689.088, 1097.265, 128.7533),
(27891, 4, 28, 2, 1692.588, 1099.265, 129.2533),
(27891, 4, 28, 3, 1694.088, 1100.265, 129.7533),
(27891, 4, 28, 4, 1697.338, 1102.265, 130.5033),
(27891, 4, 28, 5, 1699.528, 1103.752, 130.6805),
(27891, 4, 29, 0, 1696.527, 1101.835, 130.2339),
(27891, 4, 29, 1, 1697.750, 1102.589, 130.8327),
(27891, 4, 29, 2, 1699.750, 1104.089, 131.0827),
(27891, 4, 29, 3, 1702.500, 1105.589, 132.0827),
(27891, 4, 29, 4, 1705.500, 1107.339, 132.5827),
(27891, 4, 29, 5, 1707.250, 1108.339, 133.0827),
(27891, 4, 29, 6, 1710.000, 1109.839, 133.8327),
(27891, 4, 29, 7, 1710.973, 1110.343, 133.9314),
(27891, 4, 30, 0, 1709.266, 1109.362, 133.3899),
(27891, 4, 30, 1, 1710.148, 1109.964, 133.9583),
(27891, 4, 30, 2, 1711.148, 1110.714, 134.4583),
(27891, 4, 30, 3, 1713.148, 1111.464, 134.9583),
(27891, 4, 30, 4, 1714.898, 1112.214, 135.4583),
(27891, 4, 30, 5, 1717.398, 1113.464, 135.9583),
(27891, 4, 30, 6, 1719.148, 1114.214, 136.7083),
(27891, 4, 30, 7, 1720.898, 1114.964, 137.2083),
(27891, 4, 30, 8, 1723.031, 1116.066, 137.5268),
(27891, 4, 31, 0, 1719.710, 1114.490, 136.6331),
(27891, 4, 31, 1, 1721.044, 1115.318, 137.4891),
(27891, 4, 31, 2, 1723.294, 1116.318, 137.9891),
(27891, 4, 31, 3, 1725.794, 1117.818, 138.7391),
(27891, 4, 31, 4, 1727.294, 1118.568, 138.9891),
(27891, 4, 31, 5, 1730.044, 1120.068, 139.7391),
(27891, 4, 31, 6, 1731.544, 1121.068, 140.2391),
(27891, 4, 31, 7, 1733.379, 1122.147, 140.8451),
(27892, 1, 0, 0, 1601.366, 805.0612, 123.7103),
(27892, 1, 0, 1, 1600.004, 806.3074, 123.8376),
(27892, 1, 0, 2, 1600.781, 805.6780, 123.8376),
(27892, 1, 0, 3, 1604.224, 802.0498, 123.0886),
(27892, 1, 0, 4, 1606.311, 799.8455, 122.8354),
(27892, 1, 0, 5, 1606.311, 799.8455, 122.8354),
(27892, 1, 1, 0, 1604.806, 801.4352, 123.0180),
(27892, 1, 1, 1, 1606.652, 799.8110, 122.9106),
(27892, 1, 1, 2, 1609.497, 797.1868, 122.3031),
(27892, 1, 2, 0, 1606.937, 799.3236, 122.7309),
(27892, 1, 2, 1, 1609.646, 797.1644, 122.5922),
(27892, 1, 2, 2, 1612.855, 794.5053, 121.9534),
(27892, 1, 3, 0, 1611.604, 795.5046, 122.0837),
(27892, 1, 3, 1, 1613.088, 794.5215, 122.1889),
(27892, 1, 3, 2, 1617.072, 793.0383, 121.2942),
(27892, 1, 4, 0, 1614.179, 794.0447, 121.7464),
(27892, 1, 4, 1, 1617.402, 793.2491, 121.4646),
(27892, 1, 4, 2, 1621.126, 794.4536, 120.6827),
(27892, 1, 5, 0, 1616.998, 793.0639, 121.3057),
(27892, 1, 5, 1, 1621.170, 794.7802, 120.8156),
(27892, 1, 5, 2, 1624.841, 798.4964, 120.3256),
(27892, 1, 6, 0, 1622.230, 795.6549, 120.5766),
(27892, 1, 6, 1, 1624.831, 798.3754, 120.3729),
(27892, 1, 6, 2, 1626.933, 801.0958, 120.1692),
(27892, 1, 7, 0, 1624.277, 797.8823, 120.3798),
(27892, 1, 7, 1, 1624.999, 798.7412, 120.5467),
(27892, 1, 7, 2, 1626.999, 801.2412, 120.2967),
(27892, 1, 7, 3, 1628.722, 805.1000, 120.2136),
(27892, 2, 0, 0, 1628.722, 805.1000, 120.2136),
(27892, 2, 0, 1, 1629.004, 810.1380, 120.4927),
(27884, 1, 0, 0, 1639.946, 725.7776, 113.5619),
(27884, 1, 0, 1, 1637.886, 725.7106, 113.8119),
(27884, 1, 0, 2, 1636.136, 725.7106, 113.8119),
(27884, 1, 0, 3, 1635.827, 723.1434, 113.5619),
(27884, 2, 0, 0, 1635.827, 723.0861, 113.6452),
(27884, 2, 0, 1, 1636.886, 725.6819, 113.8536),
(27884, 2, 0, 2, 1639.946, 725.7776, 113.5619),
(27885, 70, 0, 0, 1602.132, 743.8040, 114.7303),
(27885, 70, 0, 1, 1605.358, 744.0162, 114.9277),
(27885, 70, 0, 2, 1611.608, 744.7662, 114.9277),
(27885, 70, 0, 3, 1612.858, 744.7662, 114.9277),
(27885, 70, 0, 4, 1614.108, 744.2662, 114.4277),
(27885, 70, 0, 5, 1614.583, 743.2285, 114.1251),
(27885, 70, 1, 0, 1611.180, 744.6971, 114.7383),
(27885, 70, 1, 1, 1613.148, 744.7632, 114.8577),
(27885, 70, 1, 2, 1614.398, 744.2632, 114.3577),
(27885, 70, 1, 3, 1614.648, 743.2632, 114.3577),
(27885, 70, 1, 4, 1617.615, 737.8293, 113.4772),
(27885, 70, 2, 0, 1616.893, 739.1165, 113.6317),
(27885, 70, 2, 1, 1617.805, 737.9444, 113.7083),
(27885, 70, 2, 2, 1619.805, 734.4444, 112.9583),
(27885, 70, 2, 3, 1622.555, 729.4444, 112.7083),
(27885, 70, 2, 4, 1623.717, 727.2723, 112.2850),
(27885, 70, 3, 0, 1622.905, 728.6694, 112.3143),
(27885, 70, 3, 1, 1623.866, 727.3546, 112.4240),
(27885, 70, 3, 2, 1628.827, 726.0397, 112.5336),
(27885, 70, 4, 0, 1625.025, 726.9567, 112.3486),
(27885, 70, 4, 1, 1629.196, 726.4058, 112.9477),
(27885, 70, 4, 2, 1631.196, 726.6558, 112.9477),
(27885, 70, 4, 3, 1632.196, 726.6558, 113.4477),
(27885, 70, 4, 4, 1633.366, 726.3549, 113.5467),
(27885, 71, 0, 0, 1633.366, 726.3549, 113.5467),
(27885, 71, 0, 1, 1632.387, 726.9871, 113.6156),
(27885, 71, 0, 2, 1630.887, 727.7371, 113.1156),
(27885, 71, 0, 3, 1631.387, 727.9871, 113.3656),
(27885, 71, 0, 4, 1630.887, 727.7371, 113.1156),
(27885, 71, 0, 5, 1629.887, 728.2371, 113.1156),
(27885, 71, 0, 6, 1631.387, 729.4871, 113.8656),
(27885, 71, 0, 7, 1631.637, 730.4871, 113.8656),
(27885, 71, 0, 8, 1630.407, 730.1193, 113.6845),
(27885, 72, 0, 0, 1630.407, 730.1193, 113.6845),
(27885, 72, 0, 1, 1630.917, 730.2725, 113.9209),
(27885, 72, 0, 2, 1629.667, 728.5225, 112.9209),
(27885, 72, 0, 3, 1624.917, 727.0225, 112.4209),
(27885, 72, 0, 4, 1620.917, 725.0225, 111.9209),
(27885, 72, 0, 5, 1618.417, 722.0225, 111.4209),
(27885, 72, 0, 6, 1616.167, 718.7725, 110.6709),
(27885, 72, 0, 7, 1613.928, 715.9256, 109.6573),
(27885, 72, 1, 0, 1623.199, 726.2747, 112.1131),
(27885, 72, 1, 1, 1620.688, 725.0859, 112.0865),
(27885, 72, 1, 2, 1618.188, 721.8359, 111.0865),
(27885, 72, 1, 3, 1615.938, 718.5859, 110.3365),
(27885, 72, 1, 4, 1614.188, 715.8359, 109.8365),
(27885, 72, 1, 5, 1612.938, 713.3359, 109.5865),
(27885, 72, 1, 6, 1611.188, 708.8359, 109.0865),
(27885, 72, 1, 7, 1609.688, 705.0859, 108.3365),
(27885, 72, 1, 8, 1608.688, 702.3359, 107.8365),
(27885, 72, 1, 9, 1607.678, 700.3972, 107.0600),
(27885, 72, 2, 0, 1612.112, 711.4092, 108.9662),
(27885, 72, 2, 1, 1611.035, 708.5569, 108.6749),
(27885, 72, 2, 2, 1609.535, 704.8069, 108.1749),
(27885, 72, 2, 3, 1608.285, 702.0569, 107.4249),
(27885, 72, 2, 4, 1607.785, 700.3069, 107.1749),
(27885, 72, 2, 5, 1606.535, 696.8069, 106.9249),
(27885, 72, 2, 6, 1604.285, 691.3069, 106.1749),
(27885, 72, 2, 7, 1601.958, 685.7047, 105.3837),
(27885, 72, 3, 0, 1605.050, 693.6397, 106.1223),
(27885, 72, 3, 1, 1604.178, 691.2042, 105.9571),
(27885, 72, 3, 2, 1601.928, 685.7042, 105.4571),
(27885, 72, 3, 3, 1599.928, 680.4542, 104.9571),
(27885, 72, 3, 4, 1597.928, 674.7042, 104.7071),
(27885, 72, 3, 5, 1596.307, 671.2687, 103.7920),
(27885, 72, 4, 0, 1598.042, 675.6906, 104.3130),
(27885, 72, 4, 1, 1597.688, 674.4025, 104.3032),
(27885, 72, 4, 2, 1596.188, 671.1525, 104.0532),
(27885, 72, 4, 3, 1594.188, 665.9025, 103.3032),
(27885, 72, 4, 4, 1592.188, 661.4025, 103.0532),
(27885, 72, 4, 5, 1590.834, 658.6144, 102.2933),
(27885, 72, 5, 0, 1594.380, 666.8188, 103.3112),
(27885, 72, 5, 1, 1593.886, 665.8480, 103.3166),
(27885, 72, 5, 2, 1591.886, 661.0980, 102.8166),
(27885, 72, 5, 3, 1590.886, 658.5980, 102.5666),
(27885, 72, 5, 4, 1588.636, 653.3480, 102.0666),
(27885, 72, 5, 5, 1586.136, 647.8480, 101.5666),
(27885, 72, 5, 6, 1583.393, 641.8773, 100.8220),
(27885, 72, 6, 0, 1586.642, 649.1833, 101.2471),
(27885, 72, 6, 1, 1585.855, 647.6183, 101.1272),
(27885, 72, 6, 2, 1583.355, 641.8683, 100.8772),
(27885, 72, 6, 3, 1578.605, 629.1183, 100.6272),
(27885, 72, 6, 4, 1577.569, 626.5533, 100.0073),
(27885, 72, 7, 0, 1579.374, 631.3001, 100.2685),
(27885, 72, 7, 1, 1578.524, 628.7549, 100.2654),
(27885, 72, 7, 2, 1577.524, 626.5049, 100.2654),
(27885, 72, 7, 3, 1577.024, 625.0049, 100.0154),
(27885, 72, 7, 4, 1575.274, 620.5049, 100.0154),
(27885, 72, 7, 5, 1575.024, 619.7549, 100.0154),
(27885, 72, 7, 6, 1574.774, 619.0049, 100.0154),
(27885, 72, 7, 7, 1572.675, 613.7097, 99.76225),
(27885, 72, 8, 0, 1575.843, 622.2479, 99.65166),
(27885, 72, 8, 1, 1574.988, 620.0990, 99.71298),
(27885, 72, 8, 2, 1574.738, 619.5990, 99.96298),
(27885, 72, 8, 3, 1574.488, 618.8490, 99.96298),
(27885, 72, 8, 4, 1572.738, 613.8490, 99.96298),
(27885, 72, 8, 5, 1569.633, 609.4501, 99.77429),
(27885, 72, 9, 0, 1572.403, 613.3293, 99.76333),
(27885, 72, 9, 1, 1569.547, 609.7275, 100.0184),
(27885, 72, 9, 2, 1565.190, 611.6257, 99.77345),
(27885, 1, 0, 0, 1603.050, 747.9994, 114.7605),
(27885, 1, 0, 1, 1604.049, 750.7614, 114.8151),
(27885, 1, 0, 2, 1603.475, 749.9422, 114.8151),
(27885, 1, 0, 3, 1602.821, 746.9496, 114.7310),
(27885, 1, 0, 4, 1602.132, 743.8040, 114.7303),
(27885, 1, 0, 5, 1602.132, 743.8040, 114.7303),
(27885, 2, 0, 0, 1602.132, 743.8040, 114.7303),
(27885, 2, 0, 1, 1602.813, 747.0300, 114.9824),
(27885, 2, 0, 2, 1603.493, 749.7560, 114.7345),
(27885, 3, 0, 0, 1603.493, 749.7560, 114.7345),
(27885, 3, 0, 1, 1602.813, 747.0300, 114.9824),
(27885, 3, 0, 2, 1602.132, 743.8040, 114.7303),
(27877, 1, 0, 0, 1561.571, 670.3199, 102.1444),
(27877, 1, 0, 1, 1565.856, 668.4106, 102.1827),
(27877, 1, 1, 0, 1564.340, 669.0860, 102.1692),
(27877, 1, 1, 1, 1566.094, 668.7725, 102.5262),
(27877, 1, 1, 2, 1566.594, 668.0225, 102.5262),
(27877, 1, 1, 3, 1568.348, 669.4590, 102.8832),
(27877, 2, 0, 0, 1568.348, 669.4590, 102.8832),
(27877, 2, 0, 1, 1570.132, 667.8282, 102.5401),
(27877, 2, 0, 2, 1570.132, 666.5782, 102.5401),
(27877, 2, 0, 3, 1573.416, 658.6976, 102.1970),
(27877, 2, 1, 0, 1572.105, 661.5780, 102.1970),
(27877, 2, 1, 1, 1573.661, 658.8035, 102.3220),
(27877, 2, 1, 2, 1579.911, 652.5535, 101.8220),
(27877, 2, 1, 3, 1580.717, 651.5290, 101.4470),
(27877, 2, 2, 0, 1577.634, 654.5538, 101.7866),
(27877, 2, 2, 1, 1580.112, 652.4617, 101.8577),
(27877, 2, 2, 2, 1580.862, 651.7117, 101.6077),
(27877, 2, 2, 3, 1588.590, 650.3696, 101.4288),
(27877, 2, 3, 0, 1585.335, 650.8489, 101.4363),
(27877, 2, 3, 1, 1588.816, 650.5333, 101.8634),
(27877, 2, 3, 2, 1591.066, 656.0333, 102.3634),
(27877, 2, 3, 3, 1593.566, 661.2833, 102.8634),
(27877, 2, 3, 4, 1593.797, 661.7178, 102.7905),
(27877, 2, 4, 0, 1592.303, 658.4574, 102.3747),
(27877, 2, 4, 1, 1593.883, 661.4075, 103.1464),
(27877, 2, 4, 2, 1594.133, 661.9075, 103.1464),
(27877, 2, 4, 3, 1596.383, 667.1575, 103.6464),
(27877, 2, 4, 4, 1598.633, 671.6575, 104.1464),
(27877, 2, 4, 5, 1599.962, 674.3575, 104.4181),
(27877, 2, 5, 0, 1598.789, 671.9459, 104.1030),
(27877, 2, 5, 1, 1600.133, 674.5853, 104.7467),
(27877, 2, 5, 2, 1601.883, 678.0853, 105.2467),
(27877, 2, 5, 3, 1604.383, 683.3353, 105.7467),
(27877, 2, 5, 4, 1606.477, 687.7247, 105.8904),
(27877, 2, 6, 0, 1605.371, 685.4503, 105.7326),
(27877, 2, 6, 1, 1606.650, 687.9642, 106.2105),
(27877, 2, 6, 2, 1608.900, 693.2142, 106.7105),
(27877, 2, 6, 3, 1610.900, 697.9642, 107.4605),
(27877, 2, 6, 4, 1611.928, 700.4782, 107.6884),
(27903, 1, 0, 0, 1588.942, 597.9799, 99.37262),
(27903, 1, 0, 1, 1589.883, 608.7765, 99.63657),
(27903, 1, 1, 0, 1589.730, 607.0264, 99.59379),
(27903, 1, 1, 1, 1589.919, 609.1281, 99.74018),
(27903, 1, 1, 2, 1588.607, 616.2296, 99.88657),
(27903, 1, 2, 0, 1589.159, 613.0059, 99.77844),
(27903, 1, 2, 1, 1588.610, 616.4816, 100.1237),
(27903, 1, 2, 2, 1586.060, 619.9573, 99.96897),
(27903, 1, 3, 0, 1587.032, 618.5356, 99.93755),
(27903, 1, 3, 1, 1586.021, 620.1125, 100.2397),
(27903, 1, 3, 2, 1580.011, 623.6895, 100.0418),
(27903, 2, 0, 0, 1580.011, 623.6895, 100.0418),
(27903, 2, 0, 1, 1576.298, 620.4587, 99.65415),
(27903, 3, 0, 0, 1576.298, 620.4587, 99.65415),
(27903, 3, 0, 1, 1579.411, 622.9457, 99.83286),
(27903, 3, 0, 2, 1583.411, 622.9457, 100.0829),
(27903, 3, 0, 3, 1586.523, 620.9327, 100.0116),
(27903, 3, 1, 0, 1584.299, 622.3154, 100.0116),
(27903, 3, 1, 1, 1586.711, 620.8452, 100.1366),
(27903, 3, 1, 2, 1589.123, 612.8749, 99.76157),
(27903, 3, 2, 0, 1588.503, 614.7979, 99.82124),
(27903, 3, 2, 1, 1589.286, 612.9751, 99.91640),
(27903, 3, 2, 2, 1591.070, 601.6522, 99.51157),
(27903, 3, 3, 0, 1590.331, 605.9120, 99.60647),
(27903, 3, 3, 1, 1591.018, 601.7597, 99.71784),
(27903, 3, 3, 2, 1590.768, 600.0097, 99.71784),
(27903, 3, 3, 3, 1590.768, 598.2597, 99.46784),
(27903, 3, 3, 4, 1591.268, 596.0097, 99.46784),
(27903, 3, 3, 5, 1591.268, 595.0097, 99.46784),
(27903, 3, 3, 6, 1591.268, 594.0097, 99.46784),
(27903, 3, 3, 7, 1591.268, 593.0097, 99.46784),
(27903, 3, 3, 8, 1591.705, 591.6074, 99.32922);
