-- Skorn - Howling Fjord
-- Duplicates
DELETE FROM `creature` WHERE `guid` IN (106758,106839,106769,105924,106277);
DELETE FROM `creature_addon` WHERE `guid` IN (106758,106839,106769,105924,106277);
-- Winterskorn Woodsman 23662
UPDATE `creature` SET `orientation` = 6.09119 WHERE `guid` = 106157;
UPDATE `creature` SET `position_x` = 2019.013, `position_y` = -4048.588, `position_z` = 220.6448, `orientation` = 5.445427 WHERE `guid` = 106156;
UPDATE `creature` SET `position_x` = 2035.516, `position_y` = -4081.487, `position_z` = 219.9021, `orientation` = 1.029744 WHERE `guid` = 106135;
UPDATE `creature` SET `position_x` = 2012.510, `position_y` = -4174.690, `position_z` = 214.3585, `orientation` = 5.899213 WHERE `guid` = 106158;
UPDATE `creature` SET `position_x` = 2045.983, `position_y` = -4160.231, `position_z` = 217.0959, `orientation` = 5.392896 WHERE `guid` = 106134;
UPDATE `creature` SET `position_x` = 1603.620, `position_y` = -4183.390, `position_z` = 272.5782, `orientation` = 3.787364 WHERE `guid` = 106122;
-- Winterskorn Tribesman 23661
-- missing spawns added
DELETE FROM `creature_addon` WHERE `guid` IN (106758,106839,106769);
DELETE FROM `creature` WHERE `guid` IN (106758,106839,106769);
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `modelid`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `spawndist`, `currentwaypoint`, `curhealth`, `curmana`, `npcflag`, `MovementType`) VALUES
(106758,23661,571,1,1,0,1,1940.196,-4128.496,215.0096,4.747295,300,0,0,8982,0,0,0),
(106839,23661,571,1,1,0,1,1789.604,-4086.97,234.7858,4.223697,300,0,0,8982,0,0,0),
(106769,23661,571,1,1,0,1,1960.5,-4036.13,218.077,5.9233,300,2,0,8982,0,0,2);
-- individual addons
DELETE FROM `creature_addon` WHERE `guid` IN (106769,105917,105923);
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`) VALUES
(106769,1067690,1),
(105917,1059170,1),
(105923,1059230,1);
-- Update Positions
UPDATE `creature` SET `position_x` = 1928.427, `position_y` = -4108.591, `position_z` = 215.5306, `orientation` = 2.722714 WHERE `guid` = 105916;
UPDATE `creature` SET `position_x` = 1943.333130, `position_y` = -4044.424561, `position_z` = 215.628464, `orientation` = 4.274271 WHERE `guid` = 105911;
UPDATE `creature` SET `position_x` = 1919.100830, `position_y` = -4151.435547, `position_z` = 214.519730, `orientation` = 5.573854 WHERE `guid` = 105917;
UPDATE `creature` SET `position_x` = 1708.850952, `position_y` = -4254.422363, `position_z` = 243.783539, `spawndist` = 2, `MovementType` = 1 WHERE `guid` = 105925;
UPDATE `creature` SET `position_x` = 1875.149414, `position_y` = -4177.331055, `position_z` = 213.976547, `spawndist` = 2, `MovementType` = 1 WHERE `guid` = 105921;
-- waypoints
UPDATE `creature` SET `spawndist` = 0, `MovementType` = 2 WHERE `guid` IN (106769,105917,105923);
DELETE FROM `waypoint_data` WHERE `id` IN (1067690,1059170,1059230);
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`, `delay`,`move_type`,`action`,`action_chance`,`orientation`) VALUES
-- #106769
(1067690,1,1794.22,-4085.77,234.28,0,0,0,100,0.218943),
(1067690,2,1801.98,-4096.94,234.889,0,0,0,100,4.27945),
(1067690,3,1796.3,-4113.24,237.45,0,0,0,100,4.45348),
(1067690,4,1795.54,-4124.3,238.534,0,0,0,100,4.96005),
(1067690,5,1799.77,-4136.4,239.373,0,0,0,100,5.25457),
(1067690,6,1811.01,-4146.99,238.857,0,0,0,100,5.34882),
(1067690,7,1815.35,-4155.39,238.69,0,0,0,100,4.81083),
(1067690,8,1813.37,-4162.83,239.074,0,0,0,100,4.11183),
(1067690,9,1809.16,-4168.86,239.45,0,0,0,100,3.55812),
(1067690,10,1802.01,-4169.63,240.189,45000,0,0,100,3.36648),
(1067690,11,1808.62,-4169.02,239.504,0,0,0,100,0.601904),
(1067690,12,1815.18,-4155.68,238.718,0,0,0,100,1.55852),
(1067690,13,1811.18,-4146.49,238.847,0,0,0,100,2.09652),
(1067690,14,1799.42,-4136.27,239.363,0,0,0,100,1.98263),
(1067690,15,1794.07,-4123.99,238.543,0,0,0,100,1.68418),
(1067690,16,1796.21,-4113.15,237.444,0,0,0,100,1.20902),
(1067690,17,1802.24,-4097.13,234.878,0,0,0,100,1.99049),
(1067690,18,1794.57,-4085.61,234.24,0,0,0,100,3.54558),
(1067690,19,1789.604,-4086.97,234.7858,45000,0,0,100,4.223697),
-- #105917
(1059170,1,1934.46,-4163.38,213.867,0,0,0,100,5.66339),
(1059170,2,1949.17,-4170.86,214.067,0,0,0,100,5.88723),
(1059170,3,1970.82,-4179.65,210.813,45000,0,0,100,5.84796),
(1059170,4,1957.4,-4170.83,213.307,0,0,0,100,2.60034),
(1059170,5,1941.53,-4161.64,213.99,0,0,0,100,2.69066),
(1059170,6,1922.24,-4151.89,214.198,0,0,0,100,2.64746),
(1059170,7,1908.68,-4143.94,215.313,0,0,0,100,2.71836),
(1059170,8,1898.09,-4140.05,215.432,0,0,0,100,3.3671),
(1059170,9,1888.33,-4145.249,216.1166,45000,0,0,100,3.054326),
(1059170,10,1897.36,-4140.12,215.453,0,0,0,100,0.42232),
(1059170,11,1908.15,-4143.58,215.332,0,0,0,100,5.8612),
(1059170,12,1918.92,-4151.2,214.542,0,0,0,100,5.69627),
-- #105923
(1059230,1,1796.76,-4175.648,240.6758,45000,0,0,100,2.10092),
(1059230,2,1808.329,-4188.263,239.8679,20000,0,0,100,2.478368);
-- Winterskorn Worg 24076
-- missing spawns added
DELETE FROM `creature_addon` WHERE `guid` IN (105924,106277,107133);
DELETE FROM `creature` WHERE `guid` IN (105924,106277,107133);
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `modelid`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `spawndist`, `currentwaypoint`, `curhealth`, `curmana`, `npcflag`, `MovementType`) VALUES
(105924,24076,571,1,1,0,0,1721.64,-4074.59,268.769,2.311127,300,0,0,6986,0,0,0),
(106277,24076,571,1,1,0,0,1877.36,-4092.95,213.301,5.40344,300,0,0,6986,0,0,0),
(107133,24076,571,1,1,0,0,1960.46,-4117.4,215.525,4.24665,300,0,0,6986,0,0,0);
-- Update
UPDATE `creature` SET `position_x` = 1800.432739, `position_y` = -4139.377930, `position_z` = 239.437134, `orientation` = 2.117636, `spawndist` = 0, `MovementType` = 0 WHERE `guid` = 97542;
-- Winterskorn Elder 23670
-- missing spawns added
DELETE FROM `creature_addon` WHERE `guid` IN (107139, 107140, 107156, 107164);
DELETE FROM `creature` WHERE `guid` IN (107139, 107140, 107156, 107164);
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `modelid`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `spawndist`, `currentwaypoint`, `curhealth`, `curmana`, `npcflag`, `MovementType`) VALUES
(107139,23670,571,1,1,0,0,1614.2,-4124.48,271.029,4.98946,300,0,0,7432,7332,0,0),
(107140,23670,571,1,1,0,0,1798.695801,-4141.260254,239.289612,2.117636,300,0,0,7432,7332,0,0),
(107156,23670,571,1,1,0,0,1879.5,-4092.15,213.08,5.40344,300,0,0,7432,7332,0,0),
(107164,23670,571,1,1,0,0,1962.15,-4118.67,215.473,4.37231,300,0,0,7432,7332,0,0);
-- Updates position
UPDATE `creature` SET `position_x` = 1720.066895, `position_y` = -4076.642822, `position_z` = 269.264526, `orientation` = 2.311127 WHERE `guid` = 106919;
-- waypoints
UPDATE `creature` SET `spawndist` = 0, `MovementType` = 2 WHERE `guid` IN (106919,107139, 107140, 107156, 107164);
DELETE FROM `creature_addon` WHERE `guid` IN (106919,107139, 107140, 107156, 107164);
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`) VALUES
(106919,1069190,1),
(107139,1071390,1),
(107140,1071400,1),
(107156,1071560,1),
(107164,1071640,1);
DELETE FROM `waypoint_data` WHERE `id` IN (1069190,1071390,1071400,1071560,1071640);
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`, `delay`,`move_type`,`action`,`action_chance`,`orientation`) VALUES
-- #106919
(1069190,1,1710.57,-4070.5,268.827,0,0,0,100,2.73916),
(1069190,2,1698.22,-4065.94,269.233,0,0,0,100,2.82948),
(1069190,3,1688,-4064.58,270.33,0,0,0,100,3.30858),
(1069190,4,1677.86,-4067.84,271.765,0,0,0,100,3.47351),
(1069190,5,1665.39,-4072.6,270.884,0,0,0,100,3.45388),
(1069190,6,1656.83,-4074.56,270.738,0,0,0,100,3.18684),
(1069190,7,1646.78,-4073.88,269.437,0,0,0,100,2.86875),
(1069190,8,1639.63,-4069.1,266.729,0,0,0,100,2.37395),
(1069190,9,1636.39,-4061.96,264.221,0,0,0,100,1.70636),
(1069190,10,1639.32,-4052.59,261.131,0,0,0,100,1.10553),
(1069190,11,1640.28,-4059.63,263.372,0,0,0,100,4.81654),
(1069190,12,1644.58,-4068.18,267.108,0,0,0,100,5.43153),
(1069190,13,1651.6,-4071.62,269.407,0,0,0,100,5.99309),
(1069190,14,1660.66,-4073.78,270.82,0,0,0,100,6.07555),
(1069190,15,1670.32,-4077.54,270.989,0,0,0,100,5.75747),
(1069190,16,1677.77,-4082.79,270.961,0,0,0,100,5.51007),
(1069190,17,1686.67,-4092.48,270.636,0,0,0,100,5.4119),
(1069190,18,1691.1,-4108.18,270.955,0,0,0,100,5.01528),
(1069190,19,1694.78,-4122.23,270.792,0,0,0,100,4.90925),
(1069190,20,1695.18,-4137.35,271.235,0,0,0,100,4.68541),
(1069190,21,1692.54,-4151.36,272.047,0,0,0,100,4.48121),
(1069190,22,1687.14,-4160.81,272.562,0,0,0,100,4.01783),
(1069190,23,1680.01,-4168.44,273.036,0,0,0,100,3.93929),
(1069190,24,1673.15,-4173.83,272.124,0,0,0,100,3.76257),
(1069190,25,1662.76,-4181.35,268.927,0,0,0,100,3.67618),
(1069190,26,1653.23,-4187.39,265.728,0,0,0,100,3.86713),
(1069190,27,1645.61,-4196.01,261.971,0,0,0,100,4.1538),
(1069190,28,1645.35,-4191.19,263.452,0,0,0,100,1.44505),
(1069190,29,1652.61,-4184.35,266.03,0,0,0,100,0.601531),
(1069190,30,1661.09,-4178.99,268.764,0,0,0,100,0.55048),
(1069190,31,1668.69,-4173.85,271.176,0,0,0,100,0.683998),
(1069190,32,1676.86,-4166.88,272.843,0,0,0,100,0.714795),
(1069190,33,1687.14,-4168.05,273.641,0,0,0,100,6.18902),
(1069190,34,1702.65,-4166.48,273.476,0,0,0,100,0.113963),
(1069190,35,1714.63,-4164.55,273.094,0,0,0,100,0.40456),
(1069190,36,1724.03,-4158.7,273.055,0,0,0,100,0.840456),
(1069190,37,1732.24,-4148.98,272.317,0,0,0,100,0.985755),
(1069190,38,1738.69,-4139.32,271.146,0,0,0,100,1.03681),
(1069190,39,1743.9,-4129.78,270.014,0,0,0,100,1.25279),
(1069190,40,1745.49,-4120.55,269.932,0,0,0,100,1.5591),
(1069190,41,1743.21,-4109.89,270.084,0,0,0,100,1.91253),
(1069190,42,1739.94,-4098.47,269.722,0,0,0,100,2.0696),
(1069190,43,1735.96,-4089.89,269.506,0,0,0,100,2.05782),
(1069190,44,1731.46,-4083.54,269.331,0,0,0,100,2.29344),
(1069190,45,1720.94,-4076.86,269.237,0,0,0,100,2.70578),
-- #107139
(1071390,1,1621.33,-4144.94,271.007,0,0,0,100,5.64919),
(1071390,2,1635.7,-4145.38,271.527,0,0,0,100,0.198711),
(1071390,3,1642.84,-4143.63,275.342,0,0,0,100,0.2262),
(1071390,4,1648.43,-4142.48,276.647,0,0,0,100,0.194784),
(1071390,5,1654.56,-4141.11,276.774,0,0,0,100,0.234054),
(1071390,6,1660.25,-4139.81,278.095,0,0,0,100,0.234054),
(1071390,7,1668.72,-4138.1,279.716,2000,0,0,100,0.210492),
(1071390,8,1660.84,-4139.69,278.198,0,0,0,100,3.33245),
(1071390,9,1653.83,-4141.32,276.765,0,0,0,100,3.37565),
(1071390,10,1643.78,-4143.37,275.37,0,0,0,100,3.33638),
(1071390,11,1635.59,-4145.17,271.492,0,0,0,100,3.39135),
(1071390,12,1621.25,-4144.35,271.006,0,0,0,100,1.90695),
(1071390,13,1615.25,-4130.84,271.042,0,0,0,100,1.8127),
(1071390,14,1612.7,-4114.14,271.007,0,0,0,100,1.5064),
(1071390,15,1616.67,-4109.29,271.047,0,0,0,100,0.611044),
(1071390,16,1627.11,-4107.62,271.086,0,0,0,100,0.28903),
(1071390,17,1633.25,-4105.95,274.926,0,0,0,100,0.281176),
(1071390,18,1639.2,-4103.98,276.654,0,0,0,100,0.292957),
(1071390,19,1646.76,-4101.8,276.897,0,0,0,100,0.326828),
(1071390,20,1650.6,-4099.95,278.082,0,0,0,100,0.354317),
(1071390,21,1658.61,-4098.5,279.673,2000,0,0,100,0.248288),
(1071390,22,1653.77,-4099.21,278.821,0,0,0,100,3.38595),
(1071390,23,1646.39,-4101.67,276.798,0,0,0,100,3.49591),
(1071390,24,1634.47,-4105.33,275.329,0,0,0,100,3.40952),
(1071390,25,1626.97,-4107.35,271.073,0,0,0,100,3.41737),
(1071390,26,1616.55,-4109.67,271.044,0,0,0,100,3.85091),
(1071390,27,1612.2,-4115.41,271.007,0,0,0,100,4.46351),
(1071390,28,1614.08,-4123.58,271.026,0,0,0,100,4.92297),
-- #107140
(1071400,1,1793.51,-4132.84,239.056,0,0,0,100,1.98804),
(1071400,2,1791.04,-4123.36,238.583,0,0,0,100,1.71708),
(1071400,3,1791.68,-4112.52,237.78,0,0,0,100,1.42648),
(1071400,4,1794.24,-4103.85,236.595,0,0,0,100,1.09269),
(1071400,5,1800.22,-4096,235.007,0,0,0,100,0.78638),
(1071400,6,1805,-4092,233.813,0,0,0,100,0.727475),
(1071400,7,1802.82,-4097.69,234.873,0,0,0,100,4.2814),
(1071400,8,1799.24,-4105.43,236.225,0,0,0,100,4.31674),
(1071400,9,1795.71,-4114.8,237.649,0,0,0,100,4.54451),
(1071400,10,1795.69,-4125.9,238.98,0,0,0,100,4.92149),
(1071400,11,1799.15,-4134.01,239.321,0,0,0,100,5.30634),
(1071400,12,1804.44,-4140.91,239.163,0,0,0,100,5.45163),
(1071400,13,1811.14,-4149.29,238.852,0,0,0,100,5.28277),
(1071400,14,1814.27,-4159.79,238.983,0,0,0,100,4.62304),
(1071400,15,1810.42,-4169.78,239.334,0,0,0,100,4.28533),
(1071400,16,1804.13,-4181.41,239.643,0,0,0,100,4.13217),
(1071400,17,1796.04,-4189.55,239.584,0,0,0,100,3.88085),
(1071400,18,1786.44,-4197.27,239.449,0,0,0,100,3.81409),
(1071400,19,1776.58,-4205.22,238.841,0,0,0,100,3.79053),
(1071400,20,1765.08,-4211.94,237.942,0,0,0,100,3.63737),
(1071400,21,1754.33,-4216.14,237.441,0,0,0,100,3.41354),
(1071400,22,1741.45,-4218.34,238.187,0,0,0,100,3.28002),
(1071400,23,1731.05,-4219.79,239.51,0,0,0,100,3.28002),
(1071400,24,1721.15,-4220.61,239.899,0,0,0,100,3.20226),
(1071400,25,1710.67,-4221.24,240.958,0,0,0,100,3.20226),
(1071400,26,1703.69,-4221.67,241.861,0,0,0,100,3.20226),
(1071400,27,1695.37,-4221.58,243.509,0,0,0,100,3.04204),
(1071400,28,1685.91,-4220.62,245.348,0,0,0,100,2.96429),
(1071400,29,1679.02,-4219.39,246.878,0,0,0,100,2.96429),
(1071400,30,1681.83,-4216.46,246.493,0,0,0,100,0.262517),
(1071400,31,1690.36,-4216.99,244.799,0,0,0,100,6.22369),
(1071400,32,1705.15,-4216.51,241.917,0,0,0,100,0.0700953),
(1071400,33,1712.13,-4216.02,241.15,0,0,0,100,0.0700953),
(1071400,34,1729.59,-4214.8,240.235,0,0,0,100,0.0700953),
(1071400,35,1747.05,-4213.57,238.346,0,0,0,100,0.0700953),
(1071400,36,1760.76,-4209.76,238.298,0,0,0,100,0.388182),
(1071400,37,1771.17,-4204.27,238.876,0,0,0,100,0.608093),
(1071400,38,1783.22,-4195.38,239.293,0,0,0,100,0.706268),
(1071400,39,1794.29,-4185.29,239.942,0,0,0,100,0.788735),
(1071400,40,1800.34,-4178.85,239.958,0,0,0,100,0.957595),
(1071400,41,1807.39,-4168.82,239.65,0,0,0,100,1.04006),
(1071400,42,1810.61,-4159.87,239.386,0,0,0,100,1.51523),
(1071400,43,1808.39,-4151.23,239.226,0,0,0,100,2.05323),
(1071400,44,1798.84,-4141.5,239.294,0,0,0,100,2.30848),
-- #107156
(1071560,1,1885.27,-4101.24,213.1,0,0,0,100,5.54365),
(1071560,2,1895.57,-4107.97,213.415,0,0,0,100,6.03059),
(1071560,3,1904.37,-4110.79,214.263,0,0,0,100,6.2662),
(1071560,4,1914.77,-4110.66,215.019,0,0,0,100,6.19552),
(1071560,5,1904.11,-4110.31,214.232,0,0,0,100,3.03036),
(1071560,6,1895.48,-4107.99,213.405,0,0,0,100,2.69657),
(1071560,7,1885.12,-4101.3,213.107,0,0,0,100,2.28816),
(1071560,8,1875.83,-4089.28,213.293,0,0,0,100,2.40888),
(1071560,9,1863.18,-4083.47,216.195,0,0,0,100,2.82907),
(1071560,10,1853.15,-4080.78,219.494,0,0,0,100,3.04506),
(1071560,11,1841.82,-4079.36,223.032,0,0,0,100,3.11181),
(1071560,12,1832.02,-4080.48,226.444,0,0,0,100,3.39373),
(1071560,13,1820.05,-4084.71,229.831,0,0,0,100,3.48798),
(1071560,14,1810.81,-4086.17,231.853,0,0,0,100,2.81646),
(1071560,15,1797.94,-4079.67,233.581,0,0,0,100,2.42376),
(1071560,16,1788.86,-4071.21,234.458,0,0,0,100,2.32166),
(1071560,17,1781.78,-4063.54,234.534,0,0,0,100,2.59262),
(1071560,18,1771.71,-4055.67,235.994,0,0,0,100,2.53264),
(1071560,19,1757.72,-4048.24,239.344,0,0,0,100,2.73685),
(1071560,20,1745.33,-4042.41,241.724,0,0,0,100,2.68972),
(1071560,21,1733.04,-4034.4,243.591,0,0,0,100,2.59548),
(1071560,22,1719.73,-4028.48,245.882,0,0,0,100,2.83502),
(1071560,23,1706.11,-4025.92,247.343,0,0,0,100,2.97247),
(1071560,24,1688.11,-4022.62,248.57,0,0,0,100,3.03137),
(1071560,25,1705.98,-4025.74,247.336,0,0,0,100,6.11406),
(1071560,26,1719.48,-4028.48,245.922,0,0,0,100,5.90967),
(1071560,27,1732.97,-4034.29,243.603,0,0,0,100,5.79579),
(1071560,28,1746.08,-4043.07,241.618,0,0,0,100,5.77616),
(1071560,29,1757.61,-4048.31,239.356,0,0,0,100,5.83506),
(1071560,30,1771.33,-4055.44,236.067,0,0,0,100,5.74474),
(1071560,31,1781.45,-4063.43,234.561,0,0,0,100,5.43844),
(1071560,32,1789.42,-4071.94,234.402,0,0,0,100,5.53661),
(1071560,33,1798.18,-4079.8,233.56,0,0,0,100,5.65835),
(1071560,34,1810.36,-4086.02,231.926,0,0,0,100,6.27341),
(1071560,35,1819.79,-4084.87,229.896,0,0,0,100,0.28475),
(1071560,36,1832.11,-4080.5,226.414,0,0,0,100,0.188346),
(1071560,37,1841.73,-4079.4,223.067,0,0,0,100,6.24769),
(1071560,38,1853.22,-4080.92,219.472,0,0,0,100,6.04208),
(1071560,39,1863.01,-4083.34,216.26,0,0,0,100,5.93212),
(1071560,40,1878.31,-4091.29,213.136,0,0,0,100,5.46874),
-- #107164
(1071640,1,1954.09,-4130.47,215.155,0,0,0,100,4.06601),
(1071640,2,1950.52,-4138.74,214.326,0,0,0,100,4.65112),
(1071640,3,1951.66,-4149.72,214.264,0,0,0,100,4.85135),
(1071640,4,1953.99,-4162.76,213.939,0,0,0,100,5.22834),
(1071640,5,1961.29,-4172.88,212.759,0,0,0,100,5.4993),
(1071640,6,1964.66,-4178.68,211.862,0,0,0,100,5.0045),
(1071640,7,1954.9,-4170.71,213.577,0,0,0,100,2.37735),
(1071640,8,1950.49,-4164.13,213.961,0,0,0,100,1.97287),
(1071640,9,1946.99,-4156.48,214.089,0,0,0,100,1.65085),
(1071640,10,1946.14,-4147,214.04,0,0,0,100,1.75295),
(1071640,11,1943.3,-4137.58,214.139,0,0,0,100,2.3263),
(1071640,12,1937.41,-4135.21,214.191,0,0,0,100,3.11955),
(1071640,13,1930.97,-4141.48,213.888,0,0,0,100,4.07381),
(1071640,14,1925.65,-4147.64,213.957,0,0,0,100,3.63398),
(1071640,15,1918.05,-4151.62,214.613,0,0,0,100,3.51225),
(1071640,16,1909.38,-4155.35,215.183,0,0,0,100,3.48083),
(1071640,17,1920.59,-4148.7,214.445,0,0,0,100,0.870622),
(1071640,18,1926.19,-4142.15,214.119,0,0,0,100,1.09053),
(1071640,19,1927.79,-4132.92,214.613,0,0,0,100,1.90347),
(1071640,20,1922.8,-4123.43,215.46,0,0,0,100,1.89561),
(1071640,21,1919.12,-4111.85,215.163,0,0,0,100,1.53826),
(1071640,22,1924.37,-4101.32,215.01,0,0,0,100,1.07487),
(1071640,23,1929.28,-4092.07,214.954,0,0,0,100,2.05269),
(1071640,24,1922.48,-4083.27,213.247,0,0,0,100,2.30009),
(1071640,25,1915.49,-4075.44,212.512,0,0,0,100,2.30009),
(1071640,26,1908.68,-4068.16,212.636,0,0,0,100,2.16658),
(1071640,27,1904.61,-4060.91,212.781,0,0,0,100,1.78566),
(1071640,28,1917.19,-4073.06,212.405,0,0,0,100,5.48096),
(1071640,29,1924.42,-4080.67,213.3,0,0,0,100,5.45347),
(1071640,30,1932.62,-4089.75,215.17,0,0,0,100,5.42991),
(1071640,31,1939.38,-4094.93,215.576,0,0,0,100,5.90114),
(1071640,32,1951.68,-4097.95,215.576,0,0,0,100,6.20744),
(1071640,33,1965.44,-4094.53,215.51,0,0,0,100,0.309102),
(1071640,34,1975.69,-4089.12,214.692,0,0,0,100,0.572211),
(1071640,35,1982.32,-4079.53,214.669,0,0,0,100,1.25567),
(1071640,36,1985.17,-4067.42,215.008,0,0,0,100,1.29887),
(1071640,37,1992.11,-4048.87,215.724,0,0,0,100,1.17713),
(1071640,38,1989.66,-4059.07,215.335,0,0,0,100,4.46795),
(1071640,39,1986.28,-4072.66,215.028,0,0,0,100,4.46795),
(1071640,40,1979.24,-4090.21,214.247,0,0,0,100,4.13808),
(1071640,41,1971.28,-4096.26,215.26,0,0,0,100,3.52548),
(1071640,42,1962.09,-4099.18,215.571,0,0,0,100,3.78073),
(1071640,43,1962.18,-4107.96,215.552,0,0,0,100,4.74674),
(1071640,44,1962.4,-4117.77,215.483,0,0,0,100,4.34274);
-- formations
DELETE FROM `creature_formations` WHERE `leaderGUID` IN (107140,106919,107156,107164);
INSERT INTO `creature_formations` (`leaderGUID`, `memberGUID`, `dist`, `angle`, `groupAI`, `point_1`, `point_2`) VALUES
(107140, 107140, 0, 0, 515, 0, 0),
(107140, 97542, 2, 90, 515, 0, 0),
(106919, 106919, 0, 0, 515, 0, 0),
(106919, 105924, 2, 90, 515, 0, 0),
(107156, 107156, 0, 0, 515, 0, 0),
(107156, 106277, 2, 90, 515, 0, 0),
(107164, 107164, 0, 0, 515, 0, 0),
(107164, 107133, 2, 90, 515, 0, 0);
-- Skorn Tower SW
UPDATE `creature` SET `spawndist` = 0, `MovementType` = 0 WHERE `guid` IN (106765,106822,106841,106840,106820,106821,106766);
-- individual addons
DELETE FROM `creature_addon` WHERE `guid` IN (106765,106822,106841,106840,106820,106821,106766);
INSERT INTO `creature_addon` (`guid`,`mount`,`bytes1`,`bytes2`,`auras`) VALUES
(106765,0,0,1,"43085"),
(106822,0,0,1,"43085"),
(106841,0,0,1,"43085"),
(106840,0,0,1,"43085"),
(106820,0,0,1,"43085"),
(106821,0,0,1,"43085"),
(106766,0,0,1,"43085");
-- Skorn Tower NW
UPDATE `creature` SET `spawndist` = 0, `MovementType` = 0 WHERE `guid` IN (106845,106846,106771,106770,106826,106772,106825,106773);
-- individual addons
DELETE FROM `creature_addon` WHERE `guid` IN (106845,106846,106771,106770,106826,106772,106825,106773);
INSERT INTO `creature_addon` (`guid`,`mount`,`bytes1`,`bytes2`,`auras`) VALUES
(106845,0,0,1,"43085"),
(106846,0,0,1,"43085"),
(106771,0,0,1,"43085"),
(106770,0,0,1,"43085"),
(106826,0,0,1,"43085"),
(106772,0,0,1,"43085"),
(106825,0,0,1,"43085"),
(106773,0,0,1,"43085");
-- Skorn Tower E
UPDATE `creature` SET `spawndist` = 0, `MovementType` = 0 WHERE `guid` IN (106761,106764,106817,106763,106762,106819,106818,106816);
-- individual addons
DELETE FROM `creature_addon` WHERE `guid` IN (106761,106764,106817,106763,106762,106819,106818,106816);
INSERT INTO `creature_addon` (`guid`,`mount`,`bytes1`,`bytes2`,`auras`) VALUES
(106761,0,0,1,"43085"),
(106764,0,0,1,"43085"),
(106817,0,0,1,"43085"),
(106763,0,0,1,"43085"),
(106762,0,0,1,"43085"),
(106819,0,0,1,"43085"),
(106818,0,0,1,"43085"),
(106816,0,0,1,"43085");
-- Skorn Tower SE
UPDATE `creature` SET `spawndist` = 0, `MovementType` = 0 WHERE `guid` IN (106768,106843,106823,106824,106844,106767,106842);
-- individual addons
DELETE FROM `creature_addon` WHERE `guid` IN (106768,106843,106823,106824,106844,106767,106842);
INSERT INTO `creature_addon` (`guid`,`mount`,`bytes1`,`bytes2`,`auras`) VALUES
(106768,0,0,1,"43085"),
(106843,0,0,1,"43085"),
(106823,0,0,1,"43085"),
(106824,0,0,1,"43085"),
(106844,0,0,1,"43085"),
(106767,0,0,1,"43085"),
(106842,0,0,1,"43085");
-- Winterskorn Raider 23665
DELETE FROM `creature_movement_override` WHERE `SpawnId` IN (106339, 106340);
INSERT INTO `creature_movement_override` (`SpawnId`, `Ground`, `Swim`, `Flight`, `Rooted`) VALUES
(106339, 1, 1, 2, 0),
(106340, 1, 1, 2, 0);
-- Winterskorn Warrior 23664
UPDATE `creature` SET `position_x` = 1901.188965, `position_y` = -4158.089844, `position_z` = 215.036270, `orientation` = 0.493954 WHERE `guid` = 106286;
UPDATE `creature` SET `position_x` = 1913.361938, `position_y` = -4035.461182, `position_z` = 215.914795, `spawndist` = 2, `MovementType` = 1 WHERE `guid` = 106283;
-- rats
UPDATE `creature` SET `spawndist` = 20 , `MovementType` = 1 WHERE `guid` IN (118112,118091,118131,118115,118096,118128,106153,118137);
-- Duelling Pairs
DELETE FROM `spawn_group`  WHERE `spawnid` IN (106218,106222) AND `spawnType`=0;
DELETE FROM `creature` WHERE `guid` IN (106218, 106222, 106194, 106193, 106534, 106195, 106274, 106205, 106355, 106354, 106288, 106358, 106568, 106207, 106359, 106211, 106212, 106196, 106537, 106270, 106271, 106202, 106259, 106206, 106569, 106210, 106495, 106282, 106344, 106197, 106280, 106281, 106204, 106356, 106497, 106234, 106243, 106341, 106273, 106357, 106228, 106496, 106572, 106276, 107167, 107168, 107249, 107253, 107389, 107408, 107410, 107411, 107413, 107414, 107415, 107416, 107417, 107423, 107426, 107432, 107433, 107434, 107435, 107436, 107444, 107445, 107446, 107447, 107448, 107449, 107450, 107451, 107452, 107453, 107457, 107458, 107459, 107460, 107461, 107462, 107463, 107464, 107465, 107466, 107468, 107469, 107470, 107471, 107472, 107473, 107474, 107475, 107478, 107484, 107485, 107486, 107487, 107489, 107490, 107493, 107494, 107496, 107497, 107498, 107499, 107500, 107503, 107519, 107520, 107521, 107522, 107523, 107525, 107528, 107560, 107566, 107568, 107576, 107577, 107578, 107579, 107580, 107582, 107605, 107607, 107624, 107629, 107641, 107704, 107706, 107802, 107814, 107837, 107999, 108000, 108001, 108002, 108003, 108004, 108005, 108006, 108007, 108008, 108009, 108010, 108011, 108019, 108025, 108028, 108033, 108043, 108048, 108100, 108110, 108136, 108137, 108198, 108505, 108510, 108511, 108520, 108521, 108562, 108600, 108766, 108846, 108886, 108894, 108920, 108925, 108959, 108963, 108964, 108965, 108966, 108997, 108999, 109000, 109001, 109004, 109019, 109045, 109047, 109066, 109112, 109145);
INSERT INTO `creature` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `modelid`, `equipment_id`, `position_x`, `position_y`, `position_z`, `orientation`, `spawntimesecs`, `spawndist`, `currentwaypoint`, `curhealth`, `curmana`, `npcflag`, `MovementType`) VALUES
(106194,23663,571,1,1,0,1,1847.715,-4242.075,208.0441,3.650937,300,0,0,8982,0,0,0),-- #1st pair
(106193,23664,571,1,1,0,1,1847.715,-4242.075,208.0441,3.650937,300,0,0,9291,0,0,0),
(106534,23665,571,1,1,0,1,1847.715,-4242.075,208.0441,3.650937,300,0,0,8982,3155,0,0),
(106195,23666,571,1,1,0,1,1847.715,-4242.075,208.0441,3.650937,300,0,0,8982,0,0,0),
(106274,23663,571,1,1,0,1,1844.074,-4244.109,208.3301,0.5093443,300,0,0,8982,0,0,0),
(106205,23664,571,1,1,0,1,1844.074,-4244.109,208.3301,0.5093443,300,0,0,9291,0,0,0),
(106355,23665,571,1,1,0,1,1844.074,-4244.109,208.3301,0.5093443,300,0,0,8982,3155,0,0),
(106354,23666,571,1,1,0,1,1844.074,-4244.109,208.3301,0.5093443,300,0,0,8982,0,0,0),
(106288,23663,571,1,1,0,1,1867.719,-4222.087,215.1427,2.764337,300,0,0,8982,0,0,0),-- #2nd pair
(106358,23664,571,1,1,0,1,1867.719,-4222.087,215.1427,2.764337,300,0,0,9291,0,0,0),
(106568,23665,571,1,1,0,1,1867.719,-4222.087,215.1427,2.764337,300,0,0,8982,3155,0,0),
(106207,23666,571,1,1,0,1,1867.719,-4222.087,215.1427,2.764337,300,0,0,8982,0,0,0),
(106359,23663,571,1,1,0,1,1863.946,-4220.592,215.1427,5.90593,300,0,0,8982,0,0,0),
(106211,23664,571,1,1,0,1,1863.946,-4220.592,215.1427,5.90593,300,0,0,9291,0,0,0),
(106212,23665,571,1,1,0,1,1863.946,-4220.592,215.1427,5.90593,300,0,0,8982,3155,0,0),
(106196,23666,571,1,1,0,1,1863.946,-4220.592,215.1427,5.90593,300,0,0,8982,0,0,0),
(106537,23663,571,1,1,0,1,1851.98,-4107.492,225.8964,1.849134,300,0,0,8982,0,0,0),-- #3rd pair
(106270,23664,571,1,1,0,1,1851.98,-4107.492,225.8964,1.849134,300,0,0,9291,0,0,0),
(106271,23665,571,1,1,0,1,1851.98,-4107.492,225.8964,1.849134,300,0,0,8982,3155,0,0),
(106202,23666,571,1,1,0,1,1851.98,-4107.492,225.8964,1.849134,300,0,0,8982,0,0,0),
(106259,23663,571,1,1,0,1,1850.898,-4103.702,225.9372,4.990727,300,0,0,8982,0,0,0),
(106206,23664,571,1,1,0,1,1850.898,-4103.702,225.9372,4.990727,300,0,0,9291,0,0,0),
(106569,23665,571,1,1,0,1,1850.898,-4103.702,225.9372,4.990727,300,0,0,8982,3155,0,0),
(106210,23666,571,1,1,0,1,1850.898,-4103.702,225.9372,4.990727,300,0,0,8982,0,0,0),
(106495,23663,571,1,1,0,1,1741.009,-4118.619,270.9087,1.553029,300,0,0,8982,0,0,0),-- #4th pair
(106282,23664,571,1,1,0,1,1741.009,-4118.619,270.9087,1.553029,300,0,0,9291,0,0,0),
(106344,23665,571,1,1,0,1,1741.009,-4118.619,270.9087,1.553029,300,0,0,8982,3155,0,0),
(106197,23666,571,1,1,0,1,1741.009,-4118.619,270.9087,1.553029,300,0,0,8982,0,0,0),
(106280,23663,571,1,1,0,1,1741.078,-4114.772,270.7665,4.799655,300,0,0,8982,0,0,0),
(106281,23664,571,1,1,0,1,1741.078,-4114.772,270.7665,4.799655,300,0,0,9291,0,0,0),
(106204,23665,571,1,1,0,1,1741.078,-4114.772,270.7665,4.799655,300,0,0,8982,3155,0,0),
(106356,23666,571,1,1,0,1,1741.078,-4114.772,270.7665,4.799655,300,0,0,8982,0,0,0),
(106497,23663,571,1,1,0,1,1883.826,-4065.674,212.5205,2.148151,300,0,0,8982,0,0,0),-- #5th pair
(106234,23664,571,1,1,0,1,1883.826,-4065.674,212.5205,2.148151,300,0,0,9291,0,0,0),
(106243,23665,571,1,1,0,1,1883.826,-4065.674,212.5205,2.148151,300,0,0,8982,3155,0,0),
(106341,23666,571,1,1,0,1,1883.826,-4065.674,212.5205,2.148151,300,0,0,8982,0,0,0),
(106273,23663,571,1,1,0,1,1881.556,-4062.189,212.4773,5.289744,300,0,0,8982,0,0,0),
(106357,23664,571,1,1,0,1,1881.556,-4062.189,212.4773,5.289744,300,0,0,9291,0,0,0),
(106228,23665,571,1,1,0,1,1881.556,-4062.189,212.4773,5.289744,300,0,0,8982,3155,0,0),
(106496,23666,571,1,1,0,1,1881.556,-4062.189,212.4773,5.289744,300,0,0,8982,0,0,0),
(106572,23663,571,1,1,0,1,1899.793,-4089.314,214.2414,0.3849756,300,0,0,8982,0,0,0),-- #6th pair
(106276,23664,571,1,1,0,1,1899.793,-4089.314,214.2414,0.3849756,300,0,0,9291,0,0,0),
(107167,23665,571,1,1,0,1,1899.793,-4089.314,214.2414,0.3849756,300,0,0,8982,3155,0,0),
(107168,23666,571,1,1,0,1,1899.793,-4089.314,214.2414,0.3849756,300,0,0,8982,0,0,0),
(107249,23663,571,1,1,0,1,1904.014,-4087.604,213.9469,3.526568,300,0,0,8982,0,0,0),
(107253,23664,571,1,1,0,1,1904.014,-4087.604,213.9469,3.526568,300,0,0,9291,0,0,0),
(107389,23665,571,1,1,0,1,1904.014,-4087.604,213.9469,3.526568,300,0,0,8982,3155,0,0),
(107408,23666,571,1,1,0,1,1904.014,-4087.604,213.9469,3.526568,300,0,0,8982,0,0,0),
(107410,23663,571,1,1,0,1,1980.459,-4105.223,214.128,3.649705,300,0,0,8982,0,0,0),-- #7th pair
(107411,23664,571,1,1,0,1,1980.459,-4105.223,214.128,3.649705,300,0,0,9291,0,0,0),
(107413,23665,571,1,1,0,1,1980.459,-4105.223,214.128,3.649705,300,0,0,8982,3155,0,0),
(107414,23666,571,1,1,0,1,1980.459,-4105.223,214.128,3.649705,300,0,0,8982,0,0,0),
(107415,23663,571,1,1,0,1,1977.026,-4107.135,214.371,0.5081121,300,0,0,8982,0,0,0),
(107416,23664,571,1,1,0,1,1977.026,-4107.135,214.371,0.5081121,300,0,0,9291,0,0,0),
(107417,23665,571,1,1,0,1,1977.026,-4107.135,214.371,0.5081121,300,0,0,8982,3155,0,0),
(107423,23666,571,1,1,0,1,1977.026,-4107.135,214.371,0.5081121,300,0,0,8982,0,0,0),
(107426,23663,571,1,1,0,1,2019.33,-4151.991,216.7243,2.704172,300,0,0,8982,0,0,0),-- #8th pair
(107432,23664,571,1,1,0,1,2019.33,-4151.991,216.7243,2.704172,300,0,0,9291,0,0,0),
(107433,23665,571,1,1,0,1,2019.33,-4151.991,216.7243,2.704172,300,0,0,8982,3155,0,0),
(107434,23666,571,1,1,0,1,2019.33,-4151.991,216.7243,2.704172,300,0,0,8982,0,0,0),
(107435,23663,571,1,1,0,1,2015.888,-4150.381,216.7609,5.845765,300,0,0,8982,0,0,0),
(107436,23664,571,1,1,0,1,2015.888,-4150.381,216.7609,5.845765,300,0,0,9291,0,0,0),
(107444,23665,571,1,1,0,1,2015.888,-4150.381,216.7609,5.845765,300,0,0,8982,3155,0,0),
(107445,23666,571,1,1,0,1,2015.888,-4150.381,216.7609,5.845765,300,0,0,8982,0,0,0),
(107446,23663,571,1,1,0,1,2008.486,-4214.342,209.4296,1.291544,300,0,0,8982,0,0,0),-- #9th pair
(107447,23664,571,1,1,0,1,2008.486,-4214.342,209.4296,1.291544,300,0,0,9291,0,0,0),
(107448,23665,571,1,1,0,1,2008.486,-4214.342,209.4296,1.291544,300,0,0,8982,3155,0,0),
(107449,23666,571,1,1,0,1,2008.486,-4214.342,209.4296,1.291544,300,0,0,8982,0,0,0),
(107450,23663,571,1,1,0,1,2009.75,-4210.49,209.43,4.46804,300,0,0,8982,0,0,0),
(107451,23664,571,1,1,0,1,2009.75,-4210.49,209.43,4.46804,300,0,0,9291,0,0,0),
(107452,23665,571,1,1,0,1,2009.75,-4210.49,209.43,4.46804,300,0,0,8982,3155,0,0),
(107453,23666,571,1,1,0,1,2009.75,-4210.49,209.43,4.46804,300,0,0,8982,0,0,0),
(107457,23663,571,1,1,0,1,1721.735,-4080.907,269.9704,5.663137,300,0,0,8982,0,0,0),-- #10th pair
(107458,23664,571,1,1,0,1,1721.735,-4080.907,269.9704,5.663137,300,0,0,9291,0,0,0),
(107459,23665,571,1,1,0,1,1721.735,-4080.907,269.9704,5.663137,300,0,0,8982,3155,0,0),
(107460,23666,571,1,1,0,1,1721.735,-4080.907,269.9704,5.663137,300,0,0,8982,0,0,0),
(107461,23663,571,1,1,0,1,1724.95,-4083.202,270.0606,2.521544,300,0,0,8982,0,0,0),
(107462,23664,571,1,1,0,1,1724.95,-4083.202,270.0606,2.521544,300,0,0,9291,0,0,0),
(107463,23665,571,1,1,0,1,1724.95,-4083.202,270.0606,2.521544,300,0,0,8982,3155,0,0),
(107464,23666,571,1,1,0,1,1724.95,-4083.202,270.0606,2.521544,300,0,0,8982,0,0,0),
(107465,23663,571,1,1,0,1,1626.241,-4069.501,266.6838,1.789505,300,0,0,8982,0,0,0),-- #11th pair
(107466,23664,571,1,1,0,1,1626.241,-4069.501,266.6838,1.789505,300,0,0,9291,0,0,0),
(107468,23665,571,1,1,0,1,1626.241,-4069.501,266.6838,1.789505,300,0,0,8982,3155,0,0),
(107469,23666,571,1,1,0,1,1626.241,-4069.501,266.6838,1.789505,300,0,0,8982,0,0,0),
(107470,23663,571,1,1,0,1,1625.446,-4065.923,265.8284,4.931098,300,0,0,8982,0,0,0),
(107471,23664,571,1,1,0,1,1625.446,-4065.923,265.8284,4.931098,300,0,0,9291,0,0,0),
(107472,23665,571,1,1,0,1,1625.446,-4065.923,265.8284,4.931098,300,0,0,8982,3155,0,0),
(107473,23666,571,1,1,0,1,1625.446,-4065.923,265.8284,4.931098,300,0,0,8982,0,0,0),
(107474,23663,571,1,1,0,1,1835.797,-4064.204,223.002,0.4380742,300,0,0,8982,0,0,0),-- #12th pair
(107475,23664,571,1,1,0,1,1835.797,-4064.204,223.002,0.4380742,300,0,0,9291,0,0,0),
(107478,23665,571,1,1,0,1,1835.797,-4064.204,223.002,0.4380742,300,0,0,8982,3155,0,0),
(107484,23666,571,1,1,0,1,1835.797,-4064.204,223.002,0.4380742,300,0,0,8982,0,0,0),
(107485,23663,571,1,1,0,1,1839.17,-4062.623,222.3133,3.579667,300,0,0,8982,0,0,0),
(107486,23664,571,1,1,0,1,1839.17,-4062.623,222.3133,3.579667,300,0,0,9291,0,0,0),
(107487,23665,571,1,1,0,1,1839.17,-4062.623,222.3133,3.579667,300,0,0,8982,3155,0,0),
(107489,23666,571,1,1,0,1,1839.17,-4062.623,222.3133,3.579667,300,0,0,8982,0,0,0),
(107490,23663,571,1,1,0,1,1902.227,-4129.773,215.0745,5.519782,300,0,0,8982,0,0,0),-- #13th pair
(107493,23664,571,1,1,0,1,1902.227,-4129.773,215.0745,5.519782,300,0,0,9291,0,0,0),
(107494,23665,571,1,1,0,1,1902.227,-4129.773,215.0745,5.519782,300,0,0,8982,3155,0,0),
(107496,23666,571,1,1,0,1,1902.227,-4129.773,215.0745,5.519782,300,0,0,8982,0,0,0),
(107497,23663,571,1,1,0,1,1905.199,-4132.617,215.2057,2.378189,300,0,0,8982,0,0,0),
(107498,23664,571,1,1,0,1,1905.199,-4132.617,215.2057,2.378189,300,0,0,9291,0,0,0),
(107499,23665,571,1,1,0,1,1905.199,-4132.617,215.2057,2.378189,300,0,0,8982,3155,0,0),
(107500,23666,571,1,1,0,1,1905.199,-4132.617,215.2057,2.378189,300,0,0,8982,0,0,0),
(107503,23663,571,1,1,0,1,1979.143,-4143.804,216.8537,0.2869127,300,0,0,8982,0,0,0),-- #14th pair
(107519,23664,571,1,1,0,1,1979.143,-4143.804,216.8537,0.2869127,300,0,0,9291,0,0,0),
(107520,23665,571,1,1,0,1,1979.143,-4143.804,216.8537,0.2869127,300,0,0,8982,3155,0,0),
(107521,23666,571,1,1,0,1,1979.143,-4143.804,216.8537,0.2869127,300,0,0,8982,0,0,0),
(107522,23663,571,1,1,0,1,1982.68,-4142.76,216.9296,3.428505,300,0,0,8982,0,0,0),
(107523,23664,571,1,1,0,1,1982.68,-4142.76,216.9296,3.428505,300,0,0,9291,0,0,0),
(107525,23665,571,1,1,0,1,1982.68,-4142.76,216.9296,3.428505,300,0,0,8982,3155,0,0),
(107528,23666,571,1,1,0,1,1982.68,-4142.76,216.9296,3.428505,300,0,0,8982,0,0,0),
(107560,23663,571,1,1,0,1,1938.262,-4225.21,209.5864,5.56734,300,0,0,8982,0,0,0),-- #15th pair
(107566,23664,571,1,1,0,1,1938.262,-4225.21,209.5864,5.56734,300,0,0,9291,0,0,0),
(107568,23665,571,1,1,0,1,1938.262,-4225.21,209.5864,5.56734,300,0,0,8982,3155,0,0),
(107576,23666,571,1,1,0,1,1938.262,-4225.21,209.5864,5.56734,300,0,0,8982,0,0,0),
(107577,23663,571,1,1,0,1,1941.243,-4227.803,210.0931,2.425748,300,0,0,8982,0,0,0),
(107578,23664,571,1,1,0,1,1941.243,-4227.803,210.0931,2.425748,300,0,0,9291,0,0,0),
(107579,23665,571,1,1,0,1,1941.243,-4227.803,210.0931,2.425748,300,0,0,8982,3155,0,0),
(107580,23666,571,1,1,0,1,1941.243,-4227.803,210.0931,2.425748,300,0,0,8982,0,0,0),
(107582,23663,571,1,1,0,1,2005.48,-4071.71,218.1608,0.9706288,300,0,0,8982,0,0,0),-- #16th pair
(107605,23664,571,1,1,0,1,2005.48,-4071.71,218.1608,0.9706288,300,0,0,9291,0,0,0),
(107607,23665,571,1,1,0,1,2005.48,-4071.71,218.1608,0.9706288,300,0,0,8982,3155,0,0),
(107624,23666,571,1,1,0,1,2005.48,-4071.71,218.1608,0.9706288,300,0,0,8982,0,0,0),
(107629,23663,571,1,1,0,1,2007.955,-4068.093,218.5989,4.112222,300,0,0,8982,0,0,0),
(107641,23664,571,1,1,0,1,2007.955,-4068.093,218.5989,4.112222,300,0,0,9291,0,0,0),
(107704,23665,571,1,1,0,1,2007.955,-4068.093,218.5989,4.112222,300,0,0,8982,3155,0,0),
(107706,23666,571,1,1,0,1,2007.955,-4068.093,218.5989,4.112222,300,0,0,8982,0,0,0),
(107802,23663,571,1,1,0,1,1715.657,-4150.159,272.7656,5.545485,300,0,0,8982,0,0,0),-- #17th pair
(107814,23664,571,1,1,0,1,1715.657,-4150.159,272.7656,5.545485,300,0,0,9291,0,0,0),
(107837,23665,571,1,1,0,1,1715.657,-4150.159,272.7656,5.545485,300,0,0,8982,3155,0,0),
(107999,23666,571,1,1,0,1,1715.657,-4150.159,272.7656,5.545485,300,0,0,8982,0,0,0),
(108000,23663,571,1,1,0,1,1718.819,-4153.032,273.0042,2.513274,300,0,0,8982,0,0,0),
(108001,23664,571,1,1,0,1,1718.819,-4153.032,273.0042,2.513274,300,0,0,9291,0,0,0),
(108002,23665,571,1,1,0,1,1718.819,-4153.032,273.0042,2.513274,300,0,0,8982,3155,0,0),
(108003,23666,571,1,1,0,1,1718.819,-4153.032,273.0042,2.513274,300,0,0,8982,0,0,0),
(108004,23663,571,1,1,0,1,1689.78,-4070.417,270.8647,3.560874,300,0,0,8982,0,0,0),-- #18th pair
(108005,23664,571,1,1,0,1,1689.78,-4070.417,270.8647,3.560874,300,0,0,9291,0,0,0),
(108006,23665,571,1,1,0,1,1689.78,-4070.417,270.8647,3.560874,300,0,0,8982,3155,0,0),
(108007,23666,571,1,1,0,1,1689.78,-4070.417,270.8647,3.560874,300,0,0,8982,0,0,0),
(108008,23663,571,1,1,0,1,1686.373,-4071.936,271.2866,0.4192808,300,0,0,8982,0,0,0),
(108009,23664,571,1,1,0,1,1686.373,-4071.936,271.2866,0.4192808,300,0,0,9291,0,0,0),
(108010,23665,571,1,1,0,1,1686.373,-4071.936,271.2866,0.4192808,300,0,0,8982,3155,0,0),
(108011,23666,571,1,1,0,1,1686.373,-4071.936,271.2866,0.4192808,300,0,0,8982,0,0,0),
(108019,23663,571,1,1,0,1,1633.54,-4182.149,273.5407,3.77211,300,0,0,8982,0,0,0),-- #19th pair
(108025,23664,571,1,1,0,1,1633.54,-4182.149,273.5407,3.77211,300,0,0,9291,0,0,0),
(108028,23665,571,1,1,0,1,1633.54,-4182.149,273.5407,3.77211,300,0,0,8982,3155,0,0),
(108033,23666,571,1,1,0,1,1633.54,-4182.149,273.5407,3.77211,300,0,0,8982,0,0,0),
(108043,23663,571,1,1,0,1,1630.288,-4184.522,273.2512,0.6305172,300,0,0,8982,0,0,0),
(108048,23664,571,1,1,0,1,1630.288,-4184.522,273.2512,0.6305172,300,0,0,9291,0,0,0),
(108100,23665,571,1,1,0,1,1630.288,-4184.522,273.2512,0.6305172,300,0,0,8982,3155,0,0),
(108110,23666,571,1,1,0,1,1630.288,-4184.522,273.2512,0.6305172,300,0,0,8982,0,0,0),
(108136,23663,571,1,1,0,1,1877.944,-4120.542,214.7395,0.6609709,300,0,0,8982,0,0,0),-- #20th pair
(108137,23664,571,1,1,0,1,1877.944,-4120.542,214.7395,0.6609709,300,0,0,9291,0,0,0),
(108198,23665,571,1,1,0,1,1877.944,-4120.542,214.7395,0.6609709,300,0,0,8982,3155,0,0),
(108505,23666,571,1,1,0,1,1877.944,-4120.542,214.7395,0.6609709,300,0,0,8982,0,0,0),
(108510,23663,571,1,1,0,1,1880.633,-4118.451,214.6458,3.802564,300,0,0,8982,0,0,0),
(108511,23664,571,1,1,0,1,1880.633,-4118.451,214.6458,3.802564,300,0,0,9291,0,0,0),
(108520,23665,571,1,1,0,1,1880.633,-4118.451,214.6458,3.802564,300,0,0,8982,3155,0,0),
(108521,23666,571,1,1,0,1,1880.633,-4118.451,214.6458,3.802564,300,0,0,8982,0,0,0),
(108562,23663,571,1,1,0,1,1964.592,-4071.603,215.1496,5.451624,300,0,0,8982,0,0,0),-- #21th pair
(108600,23664,571,1,1,0,1,1964.592,-4071.603,215.1496,5.451624,300,0,0,9291,0,0,0),
(108766,23665,571,1,1,0,1,1964.592,-4071.603,215.1496,5.451624,300,0,0,8982,3155,0,0),
(108846,23666,571,1,1,0,1,1964.592,-4071.603,215.1496,5.451624,300,0,0,8982,0,0,0),
(108886,23663,571,1,1,0,1,1967.281,-4074.553,215.2122,2.310031,300,0,0,8982,0,0,0),
(108894,23664,571,1,1,0,1,1967.281,-4074.553,215.2122,2.310031,300,0,0,9291,0,0,0),
(108920,23665,571,1,1,0,1,1967.281,-4074.553,215.2122,2.310031,300,0,0,8982,3155,0,0),
(108925,23666,571,1,1,0,1,1967.281,-4074.553,215.2122,2.310031,300,0,0,8982,0,0,0),
(108959,23663,571,1,1,0,1,1941.719,-4146.763,214.4467,2.971595,300,0,0,8982,0,0,0),-- #22th pair
(108963,23664,571,1,1,0,1,1941.719,-4146.763,214.4467,2.971595,300,0,0,9291,0,0,0),
(108964,23665,571,1,1,0,1,1941.719,-4146.763,214.4467,2.971595,300,0,0,8982,3155,0,0),
(108965,23666,571,1,1,0,1,1941.719,-4146.763,214.4467,2.971595,300,0,0,8982,0,0,0),
(108966,23663,571,1,1,0,1,1937.913,-4146.109,214.3904,6.113188,300,0,0,8982,0,0,0),
(108997,23664,571,1,1,0,1,1937.913,-4146.109,214.3904,6.113188,300,0,0,9291,0,0,0),
(108999,23665,571,1,1,0,1,1937.913,-4146.109,214.3904,6.113188,300,0,0,8982,3155,0,0),
(109000,23666,571,1,1,0,1,1937.913,-4146.109,214.3904,6.113188,300,0,0,8982,0,0,0),
(109001,23663,571,1,1,0,1,1943.957,-4185.292,214.712,1.689342,300,0,0,8982,0,0,0),-- #23th pair
(109004,23664,571,1,1,0,1,1943.957,-4185.292,214.712,1.689342,300,0,0,9291,0,0,0),
(109019,23665,571,1,1,0,1,1943.957,-4185.292,214.712,1.689342,300,0,0,8982,3155,0,0),
(109045,23666,571,1,1,0,1,1943.957,-4185.292,214.712,1.689342,300,0,0,8982,0,0,0),
(109047,23663,571,1,1,0,1,1943.489,-4181.358,214.8517,4.830935,300,0,0,8982,0,0,0),
(109066,23664,571,1,1,0,1,1943.489,-4181.358,214.8517,4.830935,300,0,0,9291,0,0,0),
(109112,23665,571,1,1,0,1,1943.489,-4181.358,214.8517,4.830935,300,0,0,8982,3155,0,0),
(109145,23666,571,1,1,0,1,1943.489,-4181.358,214.8517,4.830935,300,0,0,8982,0,0,0);
-- individual addons
DELETE FROM `creature_addon` WHERE `guid` IN (106218, 106222, 106194, 106193, 106534, 106195, 106274, 106205, 106355, 106354, 106288, 106358, 106568, 106207, 106359, 106211, 106212, 106196, 106537, 106270, 106271, 106202, 106259, 106206, 106569, 106210, 106495, 106282, 106344, 106197, 106280, 106281, 106204, 106356, 106497, 106234, 106243, 106341, 106273, 106357, 106228, 106496, 106572, 106276, 107167, 107168, 107249, 107253, 107389, 107408, 107410, 107411, 107413, 107414, 107415, 107416, 107417, 107423, 107426, 107432, 107433, 107434, 107435, 107436, 107444, 107445, 107446, 107447, 107448, 107449, 107450, 107451, 107452, 107453, 107457, 107458, 107459, 107460, 107461, 107462, 107463, 107464, 107465, 107466, 107468, 107469, 107470, 107471, 107472, 107473, 107474, 107475, 107478, 107484, 107485, 107486, 107487, 107489, 107490, 107493, 107494, 107496, 107497, 107498, 107499, 107500, 107503, 107519, 107520, 107521, 107522, 107523, 107525, 107528, 107560, 107566, 107568, 107576, 107577, 107578, 107579, 107580, 107582, 107605, 107607, 107624, 107629, 107641, 107704, 107706, 107802, 107814, 107837, 107999, 108000, 108001, 108002, 108003, 108004, 108005, 108006, 108007, 108008, 108009, 108010, 108011, 108019, 108025, 108028, 108033, 108043, 108048, 108100, 108110, 108136, 108137, 108198, 108505, 108510, 108511, 108520, 108521, 108562, 108600, 108766, 108846, 108886, 108894, 108920, 108925, 108959, 108963, 108964, 108965, 108966, 108997, 108999, 109000, 109001, 109004, 109019, 109045, 109047, 109066, 109112, 109145);
INSERT INTO `creature_addon` (`guid`,`mount`,`bytes1`,`bytes2`,`emote`) VALUES
(106194,0,0,1,333),
(106193,0,0,1,333),
(106534,0,0,1,333),
(106195,0,0,1,375),
(106274,0,0,1,333),
(106205,0,0,1,333),
(106355,0,0,1,333),
(106354,0,0,1,375),
(106288,0,0,1,333),
(106358,0,0,1,333),
(106568,0,0,1,333),
(106207,0,0,1,375),
(106359,0,0,1,333),
(106211,0,0,1,333),
(106212,0,0,1,333),
(106196,0,0,1,375),
(106537,0,0,1,333),
(106270,0,0,1,333),
(106271,0,0,1,333),
(106202,0,0,1,375),
(106259,0,0,1,333),
(106206,0,0,1,333),
(106569,0,0,1,333),
(106210,0,0,1,375),
(106495,0,0,1,333),
(106282,0,0,1,333),
(106344,0,0,1,333),
(106197,0,0,1,375),
(106280,0,0,1,333),
(106281,0,0,1,333),
(106204,0,0,1,333),
(106356,0,0,1,375),
(106497,0,0,1,333),
(106234,0,0,1,333),
(106243,0,0,1,333),
(106341,0,0,1,375),
(106273,0,0,1,333),
(106357,0,0,1,333),
(106228,0,0,1,333),
(106496,0,0,1,375),
(106572,0,0,1,333),
(106276,0,0,1,333),
(107167,0,0,1,333),
(107168,0,0,1,375),
(107249,0,0,1,333),
(107253,0,0,1,333),
(107389,0,0,1,333),
(107408,0,0,1,375),
(107410,0,0,1,333),
(107411,0,0,1,333),
(107413,0,0,1,333),
(107414,0,0,1,375),
(107415,0,0,1,333),
(107416,0,0,1,333),
(107417,0,0,1,333),
(107423,0,0,1,375),
(107426,0,0,1,333),
(107432,0,0,1,333),
(107433,0,0,1,333),
(107434,0,0,1,375),
(107435,0,0,1,333),
(107436,0,0,1,333),
(107444,0,0,1,333),
(107445,0,0,1,375),
(107446,0,0,1,333),
(107447,0,0,1,333),
(107448,0,0,1,333),
(107449,0,0,1,375),
(107450,0,0,1,333),
(107451,0,0,1,333),
(107452,0,0,1,333),
(107453,0,0,1,375),
(107457,0,0,1,333),
(107458,0,0,1,333),
(107459,0,0,1,333),
(107460,0,0,1,375),
(107461,0,0,1,333),
(107462,0,0,1,333),
(107463,0,0,1,333),
(107464,0,0,1,375),
(107465,0,0,1,333),
(107466,0,0,1,333),
(107468,0,0,1,333),
(107469,0,0,1,375),
(107470,0,0,1,333),
(107471,0,0,1,333),
(107472,0,0,1,333),
(107473,0,0,1,375),
(107474,0,0,1,333),
(107475,0,0,1,333),
(107478,0,0,1,333),
(107484,0,0,1,375),
(107485,0,0,1,333),
(107486,0,0,1,333),
(107487,0,0,1,333),
(107489,0,0,1,375),
(107490,0,0,1,333),
(107493,0,0,1,333),
(107494,0,0,1,333),
(107496,0,0,1,375),
(107497,0,0,1,333),
(107498,0,0,1,333),
(107499,0,0,1,333),
(107500,0,0,1,375),
(107503,0,0,1,333),
(107519,0,0,1,333),
(107520,0,0,1,333),
(107521,0,0,1,375),
(107522,0,0,1,333),
(107523,0,0,1,333),
(107525,0,0,1,333),
(107528,0,0,1,375),
(107560,0,0,1,333),
(107566,0,0,1,333),
(107568,0,0,1,333),
(107576,0,0,1,375),
(107577,0,0,1,333),
(107578,0,0,1,333),
(107579,0,0,1,333),
(107580,0,0,1,375),
(107582,0,0,1,333),
(107605,0,0,1,333),
(107607,0,0,1,333),
(107624,0,0,1,375),
(107629,0,0,1,333),
(107641,0,0,1,333),
(107704,0,0,1,333),
(107706,0,0,1,375),
(107802,0,0,1,333),
(107814,0,0,1,333),
(107837,0,0,1,333),
(107999,0,0,1,375),
(108000,0,0,1,333),
(108001,0,0,1,333),
(108002,0,0,1,333),
(108003,0,0,1,375),
(108004,0,0,1,333),
(108005,0,0,1,333),
(108006,0,0,1,333),
(108007,0,0,1,375),
(108008,0,0,1,333),
(108009,0,0,1,333),
(108010,0,0,1,333),
(108011,0,0,1,375),
(108019,0,0,1,333),
(108025,0,0,1,333),
(108028,0,0,1,333),
(108033,0,0,1,375),
(108043,0,0,1,333),
(108048,0,0,1,333),
(108100,0,0,1,333),
(108110,0,0,1,375),
(108136,0,0,1,333),
(108137,0,0,1,333),
(108198,0,0,1,333),
(108505,0,0,1,375),
(108510,0,0,1,333),
(108511,0,0,1,333),
(108520,0,0,1,333),
(108521,0,0,1,375),
(108562,0,0,1,333),
(108600,0,0,1,333),
(108766,0,0,1,333),
(108846,0,0,1,375),
(108886,0,0,1,333),
(108894,0,0,1,333),
(108920,0,0,1,333),
(108925,0,0,1,375),
(108959,0,0,1,333),
(108963,0,0,1,333),
(108964,0,0,1,333),
(108965,0,0,1,375),
(108966,0,0,1,333),
(108997,0,0,1,333),
(108999,0,0,1,333),
(109000,0,0,1,375),
(109001,0,0,1,333),
(109004,0,0,1,333),
(109019,0,0,1,333),
(109045,0,0,1,375),
(109047,0,0,1,333),
(109066,0,0,1,333),
(109112,0,0,1,333),
(109145,0,0,1,375);
-- Pooling
DELETE FROM `pool_template` WHERE `entry` IN (599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621,622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644);
INSERT INTO `pool_template` (`entry`, `max_limit`, `description`) VALUES
(599, 1, 'Winterskorn Duel 1'),
(600, 1, 'Winterskorn Duel 2'),
(601, 1, 'Winterskorn Duel 3'),
(602, 1, 'Winterskorn Duel 4'),
(603, 1, 'Winterskorn Duel 5'),
(604, 1, 'Winterskorn Duel 6'),
(605, 1, 'Winterskorn Duel 7'),
(606, 1, 'Winterskorn Duel 8'),
(607, 1, 'Winterskorn Duel 9'),
(608, 1, 'Winterskorn Duel 10'),
(609, 1, 'Winterskorn Duel 11'),
(610, 1, 'Winterskorn Duel 12'),
(611, 1, 'Winterskorn Duel 13'),
(612, 1, 'Winterskorn Duel 14'),
(613, 1, 'Winterskorn Duel 15'),
(614, 1, 'Winterskorn Duel 16'),
(615, 1, 'Winterskorn Duel 17'),
(616, 1, 'Winterskorn Duel 18'),
(617, 1, 'Winterskorn Duel 19'),
(618, 1, 'Winterskorn Duel 20'),
(619, 1, 'Winterskorn Duel 21'),
(620, 1, 'Winterskorn Duel 22'),
(621, 1, 'Winterskorn Duel 23'),
(622, 1, 'Winterskorn Duel 24'),
(623, 1, 'Winterskorn Duel 25'),
(624, 1, 'Winterskorn Duel 26'),
(625, 1, 'Winterskorn Duel 27'),
(626, 1, 'Winterskorn Duel 28'),
(627, 1, 'Winterskorn Duel 29'),
(628, 1, 'Winterskorn Duel 30'),
(629, 1, 'Winterskorn Duel 31'),
(630, 1, 'Winterskorn Duel 32'),
(631, 1, 'Winterskorn Duel 33'),
(632, 1, 'Winterskorn Duel 34'),
(633, 1, 'Winterskorn Duel 35'),
(634, 1, 'Winterskorn Duel 36'),
(635, 1, 'Winterskorn Duel 37'),
(636, 1, 'Winterskorn Duel 38'),
(637, 1, 'Winterskorn Duel 39'),
(638, 1, 'Winterskorn Duel 40'),
(639, 1, 'Winterskorn Duel 41'),
(640, 1, 'Winterskorn Duel 42'),
(641, 1, 'Winterskorn Duel 43'),
(642, 1, 'Winterskorn Duel 44'),
(643, 1, 'Winterskorn Duel 45'),
(644, 1, 'Winterskorn Duel 46');

DELETE FROM `pool_creature` WHERE `pool_entry` IN (599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621,622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644);
INSERT INTO `pool_creature` (`guid`, `pool_entry`, `chance`, `description`) VALUES
(106194, 599, 0, 'Winterskorn Duel'),
(106193, 599, 0, 'Winterskorn Duel'),
(106534, 599, 0, 'Winterskorn Duel'),
(106195, 599, 0, 'Winterskorn Duel'),
(106274, 600, 0, 'Winterskorn Duel'),
(106205, 600, 0, 'Winterskorn Duel'),
(106355, 600, 0, 'Winterskorn Duel'),
(106354, 600, 0, 'Winterskorn Duel'),
(106288, 601, 0, 'Winterskorn Duel'),
(106358, 601, 0, 'Winterskorn Duel'),
(106568, 601, 0, 'Winterskorn Duel'),
(106207, 601, 0, 'Winterskorn Duel'),
(106359, 602, 0, 'Winterskorn Duel'),
(106211, 602, 0, 'Winterskorn Duel'),
(106212, 602, 0, 'Winterskorn Duel'),
(106196, 602, 0, 'Winterskorn Duel'),
(106537, 603, 0, 'Winterskorn Duel'),
(106270, 603, 0, 'Winterskorn Duel'),
(106271, 603, 0, 'Winterskorn Duel'),
(106202, 603, 0, 'Winterskorn Duel'),
(106259, 604, 0, 'Winterskorn Duel'),
(106206, 604, 0, 'Winterskorn Duel'),
(106569, 604, 0, 'Winterskorn Duel'),
(106210, 604, 0, 'Winterskorn Duel'),
(106495, 605, 0, 'Winterskorn Duel'),
(106282, 605, 0, 'Winterskorn Duel'),
(106344, 605, 0, 'Winterskorn Duel'),
(106197, 605, 0, 'Winterskorn Duel'),
(106280, 606, 0, 'Winterskorn Duel'),
(106281, 606, 0, 'Winterskorn Duel'),
(106204, 606, 0, 'Winterskorn Duel'),
(106356, 606, 0, 'Winterskorn Duel'),
(106497, 607, 0, 'Winterskorn Duel'),
(106234, 607, 0, 'Winterskorn Duel'),
(106243, 607, 0, 'Winterskorn Duel'),
(106341, 607, 0, 'Winterskorn Duel'),
(106273, 608, 0, 'Winterskorn Duel'),
(106357, 608, 0, 'Winterskorn Duel'),
(106228, 608, 0, 'Winterskorn Duel'),
(106496, 608, 0, 'Winterskorn Duel'),
(106572, 609, 0, 'Winterskorn Duel'),
(106276, 609, 0, 'Winterskorn Duel'),
(107167, 609, 0, 'Winterskorn Duel'),
(107168, 609, 0, 'Winterskorn Duel'),
(107249, 610, 0, 'Winterskorn Duel'),
(107253, 610, 0, 'Winterskorn Duel'),
(107389, 610, 0, 'Winterskorn Duel'),
(107408, 610, 0, 'Winterskorn Duel'),
(107410, 611, 0, 'Winterskorn Duel'),
(107411, 611, 0, 'Winterskorn Duel'),
(107413, 611, 0, 'Winterskorn Duel'),
(107414, 611, 0, 'Winterskorn Duel'),
(107415, 612, 0, 'Winterskorn Duel'),
(107416, 612, 0, 'Winterskorn Duel'),
(107417, 612, 0, 'Winterskorn Duel'),
(107423, 612, 0, 'Winterskorn Duel'),
(107426, 613, 0, 'Winterskorn Duel'),
(107432, 613, 0, 'Winterskorn Duel'),
(107433, 613, 0, 'Winterskorn Duel'),
(107434, 613, 0, 'Winterskorn Duel'),
(107435, 614, 0, 'Winterskorn Duel'),
(107436, 614, 0, 'Winterskorn Duel'),
(107444, 614, 0, 'Winterskorn Duel'),
(107445, 614, 0, 'Winterskorn Duel'),
(107446, 615, 0, 'Winterskorn Duel'),
(107447, 615, 0, 'Winterskorn Duel'),
(107448, 615, 0, 'Winterskorn Duel'),
(107449, 615, 0, 'Winterskorn Duel'),
(107450, 616, 0, 'Winterskorn Duel'),
(107451, 616, 0, 'Winterskorn Duel'),
(107452, 616, 0, 'Winterskorn Duel'),
(107453, 616, 0, 'Winterskorn Duel'),
(107457, 617, 0, 'Winterskorn Duel'),
(107458, 617, 0, 'Winterskorn Duel'),
(107459, 617, 0, 'Winterskorn Duel'),
(107460, 617, 0, 'Winterskorn Duel'),
(107461, 618, 0, 'Winterskorn Duel'),
(107462, 618, 0, 'Winterskorn Duel'),
(107463, 618, 0, 'Winterskorn Duel'),
(107464, 618, 0, 'Winterskorn Duel'),
(107465, 619, 0, 'Winterskorn Duel'),
(107466, 619, 0, 'Winterskorn Duel'),
(107468, 619, 0, 'Winterskorn Duel'),
(107469, 619, 0, 'Winterskorn Duel'),
(107470, 620, 0, 'Winterskorn Duel'),
(107471, 620, 0, 'Winterskorn Duel'),
(107472, 620, 0, 'Winterskorn Duel'),
(107473, 620, 0, 'Winterskorn Duel'),
(107474, 621, 0, 'Winterskorn Duel'),
(107475, 621, 0, 'Winterskorn Duel'),
(107478, 621, 0, 'Winterskorn Duel'),
(107484, 621, 0, 'Winterskorn Duel'),
(107485, 622, 0, 'Winterskorn Duel'),
(107486, 622, 0, 'Winterskorn Duel'),
(107487, 622, 0, 'Winterskorn Duel'),
(107489, 622, 0, 'Winterskorn Duel'),
(107490, 623, 0, 'Winterskorn Duel'),
(107493, 623, 0, 'Winterskorn Duel'),
(107494, 623, 0, 'Winterskorn Duel'),
(107496, 623, 0, 'Winterskorn Duel'),
(107497, 624, 0, 'Winterskorn Duel'),
(107498, 624, 0, 'Winterskorn Duel'),
(107499, 624, 0, 'Winterskorn Duel'),
(107500, 624, 0, 'Winterskorn Duel'),
(107503, 625, 0, 'Winterskorn Duel'),
(107519, 625, 0, 'Winterskorn Duel'),
(107520, 625, 0, 'Winterskorn Duel'),
(107521, 625, 0, 'Winterskorn Duel'),
(107522, 626, 0, 'Winterskorn Duel'),
(107523, 626, 0, 'Winterskorn Duel'),
(107525, 626, 0, 'Winterskorn Duel'),
(107528, 626, 0, 'Winterskorn Duel'),
(107560, 627, 0, 'Winterskorn Duel'),
(107566, 627, 0, 'Winterskorn Duel'),
(107568, 627, 0, 'Winterskorn Duel'),
(107576, 627, 0, 'Winterskorn Duel'),
(107577, 628, 0, 'Winterskorn Duel'),
(107578, 628, 0, 'Winterskorn Duel'),
(107579, 628, 0, 'Winterskorn Duel'),
(107580, 628, 0, 'Winterskorn Duel'),
(107582, 629, 0, 'Winterskorn Duel'),
(107605, 629, 0, 'Winterskorn Duel'),
(107607, 629, 0, 'Winterskorn Duel'),
(107624, 629, 0, 'Winterskorn Duel'),
(107629, 630, 0, 'Winterskorn Duel'),
(107641, 630, 0, 'Winterskorn Duel'),
(107704, 630, 0, 'Winterskorn Duel'),
(107706, 630, 0, 'Winterskorn Duel'),
(107802, 631, 0, 'Winterskorn Duel'),
(107814, 631, 0, 'Winterskorn Duel'),
(107837, 631, 0, 'Winterskorn Duel'),
(107999, 631, 0, 'Winterskorn Duel'),
(108000, 632, 0, 'Winterskorn Duel'),
(108001, 632, 0, 'Winterskorn Duel'),
(108002, 632, 0, 'Winterskorn Duel'),
(108003, 632, 0, 'Winterskorn Duel'),
(108004, 633, 0, 'Winterskorn Duel'),
(108005, 633, 0, 'Winterskorn Duel'),
(108006, 633, 0, 'Winterskorn Duel'),
(108007, 633, 0, 'Winterskorn Duel'),
(108008, 634, 0, 'Winterskorn Duel'),
(108009, 634, 0, 'Winterskorn Duel'),
(108010, 634, 0, 'Winterskorn Duel'),
(108011, 634, 0, 'Winterskorn Duel'),
(108019, 635, 0, 'Winterskorn Duel'),
(108025, 635, 0, 'Winterskorn Duel'),
(108028, 635, 0, 'Winterskorn Duel'),
(108033, 635, 0, 'Winterskorn Duel'),
(108043, 636, 0, 'Winterskorn Duel'),
(108048, 636, 0, 'Winterskorn Duel'),
(108100, 636, 0, 'Winterskorn Duel'),
(108110, 636, 0, 'Winterskorn Duel'),
(108136, 637, 0, 'Winterskorn Duel'),
(108137, 637, 0, 'Winterskorn Duel'),
(108198, 637, 0, 'Winterskorn Duel'),
(108505, 637, 0, 'Winterskorn Duel'),
(108510, 638, 0, 'Winterskorn Duel'),
(108511, 638, 0, 'Winterskorn Duel'),
(108520, 638, 0, 'Winterskorn Duel'),
(108521, 638, 0, 'Winterskorn Duel'),
(108562, 639, 0, 'Winterskorn Duel'),
(108600, 639, 0, 'Winterskorn Duel'),
(108766, 639, 0, 'Winterskorn Duel'),
(108846, 639, 0, 'Winterskorn Duel'),
(108886, 640, 0, 'Winterskorn Duel'),
(108894, 640, 0, 'Winterskorn Duel'),
(108920, 640, 0, 'Winterskorn Duel'),
(108925, 640, 0, 'Winterskorn Duel'),
(108959, 641, 0, 'Winterskorn Duel'),
(108963, 641, 0, 'Winterskorn Duel'),
(108964, 641, 0, 'Winterskorn Duel'),
(108965, 641, 0, 'Winterskorn Duel'),
(108966, 642, 0, 'Winterskorn Duel'),
(108997, 642, 0, 'Winterskorn Duel'),
(108999, 642, 0, 'Winterskorn Duel'),
(109000, 642, 0, 'Winterskorn Duel'),
(109001, 643, 0, 'Winterskorn Duel'),
(109004, 643, 0, 'Winterskorn Duel'),
(109019, 643, 0, 'Winterskorn Duel'),
(109045, 643, 0, 'Winterskorn Duel'),
(109047, 644, 0, 'Winterskorn Duel'),
(109066, 644, 0, 'Winterskorn Duel'),
(109112, 644, 0, 'Winterskorn Duel'),
(109145, 644, 0, 'Winterskorn Duel');
-- 
DELETE FROM `smart_scripts` WHERE `entryorguid` IN (2366300,2366301,2366302,2366303,2366304,2366500,2366501,2366502,2366503,2366504,2366600,2366601,2366602,2366603,2366604) AND `source_type`=9;
DELETE FROM `smart_scripts` WHERE `entryorguid` IN (23663,23665,23666) AND `source_type`=0 AND `id`=5;
DELETE FROM `smart_scripts` WHERE `entryorguid` IN (23664) AND `source_type`=0 AND `id`=4;
INSERT INTO `smart_scripts` (`entryorguid`, `source_type`, `id`, `link`, `event_type`, `event_phase_mask`, `event_chance`, `event_flags`, `event_param1`, `event_param2`, `event_param3`, `event_param4`, `action_type`, `action_param1`, `action_param2`, `action_param3`, `action_param4`, `action_param5`, `action_param6`, `target_type`, `target_param1`, `target_param2`, `target_param3`, `target_x`, `target_y`, `target_z`, `target_o`, `comment`) VALUES
(23663, 0, 5, 0, 1, 0, 100, 0, 3000, 6000, 3000, 6000, 88, 2366300, 2366304, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Shield-Maiden - Ooc - Random timed action list"),
(2366300, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42880, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Shield-Maiden - On timed action list - Cast Cosmetic - Combat Attack 1H"),
(2366301, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42908, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Shield-Maiden - On timed action list - Cast Cosmetic - Combat Kick"),
(2366302, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42907, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Shield-Maiden - On timed action list - Cast Cosmetic - Combat Shield Bash"),
(2366303, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42906, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Shield-Maiden - On timed action list - Cast Cosmetic - Combat Shield Block"),
(2366304, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42903, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Shield-Maiden - On timed action list - Cast Cosmetic - Combat Special Attack 1H"),
(23664, 0, 4, 0, 1, 0, 100, 0, 3000, 6000, 3000, 6000, 88, 2366300, 2366304, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Warrior - Ooc - Random timed action list"),
(23665, 0, 5, 0, 1, 0, 100, 0, 3000, 6000, 3000, 6000, 88, 2366500, 2366504, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Raider - Ooc - Random timed action list"),
(2366500, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42880, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Raider - On timed action list - Cast Cosmetic - Combat Attack 1H"),
(2366501, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42908, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Raider - On timed action list - Cast Cosmetic - Combat Kick"),
(2366502, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42903, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Raider - On timed action list - Cast Cosmetic - Combat Special Attack 1H"),
(2366503, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42902, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Raider - On timed action list - Cast Cosmetic - Combat Attack Offhand"),
(2366504, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42901, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Raider - On timed action list - Cast Cosmetic - Combat Whirlwind"),
(2366504, 9, 1, 0, 0, 0, 100, 0, 1000, 1000, 0, 0, 28, 42901, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Raider - On timed action list - Cast Cosmetic - Combat Whirlwind"),
(23666, 0, 5, 0, 1, 0, 100, 0, 3000, 6000, 3000, 6000, 88, 2366600, 2366604, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Berserker- Ooc - Random timed action list"),
(2366600, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42880, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Berserker - On timed action list - Cast Cosmetic - Combat Attack 1H"),
(2366601, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42908, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Berserker - On timed action list - Cast Cosmetic - Combat Kick"),
(2366602, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42904, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Berserker - On timed action list - Cast Cosmetic - Combat Special Attack 2H"),
(2366603, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42889, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Berserker - On timed action list - Cast Cosmetic - Combat Attack 2H"),
(2366604, 9, 0, 0, 0, 0, 100, 0, 0, 0, 0, 0, 11, 42901, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Berserker - On timed action list - Cast Cosmetic - Combat Whirlwind"),
(2366604, 9, 1, 0, 0, 0, 100, 0, 1000, 1000, 0, 0, 28, 42901, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, "Winterskorn Berserker - On timed action list - Cast Cosmetic - Combat Whirlwind");
-- 
DELETE FROM `conditions` WHERE `SourceTypeOrReferenceId`=22 AND `SourceEntry` IN (23663,23664,23665,23666);
INSERT INTO `conditions` (`SourceTypeOrReferenceId`,`SourceGroup`,`SourceEntry`,`SourceId`,`ElseGroup`,`ConditionTypeOrReference`,`ConditionTarget`,`ConditionValue1`,`ConditionValue2`,`ConditionValue3`,`NegativeCondition` ,`ErrorTextId`,`ScriptName`,`Comment`) VALUES
(22,6,23663,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23663,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23663,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23663,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23663,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23663,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23663,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23663,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23664,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23664,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23664,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23664,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23664,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23664,0,0,1,1,29266,0,0,1,0,'','Winterskorn Berserker only run SAI if Winterskorn Berserker does not have aura Permanent Feign Death'),
(22,4,23664,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23664,0,1,1,1,29266,0,0,1,0,'','Winterskorn Berserker only run SAI if Winterskorn Berserker does not have aura Permanent Feign Death'),
(22,4,23664,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23664,0,2,1,1,29266,0,0,1,0,'','Winterskorn Berserker only run SAI if Winterskorn Berserker does not have aura Permanent Feign Death'),
(22,4,23664,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23664,0,3,1,1,29266,0,0,1,0,'','Winterskorn Berserker only run SAI if Winterskorn Berserker does not have aura Permanent Feign Death'),
(22,6,23665,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23665,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23665,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23665,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23665,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23665,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23665,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,5,23665,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23666,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23666,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23666,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,6,23666,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23666,0,0,29,1,23663,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23666,0,1,29,1,23664,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23666,0,2,29,1,23665,6,0,0,0,'','execute SAI only if near creature'),
(22,4,23666,0,3,29,1,23666,6,0,0,0,'','execute SAI only if near creature');
