-- Issue 8514: Razormane Wolves - add and bind to Razormane Hunters
-- Razormane Hunters in the Barrens (9 guids) are all missing the Wolves that path with them
-- create a Razormane Wolf pet (#3939) for each of the 9 Razormane Hunters (#3265)
SET @GUID := 45823; -- set by tdb team
-- insert 9 razormane wolves into new guids (@GUID to @GUID+8) with invalid xyz coords (we don't know them yet)
DELETE FROM `creature` WHERE `guid` BETWEEN @GUID AND @GUID+8;
INSERT INTO `creature` (`guid`,`id`,`map`,`position_x`,`position_y`, `position_z`,`spawntimesecs`,`curhealth`,`MovementType`) VALUES 
(@GUID  ,3939,1,0,0,0,90,120,1),
(@GUID+1,3939,1,0,0,0,90,120,1),
(@GUID+2,3939,1,0,0,0,90,120,1),
(@GUID+3,3939,1,0,0,0,90,120,1),
(@GUID+4,3939,1,0,0,0,90,120,1),
(@GUID+5,3939,1,0,0,0,90,120,1),
(@GUID+6,3939,1,0,0,0,90,120,1),
(@GUID+7,3939,1,0,0,0,90,120,1),
(@GUID+8,3939,1,0,0,0,90,120,1);
-- bind the wolves to the 9 razormane hunters (id 3265)
DELETE FROM `creature_formations` WHERE `leaderGUID` BETWEEN 20301 AND 20309;
INSERT INTO `creature_formations` (`leaderGUID`,`memberGUID`,`dist`,`angle`,`groupAI`) VALUES 
(20301,20301,0,0,2),
(20301,@GUID,4,60,2),
(20302,20302,0,0,2),
(20302,@GUID+1,4,60,2),
(20303,20303,0,0,2),
(20303,@GUID+2,4,60,2),
(20304,20304,0,0,2),
(20304,@GUID+3,4,60,2),
(20305,20305,0,0,2),
(20305,@GUID+4,4,60,2),
(20306,20306,0,0,2),
(20306,@GUID+5,4,60,2),
(20307,20307,0,0,2),
(20307,@GUID+6,4,60,2),
(20308,20308,0,0,2),
(20308,@GUID+7,4,60,2),
(20309,20309,0,0,2),
(20309,@GUID+8,4,60,2);
-- now set the wolf pets to the same xyz as their leader
UPDATE `creature` c1,`creature` c2,`creature_formations` cf SET c1.`position_x`=c2.`position_x`,c1.`position_y`=c2.`position_y`,c1.`position_z`=c2.`position_z` WHERE c1.`guid`=cf.`memberGUID` AND c2.`guid`=cf.`leaderGUID` AND c1. `guid` BETWEEN @GUID AND @GUID+8;
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Issue 8594: Missing Raptor egg nests
-- Create spawn points for missing Raptor nests (Takk nest pool, Ravasaur nest pool, Razormaw nest)
SET @GUID :=14990;
-- existing nest for Ravasaur Matriarch will be re-added with others in pool
DELETE FROM `gameobject` WHERE `guid` = 150392;
-- New spawns
DELETE FROM `gameobject` WHERE `guid` BETWEEN @GUID AND @GUID+9;
INSERT INTO `gameobject` (`guid`,`id`,`map`,`position_x`,`position_y`,`position_z`,`spawntimesecs`,`animprogress`,`state`) VALUES
(@GUID  ,202081,1, 1036.85,-3404.15,  91.67,3600,0,1),
(@GUID+1,202081,1,  929.03,-3483.34,  91.67,3600,0,1),
(@GUID+2,202081,1,  708.62,-3527.60,  91.76,3600,0,1),
(@GUID+3,202081,1,  844.24,-3573.38,  91.74,3600,0,1),
(@GUID+4,202082,1,-7522.43,-1797.43,-271.79,3600,0,1),
(@GUID+5,202082,1,-7594.88,-1800.48,-265.33,3600,0,1),
(@GUID+6,202082,1,-7426.77,-2018.86,-271.69,3600,0,1),
(@GUID+7,202082,1,-7668.27,-1966.72,-271.96,3600,0,1),
(@GUID+8,202082,1,-7824.72,-1590.05,-265.07,3600,0,1),
(@GUID+9,202083,0,-2944.48,-3277.68,  62.27,18000,100, 1);
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID AND @GUID+9;
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`description`) VALUES
(@GUID  ,7001, 'Takk''s Nest spawn point #1'),
(@GUID+1,7001, 'Takk''s Nest spawn point #2'),
(@GUID+2,7001, 'Takk''s Nest spawn point #3'),
(@GUID+3,7001, 'Takk''s Nest spawn point #4'),
(@GUID+4,7002, 'Ravasaur Matriarch''s Nest spawn point #1'),
(@GUID+5,7002, 'Ravasaur Matriarch''s Nest spawn point #2'),
(@GUID+6,7002, 'Ravasaur Matriarch''s Nest spawn point #3'),
(@GUID+7,7002, 'Ravasaur Matriarch''s Nest spawn point #4'),
(@GUID+8,7002, 'Ravasaur Matriarch''s Nest spawn point #5');
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Issue 8601: Twilight Prophet (2) - Pathing
-- ====================================
-- Paths for Twilight Prophet 1 (guid #43322)
-- ====================================
UPDATE `creature` SET `MovementType`=2,`position_x`=-7895.314941, `position_y`=1891.944092,`position_z`=8.447455 WHERE `guid`=43322;
UPDATE `creature_addon` SET `path_id`=433220 WHERE `guid`=43322;
DELETE FROM `waypoint_data` WHERE `id`=433220;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(433220,1,-7895.314941,1891.944092,8.447455,0,0,0,0,100,0),
(433220,2,-7889.814453,1892.442139,6.512199,0,0,0,0,100,0),
(433220,3,-7875.850586,1893.292969,5.065457,0,0,0,0,100,0),
(433220,4,-7863.858398,1890.743408,3.855400,0,0,0,0,100,0),
(433220,5,-7851.287109,1884.620361,3.379698,0,0,0,0,100,0),
(433220,6,-7839.691406,1876.790527,3.826157,0,0,0,0,100,0),
(433220,7,-7826.647461,1865.424316,4.368514,0,0,0,0,100,0),
(433220,8,-7816.574219,1855.712524,3.208780,0,0,0,0,100,0),
(433220,9,-7807.453613,1847.762085,2.136624,0,0,0,0,100,0),
(433220,10,-7799.522461,1836.230225,2.907008,0,0,0,0,100,0),
(433220,11,-7789.064453,1822.204468,1.495795,0,0,0,0,100,0),
(433220,12,-7780.687500,1810.996704,-0.079978,0,0,0,0,100,0),
(433220,13,-7773.758301,1795.407227,2.095025,0,0,0,0,100,0),
(433220,14,-7770.189941,1781.901123,3.807251,0,0,0,0,100,0),
(433220,15,-7768.526855,1768.004028,3.786433,0,0,0,0,100,0),
(433220,16,-7767.317871,1754.062012,4.589085,0,0,0,0,100,0),
(433220,17,-7766.593750,1740.086060,5.127120,0,0,0,0,100,0),
(433220,18,-7766.543457,1722.587158,3.306771,0,0,0,0,100,0),
(433220,19,-7765.512207,1710.202515,2.194530,0,0,0,0,100,0),
(433220,20,-7756.119141,1696.762329,2.299271,0,0,0,0,100,0),
(433220,21,-7745.099121,1688.132690,5.269642,0,0,0,0,100,0),
(433220,22,-7734.173828,1679.384888,7.263340,0,0,0,0,100,0),
(433220,23,-7724.966797,1669.663940,7.202020,0,0,0,0,100,0),
(433220,24,-7715.616699,1659.246826,7.387191,0,0,0,0,100,0),
(433220,25,-7703.356445,1646.774414,7.689360,0,0,0,0,100,0),
(433220,26,-7693.303223,1637.030884,5.440024,0,0,0,0,100,0),
(433220,27,-7685.538086,1624.118042,5.128979,0,0,0,0,100,0),
(433220,28,-7677.588867,1612.681885,3.419049,0,0,0,0,100,0),
(433220,29,-7667.428711,1601.642334,1.248345,0,0,0,0,100,0),
(433220,30,-7656.230957,1593.253296,3.186309,0,0,0,0,100,0),
(433220,31,-7643.143066,1587.457275,5.195174,0,0,0,0,100,0),
(433220,32,-7628.659668,1587.804810,6.025109,0,0,0,0,100,0),
(433220,33,-7619.128906,1595.998901,5.355808,0,0,0,0,100,0),
(433220,34,-7613.072266,1608.582764,2.668371,0,0,0,0,100,0),
(433220,35,-7605.075684,1620.776611,2.568130,0,0,0,0,100,0),
(433220,36,-7599.562988,1634.706543,4.553499,0,0,0,0,100,0),
(433220,37,-7605.732422,1639.759155,2.198371,0,0,0,0,100,0),
(433220,38,-7610.278320,1628.909790,2.462519,0,0,0,0,100,0),
(433220,39,-7613.120605,1611.651123,2.589123,0,0,0,0,100,0),
(433220,40,-7617.356934,1598.347534,4.641613,0,0,0,0,100,0),
(433220,41,-7628.784180,1587.950806,6.064836,0,0,0,0,100,0),
(433220,42,-7639.729980,1589.783813,5.447087,0,0,0,0,100,0),
(433220,43,-7654.615723,1597.761353,3.670609,0,0,0,0,100,0),
(433220,44,-7663.443359,1606.836182,2.949980,0,0,0,0,100,0),
(433220,45,-7672.763672,1617.280640,4.842738,0,0,0,0,100,0),
(433220,46,-7684.707031,1630.059326,5.168031,0,0,0,0,100,0),
(433220,47,-7694.602051,1639.962524,5.923426,0,0,0,0,100,0),
(433220,48,-7707.055176,1652.256348,7.801556,0,0,0,0,100,0),
(433220,49,-7717.229004,1661.873413,7.195765,0,0,0,0,100,0),
(433220,50,-7727.743652,1671.116211,7.281052,0,0,0,0,100,0),
(433220,51,-7738.428711,1680.162109,6.843456,0,0,0,0,100,0),
(433220,52,-7751.823730,1691.423706,3.485293,0,0,0,0,100,0),
(433220,53,-7762.860352,1702.140625,1.730373,0,0,0,0,100,0),
(433220,54,-7768.805176,1716.334961,2.038195,0,0,0,0,100,0),
(433220,55,-7772.072754,1729.328857,3.194579,0,0,0,0,100,0),
(433220,56,-7773.440430,1746.756226,3.262704,0,0,0,0,100,0),
(433220,57,-7774.675293,1760.701538,1.454978,0,0,0,0,100,0),
(433220,58,-7775.765625,1778.149048,2.863208,0,0,0,0,100,0),
(433220,59,-7778.452637,1790.994507,2.010733,0,0,0,0,100,0),
(433220,60,-7783.087891,1807.865723,0.271067,0,0,0,0,100,0),
(433220,61,-7786.545410,1821.431396,0.923371,0,0,0,0,100,0),
(433220,62,-7790.598633,1838.451538,1.505119,0,0,0,0,100,0),
(433220,63,-7795.272461,1852.971802,1.468031,0,0,0,0,100,0),
(433220,64,-7804.368652,1867.914795,2.308474,0,0,0,0,100,0),
(433220,65,-7811.636719,1877.915405,5.278152,0,0,0,0,100,0),
(433220,66,-7824.912598,1887.686401,5.346197,0,0,0,0,100,0),
(433220,67,-7839.624512,1892.284058,2.934072,0,0,0,0,100,0),
(433220,68,-7856.468262,1895.142822,1.916823,0,0,0,0,100,0),
(433220,69,-7868.257324,1894.790161,4.164560,0,0,0,0,100,0),
(433220,70,-7885.666504,1893.007935,5.893253,0,0,0,0,100,0);
-- ====================================
-- Paths for Twilight Prophet 2 (guid #43323)
-- ====================================
UPDATE `creature` SET `MovementType`=2, `position_x`=-7007.199219, `position_y`=1155.165649, `position_z`=10.367001 WHERE `guid`=43323;
UPDATE `creature_addon` SET `path_id`=433230 WHERE `guid`= 43323;
DELETE FROM `waypoint_data` WHERE `id`=433230;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(433230,1,-7007.199219,1155.165649,10.367001,0,0,0,0,100,0),
(433230,2,-7013.322754,1146.656982,7.765337,0,0,0,0,100,0),
(433230,3,-7029.557129,1126.831177,0.441744,0,0,0,0,100,0),
(433230,4,-7042.741211,1124.151367,2.458173,0,0,0,0,100,0),
(433230,5,-7057.576172,1132.508423,1.796156,0,0,0,0,100,0),
(433230,6,-7066.061523,1144.144409,1.819798,0,0,0,0,100,0),
(433230,7,-7063.622559,1155.527222,0.355760,0,0,0,0,100,0),
(433230,8,-7057.280273,1162.759033,0.884041,0,0,0,0,100,0),
(433230,9,-7051.809082,1173.513184,0.766896,0,0,0,0,100,0),
(433230,10,-7053.896973,1184.036377,0.545792,0,0,0,0,100,0),
(433230,11,-7051.105469,1194.661133,0.349549,0,0,0,0,100,0),
(433230,12,-7054.485840,1205.540894,0.349985,0,0,0,0,100,0),
(433230,13,-7055.359375,1215.794434,0.349985,0,0,0,0,100,0),
(433230,14,-7049.322266,1223.330322,0.349985,0,0,0,0,100,0),
(433230,15,-7035.041992,1239.769531,0.358600,0,0,0,0,100,0),
(433230,16,-7025.624023,1250.415405,0.526597,0,0,0,0,100,0),
(433230,17,-7012.420410,1257.504395,0.411500,0,0,0,0,100,0),
(433230,18,-6993.685059,1258.257690,-0.058926,0,0,0,0,100,0),
(433230,19,-6976.384277,1260.632446,-0.220956,0,0,0,0,100,0),
(433230,20,-6954.655273,1267.109131,2.393948,0,0,0,0,100,0),
(433230,21,-6938.101074,1272.757690,3.474210,0,0,0,0,100,0),
(433230,22,-6923.599609,1283.566650,2.920597,0,0,0,0,100,0),
(433230,23,-6911.884277,1300.983032,5.251194,0,0,0,0,100,0),
(433230,24,-6895.383301,1327.812012,3.925846,0,0,0,0,100,0),
(433230,25,-6882.254395,1348.496704,2.143369,0,0,0,0,100,0),
(433230,26,-6869.834473,1369.613037,3.275267,0,0,0,0,100,0),
(433230,27,-6854.997559,1393.331299,3.114167,0,0,0,0,100,0),
(433230,28,-6840.753418,1417.390625,-0.766261,0,0,0,0,100,0),
(433230,29,-6827.396973,1441.993530,4.690745,0,0,0,0,100,0),
(433230,30,-6815.702148,1459.405029,4.718923,0,0,0,0,100,0),
(433230,31,-6802.099121,1479.763550,3.148716,0,0,0,0,100,0),
(433230,32,-6786.228027,1498.344238,4.406202,0,0,0,0,100,0),
(433230,33,-6756.861816,1533.071045,4.684423,0,0,0,0,100,0),
(433230,34,-6739.011719,1557.908691,5.224258,0,0,0,0,100,0),
(433230,35,-6719.190430,1577.632202,6.617586,0,0,0,0,100,0),
(433230,36,-6700.756348,1593.744507,7.824927,0,0,0,0,100,0),
(433230,37,-6688.981934,1615.776855,10.382424,0,0,0,0,100,0),
(433230,38,-6688.395020,1633.384277,9.874694,0,0,0,0,100,0),
(433230,39,-6695.491211,1645.041016,8.801991,0,0,0,0,100,0),
(433230,40,-6709.729004,1660.468872,7.372326,0,0,0,0,100,0),
(433230,41,-6717.024902,1672.027588,8.437102,0,0,0,0,100,0),
(433230,42,-6725.587402,1666.742920,6.688062,0,0,0,0,100,0),
(433230,43,-6749.216309,1660.499878,6.760650,0,0,0,0,100,0),
(433230,44,-6756.531250,1655.720703,5.885690,0,0,0,0,100,0),
(433230,45,-6751.630859,1649.907227,7.501710,0,0,0,0,100,0),
(433230,46,-6757.303223,1654.306396,5.651666,0,0,0,0,100,0),
(433230,47,-6760.314453,1646.274780,6.422415,0,0,0,0,100,0),
(433230,48,-6760.897949,1620.609009,6.122479,0,0,0,0,100,0),
(433230,49,-6754.945801,1604.433838,7.166245,0,0,0,0,100,0),
(433230,50,-6743.704590,1586.736206,6.590928,0,0,0,0,100,0),
(433230,51,-6734.563965,1566.877808,5.459243,0,0,0,0,100,0),
(433230,52,-6737.753906,1555.786255,5.394959,0,0,0,0,100,0),
(433230,53,-6751.723145,1512.513184,5.181065,0,0,0,0,100,0),
(433230,54,-6759.635742,1478.423706,4.751054,0,0,0,0,100,0),
(433230,55,-6770.013672,1446.814331,2.063652,0,0,0,0,100,0),
(433230,56,-6788.232910,1425.676392,3.310894,0,0,0,0,100,0),
(433230,57,-6800.025391,1396.515381,1.172720,0,0,0,0,100,0),
(433230,58,-6819.817383,1360.497070,4.872425,0,0,0,0,100,0),
(433230,59,-6843.601563,1330.235718,4.759835,0,0,0,0,100,0),
(433230,60,-6865.066895,1302.607056,-0.134331,0,0,0,0,100,0),
(433230,61,-6882.897949,1276.647705,-0.666526,0,0,0,0,100,0),
(433230,62,-6899.618164,1249.951416,1.992437,0,0,0,0,100,0),
(433230,63,-6911.325195,1233.318115,2.319501,0,0,0,0,100,0),
(433230,64,-6921.393555,1211.509766,2.345217,0,0,0,0,100,0),
(433230,65,-6924.643066,1190.791016,2.364320,0,0,0,0,100,0),
(433230,66,-6928.015137,1159.474487,3.196892,0,0,0,0,100,0),
(433230,67,-6936.601563,1143.801880,4.415056,0,0,0,0,100,0),
(433230,68,-6943.562012,1128.777466,3.058245,0,0,0,0,100,0),
(433230,69,-6949.626465,1108.707520,0.427855,0,0,0,0,100,0),
(433230,70,-6964.038086,1089.657227,2.763069,0,0,0,0,100,0),
(433230,71,-6987.258301,1082.670776,4.084322,0,0,0,0,100,0),
(433230,72,-7012.456055,1093.988525,1.606724,0,0,0,0,100,0),
(433230,73,-7026.307129,1108.785156,2.950602,0,0,0,0,100,0),
(433230,74,-7021.941406,1133.171997,1.929922,0,0,0,0,100,0),
(433230,75,-7013.507813,1146.713501,7.749496,0,0,0,0,100,0);
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Issue 8602: Setis - correction and pathing
-- Before Cataclysm, this rare elite was a Fel Reaver type mob in Silithus
-- but the 3.3.5 TDB has this mob inexplicably nerfed to his post-Cataclysm size and damage
--
-- This fixes his pre-Cat size, damage and restores his zone pathing

-- ====================================
-- Setis correction and path
-- ====================================
UPDATE `creature_template` SET `scale`=3, `mindmg`=700, `maxdmg`=900 WHERE `entry`=14471;
UPDATE `creature` SET `MovementType`=2, `position_x`=-7970.898438, `position_y`=1507.219971, `position_z`=-1.551867 WHERE `guid`=51838;
DELETE FROM `creature_addon` WHERE `guid`=51838;
INSERT INTO `creature_addon` (`guid`, `path_id`) VALUES (51838, 518380);
DELETE FROM `waypoint_data` WHERE `id`=518380;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(518380,1,-7970.898438,1507.219971,-1.551867,0,0,0,0,100,0),
(518380,2,-7943.037598,1493.791138,-6.626160,0,0,0,0,100,0),
(518380,3,-7918.484375,1468.855347,-5.768747,0,0,0,0,100,0),
(518380,4,-7894.920898,1446.878418,-9.586535,0,0,0,0,100,0),
(518380,5,-7887.063965,1414.645752,-4.758429,0,0,0,0,100,0),
(518380,6,-7879.735840,1375.461914,-8.273664,0,0,0,0,100,0),
(518380,7,-7863.913574,1348.840820,-6.652806,0,0,0,0,100,0),
(518380,8,-7839.481934,1331.171509,-9.644982,0,0,0,0,100,0),
(518380,9,-7799.420410,1305.002441,-5.837549,0,0,0,0,100,0),
(518380,10,-7775.251953,1267.372559,-4.494194,0,0,0,0,100,0),
(518380,11,-7796.921387,1231.137085,-4.357635,0,0,0,0,100,0),
(518380,12,-7814.783203,1204.887451,-0.534356,0,0,0,0,100,0),
(518380,13,-7823.562500,1158.288696,1.645526,0,0,0,0,100,0),
(518380,14,-7818.532227,1123.668945,0.376355,0,0,0,0,100,0),
(518380,15,-7803.921387,1086.932251,4.711929,0,0,0,0,100,0),
(518380,16,-7769.979980,1061.283813,1.140280,0,0,0,0,100,0),
(518380,17,-7748.981934,1029.688477,2.546784,0,0,0,0,100,0),
(518380,18,-7725.582031,994.818115,1.862588,0,0,0,0,100,0),
(518380,19,-7700.375977,961.477478,-1.844931,0,0,0,0,100,0),
(518380,20,-7660.693848,939.870605,0.607142,0,0,0,0,100,0),
(518380,21,-7628.968262,925.089294,0.414325,0,0,0,0,100,0),
(518380,22,-7594.459473,932.484253,1.851091,0,0,0,0,100,0),
(518380,23,-7550.452148,954.033569,0.911450,0,0,0,0,100,0),
(518380,24,-7519.019531,969.427917,1.444063,0,0,0,0,100,0),
(518380,25,-7476.106934,979.391663,2.042855,0,0,0,0,100,0),
(518380,26,-7428.556641,978.902710,3.131437,0,0,0,0,100,0),
(518380,27,-7390.671875,1013.550964,3.490367,0,0,0,0,100,0),
(518380,28,-7373.875977,1046.144897,4.743690,0,0,0,0,100,0),
(518380,29,-7364.927734,1093.089844,1.329022,0,0,0,0,100,0),
(518380,30,-7347.156250,1145.419922,1.288395,0,0,0,0,100,0),
(518380,31,-7364.325195,1159.787231,3.236028,0,0,0,0,100,0),
(518380,32,-7399.254395,1182.984497,1.843866,0,0,0,0,100,0),
(518380,33,-7429.508301,1202.897827,3.029610,0,0,0,0,100,0),
(518380,34,-7468.980469,1233.918945,3.407038,0,0,0,0,100,0),
(518380,35,-7511.831543,1250.466309,3.333737,0,0,0,0,100,0),
(518380,36,-7540.864258,1269.111328,6.091939,0,0,0,0,100,0),
(518380,37,-7555.662109,1299.827026,2.850513,0,0,0,0,100,0),
(518380,38,-7569.881348,1333.556763,3.011905,0,0,0,0,100,0),
(518380,39,-7598.235352,1373.451294,4.004597,0,0,0,0,100,0),
(518380,40,-7626.755371,1409.476685,3.858852,0,0,0,0,100,0),
(518380,41,-7655.338867,1460.769531,3.685694,0,0,0,0,100,0),
(518380,42,-7697.577637,1485.361694,4.425735,0,0,0,0,100,0),
(518380,43,-7728.651855,1513.852295,-0.668692,0,0,0,0,100,0),
(518380,44,-7740.848633,1555.398560,1.300065,0,0,0,0,100,0),
(518380,45,-7763.296875,1582.227173,-0.216693,0,0,0,0,100,0),
(518380,46,-7787.744629,1593.927979,2.871248,0,0,0,0,100,0),
(518380,47,-7832.063965,1601.147339,4.115499,0,0,0,0,100,0),
(518380,48,-7870.669434,1592.223389,2.563943,0,0,0,0,100,0),
(518380,49,-7908.875977,1561.901733,-2.734423,0,0,0,0,100,0),
(518380,50,-7932.152832,1528.089844,-0.895027,0,0,0,0,100,0),
(518380,51,-7946.883301,1508.120239,-6.629673,0,0,0,0,100,0);
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Issue 8604: Lapress - pathing
-- Lapress is a rare elite in Silithus that paths around Hive'Regal
-- TBD has two spawns for this type (error) and no path for either
-- ====================================
-- Path for Lapress (guid #43120)
-- ====================================
-- remove duplicate guid #51782
DELETE FROM `creature` WHERE `guid`=51782;
DELETE FROM `creature_addon` WHERE `guid`=51782;
-- set pathing for guid #43120
UPDATE `creature` SET `MovementType`=2,`position_x`=-7803.758789,`position_y`=515.706482,`position_z`=-38.351662 WHERE `guid`=43120;
UPDATE `creature_addon` SET `path_id`=431200 WHERE `guid`=43120;
DELETE FROM `waypoint_data` WHERE `id`=431200;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(431200,1,-7803.758789,515.706482,-38.351662,0,0,0,0,100,0),
(431200,2,-7836.155762,493.625061,-35.266079,0,0,0,0,100,0),
(431200,3,-7853.409180,473.479858,-33.659664,0,0,0,0,100,0),
(431200,4,-7883.189941,436.889862,-32.837315,0,0,0,0,100,0),
(431200,5,-7902.391113,426.345123,-32.146542,0,0,0,0,100,0),
(431200,6,-7935.672852,417.698547,-30.542465,0,0,0,0,100,0),
(431200,7,-7962.825684,424.285736,-31.605789,0,0,0,0,100,0),
(431200,8,-7985.026367,438.749878,-30.173546,0,0,0,0,100,0),
(431200,9,-7990.209961,447.782166,-30.206039,0,0,0,0,100,0),
(431200,10,-7990.671387,458.651367,-30.272879,0,0,0,0,100,0),
(431200,11,-7981.745117,472.982819,-28.886236,0,0,0,0,100,0),
(431200,12,-7978.358398,486.361145,-27.435070,0,0,0,0,100,0),
(431200,13,-7976.823730,500.482758,-29.771008,0,0,0,0,100,0),
(431200,14,-7969.692383,514.711243,-29.564129,0,0,0,0,100,0),
(431200,15,-7956.184570,519.753662,-29.493561,0,0,0,0,100,0),
(431200,16,-7947.121094,518.579346,-28.268650,0,0,0,0,100,0),
(431200,17,-7926.888184,512.964294,-30.582899,0,0,0,0,100,0),
(431200,18,-7906.528809,511.238007,-31.442280,0,0,0,0,100,0),
(431200,19,-7885.870117,513.818298,-32.604053,0,0,0,0,100,0),
(431200,20,-7865.162598,522.834473,-35.134956,0,0,0,0,100,0),
(431200,21,-7835.427246,536.469238,-35.256481,0,0,0,0,100,0),
(431200,22,-7811.894531,531.935547,-37.693974,0,0,0,0,100,0),
(431200,23,-7787.803223,517.669800,-39.175011,0,0,0,0,100,0),
(431200,24,-7758.233887,498.946594,-43.895679,0,0,0,0,100,0),
(431200,25,-7740.895020,487.130463,-44.247120,0,0,0,0,100,0),
(431200,26,-7724.676270,473.797882,-43.348301,0,0,0,0,100,0),
(431200,27,-7711.100098,466.066101,-42.162849,0,0,0,0,100,0),
(431200,28,-7693.685547,462.775269,-41.935429,0,0,0,0,100,0),
(431200,29,-7679.479980,465.434692,-42.725754,0,0,0,0,100,0),
(431200,30,-7671.343750,477.136871,-43.937260,0,0,0,0,100,0),
(431200,31,-7670.163086,492.271149,-43.557579,0,0,0,0,100,0),
(431200,32,-7676.005371,503.306671,-42.504585,0,0,0,0,100,0),
(431200,33,-7687.912598,517.063599,-42.958843,0,0,0,0,100,0),
(431200,34,-7706.184570,525.815552,-43.932297,0,0,0,0,100,0),
(431200,35,-7718.318848,525.054443,-43.541885,0,0,0,0,100,0),
(431200,36,-7751.656738,514.520874,-43.412769,0,0,0,0,100,0),
(431200,37,-7778.547363,507.991516,-41.380962,0,0,0,0,100,0);
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Issue 8605: Ghost Howl - pathing
-- ====================================
-- Ghost Howl path
-- ====================================
UPDATE `creature` SET `MovementType`=2,`position_x`=-758.331299,`position_y`=132.166534,`position_z`=2.778328 WHERE `guid`=51845;
DELETE FROM `creature_addon` WHERE `guid`=51845;
INSERT INTO `creature_addon` (`guid`,`path_id`) VALUES (51845,518450);
DELETE FROM `waypoint_data` WHERE `id`=518450;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(518450,1,-758.331299,132.166534,2.778328,0,0,0,0,100,0),
(518450,2,-779.039490,138.003098,-3.392812,0,0,0,0,100,0),
(518450,3,-801.729553,140.723877,-8.184513,0,0,0,0,100,0),
(518450,4,-817.906494,137.463898,-10.610684,0,0,0,0,100,0),
(518450,5,-830.671692,150.509171,-10.048956,0,0,0,0,100,0),
(518450,6,-824.121399,172.510635,-10.201122,0,0,0,0,100,0),
(518450,7,-824.764526,186.873199,-9.988710,0,0,0,0,100,0),
(518450,8,-831.982727,206.749084,-9.489987,0,0,0,0,100,0),
(518450,9,-844.890625,227.419128,-3.092471,0,0,0,0,100,0),
(518450,10,-857.643433,244.087906,8.022249,0,0,0,0,100,0),
(518450,11,-872.992188,266.185333,19.168064,0,0,0,0,100,0),
(518450,12,-882.134399,276.546539,22.082525,0,0,0,0,100,0),
(518450,13,-889.800964,296.096069,23.395178,0,0,0,0,100,0),
(518450,14,-902.934753,328.538361,23.222651,0,0,0,0,100,0),
(518450,15,-911.667236,347.622101,22.762335,0,0,0,0,100,0),
(518450,16,-920.617126,366.609924,17.728148,0,0,0,0,100,0),
(518450,17,-929.675842,385.545471,15.672112,0,0,0,0,100,0),
(518450,18,-939.391296,404.154327,17.809969,0,0,0,0,100,0),
(518450,19,-952.277527,430.414551,22.445030,0,0,0,0,100,0),
(518450,20,-962.798096,448.574280,27.889492,0,0,0,0,100,0),
(518450,21,-974.157043,466.224060,33.387161,0,0,0,0,100,0),
(518450,22,-986.256165,481.866150,36.911251,0,0,0,0,100,0),
(518450,23,-1009.331055,498.010986,39.317425,0,0,0,0,100,0),
(518450,24,-1028.780029,505.894989,38.973831,0,0,0,0,100,0),
(518450,25,-1050.176880,512.740112,37.666676,0,0,0,0,100,0),
(518450,26,-1067.730103,514.100281,36.464020,0,0,0,0,100,0),
(518450,27,-1088.434937,510.596375,33.673737,0,0,0,0,100,0),
(518450,28,-1109.123535,506.992828,31.172518,0,0,0,0,100,0),
(518450,29,-1136.632324,501.823212,24.153307,0,0,0,0,100,0),
(518450,30,-1156.810181,493.641083,17.238251,0,0,0,0,100,0),
(518450,31,-1171.157104,480.669556,11.453438,0,0,0,0,100,0),
(518450,32,-1185.964233,465.781128,6.865259,0,0,0,0,100,0),
(518450,33,-1207.324707,447.692993,5.389233,0,0,0,0,100,0),
(518450,34,-1218.004517,433.970886,4.800968,0,0,0,0,100,0),
(518450,35,-1233.591797,412.767426,3.494786,0,0,0,0,100,0),
(518450,36,-1231.269775,384.682373,-1.099372,0,0,0,0,100,0),
(518450,37,-1215.842285,369.726135,-1.821958,0,0,0,0,100,0),
(518450,38,-1195.579590,360.878784,4.173124,0,0,0,0,100,0),
(518450,39,-1176.721313,351.738220,10.693844,0,0,0,0,100,0),
(518450,40,-1156.654419,345.599243,15.725755,0,0,0,0,100,0),
(518450,41,-1130.640137,342.170074,22.589449,0,0,0,0,100,0),
(518450,42,-1102.557251,342.299896,31.515118,0,0,0,0,100,0),
(518450,43,-1080.748291,344.271393,37.185501,0,0,0,0,100,0),
(518450,44,-1064.598389,353.161041,35.431694,0,0,0,0,100,0),
(518450,45,-1040.972900,368.182465,32.022644,0,0,0,0,100,0),
(518450,46,-1023.555725,379.914581,27.822573,0,0,0,0,100,0),
(518450,47,-1006.352783,391.955780,24.177290,0,0,0,0,100,0),
(518450,48,-988.705933,402.575775,20.717924,0,0,0,0,100,0),
(518450,49,-969.883667,398.736816,17.409334,0,0,0,0,100,0),
(518450,50,-954.819580,383.869385,18.176464,0,0,0,0,100,0),
(518450,51,-940.532715,364.391052,19.092533,0,0,0,0,100,0),
(518450,52,-930.115662,346.157562,23.026438,0,0,0,0,100,0),
(518450,53,-914.620056,322.843170,27.801060,0,0,0,0,100,0),
(518450,54,-907.517029,307.239838,28.464359,0,0,0,0,100,0),
(518450,55,-899.405396,286.196198,28.664932,0,0,0,0,100,0),
(518450,56,-883.979919,262.894531,23.531834,0,0,0,0,100,0),
(518450,57,-875.788635,248.850708,16.680983,0,0,0,0,100,0),
(518450,58,-872.646851,221.030136,3.035634,0,0,0,0,100,0),
(518450,59,-869.936951,200.205719,-4.584671,0,0,0,0,100,0),
(518450,60,-865.188293,175.768646,-11.755344,0,0,0,0,100,0),
(518450,61,-856.970764,158.444336,-10.823591,0,0,0,0,100,0),
(518450,62,-840.617371,142.700714,-10.213431,0,0,0,0,100,0),
(518450,63,-819.317688,131.755249,-10.598165,0,0,0,0,100,0),
(518450,64,-794.494324,124.537750,-8.377938,0,0,0,0,100,0),
(518450,65,-769.618774,126.572906,-4.253401,0,0,0,0,100,0),
(518450,66,-751.691223,122.151276,0.485237,0,0,0,0,100,0),
(518450,67,-727.576599,116.421646,5.932970,0,0,0,0,100,0),
(518450,68,-701.033875,114.985733,7.786272,0,0,0,0,100,0);
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Issue 8606: Magram Pack Runners & Bonepaws - pathing and formations
-- The 3 Magram Pack Runners are supposed to have paths and 
-- each in a formation with 2 of the 6 Magram Bonepaws
-- ====================================
-- Path for Magram Pack Runner #27113
-- ====================================
UPDATE `creature` SET `MovementType`=2,`position_x`=-1891.590088,`position_y`=980.184692,`position_z`=90.829735 WHERE `guid`=27113;
UPDATE `creature_addon` SET `path_id` = 271130 WHERE `guid`= 27113;
DELETE FROM `waypoint_data` WHERE `id`=271130;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(271130,1,-1891.590088,980.184692,90.829735,0,0,0,0,100,0),
(271130,2,-1891.458496,956.675476,91.027580,0,0,0,0,100,0),
(271130,3,-1891.624878,946.563904,92.976524,0,0,0,0,100,0),
(271130,4,-1898.689453,936.942932,96.155182,0,0,0,0,100,0),
(271130,5,-1896.239990,928.439636,100.486923,0,0,0,0,100,0),
(271130,6,-1895.771118,926.325623,101.644440,0,0,0,0,100,0),
(271130,7,-1898.247803,913.548157,108.486610,0,0,0,0,100,0),
(271130,8,-1903.221069,906.490662,112.850449,0,0,0,0,100,0),
(271130,9,-1900.763306,901.097595,113.787796,0,0,0,0,100,0),
(271130,10,-1895.742065,893.227478,115.708855,0,0,0,0,100,0),
(271130,11,-1893.209839,883.200073,119.829475,0,0,0,0,100,0),
(271130,12,-1888.124268,877.533752,122.451233,0,0,0,0,100,0),
(271130,13,-1881.200928,876.302002,123.132965,0,0,0,0,100,0),
(271130,14,-1874.027710,875.738892,120.035500,0,0,0,0,100,0),
(271130,15,-1863.357178,872.131592,113.412071,0,0,0,0,100,0),
(271130,16,-1853.591919,866.042908,106.688286,0,0,0,0,100,0),
(271130,17,-1848.998535,861.435791,105.390579,0,0,0,0,100,0),
(271130,18,-1838.855347,859.845703,98.179382,0,0,0,0,100,0),
(271130,19,-1832.145508,857.384705,96.830002,0,0,0,0,100,0),
(271130,20,-1824.019287,851.966980,95.998306,0,0,0,0,100,0),
(271130,21,-1820.149292,845.271362,95.867393,0,0,0,0,100,0),
(271130,22,-1820.087524,837.699524,96.678963,0,0,0,0,100,0),
(271130,23,-1820.891357,829.095459,101.625664,0,0,0,0,100,0),
(271130,24,-1822.111328,821.425110,102.975616,0,0,0,0,100,0),
(271130,25,-1813.876953,816.177124,102.989807,0,0,0,0,100,0),
(271130,26,-1796.074097,809.767456,103.040268,0,0,0,0,100,0),
(271130,27,-1775.111328,808.607422,103.003746,0,0,0,0,100,0),
(271130,28,-1745.328003,812.193054,100.710617,0,0,0,0,100,0),
(271130,29,-1731.692627,815.352661,98.948845,0,0,0,0,100,0),
(271130,30,-1704.316528,821.220398,96.105034,0,0,0,0,100,0),
(271130,31,-1684.435303,827.895630,95.722160,0,0,0,0,100,0),
(271130,32,-1658.400269,838.199158,94.617905,0,0,0,0,100,0),
(271130,33,-1639.631348,847.562805,92.239937,0,0,0,0,100,0),
(271130,34,-1625.172974,862.494629,91.397324,0,0,0,0,100,0),
(271130,35,-1622.582153,879.298401,89.652138,0,0,0,0,100,0),
(271130,36,-1621.649536,904.026794,88.916763,0,0,0,0,100,0),
(271130,37,-1607.298218,909.740479,88.886688,0,0,0,0,100,0),
(271130,38,-1618.637207,899.038879,89.218735,0,0,0,0,100,0),
(271130,39,-1621.257446,882.686401,89.581314,0,0,0,0,100,0),
(271130,40,-1625.103271,866.434509,90.726997,0,0,0,0,100,0),
(271130,41,-1642.078247,846.703918,92.289513,0,0,0,0,100,0),
(271130,42,-1657.022583,841.595581,93.342613,0,0,0,0,100,0),
(271130,43,-1676.612915,834.048279,94.937180,0,0,0,0,100,0),
(271130,44,-1696.567139,827.531250,95.551430,0,0,0,0,100,0),
(271130,45,-1716.638916,821.356750,96.912285,0,0,0,0,100,0),
(271130,46,-1743.523560,813.593079,100.411209,0,0,0,0,100,0),
(271130,47,-1762.349976,810.495056,102.357765,0,0,0,0,100,0),
(271130,48,-1783.272583,809.470154,102.856506,0,0,0,0,100,0),
(271130,49,-1801.859985,812.414734,103.297623,0,0,0,0,100,0),
(271130,50,-1822.259888,821.903259,102.958633,0,0,0,0,100,0),
(271130,51,-1819.364502,837.597229,96.466019,0,0,0,0,100,0),
(271130,52,-1820.273804,844.711060,96.063477,0,0,0,0,100,0),
(271130,53,-1826.404053,854.782043,95.999260,0,0,0,0,100,0),
(271130,54,-1836.027832,861.635498,96.368958,0,0,0,0,100,0),
(271130,55,-1848.700195,864.365601,104.286652,0,0,0,0,100,0),
(271130,56,-1870.647461,871.074402,118.388863,0,0,0,0,100,0),
(271130,57,-1880.014038,876.556885,122.919815,0,0,0,0,100,0),
(271130,58,-1885.373779,877.127441,122.962570,0,0,0,0,100,0),
(271130,59,-1893.455322,880.086243,120.755325,0,0,0,0,100,0),
(271130,60,-1896.515259,889.165039,116.963913,0,0,0,0,100,0),
(271130,61,-1897.799316,898.470825,114.102051,0,0,0,0,100,0),
(271130,62,-1900.567505,904.286072,113.080307,0,0,0,0,100,0),
(271130,63,-1903.235352,908.120667,112.314278,0,0,0,0,100,0),
(271130,64,-1900.511353,914.542542,108.583321,0,0,0,0,100,0),
(271130,65,-1894.257202,927.594543,100.719864,0,0,0,0,100,0),
(271130,66,-1896.971069,937.240601,96.210007,0,0,0,0,100,0),
(271130,67,-1892.367676,945.632507,93.317879,0,0,0,0,100,0),
(271130,68,-1886.229248,960.514404,90.799576,0,0,0,0,100,0);
-- ====================================
-- Path for Magram Pack Runner #27114
-- ====================================
UPDATE `creature` SET `MovementType`=2,`position_x`=-1866.258911,`position_y`=1292.665039,`position_z`=90.267395 WHERE `guid`=27114;
UPDATE `creature_addon` SET `path_id`=271140 WHERE `guid`=27114;
DELETE FROM `waypoint_data` WHERE `id`=271140;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(271140,1,-1866.258911,1292.665039,90.267395,0,0,0,0,100,0),
(271140,2,-1886.374634,1289.152222,90.551041,0,0,0,0,100,0),
(271140,3,-1892.611328,1280.994873,91.166740,0,0,0,0,100,0),
(271140,4,-1908.316772,1257.842529,93.266472,0,0,0,0,100,0),
(271140,5,-1917.964233,1246.185059,92.404716,0,0,0,0,100,0),
(271140,6,-1931.856934,1230.453003,91.080635,0,0,0,0,100,0),
(271140,7,-1945.802490,1217.474487,90.822105,0,0,0,0,100,0),
(271140,8,-1953.053955,1205.906982,90.199371,0,0,0,0,100,0),
(271140,9,-1954.759521,1185.012451,90.546669,0,0,0,0,100,0),
(271140,10,-1960.632080,1162.009644,92.740318,0,0,0,0,100,0),
(271140,11,-1968.671509,1142.648438,92.969467,0,0,0,0,100,0),
(271140,12,-1975.597656,1123.311523,98.838661,0,0,0,0,100,0),
(271140,13,-1976.925781,1112.383911,100.757591,0,0,0,0,100,0),
(271140,14,-1978.639648,1091.477661,104.626518,0,0,0,0,100,0),
(271140,15,-1981.014648,1077.680664,108.600563,0,0,0,0,100,0),
(271140,16,-1981.231812,1093.783081,104.649025,0,0,0,0,100,0),
(271140,17,-1980.318115,1114.760254,100.730011,0,0,0,0,100,0),
(271140,18,-1977.647827,1135.578613,98.110054,0,0,0,0,100,0),
(271140,19,-1976.883911,1152.740601,92.612328,0,0,0,0,100,0),
(271140,20,-1972.871948,1168.429443,92.369759,0,0,0,0,100,0),
(271140,21,-1967.373779,1181.294678,91.924042,0,0,0,0,100,0),
(271140,22,-1956.891968,1199.446533,90.469025,0,0,0,0,100,0),
(271140,23,-1944.451538,1216.360474,90.741180,0,0,0,0,100,0),
(271140,24,-1935.247192,1226.884766,90.725029,0,0,0,0,100,0),
(271140,25,-1919.173584,1240.278442,91.884590,0,0,0,0,100,0),
(271140,26,-1910.415283,1250.672729,92.707100,0,0,0,0,100,0),
(271140,27,-1902.390259,1269.222412,93.079758,0,0,0,0,100,0),
(271140,28,-1882.762817,1289.113037,89.803139,0,0,0,0,100,0);
-- ====================================
-- Path for Magram Pack Runner #27115
-- ====================================
UPDATE `creature` SET `MovementType`=2,`position_x`=-1743.915527,`position_y`=1068.425781,`position_z`=91.268845 WHERE `guid`=27115;
UPDATE `creature_addon` SET `path_id`=271150 WHERE `guid`=27115;
DELETE FROM `waypoint_data` WHERE `id`=271150;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`orientation`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES 
(271150,1,-1743.915527,1068.425781,91.268845,0,0,0,0,100,0),
(271150,2,-1736.558838,1082.173950,89.994659,0,0,0,0,100,0),
(271150,3,-1731.699097,1095.289185,90.883049,0,0,0,0,100,0),
(271150,4,-1722.143555,1114.410278,93.485123,0,0,0,0,100,0),
(271150,5,-1709.042358,1125.708862,89.139664,0,0,0,0,100,0),
(271150,6,-1699.357300,1128.252197,89.850990,0,0,0,0,100,0),
(271150,7,-1683.567871,1130.573364,93.404541,0,0,0,0,100,0),
(271150,8,-1667.459351,1123.953369,90.854866,0,0,0,0,100,0),
(271150,9,-1656.821899,1116.278931,90.431404,0,0,0,0,100,0),
(271150,10,-1646.577393,1106.751831,91.073830,0,0,0,0,100,0),
(271150,11,-1631.150879,1093.422852,91.403458,0,0,0,0,100,0),
(271150,12,-1621.821655,1082.984253,88.607735,0,0,0,0,100,0),
(271150,13,-1611.260376,1069.123901,90.329842,0,0,0,0,100,0),
(271150,14,-1604.194092,1057.039795,92.576813,0,0,0,0,100,0),
(271150,15,-1594.728149,1034.252197,88.385590,0,0,0,0,100,0),
(271150,16,-1595.609131,1021.981750,89.746979,0,0,0,0,100,0),
(271150,17,-1604.221924,1005.585327,90.266022,0,0,0,0,100,0),
(271150,18,-1615.037598,992.642090,90.368553,0,0,0,0,100,0),
(271150,19,-1631.977051,980.254822,90.305595,0,0,0,0,100,0),
(271150,20,-1647.029297,972.532104,90.763550,0,0,0,0,100,0),
(271150,21,-1666.543457,964.811646,93.425499,0,0,0,0,100,0),
(271150,22,-1679.549927,959.631775,91.412773,0,0,0,0,100,0),
(271150,23,-1699.294800,952.516907,90.277832,0,0,0,0,100,0),
(271150,24,-1717.125854,948.837036,90.326904,0,0,0,0,100,0),
(271150,25,-1738.984375,950.498413,91.433197,0,0,0,0,100,0),
(271150,26,-1759.411499,958.262085,92.419426,0,0,0,0,100,0),
(271150,27,-1769.315063,968.137329,92.924309,0,0,0,0,100,0),
(271150,28,-1783.742065,983.393127,95.142967,0,0,0,0,100,0),
(271150,29,-1792.408325,994.340515,93.971786,0,0,0,0,100,0),
(271150,30,-1800.310425,1011.053650,92.614510,0,0,0,0,100,0),
(271150,31,-1793.093384,1027.993652,91.870705,0,0,0,0,100,0),
(271150,32,-1772.457642,1046.897461,92.920769,0,0,0,0,100,0);
-- ====================================
-- assign the 6 Magram Bonepaws (guid 27601-27606) into groups with the 3 Magram Pack Runners (guid 27113-27115) 
-- ====================================
DELETE FROM `creature_formations` WHERE `leaderGUID` BETWEEN 27113 AND 27115;
INSERT INTO `creature_formations` (`leaderGUID`,`memberGUID`,`dist`,`angle`,`groupAI`) VALUES
(27113,27113,0,0,2),
(27113,27601,3,20,2),
(27113,27602,3,340,2),
(27114,27114,0,0,2),
(27114,27603,3,20,2),
(27114,27604,3,340,2),
(27115,27115,0,0,2),
(27115,27605,3,20,2),
(27115,27606,3,340,2);
UPDATE creature c1, creature c2, `creature_formations` cf SET c1.position_x = c2.position_x, c1.position_y = c2.position_y, c1.position_z = c2.position_z WHERE c1.guid = cf.memberGUID AND c2.guid = cf.leaderGUID AND c1.guid IN (27601,27602,27603,27604,27605,27606);
-- -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Issue 8608: Caliph Scorpidsting's guard formation
-- Caliph Scorpidstring has two guards assigned (guid 23466 and 23467)
-- but they are defined incorrectly as MovementType=2 with no waypoint data so they just sit at their spawn point and never moved
-- This places them in a formation with Caliph Scorpidsting so that they follow him on his pathing
DELETE FROM `creature_formations` WHERE `leaderGUID`=23286;
INSERT INTO `creature_formations` (`leaderGUID`,`memberGUID`,`dist`,`angle`,`groupAI`) VALUES
(23286,23286,0,0,2),
(23286,23466,4,30,2),
(23286,23467,4,330,2);
