-- --- Northrend ore spawns ---
/*
Borean Tundra  guid 160000 - 160299 pool 10000 - 10149
150 - Cobalt
150 - Secondary
Howling Fjord  guid 160300 - 160599 pool 10150 - 10299
150 - Cobalt
150 - Secondary
Grizzly Hills  guid 160600 - 160799 pool 10300 - 10499
100 - Cobalt
100 - Secondary
Dragonblight   guid 160800 - 161099 pool 10500 - 10649
150 - Cobalt
150 - Secondary
Zul''Drak       guid 161100 - 161399 pool 10650 - 10799
150 - Cobalt
150 - Secondary
Sholazar Basin guid 161400 - 162449 pool 10800 - 11149
350 - Saronite
350 - Secondary
350 - third
Storm Peaks    guid 162450 - 163199 pool 11150 - 11399
250 - Saronite
250 - Secondary
250 - Third
Icecrown       guid 163200 - 164399 pool 11400 - 11799
400 - Saronite
400 - Secondary
400 - Third
*/
-- ----------------------------------------
-- -- Fixup ore spawns for Borean Tundra --
-- ----------------------------------------
SET @RANGE    := 150;
SET @GUID1    := 160000;
SET @GUID2    := @GUID1 + @RANGE;
SET @POOL     := 10000;
SET @LASTGUID := 90; -- Total number of guids - 1 in zone
SET @CHANCE1  := 90; -- This value can be 0 to 100
SET @CHANCE2  := 100 - @CHANCE1;
SET @MOTHER   := 9900;
SET @ACTIVE   := 30; -- Max number of active spawns
SET @TIMER    := 900; -- Respawn timer in seconds
-- Remove Ore spawns from Borean Tundra
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y > 4800 AND `position_x` < 4600;
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y < 4800 AND position_y > 4235 AND `position_x` < 4420;
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y < 4235 AND position_y > 3120 AND `position_x` < 4290;
-- Remove old pools
DELETE FROM `pool_gameobject` WHERE `guid` NOT IN (SELECT `guid` FROM `gameobject`);
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5000 AND 5064;
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5283 AND 5291;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5000 AND 5064;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5283 AND 5291;
-- Colbalt Deposits Borean Tundra
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID1+0,189978,571,1,1,2041.020,5487.780,0.6657,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID1+1,189978,571,1,1,2107.070,5567.050,4.3290,0.61086,0,0,0,1,@TIMER,255,1),
(@GUID1+2,189978,571,1,1,2176.160,6465.650,36.7026,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID1+3,189978,571,1,1,2191.400,6179.220,59.8092,0.55850,0,0,0,1,@TIMER,255,1),
(@GUID1+4,189978,571,1,1,2207.810,5461.620,1.4179,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID1+5,189978,571,1,1,2210.390,6140.070,102.5860,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+6,189978,571,1,1,2268.480,6553.980,44.8410,2.23402,0,0,0,1,@TIMER,255,1),
(@GUID1+7,189978,571,1,1,2420.550,5354.250,1.1916,-2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+8,189978,571,1,1,2440.970,5670.830,55.7080,-1.72787,0,0,0,1,@TIMER,255,1),
(@GUID1+9,189978,571,1,1,2479.390,5862.970,123.9090,-2.67035,0,0,0,1,@TIMER,255,1),
(@GUID1+10,189978,571,1,1,2484.080,5877.070,-24.4687,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+11,189978,571,1,1,2522.500,5118.600,11.1408,-1.18682,0,0,0,1,@TIMER,255,1),
(@GUID1+12,189978,571,1,1,2599.540,5932.400,-15.0285,1.51844,0,0,0,1,@TIMER,255,1),
(@GUID1+13,189978,571,1,1,2650.770,5183.580,8.5151,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID1+14,189978,571,1,1,2748.900,6927.940,-0.4558,0.64577,0,0,0,1,@TIMER,255,1),
(@GUID1+15,189978,571,1,1,2761.550,5608.240,45.2715,-0.80285,0,0,0,1,@TIMER,255,1),
(@GUID1+16,189978,571,1,1,2763.630,5342.760,30.6526,2.84488,0,0,0,1,@TIMER,255,1),
(@GUID1+17,189978,571,1,1,2770.520,5154.430,30.9665,-2.86233,0,0,0,1,@TIMER,255,1),
(@GUID1+18,189978,571,1,1,2790.090,5263.080,20.6015,-1.44862,0,0,0,1,@TIMER,255,1),
(@GUID1+19,189978,571,1,1,2840.900,4952.440,8.9537,2.65289,0,0,0,1,@TIMER,255,1),
(@GUID1+20,189978,571,1,1,2874.190,5228.350,8.6320,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID1+21,189978,571,1,1,2930.960,5704.170,48.5007,0.61086,0,0,0,1,@TIMER,255,1),
(@GUID1+22,189978,571,1,1,3027.790,4980.890,12.1247,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID1+23,189978,571,1,1,3034.250,4541.600,9.2876,-0.68068,0,0,0,1,@TIMER,255,1),
(@GUID1+24,189978,571,1,1,3099.810,4421.810,27.8759,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID1+25,189978,571,1,1,3112.390,4653.800,7.5872,-1.98967,0,0,0,1,@TIMER,255,1),
(@GUID1+26,189978,571,1,1,3121.680,3765.480,9.0758,-2.80997,0,0,0,1,@TIMER,255,1),
(@GUID1+27,189978,571,1,1,3137.750,3442.070,3.3502,0.40143,0,0,0,1,@TIMER,255,1),
(@GUID1+28,189978,571,1,1,3138.650,5762.380,56.1208,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID1+29,189978,571,1,1,3139.470,3676.510,4.5353,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID1+30,189978,571,1,1,3151.480,5622.400,31.6321,-0.57596,0,0,0,1,@TIMER,255,1),
(@GUID1+31,189978,571,1,1,3166.540,4828.210,8.4315,2.47837,0,0,0,1,@TIMER,255,1),
(@GUID1+32,189978,571,1,1,3178.550,4306.800,27.7940,-0.40143,0,0,0,1,@TIMER,255,1),
(@GUID1+33,189978,571,1,1,3185.580,3546.170,7.6564,2.39110,0,0,0,1,@TIMER,255,1),
(@GUID1+34,189978,571,1,1,3198.810,4009.430,26.2162,1.11701,0,0,0,1,@TIMER,255,1),
(@GUID1+35,189978,571,1,1,3236.340,5552.180,37.9475,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+36,189978,571,1,1,3258.650,6215.420,66.4526,2.05949,0,0,0,1,@TIMER,255,1),
(@GUID1+37,189978,571,1,1,3286.000,3285.200,26.0825,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+38,189978,571,1,1,3312.170,4442.610,16.2630,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID1+39,189978,571,1,1,3339.990,6077.690,70.5354,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID1+40,189978,571,1,1,3373.570,5698.460,59.7515,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID1+41,189978,571,1,1,3425.060,6250.550,59.3819,-1.02974,0,0,0,1,@TIMER,255,1),
(@GUID1+42,189978,571,1,1,3432.170,3205.750,28.7276,0.19199,0,0,0,1,@TIMER,255,1),
(@GUID1+43,189978,571,1,1,3442.730,4790.610,28.0548,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+44,189978,571,1,1,3456.690,4495.230,-14.5277,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID1+45,189978,571,1,1,3471.360,3949.050,28.4666,1.36136,0,0,0,1,@TIMER,255,1),
(@GUID1+46,189978,571,1,1,3500.650,5648.270,61.2663,-1.30900,0,0,0,1,@TIMER,255,1),
(@GUID1+47,189978,571,1,1,3546.060,5485.130,28.2165,-1.20428,0,0,0,1,@TIMER,255,1),
(@GUID1+48,189978,571,1,1,3575.170,5582.850,36.2144,1.36136,0,0,0,1,@TIMER,255,1),
(@GUID1+49,189978,571,1,1,3589.770,4352.250,-0.0799,0.69813,0,0,0,1,@TIMER,255,1),
(@GUID1+50,189978,571,1,1,3597.660,7076.430,207.8640,-0.80285,0,0,0,1,@TIMER,255,1),
(@GUID1+51,189978,571,1,1,3602.530,3264.460,29.1279,3.01941,0,0,0,1,@TIMER,255,1),
(@GUID1+52,189978,571,1,1,3629.540,3121.820,52.9232,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID1+53,189978,571,1,1,3637.100,4875.020,-4.4644,1.23918,0,0,0,1,@TIMER,255,1),
(@GUID1+54,189978,571,1,1,3641.540,7262.290,224.0600,0.33161,0,0,0,1,@TIMER,255,1),
(@GUID1+55,189978,571,1,1,3647.920,4760.270,-21.7579,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID1+56,189978,571,1,1,3673.780,5719.620,65.1652,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+57,189978,571,1,1,3679.230,4027.050,25.4779,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+58,189978,571,1,1,3735.660,7364.340,221.5280,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID1+59,189978,571,1,1,3773.740,4124.640,26.3959,2.19912,0,0,0,1,@TIMER,255,1),
(@GUID1+60,189978,571,1,1,3791.720,6400.170,201.6110,-0.68068,0,0,0,1,@TIMER,255,1),
(@GUID1+61,189978,571,1,1,3799.720,6641.220,152.9170,3.00195,0,0,0,1,@TIMER,255,1),
(@GUID1+62,189978,571,1,1,3806.030,4624.150,-4.2562,2.67035,0,0,0,1,@TIMER,255,1),
(@GUID1+63,189978,571,1,1,3815.140,4009.440,27.9435,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID1+64,189978,571,1,1,3835.130,4339.370,13.9343,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+65,189978,571,1,1,3903.800,6724.670,152.8680,-0.82030,0,0,0,1,@TIMER,255,1),
(@GUID1+66,189978,571,1,1,3917.590,6440.270,12.2326,-2.16421,0,0,0,1,@TIMER,255,1),
(@GUID1+67,189978,571,1,1,3966.950,4626.570,3.9666,1.48353,0,0,0,1,@TIMER,255,1),
(@GUID1+68,189978,571,1,1,3983.410,5187.210,14.7211,-0.50615,0,0,0,1,@TIMER,255,1),
(@GUID1+69,189978,571,1,1,4027.440,5977.490,-126.0680,-1.27409,0,0,0,1,@TIMER,255,1),
(@GUID1+70,189978,571,1,1,4032.270,4116.910,68.5057,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+71,189978,571,1,1,4069.310,7227.390,193.9630,-0.17453,0,0,0,1,@TIMER,255,1),
(@GUID1+72,189978,571,1,1,4070.480,6434.010,18.6334,-2.39110,0,0,0,1,@TIMER,255,1),
(@GUID1+73,189978,571,1,1,4145.380,6067.060,-125.9360,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID1+74,189978,571,1,1,4171.720,5077.170,16.6149,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID1+75,189978,571,1,1,4208.170,6800.440,237.2870,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID1+76,189978,571,1,1,4230.770,4443.920,31.1130,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID1+77,189978,571,1,1,4250.450,5738.320,63.6832,3.01941,0,0,0,1,@TIMER,255,1),
(@GUID1+78,189978,571,1,1,4284.010,6139.800,-124.8270,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID1+79,189978,571,1,1,4290.250,4914.950,24.5063,-0.45379,0,0,0,1,@TIMER,255,1),
(@GUID1+80,189978,571,1,1,4365.940,6207.040,-125.8980,1.06465,0,0,0,1,@TIMER,255,1),
(@GUID1+81,189978,571,1,1,4367.850,4251.450,97.6535,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID1+82,189978,571,1,1,4368.080,5342.280,5.1373,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID1+83,189978,571,1,1,4420.920,5968.570,58.9111,-1.78023,0,0,0,1,@TIMER,255,1),
(@GUID1+84,189978,571,1,1,4428.090,4947.540,22.4015,-0.57596,0,0,0,1,@TIMER,255,1),
(@GUID1+85,189978,571,1,1,4474.030,5326.940,81.2181,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+86,189978,571,1,1,4489.790,5061.610,53.6446,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+87,189978,571,1,1,4495.700,5196.980,77.0767,-2.49582,0,0,0,1,@TIMER,255,1),
(@GUID1+88,189978,571,1,1,4510.570,5420.060,28.6437,0.87266,0,0,0,1,@TIMER,255,1),
(@GUID1+89,189978,571,1,1,4527.510,5433.780,-17.0905,0.45379,0,0,0,1,@TIMER,255,1),
(@GUID1+90,189978,571,1,1,4541.420,5349.580,-31.6367,1.36136,0,0,0,1,@TIMER,255,1);
-- Rich Colbalt Deposits Borean Tundra
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID2+0,189979,571,1,1,2041.020,5487.780,0.6657,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID2+1,189979,571,1,1,2107.070,5567.050,4.3290,0.61086,0,0,0,1,@TIMER,255,1),
(@GUID2+2,189979,571,1,1,2176.160,6465.650,36.7026,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID2+3,189979,571,1,1,2191.400,6179.220,59.8092,0.55850,0,0,0,1,@TIMER,255,1),
(@GUID2+4,189979,571,1,1,2207.810,5461.620,1.4179,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID2+5,189979,571,1,1,2210.390,6140.070,102.5860,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+6,189979,571,1,1,2268.480,6553.980,44.8410,2.23402,0,0,0,1,@TIMER,255,1),
(@GUID2+7,189979,571,1,1,2420.550,5354.250,1.1916,-2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+8,189979,571,1,1,2440.970,5670.830,55.7080,-1.72787,0,0,0,1,@TIMER,255,1),
(@GUID2+9,189979,571,1,1,2479.390,5862.970,123.9090,-2.67035,0,0,0,1,@TIMER,255,1),
(@GUID2+10,189979,571,1,1,2484.080,5877.070,-24.4687,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+11,189979,571,1,1,2522.500,5118.600,11.1408,-1.18682,0,0,0,1,@TIMER,255,1),
(@GUID2+12,189979,571,1,1,2599.540,5932.400,-15.0285,1.51844,0,0,0,1,@TIMER,255,1),
(@GUID2+13,189979,571,1,1,2650.770,5183.580,8.5151,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID2+14,189979,571,1,1,2748.900,6927.940,-0.4558,0.64577,0,0,0,1,@TIMER,255,1),
(@GUID2+15,189979,571,1,1,2761.550,5608.240,45.2715,-0.80285,0,0,0,1,@TIMER,255,1),
(@GUID2+16,189979,571,1,1,2763.630,5342.760,30.6526,2.84488,0,0,0,1,@TIMER,255,1),
(@GUID2+17,189979,571,1,1,2770.520,5154.430,30.9665,-2.86233,0,0,0,1,@TIMER,255,1),
(@GUID2+18,189979,571,1,1,2790.090,5263.080,20.6015,-1.44862,0,0,0,1,@TIMER,255,1),
(@GUID2+19,189979,571,1,1,2840.900,4952.440,8.9537,2.65289,0,0,0,1,@TIMER,255,1),
(@GUID2+20,189979,571,1,1,2874.190,5228.350,8.6320,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID2+21,189979,571,1,1,2930.960,5704.170,48.5007,0.61086,0,0,0,1,@TIMER,255,1),
(@GUID2+22,189979,571,1,1,3027.790,4980.890,12.1247,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID2+23,189979,571,1,1,3034.250,4541.600,9.2876,-0.68068,0,0,0,1,@TIMER,255,1),
(@GUID2+24,189979,571,1,1,3099.810,4421.810,27.8759,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID2+25,189979,571,1,1,3112.390,4653.800,7.5872,-1.98967,0,0,0,1,@TIMER,255,1),
(@GUID2+26,189979,571,1,1,3121.680,3765.480,9.0758,-2.80997,0,0,0,1,@TIMER,255,1),
(@GUID2+27,189979,571,1,1,3137.750,3442.070,3.3502,0.40143,0,0,0,1,@TIMER,255,1),
(@GUID2+28,189979,571,1,1,3138.650,5762.380,56.1208,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID2+29,189979,571,1,1,3139.470,3676.510,4.5353,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID2+30,189979,571,1,1,3151.480,5622.400,31.6321,-0.57596,0,0,0,1,@TIMER,255,1),
(@GUID2+31,189979,571,1,1,3166.540,4828.210,8.4315,2.47837,0,0,0,1,@TIMER,255,1),
(@GUID2+32,189979,571,1,1,3178.550,4306.800,27.7940,-0.40143,0,0,0,1,@TIMER,255,1),
(@GUID2+33,189979,571,1,1,3185.580,3546.170,7.6564,2.39110,0,0,0,1,@TIMER,255,1),
(@GUID2+34,189979,571,1,1,3198.810,4009.430,26.2162,1.11701,0,0,0,1,@TIMER,255,1),
(@GUID2+35,189979,571,1,1,3236.340,5552.180,37.9475,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+36,189979,571,1,1,3258.650,6215.420,66.4526,2.05949,0,0,0,1,@TIMER,255,1),
(@GUID2+37,189979,571,1,1,3286.000,3285.200,26.0825,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+38,189979,571,1,1,3312.170,4442.610,16.2630,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID2+39,189979,571,1,1,3339.990,6077.690,70.5354,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID2+40,189979,571,1,1,3373.570,5698.460,59.7515,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID2+41,189979,571,1,1,3425.060,6250.550,59.3819,-1.02974,0,0,0,1,@TIMER,255,1),
(@GUID2+42,189979,571,1,1,3432.170,3205.750,28.7276,0.19199,0,0,0,1,@TIMER,255,1),
(@GUID2+43,189979,571,1,1,3442.730,4790.610,28.0548,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+44,189979,571,1,1,3456.690,4495.230,-14.5277,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID2+45,189979,571,1,1,3471.360,3949.050,28.4666,1.36136,0,0,0,1,@TIMER,255,1),
(@GUID2+46,189979,571,1,1,3500.650,5648.270,61.2663,-1.30900,0,0,0,1,@TIMER,255,1),
(@GUID2+47,189979,571,1,1,3546.060,5485.130,28.2165,-1.20428,0,0,0,1,@TIMER,255,1),
(@GUID2+48,189979,571,1,1,3575.170,5582.850,36.2144,1.36136,0,0,0,1,@TIMER,255,1),
(@GUID2+49,189979,571,1,1,3589.770,4352.250,-0.0799,0.69813,0,0,0,1,@TIMER,255,1),
(@GUID2+50,189979,571,1,1,3597.660,7076.430,207.8640,-0.80285,0,0,0,1,@TIMER,255,1),
(@GUID2+51,189979,571,1,1,3602.530,3264.460,29.1279,3.01941,0,0,0,1,@TIMER,255,1),
(@GUID2+52,189979,571,1,1,3629.540,3121.820,52.9232,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID2+53,189979,571,1,1,3637.100,4875.020,-4.4644,1.23918,0,0,0,1,@TIMER,255,1),
(@GUID2+54,189979,571,1,1,3641.540,7262.290,224.0600,0.33161,0,0,0,1,@TIMER,255,1),
(@GUID2+55,189979,571,1,1,3647.920,4760.270,-21.7579,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID2+56,189979,571,1,1,3673.780,5719.620,65.1652,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+57,189979,571,1,1,3679.230,4027.050,25.4779,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+58,189979,571,1,1,3735.660,7364.340,221.5280,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID2+59,189979,571,1,1,3773.740,4124.640,26.3959,2.19912,0,0,0,1,@TIMER,255,1),
(@GUID2+60,189979,571,1,1,3791.720,6400.170,201.6110,-0.68068,0,0,0,1,@TIMER,255,1),
(@GUID2+61,189979,571,1,1,3799.720,6641.220,152.9170,3.00195,0,0,0,1,@TIMER,255,1),
(@GUID2+62,189979,571,1,1,3806.030,4624.150,-4.2562,2.67035,0,0,0,1,@TIMER,255,1),
(@GUID2+63,189979,571,1,1,3815.140,4009.440,27.9435,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID2+64,189979,571,1,1,3835.130,4339.370,13.9343,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+65,189979,571,1,1,3903.800,6724.670,152.8680,-0.82030,0,0,0,1,@TIMER,255,1),
(@GUID2+66,189979,571,1,1,3917.590,6440.270,12.2326,-2.16421,0,0,0,1,@TIMER,255,1),
(@GUID2+67,189979,571,1,1,3966.950,4626.570,3.9666,1.48353,0,0,0,1,@TIMER,255,1),
(@GUID2+68,189979,571,1,1,3983.410,5187.210,14.7211,-0.50615,0,0,0,1,@TIMER,255,1),
(@GUID2+69,189979,571,1,1,4027.440,5977.490,-126.0680,-1.27409,0,0,0,1,@TIMER,255,1),
(@GUID2+70,189979,571,1,1,4032.270,4116.910,68.5057,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+71,189979,571,1,1,4069.310,7227.390,193.9630,-0.17453,0,0,0,1,@TIMER,255,1),
(@GUID2+72,189979,571,1,1,4070.480,6434.010,18.6334,-2.39110,0,0,0,1,@TIMER,255,1),
(@GUID2+73,189979,571,1,1,4145.380,6067.060,-125.9360,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID2+74,189979,571,1,1,4171.720,5077.170,16.6149,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID2+75,189979,571,1,1,4208.170,6800.440,237.2870,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID2+76,189979,571,1,1,4230.770,4443.920,31.1130,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID2+77,189979,571,1,1,4250.450,5738.320,63.6832,3.01941,0,0,0,1,@TIMER,255,1),
(@GUID2+78,189979,571,1,1,4284.010,6139.800,-124.8270,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID2+79,189979,571,1,1,4290.250,4914.950,24.5063,-0.45379,0,0,0,1,@TIMER,255,1),
(@GUID2+80,189979,571,1,1,4365.940,6207.040,-125.8980,1.06465,0,0,0,1,@TIMER,255,1),
(@GUID2+81,189979,571,1,1,4367.850,4251.450,97.6535,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID2+82,189979,571,1,1,4368.080,5342.280,5.1373,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID2+83,189979,571,1,1,4420.920,5968.570,58.9111,-1.78023,0,0,0,1,@TIMER,255,1),
(@GUID2+84,189979,571,1,1,4428.090,4947.540,22.4015,-0.57596,0,0,0,1,@TIMER,255,1),
(@GUID2+85,189979,571,1,1,4474.030,5326.940,81.2181,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+86,189979,571,1,1,4489.790,5061.610,53.6446,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+87,189979,571,1,1,4495.700,5196.980,77.0767,-2.49582,0,0,0,1,@TIMER,255,1),
(@GUID2+88,189979,571,1,1,4510.570,5420.060,28.6437,0.87266,0,0,0,1,@TIMER,255,1),
(@GUID2+89,189979,571,1,1,4527.510,5433.780,-17.0905,0.45379,0,0,0,1,@TIMER,255,1),
(@GUID2+90,189979,571,1,1,4541.420,5349.580,-31.6367,1.36136,0,0,0,1,@TIMER,255,1);
-- Pooling
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID1 AND @GUID1+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID2 AND @GUID2+@LASTGUID;
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+0,@POOL+0,@CHANCE1, 'Borean Tundra Ore Spawnpoint 1 Cobalt'),
(@GUID2+0,@POOL+0,@CHANCE2, 'Borean Tundra Ore Spawnpoint 1 Rich Cobalt'),
(@GUID1+1,@POOL+1,@CHANCE1, 'Borean Tundra Ore Spawnpoint 2 Cobalt'),
(@GUID2+1,@POOL+1,@CHANCE2, 'Borean Tundra Ore Spawnpoint 2 Rich Cobalt'),
(@GUID1+2,@POOL+2,@CHANCE1, 'Borean Tundra Ore Spawnpoint 3 Cobalt'),
(@GUID2+2,@POOL+2,@CHANCE2, 'Borean Tundra Ore Spawnpoint 3 Rich Cobalt'),
(@GUID1+3,@POOL+3,@CHANCE1, 'Borean Tundra Ore Spawnpoint 4 Cobalt'),
(@GUID2+3,@POOL+3,@CHANCE2, 'Borean Tundra Ore Spawnpoint 4 Rich Cobalt'),
(@GUID1+4,@POOL+4,@CHANCE1, 'Borean Tundra Ore Spawnpoint 5 Cobalt'),
(@GUID2+4,@POOL+4,@CHANCE2, 'Borean Tundra Ore Spawnpoint 5 Rich Cobalt'),
(@GUID1+5,@POOL+5,@CHANCE1, 'Borean Tundra Ore Spawnpoint 6 Cobalt'),
(@GUID2+5,@POOL+5,@CHANCE2, 'Borean Tundra Ore Spawnpoint 6 Rich Cobalt'),
(@GUID1+6,@POOL+6,@CHANCE1, 'Borean Tundra Ore Spawnpoint 7 Cobalt'),
(@GUID2+6,@POOL+6,@CHANCE2, 'Borean Tundra Ore Spawnpoint 7 Rich Cobalt'),
(@GUID1+7,@POOL+7,@CHANCE1, 'Borean Tundra Ore Spawnpoint 8 Cobalt'),
(@GUID2+7,@POOL+7,@CHANCE2, 'Borean Tundra Ore Spawnpoint 8 Rich Cobalt'),
(@GUID1+8,@POOL+8,@CHANCE1, 'Borean Tundra Ore Spawnpoint 9 Cobalt'),
(@GUID2+8,@POOL+8,@CHANCE2, 'Borean Tundra Ore Spawnpoint 9 Rich Cobalt'),
(@GUID1+9,@POOL+9,@CHANCE1, 'Borean Tundra Ore Spawnpoint 10 Cobalt'),
(@GUID2+9,@POOL+9,@CHANCE2, 'Borean Tundra Ore Spawnpoint 10 Rich Cobalt'),
(@GUID1+10,@POOL+10,@CHANCE1, 'Borean Tundra Ore Spawnpoint 11 Cobalt'),
(@GUID2+10,@POOL+10,@CHANCE2, 'Borean Tundra Ore Spawnpoint 11 Rich Cobalt'),
(@GUID1+11,@POOL+11,@CHANCE1, 'Borean Tundra Ore Spawnpoint 12 Cobalt'),
(@GUID2+11,@POOL+11,@CHANCE2, 'Borean Tundra Ore Spawnpoint 12 Rich Cobalt'),
(@GUID1+12,@POOL+12,@CHANCE1, 'Borean Tundra Ore Spawnpoint 13 Cobalt'),
(@GUID2+12,@POOL+12,@CHANCE2, 'Borean Tundra Ore Spawnpoint 13 Rich Cobalt'),
(@GUID1+13,@POOL+13,@CHANCE1, 'Borean Tundra Ore Spawnpoint 14 Cobalt'),
(@GUID2+13,@POOL+13,@CHANCE2, 'Borean Tundra Ore Spawnpoint 14 Rich Cobalt'),
(@GUID1+14,@POOL+14,@CHANCE1, 'Borean Tundra Ore Spawnpoint 15 Cobalt'),
(@GUID2+14,@POOL+14,@CHANCE2, 'Borean Tundra Ore Spawnpoint 15 Rich Cobalt'),
(@GUID1+15,@POOL+15,@CHANCE1, 'Borean Tundra Ore Spawnpoint 16 Cobalt'),
(@GUID2+15,@POOL+15,@CHANCE2, 'Borean Tundra Ore Spawnpoint 16 Rich Cobalt'),
(@GUID1+16,@POOL+16,@CHANCE1, 'Borean Tundra Ore Spawnpoint 17 Cobalt'),
(@GUID2+16,@POOL+16,@CHANCE2, 'Borean Tundra Ore Spawnpoint 17 Rich Cobalt'),
(@GUID1+17,@POOL+17,@CHANCE1, 'Borean Tundra Ore Spawnpoint 18 Cobalt'),
(@GUID2+17,@POOL+17,@CHANCE2, 'Borean Tundra Ore Spawnpoint 18 Rich Cobalt'),
(@GUID1+18,@POOL+18,@CHANCE1, 'Borean Tundra Ore Spawnpoint 19 Cobalt'),
(@GUID2+18,@POOL+18,@CHANCE2, 'Borean Tundra Ore Spawnpoint 19 Rich Cobalt'),
(@GUID1+19,@POOL+19,@CHANCE1, 'Borean Tundra Ore Spawnpoint 20 Cobalt'),
(@GUID2+19,@POOL+19,@CHANCE2, 'Borean Tundra Ore Spawnpoint 20 Rich Cobalt'),
(@GUID1+20,@POOL+20,@CHANCE1, 'Borean Tundra Ore Spawnpoint 21 Cobalt'),
(@GUID2+20,@POOL+20,@CHANCE2, 'Borean Tundra Ore Spawnpoint 21 Rich Cobalt'),
(@GUID1+21,@POOL+21,@CHANCE1, 'Borean Tundra Ore Spawnpoint 22 Cobalt'),
(@GUID2+21,@POOL+21,@CHANCE2, 'Borean Tundra Ore Spawnpoint 22 Rich Cobalt'),
(@GUID1+22,@POOL+22,@CHANCE1, 'Borean Tundra Ore Spawnpoint 23 Cobalt'),
(@GUID2+22,@POOL+22,@CHANCE2, 'Borean Tundra Ore Spawnpoint 23 Rich Cobalt'),
(@GUID1+23,@POOL+23,@CHANCE1, 'Borean Tundra Ore Spawnpoint 24 Cobalt'),
(@GUID2+23,@POOL+23,@CHANCE2, 'Borean Tundra Ore Spawnpoint 24 Rich Cobalt'),
(@GUID1+24,@POOL+24,@CHANCE1, 'Borean Tundra Ore Spawnpoint 25 Cobalt'),
(@GUID2+24,@POOL+24,@CHANCE2, 'Borean Tundra Ore Spawnpoint 25 Rich Cobalt'),
(@GUID1+25,@POOL+25,@CHANCE1, 'Borean Tundra Ore Spawnpoint 26 Cobalt'),
(@GUID2+25,@POOL+25,@CHANCE2, 'Borean Tundra Ore Spawnpoint 26 Rich Cobalt'),
(@GUID1+26,@POOL+26,@CHANCE1, 'Borean Tundra Ore Spawnpoint 27 Cobalt'),
(@GUID2+26,@POOL+26,@CHANCE2, 'Borean Tundra Ore Spawnpoint 27 Rich Cobalt'),
(@GUID1+27,@POOL+27,@CHANCE1, 'Borean Tundra Ore Spawnpoint 28 Cobalt'),
(@GUID2+27,@POOL+27,@CHANCE2, 'Borean Tundra Ore Spawnpoint 28 Rich Cobalt'),
(@GUID1+28,@POOL+28,@CHANCE1, 'Borean Tundra Ore Spawnpoint 29 Cobalt'),
(@GUID2+28,@POOL+28,@CHANCE2, 'Borean Tundra Ore Spawnpoint 29 Rich Cobalt'),
(@GUID1+29,@POOL+29,@CHANCE1, 'Borean Tundra Ore Spawnpoint 30 Cobalt'),
(@GUID2+29,@POOL+29,@CHANCE2, 'Borean Tundra Ore Spawnpoint 30 Rich Cobalt'),
(@GUID1+30,@POOL+30,@CHANCE1, 'Borean Tundra Ore Spawnpoint 31 Cobalt'),
(@GUID2+30,@POOL+30,@CHANCE2, 'Borean Tundra Ore Spawnpoint 31 Rich Cobalt'),
(@GUID1+31,@POOL+31,@CHANCE1, 'Borean Tundra Ore Spawnpoint 32 Cobalt'),
(@GUID2+31,@POOL+31,@CHANCE2, 'Borean Tundra Ore Spawnpoint 32 Rich Cobalt'),
(@GUID1+32,@POOL+32,@CHANCE1, 'Borean Tundra Ore Spawnpoint 33 Cobalt'),
(@GUID2+32,@POOL+32,@CHANCE2, 'Borean Tundra Ore Spawnpoint 33 Rich Cobalt'),
(@GUID1+33,@POOL+33,@CHANCE1, 'Borean Tundra Ore Spawnpoint 34 Cobalt'),
(@GUID2+33,@POOL+33,@CHANCE2, 'Borean Tundra Ore Spawnpoint 34 Rich Cobalt'),
(@GUID1+34,@POOL+34,@CHANCE1, 'Borean Tundra Ore Spawnpoint 35 Cobalt'),
(@GUID2+34,@POOL+34,@CHANCE2, 'Borean Tundra Ore Spawnpoint 35 Rich Cobalt'),
(@GUID1+35,@POOL+35,@CHANCE1, 'Borean Tundra Ore Spawnpoint 36 Cobalt'),
(@GUID2+35,@POOL+35,@CHANCE2, 'Borean Tundra Ore Spawnpoint 36 Rich Cobalt'),
(@GUID1+36,@POOL+36,@CHANCE1, 'Borean Tundra Ore Spawnpoint 37 Cobalt'),
(@GUID2+36,@POOL+36,@CHANCE2, 'Borean Tundra Ore Spawnpoint 37 Rich Cobalt'),
(@GUID1+37,@POOL+37,@CHANCE1, 'Borean Tundra Ore Spawnpoint 38 Cobalt'),
(@GUID2+37,@POOL+37,@CHANCE2, 'Borean Tundra Ore Spawnpoint 38 Rich Cobalt'),
(@GUID1+38,@POOL+38,@CHANCE1, 'Borean Tundra Ore Spawnpoint 39 Cobalt'),
(@GUID2+38,@POOL+38,@CHANCE2, 'Borean Tundra Ore Spawnpoint 39 Rich Cobalt'),
(@GUID1+39,@POOL+39,@CHANCE1, 'Borean Tundra Ore Spawnpoint 40 Cobalt'),
(@GUID2+39,@POOL+39,@CHANCE2, 'Borean Tundra Ore Spawnpoint 40 Rich Cobalt'),
(@GUID1+40,@POOL+40,@CHANCE1, 'Borean Tundra Ore Spawnpoint 41 Cobalt'),
(@GUID2+40,@POOL+40,@CHANCE2, 'Borean Tundra Ore Spawnpoint 41 Rich Cobalt'),
(@GUID1+41,@POOL+41,@CHANCE1, 'Borean Tundra Ore Spawnpoint 42 Cobalt'),
(@GUID2+41,@POOL+41,@CHANCE2, 'Borean Tundra Ore Spawnpoint 42 Rich Cobalt'),
(@GUID1+42,@POOL+42,@CHANCE1, 'Borean Tundra Ore Spawnpoint 43 Cobalt'),
(@GUID2+42,@POOL+42,@CHANCE2, 'Borean Tundra Ore Spawnpoint 43 Rich Cobalt'),
(@GUID1+43,@POOL+43,@CHANCE1, 'Borean Tundra Ore Spawnpoint 44 Cobalt'),
(@GUID2+43,@POOL+43,@CHANCE2, 'Borean Tundra Ore Spawnpoint 44 Rich Cobalt'),
(@GUID1+44,@POOL+44,@CHANCE1, 'Borean Tundra Ore Spawnpoint 45 Cobalt'),
(@GUID2+44,@POOL+44,@CHANCE2, 'Borean Tundra Ore Spawnpoint 45 Rich Cobalt'),
(@GUID1+45,@POOL+45,@CHANCE1, 'Borean Tundra Ore Spawnpoint 46 Cobalt'),
(@GUID2+45,@POOL+45,@CHANCE2, 'Borean Tundra Ore Spawnpoint 46 Rich Cobalt'),
(@GUID1+46,@POOL+46,@CHANCE1, 'Borean Tundra Ore Spawnpoint 47 Cobalt'),
(@GUID2+46,@POOL+46,@CHANCE2, 'Borean Tundra Ore Spawnpoint 47 Rich Cobalt'),
(@GUID1+47,@POOL+47,@CHANCE1, 'Borean Tundra Ore Spawnpoint 48 Cobalt'),
(@GUID2+47,@POOL+47,@CHANCE2, 'Borean Tundra Ore Spawnpoint 48 Rich Cobalt'),
(@GUID1+48,@POOL+48,@CHANCE1, 'Borean Tundra Ore Spawnpoint 49 Cobalt'),
(@GUID2+48,@POOL+48,@CHANCE2, 'Borean Tundra Ore Spawnpoint 49 Rich Cobalt'),
(@GUID1+49,@POOL+49,@CHANCE1, 'Borean Tundra Ore Spawnpoint 50 Cobalt'),
(@GUID2+49,@POOL+49,@CHANCE2, 'Borean Tundra Ore Spawnpoint 50 Rich Cobalt'),
(@GUID1+50,@POOL+50,@CHANCE1, 'Borean Tundra Ore Spawnpoint 51 Cobalt'),
(@GUID2+50,@POOL+50,@CHANCE2, 'Borean Tundra Ore Spawnpoint 51 Rich Cobalt'),
(@GUID1+51,@POOL+51,@CHANCE1, 'Borean Tundra Ore Spawnpoint 52 Cobalt'),
(@GUID2+51,@POOL+51,@CHANCE2, 'Borean Tundra Ore Spawnpoint 52 Rich Cobalt'),
(@GUID1+52,@POOL+52,@CHANCE1, 'Borean Tundra Ore Spawnpoint 53 Cobalt'),
(@GUID2+52,@POOL+52,@CHANCE2, 'Borean Tundra Ore Spawnpoint 53 Rich Cobalt'),
(@GUID1+53,@POOL+53,@CHANCE1, 'Borean Tundra Ore Spawnpoint 54 Cobalt'),
(@GUID2+53,@POOL+53,@CHANCE2, 'Borean Tundra Ore Spawnpoint 54 Rich Cobalt'),
(@GUID1+54,@POOL+54,@CHANCE1, 'Borean Tundra Ore Spawnpoint 55 Cobalt'),
(@GUID2+54,@POOL+54,@CHANCE2, 'Borean Tundra Ore Spawnpoint 55 Rich Cobalt'),
(@GUID1+55,@POOL+55,@CHANCE1, 'Borean Tundra Ore Spawnpoint 56 Cobalt'),
(@GUID2+55,@POOL+55,@CHANCE2, 'Borean Tundra Ore Spawnpoint 56 Rich Cobalt'),
(@GUID1+56,@POOL+56,@CHANCE1, 'Borean Tundra Ore Spawnpoint 57 Cobalt'),
(@GUID2+56,@POOL+56,@CHANCE2, 'Borean Tundra Ore Spawnpoint 57 Rich Cobalt'),
(@GUID1+57,@POOL+57,@CHANCE1, 'Borean Tundra Ore Spawnpoint 58 Cobalt'),
(@GUID2+57,@POOL+57,@CHANCE2, 'Borean Tundra Ore Spawnpoint 58 Rich Cobalt'),
(@GUID1+58,@POOL+58,@CHANCE1, 'Borean Tundra Ore Spawnpoint 59 Cobalt'),
(@GUID2+58,@POOL+58,@CHANCE2, 'Borean Tundra Ore Spawnpoint 59 Rich Cobalt'),
(@GUID1+59,@POOL+59,@CHANCE1, 'Borean Tundra Ore Spawnpoint 60 Cobalt'),
(@GUID2+59,@POOL+59,@CHANCE2, 'Borean Tundra Ore Spawnpoint 60 Rich Cobalt'),
(@GUID1+60,@POOL+60,@CHANCE1, 'Borean Tundra Ore Spawnpoint 61 Cobalt'),
(@GUID2+60,@POOL+60,@CHANCE2, 'Borean Tundra Ore Spawnpoint 61 Rich Cobalt'),
(@GUID1+61,@POOL+61,@CHANCE1, 'Borean Tundra Ore Spawnpoint 62 Cobalt'),
(@GUID2+61,@POOL+61,@CHANCE2, 'Borean Tundra Ore Spawnpoint 62 Rich Cobalt'),
(@GUID1+62,@POOL+62,@CHANCE1, 'Borean Tundra Ore Spawnpoint 63 Cobalt'),
(@GUID2+62,@POOL+62,@CHANCE2, 'Borean Tundra Ore Spawnpoint 63 Rich Cobalt'),
(@GUID1+63,@POOL+63,@CHANCE1, 'Borean Tundra Ore Spawnpoint 64 Cobalt'),
(@GUID2+63,@POOL+63,@CHANCE2, 'Borean Tundra Ore Spawnpoint 64 Rich Cobalt'),
(@GUID1+64,@POOL+64,@CHANCE1, 'Borean Tundra Ore Spawnpoint 65 Cobalt'),
(@GUID2+64,@POOL+64,@CHANCE2, 'Borean Tundra Ore Spawnpoint 65 Rich Cobalt'),
(@GUID1+65,@POOL+65,@CHANCE1, 'Borean Tundra Ore Spawnpoint 66 Cobalt'),
(@GUID2+65,@POOL+65,@CHANCE2, 'Borean Tundra Ore Spawnpoint 66 Rich Cobalt'),
(@GUID1+66,@POOL+66,@CHANCE1, 'Borean Tundra Ore Spawnpoint 67 Cobalt'),
(@GUID2+66,@POOL+66,@CHANCE2, 'Borean Tundra Ore Spawnpoint 67 Rich Cobalt'),
(@GUID1+67,@POOL+67,@CHANCE1, 'Borean Tundra Ore Spawnpoint 68 Cobalt'),
(@GUID2+67,@POOL+67,@CHANCE2, 'Borean Tundra Ore Spawnpoint 68 Rich Cobalt'),
(@GUID1+68,@POOL+68,@CHANCE1, 'Borean Tundra Ore Spawnpoint 69 Cobalt'),
(@GUID2+68,@POOL+68,@CHANCE2, 'Borean Tundra Ore Spawnpoint 69 Rich Cobalt'),
(@GUID1+69,@POOL+69,@CHANCE1, 'Borean Tundra Ore Spawnpoint 70 Cobalt'),
(@GUID2+69,@POOL+69,@CHANCE2, 'Borean Tundra Ore Spawnpoint 70 Rich Cobalt'),
(@GUID1+70,@POOL+70,@CHANCE1, 'Borean Tundra Ore Spawnpoint 71 Cobalt'),
(@GUID2+70,@POOL+70,@CHANCE2, 'Borean Tundra Ore Spawnpoint 71 Rich Cobalt'),
(@GUID1+71,@POOL+71,@CHANCE1, 'Borean Tundra Ore Spawnpoint 72 Cobalt'),
(@GUID2+71,@POOL+71,@CHANCE2, 'Borean Tundra Ore Spawnpoint 72 Rich Cobalt'),
(@GUID1+72,@POOL+72,@CHANCE1, 'Borean Tundra Ore Spawnpoint 73 Cobalt'),
(@GUID2+72,@POOL+72,@CHANCE2, 'Borean Tundra Ore Spawnpoint 73 Rich Cobalt'),
(@GUID1+73,@POOL+73,@CHANCE1, 'Borean Tundra Ore Spawnpoint 74 Cobalt'),
(@GUID2+73,@POOL+73,@CHANCE2, 'Borean Tundra Ore Spawnpoint 74 Rich Cobalt'),
(@GUID1+74,@POOL+74,@CHANCE1, 'Borean Tundra Ore Spawnpoint 75 Cobalt'),
(@GUID2+74,@POOL+74,@CHANCE2, 'Borean Tundra Ore Spawnpoint 75 Rich Cobalt'),
(@GUID1+75,@POOL+75,@CHANCE1, 'Borean Tundra Ore Spawnpoint 76 Cobalt'),
(@GUID2+75,@POOL+75,@CHANCE2, 'Borean Tundra Ore Spawnpoint 76 Rich Cobalt'),
(@GUID1+76,@POOL+76,@CHANCE1, 'Borean Tundra Ore Spawnpoint 77 Cobalt'),
(@GUID2+76,@POOL+76,@CHANCE2, 'Borean Tundra Ore Spawnpoint 77 Rich Cobalt'),
(@GUID1+77,@POOL+77,@CHANCE1, 'Borean Tundra Ore Spawnpoint 78 Cobalt'),
(@GUID2+77,@POOL+77,@CHANCE2, 'Borean Tundra Ore Spawnpoint 78 Rich Cobalt'),
(@GUID1+78,@POOL+78,@CHANCE1, 'Borean Tundra Ore Spawnpoint 79 Cobalt'),
(@GUID2+78,@POOL+78,@CHANCE2, 'Borean Tundra Ore Spawnpoint 79 Rich Cobalt'),
(@GUID1+79,@POOL+79,@CHANCE1, 'Borean Tundra Ore Spawnpoint 80 Cobalt'),
(@GUID2+79,@POOL+79,@CHANCE2, 'Borean Tundra Ore Spawnpoint 80 Rich Cobalt'),
(@GUID1+80,@POOL+80,@CHANCE1, 'Borean Tundra Ore Spawnpoint 81 Cobalt'),
(@GUID2+80,@POOL+80,@CHANCE2, 'Borean Tundra Ore Spawnpoint 81 Rich Cobalt'),
(@GUID1+81,@POOL+81,@CHANCE1, 'Borean Tundra Ore Spawnpoint 82 Cobalt'),
(@GUID2+81,@POOL+81,@CHANCE2, 'Borean Tundra Ore Spawnpoint 82 Rich Cobalt'),
(@GUID1+82,@POOL+82,@CHANCE1, 'Borean Tundra Ore Spawnpoint 83 Cobalt'),
(@GUID2+82,@POOL+82,@CHANCE2, 'Borean Tundra Ore Spawnpoint 83 Rich Cobalt'),
(@GUID1+83,@POOL+83,@CHANCE1, 'Borean Tundra Ore Spawnpoint 84 Cobalt'),
(@GUID2+83,@POOL+83,@CHANCE2, 'Borean Tundra Ore Spawnpoint 84 Rich Cobalt'),
(@GUID1+84,@POOL+84,@CHANCE1, 'Borean Tundra Ore Spawnpoint 85 Cobalt'),
(@GUID2+84,@POOL+84,@CHANCE2, 'Borean Tundra Ore Spawnpoint 85 Rich Cobalt'),
(@GUID1+85,@POOL+85,@CHANCE1, 'Borean Tundra Ore Spawnpoint 86 Cobalt'),
(@GUID2+85,@POOL+85,@CHANCE2, 'Borean Tundra Ore Spawnpoint 86 Rich Cobalt'),
(@GUID1+86,@POOL+86,@CHANCE1, 'Borean Tundra Ore Spawnpoint 87 Cobalt'),
(@GUID2+86,@POOL+86,@CHANCE2, 'Borean Tundra Ore Spawnpoint 87 Rich Cobalt'),
(@GUID1+87,@POOL+87,@CHANCE1, 'Borean Tundra Ore Spawnpoint 88 Cobalt'),
(@GUID2+87,@POOL+87,@CHANCE2, 'Borean Tundra Ore Spawnpoint 88 Rich Cobalt'),
(@GUID1+88,@POOL+88,@CHANCE1, 'Borean Tundra Ore Spawnpoint 89 Cobalt'),
(@GUID2+88,@POOL+88,@CHANCE2, 'Borean Tundra Ore Spawnpoint 89 Rich Cobalt'),
(@GUID1+89,@POOL+89,@CHANCE1, 'Borean Tundra Ore Spawnpoint 90 Cobalt'),
(@GUID2+89,@POOL+89,@CHANCE2, 'Borean Tundra Ore Spawnpoint 90 Rich Cobalt'),
(@GUID1+90,@POOL+90,@CHANCE1, 'Borean Tundra Ore Spawnpoint 91 Cobalt'),
(@GUID2+90,@POOL+90,@CHANCE2, 'Borean Tundra Ore Spawnpoint 91 Rich Cobalt');
-- Add each pool to pool template
DELETE FROM `pool_template` WHERE `entry` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+0,1, 'Borean Tundra Ore Spawnpoint 1'),
(@POOL+1,1, 'Borean Tundra Ore Spawnpoint 2'),
(@POOL+2,1, 'Borean Tundra Ore Spawnpoint 3'),
(@POOL+3,1, 'Borean Tundra Ore Spawnpoint 4'),
(@POOL+4,1, 'Borean Tundra Ore Spawnpoint 5'),
(@POOL+5,1, 'Borean Tundra Ore Spawnpoint 6'),
(@POOL+6,1, 'Borean Tundra Ore Spawnpoint 7'),
(@POOL+7,1, 'Borean Tundra Ore Spawnpoint 8'),
(@POOL+8,1, 'Borean Tundra Ore Spawnpoint 9'),
(@POOL+9,1, 'Borean Tundra Ore Spawnpoint 10'),
(@POOL+10,1, 'Borean Tundra Ore Spawnpoint 11'),
(@POOL+11,1, 'Borean Tundra Ore Spawnpoint 12'),
(@POOL+12,1, 'Borean Tundra Ore Spawnpoint 13'),
(@POOL+13,1, 'Borean Tundra Ore Spawnpoint 14'),
(@POOL+14,1, 'Borean Tundra Ore Spawnpoint 15'),
(@POOL+15,1, 'Borean Tundra Ore Spawnpoint 16'),
(@POOL+16,1, 'Borean Tundra Ore Spawnpoint 17'),
(@POOL+17,1, 'Borean Tundra Ore Spawnpoint 18'),
(@POOL+18,1, 'Borean Tundra Ore Spawnpoint 19'),
(@POOL+19,1, 'Borean Tundra Ore Spawnpoint 20'),
(@POOL+20,1, 'Borean Tundra Ore Spawnpoint 21'),
(@POOL+21,1, 'Borean Tundra Ore Spawnpoint 22'),
(@POOL+22,1, 'Borean Tundra Ore Spawnpoint 23'),
(@POOL+23,1, 'Borean Tundra Ore Spawnpoint 24'),
(@POOL+24,1, 'Borean Tundra Ore Spawnpoint 25'),
(@POOL+25,1, 'Borean Tundra Ore Spawnpoint 26'),
(@POOL+26,1, 'Borean Tundra Ore Spawnpoint 27'),
(@POOL+27,1, 'Borean Tundra Ore Spawnpoint 28'),
(@POOL+28,1, 'Borean Tundra Ore Spawnpoint 29'),
(@POOL+29,1, 'Borean Tundra Ore Spawnpoint 30'),
(@POOL+30,1, 'Borean Tundra Ore Spawnpoint 31'),
(@POOL+31,1, 'Borean Tundra Ore Spawnpoint 32'),
(@POOL+32,1, 'Borean Tundra Ore Spawnpoint 33'),
(@POOL+33,1, 'Borean Tundra Ore Spawnpoint 34'),
(@POOL+34,1, 'Borean Tundra Ore Spawnpoint 35'),
(@POOL+35,1, 'Borean Tundra Ore Spawnpoint 36'),
(@POOL+36,1, 'Borean Tundra Ore Spawnpoint 37'),
(@POOL+37,1, 'Borean Tundra Ore Spawnpoint 38'),
(@POOL+38,1, 'Borean Tundra Ore Spawnpoint 39'),
(@POOL+39,1, 'Borean Tundra Ore Spawnpoint 40'),
(@POOL+40,1, 'Borean Tundra Ore Spawnpoint 41'),
(@POOL+41,1, 'Borean Tundra Ore Spawnpoint 42'),
(@POOL+42,1, 'Borean Tundra Ore Spawnpoint 43'),
(@POOL+43,1, 'Borean Tundra Ore Spawnpoint 44'),
(@POOL+44,1, 'Borean Tundra Ore Spawnpoint 45'),
(@POOL+45,1, 'Borean Tundra Ore Spawnpoint 46'),
(@POOL+46,1, 'Borean Tundra Ore Spawnpoint 47'),
(@POOL+47,1, 'Borean Tundra Ore Spawnpoint 48'),
(@POOL+48,1, 'Borean Tundra Ore Spawnpoint 49'),
(@POOL+49,1, 'Borean Tundra Ore Spawnpoint 50'),
(@POOL+50,1, 'Borean Tundra Ore Spawnpoint 51'),
(@POOL+51,1, 'Borean Tundra Ore Spawnpoint 52'),
(@POOL+52,1, 'Borean Tundra Ore Spawnpoint 53'),
(@POOL+53,1, 'Borean Tundra Ore Spawnpoint 54'),
(@POOL+54,1, 'Borean Tundra Ore Spawnpoint 55'),
(@POOL+55,1, 'Borean Tundra Ore Spawnpoint 56'),
(@POOL+56,1, 'Borean Tundra Ore Spawnpoint 57'),
(@POOL+57,1, 'Borean Tundra Ore Spawnpoint 58'),
(@POOL+58,1, 'Borean Tundra Ore Spawnpoint 59'),
(@POOL+59,1, 'Borean Tundra Ore Spawnpoint 60'),
(@POOL+60,1, 'Borean Tundra Ore Spawnpoint 61'),
(@POOL+61,1, 'Borean Tundra Ore Spawnpoint 62'),
(@POOL+62,1, 'Borean Tundra Ore Spawnpoint 63'),
(@POOL+63,1, 'Borean Tundra Ore Spawnpoint 64'),
(@POOL+64,1, 'Borean Tundra Ore Spawnpoint 65'),
(@POOL+65,1, 'Borean Tundra Ore Spawnpoint 66'),
(@POOL+66,1, 'Borean Tundra Ore Spawnpoint 67'),
(@POOL+67,1, 'Borean Tundra Ore Spawnpoint 68'),
(@POOL+68,1, 'Borean Tundra Ore Spawnpoint 69'),
(@POOL+69,1, 'Borean Tundra Ore Spawnpoint 70'),
(@POOL+70,1, 'Borean Tundra Ore Spawnpoint 71'),
(@POOL+71,1, 'Borean Tundra Ore Spawnpoint 72'),
(@POOL+72,1, 'Borean Tundra Ore Spawnpoint 73'),
(@POOL+73,1, 'Borean Tundra Ore Spawnpoint 74'),
(@POOL+74,1, 'Borean Tundra Ore Spawnpoint 75'),
(@POOL+75,1, 'Borean Tundra Ore Spawnpoint 76'),
(@POOL+76,1, 'Borean Tundra Ore Spawnpoint 77'),
(@POOL+77,1, 'Borean Tundra Ore Spawnpoint 78'),
(@POOL+78,1, 'Borean Tundra Ore Spawnpoint 79'),
(@POOL+79,1, 'Borean Tundra Ore Spawnpoint 80'),
(@POOL+80,1, 'Borean Tundra Ore Spawnpoint 81'),
(@POOL+81,1, 'Borean Tundra Ore Spawnpoint 82'),
(@POOL+82,1, 'Borean Tundra Ore Spawnpoint 83'),
(@POOL+83,1, 'Borean Tundra Ore Spawnpoint 84'),
(@POOL+84,1, 'Borean Tundra Ore Spawnpoint 85'),
(@POOL+85,1, 'Borean Tundra Ore Spawnpoint 86'),
(@POOL+86,1, 'Borean Tundra Ore Spawnpoint 87'),
(@POOL+87,1, 'Borean Tundra Ore Spawnpoint 88'),
(@POOL+88,1, 'Borean Tundra Ore Spawnpoint 89'),
(@POOL+89,1, 'Borean Tundra Ore Spawnpoint 90'),
(@POOL+90,1, 'Borean Tundra Ore Spawnpoint 91');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER,@ACTIVE, 'Borean Tundra Ore Mother pool');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+0,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 1'),
(@POOL+1,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 2'),
(@POOL+2,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 3'),
(@POOL+3,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 4'),
(@POOL+4,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 5'),
(@POOL+5,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 6'),
(@POOL+6,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 7'),
(@POOL+7,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 8'),
(@POOL+8,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 9'),
(@POOL+9,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 10'),
(@POOL+10,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 11'),
(@POOL+11,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 12'),
(@POOL+12,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 13'),
(@POOL+13,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 14'),
(@POOL+14,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 15'),
(@POOL+15,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 16'),
(@POOL+16,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 17'),
(@POOL+17,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 18'),
(@POOL+18,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 19'),
(@POOL+19,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 20'),
(@POOL+20,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 21'),
(@POOL+21,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 22'),
(@POOL+22,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 23'),
(@POOL+23,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 24'),
(@POOL+24,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 25'),
(@POOL+25,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 26'),
(@POOL+26,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 27'),
(@POOL+27,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 28'),
(@POOL+28,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 29'),
(@POOL+29,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 30'),
(@POOL+30,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 31'),
(@POOL+31,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 32'),
(@POOL+32,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 33'),
(@POOL+33,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 34'),
(@POOL+34,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 35'),
(@POOL+35,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 36'),
(@POOL+36,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 37'),
(@POOL+37,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 38'),
(@POOL+38,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 39'),
(@POOL+39,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 40'),
(@POOL+40,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 41'),
(@POOL+41,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 42'),
(@POOL+42,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 43'),
(@POOL+43,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 44'),
(@POOL+44,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 45'),
(@POOL+45,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 46'),
(@POOL+46,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 47'),
(@POOL+47,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 48'),
(@POOL+48,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 49'),
(@POOL+49,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 50'),
(@POOL+50,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 51'),
(@POOL+51,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 52'),
(@POOL+52,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 53'),
(@POOL+53,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 54'),
(@POOL+54,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 55'),
(@POOL+55,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 56'),
(@POOL+56,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 57'),
(@POOL+57,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 58'),
(@POOL+58,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 59'),
(@POOL+59,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 60'),
(@POOL+60,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 61'),
(@POOL+61,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 62'),
(@POOL+62,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 63'),
(@POOL+63,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 64'),
(@POOL+64,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 65'),
(@POOL+65,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 66'),
(@POOL+66,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 67'),
(@POOL+67,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 68'),
(@POOL+68,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 69'),
(@POOL+69,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 70'),
(@POOL+70,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 71'),
(@POOL+71,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 72'),
(@POOL+72,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 73'),
(@POOL+73,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 74'),
(@POOL+74,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 75'),
(@POOL+75,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 76'),
(@POOL+76,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 77'),
(@POOL+77,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 78'),
(@POOL+78,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 79'),
(@POOL+79,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 80'),
(@POOL+80,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 81'),
(@POOL+81,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 82'),
(@POOL+82,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 83'),
(@POOL+83,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 84'),
(@POOL+84,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 85'),
(@POOL+85,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 86'),
(@POOL+86,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 87'),
(@POOL+87,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 88'),
(@POOL+88,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 89'),
(@POOL+89,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 90'),
(@POOL+90,@MOTHER,0, 'Borean Tundra Ore Spawnpoint 91');

-- ----------------------------------------
-- Fixup ore spawns for Howling Fjord
-- ----------------------------------------
SET @RANGE    := 150;
SET @GUID1    := 160300;
SET @GUID2    := @GUID1 + @RANGE;
SET @POOL     := 10150;
SET @LASTGUID := 99; -- Total number of guids - 1 in zone
SET @CHANCE1  := 90; -- This value can be 0 to 100
SET @CHANCE2  := 100 - @CHANCE1;
SET @MOTHER   := 9901;
SET @ACTIVE   := 30; -- Max number of active spawns
SET @TIMER    := 900; -- Respawn timer in seconds
-- Remove Ore spawns from Howling Fjord
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y < -1630 AND `position_x` < 3090;
-- Remove old pools
DELETE FROM `pool_gameobject` WHERE `guid` NOT IN (SELECT `guid` FROM `gameobject`);
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5065 AND 5121;
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5277 AND 5282;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5065 AND 5120;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5277 AND 5282;
-- Cobalt Deposits Howling Fjord
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID1,189978,571,1,1,-144.006,-4989.570,309.6730,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID1+1,189978,571,1,1,-23.354,-3586.670,33.7790,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID1+2,189978,571,1,1,27.324,-3423.650,35.6203,-1.02974,0,0,0,1,@TIMER,255,1),
(@GUID1+3,189978,571,1,1,85.848,-4961.880,316.0240,-1.74533,0,0,0,1,@TIMER,255,1),
(@GUID1+4,189978,571,1,1,124.983,-3449.730,11.4041,-2.04204,0,0,0,1,@TIMER,255,1),
(@GUID1+5,189978,571,1,1,146.113,-5708.520,190.8280,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+6,189978,571,1,1,196.368,-5529.420,341.1140,1.72787,0,0,0,1,@TIMER,255,1),
(@GUID1+7,189978,571,1,1,222.143,-4541.690,253.7470,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID1+8,189978,571,1,1,229.642,-4166.400,247.4830,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID1+9,189978,571,1,1,299.400,-5925.310,169.6930,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+10,189978,571,1,1,311.682,-5829.520,198.0980,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+11,189978,571,1,1,316.353,-5817.650,83.6513,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID1+12,189978,571,1,1,328.762,-5728.000,99.5547,-0.95993,0,0,0,1,@TIMER,255,1),
(@GUID1+13,189978,571,1,1,330.220,-3287.700,18.4444,-2.23402,0,0,0,1,@TIMER,255,1),
(@GUID1+14,189978,571,1,1,423.793,-4250.210,244.9780,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID1+15,189978,571,1,1,492.294,-4829.170,197.9880,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+16,189978,571,1,1,500.158,-5366.890,254.5380,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID1+17,189978,571,1,1,541.476,-4125.020,233.4580,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID1+18,189978,571,1,1,576.522,-5438.030,252.0870,2.60053,0,0,0,1,@TIMER,255,1),
(@GUID1+19,189978,571,1,1,589.568,-5148.210,-27.0699,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID1+20,189978,571,1,1,635.328,-5190.950,-62.0246,-0.47124,0,0,0,1,@TIMER,255,1),
(@GUID1+21,189978,571,1,1,667.572,-5772.810,284.2740,2.19912,0,0,0,1,@TIMER,255,1),
(@GUID1+22,189978,571,1,1,714.204,-5995.600,298.3530,-1.23918,0,0,0,1,@TIMER,255,1),
(@GUID1+23,189978,571,1,1,733.277,-5463.260,245.2840,-1.58825,0,0,0,1,@TIMER,255,1),
(@GUID1+24,189978,571,1,1,785.268,-4710.470,189.7250,0.78540,0,0,0,1,@TIMER,255,1),
(@GUID1+25,189978,571,1,3,788.804,-5611.920,231.8180,2.63544,0,0,0,1,@TIMER,255,1),
(@GUID1+26,189978,571,1,1,830.549,-5146.020,-89.1197,-2.82743,0,0,0,1,@TIMER,255,1),
(@GUID1+27,189978,571,1,1,837.785,-3214.380,20.0425,0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+28,189978,571,1,1,854.087,-5928.980,280.4520,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID1+29,189978,571,1,1,875.595,-3690.570,175.6530,2.63544,0,0,0,1,@TIMER,255,1),
(@GUID1+30,189978,571,1,1,886.931,-4307.350,193.8120,-1.72787,0,0,0,1,@TIMER,255,1),
(@GUID1+31,189978,571,1,1,895.472,-4540.750,159.1540,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID1+32,189978,571,1,1,910.239,-3593.450,177.5230,2.46091,0,0,0,1,@TIMER,255,1),
(@GUID1+33,189978,571,1,1,937.882,-3032.450,48.7494,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID1+34,189978,571,1,1,985.488,-5351.640,193.8970,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID1+35,189978,571,1,1,997.533,-3464.590,186.6590,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID1+36,189978,571,1,1,998.078,-5148.790,-57.7402,2.47837,0,0,0,1,@TIMER,255,1),
(@GUID1+37,189978,571,1,1,1016.760,-4291.670,174.0770,2.75761,0,0,0,1,@TIMER,255,1),
(@GUID1+38,189978,571,1,1,1041.890,-4154.150,152.6180,0.94248,0,0,0,1,@TIMER,255,1),
(@GUID1+39,189978,571,1,1,1118.230,-3437.520,182.9670,2.65289,0,0,0,1,@TIMER,255,1),
(@GUID1+40,189978,571,1,1,1257.230,-6054.090,270.8700,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID1+41,189978,571,1,3,1257.940,-6169.470,234.7100,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID1+42,189978,571,1,1,1339.420,-5826.830,281.0600,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+43,189978,571,1,1,1462.340,-5216.200,195.6330,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID1+44,189978,571,1,1,1541.420,-5149.820,182.1700,2.35619,0,0,0,1,@TIMER,255,1),
(@GUID1+45,189978,571,1,1,1598.760,-5001.500,144.0290,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID1+46,189978,571,1,1,1599.154,-4322.061,187.5960,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID1+47,189978,571,1,1,1615.540,-5234.790,181.3280,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+48,189978,571,1,1,1653.280,-4680.180,88.7987,1.51844,0,0,0,1,@TIMER,255,1),
(@GUID1+49,189978,571,1,1,1660.280,-6275.210,-0.2026,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID1+50,189978,571,1,1,1683.270,-6037.250,7.9892,-3.12412,0,0,0,1,@TIMER,255,1),
(@GUID1+51,189978,571,1,1,1691.670,-4586.670,169.3620,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID1+52,189978,571,1,1,1725.580,-4852.210,115.8110,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+53,189978,571,1,1,1742.030,-4378.720,174.1920,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+54,189978,571,1,1,1796.960,-6265.710,-0.9726,-2.14675,0,0,0,1,@TIMER,255,1),
(@GUID1+55,189978,571,1,1,1813.380,-5678.040,226.8270,0.29671,0,0,0,1,@TIMER,255,1),
(@GUID1+56,189978,571,1,1,1820.460,-3808.940,151.5820,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID1+57,189978,571,1,1,1836.030,-3927.070,177.5710,-1.39626,0,0,0,1,@TIMER,255,1),
(@GUID1+58,189978,571,1,1,1864.170,-3001.180,144.1620,2.77507,0,0,0,1,@TIMER,255,1),
(@GUID1+59,189978,571,1,1,1876.110,-4463.470,197.2810,2.53072,0,0,0,1,@TIMER,255,1),
(@GUID1+60,189978,571,1,1,1887.140,-3679.140,153.3620,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID1+61,189978,571,1,1,1963.890,-2986.950,155.5740,-2.18166,0,0,0,1,@TIMER,255,1),
(@GUID1+62,189978,571,1,1,1985.820,-5552.980,217.1860,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+63,189978,571,1,1,2022.600,-2729.910,0.3004,0.83776,0,0,0,1,@TIMER,255,1),
(@GUID1+64,189978,571,1,1,2047.480,-5751.410,222.5030,-2.74016,0,0,0,1,@TIMER,255,1),
(@GUID1+65,189978,571,1,1,2063.090,-5004.980,231.0370,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID1+66,189978,571,1,1,2136.450,-5652.090,224.3920,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID1+67,189978,571,1,1,2143.750,-5151.330,240.6410,2.60053,0,0,0,1,@TIMER,255,1),
(@GUID1+68,189978,571,1,1,2183.740,-5265.660,250.0680,0.47124,0,0,0,1,@TIMER,255,1),
(@GUID1+69,189978,571,1,1,2192.250,-2648.390,1.1699,-1.55334,0,0,0,1,@TIMER,255,1),
(@GUID1+70,189978,571,1,1,2192.970,-2536.350,5.3353,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID1+71,189978,571,1,1,2208.330,-3082.530,132.8410,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID1+72,189978,571,1,1,2275.290,-2949.500,123.7380,2.14675,0,0,0,1,@TIMER,255,1),
(@GUID1+73,189978,571,1,1,2304.780,-2744.870,-0.0415,2.47837,0,0,0,1,@TIMER,255,1),
(@GUID1+74,189978,571,1,1,2332.090,-5852.160,251.1900,-0.50614,0,0,0,1,@TIMER,255,1),
(@GUID1+75,189978,571,1,1,2357.480,-3706.470,223.2140,-2.32129,0,0,0,1,@TIMER,255,1),
(@GUID1+76,189978,571,1,1,2407.690,-2824.830,9.7012,-0.85521,0,0,0,1,@TIMER,255,1),
(@GUID1+77,189978,571,1,1,2467.060,-2824.690,20.6504,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+78,189978,571,1,1,2478.630,-3080.530,138.9920,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID1+79,189978,571,1,1,2479.220,-5437.190,299.5430,1.74533,0,0,0,1,@TIMER,255,1),
(@GUID1+80,189978,571,1,1,2504.180,-3896.100,263.8390,1.76278,0,0,0,1,@TIMER,255,1),
(@GUID1+81,189978,571,1,1,2508.660,-3015.970,120.7830,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID1+82,189978,571,1,1,2518.630,-4743.720,246.5690,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+83,189978,571,1,1,2536.780,-3717.470,266.8920,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+84,189978,571,1,1,2545.640,-4507.800,230.7980,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID1+85,189978,571,1,1,2557.900,-4616.650,229.8060,0.80285,0,0,0,1,@TIMER,255,1),
(@GUID1+86,189978,571,1,3,2570.450,-2766.360,8.7401,-0.48869,0,0,0,1,@TIMER,255,1),
(@GUID1+87,189978,571,1,1,2580.790,-4152.530,302.8390,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID1+88,189978,571,1,1,2583.110,-3123.240,128.7190,2.12930,0,0,0,1,@TIMER,255,1),
(@GUID1+89,189978,571,1,1,2588.110,-3004.660,111.5360,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID1+90,189978,571,1,1,2589.780,-3917.450,296.8400,-0.29671,0,0,0,1,@TIMER,255,1),
(@GUID1+91,189978,571,1,1,2616.550,-5791.180,314.3880,0.03491,0,0,0,1,@TIMER,255,1),
(@GUID1+92,189978,571,1,1,2637.770,-3659.380,241.5800,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID1+93,189978,571,1,3,2696.920,-4105.830,365.9280,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID1+94,189978,571,1,1,2700.000,-3145.570,119.8800,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID1+95,189978,571,1,1,2731.690,-5583.630,379.2140,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+96,189978,571,1,3,2733.180,-4021.560,378.2430,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID1+97,189978,571,1,1,2821.700,-3719.720,232.7200,1.06465,0,0,0,1,@TIMER,255,1),
(@GUID1+98,189978,571,1,1,2869.770,-3186.190,134.0100,1.18682,0,0,0,1,@TIMER,255,1),
(@GUID1+99,189978,571,1,1,2918.130,-3075.250,91.0060,1.81514,0,0,0,1,@TIMER,255,1);
-- Rich Cobalt Deposits Howling Fjord
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID2,189979,571,1,1,-144.006,-4989.570,309.6730,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID2+1,189979,571,1,1,-23.354,-3586.670,33.7790,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID2+2,189979,571,1,1,27.324,-3423.650,35.6203,-1.02974,0,0,0,1,@TIMER,255,1),
(@GUID2+3,189979,571,1,1,85.848,-4961.880,316.0240,-1.74533,0,0,0,1,@TIMER,255,1),
(@GUID2+4,189979,571,1,1,124.983,-3449.730,11.4041,-2.04204,0,0,0,1,@TIMER,255,1),
(@GUID2+5,189979,571,1,1,146.113,-5708.520,190.8280,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+6,189979,571,1,1,196.368,-5529.420,341.1140,1.72787,0,0,0,1,@TIMER,255,1),
(@GUID2+7,189979,571,1,1,222.143,-4541.690,253.7470,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID2+8,189979,571,1,1,229.642,-4166.400,247.4830,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID2+9,189979,571,1,1,299.400,-5925.310,169.6930,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+10,189979,571,1,1,311.682,-5829.520,198.0980,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+11,189979,571,1,1,316.353,-5817.650,83.6513,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID2+12,189979,571,1,1,328.762,-5728.000,99.5547,-0.95993,0,0,0,1,@TIMER,255,1),
(@GUID2+13,189979,571,1,1,330.220,-3287.700,18.4444,-2.23402,0,0,0,1,@TIMER,255,1),
(@GUID2+14,189979,571,1,1,423.793,-4250.210,244.9780,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID2+15,189979,571,1,1,492.294,-4829.170,197.9880,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+16,189979,571,1,1,500.158,-5366.890,254.5380,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID2+17,189979,571,1,1,541.476,-4125.020,233.4580,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID2+18,189979,571,1,1,576.522,-5438.030,252.0870,2.60053,0,0,0,1,@TIMER,255,1),
(@GUID2+19,189979,571,1,1,589.568,-5148.210,-27.0699,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID2+20,189979,571,1,1,635.328,-5190.950,-62.0246,-0.47124,0,0,0,1,@TIMER,255,1),
(@GUID2+21,189979,571,1,1,667.572,-5772.810,284.2740,2.19912,0,0,0,1,@TIMER,255,1),
(@GUID2+22,189979,571,1,1,714.204,-5995.600,298.3530,-1.23918,0,0,0,1,@TIMER,255,1),
(@GUID2+23,189979,571,1,1,733.277,-5463.260,245.2840,-1.58825,0,0,0,1,@TIMER,255,1),
(@GUID2+24,189979,571,1,1,785.268,-4710.470,189.7250,0.78540,0,0,0,1,@TIMER,255,1),
(@GUID2+25,189979,571,1,3,788.804,-5611.920,231.8180,2.63544,0,0,0,1,@TIMER,255,1),
(@GUID2+26,189979,571,1,1,830.549,-5146.020,-89.1197,-2.82743,0,0,0,1,@TIMER,255,1),
(@GUID2+27,189979,571,1,1,837.785,-3214.380,20.0425,0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+28,189979,571,1,1,854.087,-5928.980,280.4520,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID2+29,189979,571,1,1,875.595,-3690.570,175.6530,2.63544,0,0,0,1,@TIMER,255,1),
(@GUID2+30,189979,571,1,1,886.931,-4307.350,193.8120,-1.72787,0,0,0,1,@TIMER,255,1),
(@GUID2+31,189979,571,1,1,895.472,-4540.750,159.1540,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID2+32,189979,571,1,1,910.239,-3593.450,177.5230,2.46091,0,0,0,1,@TIMER,255,1),
(@GUID2+33,189979,571,1,1,937.882,-3032.450,48.7494,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID2+34,189979,571,1,1,985.488,-5351.640,193.8970,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID2+35,189979,571,1,1,997.533,-3464.590,186.6590,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID2+36,189979,571,1,1,998.078,-5148.790,-57.7402,2.47837,0,0,0,1,@TIMER,255,1),
(@GUID2+37,189979,571,1,1,1016.760,-4291.670,174.0770,2.75761,0,0,0,1,@TIMER,255,1),
(@GUID2+38,189979,571,1,1,1041.890,-4154.150,152.6180,0.94248,0,0,0,1,@TIMER,255,1),
(@GUID2+39,189979,571,1,1,1118.230,-3437.520,182.9670,2.65289,0,0,0,1,@TIMER,255,1),
(@GUID2+40,189979,571,1,1,1257.230,-6054.090,270.8700,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID2+41,189979,571,1,3,1257.940,-6169.470,234.7100,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID2+42,189979,571,1,1,1339.420,-5826.830,281.0600,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+43,189979,571,1,1,1462.340,-5216.200,195.6330,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID2+44,189979,571,1,1,1541.420,-5149.820,182.1700,2.35619,0,0,0,1,@TIMER,255,1),
(@GUID2+45,189979,571,1,1,1598.760,-5001.500,144.0290,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID2+46,189979,571,1,1,1599.154,-4322.061,187.5960,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID2+47,189979,571,1,1,1615.540,-5234.790,181.3280,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+48,189979,571,1,1,1653.280,-4680.180,88.7987,1.51844,0,0,0,1,@TIMER,255,1),
(@GUID2+49,189979,571,1,1,1660.280,-6275.210,-0.2026,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID2+50,189979,571,1,1,1683.270,-6037.250,7.9892,-3.12412,0,0,0,1,@TIMER,255,1),
(@GUID2+51,189979,571,1,1,1691.670,-4586.670,169.3620,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID2+52,189979,571,1,1,1725.580,-4852.210,115.8110,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+53,189979,571,1,1,1742.030,-4378.720,174.1920,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+54,189979,571,1,1,1796.960,-6265.710,-0.9726,-2.14675,0,0,0,1,@TIMER,255,1),
(@GUID2+55,189979,571,1,1,1813.380,-5678.040,226.8270,0.29671,0,0,0,1,@TIMER,255,1),
(@GUID2+56,189979,571,1,1,1820.460,-3808.940,151.5820,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID2+57,189979,571,1,1,1836.030,-3927.070,177.5710,-1.39626,0,0,0,1,@TIMER,255,1),
(@GUID2+58,189979,571,1,1,1864.170,-3001.180,144.1620,2.77507,0,0,0,1,@TIMER,255,1),
(@GUID2+59,189979,571,1,1,1876.110,-4463.470,197.2810,2.53072,0,0,0,1,@TIMER,255,1),
(@GUID2+60,189979,571,1,1,1887.140,-3679.140,153.3620,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID2+61,189979,571,1,1,1963.890,-2986.950,155.5740,-2.18166,0,0,0,1,@TIMER,255,1),
(@GUID2+62,189979,571,1,1,1985.820,-5552.980,217.1860,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+63,189979,571,1,1,2022.600,-2729.910,0.3004,0.83776,0,0,0,1,@TIMER,255,1),
(@GUID2+64,189979,571,1,1,2047.480,-5751.410,222.5030,-2.74016,0,0,0,1,@TIMER,255,1),
(@GUID2+65,189979,571,1,1,2063.090,-5004.980,231.0370,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID2+66,189979,571,1,1,2136.450,-5652.090,224.3920,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID2+67,189979,571,1,1,2143.750,-5151.330,240.6410,2.60053,0,0,0,1,@TIMER,255,1),
(@GUID2+68,189979,571,1,1,2183.740,-5265.660,250.0680,0.47124,0,0,0,1,@TIMER,255,1),
(@GUID2+69,189979,571,1,1,2192.250,-2648.390,1.1699,-1.55334,0,0,0,1,@TIMER,255,1),
(@GUID2+70,189979,571,1,1,2192.970,-2536.350,5.3353,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID2+71,189979,571,1,1,2208.330,-3082.530,132.8410,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID2+72,189979,571,1,1,2275.290,-2949.500,123.7380,2.14675,0,0,0,1,@TIMER,255,1),
(@GUID2+73,189979,571,1,1,2304.780,-2744.870,-0.0415,2.47837,0,0,0,1,@TIMER,255,1),
(@GUID2+74,189979,571,1,1,2332.090,-5852.160,251.1900,-0.50614,0,0,0,1,@TIMER,255,1),
(@GUID2+75,189979,571,1,1,2357.480,-3706.470,223.2140,-2.32129,0,0,0,1,@TIMER,255,1),
(@GUID2+76,189979,571,1,1,2407.690,-2824.830,9.7012,-0.85521,0,0,0,1,@TIMER,255,1),
(@GUID2+77,189979,571,1,1,2467.060,-2824.690,20.6504,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+78,189979,571,1,1,2478.630,-3080.530,138.9920,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID2+79,189979,571,1,1,2479.220,-5437.190,299.5430,1.74533,0,0,0,1,@TIMER,255,1),
(@GUID2+80,189979,571,1,1,2504.180,-3896.100,263.8390,1.76278,0,0,0,1,@TIMER,255,1),
(@GUID2+81,189979,571,1,1,2508.660,-3015.970,120.7830,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID2+82,189979,571,1,1,2518.630,-4743.720,246.5690,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+83,189979,571,1,1,2536.780,-3717.470,266.8920,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+84,189979,571,1,1,2545.640,-4507.800,230.7980,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID2+85,189979,571,1,1,2557.900,-4616.650,229.8060,0.80285,0,0,0,1,@TIMER,255,1),
(@GUID2+86,189979,571,1,3,2570.450,-2766.360,8.7401,-0.48869,0,0,0,1,@TIMER,255,1),
(@GUID2+87,189979,571,1,1,2580.790,-4152.530,302.8390,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID2+88,189979,571,1,1,2583.110,-3123.240,128.7190,2.12930,0,0,0,1,@TIMER,255,1),
(@GUID2+89,189979,571,1,1,2588.110,-3004.660,111.5360,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID2+90,189979,571,1,1,2589.780,-3917.450,296.8400,-0.29671,0,0,0,1,@TIMER,255,1),
(@GUID2+91,189979,571,1,1,2616.550,-5791.180,314.3880,0.03491,0,0,0,1,@TIMER,255,1),
(@GUID2+92,189979,571,1,1,2637.770,-3659.380,241.5800,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID2+93,189979,571,1,3,2696.920,-4105.830,365.9280,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID2+94,189979,571,1,1,2700.000,-3145.570,119.8800,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID2+95,189979,571,1,1,2731.690,-5583.630,379.2140,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+96,189979,571,1,3,2733.180,-4021.560,378.2430,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID2+97,189979,571,1,1,2821.700,-3719.720,232.7200,1.06465,0,0,0,1,@TIMER,255,1),
(@GUID2+98,189979,571,1,1,2869.770,-3186.190,134.0100,1.18682,0,0,0,1,@TIMER,255,1),
(@GUID2+99,189979,571,1,1,2918.130,-3075.250,91.0060,1.81514,0,0,0,1,@TIMER,255,1);
-- Pooling
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID1 AND @GUID1+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID2 AND @GUID2+@LASTGUID;
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+0,@POOL+0,@CHANCE1, 'Howling Fjord Ore Spawnpoint 1 Cobalt'),
(@GUID2+0,@POOL+0,@CHANCE2, 'Howling Fjord Ore Spawnpoint 1 Rich Cobalt'),
(@GUID1+1,@POOL+1,@CHANCE1, 'Howling Fjord Ore Spawnpoint 2 Cobalt'),
(@GUID2+1,@POOL+1,@CHANCE2, 'Howling Fjord Ore Spawnpoint 2 Rich Cobalt'),
(@GUID1+2,@POOL+2,@CHANCE1, 'Howling Fjord Ore Spawnpoint 3 Cobalt'),
(@GUID2+2,@POOL+2,@CHANCE2, 'Howling Fjord Ore Spawnpoint 3 Rich Cobalt'),
(@GUID1+3,@POOL+3,@CHANCE1, 'Howling Fjord Ore Spawnpoint 4 Cobalt'),
(@GUID2+3,@POOL+3,@CHANCE2, 'Howling Fjord Ore Spawnpoint 4 Rich Cobalt'),
(@GUID1+4,@POOL+4,@CHANCE1, 'Howling Fjord Ore Spawnpoint 5 Cobalt'),
(@GUID2+4,@POOL+4,@CHANCE2, 'Howling Fjord Ore Spawnpoint 5 Rich Cobalt'),
(@GUID1+5,@POOL+5,@CHANCE1, 'Howling Fjord Ore Spawnpoint 6 Cobalt'),
(@GUID2+5,@POOL+5,@CHANCE2, 'Howling Fjord Ore Spawnpoint 6 Rich Cobalt'),
(@GUID1+6,@POOL+6,@CHANCE1, 'Howling Fjord Ore Spawnpoint 7 Cobalt'),
(@GUID2+6,@POOL+6,@CHANCE2, 'Howling Fjord Ore Spawnpoint 7 Rich Cobalt'),
(@GUID1+7,@POOL+7,@CHANCE1, 'Howling Fjord Ore Spawnpoint 8 Cobalt'),
(@GUID2+7,@POOL+7,@CHANCE2, 'Howling Fjord Ore Spawnpoint 8 Rich Cobalt'),
(@GUID1+8,@POOL+8,@CHANCE1, 'Howling Fjord Ore Spawnpoint 9 Cobalt'),
(@GUID2+8,@POOL+8,@CHANCE2, 'Howling Fjord Ore Spawnpoint 9 Rich Cobalt'),
(@GUID1+9,@POOL+9,@CHANCE1, 'Howling Fjord Ore Spawnpoint 10 Cobalt'),
(@GUID2+9,@POOL+9,@CHANCE2, 'Howling Fjord Ore Spawnpoint 10 Rich Cobalt'),
(@GUID1+10,@POOL+10,@CHANCE1, 'Howling Fjord Ore Spawnpoint 11 Cobalt'),
(@GUID2+10,@POOL+10,@CHANCE2, 'Howling Fjord Ore Spawnpoint 11 Rich Cobalt'),
(@GUID1+11,@POOL+11,@CHANCE1, 'Howling Fjord Ore Spawnpoint 12 Cobalt'),
(@GUID2+11,@POOL+11,@CHANCE2, 'Howling Fjord Ore Spawnpoint 12 Rich Cobalt'),
(@GUID1+12,@POOL+12,@CHANCE1, 'Howling Fjord Ore Spawnpoint 13 Cobalt'),
(@GUID2+12,@POOL+12,@CHANCE2, 'Howling Fjord Ore Spawnpoint 13 Rich Cobalt'),
(@GUID1+13,@POOL+13,@CHANCE1, 'Howling Fjord Ore Spawnpoint 14 Cobalt'),
(@GUID2+13,@POOL+13,@CHANCE2, 'Howling Fjord Ore Spawnpoint 14 Rich Cobalt'),
(@GUID1+14,@POOL+14,@CHANCE1, 'Howling Fjord Ore Spawnpoint 15 Cobalt'),
(@GUID2+14,@POOL+14,@CHANCE2, 'Howling Fjord Ore Spawnpoint 15 Rich Cobalt'),
(@GUID1+15,@POOL+15,@CHANCE1, 'Howling Fjord Ore Spawnpoint 16 Cobalt'),
(@GUID2+15,@POOL+15,@CHANCE2, 'Howling Fjord Ore Spawnpoint 16 Rich Cobalt'),
(@GUID1+16,@POOL+16,@CHANCE1, 'Howling Fjord Ore Spawnpoint 17 Cobalt'),
(@GUID2+16,@POOL+16,@CHANCE2, 'Howling Fjord Ore Spawnpoint 17 Rich Cobalt'),
(@GUID1+17,@POOL+17,@CHANCE1, 'Howling Fjord Ore Spawnpoint 18 Cobalt'),
(@GUID2+17,@POOL+17,@CHANCE2, 'Howling Fjord Ore Spawnpoint 18 Rich Cobalt'),
(@GUID1+18,@POOL+18,@CHANCE1, 'Howling Fjord Ore Spawnpoint 19 Cobalt'),
(@GUID2+18,@POOL+18,@CHANCE2, 'Howling Fjord Ore Spawnpoint 19 Rich Cobalt'),
(@GUID1+19,@POOL+19,@CHANCE1, 'Howling Fjord Ore Spawnpoint 20 Cobalt'),
(@GUID2+19,@POOL+19,@CHANCE2, 'Howling Fjord Ore Spawnpoint 20 Rich Cobalt'),
(@GUID1+20,@POOL+20,@CHANCE1, 'Howling Fjord Ore Spawnpoint 21 Cobalt'),
(@GUID2+20,@POOL+20,@CHANCE2, 'Howling Fjord Ore Spawnpoint 21 Rich Cobalt'),
(@GUID1+21,@POOL+21,@CHANCE1, 'Howling Fjord Ore Spawnpoint 22 Cobalt'),
(@GUID2+21,@POOL+21,@CHANCE2, 'Howling Fjord Ore Spawnpoint 22 Rich Cobalt'),
(@GUID1+22,@POOL+22,@CHANCE1, 'Howling Fjord Ore Spawnpoint 23 Cobalt'),
(@GUID2+22,@POOL+22,@CHANCE2, 'Howling Fjord Ore Spawnpoint 23 Rich Cobalt'),
(@GUID1+23,@POOL+23,@CHANCE1, 'Howling Fjord Ore Spawnpoint 24 Cobalt'),
(@GUID2+23,@POOL+23,@CHANCE2, 'Howling Fjord Ore Spawnpoint 24 Rich Cobalt'),
(@GUID1+24,@POOL+24,@CHANCE1, 'Howling Fjord Ore Spawnpoint 25 Cobalt'),
(@GUID2+24,@POOL+24,@CHANCE2, 'Howling Fjord Ore Spawnpoint 25 Rich Cobalt'),
(@GUID1+25,@POOL+25,@CHANCE1, 'Howling Fjord Ore Spawnpoint 26 Cobalt'),
(@GUID2+25,@POOL+25,@CHANCE2, 'Howling Fjord Ore Spawnpoint 26 Rich Cobalt'),
(@GUID1+26,@POOL+26,@CHANCE1, 'Howling Fjord Ore Spawnpoint 27 Cobalt'),
(@GUID2+26,@POOL+26,@CHANCE2, 'Howling Fjord Ore Spawnpoint 27 Rich Cobalt'),
(@GUID1+27,@POOL+27,@CHANCE1, 'Howling Fjord Ore Spawnpoint 28 Cobalt'),
(@GUID2+27,@POOL+27,@CHANCE2, 'Howling Fjord Ore Spawnpoint 28 Rich Cobalt'),
(@GUID1+28,@POOL+28,@CHANCE1, 'Howling Fjord Ore Spawnpoint 29 Cobalt'),
(@GUID2+28,@POOL+28,@CHANCE2, 'Howling Fjord Ore Spawnpoint 29 Rich Cobalt'),
(@GUID1+29,@POOL+29,@CHANCE1, 'Howling Fjord Ore Spawnpoint 30 Cobalt'),
(@GUID2+29,@POOL+29,@CHANCE2, 'Howling Fjord Ore Spawnpoint 30 Rich Cobalt'),
(@GUID1+30,@POOL+30,@CHANCE1, 'Howling Fjord Ore Spawnpoint 31 Cobalt'),
(@GUID2+30,@POOL+30,@CHANCE2, 'Howling Fjord Ore Spawnpoint 31 Rich Cobalt'),
(@GUID1+31,@POOL+31,@CHANCE1, 'Howling Fjord Ore Spawnpoint 32 Cobalt'),
(@GUID2+31,@POOL+31,@CHANCE2, 'Howling Fjord Ore Spawnpoint 32 Rich Cobalt'),
(@GUID1+32,@POOL+32,@CHANCE1, 'Howling Fjord Ore Spawnpoint 33 Cobalt'),
(@GUID2+32,@POOL+32,@CHANCE2, 'Howling Fjord Ore Spawnpoint 33 Rich Cobalt'),
(@GUID1+33,@POOL+33,@CHANCE1, 'Howling Fjord Ore Spawnpoint 34 Cobalt'),
(@GUID2+33,@POOL+33,@CHANCE2, 'Howling Fjord Ore Spawnpoint 34 Rich Cobalt'),
(@GUID1+34,@POOL+34,@CHANCE1, 'Howling Fjord Ore Spawnpoint 35 Cobalt'),
(@GUID2+34,@POOL+34,@CHANCE2, 'Howling Fjord Ore Spawnpoint 35 Rich Cobalt'),
(@GUID1+35,@POOL+35,@CHANCE1, 'Howling Fjord Ore Spawnpoint 36 Cobalt'),
(@GUID2+35,@POOL+35,@CHANCE2, 'Howling Fjord Ore Spawnpoint 36 Rich Cobalt'),
(@GUID1+36,@POOL+36,@CHANCE1, 'Howling Fjord Ore Spawnpoint 37 Cobalt'),
(@GUID2+36,@POOL+36,@CHANCE2, 'Howling Fjord Ore Spawnpoint 37 Rich Cobalt'),
(@GUID1+37,@POOL+37,@CHANCE1, 'Howling Fjord Ore Spawnpoint 38 Cobalt'),
(@GUID2+37,@POOL+37,@CHANCE2, 'Howling Fjord Ore Spawnpoint 38 Rich Cobalt'),
(@GUID1+38,@POOL+38,@CHANCE1, 'Howling Fjord Ore Spawnpoint 39 Cobalt'),
(@GUID2+38,@POOL+38,@CHANCE2, 'Howling Fjord Ore Spawnpoint 39 Rich Cobalt'),
(@GUID1+39,@POOL+39,@CHANCE1, 'Howling Fjord Ore Spawnpoint 40 Cobalt'),
(@GUID2+39,@POOL+39,@CHANCE2, 'Howling Fjord Ore Spawnpoint 40 Rich Cobalt'),
(@GUID1+40,@POOL+40,@CHANCE1, 'Howling Fjord Ore Spawnpoint 41 Cobalt'),
(@GUID2+40,@POOL+40,@CHANCE2, 'Howling Fjord Ore Spawnpoint 41 Rich Cobalt'),
(@GUID1+41,@POOL+41,@CHANCE1, 'Howling Fjord Ore Spawnpoint 42 Cobalt'),
(@GUID2+41,@POOL+41,@CHANCE2, 'Howling Fjord Ore Spawnpoint 42 Rich Cobalt'),
(@GUID1+42,@POOL+42,@CHANCE1, 'Howling Fjord Ore Spawnpoint 43 Cobalt'),
(@GUID2+42,@POOL+42,@CHANCE2, 'Howling Fjord Ore Spawnpoint 43 Rich Cobalt'),
(@GUID1+43,@POOL+43,@CHANCE1, 'Howling Fjord Ore Spawnpoint 44 Cobalt'),
(@GUID2+43,@POOL+43,@CHANCE2, 'Howling Fjord Ore Spawnpoint 44 Rich Cobalt'),
(@GUID1+44,@POOL+44,@CHANCE1, 'Howling Fjord Ore Spawnpoint 45 Cobalt'),
(@GUID2+44,@POOL+44,@CHANCE2, 'Howling Fjord Ore Spawnpoint 45 Rich Cobalt'),
(@GUID1+45,@POOL+45,@CHANCE1, 'Howling Fjord Ore Spawnpoint 46 Cobalt'),
(@GUID2+45,@POOL+45,@CHANCE2, 'Howling Fjord Ore Spawnpoint 46 Rich Cobalt'),
(@GUID1+46,@POOL+46,@CHANCE1, 'Howling Fjord Ore Spawnpoint 47 Cobalt'),
(@GUID2+46,@POOL+46,@CHANCE2, 'Howling Fjord Ore Spawnpoint 47 Rich Cobalt'),
(@GUID1+47,@POOL+47,@CHANCE1, 'Howling Fjord Ore Spawnpoint 48 Cobalt'),
(@GUID2+47,@POOL+47,@CHANCE2, 'Howling Fjord Ore Spawnpoint 48 Rich Cobalt'),
(@GUID1+48,@POOL+48,@CHANCE1, 'Howling Fjord Ore Spawnpoint 49 Cobalt'),
(@GUID2+48,@POOL+48,@CHANCE2, 'Howling Fjord Ore Spawnpoint 49 Rich Cobalt'),
(@GUID1+49,@POOL+49,@CHANCE1, 'Howling Fjord Ore Spawnpoint 50 Cobalt'),
(@GUID2+49,@POOL+49,@CHANCE2, 'Howling Fjord Ore Spawnpoint 50 Rich Cobalt'),
(@GUID1+50,@POOL+50,@CHANCE1, 'Howling Fjord Ore Spawnpoint 51 Cobalt'),
(@GUID2+50,@POOL+50,@CHANCE2, 'Howling Fjord Ore Spawnpoint 51 Rich Cobalt'),
(@GUID1+51,@POOL+51,@CHANCE1, 'Howling Fjord Ore Spawnpoint 52 Cobalt'),
(@GUID2+51,@POOL+51,@CHANCE2, 'Howling Fjord Ore Spawnpoint 52 Rich Cobalt'),
(@GUID1+52,@POOL+52,@CHANCE1, 'Howling Fjord Ore Spawnpoint 53 Cobalt'),
(@GUID2+52,@POOL+52,@CHANCE2, 'Howling Fjord Ore Spawnpoint 53 Rich Cobalt'),
(@GUID1+53,@POOL+53,@CHANCE1, 'Howling Fjord Ore Spawnpoint 54 Cobalt'),
(@GUID2+53,@POOL+53,@CHANCE2, 'Howling Fjord Ore Spawnpoint 54 Rich Cobalt'),
(@GUID1+54,@POOL+54,@CHANCE1, 'Howling Fjord Ore Spawnpoint 55 Cobalt'),
(@GUID2+54,@POOL+54,@CHANCE2, 'Howling Fjord Ore Spawnpoint 55 Rich Cobalt'),
(@GUID1+55,@POOL+55,@CHANCE1, 'Howling Fjord Ore Spawnpoint 56 Cobalt'),
(@GUID2+55,@POOL+55,@CHANCE2, 'Howling Fjord Ore Spawnpoint 56 Rich Cobalt'),
(@GUID1+56,@POOL+56,@CHANCE1, 'Howling Fjord Ore Spawnpoint 57 Cobalt'),
(@GUID2+56,@POOL+56,@CHANCE2, 'Howling Fjord Ore Spawnpoint 57 Rich Cobalt'),
(@GUID1+57,@POOL+57,@CHANCE1, 'Howling Fjord Ore Spawnpoint 58 Cobalt'),
(@GUID2+57,@POOL+57,@CHANCE2, 'Howling Fjord Ore Spawnpoint 58 Rich Cobalt'),
(@GUID1+58,@POOL+58,@CHANCE1, 'Howling Fjord Ore Spawnpoint 59 Cobalt'),
(@GUID2+58,@POOL+58,@CHANCE2, 'Howling Fjord Ore Spawnpoint 59 Rich Cobalt'),
(@GUID1+59,@POOL+59,@CHANCE1, 'Howling Fjord Ore Spawnpoint 60 Cobalt'),
(@GUID2+59,@POOL+59,@CHANCE2, 'Howling Fjord Ore Spawnpoint 60 Rich Cobalt'),
(@GUID1+60,@POOL+60,@CHANCE1, 'Howling Fjord Ore Spawnpoint 61 Cobalt'),
(@GUID2+60,@POOL+60,@CHANCE2, 'Howling Fjord Ore Spawnpoint 61 Rich Cobalt'),
(@GUID1+61,@POOL+61,@CHANCE1, 'Howling Fjord Ore Spawnpoint 62 Cobalt'),
(@GUID2+61,@POOL+61,@CHANCE2, 'Howling Fjord Ore Spawnpoint 62 Rich Cobalt'),
(@GUID1+62,@POOL+62,@CHANCE1, 'Howling Fjord Ore Spawnpoint 63 Cobalt'),
(@GUID2+62,@POOL+62,@CHANCE2, 'Howling Fjord Ore Spawnpoint 63 Rich Cobalt'),
(@GUID1+63,@POOL+63,@CHANCE1, 'Howling Fjord Ore Spawnpoint 64 Cobalt'),
(@GUID2+63,@POOL+63,@CHANCE2, 'Howling Fjord Ore Spawnpoint 64 Rich Cobalt'),
(@GUID1+64,@POOL+64,@CHANCE1, 'Howling Fjord Ore Spawnpoint 65 Cobalt'),
(@GUID2+64,@POOL+64,@CHANCE2, 'Howling Fjord Ore Spawnpoint 65 Rich Cobalt'),
(@GUID1+65,@POOL+65,@CHANCE1, 'Howling Fjord Ore Spawnpoint 66 Cobalt'),
(@GUID2+65,@POOL+65,@CHANCE2, 'Howling Fjord Ore Spawnpoint 66 Rich Cobalt'),
(@GUID1+66,@POOL+66,@CHANCE1, 'Howling Fjord Ore Spawnpoint 67 Cobalt'),
(@GUID2+66,@POOL+66,@CHANCE2, 'Howling Fjord Ore Spawnpoint 67 Rich Cobalt'),
(@GUID1+67,@POOL+67,@CHANCE1, 'Howling Fjord Ore Spawnpoint 68 Cobalt'),
(@GUID2+67,@POOL+67,@CHANCE2, 'Howling Fjord Ore Spawnpoint 68 Rich Cobalt'),
(@GUID1+68,@POOL+68,@CHANCE1, 'Howling Fjord Ore Spawnpoint 69 Cobalt'),
(@GUID2+68,@POOL+68,@CHANCE2, 'Howling Fjord Ore Spawnpoint 69 Rich Cobalt'),
(@GUID1+69,@POOL+69,@CHANCE1, 'Howling Fjord Ore Spawnpoint 70 Cobalt'),
(@GUID2+69,@POOL+69,@CHANCE2, 'Howling Fjord Ore Spawnpoint 70 Rich Cobalt'),
(@GUID1+70,@POOL+70,@CHANCE1, 'Howling Fjord Ore Spawnpoint 71 Cobalt'),
(@GUID2+70,@POOL+70,@CHANCE2, 'Howling Fjord Ore Spawnpoint 71 Rich Cobalt'),
(@GUID1+71,@POOL+71,@CHANCE1, 'Howling Fjord Ore Spawnpoint 72 Cobalt'),
(@GUID2+71,@POOL+71,@CHANCE2, 'Howling Fjord Ore Spawnpoint 72 Rich Cobalt'),
(@GUID1+72,@POOL+72,@CHANCE1, 'Howling Fjord Ore Spawnpoint 73 Cobalt'),
(@GUID2+72,@POOL+72,@CHANCE2, 'Howling Fjord Ore Spawnpoint 73 Rich Cobalt'),
(@GUID1+73,@POOL+73,@CHANCE1, 'Howling Fjord Ore Spawnpoint 74 Cobalt'),
(@GUID2+73,@POOL+73,@CHANCE2, 'Howling Fjord Ore Spawnpoint 74 Rich Cobalt'),
(@GUID1+74,@POOL+74,@CHANCE1, 'Howling Fjord Ore Spawnpoint 75 Cobalt'),
(@GUID2+74,@POOL+74,@CHANCE2, 'Howling Fjord Ore Spawnpoint 75 Rich Cobalt'),
(@GUID1+75,@POOL+75,@CHANCE1, 'Howling Fjord Ore Spawnpoint 76 Cobalt'),
(@GUID2+75,@POOL+75,@CHANCE2, 'Howling Fjord Ore Spawnpoint 76 Rich Cobalt'),
(@GUID1+76,@POOL+76,@CHANCE1, 'Howling Fjord Ore Spawnpoint 77 Cobalt'),
(@GUID2+76,@POOL+76,@CHANCE2, 'Howling Fjord Ore Spawnpoint 77 Rich Cobalt'),
(@GUID1+77,@POOL+77,@CHANCE1, 'Howling Fjord Ore Spawnpoint 78 Cobalt'),
(@GUID2+77,@POOL+77,@CHANCE2, 'Howling Fjord Ore Spawnpoint 78 Rich Cobalt'),
(@GUID1+78,@POOL+78,@CHANCE1, 'Howling Fjord Ore Spawnpoint 79 Cobalt'),
(@GUID2+78,@POOL+78,@CHANCE2, 'Howling Fjord Ore Spawnpoint 79 Rich Cobalt'),
(@GUID1+79,@POOL+79,@CHANCE1, 'Howling Fjord Ore Spawnpoint 80 Cobalt'),
(@GUID2+79,@POOL+79,@CHANCE2, 'Howling Fjord Ore Spawnpoint 80 Rich Cobalt'),
(@GUID1+80,@POOL+80,@CHANCE1, 'Howling Fjord Ore Spawnpoint 81 Cobalt'),
(@GUID2+80,@POOL+80,@CHANCE2, 'Howling Fjord Ore Spawnpoint 81 Rich Cobalt'),
(@GUID1+81,@POOL+81,@CHANCE1, 'Howling Fjord Ore Spawnpoint 82 Cobalt'),
(@GUID2+81,@POOL+81,@CHANCE2, 'Howling Fjord Ore Spawnpoint 82 Rich Cobalt'),
(@GUID1+82,@POOL+82,@CHANCE1, 'Howling Fjord Ore Spawnpoint 83 Cobalt'),
(@GUID2+82,@POOL+82,@CHANCE2, 'Howling Fjord Ore Spawnpoint 83 Rich Cobalt'),
(@GUID1+83,@POOL+83,@CHANCE1, 'Howling Fjord Ore Spawnpoint 84 Cobalt'),
(@GUID2+83,@POOL+83,@CHANCE2, 'Howling Fjord Ore Spawnpoint 84 Rich Cobalt'),
(@GUID1+84,@POOL+84,@CHANCE1, 'Howling Fjord Ore Spawnpoint 85 Cobalt'),
(@GUID2+84,@POOL+84,@CHANCE2, 'Howling Fjord Ore Spawnpoint 85 Rich Cobalt'),
(@GUID1+85,@POOL+85,@CHANCE1, 'Howling Fjord Ore Spawnpoint 86 Cobalt'),
(@GUID2+85,@POOL+85,@CHANCE2, 'Howling Fjord Ore Spawnpoint 86 Rich Cobalt'),
(@GUID1+86,@POOL+86,@CHANCE1, 'Howling Fjord Ore Spawnpoint 87 Cobalt'),
(@GUID2+86,@POOL+86,@CHANCE2, 'Howling Fjord Ore Spawnpoint 87 Rich Cobalt'),
(@GUID1+87,@POOL+87,@CHANCE1, 'Howling Fjord Ore Spawnpoint 88 Cobalt'),
(@GUID2+87,@POOL+87,@CHANCE2, 'Howling Fjord Ore Spawnpoint 88 Rich Cobalt'),
(@GUID1+88,@POOL+88,@CHANCE1, 'Howling Fjord Ore Spawnpoint 89 Cobalt'),
(@GUID2+88,@POOL+88,@CHANCE2, 'Howling Fjord Ore Spawnpoint 89 Rich Cobalt'),
(@GUID1+89,@POOL+89,@CHANCE1, 'Howling Fjord Ore Spawnpoint 90 Cobalt'),
(@GUID2+89,@POOL+89,@CHANCE2, 'Howling Fjord Ore Spawnpoint 90 Rich Cobalt'),
(@GUID1+90,@POOL+90,@CHANCE1, 'Howling Fjord Ore Spawnpoint 91 Cobalt'),
(@GUID2+90,@POOL+90,@CHANCE2, 'Howling Fjord Ore Spawnpoint 91 Rich Cobalt'),
(@GUID1+91,@POOL+91,@CHANCE1, 'Howling Fjord Ore Spawnpoint 92 Cobalt'),
(@GUID2+91,@POOL+91,@CHANCE2, 'Howling Fjord Ore Spawnpoint 92 Rich Cobalt'),
(@GUID1+92,@POOL+92,@CHANCE1, 'Howling Fjord Ore Spawnpoint 93 Cobalt'),
(@GUID2+92,@POOL+92,@CHANCE2, 'Howling Fjord Ore Spawnpoint 93 Rich Cobalt'),
(@GUID1+93,@POOL+93,@CHANCE1, 'Howling Fjord Ore Spawnpoint 94 Cobalt'),
(@GUID2+93,@POOL+93,@CHANCE2, 'Howling Fjord Ore Spawnpoint 94 Rich Cobalt'),
(@GUID1+94,@POOL+94,@CHANCE1, 'Howling Fjord Ore Spawnpoint 95 Cobalt'),
(@GUID2+94,@POOL+94,@CHANCE2, 'Howling Fjord Ore Spawnpoint 95 Rich Cobalt'),
(@GUID1+95,@POOL+95,@CHANCE1, 'Howling Fjord Ore Spawnpoint 96 Cobalt'),
(@GUID2+95,@POOL+95,@CHANCE2, 'Howling Fjord Ore Spawnpoint 96 Rich Cobalt'),
(@GUID1+96,@POOL+96,@CHANCE1, 'Howling Fjord Ore Spawnpoint 97 Cobalt'),
(@GUID2+96,@POOL+96,@CHANCE2, 'Howling Fjord Ore Spawnpoint 97 Rich Cobalt'),
(@GUID1+97,@POOL+97,@CHANCE1, 'Howling Fjord Ore Spawnpoint 98 Cobalt'),
(@GUID2+97,@POOL+97,@CHANCE2, 'Howling Fjord Ore Spawnpoint 98 Rich Cobalt'),
(@GUID1+98,@POOL+98,@CHANCE1, 'Howling Fjord Ore Spawnpoint 99 Cobalt'),
(@GUID2+98,@POOL+98,@CHANCE2, 'Howling Fjord Ore Spawnpoint 99 Rich Cobalt'),
(@GUID1+99,@POOL+99,@CHANCE1, 'Howling Fjord Ore Spawnpoint 100 Cobalt'),
(@GUID2+99,@POOL+99,@CHANCE2, 'Howling Fjord Ore Spawnpoint 100 Rich Cobalt');
-- Add each pool to pool template
DELETE FROM `pool_template` WHERE `entry` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+0,1, 'Howling Fjord Ore Spawnpoint 1'),
(@POOL+1,1, 'Howling Fjord Ore Spawnpoint 2'),
(@POOL+2,1, 'Howling Fjord Ore Spawnpoint 3'),
(@POOL+3,1, 'Howling Fjord Ore Spawnpoint 4'),
(@POOL+4,1, 'Howling Fjord Ore Spawnpoint 5'),
(@POOL+5,1, 'Howling Fjord Ore Spawnpoint 6'),
(@POOL+6,1, 'Howling Fjord Ore Spawnpoint 7'),
(@POOL+7,1, 'Howling Fjord Ore Spawnpoint 8'),
(@POOL+8,1, 'Howling Fjord Ore Spawnpoint 9'),
(@POOL+9,1, 'Howling Fjord Ore Spawnpoint 10'),
(@POOL+10,1, 'Howling Fjord Ore Spawnpoint 11'),
(@POOL+11,1, 'Howling Fjord Ore Spawnpoint 12'),
(@POOL+12,1, 'Howling Fjord Ore Spawnpoint 13'),
(@POOL+13,1, 'Howling Fjord Ore Spawnpoint 14'),
(@POOL+14,1, 'Howling Fjord Ore Spawnpoint 15'),
(@POOL+15,1, 'Howling Fjord Ore Spawnpoint 16'),
(@POOL+16,1, 'Howling Fjord Ore Spawnpoint 17'),
(@POOL+17,1, 'Howling Fjord Ore Spawnpoint 18'),
(@POOL+18,1, 'Howling Fjord Ore Spawnpoint 19'),
(@POOL+19,1, 'Howling Fjord Ore Spawnpoint 20'),
(@POOL+20,1, 'Howling Fjord Ore Spawnpoint 21'),
(@POOL+21,1, 'Howling Fjord Ore Spawnpoint 22'),
(@POOL+22,1, 'Howling Fjord Ore Spawnpoint 23'),
(@POOL+23,1, 'Howling Fjord Ore Spawnpoint 24'),
(@POOL+24,1, 'Howling Fjord Ore Spawnpoint 25'),
(@POOL+25,1, 'Howling Fjord Ore Spawnpoint 26'),
(@POOL+26,1, 'Howling Fjord Ore Spawnpoint 27'),
(@POOL+27,1, 'Howling Fjord Ore Spawnpoint 28'),
(@POOL+28,1, 'Howling Fjord Ore Spawnpoint 29'),
(@POOL+29,1, 'Howling Fjord Ore Spawnpoint 30'),
(@POOL+30,1, 'Howling Fjord Ore Spawnpoint 31'),
(@POOL+31,1, 'Howling Fjord Ore Spawnpoint 32'),
(@POOL+32,1, 'Howling Fjord Ore Spawnpoint 33'),
(@POOL+33,1, 'Howling Fjord Ore Spawnpoint 34'),
(@POOL+34,1, 'Howling Fjord Ore Spawnpoint 35'),
(@POOL+35,1, 'Howling Fjord Ore Spawnpoint 36'),
(@POOL+36,1, 'Howling Fjord Ore Spawnpoint 37'),
(@POOL+37,1, 'Howling Fjord Ore Spawnpoint 38'),
(@POOL+38,1, 'Howling Fjord Ore Spawnpoint 39'),
(@POOL+39,1, 'Howling Fjord Ore Spawnpoint 40'),
(@POOL+40,1, 'Howling Fjord Ore Spawnpoint 41'),
(@POOL+41,1, 'Howling Fjord Ore Spawnpoint 42'),
(@POOL+42,1, 'Howling Fjord Ore Spawnpoint 43'),
(@POOL+43,1, 'Howling Fjord Ore Spawnpoint 44'),
(@POOL+44,1, 'Howling Fjord Ore Spawnpoint 45'),
(@POOL+45,1, 'Howling Fjord Ore Spawnpoint 46'),
(@POOL+46,1, 'Howling Fjord Ore Spawnpoint 47'),
(@POOL+47,1, 'Howling Fjord Ore Spawnpoint 48'),
(@POOL+48,1, 'Howling Fjord Ore Spawnpoint 49'),
(@POOL+49,1, 'Howling Fjord Ore Spawnpoint 50'),
(@POOL+50,1, 'Howling Fjord Ore Spawnpoint 51'),
(@POOL+51,1, 'Howling Fjord Ore Spawnpoint 52'),
(@POOL+52,1, 'Howling Fjord Ore Spawnpoint 53'),
(@POOL+53,1, 'Howling Fjord Ore Spawnpoint 54'),
(@POOL+54,1, 'Howling Fjord Ore Spawnpoint 55'),
(@POOL+55,1, 'Howling Fjord Ore Spawnpoint 56'),
(@POOL+56,1, 'Howling Fjord Ore Spawnpoint 57'),
(@POOL+57,1, 'Howling Fjord Ore Spawnpoint 58'),
(@POOL+58,1, 'Howling Fjord Ore Spawnpoint 59'),
(@POOL+59,1, 'Howling Fjord Ore Spawnpoint 60'),
(@POOL+60,1, 'Howling Fjord Ore Spawnpoint 61'),
(@POOL+61,1, 'Howling Fjord Ore Spawnpoint 62'),
(@POOL+62,1, 'Howling Fjord Ore Spawnpoint 63'),
(@POOL+63,1, 'Howling Fjord Ore Spawnpoint 64'),
(@POOL+64,1, 'Howling Fjord Ore Spawnpoint 65'),
(@POOL+65,1, 'Howling Fjord Ore Spawnpoint 66'),
(@POOL+66,1, 'Howling Fjord Ore Spawnpoint 67'),
(@POOL+67,1, 'Howling Fjord Ore Spawnpoint 68'),
(@POOL+68,1, 'Howling Fjord Ore Spawnpoint 69'),
(@POOL+69,1, 'Howling Fjord Ore Spawnpoint 70'),
(@POOL+70,1, 'Howling Fjord Ore Spawnpoint 71'),
(@POOL+71,1, 'Howling Fjord Ore Spawnpoint 72'),
(@POOL+72,1, 'Howling Fjord Ore Spawnpoint 73'),
(@POOL+73,1, 'Howling Fjord Ore Spawnpoint 74'),
(@POOL+74,1, 'Howling Fjord Ore Spawnpoint 75'),
(@POOL+75,1, 'Howling Fjord Ore Spawnpoint 76'),
(@POOL+76,1, 'Howling Fjord Ore Spawnpoint 77'),
(@POOL+77,1, 'Howling Fjord Ore Spawnpoint 78'),
(@POOL+78,1, 'Howling Fjord Ore Spawnpoint 79'),
(@POOL+79,1, 'Howling Fjord Ore Spawnpoint 80'),
(@POOL+80,1, 'Howling Fjord Ore Spawnpoint 81'),
(@POOL+81,1, 'Howling Fjord Ore Spawnpoint 82'),
(@POOL+82,1, 'Howling Fjord Ore Spawnpoint 83'),
(@POOL+83,1, 'Howling Fjord Ore Spawnpoint 84'),
(@POOL+84,1, 'Howling Fjord Ore Spawnpoint 85'),
(@POOL+85,1, 'Howling Fjord Ore Spawnpoint 86'),
(@POOL+86,1, 'Howling Fjord Ore Spawnpoint 87'),
(@POOL+87,1, 'Howling Fjord Ore Spawnpoint 88'),
(@POOL+88,1, 'Howling Fjord Ore Spawnpoint 89'),
(@POOL+89,1, 'Howling Fjord Ore Spawnpoint 90'),
(@POOL+90,1, 'Howling Fjord Ore Spawnpoint 91'),
(@POOL+91,1, 'Howling Fjord Ore Spawnpoint 92'),
(@POOL+92,1, 'Howling Fjord Ore Spawnpoint 93'),
(@POOL+93,1, 'Howling Fjord Ore Spawnpoint 94'),
(@POOL+94,1, 'Howling Fjord Ore Spawnpoint 95'),
(@POOL+95,1, 'Howling Fjord Ore Spawnpoint 96'),
(@POOL+96,1, 'Howling Fjord Ore Spawnpoint 97'),
(@POOL+97,1, 'Howling Fjord Ore Spawnpoint 98'),
(@POOL+98,1, 'Howling Fjord Ore Spawnpoint 99'),
(@POOL+99,1, 'Howling Fjord Ore Spawnpoint 100');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER,@ACTIVE, 'Howling Fjord Ore Mother pool');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+0,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 1'),
(@POOL+1,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 2'),
(@POOL+2,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 3'),
(@POOL+3,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 4'),
(@POOL+4,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 5'),
(@POOL+5,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 6'),
(@POOL+6,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 7'),
(@POOL+7,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 8'),
(@POOL+8,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 9'),
(@POOL+9,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 10'),
(@POOL+10,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 11'),
(@POOL+11,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 12'),
(@POOL+12,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 13'),
(@POOL+13,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 14'),
(@POOL+14,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 15'),
(@POOL+15,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 16'),
(@POOL+16,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 17'),
(@POOL+17,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 18'),
(@POOL+18,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 19'),
(@POOL+19,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 20'),
(@POOL+20,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 21'),
(@POOL+21,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 22'),
(@POOL+22,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 23'),
(@POOL+23,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 24'),
(@POOL+24,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 25'),
(@POOL+25,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 26'),
(@POOL+26,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 27'),
(@POOL+27,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 28'),
(@POOL+28,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 29'),
(@POOL+29,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 30'),
(@POOL+30,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 31'),
(@POOL+31,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 32'),
(@POOL+32,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 33'),
(@POOL+33,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 34'),
(@POOL+34,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 35'),
(@POOL+35,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 36'),
(@POOL+36,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 37'),
(@POOL+37,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 38'),
(@POOL+38,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 39'),
(@POOL+39,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 40'),
(@POOL+40,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 41'),
(@POOL+41,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 42'),
(@POOL+42,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 43'),
(@POOL+43,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 44'),
(@POOL+44,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 45'),
(@POOL+45,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 46'),
(@POOL+46,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 47'),
(@POOL+47,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 48'),
(@POOL+48,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 49'),
(@POOL+49,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 50'),
(@POOL+50,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 51'),
(@POOL+51,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 52'),
(@POOL+52,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 53'),
(@POOL+53,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 54'),
(@POOL+54,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 55'),
(@POOL+55,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 56'),
(@POOL+56,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 57'),
(@POOL+57,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 58'),
(@POOL+58,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 59'),
(@POOL+59,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 60'),
(@POOL+60,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 61'),
(@POOL+61,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 62'),
(@POOL+62,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 63'),
(@POOL+63,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 64'),
(@POOL+64,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 65'),
(@POOL+65,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 66'),
(@POOL+66,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 67'),
(@POOL+67,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 68'),
(@POOL+68,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 69'),
(@POOL+69,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 70'),
(@POOL+70,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 71'),
(@POOL+71,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 72'),
(@POOL+72,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 73'),
(@POOL+73,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 74'),
(@POOL+74,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 75'),
(@POOL+75,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 76'),
(@POOL+76,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 77'),
(@POOL+77,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 78'),
(@POOL+78,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 79'),
(@POOL+79,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 80'),
(@POOL+80,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 81'),
(@POOL+81,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 82'),
(@POOL+82,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 83'),
(@POOL+83,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 84'),
(@POOL+84,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 85'),
(@POOL+85,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 86'),
(@POOL+86,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 87'),
(@POOL+87,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 88'),
(@POOL+88,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 89'),
(@POOL+89,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 90'),
(@POOL+90,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 91'),
(@POOL+91,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 92'),
(@POOL+92,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 93'),
(@POOL+93,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 94'),
(@POOL+94,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 95'),
(@POOL+95,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 96'),
(@POOL+96,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 97'),
(@POOL+97,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 98'),
(@POOL+98,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 99'),
(@POOL+99,@MOTHER,0, 'Howling Fjord Ore Spawnpoint 100');

-- ----------------------------------------
-- -- Fixup ore spawns for Grizzly Hills --
-- ----------------------------------------
SET @RANGE    := 100;
SET @GUID1    := 160600;
SET @GUID2    := @GUID1 + @RANGE;
SET @POOL     := 10300;
SET @LASTGUID := 60;
SET @CHANCE1  := 90;
SET @CHANCE2  := 100 - @CHANCE1;
SET @MOTHER   := 9902;
SET @ACTIVE   := 20; -- Max number of active spawns
SET @TIMER    := 600; -- Respawn timer in seconds
-- Remove Ore spawns from Grizzly Hills
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y < -1550 AND position_y > -2380 AND `position_x` < 4650  AND `position_x` > 3090;
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y < -2380 AND position_y > -3160 AND `position_x` < 4560  AND `position_x` > 3090;
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y < -3160 AND position_y > -5800 AND `position_x` < 4850  AND `position_x` > 3090;
DELETE FROM gameobject WHERE id IN (189978,189979) AND map=571 AND position_y < -3604 AND position_y > -5800 AND `position_x` < 5470  AND `position_x` > 4850 AND `position_z` < 380;
-- Remove old pools
DELETE FROM `pool_gameobject` WHERE `guid` NOT IN (SELECT `guid` FROM `gameobject`);
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5181 AND 5216;
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5240 AND 5243;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5182 AND 5216;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5240 AND 5243;
-- Colbalt Deposits Grizzly Hills
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID1,189978,571,1,1,3092.010,-3250.750,239.4220,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+1,189978,571,1,1,3245.520,-4263.030,346.3790,-1.71042,0,0,0,1,@TIMER,255,1),
(@GUID1+2,189978,571,1,1,3278.070,-4631.530,274.2350,2.79252,0,0,0,1,@TIMER,255,1),
(@GUID1+3,189978,571,1,1,3297.320,-4432.250,323.8490,-1.71042,0,0,0,1,@TIMER,255,1),
(@GUID1+4,189978,571,1,1,3304.730,-1804.230,85.4142,2.82743,0,0,0,1,@TIMER,255,1),
(@GUID1+5,189978,571,1,1,3330.480,-4922.170,305.9250,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID1+6,189978,571,1,1,3374.104,-4776.897,274.4394,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID1+7,189978,571,1,1,3402.580,-1772.610,93.7937,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+8,189978,571,1,1,3482.790,-3444.500,267.0810,0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+9,189978,571,1,1,3504.310,-5246.790,179.1390,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID1+10,189978,571,1,1,3505.110,-4140.870,264.1560,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID1+11,189978,571,1,1,3523.270,-2664.510,104.2180,-2.18166,0,0,0,1,@TIMER,255,1),
(@GUID1+12,189978,571,1,1,3543.850,-5054.890,234.0610,2.80997,0,0,0,1,@TIMER,255,1),
(@GUID1+13,189978,571,1,1,3546.450,-1799.920,161.3730,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID1+14,189978,571,1,1,3555.420,-3562.350,242.5690,0.19199,0,0,0,1,@TIMER,255,1),
(@GUID1+15,189978,571,1,1,3562.720,-5167.090,179.5770,-2.75761,0,0,0,1,@TIMER,255,1),
(@GUID1+16,189978,571,1,1,3593.700,-3737.760,231.2620,-3.12412,0,0,0,1,@TIMER,255,1),
(@GUID1+17,189978,571,1,1,3634.340,-2647.850,137.6100,1.13446,0,0,0,1,@TIMER,255,1),
(@GUID1+18,189978,571,1,1,3683.020,-1787.160,170.3800,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+19,189978,571,1,1,3684.690,-2654.980,152.8360,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+20,189978,571,1,1,3689.440,-5363.480,107.9370,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID1+21,189978,571,1,1,3775.340,-3570.330,235.9720,2.39110,0,0,0,1,@TIMER,255,1),
(@GUID1+22,189978,571,1,1,3776.570,-2395.590,173.3690,-0.41888,0,0,0,1,@TIMER,255,1),
(@GUID1+23,189978,571,1,1,3779.940,-3770.120,179.4740,0.85521,0,0,0,1,@TIMER,255,1),
(@GUID1+24,189978,571,1,1,3806.770,-3351.670,282.0970,-1.98967,0,0,0,1,@TIMER,255,1),
(@GUID1+25,189978,571,1,1,3808.300,-1743.320,203.5550,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID1+26,189978,571,1,1,3819.070,-2721.720,200.3380,-0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+27,189978,571,1,1,3823.790,-1846.020,215.9370,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID1+28,189978,571,1,1,3887.610,-3704.440,173.5850,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+29,189978,571,1,1,3892.340,-5151.140,73.8241,-1.53589,0,0,0,1,@TIMER,255,1),
(@GUID1+30,189978,571,1,1,3931.060,-1655.190,190.6440,1.37881,0,0,0,1,@TIMER,255,1),
(@GUID1+31,189978,571,1,3,3932.550,-3970.730,174.8070,-1.97222,0,0,0,1,@TIMER,255,1),
(@GUID1+32,189978,571,1,1,3943.470,-1843.410,217.4480,2.60053,0,0,0,1,@TIMER,255,1),
(@GUID1+33,189978,571,1,1,4101.430,-2955.460,270.9040,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID1+34,189978,571,1,1,4109.900,-2432.630,221.0930,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID1+35,189978,571,1,1,4128.130,-3959.530,160.6620,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID1+36,189978,571,1,1,4151.420,-4614.510,144.2710,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID1+37,189978,571,1,1,4152.130,-1891.690,187.4210,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID1+38,189978,571,1,1,4172.300,-3685.310,186.9110,-1.23918,0,0,0,1,@TIMER,255,1),
(@GUID1+39,189978,571,1,1,4196.390,-1995.750,211.0920,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+40,189978,571,1,1,4208.140,-3133.170,282.3300,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID1+41,189978,571,1,1,4220.520,-3803.550,185.4780,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+42,189978,571,1,1,4303.788,-4978.636,23.5756,2.75761,0,0,0,1,@TIMER,255,1),
(@GUID1+43,189978,571,1,1,4408.610,-2408.180,228.9980,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+44,189978,571,1,1,4448.330,-4800.280,40.7411,-2.33874,0,0,0,1,@TIMER,255,1),
(@GUID1+45,189978,571,1,1,4560.060,-2319.040,181.0760,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID1+46,189978,571,1,1,4560.340,-4972.120,48.4352,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID1+47,189978,571,1,1,4584.810,-4561.060,196.2030,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID1+48,189978,571,1,1,4585.620,-3743.730,233.2730,-1.67551,0,0,0,1,@TIMER,255,1),
(@GUID1+49,189978,571,1,1,4641.260,-3944.710,249.8200,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID1+50,189978,571,1,1,4731.170,-3974.150,202.9880,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+51,189978,571,1,1,4734.590,-4548.180,206.8140,-0.36652,0,0,0,1,@TIMER,255,1),
(@GUID1+52,189978,571,1,1,4774.960,-4882.750,58.8890,-2.39110,0,0,0,1,@TIMER,255,1),
(@GUID1+53,189978,571,1,1,4782.520,-3895.370,187.3920,2.60054,0,0,0,1,@TIMER,255,1),
(@GUID1+54,189978,571,1,1,4823.120,-3888.860,183.0190,2.75761,0,0,0,1,@TIMER,255,1),
(@GUID1+55,189978,571,1,1,4830.860,-4477.090,200.1495,1.39626,0,0,0,1,@TIMER,255,1),
(@GUID1+56,189978,571,1,1,4882.170,-4206.040,253.2890,-0.19199,0,0,0,1,@TIMER,255,1),
(@GUID1+57,189978,571,1,1,4934.329,-4555.055,220.0529,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID1+58,189978,571,1,1,4956.457,-4666.764,214.5148,2.79252,0,0,0,1,@TIMER,255,1),
(@GUID1+59,189978,571,1,1,5018.210,-4794.480,217.7570,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+60,189978,571,1,1,5060.030,-4828.330,212.2340,0.85521,0,0,0,1,@TIMER,255,1);
-- Rich Colbalt Deposits Grizzly Hills
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID2,189979,571,1,1,3092.010,-3250.750,239.4220,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+1,189979,571,1,1,3245.520,-4263.030,346.3790,-1.71042,0,0,0,1,@TIMER,255,1),
(@GUID2+2,189979,571,1,1,3278.070,-4631.530,274.2350,2.79252,0,0,0,1,@TIMER,255,1),
(@GUID2+3,189979,571,1,1,3297.320,-4432.250,323.8490,-1.71042,0,0,0,1,@TIMER,255,1),
(@GUID2+4,189979,571,1,1,3304.730,-1804.230,85.4142,2.82743,0,0,0,1,@TIMER,255,1),
(@GUID2+5,189979,571,1,1,3330.480,-4922.170,305.9250,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID2+6,189979,571,1,1,3374.104,-4776.897,274.4394,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID2+7,189979,571,1,1,3402.580,-1772.610,93.7937,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+8,189979,571,1,1,3482.790,-3444.500,267.0810,0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+9,189979,571,1,1,3504.310,-5246.790,179.1390,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID2+10,189979,571,1,1,3505.110,-4140.870,264.1560,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID2+11,189979,571,1,1,3523.270,-2664.510,104.2180,-2.18166,0,0,0,1,@TIMER,255,1),
(@GUID2+12,189979,571,1,1,3543.850,-5054.890,234.0610,2.80997,0,0,0,1,@TIMER,255,1),
(@GUID2+13,189979,571,1,1,3546.450,-1799.920,161.3730,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID2+14,189979,571,1,1,3555.420,-3562.350,242.5690,0.19199,0,0,0,1,@TIMER,255,1),
(@GUID2+15,189979,571,1,1,3562.720,-5167.090,179.5770,-2.75761,0,0,0,1,@TIMER,255,1),
(@GUID2+16,189979,571,1,1,3593.700,-3737.760,231.2620,-3.12412,0,0,0,1,@TIMER,255,1),
(@GUID2+17,189979,571,1,1,3634.340,-2647.850,137.6100,1.13446,0,0,0,1,@TIMER,255,1),
(@GUID2+18,189979,571,1,1,3683.020,-1787.160,170.3800,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+19,189979,571,1,1,3684.690,-2654.980,152.8360,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+20,189979,571,1,1,3689.440,-5363.480,107.9370,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID2+21,189979,571,1,1,3775.340,-3570.330,235.9720,2.39110,0,0,0,1,@TIMER,255,1),
(@GUID2+22,189979,571,1,1,3776.570,-2395.590,173.3690,-0.41888,0,0,0,1,@TIMER,255,1),
(@GUID2+23,189979,571,1,1,3779.940,-3770.120,179.4740,0.85521,0,0,0,1,@TIMER,255,1),
(@GUID2+24,189979,571,1,1,3806.770,-3351.670,282.0970,-1.98967,0,0,0,1,@TIMER,255,1),
(@GUID2+25,189979,571,1,1,3808.300,-1743.320,203.5550,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID2+26,189979,571,1,1,3819.070,-2721.720,200.3380,-0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+27,189979,571,1,1,3823.790,-1846.020,215.9370,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID2+28,189979,571,1,1,3887.610,-3704.440,173.5850,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+29,189979,571,1,1,3892.340,-5151.140,73.8241,-1.53589,0,0,0,1,@TIMER,255,1),
(@GUID2+30,189979,571,1,1,3931.060,-1655.190,190.6440,1.37881,0,0,0,1,@TIMER,255,1),
(@GUID2+31,189979,571,1,3,3932.550,-3970.730,174.8070,-1.97222,0,0,0,1,@TIMER,255,1),
(@GUID2+32,189979,571,1,1,3943.470,-1843.410,217.4480,2.60053,0,0,0,1,@TIMER,255,1),
(@GUID2+33,189979,571,1,1,4101.430,-2955.460,270.9040,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID2+34,189979,571,1,1,4109.900,-2432.630,221.0930,3.14159,0,0,0,1,@TIMER,255,1),
(@GUID2+35,189979,571,1,1,4128.130,-3959.530,160.6620,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID2+36,189979,571,1,1,4151.420,-4614.510,144.2710,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID2+37,189979,571,1,1,4152.130,-1891.690,187.4210,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID2+38,189979,571,1,1,4172.300,-3685.310,186.9110,-1.23918,0,0,0,1,@TIMER,255,1),
(@GUID2+39,189979,571,1,1,4196.390,-1995.750,211.0920,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+40,189979,571,1,1,4208.140,-3133.170,282.3300,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID2+41,189979,571,1,1,4220.520,-3803.550,185.4780,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+42,189979,571,1,1,4303.788,-4978.636,23.5756,2.75761,0,0,0,1,@TIMER,255,1),
(@GUID2+43,189979,571,1,1,4408.610,-2408.180,228.9980,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+44,189979,571,1,1,4448.330,-4800.280,40.7411,-2.33874,0,0,0,1,@TIMER,255,1),
(@GUID2+45,189979,571,1,1,4560.060,-2319.040,181.0760,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID2+46,189979,571,1,1,4560.340,-4972.120,48.4352,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID2+47,189979,571,1,1,4584.810,-4561.060,196.2030,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID2+48,189979,571,1,1,4585.620,-3743.730,233.2730,-1.67551,0,0,0,1,@TIMER,255,1),
(@GUID2+49,189979,571,1,1,4641.260,-3944.710,249.8200,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID2+50,189979,571,1,1,4731.170,-3974.150,202.9880,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+51,189979,571,1,1,4734.590,-4548.180,206.8140,-0.36652,0,0,0,1,@TIMER,255,1),
(@GUID2+52,189979,571,1,1,4774.960,-4882.750,58.8890,-2.39110,0,0,0,1,@TIMER,255,1),
(@GUID2+53,189979,571,1,1,4782.520,-3895.370,187.3920,2.60054,0,0,0,1,@TIMER,255,1),
(@GUID2+54,189979,571,1,1,4823.120,-3888.860,183.0190,2.75761,0,0,0,1,@TIMER,255,1),
(@GUID2+55,189979,571,1,1,4830.860,-4477.090,200.1495,1.39626,0,0,0,1,@TIMER,255,1),
(@GUID2+56,189979,571,1,1,4882.170,-4206.040,253.2890,-0.19199,0,0,0,1,@TIMER,255,1),
(@GUID2+57,189979,571,1,1,4934.329,-4555.055,220.0529,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID2+58,189979,571,1,1,4956.457,-4666.764,214.5148,2.79252,0,0,0,1,@TIMER,255,1),
(@GUID2+59,189979,571,1,1,5018.210,-4794.480,217.7570,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+60,189979,571,1,1,5060.030,-4828.330,212.2340,0.85521,0,0,0,1,@TIMER,255,1);
-- Pooling
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID1 AND @GUID1+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID2 AND @GUID2+@LASTGUID;
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+0,@POOL+0,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 1 Cobalt'),
(@GUID2+0,@POOL+0,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 1 Rich Cobalt'),
(@GUID1+1,@POOL+1,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 2 Cobalt'),
(@GUID2+1,@POOL+1,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 2 Rich Cobalt'),
(@GUID1+2,@POOL+2,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 3 Cobalt'),
(@GUID2+2,@POOL+2,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 3 Rich Cobalt'),
(@GUID1+3,@POOL+3,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 4 Cobalt'),
(@GUID2+3,@POOL+3,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 4 Rich Cobalt'),
(@GUID1+4,@POOL+4,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 5 Cobalt'),
(@GUID2+4,@POOL+4,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 5 Rich Cobalt'),
(@GUID1+5,@POOL+5,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 6 Cobalt'),
(@GUID2+5,@POOL+5,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 6 Rich Cobalt'),
(@GUID1+6,@POOL+6,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 7 Cobalt'),
(@GUID2+6,@POOL+6,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 7 Rich Cobalt'),
(@GUID1+7,@POOL+7,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 8 Cobalt'),
(@GUID2+7,@POOL+7,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 8 Rich Cobalt'),
(@GUID1+8,@POOL+8,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 9 Cobalt'),
(@GUID2+8,@POOL+8,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 9 Rich Cobalt'),
(@GUID1+9,@POOL+9,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 10 Cobalt'),
(@GUID2+9,@POOL+9,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 10 Rich Cobalt'),
(@GUID1+10,@POOL+10,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 11 Cobalt'),
(@GUID2+10,@POOL+10,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 11 Rich Cobalt'),
(@GUID1+11,@POOL+11,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 12 Cobalt'),
(@GUID2+11,@POOL+11,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 12 Rich Cobalt'),
(@GUID1+12,@POOL+12,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 13 Cobalt'),
(@GUID2+12,@POOL+12,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 13 Rich Cobalt'),
(@GUID1+13,@POOL+13,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 14 Cobalt'),
(@GUID2+13,@POOL+13,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 14 Rich Cobalt'),
(@GUID1+14,@POOL+14,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 15 Cobalt'),
(@GUID2+14,@POOL+14,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 15 Rich Cobalt'),
(@GUID1+15,@POOL+15,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 16 Cobalt'),
(@GUID2+15,@POOL+15,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 16 Rich Cobalt'),
(@GUID1+16,@POOL+16,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 17 Cobalt'),
(@GUID2+16,@POOL+16,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 17 Rich Cobalt'),
(@GUID1+17,@POOL+17,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 18 Cobalt'),
(@GUID2+17,@POOL+17,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 18 Rich Cobalt'),
(@GUID1+18,@POOL+18,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 19 Cobalt'),
(@GUID2+18,@POOL+18,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 19 Rich Cobalt'),
(@GUID1+19,@POOL+19,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 20 Cobalt'),
(@GUID2+19,@POOL+19,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 20 Rich Cobalt'),
(@GUID1+20,@POOL+20,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 21 Cobalt'),
(@GUID2+20,@POOL+20,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 21 Rich Cobalt'),
(@GUID1+21,@POOL+21,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 22 Cobalt'),
(@GUID2+21,@POOL+21,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 22 Rich Cobalt'),
(@GUID1+22,@POOL+22,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 23 Cobalt'),
(@GUID2+22,@POOL+22,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 23 Rich Cobalt'),
(@GUID1+23,@POOL+23,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 24 Cobalt'),
(@GUID2+23,@POOL+23,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 24 Rich Cobalt'),
(@GUID1+24,@POOL+24,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 25 Cobalt'),
(@GUID2+24,@POOL+24,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 25 Rich Cobalt'),
(@GUID1+25,@POOL+25,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 26 Cobalt'),
(@GUID2+25,@POOL+25,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 26 Rich Cobalt'),
(@GUID1+26,@POOL+26,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 27 Cobalt'),
(@GUID2+26,@POOL+26,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 27 Rich Cobalt'),
(@GUID1+27,@POOL+27,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 28 Cobalt'),
(@GUID2+27,@POOL+27,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 28 Rich Cobalt'),
(@GUID1+28,@POOL+28,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 29 Cobalt'),
(@GUID2+28,@POOL+28,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 29 Rich Cobalt'),
(@GUID1+29,@POOL+29,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 30 Cobalt'),
(@GUID2+29,@POOL+29,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 30 Rich Cobalt'),
(@GUID1+30,@POOL+30,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 31 Cobalt'),
(@GUID2+30,@POOL+30,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 31 Rich Cobalt'),
(@GUID1+31,@POOL+31,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 32 Cobalt'),
(@GUID2+31,@POOL+31,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 32 Rich Cobalt'),
(@GUID1+32,@POOL+32,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 33 Cobalt'),
(@GUID2+32,@POOL+32,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 33 Rich Cobalt'),
(@GUID1+33,@POOL+33,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 34 Cobalt'),
(@GUID2+33,@POOL+33,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 34 Rich Cobalt'),
(@GUID1+34,@POOL+34,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 35 Cobalt'),
(@GUID2+34,@POOL+34,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 35 Rich Cobalt'),
(@GUID1+35,@POOL+35,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 36 Cobalt'),
(@GUID2+35,@POOL+35,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 36 Rich Cobalt'),
(@GUID1+36,@POOL+36,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 37 Cobalt'),
(@GUID2+36,@POOL+36,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 37 Rich Cobalt'),
(@GUID1+37,@POOL+37,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 38 Cobalt'),
(@GUID2+37,@POOL+37,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 38 Rich Cobalt'),
(@GUID1+38,@POOL+38,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 39 Cobalt'),
(@GUID2+38,@POOL+38,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 39 Rich Cobalt'),
(@GUID1+39,@POOL+39,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 40 Cobalt'),
(@GUID2+39,@POOL+39,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 40 Rich Cobalt'),
(@GUID1+40,@POOL+40,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 41 Cobalt'),
(@GUID2+40,@POOL+40,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 41 Rich Cobalt'),
(@GUID1+41,@POOL+41,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 42 Cobalt'),
(@GUID2+41,@POOL+41,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 42 Rich Cobalt'),
(@GUID1+42,@POOL+42,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 43 Cobalt'),
(@GUID2+42,@POOL+42,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 43 Rich Cobalt'),
(@GUID1+43,@POOL+43,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 44 Cobalt'),
(@GUID2+43,@POOL+43,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 44 Rich Cobalt'),
(@GUID1+44,@POOL+44,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 45 Cobalt'),
(@GUID2+44,@POOL+44,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 45 Rich Cobalt'),
(@GUID1+45,@POOL+45,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 46 Cobalt'),
(@GUID2+45,@POOL+45,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 46 Rich Cobalt'),
(@GUID1+46,@POOL+46,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 47 Cobalt'),
(@GUID2+46,@POOL+46,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 47 Rich Cobalt'),
(@GUID1+47,@POOL+47,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 48 Cobalt'),
(@GUID2+47,@POOL+47,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 48 Rich Cobalt'),
(@GUID1+48,@POOL+48,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 49 Cobalt'),
(@GUID2+48,@POOL+48,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 49 Rich Cobalt'),
(@GUID1+49,@POOL+49,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 50 Cobalt'),
(@GUID2+49,@POOL+49,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 50 Rich Cobalt'),
(@GUID1+50,@POOL+50,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 51 Cobalt'),
(@GUID2+50,@POOL+50,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 51 Rich Cobalt'),
(@GUID1+51,@POOL+51,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 52 Cobalt'),
(@GUID2+51,@POOL+51,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 52 Rich Cobalt'),
(@GUID1+52,@POOL+52,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 53 Cobalt'),
(@GUID2+52,@POOL+52,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 53 Rich Cobalt'),
(@GUID1+53,@POOL+53,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 54 Cobalt'),
(@GUID2+53,@POOL+53,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 54 Rich Cobalt'),
(@GUID1+54,@POOL+54,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 55 Cobalt'),
(@GUID2+54,@POOL+54,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 55 Rich Cobalt'),
(@GUID1+55,@POOL+55,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 56 Cobalt'),
(@GUID2+55,@POOL+55,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 56 Rich Cobalt'),
(@GUID1+56,@POOL+56,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 57 Cobalt'),
(@GUID2+56,@POOL+56,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 57 Rich Cobalt'),
(@GUID1+57,@POOL+57,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 58 Cobalt'),
(@GUID2+57,@POOL+57,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 58 Rich Cobalt'),
(@GUID1+58,@POOL+58,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 59 Cobalt'),
(@GUID2+58,@POOL+58,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 59 Rich Cobalt'),
(@GUID1+59,@POOL+59,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 60 Cobalt'),
(@GUID2+59,@POOL+59,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 60 Rich Cobalt'),
(@GUID1+60,@POOL+60,@CHANCE1, 'Grizzly Hills Ore Spawnpoint 61 Cobalt'),
(@GUID2+60,@POOL+60,@CHANCE2, 'Grizzly Hills Ore Spawnpoint 61 Rich Cobalt');
-- Add each pool to pool template
DELETE FROM `pool_template` WHERE `entry` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+0,1, 'Grizzly Hills Ore Spawnpoint 1'),
(@POOL+1,1, 'Grizzly Hills Ore Spawnpoint 2'),
(@POOL+2,1, 'Grizzly Hills Ore Spawnpoint 3'),
(@POOL+3,1, 'Grizzly Hills Ore Spawnpoint 4'),
(@POOL+4,1, 'Grizzly Hills Ore Spawnpoint 5'),
(@POOL+5,1, 'Grizzly Hills Ore Spawnpoint 6'),
(@POOL+6,1, 'Grizzly Hills Ore Spawnpoint 7'),
(@POOL+7,1, 'Grizzly Hills Ore Spawnpoint 8'),
(@POOL+8,1, 'Grizzly Hills Ore Spawnpoint 9'),
(@POOL+9,1, 'Grizzly Hills Ore Spawnpoint 10'),
(@POOL+10,1, 'Grizzly Hills Ore Spawnpoint 11'),
(@POOL+11,1, 'Grizzly Hills Ore Spawnpoint 12'),
(@POOL+12,1, 'Grizzly Hills Ore Spawnpoint 13'),
(@POOL+13,1, 'Grizzly Hills Ore Spawnpoint 14'),
(@POOL+14,1, 'Grizzly Hills Ore Spawnpoint 15'),
(@POOL+15,1, 'Grizzly Hills Ore Spawnpoint 16'),
(@POOL+16,1, 'Grizzly Hills Ore Spawnpoint 17'),
(@POOL+17,1, 'Grizzly Hills Ore Spawnpoint 18'),
(@POOL+18,1, 'Grizzly Hills Ore Spawnpoint 19'),
(@POOL+19,1, 'Grizzly Hills Ore Spawnpoint 20'),
(@POOL+20,1, 'Grizzly Hills Ore Spawnpoint 21'),
(@POOL+21,1, 'Grizzly Hills Ore Spawnpoint 22'),
(@POOL+22,1, 'Grizzly Hills Ore Spawnpoint 23'),
(@POOL+23,1, 'Grizzly Hills Ore Spawnpoint 24'),
(@POOL+24,1, 'Grizzly Hills Ore Spawnpoint 25'),
(@POOL+25,1, 'Grizzly Hills Ore Spawnpoint 26'),
(@POOL+26,1, 'Grizzly Hills Ore Spawnpoint 27'),
(@POOL+27,1, 'Grizzly Hills Ore Spawnpoint 28'),
(@POOL+28,1, 'Grizzly Hills Ore Spawnpoint 29'),
(@POOL+29,1, 'Grizzly Hills Ore Spawnpoint 30'),
(@POOL+30,1, 'Grizzly Hills Ore Spawnpoint 31'),
(@POOL+31,1, 'Grizzly Hills Ore Spawnpoint 32'),
(@POOL+32,1, 'Grizzly Hills Ore Spawnpoint 33'),
(@POOL+33,1, 'Grizzly Hills Ore Spawnpoint 34'),
(@POOL+34,1, 'Grizzly Hills Ore Spawnpoint 35'),
(@POOL+35,1, 'Grizzly Hills Ore Spawnpoint 36'),
(@POOL+36,1, 'Grizzly Hills Ore Spawnpoint 37'),
(@POOL+37,1, 'Grizzly Hills Ore Spawnpoint 38'),
(@POOL+38,1, 'Grizzly Hills Ore Spawnpoint 39'),
(@POOL+39,1, 'Grizzly Hills Ore Spawnpoint 40'),
(@POOL+40,1, 'Grizzly Hills Ore Spawnpoint 41'),
(@POOL+41,1, 'Grizzly Hills Ore Spawnpoint 42'),
(@POOL+42,1, 'Grizzly Hills Ore Spawnpoint 43'),
(@POOL+43,1, 'Grizzly Hills Ore Spawnpoint 44'),
(@POOL+44,1, 'Grizzly Hills Ore Spawnpoint 45'),
(@POOL+45,1, 'Grizzly Hills Ore Spawnpoint 46'),
(@POOL+46,1, 'Grizzly Hills Ore Spawnpoint 47'),
(@POOL+47,1, 'Grizzly Hills Ore Spawnpoint 48'),
(@POOL+48,1, 'Grizzly Hills Ore Spawnpoint 49'),
(@POOL+49,1, 'Grizzly Hills Ore Spawnpoint 50'),
(@POOL+50,1, 'Grizzly Hills Ore Spawnpoint 51'),
(@POOL+51,1, 'Grizzly Hills Ore Spawnpoint 52'),
(@POOL+52,1, 'Grizzly Hills Ore Spawnpoint 53'),
(@POOL+53,1, 'Grizzly Hills Ore Spawnpoint 54'),
(@POOL+54,1, 'Grizzly Hills Ore Spawnpoint 55'),
(@POOL+55,1, 'Grizzly Hills Ore Spawnpoint 56'),
(@POOL+56,1, 'Grizzly Hills Ore Spawnpoint 57'),
(@POOL+57,1, 'Grizzly Hills Ore Spawnpoint 58'),
(@POOL+58,1, 'Grizzly Hills Ore Spawnpoint 59'),
(@POOL+59,1, 'Grizzly Hills Ore Spawnpoint 60'),
(@POOL+60,1, 'Grizzly Hills Ore Spawnpoint 61');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER,@ACTIVE, 'Grizzly Hills Ore Mother pool');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+0,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 1'),
(@POOL+1,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 2'),
(@POOL+2,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 3'),
(@POOL+3,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 4'),
(@POOL+4,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 5'),
(@POOL+5,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 6'),
(@POOL+6,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 7'),
(@POOL+7,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 8'),
(@POOL+8,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 9'),
(@POOL+9,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 10'),
(@POOL+10,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 11'),
(@POOL+11,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 12'),
(@POOL+12,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 13'),
(@POOL+13,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 14'),
(@POOL+14,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 15'),
(@POOL+15,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 16'),
(@POOL+16,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 17'),
(@POOL+17,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 18'),
(@POOL+18,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 19'),
(@POOL+19,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 20'),
(@POOL+20,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 21'),
(@POOL+21,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 22'),
(@POOL+22,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 23'),
(@POOL+23,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 24'),
(@POOL+24,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 25'),
(@POOL+25,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 26'),
(@POOL+26,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 27'),
(@POOL+27,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 28'),
(@POOL+28,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 29'),
(@POOL+29,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 30'),
(@POOL+30,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 31'),
(@POOL+31,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 32'),
(@POOL+32,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 33'),
(@POOL+33,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 34'),
(@POOL+34,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 35'),
(@POOL+35,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 36'),
(@POOL+36,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 37'),
(@POOL+37,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 38'),
(@POOL+38,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 39'),
(@POOL+39,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 40'),
(@POOL+40,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 41'),
(@POOL+41,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 42'),
(@POOL+42,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 43'),
(@POOL+43,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 44'),
(@POOL+44,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 45'),
(@POOL+45,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 46'),
(@POOL+46,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 47'),
(@POOL+47,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 48'),
(@POOL+48,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 49'),
(@POOL+49,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 50'),
(@POOL+50,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 51'),
(@POOL+51,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 52'),
(@POOL+52,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 53'),
(@POOL+53,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 54'),
(@POOL+54,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 55'),
(@POOL+55,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 56'),
(@POOL+56,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 57'),
(@POOL+57,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 58'),
(@POOL+58,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 59'),
(@POOL+59,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 60'),
(@POOL+60,@MOTHER,0, 'Grizzly Hills Ore Spawnpoint 61');

-- -----------------------------------
-- -- Fixup ore spawns for Zul'Drak --
-- -----------------------------------
SET @RANGE    := 150;
SET @GUID1    := 161100;
SET @GUID2    := @GUID1 + @RANGE;
SET @POOL     := 10650;
SET @LASTGUID := 92;
SET @CHANCE1  := 90;
SET @CHANCE2  := 100 - @CHANCE1;
SET @MOTHER   := 9904;
SET @ACTIVE   := 30; -- Max number of active spawns
SET @TIMER    := 900; -- Respawn timer in seconds
-- Remove existing Colbalt, Rich Colbalt, & Saronite Deposits from Zul''Drak
DELETE FROM gameobject WHERE id IN (189978,189979,189980) AND map=571 AND position_y < -1100 AND position_y > -3605 AND `position_x` > 4850  AND `position_x` < 6516 ORDER BY position_x;
DELETE FROM gameobject WHERE id IN (189978,189979,189980) AND map=571 AND position_y < -3605 AND position_y > -5500 AND `position_x` > 5100  AND `position_x` < 7000 ORDER BY position_x;
-- Remove old pools
DELETE FROM `pool_gameobject` WHERE `guid` NOT IN (SELECT `guid` FROM `gameobject`);
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5256 AND 5276;
-- Colbalt Deposits Zul'Drak
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID1,189978,571,1,1,4859.570,-2766.920,293.1760,1.39626,0,0,0,1,@TIMER,255,1),
(@GUID1+1,189978,571,1,1,4862.150,-3603.410,307.0340,1.50098,0,0,0,1,@TIMER,255,1),
(@GUID1+2,189978,571,1,1,4865.680,-2458.640,213.6510,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+3,189978,571,1,1,4914.590,-1231.760,174.7320,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID1+4,189978,571,1,1,4930.794,-2900.828,290.6294,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID1+5,189978,571,1,1,4988.300,-3547.630,289.5220,3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+6,189978,571,1,1,5034.149,-3107.575,281.8192,-2.94960,0,0,0,1,@TIMER,255,1),
(@GUID1+7,189978,571,1,1,5068.390,-1175.990,260.7850,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID1+8,189978,571,1,1,5086.030,-1155.550,265.3410,1.48353,0,0,0,1,@TIMER,255,1),
(@GUID1+9,189978,571,1,1,5090.210,-1197.570,267.1280,-2.60053,0,0,0,1,@TIMER,255,1),
(@GUID1+10,189978,571,1,1,5104.010,-1243.180,252.9670,2.25147,0,0,0,1,@TIMER,255,1),
(@GUID1+11,189978,571,1,1,5107.330,-1267.570,262.3820,2.28638,0,0,0,1,@TIMER,255,1),
(@GUID1+12,189978,571,1,1,5118.357,-2138.430,241.0557,2.16421,0,0,0,1,@TIMER,255,1),
(@GUID1+13,189978,571,1,1,5124.540,-2863.140,292.8380,-0.43633,0,0,0,1,@TIMER,255,1),
(@GUID1+14,189978,571,1,1,5126.980,-1597.360,236.5620,-3.05433,0,0,0,1,@TIMER,255,1),
(@GUID1+15,189978,571,1,1,5131.699,-2155.166,239.0023,0.99484,0,0,0,1,@TIMER,255,1),
(@GUID1+16,189978,571,1,1,5131.740,-1276.760,248.3140,3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+17,189978,571,1,1,5138.820,-1427.070,246.8070,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+18,189978,571,1,1,5174.090,-1159.020,257.8510,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID1+19,189978,571,1,1,5179.080,-3316.920,283.7740,-0.90757,0,0,0,1,@TIMER,255,1),
(@GUID1+20,189978,571,1,1,5179.630,-3603.580,295.8630,-0.59341,0,0,0,1,@TIMER,255,1),
(@GUID1+21,189978,571,1,1,5193.190,-3341.850,289.4360,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID1+22,189978,571,1,1,5213.890,-3377.160,290.4010,1.81514,0,0,0,1,@TIMER,255,1),
(@GUID1+23,189978,571,1,1,5239.606,-2370.833,286.3241,0.33161,0,0,0,1,@TIMER,255,1),
(@GUID1+24,189978,571,1,1,5251.932,-2361.378,286.3510,-1.04720,0,0,0,1,@TIMER,255,1),
(@GUID1+25,189978,571,1,1,5272.223,-1614.815,231.3021,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID1+26,189978,571,1,1,5309.277,-3209.399,282.3378,-0.57596,0,0,0,1,@TIMER,255,1),
(@GUID1+27,189978,571,1,1,5309.970,-2060.150,241.4680,1.62316,0,0,0,1,@TIMER,255,1),
(@GUID1+28,189978,571,1,1,5311.820,-3125.220,280.9130,2.84488,0,0,0,1,@TIMER,255,1),
(@GUID1+29,189978,571,1,1,5311.940,-1202.480,246.5990,-1.16937,0,0,0,1,@TIMER,255,1),
(@GUID1+30,189978,571,1,1,5319.037,-4535.752,415.2371,1.18682,0,0,0,1,@TIMER,255,1),
(@GUID1+31,189978,571,1,1,5341.113,-1305.672,238.4332,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+32,189978,571,1,1,5355.556,-2016.313,235.9245,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+33,189978,571,1,1,5364.510,-2058.915,242.2356,2.70526,0,0,0,1,@TIMER,255,1),
(@GUID1+34,189978,571,1,1,5368.401,-3257.874,290.5284,1.30900,0,0,0,1,@TIMER,255,1),
(@GUID1+35,189978,571,1,1,5374.420,-1755.010,240.0630,2.98450,0,0,0,1,@TIMER,255,1),
(@GUID1+36,189978,571,1,1,5380.200,-2170.010,237.1360,-1.32645,0,0,0,1,@TIMER,255,1),
(@GUID1+37,189978,571,1,1,5384.130,-1101.800,185.3190,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+38,189978,571,1,1,5402.130,-1898.590,237.1590,1.74533,0,0,0,1,@TIMER,255,1),
(@GUID1+39,189978,571,1,1,5403.180,-2268.070,243.9030,2.40855,0,0,0,1,@TIMER,255,1),
(@GUID1+40,189978,571,1,1,5410.570,-2534.090,292.4060,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID1+41,189978,571,1,1,5512.260,-1314.160,238.3930,-0.20944,0,0,0,1,@TIMER,255,1),
(@GUID1+42,189978,571,1,1,5517.676,-2101.106,239.9783,-0.71558,0,0,0,1,@TIMER,255,1),
(@GUID1+43,189978,571,1,1,5517.870,-1276.300,239.4080,2.16421,0,0,0,1,@TIMER,255,1),
(@GUID1+44,189978,571,1,1,5546.540,-1721.970,243.6690,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+45,189978,571,1,1,5557.930,-2331.110,287.8600,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID1+46,189978,571,1,1,5566.940,-1860.930,235.2660,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+47,189978,571,1,1,5673.484,-3554.344,373.4818,0.71558,0,0,0,1,@TIMER,255,1),
(@GUID1+48,189978,571,1,1,5697.810,-2317.470,288.6290,1.13446,0,0,0,1,@TIMER,255,1),
(@GUID1+49,189978,571,1,1,5711.410,-3665.910,372.2200,-2.75761,0,0,0,1,@TIMER,255,1),
(@GUID1+50,189978,571,1,1,5714.953,-2415.053,288.1849,2.16421,0,0,0,1,@TIMER,255,1),
(@GUID1+51,189978,571,1,1,5775.913,-3235.525,362.1545,-2.74016,0,0,0,1,@TIMER,255,1),
(@GUID1+52,189978,571,1,1,5840.190,-2309.730,288.2010,-1.08210,0,0,0,1,@TIMER,255,1),
(@GUID1+53,189978,571,1,1,5915.270,-1263.340,261.5160,-2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+54,189978,571,1,1,5953.860,-2800.040,270.2110,-1.04720,0,0,0,1,@TIMER,255,1),
(@GUID1+55,189978,571,1,1,5966.880,-4236.390,358.4940,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+56,189978,571,1,1,5970.190,-2870.240,287.2890,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+57,189978,571,1,1,5971.868,-3366.344,363.9691,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID1+58,189978,571,1,1,5972.123,-3234.955,361.8635,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID1+59,189978,571,1,1,5990.524,-4156.240,377.7000,1.72787,0,0,0,1,@TIMER,255,1),
(@GUID1+60,189978,571,1,1,6033.010,-4086.710,355.1950,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+61,189978,571,1,1,6051.720,-1285.410,503.8380,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+62,189978,571,1,1,6055.426,-4338.665,378.8201,2.60054,0,0,0,1,@TIMER,255,1),
(@GUID1+63,189978,571,1,1,6073.873,-2672.150,293.3498,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+64,189978,571,1,1,6085.920,-1623.470,273.3960,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID1+65,189978,571,1,1,6093.193,-4243.174,319.0197,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID1+66,189978,571,1,1,6106.116,-4426.526,366.1528,-0.95993,0,0,0,1,@TIMER,255,1),
(@GUID1+67,189978,571,1,1,6131.640,-2383.840,301.0840,-0.26180,0,0,0,1,@TIMER,255,1),
(@GUID1+68,189978,571,1,1,6171.825,-3366.969,363.1176,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID1+69,189978,571,1,1,6176.548,-3235.763,362.9467,2.46091,0,0,0,1,@TIMER,255,1),
(@GUID1+70,189978,571,1,1,6217.740,-2238.070,238.7050,-1.97222,0,0,0,1,@TIMER,255,1),
(@GUID1+71,189978,571,1,1,6265.880,-2931.170,307.0120,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+72,189978,571,1,1,6278.610,-2746.580,303.1850,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+73,189978,571,1,1,6280.100,-2592.430,302.3720,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID1+74,189978,571,1,1,6286.331,-2263.173,237.8203,-2.37364,0,0,0,1,@TIMER,255,1),
(@GUID1+75,189978,571,1,1,6286.910,-2671.790,304.4130,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID1+76,189978,571,1,1,6331.420,-2977.620,339.6420,1.67551,0,0,0,1,@TIMER,255,1),
(@GUID1+77,189978,571,1,1,6365.950,-2193.240,272.6010,-0.47124,0,0,0,1,@TIMER,255,1),
(@GUID1+78,189978,571,1,1,6436.630,-3241.960,405.8750,-1.01229,0,0,0,1,@TIMER,255,1),
(@GUID1+79,189978,571,1,1,6439.040,-3330.390,404.9060,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+80,189978,571,1,1,6462.370,-3474.220,388.9030,-0.22689,0,0,0,1,@TIMER,255,1),
(@GUID1+81,189978,571,1,1,6512.855,-4255.316,463.8195,-0.29671,0,0,0,1,@TIMER,255,1),
(@GUID1+82,189978,571,1,1,6515.427,-3485.970,389.0715,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID1+83,189978,571,1,1,6537.952,-4141.421,467.0403,-0.10472,0,0,0,1,@TIMER,255,1),
(@GUID1+84,189978,571,1,1,6564.480,-4107.550,464.1680,1.76278,0,0,0,1,@TIMER,255,1),
(@GUID1+85,189978,571,1,1,6572.520,-4193.380,468.7800,-1.55334,0,0,0,1,@TIMER,255,1),
(@GUID1+86,189978,571,1,1,6579.668,-4053.245,487.2758,-1.18682,0,0,0,1,@TIMER,255,1),
(@GUID1+87,189978,571,1,1,6700.080,-4231.600,461.2990,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+88,189978,571,1,1,6779.470,-4100.770,470.9730,-3.10665,0,0,0,1,@TIMER,255,1),
(@GUID1+89,189978,571,1,1,6792.440,-4281.660,452.8340,0.85521,0,0,0,1,@TIMER,255,1),
(@GUID1+90,189978,571,1,1,6818.135,-4627.391,442.2250,1.34390,0,0,0,1,@TIMER,255,1),
(@GUID1+91,189978,571,1,1,6845.492,-4442.293,444.4835,-0.59341,0,0,0,1,@TIMER,255,1),
(@GUID1+92,189978,571,1,1,6914.570,-4477.570,444.9130,1.55334,0,0,0,1,@TIMER,255,1);
-- Rich Colbalt & Saronite Deposits Zul'Drak
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID2,189979,571,1,1,4859.570,-2766.920,293.1760,1.39626,0,0,0,1,@TIMER,255,1),
(@GUID2+1,189979,571,1,1,4862.150,-3603.410,307.0340,1.50098,0,0,0,1,@TIMER,255,1),
(@GUID2+2,189979,571,1,1,4865.680,-2458.640,213.6510,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+3,189979,571,1,1,4914.590,-1231.760,174.7320,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID2+4,189979,571,1,1,4930.794,-2900.828,290.6294,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID2+5,189979,571,1,1,4988.300,-3547.630,289.5220,3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+6,189979,571,1,1,5034.149,-3107.575,281.8192,-2.94960,0,0,0,1,@TIMER,255,1),
(@GUID2+7,189979,571,1,1,5068.390,-1175.990,260.7850,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID2+8,189979,571,1,1,5086.030,-1155.550,265.3410,1.48353,0,0,0,1,@TIMER,255,1),
(@GUID2+9,189979,571,1,1,5090.210,-1197.570,267.1280,-2.60053,0,0,0,1,@TIMER,255,1),
(@GUID2+10,189979,571,1,1,5104.010,-1243.180,252.9670,2.25147,0,0,0,1,@TIMER,255,1),
(@GUID2+11,189979,571,1,1,5107.330,-1267.570,262.3820,2.28638,0,0,0,1,@TIMER,255,1),
(@GUID2+12,189979,571,1,1,5118.357,-2138.430,241.0557,2.16421,0,0,0,1,@TIMER,255,1),
(@GUID2+13,189979,571,1,1,5124.540,-2863.140,292.8380,-0.43633,0,0,0,1,@TIMER,255,1),
(@GUID2+14,189979,571,1,1,5126.980,-1597.360,236.5620,-3.05433,0,0,0,1,@TIMER,255,1),
(@GUID2+15,189979,571,1,1,5131.699,-2155.166,239.0023,0.99484,0,0,0,1,@TIMER,255,1),
(@GUID2+16,189979,571,1,1,5131.740,-1276.760,248.3140,3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+17,189979,571,1,1,5138.820,-1427.070,246.8070,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+18,189979,571,1,1,5174.090,-1159.020,257.8510,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID2+19,189979,571,1,1,5179.080,-3316.920,283.7740,-0.90757,0,0,0,1,@TIMER,255,1),
(@GUID2+20,189979,571,1,1,5179.630,-3603.580,295.8630,-0.59341,0,0,0,1,@TIMER,255,1),
(@GUID2+21,189979,571,1,1,5193.190,-3341.850,289.4360,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID2+22,189980,571,1,1,5213.890,-3377.160,290.4010,1.81514,0,0,0,1,@TIMER,255,1), -- Saronite
(@GUID2+23,189979,571,1,1,5239.606,-2370.833,286.3241,0.33161,0,0,0,1,@TIMER,255,1),
(@GUID2+24,189979,571,1,1,5251.932,-2361.378,286.3510,-1.04720,0,0,0,1,@TIMER,255,1),
(@GUID2+25,189979,571,1,1,5272.223,-1614.815,231.3021,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID2+26,189979,571,1,1,5309.277,-3209.399,282.3378,-0.57596,0,0,0,1,@TIMER,255,1),
(@GUID2+27,189979,571,1,1,5309.970,-2060.150,241.4680,1.62316,0,0,0,1,@TIMER,255,1),
(@GUID2+28,189979,571,1,1,5311.820,-3125.220,280.9130,2.84488,0,0,0,1,@TIMER,255,1),
(@GUID2+29,189979,571,1,1,5311.940,-1202.480,246.5990,-1.16937,0,0,0,1,@TIMER,255,1),
(@GUID2+30,189979,571,1,1,5319.037,-4535.752,415.2371,1.18682,0,0,0,1,@TIMER,255,1),
(@GUID2+31,189979,571,1,1,5341.113,-1305.672,238.4332,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+32,189979,571,1,1,5355.556,-2016.313,235.9245,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+33,189979,571,1,1,5364.510,-2058.915,242.2356,2.70526,0,0,0,1,@TIMER,255,1),
(@GUID2+34,189979,571,1,1,5368.401,-3257.874,290.5284,1.30900,0,0,0,1,@TIMER,255,1),
(@GUID2+35,189979,571,1,1,5374.420,-1755.010,240.0630,2.98450,0,0,0,1,@TIMER,255,1),
(@GUID2+36,189979,571,1,1,5380.200,-2170.010,237.1360,-1.32645,0,0,0,1,@TIMER,255,1),
(@GUID2+37,189979,571,1,1,5384.130,-1101.800,185.3190,2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+38,189979,571,1,1,5402.130,-1898.590,237.1590,1.74533,0,0,0,1,@TIMER,255,1),
(@GUID2+39,189979,571,1,1,5403.180,-2268.070,243.9030,2.40855,0,0,0,1,@TIMER,255,1),
(@GUID2+40,189979,571,1,1,5410.570,-2534.090,292.4060,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID2+41,189979,571,1,1,5512.260,-1314.160,238.3930,-0.20944,0,0,0,1,@TIMER,255,1),
(@GUID2+42,189979,571,1,1,5517.676,-2101.106,239.9783,-0.71558,0,0,0,1,@TIMER,255,1),
(@GUID2+43,189979,571,1,1,5517.870,-1276.300,239.4080,2.16421,0,0,0,1,@TIMER,255,1),
(@GUID2+44,189979,571,1,1,5546.540,-1721.970,243.6690,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+45,189979,571,1,1,5557.930,-2331.110,287.8600,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID2+46,189980,571,1,1,5566.940,-1860.930,235.2660,-1.79769,0,0,0,1,@TIMER,255,1), -- Saronite
(@GUID2+47,189980,571,1,1,5673.484,-3554.344,373.4818,0.71558,0,0,0,1,@TIMER,255,1), -- Saronite
(@GUID2+48,189979,571,1,1,5697.810,-2317.470,288.6290,1.13446,0,0,0,1,@TIMER,255,1),
(@GUID2+49,189979,571,1,1,5711.410,-3665.910,372.2200,-2.75761,0,0,0,1,@TIMER,255,1),
(@GUID2+50,189979,571,1,1,5714.953,-2415.053,288.1849,2.16421,0,0,0,1,@TIMER,255,1),
(@GUID2+51,189979,571,1,1,5775.913,-3235.525,362.1545,-2.74016,0,0,0,1,@TIMER,255,1),
(@GUID2+52,189979,571,1,1,5840.190,-2309.730,288.2010,-1.08210,0,0,0,1,@TIMER,255,1),
(@GUID2+53,189979,571,1,1,5915.270,-1263.340,261.5160,-2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+54,189979,571,1,1,5953.860,-2800.040,270.2110,-1.04720,0,0,0,1,@TIMER,255,1),
(@GUID2+55,189979,571,1,1,5966.880,-4236.390,358.4940,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+56,189979,571,1,1,5970.190,-2870.240,287.2890,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+57,189979,571,1,1,5971.868,-3366.344,363.9691,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID2+58,189979,571,1,1,5972.123,-3234.955,361.8635,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID2+59,189979,571,1,1,5990.524,-4156.240,377.7000,1.72787,0,0,0,1,@TIMER,255,1),
(@GUID2+60,189979,571,1,1,6033.010,-4086.710,355.1950,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+61,189979,571,1,1,6051.720,-1285.410,503.8380,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+62,189980,571,1,1,6055.426,-4338.665,378.8201,2.60054,0,0,0,1,@TIMER,255,1), -- Saronite
(@GUID2+63,189979,571,1,1,6073.873,-2672.150,293.3498,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+64,189979,571,1,1,6085.920,-1623.470,273.3960,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID2+65,189979,571,1,1,6093.193,-4243.174,319.0197,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID2+66,189979,571,1,1,6106.116,-4426.526,366.1528,-0.95993,0,0,0,1,@TIMER,255,1),
(@GUID2+67,189979,571,1,1,6131.640,-2383.840,301.0840,-0.26180,0,0,0,1,@TIMER,255,1),
(@GUID2+68,189979,571,1,1,6171.825,-3366.969,363.1176,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID2+69,189979,571,1,1,6176.548,-3235.763,362.9467,2.46091,0,0,0,1,@TIMER,255,1),
(@GUID2+70,189979,571,1,1,6217.740,-2238.070,238.7050,-1.97222,0,0,0,1,@TIMER,255,1),
(@GUID2+71,189980,571,1,1,6265.880,-2931.170,307.0120,0.76794,0,0,0,1,@TIMER,255,1), -- Saronite
(@GUID2+72,189979,571,1,1,6278.610,-2746.580,303.1850,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+73,189979,571,1,1,6280.100,-2592.430,302.3720,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID2+74,189980,571,1,1,6286.331,-2263.173,237.8203,-2.37364,0,0,0,1,@TIMER,255,1), -- Saronite
(@GUID2+75,189979,571,1,1,6286.910,-2671.790,304.4130,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID2+76,189979,571,1,1,6331.420,-2977.620,339.6420,1.67551,0,0,0,1,@TIMER,255,1),
(@GUID2+77,189979,571,1,1,6365.950,-2193.240,272.6010,-0.47124,0,0,0,1,@TIMER,255,1),
(@GUID2+78,189979,571,1,1,6436.630,-3241.960,405.8750,-1.01229,0,0,0,1,@TIMER,255,1),
(@GUID2+79,189979,571,1,1,6439.040,-3330.390,404.9060,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+80,189979,571,1,1,6462.370,-3474.220,388.9030,-0.22689,0,0,0,1,@TIMER,255,1),
(@GUID2+81,189979,571,1,1,6512.855,-4255.316,463.8195,-0.29671,0,0,0,1,@TIMER,255,1),
(@GUID2+82,189979,571,1,1,6515.427,-3485.970,389.0715,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID2+83,189979,571,1,1,6537.952,-4141.421,467.0403,-0.10472,0,0,0,1,@TIMER,255,1),
(@GUID2+84,189979,571,1,1,6564.480,-4107.550,464.1680,1.76278,0,0,0,1,@TIMER,255,1),
(@GUID2+85,189979,571,1,1,6572.520,-4193.380,468.7800,-1.55334,0,0,0,1,@TIMER,255,1),
(@GUID2+86,189979,571,1,1,6579.668,-4053.245,487.2758,-1.18682,0,0,0,1,@TIMER,255,1),
(@GUID2+87,189979,571,1,1,6700.080,-4231.600,461.2990,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+88,189979,571,1,1,6779.470,-4100.770,470.9730,-3.10665,0,0,0,1,@TIMER,255,1),
(@GUID2+89,189979,571,1,1,6792.440,-4281.660,452.8340,0.85521,0,0,0,1,@TIMER,255,1),
(@GUID2+90,189979,571,1,1,6818.135,-4627.391,442.2250,1.34390,0,0,0,1,@TIMER,255,1),
(@GUID2+91,189979,571,1,1,6845.492,-4442.293,444.4835,-0.59341,0,0,0,1,@TIMER,255,1),
(@GUID2+92,189979,571,1,1,6914.570,-4477.570,444.9130,1.55334,0,0,0,1,@TIMER,255,1);
-- Pooling
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID1 AND @GUID1+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID2 AND @GUID2+@LASTGUID;
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+0,@POOL+0,@CHANCE1, 'Zul''Drak Ore Spawnpoint 1 Cobalt'),
(@GUID2+0,@POOL+0,@CHANCE2, 'Zul''Drak Ore Spawnpoint 1 Rich Cobalt'),
(@GUID1+1,@POOL+1,@CHANCE1, 'Zul''Drak Ore Spawnpoint 2 Cobalt'),
(@GUID2+1,@POOL+1,@CHANCE2, 'Zul''Drak Ore Spawnpoint 2 Rich Cobalt'),
(@GUID1+2,@POOL+2,@CHANCE1, 'Zul''Drak Ore Spawnpoint 3 Cobalt'),
(@GUID2+2,@POOL+2,@CHANCE2, 'Zul''Drak Ore Spawnpoint 3 Rich Cobalt'),
(@GUID1+3,@POOL+3,@CHANCE1, 'Zul''Drak Ore Spawnpoint 4 Cobalt'),
(@GUID2+3,@POOL+3,@CHANCE2, 'Zul''Drak Ore Spawnpoint 4 Rich Cobalt'),
(@GUID1+4,@POOL+4,@CHANCE1, 'Zul''Drak Ore Spawnpoint 5 Cobalt'),
(@GUID2+4,@POOL+4,@CHANCE2, 'Zul''Drak Ore Spawnpoint 5 Rich Cobalt'),
(@GUID1+5,@POOL+5,@CHANCE1, 'Zul''Drak Ore Spawnpoint 6 Cobalt'),
(@GUID2+5,@POOL+5,@CHANCE2, 'Zul''Drak Ore Spawnpoint 6 Rich Cobalt'),
(@GUID1+6,@POOL+6,@CHANCE1, 'Zul''Drak Ore Spawnpoint 7 Cobalt'),
(@GUID2+6,@POOL+6,@CHANCE2, 'Zul''Drak Ore Spawnpoint 7 Rich Cobalt'),
(@GUID1+7,@POOL+7,@CHANCE1, 'Zul''Drak Ore Spawnpoint 8 Cobalt'),
(@GUID2+7,@POOL+7,@CHANCE2, 'Zul''Drak Ore Spawnpoint 8 Rich Cobalt'),
(@GUID1+8,@POOL+8,@CHANCE1, 'Zul''Drak Ore Spawnpoint 9 Cobalt'),
(@GUID2+8,@POOL+8,@CHANCE2, 'Zul''Drak Ore Spawnpoint 9 Rich Cobalt'),
(@GUID1+9,@POOL+9,@CHANCE1, 'Zul''Drak Ore Spawnpoint 10 Cobalt'),
(@GUID2+9,@POOL+9,@CHANCE2, 'Zul''Drak Ore Spawnpoint 10 Rich Cobalt'),
(@GUID1+10,@POOL+10,@CHANCE1, 'Zul''Drak Ore Spawnpoint 11 Cobalt'),
(@GUID2+10,@POOL+10,@CHANCE2, 'Zul''Drak Ore Spawnpoint 11 Rich Cobalt'),
(@GUID1+11,@POOL+11,@CHANCE1, 'Zul''Drak Ore Spawnpoint 12 Cobalt'),
(@GUID2+11,@POOL+11,@CHANCE2, 'Zul''Drak Ore Spawnpoint 12 Rich Cobalt'),
(@GUID1+12,@POOL+12,@CHANCE1, 'Zul''Drak Ore Spawnpoint 13 Cobalt'),
(@GUID2+12,@POOL+12,@CHANCE2, 'Zul''Drak Ore Spawnpoint 13 Rich Cobalt'),
(@GUID1+13,@POOL+13,@CHANCE1, 'Zul''Drak Ore Spawnpoint 14 Cobalt'),
(@GUID2+13,@POOL+13,@CHANCE2, 'Zul''Drak Ore Spawnpoint 14 Rich Cobalt'),
(@GUID1+14,@POOL+14,@CHANCE1, 'Zul''Drak Ore Spawnpoint 15 Cobalt'),
(@GUID2+14,@POOL+14,@CHANCE2, 'Zul''Drak Ore Spawnpoint 15 Rich Cobalt'),
(@GUID1+15,@POOL+15,@CHANCE1, 'Zul''Drak Ore Spawnpoint 16 Cobalt'),
(@GUID2+15,@POOL+15,@CHANCE2, 'Zul''Drak Ore Spawnpoint 16 Rich Cobalt'),
(@GUID1+16,@POOL+16,@CHANCE1, 'Zul''Drak Ore Spawnpoint 17 Cobalt'),
(@GUID2+16,@POOL+16,@CHANCE2, 'Zul''Drak Ore Spawnpoint 17 Rich Cobalt'),
(@GUID1+17,@POOL+17,@CHANCE1, 'Zul''Drak Ore Spawnpoint 18 Cobalt'),
(@GUID2+17,@POOL+17,@CHANCE2, 'Zul''Drak Ore Spawnpoint 18 Rich Cobalt'),
(@GUID1+18,@POOL+18,@CHANCE1, 'Zul''Drak Ore Spawnpoint 19 Cobalt'),
(@GUID2+18,@POOL+18,@CHANCE2, 'Zul''Drak Ore Spawnpoint 19 Rich Cobalt'),
(@GUID1+19,@POOL+19,@CHANCE1, 'Zul''Drak Ore Spawnpoint 20 Cobalt'),
(@GUID2+19,@POOL+19,@CHANCE2, 'Zul''Drak Ore Spawnpoint 20 Rich Cobalt'),
(@GUID1+20,@POOL+20,@CHANCE1, 'Zul''Drak Ore Spawnpoint 21 Cobalt'),
(@GUID2+20,@POOL+20,@CHANCE2, 'Zul''Drak Ore Spawnpoint 21 Rich Cobalt'),
(@GUID1+21,@POOL+21,@CHANCE1, 'Zul''Drak Ore Spawnpoint 22 Cobalt'),
(@GUID2+21,@POOL+21,@CHANCE2, 'Zul''Drak Ore Spawnpoint 22 Rich Cobalt'),
(@GUID1+22,@POOL+22,@CHANCE1, 'Zul''Drak Ore Spawnpoint 23 Cobalt'),
(@GUID2+22,@POOL+22,@CHANCE2, 'Zul''Drak Ore Spawnpoint 23 Saronite'),
(@GUID1+23,@POOL+23,@CHANCE1, 'Zul''Drak Ore Spawnpoint 24 Cobalt'),
(@GUID2+23,@POOL+23,@CHANCE2, 'Zul''Drak Ore Spawnpoint 24 Rich Cobalt'),
(@GUID1+24,@POOL+24,@CHANCE1, 'Zul''Drak Ore Spawnpoint 25 Cobalt'),
(@GUID2+24,@POOL+24,@CHANCE2, 'Zul''Drak Ore Spawnpoint 25 Rich Cobalt'),
(@GUID1+25,@POOL+25,@CHANCE1, 'Zul''Drak Ore Spawnpoint 26 Cobalt'),
(@GUID2+25,@POOL+25,@CHANCE2, 'Zul''Drak Ore Spawnpoint 26 Rich Cobalt'),
(@GUID1+26,@POOL+26,@CHANCE1, 'Zul''Drak Ore Spawnpoint 27 Cobalt'),
(@GUID2+26,@POOL+26,@CHANCE2, 'Zul''Drak Ore Spawnpoint 27 Rich Cobalt'),
(@GUID1+27,@POOL+27,@CHANCE1, 'Zul''Drak Ore Spawnpoint 28 Cobalt'),
(@GUID2+27,@POOL+27,@CHANCE2, 'Zul''Drak Ore Spawnpoint 28 Rich Cobalt'),
(@GUID1+28,@POOL+28,@CHANCE1, 'Zul''Drak Ore Spawnpoint 29 Cobalt'),
(@GUID2+28,@POOL+28,@CHANCE2, 'Zul''Drak Ore Spawnpoint 29 Rich Cobalt'),
(@GUID1+29,@POOL+29,@CHANCE1, 'Zul''Drak Ore Spawnpoint 30 Cobalt'),
(@GUID2+29,@POOL+29,@CHANCE2, 'Zul''Drak Ore Spawnpoint 30 Rich Cobalt'),
(@GUID1+30,@POOL+30,@CHANCE1, 'Zul''Drak Ore Spawnpoint 31 Cobalt'),
(@GUID2+30,@POOL+30,@CHANCE2, 'Zul''Drak Ore Spawnpoint 31 Rich Cobalt'),
(@GUID1+31,@POOL+31,@CHANCE1, 'Zul''Drak Ore Spawnpoint 32 Cobalt'),
(@GUID2+31,@POOL+31,@CHANCE2, 'Zul''Drak Ore Spawnpoint 32 Rich Cobalt'),
(@GUID1+32,@POOL+32,@CHANCE1, 'Zul''Drak Ore Spawnpoint 33 Cobalt'),
(@GUID2+32,@POOL+32,@CHANCE2, 'Zul''Drak Ore Spawnpoint 33 Rich Cobalt'),
(@GUID1+33,@POOL+33,@CHANCE1, 'Zul''Drak Ore Spawnpoint 34 Cobalt'),
(@GUID2+33,@POOL+33,@CHANCE2, 'Zul''Drak Ore Spawnpoint 34 Rich Cobalt'),
(@GUID1+34,@POOL+34,@CHANCE1, 'Zul''Drak Ore Spawnpoint 35 Cobalt'),
(@GUID2+34,@POOL+34,@CHANCE2, 'Zul''Drak Ore Spawnpoint 35 Rich Cobalt'),
(@GUID1+35,@POOL+35,@CHANCE1, 'Zul''Drak Ore Spawnpoint 36 Cobalt'),
(@GUID2+35,@POOL+35,@CHANCE2, 'Zul''Drak Ore Spawnpoint 36 Rich Cobalt'),
(@GUID1+36,@POOL+36,@CHANCE1, 'Zul''Drak Ore Spawnpoint 37 Cobalt'),
(@GUID2+36,@POOL+36,@CHANCE2, 'Zul''Drak Ore Spawnpoint 37 Rich Cobalt'),
(@GUID1+37,@POOL+37,@CHANCE1, 'Zul''Drak Ore Spawnpoint 38 Cobalt'),
(@GUID2+37,@POOL+37,@CHANCE2, 'Zul''Drak Ore Spawnpoint 38 Rich Cobalt'),
(@GUID1+38,@POOL+38,@CHANCE1, 'Zul''Drak Ore Spawnpoint 39 Cobalt'),
(@GUID2+38,@POOL+38,@CHANCE2, 'Zul''Drak Ore Spawnpoint 39 Rich Cobalt'),
(@GUID1+39,@POOL+39,@CHANCE1, 'Zul''Drak Ore Spawnpoint 40 Cobalt'),
(@GUID2+39,@POOL+39,@CHANCE2, 'Zul''Drak Ore Spawnpoint 40 Rich Cobalt'),
(@GUID1+40,@POOL+40,@CHANCE1, 'Zul''Drak Ore Spawnpoint 41 Cobalt'),
(@GUID2+40,@POOL+40,@CHANCE2, 'Zul''Drak Ore Spawnpoint 41 Rich Cobalt'),
(@GUID1+41,@POOL+41,@CHANCE1, 'Zul''Drak Ore Spawnpoint 42 Cobalt'),
(@GUID2+41,@POOL+41,@CHANCE2, 'Zul''Drak Ore Spawnpoint 42 Rich Cobalt'),
(@GUID1+42,@POOL+42,@CHANCE1, 'Zul''Drak Ore Spawnpoint 43 Cobalt'),
(@GUID2+42,@POOL+42,@CHANCE2, 'Zul''Drak Ore Spawnpoint 43 Rich Cobalt'),
(@GUID1+43,@POOL+43,@CHANCE1, 'Zul''Drak Ore Spawnpoint 44 Cobalt'),
(@GUID2+43,@POOL+43,@CHANCE2, 'Zul''Drak Ore Spawnpoint 44 Rich Cobalt'),
(@GUID1+44,@POOL+44,@CHANCE1, 'Zul''Drak Ore Spawnpoint 45 Cobalt'),
(@GUID2+44,@POOL+44,@CHANCE2, 'Zul''Drak Ore Spawnpoint 45 Rich Cobalt'),
(@GUID1+45,@POOL+45,@CHANCE1, 'Zul''Drak Ore Spawnpoint 46 Cobalt'),
(@GUID2+45,@POOL+45,@CHANCE2, 'Zul''Drak Ore Spawnpoint 46 Rich Cobalt'),
(@GUID1+46,@POOL+46,@CHANCE1, 'Zul''Drak Ore Spawnpoint 47 Cobalt'),
(@GUID2+46,@POOL+46,@CHANCE2, 'Zul''Drak Ore Spawnpoint 47 Saronite'),
(@GUID1+47,@POOL+47,@CHANCE1, 'Zul''Drak Ore Spawnpoint 48 Cobalt'),
(@GUID2+47,@POOL+47,@CHANCE2, 'Zul''Drak Ore Spawnpoint 48 Saronite'),
(@GUID1+48,@POOL+48,@CHANCE1, 'Zul''Drak Ore Spawnpoint 49 Cobalt'),
(@GUID2+48,@POOL+48,@CHANCE2, 'Zul''Drak Ore Spawnpoint 49 Rich Cobalt'),
(@GUID1+49,@POOL+49,@CHANCE1, 'Zul''Drak Ore Spawnpoint 50 Cobalt'),
(@GUID2+49,@POOL+49,@CHANCE2, 'Zul''Drak Ore Spawnpoint 50 Rich Cobalt'),
(@GUID1+50,@POOL+50,@CHANCE1, 'Zul''Drak Ore Spawnpoint 51 Cobalt'),
(@GUID2+50,@POOL+50,@CHANCE2, 'Zul''Drak Ore Spawnpoint 51 Rich Cobalt'),
(@GUID1+51,@POOL+51,@CHANCE1, 'Zul''Drak Ore Spawnpoint 52 Cobalt'),
(@GUID2+51,@POOL+51,@CHANCE2, 'Zul''Drak Ore Spawnpoint 52 Rich Cobalt'),
(@GUID1+52,@POOL+52,@CHANCE1, 'Zul''Drak Ore Spawnpoint 53 Cobalt'),
(@GUID2+52,@POOL+52,@CHANCE2, 'Zul''Drak Ore Spawnpoint 53 Rich Cobalt'),
(@GUID1+53,@POOL+53,@CHANCE1, 'Zul''Drak Ore Spawnpoint 54 Cobalt'),
(@GUID2+53,@POOL+53,@CHANCE2, 'Zul''Drak Ore Spawnpoint 54 Rich Cobalt'),
(@GUID1+54,@POOL+54,@CHANCE1, 'Zul''Drak Ore Spawnpoint 55 Cobalt'),
(@GUID2+54,@POOL+54,@CHANCE2, 'Zul''Drak Ore Spawnpoint 55 Rich Cobalt'),
(@GUID1+55,@POOL+55,@CHANCE1, 'Zul''Drak Ore Spawnpoint 56 Cobalt'),
(@GUID2+55,@POOL+55,@CHANCE2, 'Zul''Drak Ore Spawnpoint 56 Rich Cobalt'),
(@GUID1+56,@POOL+56,@CHANCE1, 'Zul''Drak Ore Spawnpoint 57 Cobalt'),
(@GUID2+56,@POOL+56,@CHANCE2, 'Zul''Drak Ore Spawnpoint 57 Rich Cobalt'),
(@GUID1+57,@POOL+57,@CHANCE1, 'Zul''Drak Ore Spawnpoint 58 Cobalt'),
(@GUID2+57,@POOL+57,@CHANCE2, 'Zul''Drak Ore Spawnpoint 58 Rich Cobalt'),
(@GUID1+58,@POOL+58,@CHANCE1, 'Zul''Drak Ore Spawnpoint 59 Cobalt'),
(@GUID2+58,@POOL+58,@CHANCE2, 'Zul''Drak Ore Spawnpoint 59 Rich Cobalt'),
(@GUID1+59,@POOL+59,@CHANCE1, 'Zul''Drak Ore Spawnpoint 60 Cobalt'),
(@GUID2+59,@POOL+59,@CHANCE2, 'Zul''Drak Ore Spawnpoint 60 Rich Cobalt'),
(@GUID1+60,@POOL+60,@CHANCE1, 'Zul''Drak Ore Spawnpoint 61 Cobalt'),
(@GUID2+60,@POOL+60,@CHANCE2, 'Zul''Drak Ore Spawnpoint 61 Rich Cobalt'),
(@GUID1+61,@POOL+61,@CHANCE1, 'Zul''Drak Ore Spawnpoint 62 Cobalt'),
(@GUID2+61,@POOL+61,@CHANCE2, 'Zul''Drak Ore Spawnpoint 62 Saronite'),
(@GUID1+62,@POOL+62,@CHANCE1, 'Zul''Drak Ore Spawnpoint 63 Cobalt'),
(@GUID2+62,@POOL+62,@CHANCE2, 'Zul''Drak Ore Spawnpoint 63 Rich Cobalt'),
(@GUID1+63,@POOL+63,@CHANCE1, 'Zul''Drak Ore Spawnpoint 64 Cobalt'),
(@GUID2+63,@POOL+63,@CHANCE2, 'Zul''Drak Ore Spawnpoint 64 Rich Cobalt'),
(@GUID1+64,@POOL+64,@CHANCE1, 'Zul''Drak Ore Spawnpoint 65 Cobalt'),
(@GUID2+64,@POOL+64,@CHANCE2, 'Zul''Drak Ore Spawnpoint 65 Rich Cobalt'),
(@GUID1+65,@POOL+65,@CHANCE1, 'Zul''Drak Ore Spawnpoint 66 Cobalt'),
(@GUID2+65,@POOL+65,@CHANCE2, 'Zul''Drak Ore Spawnpoint 66 Rich Cobalt'),
(@GUID1+66,@POOL+66,@CHANCE1, 'Zul''Drak Ore Spawnpoint 67 Cobalt'),
(@GUID2+66,@POOL+66,@CHANCE2, 'Zul''Drak Ore Spawnpoint 67 Rich Cobalt'),
(@GUID1+67,@POOL+67,@CHANCE1, 'Zul''Drak Ore Spawnpoint 68 Cobalt'),
(@GUID2+67,@POOL+67,@CHANCE2, 'Zul''Drak Ore Spawnpoint 68 Rich Cobalt'),
(@GUID1+68,@POOL+68,@CHANCE1, 'Zul''Drak Ore Spawnpoint 69 Cobalt'),
(@GUID2+68,@POOL+68,@CHANCE2, 'Zul''Drak Ore Spawnpoint 69 Rich Cobalt'),
(@GUID1+69,@POOL+69,@CHANCE1, 'Zul''Drak Ore Spawnpoint 70 Cobalt'),
(@GUID2+69,@POOL+69,@CHANCE2, 'Zul''Drak Ore Spawnpoint 70 Rich Cobalt'),
(@GUID1+70,@POOL+70,@CHANCE1, 'Zul''Drak Ore Spawnpoint 71 Cobalt'),
(@GUID2+70,@POOL+70,@CHANCE2, 'Zul''Drak Ore Spawnpoint 71 Saronite'),
(@GUID1+71,@POOL+71,@CHANCE1, 'Zul''Drak Ore Spawnpoint 72 Cobalt'),
(@GUID2+71,@POOL+71,@CHANCE2, 'Zul''Drak Ore Spawnpoint 72 Rich Cobalt'),
(@GUID1+72,@POOL+72,@CHANCE1, 'Zul''Drak Ore Spawnpoint 73 Cobalt'),
(@GUID2+72,@POOL+72,@CHANCE2, 'Zul''Drak Ore Spawnpoint 73 Rich Cobalt'),
(@GUID1+73,@POOL+73,@CHANCE1, 'Zul''Drak Ore Spawnpoint 74 Cobalt'),
(@GUID2+73,@POOL+73,@CHANCE2, 'Zul''Drak Ore Spawnpoint 74 Saronite'),
(@GUID1+74,@POOL+74,@CHANCE1, 'Zul''Drak Ore Spawnpoint 75 Cobalt'),
(@GUID2+74,@POOL+74,@CHANCE2, 'Zul''Drak Ore Spawnpoint 75 Rich Cobalt'),
(@GUID1+75,@POOL+75,@CHANCE1, 'Zul''Drak Ore Spawnpoint 76 Cobalt'),
(@GUID2+75,@POOL+75,@CHANCE2, 'Zul''Drak Ore Spawnpoint 76 Rich Cobalt'),
(@GUID1+76,@POOL+76,@CHANCE1, 'Zul''Drak Ore Spawnpoint 77 Cobalt'),
(@GUID2+76,@POOL+76,@CHANCE2, 'Zul''Drak Ore Spawnpoint 77 Rich Cobalt'),
(@GUID1+77,@POOL+77,@CHANCE1, 'Zul''Drak Ore Spawnpoint 78 Cobalt'),
(@GUID2+77,@POOL+77,@CHANCE2, 'Zul''Drak Ore Spawnpoint 78 Rich Cobalt'),
(@GUID1+78,@POOL+78,@CHANCE1, 'Zul''Drak Ore Spawnpoint 79 Cobalt'),
(@GUID2+78,@POOL+78,@CHANCE2, 'Zul''Drak Ore Spawnpoint 79 Rich Cobalt'),
(@GUID1+79,@POOL+79,@CHANCE1, 'Zul''Drak Ore Spawnpoint 80 Cobalt'),
(@GUID2+79,@POOL+79,@CHANCE2, 'Zul''Drak Ore Spawnpoint 80 Rich Cobalt'),
(@GUID1+80,@POOL+80,@CHANCE1, 'Zul''Drak Ore Spawnpoint 81 Cobalt'),
(@GUID2+80,@POOL+80,@CHANCE2, 'Zul''Drak Ore Spawnpoint 81 Rich Cobalt'),
(@GUID1+81,@POOL+81,@CHANCE1, 'Zul''Drak Ore Spawnpoint 82 Cobalt'),
(@GUID2+81,@POOL+81,@CHANCE2, 'Zul''Drak Ore Spawnpoint 82 Rich Cobalt'),
(@GUID1+82,@POOL+82,@CHANCE1, 'Zul''Drak Ore Spawnpoint 83 Cobalt'),
(@GUID2+82,@POOL+82,@CHANCE2, 'Zul''Drak Ore Spawnpoint 83 Rich Cobalt'),
(@GUID1+83,@POOL+83,@CHANCE1, 'Zul''Drak Ore Spawnpoint 84 Cobalt'),
(@GUID2+83,@POOL+83,@CHANCE2, 'Zul''Drak Ore Spawnpoint 84 Rich Cobalt'),
(@GUID1+84,@POOL+84,@CHANCE1, 'Zul''Drak Ore Spawnpoint 85 Cobalt'),
(@GUID2+84,@POOL+84,@CHANCE2, 'Zul''Drak Ore Spawnpoint 85 Rich Cobalt'),
(@GUID1+85,@POOL+85,@CHANCE1, 'Zul''Drak Ore Spawnpoint 86 Cobalt'),
(@GUID2+85,@POOL+85,@CHANCE2, 'Zul''Drak Ore Spawnpoint 86 Rich Cobalt'),
(@GUID1+86,@POOL+86,@CHANCE1, 'Zul''Drak Ore Spawnpoint 87 Cobalt'),
(@GUID2+86,@POOL+86,@CHANCE2, 'Zul''Drak Ore Spawnpoint 87 Rich Cobalt'),
(@GUID1+87,@POOL+87,@CHANCE1, 'Zul''Drak Ore Spawnpoint 88 Cobalt'),
(@GUID2+87,@POOL+87,@CHANCE2, 'Zul''Drak Ore Spawnpoint 88 Rich Cobalt'),
(@GUID1+88,@POOL+88,@CHANCE1, 'Zul''Drak Ore Spawnpoint 89 Cobalt'),
(@GUID2+88,@POOL+88,@CHANCE2, 'Zul''Drak Ore Spawnpoint 89 Rich Cobalt'),
(@GUID1+89,@POOL+89,@CHANCE1, 'Zul''Drak Ore Spawnpoint 90 Cobalt'),
(@GUID2+89,@POOL+89,@CHANCE2, 'Zul''Drak Ore Spawnpoint 90 Rich Cobalt'),
(@GUID1+90,@POOL+90,@CHANCE1, 'Zul''Drak Ore Spawnpoint 91 Cobalt'),
(@GUID2+90,@POOL+90,@CHANCE2, 'Zul''Drak Ore Spawnpoint 91 Rich Cobalt'),
(@GUID1+91,@POOL+91,@CHANCE1, 'Zul''Drak Ore Spawnpoint 92 Cobalt'),
(@GUID2+91,@POOL+91,@CHANCE2, 'Zul''Drak Ore Spawnpoint 92 Rich Cobalt'),
(@GUID1+92,@POOL+92,@CHANCE1, 'Zul''Drak Ore Spawnpoint 93 Cobalt'),
(@GUID2+92,@POOL+92,@CHANCE2, 'Zul''Drak Ore Spawnpoint 93 Rich Cobalt');
-- Add each pool to pool template
DELETE FROM `pool_template` WHERE `entry` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+0,1, 'Zul''Drak Ore Spawnpoint 1'),
(@POOL+1,1, 'Zul''Drak Ore Spawnpoint 2'),
(@POOL+2,1, 'Zul''Drak Ore Spawnpoint 3'),
(@POOL+3,1, 'Zul''Drak Ore Spawnpoint 4'),
(@POOL+4,1, 'Zul''Drak Ore Spawnpoint 5'),
(@POOL+5,1, 'Zul''Drak Ore Spawnpoint 6'),
(@POOL+6,1, 'Zul''Drak Ore Spawnpoint 7'),
(@POOL+7,1, 'Zul''Drak Ore Spawnpoint 8'),
(@POOL+8,1, 'Zul''Drak Ore Spawnpoint 9'),
(@POOL+9,1, 'Zul''Drak Ore Spawnpoint 10'),
(@POOL+10,1, 'Zul''Drak Ore Spawnpoint 11'),
(@POOL+11,1, 'Zul''Drak Ore Spawnpoint 12'),
(@POOL+12,1, 'Zul''Drak Ore Spawnpoint 13'),
(@POOL+13,1, 'Zul''Drak Ore Spawnpoint 14'),
(@POOL+14,1, 'Zul''Drak Ore Spawnpoint 15'),
(@POOL+15,1, 'Zul''Drak Ore Spawnpoint 16'),
(@POOL+16,1, 'Zul''Drak Ore Spawnpoint 17'),
(@POOL+17,1, 'Zul''Drak Ore Spawnpoint 18'),
(@POOL+18,1, 'Zul''Drak Ore Spawnpoint 19'),
(@POOL+19,1, 'Zul''Drak Ore Spawnpoint 20'),
(@POOL+20,1, 'Zul''Drak Ore Spawnpoint 21'),
(@POOL+21,1, 'Zul''Drak Ore Spawnpoint 22'),
(@POOL+22,1, 'Zul''Drak Ore Spawnpoint 23'),
(@POOL+23,1, 'Zul''Drak Ore Spawnpoint 24'),
(@POOL+24,1, 'Zul''Drak Ore Spawnpoint 25'),
(@POOL+25,1, 'Zul''Drak Ore Spawnpoint 26'),
(@POOL+26,1, 'Zul''Drak Ore Spawnpoint 27'),
(@POOL+27,1, 'Zul''Drak Ore Spawnpoint 28'),
(@POOL+28,1, 'Zul''Drak Ore Spawnpoint 29'),
(@POOL+29,1, 'Zul''Drak Ore Spawnpoint 30'),
(@POOL+30,1, 'Zul''Drak Ore Spawnpoint 31'),
(@POOL+31,1, 'Zul''Drak Ore Spawnpoint 32'),
(@POOL+32,1, 'Zul''Drak Ore Spawnpoint 33'),
(@POOL+33,1, 'Zul''Drak Ore Spawnpoint 34'),
(@POOL+34,1, 'Zul''Drak Ore Spawnpoint 35'),
(@POOL+35,1, 'Zul''Drak Ore Spawnpoint 36'),
(@POOL+36,1, 'Zul''Drak Ore Spawnpoint 37'),
(@POOL+37,1, 'Zul''Drak Ore Spawnpoint 38'),
(@POOL+38,1, 'Zul''Drak Ore Spawnpoint 39'),
(@POOL+39,1, 'Zul''Drak Ore Spawnpoint 40'),
(@POOL+40,1, 'Zul''Drak Ore Spawnpoint 41'),
(@POOL+41,1, 'Zul''Drak Ore Spawnpoint 42'),
(@POOL+42,1, 'Zul''Drak Ore Spawnpoint 43'),
(@POOL+43,1, 'Zul''Drak Ore Spawnpoint 44'),
(@POOL+44,1, 'Zul''Drak Ore Spawnpoint 45'),
(@POOL+45,1, 'Zul''Drak Ore Spawnpoint 46'),
(@POOL+46,1, 'Zul''Drak Ore Spawnpoint 47'),
(@POOL+47,1, 'Zul''Drak Ore Spawnpoint 48'),
(@POOL+48,1, 'Zul''Drak Ore Spawnpoint 49'),
(@POOL+49,1, 'Zul''Drak Ore Spawnpoint 50'),
(@POOL+50,1, 'Zul''Drak Ore Spawnpoint 51'),
(@POOL+51,1, 'Zul''Drak Ore Spawnpoint 52'),
(@POOL+52,1, 'Zul''Drak Ore Spawnpoint 53'),
(@POOL+53,1, 'Zul''Drak Ore Spawnpoint 54'),
(@POOL+54,1, 'Zul''Drak Ore Spawnpoint 55'),
(@POOL+55,1, 'Zul''Drak Ore Spawnpoint 56'),
(@POOL+56,1, 'Zul''Drak Ore Spawnpoint 57'),
(@POOL+57,1, 'Zul''Drak Ore Spawnpoint 58'),
(@POOL+58,1, 'Zul''Drak Ore Spawnpoint 59'),
(@POOL+59,1, 'Zul''Drak Ore Spawnpoint 60'),
(@POOL+60,1, 'Zul''Drak Ore Spawnpoint 61'),
(@POOL+61,1, 'Zul''Drak Ore Spawnpoint 62'),
(@POOL+62,1, 'Zul''Drak Ore Spawnpoint 63'),
(@POOL+63,1, 'Zul''Drak Ore Spawnpoint 64'),
(@POOL+64,1, 'Zul''Drak Ore Spawnpoint 65'),
(@POOL+65,1, 'Zul''Drak Ore Spawnpoint 66'),
(@POOL+66,1, 'Zul''Drak Ore Spawnpoint 67'),
(@POOL+67,1, 'Zul''Drak Ore Spawnpoint 68'),
(@POOL+68,1, 'Zul''Drak Ore Spawnpoint 69'),
(@POOL+69,1, 'Zul''Drak Ore Spawnpoint 70'),
(@POOL+70,1, 'Zul''Drak Ore Spawnpoint 71'),
(@POOL+71,1, 'Zul''Drak Ore Spawnpoint 72'),
(@POOL+72,1, 'Zul''Drak Ore Spawnpoint 73'),
(@POOL+73,1, 'Zul''Drak Ore Spawnpoint 74'),
(@POOL+74,1, 'Zul''Drak Ore Spawnpoint 75'),
(@POOL+75,1, 'Zul''Drak Ore Spawnpoint 76'),
(@POOL+76,1, 'Zul''Drak Ore Spawnpoint 77'),
(@POOL+77,1, 'Zul''Drak Ore Spawnpoint 78'),
(@POOL+78,1, 'Zul''Drak Ore Spawnpoint 79'),
(@POOL+79,1, 'Zul''Drak Ore Spawnpoint 80'),
(@POOL+80,1, 'Zul''Drak Ore Spawnpoint 81'),
(@POOL+81,1, 'Zul''Drak Ore Spawnpoint 82'),
(@POOL+82,1, 'Zul''Drak Ore Spawnpoint 83'),
(@POOL+83,1, 'Zul''Drak Ore Spawnpoint 84'),
(@POOL+84,1, 'Zul''Drak Ore Spawnpoint 85'),
(@POOL+85,1, 'Zul''Drak Ore Spawnpoint 86'),
(@POOL+86,1, 'Zul''Drak Ore Spawnpoint 87'),
(@POOL+87,1, 'Zul''Drak Ore Spawnpoint 88'),
(@POOL+88,1, 'Zul''Drak Ore Spawnpoint 89'),
(@POOL+89,1, 'Zul''Drak Ore Spawnpoint 90'),
(@POOL+90,1, 'Zul''Drak Ore Spawnpoint 91'),
(@POOL+91,1, 'Zul''Drak Ore Spawnpoint 92'),
(@POOL+92,1, 'Zul''Drak Ore Spawnpoint 93');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER,@ACTIVE, 'Zul''Drak Ore Mother pool');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+0,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 1'),
(@POOL+1,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 2'),
(@POOL+2,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 3'),
(@POOL+3,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 4'),
(@POOL+4,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 5'),
(@POOL+5,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 6'),
(@POOL+6,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 7'),
(@POOL+7,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 8'),
(@POOL+8,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 9'),
(@POOL+9,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 10'),
(@POOL+10,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 11'),
(@POOL+11,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 12'),
(@POOL+12,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 13'),
(@POOL+13,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 14'),
(@POOL+14,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 15'),
(@POOL+15,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 16'),
(@POOL+16,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 17'),
(@POOL+17,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 18'),
(@POOL+18,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 19'),
(@POOL+19,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 20'),
(@POOL+20,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 21'),
(@POOL+21,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 22'),
(@POOL+22,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 23'),
(@POOL+23,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 24'),
(@POOL+24,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 25'),
(@POOL+25,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 26'),
(@POOL+26,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 27'),
(@POOL+27,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 28'),
(@POOL+28,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 29'),
(@POOL+29,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 30'),
(@POOL+30,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 31'),
(@POOL+31,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 32'),
(@POOL+32,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 33'),
(@POOL+33,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 34'),
(@POOL+34,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 35'),
(@POOL+35,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 36'),
(@POOL+36,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 37'),
(@POOL+37,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 38'),
(@POOL+38,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 39'),
(@POOL+39,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 40'),
(@POOL+40,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 41'),
(@POOL+41,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 42'),
(@POOL+42,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 43'),
(@POOL+43,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 44'),
(@POOL+44,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 45'),
(@POOL+45,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 46'),
(@POOL+46,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 47'),
(@POOL+47,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 48'),
(@POOL+48,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 49'),
(@POOL+49,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 50'),
(@POOL+50,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 51'),
(@POOL+51,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 52'),
(@POOL+52,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 53'),
(@POOL+53,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 54'),
(@POOL+54,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 55'),
(@POOL+55,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 56'),
(@POOL+56,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 57'),
(@POOL+57,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 58'),
(@POOL+58,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 59'),
(@POOL+59,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 60'),
(@POOL+60,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 61'),
(@POOL+61,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 62'),
(@POOL+62,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 63'),
(@POOL+63,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 64'),
(@POOL+64,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 65'),
(@POOL+65,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 66'),
(@POOL+66,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 67'),
(@POOL+67,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 68'),
(@POOL+68,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 69'),
(@POOL+69,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 70'),
(@POOL+70,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 71'),
(@POOL+71,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 72'),
(@POOL+72,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 73'),
(@POOL+73,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 74'),
(@POOL+74,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 75'),
(@POOL+75,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 76'),
(@POOL+76,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 77'),
(@POOL+77,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 78'),
(@POOL+78,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 79'),
(@POOL+79,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 80'),
(@POOL+80,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 81'),
(@POOL+81,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 82'),
(@POOL+82,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 83'),
(@POOL+83,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 84'),
(@POOL+84,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 85'),
(@POOL+85,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 86'),
(@POOL+86,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 87'),
(@POOL+87,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 88'),
(@POOL+88,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 89'),
(@POOL+89,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 90'),
(@POOL+90,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 91'),
(@POOL+91,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 92'),
(@POOL+92,@MOTHER,0, 'Zul''Drak Ore Spawnpoint 93');

-- -----------------------------------------
-- -- Fixup ore spawns for Sholazar Basin --
-- -----------------------------------------
SET @RANGE    := 350;
SET @GUID1    := 161400;
SET @GUID2    := @GUID1 + @RANGE;
SET @GUID3    := @GUID2 + @RANGE;
SET @POOL     := 10800;
SET @LASTGUID := 111;
SET @CHANCE1  := 75;
SET @CHANCE2  := 15;
SET @CHANCE3  := 10;
SET @MOTHER   := 9905;
SET @ACTIVE   := 35; -- Max number of active spawns
SET @TIMER    := 600; -- Respawn timer in seconds
-- Remove Ore spawns from Sholazar Basin
DELETE FROM gameobject WHERE id IN (189980,189981,191133) AND map=571 AND `position_y` > 3500 AND `position_x` < 6825 AND `position_x` > 4650 AND `position_z` < 300;
DELETE FROM gameobject WHERE id IN (189980,189981,191133) AND map=571 AND `position_y` > 4450 AND `position_x` < 6400 AND `position_x` > 4825 AND `position_z` > 300;
-- Remove old pools
DELETE FROM `pool_gameobject` WHERE `guid` NOT IN (SELECT `guid` FROM `gameobject`);
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5292 AND 5375;
DELETE FROM `pool_template` WHERE `entry`=899;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5292 AND 5375;
-- Saronite Deposits Sholazar Basin
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID1,189980,571,1,1,4704.718,5425.793,-32.3253,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+1,189980,571,1,1,4709.270,4367.730,-31.7133,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+2,189980,571,1,1,4716.542,4978.443,-44.2661,1.62316,0,0,0,1,@TIMER,255,1),
(@GUID1+3,189980,571,1,1,4722.860,5246.860,-42.0046,1.18682,0,0,0,1,@TIMER,255,1),
(@GUID1+4,189980,571,1,1,4724.210,5107.490,-46.3651,-1.78023,0,0,0,1,@TIMER,255,1),
(@GUID1+5,189980,571,1,1,4732.280,5135.100,-53.4326,-1.51844,0,0,0,1,@TIMER,255,1),
(@GUID1+6,189980,571,1,1,4732.570,5036.200,-54.9473,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+7,189980,571,1,1,4737.140,4847.460,-67.2180,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID1+8,189980,571,1,1,4738.390,4691.450,-56.7589,0.50615,0,0,0,1,@TIMER,255,1),
(@GUID1+9,189980,571,1,1,4794.450,5895.830,-30.9455,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID1+10,189980,571,1,1,4837.230,4160.790,-3.6381,-0.62832,0,0,0,1,@TIMER,255,1),
(@GUID1+11,189980,571,1,1,4846.780,5769.550,-57.8889,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID1+12,189980,571,1,1,4847.239,5953.834,-15.9588,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID1+13,189980,571,1,1,4866.020,4570.890,-60.3061,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+14,189980,571,1,1,4884.830,4321.190,-54.8871,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID1+15,189980,571,1,1,4927.281,4328.632,-72.9263,0.59341,0,0,0,1,@TIMER,255,1),
(@GUID1+16,189980,571,1,1,4988.200,5373.050,-94.5907,1.36136,0,0,0,1,@TIMER,255,1),
(@GUID1+17,189980,571,1,1,4993.830,4180.020,-79.1709,0.01745,0,0,0,1,@TIMER,255,1),
(@GUID1+18,189980,571,1,1,5013.689,5436.410,-94.5146,-1.08210,0,0,0,1,@TIMER,255,1),
(@GUID1+19,189980,571,1,1,5015.700,4691.840,-91.0594,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+20,189980,571,1,1,5052.430,5887.010,-69.4098,-1.69297,0,0,0,1,@TIMER,255,1),
(@GUID1+21,189980,571,1,1,5054.910,4412.610,-92.8146,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID1+22,189980,571,1,1,5056.290,4819.880,-132.8840,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID1+23,189980,571,1,1,5062.380,4526.640,-96.4765,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID1+24,189980,571,1,1,5062.479,5031.562,-131.0034,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID1+25,189980,571,1,1,5079.800,5468.130,-88.7503,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+26,189980,571,1,1,5086.370,5098.740,-134.5720,2.07694,0,0,0,1,@TIMER,255,1),
(@GUID1+27,189980,571,1,1,5093.570,4341.180,-82.7253,3.08918,0,0,0,1,@TIMER,255,1),
(@GUID1+28,189980,571,1,1,5094.270,5217.790,-88.3220,-2.21656,0,0,0,1,@TIMER,255,1),
(@GUID1+29,189980,571,1,1,5105.152,4639.756,-135.8839,-1.02974,0,0,0,1,@TIMER,255,1),
(@GUID1+30,189980,571,1,1,5125.490,6015.810,-50.0045,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID1+31,189980,571,1,1,5128.380,4215.860,-83.4258,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID1+32,189980,571,1,1,5159.018,5454.543,-88.2909,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID1+33,189980,571,1,1,5171.400,3794.750,-12.2962,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+34,189980,571,1,1,5190.180,6023.387,-37.9963,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+35,189980,571,1,1,5199.739,5436.705,-81.6717,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID1+36,189980,571,1,1,5226.190,4826.150,-132.7040,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID1+37,189980,571,1,1,5232.450,4195.245,-93.5727,1.67551,0,0,0,1,@TIMER,255,1),
(@GUID1+38,189980,571,1,1,5271.987,5251.519,-124.8593,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID1+39,189980,571,1,1,5277.800,3702.890,12.7941,1.76278,0,0,0,1,@TIMER,255,1),
(@GUID1+40,189980,571,1,1,5309.020,4437.110,-101.2090,2.98450,0,0,0,1,@TIMER,255,1),
(@GUID1+41,189980,571,1,1,5324.950,5368.980,-123.4160,-1.37881,0,0,0,1,@TIMER,255,1),
(@GUID1+42,189980,571,1,1,5325.520,6025.470,-16.2582,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID1+43,189980,571,1,1,5331.860,4405.600,-126.9970,-1.51844,0,0,0,1,@TIMER,255,1),
(@GUID1+44,189980,571,1,1,5333.070,4300.510,-148.0820,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID1+45,189980,571,1,1,5338.952,4182.072,-94.2039,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID1+46,189980,571,1,1,5341.820,5396.050,-106.7450,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+47,189980,571,1,1,5354.230,4820.880,-198.8800,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID1+48,189980,571,1,1,5358.900,4514.820,-127.6330,2.07694,0,0,0,1,@TIMER,255,1),
(@GUID1+49,189980,571,1,1,5385.530,4913.980,-195.3540,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+50,189980,571,1,1,5388.270,4753.330,-198.7980,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+51,189980,571,1,1,5418.620,4371.290,-137.6760,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID1+52,189980,571,1,1,5434.910,3826.250,-65.5299,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+53,189980,571,1,1,5443.155,4694.667,-187.9415,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID1+54,189980,571,1,1,5446.752,5166.048,-133.7927,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+55,189980,571,1,1,5447.930,4519.890,-135.9880,-1.67551,0,0,0,1,@TIMER,255,1),
(@GUID1+56,189980,571,1,1,5449.870,4089.350,-91.0623,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+57,189980,571,1,3,5451.860,5532.250,-101.7700,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID1+58,189980,571,1,1,5455.970,5712.200,-102.7660,-0.59341,0,0,0,1,@TIMER,255,1),
(@GUID1+59,189980,571,1,1,5456.090,4679.770,-173.5170,1.93731,0,0,0,1,@TIMER,255,1),
(@GUID1+60,189980,571,1,1,5461.790,4916.510,-197.1930,-0.62832,0,0,0,1,@TIMER,255,1),
(@GUID1+61,189980,571,1,1,5479.190,4193.700,-97.0735,0.80285,0,0,0,1,@TIMER,255,1),
(@GUID1+62,189980,571,1,1,5482.810,3505.600,7.2101,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID1+63,189980,571,1,1,5483.640,4688.750,-122.0030,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID1+64,189980,571,1,1,5494.615,5677.867,-97.2142,1.93731,0,0,0,1,@TIMER,255,1),
(@GUID1+65,189980,571,1,1,5509.580,3579.710,-12.9631,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+66,189980,571,1,1,5521.060,4926.980,-192.7710,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID1+67,189980,571,1,1,5522.840,3836.810,-62.7052,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID1+68,189980,571,1,1,5528.730,4681.650,-127.0880,0.43633,0,0,0,1,@TIMER,255,1),
(@GUID1+69,189980,571,1,1,5529.634,4501.900,-132.3918,-2.33874,0,0,0,1,@TIMER,255,1),
(@GUID1+70,189980,571,1,1,5537.919,4315.394,-130.2137,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+71,189980,571,1,1,5553.280,3666.730,-28.5651,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+72,189980,571,1,3,5608.650,3865.180,-99.3376,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID1+73,189980,571,1,1,5652.200,3981.090,-83.0324,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID1+74,189980,571,1,3,5656.220,6023.450,-28.9304,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+75,189980,571,1,1,5660.409,3699.911,-13.5126,-2.37364,0,0,0,1,@TIMER,255,1),
(@GUID1+76,189980,571,1,1,5668.259,4118.605,-90.1961,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID1+77,189980,571,1,3,5669.970,5463.910,-68.9469,2.89724,0,0,0,1,@TIMER,255,1),
(@GUID1+78,189980,571,1,1,5671.007,4389.625,-137.5537,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID1+79,189980,571,1,1,5679.051,5598.783,-73.9954,-0.97738,0,0,0,1,@TIMER,255,1),
(@GUID1+80,189980,571,1,1,5682.740,3538.940,-8.8133,-2.35619,0,0,0,1,@TIMER,255,1),
(@GUID1+81,189980,571,1,1,5684.080,5541.490,-72.1058,-1.64061,0,0,0,1,@TIMER,255,1),
(@GUID1+82,189980,571,1,1,5704.426,3884.596,-72.5278,1.86750,0,0,0,1,@TIMER,255,1),
(@GUID1+83,189980,571,1,1,5721.057,3655.517,-25.2488,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+84,189980,571,1,1,5721.060,3655.520,-25.2488,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+85,189980,571,1,1,5735.860,5612.500,-67.5912,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+86,189980,571,1,1,5740.394,5960.094,-36.3629,0.52360,0,0,0,1,@TIMER,255,1),
(@GUID1+87,189980,571,1,1,5762.140,3502.190,8.5711,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID1+88,189980,571,1,1,5827.040,4457.580,-130.4530,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID1+89,189980,571,1,1,5834.000,5370.130,-87.9156,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID1+90,189980,571,1,1,5859.746,4020.988,-68.8248,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID1+91,189980,571,1,3,5861.320,4419.110,-89.7436,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+92,189980,571,1,1,5882.228,5916.372,-25.0905,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID1+93,189980,571,1,1,5945.590,4566.130,-99.4520,1.69297,0,0,0,1,@TIMER,255,1),
(@GUID1+94,189980,571,1,1,6001.920,4160.640,-71.2961,0.83776,0,0,0,1,@TIMER,255,1),
(@GUID1+95,189980,571,1,1,6037.100,4847.040,-93.4030,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+96,189980,571,1,1,6053.300,4795.460,-92.8918,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID1+97,189980,571,1,1,6077.970,4860.720,-94.5449,-1.71042,0,0,0,1,@TIMER,255,1),
(@GUID1+98,189980,571,1,1,6084.560,4079.100,-46.7275,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+99,189980,571,1,1,6096.587,3644.301,143.1275,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID1+100,189980,571,1,1,6107.000,5455.440,-97.4798,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID1+101,189980,571,1,1,6167.440,5256.570,-127.8840,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+102,189980,571,1,3,6173.290,4609.010,-92.2689,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID1+103,189980,571,1,1,6174.170,5636.430,-22.3877,-1.93731,0,0,0,1,@TIMER,255,1),
(@GUID1+104,189980,571,1,1,6205.150,4325.340,-38.2094,-0.05236,0,0,0,1,@TIMER,255,1),
(@GUID1+105,189980,571,1,1,6215.250,5172.350,-97.6636,0.24435,0,0,0,1,@TIMER,255,1),
(@GUID1+106,189980,571,1,1,6229.990,5392.570,-108.9900,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID1+107,189980,571,1,1,6277.390,4221.150,-40.3804,0.59341,0,0,0,1,@TIMER,255,1),
(@GUID1+108,189980,571,1,1,6302.940,5136.300,-81.6133,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID1+109,189980,571,1,1,6310.000,3957.290,109.0570,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+110,189980,571,1,1,6659.690,4690.380,0.1829,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID1+111,189980,571,1,1,6672.220,4932.340,-17.9780,2.94959,0,0,0,1,@TIMER,255,1);
-- Rich Saronite Deposits Sholazar Basin
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID2,189981,571,1,1,4704.718,5425.793,-32.3253,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID2+1,189981,571,1,1,4709.270,4367.730,-31.7133,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+2,189981,571,1,1,4716.542,4978.443,-44.2661,1.62316,0,0,0,1,@TIMER,255,1),
(@GUID2+3,189981,571,1,1,4722.860,5246.860,-42.0046,1.18682,0,0,0,1,@TIMER,255,1),
(@GUID2+4,189981,571,1,1,4724.210,5107.490,-46.3651,-1.78023,0,0,0,1,@TIMER,255,1),
(@GUID2+5,189981,571,1,1,4732.280,5135.100,-53.4326,-1.51844,0,0,0,1,@TIMER,255,1),
(@GUID2+6,189981,571,1,1,4732.570,5036.200,-54.9473,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+7,189981,571,1,1,4737.140,4847.460,-67.2180,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID2+8,189981,571,1,1,4738.390,4691.450,-56.7589,0.50615,0,0,0,1,@TIMER,255,1),
(@GUID2+9,189981,571,1,1,4794.450,5895.830,-30.9455,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID2+10,189981,571,1,1,4837.230,4160.790,-3.6381,-0.62832,0,0,0,1,@TIMER,255,1),
(@GUID2+11,189981,571,1,1,4846.780,5769.550,-57.8889,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID2+12,189981,571,1,1,4847.239,5953.834,-15.9588,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID2+13,189981,571,1,1,4866.020,4570.890,-60.3061,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+14,189981,571,1,1,4884.830,4321.190,-54.8871,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID2+15,189981,571,1,1,4927.281,4328.632,-72.9263,0.59341,0,0,0,1,@TIMER,255,1),
(@GUID2+16,189981,571,1,1,4988.200,5373.050,-94.5907,1.36136,0,0,0,1,@TIMER,255,1),
(@GUID2+17,189981,571,1,1,4993.830,4180.020,-79.1709,0.01745,0,0,0,1,@TIMER,255,1),
(@GUID2+18,189981,571,1,1,5013.689,5436.410,-94.5146,-1.08210,0,0,0,1,@TIMER,255,1),
(@GUID2+19,189981,571,1,1,5015.700,4691.840,-91.0594,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+20,189981,571,1,1,5052.430,5887.010,-69.4098,-1.69297,0,0,0,1,@TIMER,255,1),
(@GUID2+21,189981,571,1,1,5054.910,4412.610,-92.8146,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID2+22,189981,571,1,1,5056.290,4819.880,-132.8840,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID2+23,189981,571,1,1,5062.380,4526.640,-96.4765,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID2+24,189981,571,1,1,5062.479,5031.562,-131.0034,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID2+25,189981,571,1,1,5079.800,5468.130,-88.7503,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+26,189981,571,1,1,5086.370,5098.740,-134.5720,2.07694,0,0,0,1,@TIMER,255,1),
(@GUID2+27,189981,571,1,1,5093.570,4341.180,-82.7253,3.08918,0,0,0,1,@TIMER,255,1),
(@GUID2+28,189981,571,1,1,5094.270,5217.790,-88.3220,-2.21656,0,0,0,1,@TIMER,255,1),
(@GUID2+29,189981,571,1,1,5105.152,4639.756,-135.8839,-1.02974,0,0,0,1,@TIMER,255,1),
(@GUID2+30,189981,571,1,1,5125.490,6015.810,-50.0045,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID2+31,189981,571,1,1,5128.380,4215.860,-83.4258,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID2+32,189981,571,1,1,5159.018,5454.543,-88.2909,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID2+33,189981,571,1,1,5171.400,3794.750,-12.2962,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+34,189981,571,1,1,5190.180,6023.387,-37.9963,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+35,189981,571,1,1,5199.739,5436.705,-81.6717,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID2+36,189981,571,1,1,5226.190,4826.150,-132.7040,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID2+37,189981,571,1,1,5232.450,4195.245,-93.5727,1.67551,0,0,0,1,@TIMER,255,1),
(@GUID2+38,189981,571,1,1,5271.987,5251.519,-124.8593,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID2+39,189981,571,1,1,5277.800,3702.890,12.7941,1.76278,0,0,0,1,@TIMER,255,1),
(@GUID2+40,189981,571,1,1,5309.020,4437.110,-101.2090,2.98450,0,0,0,1,@TIMER,255,1),
(@GUID2+41,189981,571,1,1,5324.950,5368.980,-123.4160,-1.37881,0,0,0,1,@TIMER,255,1),
(@GUID2+42,189981,571,1,1,5325.520,6025.470,-16.2582,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID2+43,189981,571,1,1,5331.860,4405.600,-126.9970,-1.51844,0,0,0,1,@TIMER,255,1),
(@GUID2+44,189981,571,1,1,5333.070,4300.510,-148.0820,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID2+45,189981,571,1,1,5338.952,4182.072,-94.2039,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID2+46,189981,571,1,1,5341.820,5396.050,-106.7450,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+47,189981,571,1,1,5354.230,4820.880,-198.8800,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID2+48,189981,571,1,1,5358.900,4514.820,-127.6330,2.07694,0,0,0,1,@TIMER,255,1),
(@GUID2+49,189981,571,1,1,5385.530,4913.980,-195.3540,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+50,189981,571,1,1,5388.270,4753.330,-198.7980,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+51,189981,571,1,1,5418.620,4371.290,-137.6760,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID2+52,189981,571,1,1,5434.910,3826.250,-65.5299,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+53,189981,571,1,1,5443.155,4694.667,-187.9415,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID2+54,189981,571,1,1,5446.752,5166.048,-133.7927,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+55,189981,571,1,1,5447.930,4519.890,-135.9880,-1.67551,0,0,0,1,@TIMER,255,1),
(@GUID2+56,189981,571,1,1,5449.870,4089.350,-91.0623,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+57,189981,571,1,3,5451.860,5532.250,-101.7700,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID2+58,189981,571,1,1,5455.970,5712.200,-102.7660,-0.59341,0,0,0,1,@TIMER,255,1),
(@GUID2+59,189981,571,1,1,5456.090,4679.770,-173.5170,1.93731,0,0,0,1,@TIMER,255,1),
(@GUID2+60,189981,571,1,1,5461.790,4916.510,-197.1930,-0.62832,0,0,0,1,@TIMER,255,1),
(@GUID2+61,189981,571,1,1,5479.190,4193.700,-97.0735,0.80285,0,0,0,1,@TIMER,255,1),
(@GUID2+62,189981,571,1,1,5482.810,3505.600,7.2101,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID2+63,189981,571,1,1,5483.640,4688.750,-122.0030,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID2+64,189981,571,1,1,5494.615,5677.867,-97.2142,1.93731,0,0,0,1,@TIMER,255,1),
(@GUID2+65,189981,571,1,1,5509.580,3579.710,-12.9631,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+66,189981,571,1,1,5521.060,4926.980,-192.7710,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID2+67,189981,571,1,1,5522.840,3836.810,-62.7052,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID2+68,189981,571,1,1,5528.730,4681.650,-127.0880,0.43633,0,0,0,1,@TIMER,255,1),
(@GUID2+69,189981,571,1,1,5529.634,4501.900,-132.3918,-2.33874,0,0,0,1,@TIMER,255,1),
(@GUID2+70,189981,571,1,1,5537.919,4315.394,-130.2137,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+71,189981,571,1,1,5553.280,3666.730,-28.5651,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID2+72,189981,571,1,3,5608.650,3865.180,-99.3376,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID2+73,189981,571,1,1,5652.200,3981.090,-83.0324,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID2+74,189981,571,1,3,5656.220,6023.450,-28.9304,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+75,189981,571,1,1,5660.409,3699.911,-13.5126,-2.37364,0,0,0,1,@TIMER,255,1),
(@GUID2+76,189981,571,1,1,5668.259,4118.605,-90.1961,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID2+77,189981,571,1,3,5669.970,5463.910,-68.9469,2.89724,0,0,0,1,@TIMER,255,1),
(@GUID2+78,189981,571,1,1,5671.007,4389.625,-137.5537,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID2+79,189981,571,1,1,5679.051,5598.783,-73.9954,-0.97738,0,0,0,1,@TIMER,255,1),
(@GUID2+80,189981,571,1,1,5682.740,3538.940,-8.8133,-2.35619,0,0,0,1,@TIMER,255,1),
(@GUID2+81,189981,571,1,1,5684.080,5541.490,-72.1058,-1.64061,0,0,0,1,@TIMER,255,1),
(@GUID2+82,189981,571,1,1,5704.426,3884.596,-72.5278,1.86750,0,0,0,1,@TIMER,255,1),
(@GUID2+83,189981,571,1,1,5721.057,3655.517,-25.2488,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+84,189981,571,1,1,5721.060,3655.520,-25.2488,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+85,189981,571,1,1,5735.860,5612.500,-67.5912,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+86,189981,571,1,1,5740.394,5960.094,-36.3629,0.52360,0,0,0,1,@TIMER,255,1),
(@GUID2+87,189981,571,1,1,5762.140,3502.190,8.5711,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID2+88,189981,571,1,1,5827.040,4457.580,-130.4530,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID2+89,189981,571,1,1,5834.000,5370.130,-87.9156,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID2+90,189981,571,1,1,5859.746,4020.988,-68.8248,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID2+91,189981,571,1,3,5861.320,4419.110,-89.7436,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+92,189981,571,1,1,5882.228,5916.372,-25.0905,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID2+93,189981,571,1,1,5945.590,4566.130,-99.4520,1.69297,0,0,0,1,@TIMER,255,1),
(@GUID2+94,189981,571,1,1,6001.920,4160.640,-71.2961,0.83776,0,0,0,1,@TIMER,255,1),
(@GUID2+95,189981,571,1,1,6037.100,4847.040,-93.4030,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+96,189981,571,1,1,6053.300,4795.460,-92.8918,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID2+97,189981,571,1,1,6077.970,4860.720,-94.5449,-1.71042,0,0,0,1,@TIMER,255,1),
(@GUID2+98,189981,571,1,1,6084.560,4079.100,-46.7275,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+99,189981,571,1,1,6096.587,3644.301,143.1275,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID2+100,189981,571,1,1,6107.000,5455.440,-97.4798,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID2+101,189981,571,1,1,6167.440,5256.570,-127.8840,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+102,189981,571,1,3,6173.290,4609.010,-92.2689,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID2+103,189981,571,1,1,6174.170,5636.430,-22.3877,-1.93731,0,0,0,1,@TIMER,255,1),
(@GUID2+104,189981,571,1,1,6205.150,4325.340,-38.2094,-0.05236,0,0,0,1,@TIMER,255,1),
(@GUID2+105,189981,571,1,1,6215.250,5172.350,-97.6636,0.24435,0,0,0,1,@TIMER,255,1),
(@GUID2+106,189981,571,1,1,6229.990,5392.570,-108.9900,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID2+107,189981,571,1,1,6277.390,4221.150,-40.3804,0.59341,0,0,0,1,@TIMER,255,1),
(@GUID2+108,189981,571,1,1,6302.940,5136.300,-81.6133,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID2+109,189981,571,1,1,6310.000,3957.290,109.0570,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+110,189981,571,1,1,6659.690,4690.380,0.1829,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID2+111,189981,571,1,1,6672.220,4932.340,-17.9780,2.94959,0,0,0,1,@TIMER,255,1);
-- Titanium Deposits Sholazar Basin
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID3,191133,571,1,1,4704.718,5425.793,-32.3253,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID3+1,191133,571,1,1,4709.270,4367.730,-31.7133,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+2,191133,571,1,1,4716.542,4978.443,-44.2661,1.62316,0,0,0,1,@TIMER,255,1),
(@GUID3+3,191133,571,1,1,4722.860,5246.860,-42.0046,1.18682,0,0,0,1,@TIMER,255,1),
(@GUID3+4,191133,571,1,1,4724.210,5107.490,-46.3651,-1.78023,0,0,0,1,@TIMER,255,1),
(@GUID3+5,191133,571,1,1,4732.280,5135.100,-53.4326,-1.51844,0,0,0,1,@TIMER,255,1),
(@GUID3+6,191133,571,1,1,4732.570,5036.200,-54.9473,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID3+7,191133,571,1,1,4737.140,4847.460,-67.2180,1.65806,0,0,0,1,@TIMER,255,1),
(@GUID3+8,191133,571,1,1,4738.390,4691.450,-56.7589,0.50615,0,0,0,1,@TIMER,255,1),
(@GUID3+9,191133,571,1,1,4794.450,5895.830,-30.9455,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID3+10,191133,571,1,1,4837.230,4160.790,-3.6381,-0.62832,0,0,0,1,@TIMER,255,1),
(@GUID3+11,191133,571,1,1,4846.780,5769.550,-57.8889,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID3+12,191133,571,1,1,4847.239,5953.834,-15.9588,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID3+13,191133,571,1,1,4866.020,4570.890,-60.3061,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID3+14,191133,571,1,1,4884.830,4321.190,-54.8871,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID3+15,191133,571,1,1,4927.281,4328.632,-72.9263,0.59341,0,0,0,1,@TIMER,255,1),
(@GUID3+16,191133,571,1,1,4988.200,5373.050,-94.5907,1.36136,0,0,0,1,@TIMER,255,1),
(@GUID3+17,191133,571,1,1,4993.830,4180.020,-79.1709,0.01745,0,0,0,1,@TIMER,255,1),
(@GUID3+18,191133,571,1,1,5013.689,5436.410,-94.5146,-1.08210,0,0,0,1,@TIMER,255,1),
(@GUID3+19,191133,571,1,1,5015.700,4691.840,-91.0594,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID3+20,191133,571,1,1,5052.430,5887.010,-69.4098,-1.69297,0,0,0,1,@TIMER,255,1),
(@GUID3+21,191133,571,1,1,5054.910,4412.610,-92.8146,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID3+22,191133,571,1,1,5056.290,4819.880,-132.8840,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID3+23,191133,571,1,1,5062.380,4526.640,-96.4765,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID3+24,191133,571,1,1,5062.479,5031.562,-131.0034,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID3+25,191133,571,1,1,5079.800,5468.130,-88.7503,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+26,191133,571,1,1,5086.370,5098.740,-134.5720,2.07694,0,0,0,1,@TIMER,255,1),
(@GUID3+27,191133,571,1,1,5093.570,4341.180,-82.7253,3.08918,0,0,0,1,@TIMER,255,1),
(@GUID3+28,191133,571,1,1,5094.270,5217.790,-88.3220,-2.21656,0,0,0,1,@TIMER,255,1),
(@GUID3+29,191133,571,1,1,5105.152,4639.756,-135.8839,-1.02974,0,0,0,1,@TIMER,255,1),
(@GUID3+30,191133,571,1,1,5125.490,6015.810,-50.0045,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID3+31,191133,571,1,1,5128.380,4215.860,-83.4258,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID3+32,191133,571,1,1,5159.018,5454.543,-88.2909,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID3+33,191133,571,1,1,5171.400,3794.750,-12.2962,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID3+34,191133,571,1,1,5190.180,6023.387,-37.9963,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+35,191133,571,1,1,5199.739,5436.705,-81.6717,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID3+36,191133,571,1,1,5226.190,4826.150,-132.7040,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID3+37,191133,571,1,1,5232.450,4195.245,-93.5727,1.67551,0,0,0,1,@TIMER,255,1),
(@GUID3+38,191133,571,1,1,5271.987,5251.519,-124.8593,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID3+39,191133,571,1,1,5277.800,3702.890,12.7941,1.76278,0,0,0,1,@TIMER,255,1),
(@GUID3+40,191133,571,1,1,5309.020,4437.110,-101.2090,2.98450,0,0,0,1,@TIMER,255,1),
(@GUID3+41,191133,571,1,1,5324.950,5368.980,-123.4160,-1.37881,0,0,0,1,@TIMER,255,1),
(@GUID3+42,191133,571,1,1,5325.520,6025.470,-16.2582,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID3+43,191133,571,1,1,5331.860,4405.600,-126.9970,-1.51844,0,0,0,1,@TIMER,255,1),
(@GUID3+44,191133,571,1,1,5333.070,4300.510,-148.0820,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID3+45,191133,571,1,1,5338.952,4182.072,-94.2039,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID3+46,191133,571,1,1,5341.820,5396.050,-106.7450,2.00713,0,0,0,1,@TIMER,255,1),
(@GUID3+47,191133,571,1,1,5354.230,4820.880,-198.8800,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID3+48,191133,571,1,1,5358.900,4514.820,-127.6330,2.07694,0,0,0,1,@TIMER,255,1),
(@GUID3+49,191133,571,1,1,5385.530,4913.980,-195.3540,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID3+50,191133,571,1,1,5388.270,4753.330,-198.7980,2.30383,0,0,0,1,@TIMER,255,1),
(@GUID3+51,191133,571,1,1,5418.620,4371.290,-137.6760,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID3+52,191133,571,1,1,5434.910,3826.250,-65.5299,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID3+53,191133,571,1,1,5443.155,4694.667,-187.9415,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID3+54,191133,571,1,1,5446.752,5166.048,-133.7927,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID3+55,191133,571,1,1,5447.930,4519.890,-135.9880,-1.67551,0,0,0,1,@TIMER,255,1),
(@GUID3+56,191133,571,1,1,5449.870,4089.350,-91.0623,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+57,191133,571,1,3,5451.860,5532.250,-101.7700,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID3+58,191133,571,1,1,5455.970,5712.200,-102.7660,-0.59341,0,0,0,1,@TIMER,255,1),
(@GUID3+59,191133,571,1,1,5456.090,4679.770,-173.5170,1.93731,0,0,0,1,@TIMER,255,1),
(@GUID3+60,191133,571,1,1,5461.790,4916.510,-197.1930,-0.62832,0,0,0,1,@TIMER,255,1),
(@GUID3+61,191133,571,1,1,5479.190,4193.700,-97.0735,0.80285,0,0,0,1,@TIMER,255,1),
(@GUID3+62,191133,571,1,1,5482.810,3505.600,7.2101,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID3+63,191133,571,1,1,5483.640,4688.750,-122.0030,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID3+64,191133,571,1,1,5494.615,5677.867,-97.2142,1.93731,0,0,0,1,@TIMER,255,1),
(@GUID3+65,191133,571,1,1,5509.580,3579.710,-12.9631,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID3+66,191133,571,1,1,5521.060,4926.980,-192.7710,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID3+67,191133,571,1,1,5522.840,3836.810,-62.7052,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID3+68,191133,571,1,1,5528.730,4681.650,-127.0880,0.43633,0,0,0,1,@TIMER,255,1),
(@GUID3+69,191133,571,1,1,5529.634,4501.900,-132.3918,-2.33874,0,0,0,1,@TIMER,255,1),
(@GUID3+70,191133,571,1,1,5537.919,4315.394,-130.2137,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+71,191133,571,1,1,5553.280,3666.730,-28.5651,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID3+72,191133,571,1,3,5608.650,3865.180,-99.3376,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID3+73,191133,571,1,1,5652.200,3981.090,-83.0324,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID3+74,191133,571,1,3,5656.220,6023.450,-28.9304,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+75,191133,571,1,1,5660.409,3699.911,-13.5126,-2.37364,0,0,0,1,@TIMER,255,1),
(@GUID3+76,191133,571,1,1,5668.259,4118.605,-90.1961,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID3+77,191133,571,1,3,5669.970,5463.910,-68.9469,2.89724,0,0,0,1,@TIMER,255,1),
(@GUID3+78,191133,571,1,1,5671.007,4389.625,-137.5537,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID3+79,191133,571,1,1,5679.051,5598.783,-73.9954,-0.97738,0,0,0,1,@TIMER,255,1),
(@GUID3+80,191133,571,1,1,5682.740,3538.940,-8.8133,-2.35619,0,0,0,1,@TIMER,255,1),
(@GUID3+81,191133,571,1,1,5684.080,5541.490,-72.1058,-1.64061,0,0,0,1,@TIMER,255,1),
(@GUID3+82,191133,571,1,1,5704.426,3884.596,-72.5278,1.86750,0,0,0,1,@TIMER,255,1),
(@GUID3+83,191133,571,1,1,5721.057,3655.517,-25.2488,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+84,191133,571,1,1,5721.060,3655.520,-25.2488,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+85,191133,571,1,1,5735.860,5612.500,-67.5912,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID3+86,191133,571,1,1,5740.394,5960.094,-36.3629,0.52360,0,0,0,1,@TIMER,255,1),
(@GUID3+87,191133,571,1,1,5762.140,3502.190,8.5711,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID3+88,191133,571,1,1,5827.040,4457.580,-130.4530,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID3+89,191133,571,1,1,5834.000,5370.130,-87.9156,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID3+90,191133,571,1,1,5859.746,4020.988,-68.8248,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID3+91,191133,571,1,3,5861.320,4419.110,-89.7436,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID3+92,191133,571,1,1,5882.228,5916.372,-25.0905,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID3+93,191133,571,1,1,5945.590,4566.130,-99.4520,1.69297,0,0,0,1,@TIMER,255,1),
(@GUID3+94,191133,571,1,1,6001.920,4160.640,-71.2961,0.83776,0,0,0,1,@TIMER,255,1),
(@GUID3+95,191133,571,1,1,6037.100,4847.040,-93.4030,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID3+96,191133,571,1,1,6053.300,4795.460,-92.8918,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID3+97,191133,571,1,1,6077.970,4860.720,-94.5449,-1.71042,0,0,0,1,@TIMER,255,1),
(@GUID3+98,191133,571,1,1,6084.560,4079.100,-46.7275,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID3+99,191133,571,1,1,6096.587,3644.301,143.1275,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID3+100,191133,571,1,1,6107.000,5455.440,-97.4798,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID3+101,191133,571,1,1,6167.440,5256.570,-127.8840,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID3+102,191133,571,1,3,6173.290,4609.010,-92.2689,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID3+103,191133,571,1,1,6174.170,5636.430,-22.3877,-1.93731,0,0,0,1,@TIMER,255,1),
(@GUID3+104,191133,571,1,1,6205.150,4325.340,-38.2094,-0.05236,0,0,0,1,@TIMER,255,1),
(@GUID3+105,191133,571,1,1,6215.250,5172.350,-97.6636,0.24435,0,0,0,1,@TIMER,255,1),
(@GUID3+106,191133,571,1,1,6229.990,5392.570,-108.9900,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID3+107,191133,571,1,1,6277.390,4221.150,-40.3804,0.59341,0,0,0,1,@TIMER,255,1),
(@GUID3+108,191133,571,1,1,6302.940,5136.300,-81.6133,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID3+109,191133,571,1,1,6310.000,3957.290,109.0570,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+110,191133,571,1,1,6659.690,4690.380,0.1829,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID3+111,191133,571,1,1,6672.220,4932.340,-17.9780,2.94959,0,0,0,1,@TIMER,255,1);
-- Pooling
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID1 AND @GUID1+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID2 AND @GUID2+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID3 AND @GUID3+@LASTGUID;
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+0,@POOL+0,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 1 Saronite'),
(@GUID2+0,@POOL+0,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 1 Rich Saronite'),
(@GUID3+0,@POOL+0,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 1 Titanium'),
(@GUID1+1,@POOL+1,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 2 Saronite'),
(@GUID2+1,@POOL+1,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 2 Rich Saronite'),
(@GUID3+1,@POOL+1,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 2 Titanium'),
(@GUID1+2,@POOL+2,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 3 Saronite'),
(@GUID2+2,@POOL+2,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 3 Rich Saronite'),
(@GUID3+2,@POOL+2,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 3 Titanium'),
(@GUID1+3,@POOL+3,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 4 Saronite'),
(@GUID2+3,@POOL+3,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 4 Rich Saronite'),
(@GUID3+3,@POOL+3,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 4 Titanium'),
(@GUID1+4,@POOL+4,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 5 Saronite'),
(@GUID2+4,@POOL+4,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 5 Rich Saronite'),
(@GUID3+4,@POOL+4,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 5 Titanium'),
(@GUID1+5,@POOL+5,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 6 Saronite'),
(@GUID2+5,@POOL+5,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 6 Rich Saronite'),
(@GUID3+5,@POOL+5,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 6 Titanium'),
(@GUID1+6,@POOL+6,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 7 Saronite'),
(@GUID2+6,@POOL+6,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 7 Rich Saronite'),
(@GUID3+6,@POOL+6,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 7 Titanium'),
(@GUID1+7,@POOL+7,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 8 Saronite'),
(@GUID2+7,@POOL+7,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 8 Rich Saronite'),
(@GUID3+7,@POOL+7,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 8 Titanium'),
(@GUID1+8,@POOL+8,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 9 Saronite'),
(@GUID2+8,@POOL+8,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 9 Rich Saronite'),
(@GUID3+8,@POOL+8,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 9 Titanium'),
(@GUID1+9,@POOL+9,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 10 Saronite'),
(@GUID2+9,@POOL+9,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 10 Rich Saronite'),
(@GUID3+9,@POOL+9,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 10 Titanium'),
(@GUID1+10,@POOL+10,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 11 Saronite'),
(@GUID2+10,@POOL+10,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 11 Rich Saronite'),
(@GUID3+10,@POOL+10,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 11 Titanium'),
(@GUID1+11,@POOL+11,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 12 Saronite'),
(@GUID2+11,@POOL+11,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 12 Rich Saronite'),
(@GUID3+11,@POOL+11,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 12 Titanium'),
(@GUID1+12,@POOL+12,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 13 Saronite'),
(@GUID2+12,@POOL+12,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 13 Rich Saronite'),
(@GUID3+12,@POOL+12,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 13 Titanium'),
(@GUID1+13,@POOL+13,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 14 Saronite'),
(@GUID2+13,@POOL+13,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 14 Rich Saronite'),
(@GUID3+13,@POOL+13,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 14 Titanium'),
(@GUID1+14,@POOL+14,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 15 Saronite'),
(@GUID2+14,@POOL+14,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 15 Rich Saronite'),
(@GUID3+14,@POOL+14,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 15 Titanium'),
(@GUID1+15,@POOL+15,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 16 Saronite'),
(@GUID2+15,@POOL+15,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 16 Rich Saronite'),
(@GUID3+15,@POOL+15,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 16 Titanium'),
(@GUID1+16,@POOL+16,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 17 Saronite'),
(@GUID2+16,@POOL+16,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 17 Rich Saronite'),
(@GUID3+16,@POOL+16,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 17 Titanium'),
(@GUID1+17,@POOL+17,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 18 Saronite'),
(@GUID2+17,@POOL+17,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 18 Rich Saronite'),
(@GUID3+17,@POOL+17,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 18 Titanium'),
(@GUID1+18,@POOL+18,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 19 Saronite'),
(@GUID2+18,@POOL+18,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 19 Rich Saronite'),
(@GUID3+18,@POOL+18,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 19 Titanium'),
(@GUID1+19,@POOL+19,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 20 Saronite'),
(@GUID2+19,@POOL+19,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 20 Rich Saronite'),
(@GUID3+19,@POOL+19,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 20 Titanium'),
(@GUID1+20,@POOL+20,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 21 Saronite'),
(@GUID2+20,@POOL+20,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 21 Rich Saronite'),
(@GUID3+20,@POOL+20,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 21 Titanium'),
(@GUID1+21,@POOL+21,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 22 Saronite'),
(@GUID2+21,@POOL+21,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 22 Rich Saronite'),
(@GUID3+21,@POOL+21,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 22 Titanium'),
(@GUID1+22,@POOL+22,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 23 Saronite'),
(@GUID2+22,@POOL+22,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 23 Rich Saronite'),
(@GUID3+22,@POOL+22,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 23 Titanium'),
(@GUID1+23,@POOL+23,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 24 Saronite'),
(@GUID2+23,@POOL+23,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 24 Rich Saronite'),
(@GUID3+23,@POOL+23,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 24 Titanium'),
(@GUID1+24,@POOL+24,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 25 Saronite'),
(@GUID2+24,@POOL+24,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 25 Rich Saronite'),
(@GUID3+24,@POOL+24,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 25 Titanium'),
(@GUID1+25,@POOL+25,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 26 Saronite'),
(@GUID2+25,@POOL+25,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 26 Rich Saronite'),
(@GUID3+25,@POOL+25,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 26 Titanium'),
(@GUID1+26,@POOL+26,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 27 Saronite'),
(@GUID2+26,@POOL+26,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 27 Rich Saronite'),
(@GUID3+26,@POOL+26,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 27 Titanium'),
(@GUID1+27,@POOL+27,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 28 Saronite'),
(@GUID2+27,@POOL+27,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 28 Rich Saronite'),
(@GUID3+27,@POOL+27,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 28 Titanium'),
(@GUID1+28,@POOL+28,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 29 Saronite'),
(@GUID2+28,@POOL+28,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 29 Rich Saronite'),
(@GUID3+28,@POOL+28,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 29 Titanium'),
(@GUID1+29,@POOL+29,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 30 Saronite'),
(@GUID2+29,@POOL+29,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 30 Rich Saronite'),
(@GUID3+29,@POOL+29,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 30 Titanium'),
(@GUID1+30,@POOL+30,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 31 Saronite'),
(@GUID2+30,@POOL+30,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 31 Rich Saronite'),
(@GUID3+30,@POOL+30,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 31 Titanium'),
(@GUID1+31,@POOL+31,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 32 Saronite'),
(@GUID2+31,@POOL+31,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 32 Rich Saronite'),
(@GUID3+31,@POOL+31,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 32 Titanium'),
(@GUID1+32,@POOL+32,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 33 Saronite'),
(@GUID2+32,@POOL+32,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 33 Rich Saronite'),
(@GUID3+32,@POOL+32,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 33 Titanium'),
(@GUID1+33,@POOL+33,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 34 Saronite'),
(@GUID2+33,@POOL+33,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 34 Rich Saronite'),
(@GUID3+33,@POOL+33,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 34 Titanium'),
(@GUID1+34,@POOL+34,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 35 Saronite'),
(@GUID2+34,@POOL+34,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 35 Rich Saronite'),
(@GUID3+34,@POOL+34,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 35 Titanium'),
(@GUID1+35,@POOL+35,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 36 Saronite'),
(@GUID2+35,@POOL+35,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 36 Rich Saronite'),
(@GUID3+35,@POOL+35,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 36 Titanium'),
(@GUID1+36,@POOL+36,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 37 Saronite'),
(@GUID2+36,@POOL+36,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 37 Rich Saronite'),
(@GUID3+36,@POOL+36,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 37 Titanium'),
(@GUID1+37,@POOL+37,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 38 Saronite'),
(@GUID2+37,@POOL+37,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 38 Rich Saronite'),
(@GUID3+37,@POOL+37,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 38 Titanium'),
(@GUID1+38,@POOL+38,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 39 Saronite'),
(@GUID2+38,@POOL+38,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 39 Rich Saronite'),
(@GUID3+38,@POOL+38,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 39 Titanium'),
(@GUID1+39,@POOL+39,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 40 Saronite'),
(@GUID2+39,@POOL+39,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 40 Rich Saronite'),
(@GUID3+39,@POOL+39,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 40 Titanium'),
(@GUID1+40,@POOL+40,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 41 Saronite'),
(@GUID2+40,@POOL+40,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 41 Rich Saronite'),
(@GUID3+40,@POOL+40,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 41 Titanium'),
(@GUID1+41,@POOL+41,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 42 Saronite'),
(@GUID2+41,@POOL+41,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 42 Rich Saronite'),
(@GUID3+41,@POOL+41,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 42 Titanium'),
(@GUID1+42,@POOL+42,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 43 Saronite'),
(@GUID2+42,@POOL+42,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 43 Rich Saronite'),
(@GUID3+42,@POOL+42,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 43 Titanium'),
(@GUID1+43,@POOL+43,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 44 Saronite'),
(@GUID2+43,@POOL+43,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 44 Rich Saronite'),
(@GUID3+43,@POOL+43,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 44 Titanium'),
(@GUID1+44,@POOL+44,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 45 Saronite'),
(@GUID2+44,@POOL+44,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 45 Rich Saronite'),
(@GUID3+44,@POOL+44,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 45 Titanium'),
(@GUID1+45,@POOL+45,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 46 Saronite'),
(@GUID2+45,@POOL+45,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 46 Rich Saronite'),
(@GUID3+45,@POOL+45,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 46 Titanium'),
(@GUID1+46,@POOL+46,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 47 Saronite'),
(@GUID2+46,@POOL+46,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 47 Rich Saronite'),
(@GUID3+46,@POOL+46,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 47 Titanium'),
(@GUID1+47,@POOL+47,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 48 Saronite'),
(@GUID2+47,@POOL+47,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 48 Rich Saronite'),
(@GUID3+47,@POOL+47,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 48 Titanium'),
(@GUID1+48,@POOL+48,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 49 Saronite'),
(@GUID2+48,@POOL+48,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 49 Rich Saronite'),
(@GUID3+48,@POOL+48,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 49 Titanium'),
(@GUID1+49,@POOL+49,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 50 Saronite'),
(@GUID2+49,@POOL+49,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 50 Rich Saronite'),
(@GUID3+49,@POOL+49,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 50 Titanium'),
(@GUID1+50,@POOL+50,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 51 Saronite'),
(@GUID2+50,@POOL+50,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 51 Rich Saronite'),
(@GUID3+50,@POOL+50,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 51 Titanium'),
(@GUID1+51,@POOL+51,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 52 Saronite'),
(@GUID2+51,@POOL+51,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 52 Rich Saronite'),
(@GUID3+51,@POOL+51,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 52 Titanium'),
(@GUID1+52,@POOL+52,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 53 Saronite'),
(@GUID2+52,@POOL+52,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 53 Rich Saronite'),
(@GUID3+52,@POOL+52,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 53 Titanium'),
(@GUID1+53,@POOL+53,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 54 Saronite'),
(@GUID2+53,@POOL+53,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 54 Rich Saronite'),
(@GUID3+53,@POOL+53,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 54 Titanium'),
(@GUID1+54,@POOL+54,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 55 Saronite'),
(@GUID2+54,@POOL+54,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 55 Rich Saronite'),
(@GUID3+54,@POOL+54,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 55 Titanium'),
(@GUID1+55,@POOL+55,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 56 Saronite'),
(@GUID2+55,@POOL+55,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 56 Rich Saronite'),
(@GUID3+55,@POOL+55,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 56 Titanium'),
(@GUID1+56,@POOL+56,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 57 Saronite'),
(@GUID2+56,@POOL+56,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 57 Rich Saronite'),
(@GUID3+56,@POOL+56,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 57 Titanium'),
(@GUID1+57,@POOL+57,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 58 Saronite'),
(@GUID2+57,@POOL+57,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 58 Rich Saronite'),
(@GUID3+57,@POOL+57,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 58 Titanium'),
(@GUID1+58,@POOL+58,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 59 Saronite'),
(@GUID2+58,@POOL+58,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 59 Rich Saronite'),
(@GUID3+58,@POOL+58,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 59 Titanium'),
(@GUID1+59,@POOL+59,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 60 Saronite'),
(@GUID2+59,@POOL+59,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 60 Rich Saronite'),
(@GUID3+59,@POOL+59,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 60 Titanium'),
(@GUID1+60,@POOL+60,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 61 Saronite'),
(@GUID2+60,@POOL+60,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 61 Rich Saronite'),
(@GUID3+60,@POOL+60,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 61 Titanium'),
(@GUID1+61,@POOL+61,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 62 Saronite'),
(@GUID2+61,@POOL+61,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 62 Rich Saronite'),
(@GUID3+61,@POOL+61,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 62 Titanium'),
(@GUID1+62,@POOL+62,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 63 Saronite'),
(@GUID2+62,@POOL+62,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 63 Rich Saronite'),
(@GUID3+62,@POOL+62,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 63 Titanium'),
(@GUID1+63,@POOL+63,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 64 Saronite'),
(@GUID2+63,@POOL+63,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 64 Rich Saronite'),
(@GUID3+63,@POOL+63,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 64 Titanium'),
(@GUID1+64,@POOL+64,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 65 Saronite'),
(@GUID2+64,@POOL+64,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 65 Rich Saronite'),
(@GUID3+64,@POOL+64,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 65 Titanium'),
(@GUID1+65,@POOL+65,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 66 Saronite'),
(@GUID2+65,@POOL+65,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 66 Rich Saronite'),
(@GUID3+65,@POOL+65,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 66 Titanium'),
(@GUID1+66,@POOL+66,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 67 Saronite'),
(@GUID2+66,@POOL+66,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 67 Rich Saronite'),
(@GUID3+66,@POOL+66,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 67 Titanium'),
(@GUID1+67,@POOL+67,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 68 Saronite'),
(@GUID2+67,@POOL+67,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 68 Rich Saronite'),
(@GUID3+67,@POOL+67,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 68 Titanium'),
(@GUID1+68,@POOL+68,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 69 Saronite'),
(@GUID2+68,@POOL+68,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 69 Rich Saronite'),
(@GUID3+68,@POOL+68,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 69 Titanium'),
(@GUID1+69,@POOL+69,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 70 Saronite'),
(@GUID2+69,@POOL+69,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 70 Rich Saronite'),
(@GUID3+69,@POOL+69,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 70 Titanium'),
(@GUID1+70,@POOL+70,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 71 Saronite'),
(@GUID2+70,@POOL+70,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 71 Rich Saronite'),
(@GUID3+70,@POOL+70,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 71 Titanium'),
(@GUID1+71,@POOL+71,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 72 Saronite'),
(@GUID2+71,@POOL+71,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 72 Rich Saronite'),
(@GUID3+71,@POOL+71,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 72 Titanium'),
(@GUID1+72,@POOL+72,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 73 Saronite'),
(@GUID2+72,@POOL+72,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 73 Rich Saronite'),
(@GUID3+72,@POOL+72,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 73 Titanium'),
(@GUID1+73,@POOL+73,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 74 Saronite'),
(@GUID2+73,@POOL+73,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 74 Rich Saronite'),
(@GUID3+73,@POOL+73,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 74 Titanium'),
(@GUID1+74,@POOL+74,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 75 Saronite'),
(@GUID2+74,@POOL+74,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 75 Rich Saronite'),
(@GUID3+74,@POOL+74,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 75 Titanium'),
(@GUID1+75,@POOL+75,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 76 Saronite'),
(@GUID2+75,@POOL+75,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 76 Rich Saronite'),
(@GUID3+75,@POOL+75,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 76 Titanium'),
(@GUID1+76,@POOL+76,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 77 Saronite'),
(@GUID2+76,@POOL+76,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 77 Rich Saronite'),
(@GUID3+76,@POOL+76,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 77 Titanium'),
(@GUID1+77,@POOL+77,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 78 Saronite'),
(@GUID2+77,@POOL+77,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 78 Rich Saronite'),
(@GUID3+77,@POOL+77,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 78 Titanium'),
(@GUID1+78,@POOL+78,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 79 Saronite'),
(@GUID2+78,@POOL+78,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 79 Rich Saronite'),
(@GUID3+78,@POOL+78,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 79 Titanium'),
(@GUID1+79,@POOL+79,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 80 Saronite'),
(@GUID2+79,@POOL+79,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 80 Rich Saronite'),
(@GUID3+79,@POOL+79,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 80 Titanium'),
(@GUID1+80,@POOL+80,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 81 Saronite'),
(@GUID2+80,@POOL+80,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 81 Rich Saronite'),
(@GUID3+80,@POOL+80,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 81 Titanium'),
(@GUID1+81,@POOL+81,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 82 Saronite'),
(@GUID2+81,@POOL+81,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 82 Rich Saronite'),
(@GUID3+81,@POOL+81,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 82 Titanium'),
(@GUID1+82,@POOL+82,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 83 Saronite'),
(@GUID2+82,@POOL+82,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 83 Rich Saronite'),
(@GUID3+82,@POOL+82,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 83 Titanium'),
(@GUID1+83,@POOL+83,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 84 Saronite'),
(@GUID2+83,@POOL+83,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 84 Rich Saronite'),
(@GUID3+83,@POOL+83,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 84 Titanium'),
(@GUID1+84,@POOL+84,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 85 Saronite'),
(@GUID2+84,@POOL+84,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 85 Rich Saronite'),
(@GUID3+84,@POOL+84,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 85 Titanium'),
(@GUID1+85,@POOL+85,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 86 Saronite'),
(@GUID2+85,@POOL+85,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 86 Rich Saronite'),
(@GUID3+85,@POOL+85,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 86 Titanium'),
(@GUID1+86,@POOL+86,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 87 Saronite'),
(@GUID2+86,@POOL+86,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 87 Rich Saronite'),
(@GUID3+86,@POOL+86,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 87 Titanium'),
(@GUID1+87,@POOL+87,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 88 Saronite'),
(@GUID2+87,@POOL+87,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 88 Rich Saronite'),
(@GUID3+87,@POOL+87,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 88 Titanium'),
(@GUID1+88,@POOL+88,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 89 Saronite'),
(@GUID2+88,@POOL+88,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 89 Rich Saronite'),
(@GUID3+88,@POOL+88,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 89 Titanium'),
(@GUID1+89,@POOL+89,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 90 Saronite'),
(@GUID2+89,@POOL+89,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 90 Rich Saronite'),
(@GUID3+89,@POOL+89,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 90 Titanium'),
(@GUID1+90,@POOL+90,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 91 Saronite'),
(@GUID2+90,@POOL+90,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 91 Rich Saronite'),
(@GUID3+90,@POOL+90,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 91 Titanium'),
(@GUID1+91,@POOL+91,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 92 Saronite'),
(@GUID2+91,@POOL+91,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 92 Rich Saronite'),
(@GUID3+91,@POOL+91,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 92 Titanium'),
(@GUID1+92,@POOL+92,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 93 Saronite'),
(@GUID2+92,@POOL+92,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 93 Rich Saronite'),
(@GUID3+92,@POOL+92,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 93 Titanium'),
(@GUID1+93,@POOL+93,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 94 Saronite'),
(@GUID2+93,@POOL+93,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 94 Rich Saronite'),
(@GUID3+93,@POOL+93,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 94 Titanium'),
(@GUID1+94,@POOL+94,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 95 Saronite'),
(@GUID2+94,@POOL+94,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 95 Rich Saronite'),
(@GUID3+94,@POOL+94,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 95 Titanium'),
(@GUID1+95,@POOL+95,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 96 Saronite'),
(@GUID2+95,@POOL+95,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 96 Rich Saronite'),
(@GUID3+95,@POOL+95,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 96 Titanium'),
(@GUID1+96,@POOL+96,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 97 Saronite'),
(@GUID2+96,@POOL+96,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 97 Rich Saronite'),
(@GUID3+96,@POOL+96,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 97 Titanium'),
(@GUID1+97,@POOL+97,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 98 Saronite'),
(@GUID2+97,@POOL+97,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 98 Rich Saronite'),
(@GUID3+97,@POOL+97,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 98 Titanium'),
(@GUID1+98,@POOL+98,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 99 Saronite'),
(@GUID2+98,@POOL+98,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 99 Rich Saronite'),
(@GUID3+98,@POOL+98,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 99 Titanium'),
(@GUID1+99,@POOL+99,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 100 Saronite'),
(@GUID2+99,@POOL+99,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 100 Rich Saronite'),
(@GUID3+99,@POOL+99,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 100 Titanium'),
(@GUID1+100,@POOL+100,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 101 Saronite'),
(@GUID2+100,@POOL+100,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 101 Rich Saronite'),
(@GUID3+100,@POOL+100,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 101 Titanium'),
(@GUID1+101,@POOL+101,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 102 Saronite'),
(@GUID2+101,@POOL+101,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 102 Rich Saronite'),
(@GUID3+101,@POOL+101,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 102 Titanium'),
(@GUID1+102,@POOL+102,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 103 Saronite'),
(@GUID2+102,@POOL+102,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 103 Rich Saronite'),
(@GUID3+102,@POOL+102,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 103 Titanium'),
(@GUID1+103,@POOL+103,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 104 Saronite'),
(@GUID2+103,@POOL+103,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 104 Rich Saronite'),
(@GUID3+103,@POOL+103,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 104 Titanium'),
(@GUID1+104,@POOL+104,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 105 Saronite'),
(@GUID2+104,@POOL+104,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 105 Rich Saronite'),
(@GUID3+104,@POOL+104,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 105 Titanium'),
(@GUID1+105,@POOL+105,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 106 Saronite'),
(@GUID2+105,@POOL+105,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 106 Rich Saronite'),
(@GUID3+105,@POOL+105,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 106 Titanium'),
(@GUID1+106,@POOL+106,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 107 Saronite'),
(@GUID2+106,@POOL+106,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 107 Rich Saronite'),
(@GUID3+106,@POOL+106,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 107 Titanium'),
(@GUID1+107,@POOL+107,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 108 Saronite'),
(@GUID2+107,@POOL+107,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 108 Rich Saronite'),
(@GUID3+107,@POOL+107,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 108 Titanium'),
(@GUID1+108,@POOL+108,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 109 Saronite'),
(@GUID2+108,@POOL+108,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 109 Rich Saronite'),
(@GUID3+108,@POOL+108,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 109 Titanium'),
(@GUID1+109,@POOL+109,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 110 Saronite'),
(@GUID2+109,@POOL+109,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 110 Rich Saronite'),
(@GUID3+109,@POOL+109,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 110 Titanium'),
(@GUID1+110,@POOL+110,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 111 Saronite'),
(@GUID2+110,@POOL+110,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 111 Rich Saronite'),
(@GUID3+110,@POOL+110,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 111 Titanium'),
(@GUID1+111,@POOL+111,@CHANCE1, 'Sholazar Basin Ore Spawnpoint 112 Saronite'),
(@GUID2+111,@POOL+111,@CHANCE2, 'Sholazar Basin Ore Spawnpoint 112 Rich Saronite'),
(@GUID3+111,@POOL+111,@CHANCE3, 'Sholazar Basin Ore Spawnpoint 112 Titanium');
-- Add each pool to pool template
DELETE FROM `pool_template` WHERE `entry` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+0,1, 'Sholazar Basin Ore Spawnpoint 1'),
(@POOL+1,1, 'Sholazar Basin Ore Spawnpoint 2'),
(@POOL+2,1, 'Sholazar Basin Ore Spawnpoint 3'),
(@POOL+3,1, 'Sholazar Basin Ore Spawnpoint 4'),
(@POOL+4,1, 'Sholazar Basin Ore Spawnpoint 5'),
(@POOL+5,1, 'Sholazar Basin Ore Spawnpoint 6'),
(@POOL+6,1, 'Sholazar Basin Ore Spawnpoint 7'),
(@POOL+7,1, 'Sholazar Basin Ore Spawnpoint 8'),
(@POOL+8,1, 'Sholazar Basin Ore Spawnpoint 9'),
(@POOL+9,1, 'Sholazar Basin Ore Spawnpoint 10'),
(@POOL+10,1, 'Sholazar Basin Ore Spawnpoint 11'),
(@POOL+11,1, 'Sholazar Basin Ore Spawnpoint 12'),
(@POOL+12,1, 'Sholazar Basin Ore Spawnpoint 13'),
(@POOL+13,1, 'Sholazar Basin Ore Spawnpoint 14'),
(@POOL+14,1, 'Sholazar Basin Ore Spawnpoint 15'),
(@POOL+15,1, 'Sholazar Basin Ore Spawnpoint 16'),
(@POOL+16,1, 'Sholazar Basin Ore Spawnpoint 17'),
(@POOL+17,1, 'Sholazar Basin Ore Spawnpoint 18'),
(@POOL+18,1, 'Sholazar Basin Ore Spawnpoint 19'),
(@POOL+19,1, 'Sholazar Basin Ore Spawnpoint 20'),
(@POOL+20,1, 'Sholazar Basin Ore Spawnpoint 21'),
(@POOL+21,1, 'Sholazar Basin Ore Spawnpoint 22'),
(@POOL+22,1, 'Sholazar Basin Ore Spawnpoint 23'),
(@POOL+23,1, 'Sholazar Basin Ore Spawnpoint 24'),
(@POOL+24,1, 'Sholazar Basin Ore Spawnpoint 25'),
(@POOL+25,1, 'Sholazar Basin Ore Spawnpoint 26'),
(@POOL+26,1, 'Sholazar Basin Ore Spawnpoint 27'),
(@POOL+27,1, 'Sholazar Basin Ore Spawnpoint 28'),
(@POOL+28,1, 'Sholazar Basin Ore Spawnpoint 29'),
(@POOL+29,1, 'Sholazar Basin Ore Spawnpoint 30'),
(@POOL+30,1, 'Sholazar Basin Ore Spawnpoint 31'),
(@POOL+31,1, 'Sholazar Basin Ore Spawnpoint 32'),
(@POOL+32,1, 'Sholazar Basin Ore Spawnpoint 33'),
(@POOL+33,1, 'Sholazar Basin Ore Spawnpoint 34'),
(@POOL+34,1, 'Sholazar Basin Ore Spawnpoint 35'),
(@POOL+35,1, 'Sholazar Basin Ore Spawnpoint 36'),
(@POOL+36,1, 'Sholazar Basin Ore Spawnpoint 37'),
(@POOL+37,1, 'Sholazar Basin Ore Spawnpoint 38'),
(@POOL+38,1, 'Sholazar Basin Ore Spawnpoint 39'),
(@POOL+39,1, 'Sholazar Basin Ore Spawnpoint 40'),
(@POOL+40,1, 'Sholazar Basin Ore Spawnpoint 41'),
(@POOL+41,1, 'Sholazar Basin Ore Spawnpoint 42'),
(@POOL+42,1, 'Sholazar Basin Ore Spawnpoint 43'),
(@POOL+43,1, 'Sholazar Basin Ore Spawnpoint 44'),
(@POOL+44,1, 'Sholazar Basin Ore Spawnpoint 45'),
(@POOL+45,1, 'Sholazar Basin Ore Spawnpoint 46'),
(@POOL+46,1, 'Sholazar Basin Ore Spawnpoint 47'),
(@POOL+47,1, 'Sholazar Basin Ore Spawnpoint 48'),
(@POOL+48,1, 'Sholazar Basin Ore Spawnpoint 49'),
(@POOL+49,1, 'Sholazar Basin Ore Spawnpoint 50'),
(@POOL+50,1, 'Sholazar Basin Ore Spawnpoint 51'),
(@POOL+51,1, 'Sholazar Basin Ore Spawnpoint 52'),
(@POOL+52,1, 'Sholazar Basin Ore Spawnpoint 53'),
(@POOL+53,1, 'Sholazar Basin Ore Spawnpoint 54'),
(@POOL+54,1, 'Sholazar Basin Ore Spawnpoint 55'),
(@POOL+55,1, 'Sholazar Basin Ore Spawnpoint 56'),
(@POOL+56,1, 'Sholazar Basin Ore Spawnpoint 57'),
(@POOL+57,1, 'Sholazar Basin Ore Spawnpoint 58'),
(@POOL+58,1, 'Sholazar Basin Ore Spawnpoint 59'),
(@POOL+59,1, 'Sholazar Basin Ore Spawnpoint 60'),
(@POOL+60,1, 'Sholazar Basin Ore Spawnpoint 61'),
(@POOL+61,1, 'Sholazar Basin Ore Spawnpoint 62'),
(@POOL+62,1, 'Sholazar Basin Ore Spawnpoint 63'),
(@POOL+63,1, 'Sholazar Basin Ore Spawnpoint 64'),
(@POOL+64,1, 'Sholazar Basin Ore Spawnpoint 65'),
(@POOL+65,1, 'Sholazar Basin Ore Spawnpoint 66'),
(@POOL+66,1, 'Sholazar Basin Ore Spawnpoint 67'),
(@POOL+67,1, 'Sholazar Basin Ore Spawnpoint 68'),
(@POOL+68,1, 'Sholazar Basin Ore Spawnpoint 69'),
(@POOL+69,1, 'Sholazar Basin Ore Spawnpoint 70'),
(@POOL+70,1, 'Sholazar Basin Ore Spawnpoint 71'),
(@POOL+71,1, 'Sholazar Basin Ore Spawnpoint 72'),
(@POOL+72,1, 'Sholazar Basin Ore Spawnpoint 73'),
(@POOL+73,1, 'Sholazar Basin Ore Spawnpoint 74'),
(@POOL+74,1, 'Sholazar Basin Ore Spawnpoint 75'),
(@POOL+75,1, 'Sholazar Basin Ore Spawnpoint 76'),
(@POOL+76,1, 'Sholazar Basin Ore Spawnpoint 77'),
(@POOL+77,1, 'Sholazar Basin Ore Spawnpoint 78'),
(@POOL+78,1, 'Sholazar Basin Ore Spawnpoint 79'),
(@POOL+79,1, 'Sholazar Basin Ore Spawnpoint 80'),
(@POOL+80,1, 'Sholazar Basin Ore Spawnpoint 81'),
(@POOL+81,1, 'Sholazar Basin Ore Spawnpoint 82'),
(@POOL+82,1, 'Sholazar Basin Ore Spawnpoint 83'),
(@POOL+83,1, 'Sholazar Basin Ore Spawnpoint 84'),
(@POOL+84,1, 'Sholazar Basin Ore Spawnpoint 85'),
(@POOL+85,1, 'Sholazar Basin Ore Spawnpoint 86'),
(@POOL+86,1, 'Sholazar Basin Ore Spawnpoint 87'),
(@POOL+87,1, 'Sholazar Basin Ore Spawnpoint 88'),
(@POOL+88,1, 'Sholazar Basin Ore Spawnpoint 89'),
(@POOL+89,1, 'Sholazar Basin Ore Spawnpoint 90'),
(@POOL+90,1, 'Sholazar Basin Ore Spawnpoint 91'),
(@POOL+91,1, 'Sholazar Basin Ore Spawnpoint 92'),
(@POOL+92,1, 'Sholazar Basin Ore Spawnpoint 93'),
(@POOL+93,1, 'Sholazar Basin Ore Spawnpoint 94'),
(@POOL+94,1, 'Sholazar Basin Ore Spawnpoint 95'),
(@POOL+95,1, 'Sholazar Basin Ore Spawnpoint 96'),
(@POOL+96,1, 'Sholazar Basin Ore Spawnpoint 97'),
(@POOL+97,1, 'Sholazar Basin Ore Spawnpoint 98'),
(@POOL+98,1, 'Sholazar Basin Ore Spawnpoint 99'),
(@POOL+99,1, 'Sholazar Basin Ore Spawnpoint 100'),
(@POOL+100,1, 'Sholazar Basin Ore Spawnpoint 101'),
(@POOL+101,1, 'Sholazar Basin Ore Spawnpoint 102'),
(@POOL+102,1, 'Sholazar Basin Ore Spawnpoint 103'),
(@POOL+103,1, 'Sholazar Basin Ore Spawnpoint 104'),
(@POOL+104,1, 'Sholazar Basin Ore Spawnpoint 105'),
(@POOL+105,1, 'Sholazar Basin Ore Spawnpoint 106'),
(@POOL+106,1, 'Sholazar Basin Ore Spawnpoint 107'),
(@POOL+107,1, 'Sholazar Basin Ore Spawnpoint 108'),
(@POOL+108,1, 'Sholazar Basin Ore Spawnpoint 109'),
(@POOL+109,1, 'Sholazar Basin Ore Spawnpoint 110'),
(@POOL+110,1, 'Sholazar Basin Ore Spawnpoint 111'),
(@POOL+111,1, 'Sholazar Basin Ore Spawnpoint 112');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER,@ACTIVE, 'Sholazar Basin Ore Mother pool');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+0,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 1'),
(@POOL+1,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 2'),
(@POOL+2,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 3'),
(@POOL+3,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 4'),
(@POOL+4,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 5'),
(@POOL+5,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 6'),
(@POOL+6,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 7'),
(@POOL+7,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 8'),
(@POOL+8,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 9'),
(@POOL+9,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 10'),
(@POOL+10,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 11'),
(@POOL+11,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 12'),
(@POOL+12,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 13'),
(@POOL+13,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 14'),
(@POOL+14,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 15'),
(@POOL+15,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 16'),
(@POOL+16,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 17'),
(@POOL+17,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 18'),
(@POOL+18,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 19'),
(@POOL+19,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 20'),
(@POOL+20,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 21'),
(@POOL+21,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 22'),
(@POOL+22,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 23'),
(@POOL+23,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 24'),
(@POOL+24,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 25'),
(@POOL+25,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 26'),
(@POOL+26,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 27'),
(@POOL+27,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 28'),
(@POOL+28,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 29'),
(@POOL+29,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 30'),
(@POOL+30,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 31'),
(@POOL+31,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 32'),
(@POOL+32,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 33'),
(@POOL+33,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 34'),
(@POOL+34,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 35'),
(@POOL+35,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 36'),
(@POOL+36,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 37'),
(@POOL+37,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 38'),
(@POOL+38,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 39'),
(@POOL+39,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 40'),
(@POOL+40,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 41'),
(@POOL+41,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 42'),
(@POOL+42,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 43'),
(@POOL+43,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 44'),
(@POOL+44,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 45'),
(@POOL+45,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 46'),
(@POOL+46,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 47'),
(@POOL+47,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 48'),
(@POOL+48,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 49'),
(@POOL+49,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 50'),
(@POOL+50,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 51'),
(@POOL+51,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 52'),
(@POOL+52,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 53'),
(@POOL+53,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 54'),
(@POOL+54,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 55'),
(@POOL+55,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 56'),
(@POOL+56,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 57'),
(@POOL+57,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 58'),
(@POOL+58,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 59'),
(@POOL+59,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 60'),
(@POOL+60,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 61'),
(@POOL+61,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 62'),
(@POOL+62,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 63'),
(@POOL+63,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 64'),
(@POOL+64,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 65'),
(@POOL+65,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 66'),
(@POOL+66,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 67'),
(@POOL+67,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 68'),
(@POOL+68,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 69'),
(@POOL+69,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 70'),
(@POOL+70,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 71'),
(@POOL+71,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 72'),
(@POOL+72,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 73'),
(@POOL+73,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 74'),
(@POOL+74,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 75'),
(@POOL+75,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 76'),
(@POOL+76,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 77'),
(@POOL+77,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 78'),
(@POOL+78,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 79'),
(@POOL+79,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 80'),
(@POOL+80,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 81'),
(@POOL+81,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 82'),
(@POOL+82,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 83'),
(@POOL+83,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 84'),
(@POOL+84,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 85'),
(@POOL+85,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 86'),
(@POOL+86,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 87'),
(@POOL+87,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 88'),
(@POOL+88,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 89'),
(@POOL+89,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 90'),
(@POOL+90,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 91'),
(@POOL+91,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 92'),
(@POOL+92,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 93'),
(@POOL+93,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 94'),
(@POOL+94,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 95'),
(@POOL+95,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 96'),
(@POOL+96,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 97'),
(@POOL+97,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 98'),
(@POOL+98,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 99'),
(@POOL+99,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 100'),
(@POOL+100,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 101'),
(@POOL+101,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 102'),
(@POOL+102,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 103'),
(@POOL+103,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 104'),
(@POOL+104,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 105'),
(@POOL+105,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 106'),
(@POOL+106,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 107'),
(@POOL+107,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 108'),
(@POOL+108,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 109'),
(@POOL+109,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 110'),
(@POOL+110,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 111'),
(@POOL+111,@MOTHER,0, 'Sholazar Basin Ore Spawnpoint 112');

-- --------------------------------------
-- -- Fixup ore spawns for Storm Peaks --
-- --------------------------------------
SET @RANGE    := 250;
SET @GUID1    := 162450;
SET @GUID2    := @GUID1 + @RANGE;
SET @GUID3    := @GUID2 + @RANGE;
SET @POOL     := 11150;
SET @LASTGUID := 109;
SET @CHANCE1  := 75;
SET @CHANCE2  := 15;
SET @CHANCE3  := 10;
SET @MOTHER   := 9906;
SET @MOTHER2  := 9907;
SET @ACTIVE   := 35; -- Max number of active spawns
SET @TIMER    := 900; -- Respawn timer in seconds
-- Remove Ore spawns from Storm Peaks
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < -110 AND `position_y` > -3430 AND `position_x` > 6490;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < -3430 AND `position_x` > 6980;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < -110 AND `position_y` > -1890 AND `position_x` > 6100 AND `position_x` < 6490;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < -230 AND `position_y` > -1195 AND `position_x` > 5790 AND `position_x` < 6100;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 225 AND `position_y` > -30 AND `position_x` > 6920 AND `position_x` < 7200;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 225 AND `position_y` > -110 AND `position_x` > 7300;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` > -4030 AND `position_y` < -2300 AND `position_x` > 6730 AND `position_x` < 6980;
-- Remove old pools
DELETE FROM `pool_gameobject` WHERE `guid` NOT IN (SELECT `guid` FROM `gameobject`);
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5376 AND 5447;
DELETE FROM `pool_template` WHERE `entry`=898;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5376 AND 5447;
-- Saronite Deposits Storm Peaks
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID1,189980,571,1,1,5973.130,-678.799,384.3029,-1.01229,0,0,0,1,@TIMER,255,1),
(@GUID1+1,189980,571,1,1,5990.065,-1015.166,446.6375,2.19911,0,0,0,1,@TIMER,255,1),
(@GUID1+2,189980,571,1,1,5990.990,-621.435,374.3110,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID1+3,189980,571,1,1,6344.363,-785.474,408.0191,-1.86750,0,0,0,1,@TIMER,255,1),
(@GUID1+4,189980,571,1,1,6394.662,-876.401,409.3433,1.27409,0,0,0,1,@TIMER,255,1),
(@GUID1+5,189980,571,1,1,6518.710,-1309.900,407.2080,2.21656,0,0,0,1,@TIMER,255,1),
(@GUID1+6,189980,571,1,1,6523.616,-1265.091,405.4821,-1.58825,0,0,0,1,@TIMER,255,1),
(@GUID1+7,189980,571,1,1,6570.893,-1050.817,432.5308,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID1+8,189980,571,1,1,6570.996,-1230.147,404.3670,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID1+9,189980,571,1,1,6571.000,-1230.150,404.3670,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID1+10,189980,571,1,1,6596.600,-1356.010,410.0870,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+11,189980,571,1,1,6600.015,-977.058,430.9555,1.06465,0,0,0,1,@TIMER,255,1),
(@GUID1+12,189980,571,1,1,6646.551,-876.419,685.5173,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+13,189980,571,1,1,6657.530,-1251.140,397.5630,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID1+14,189980,571,1,1,6666.780,-1032.980,413.8020,-0.08727,0,0,0,1,@TIMER,255,1),
(@GUID1+15,189980,571,1,1,6675.330,-1195.820,398.5400,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID1+16,189980,571,1,1,6677.080,-1207.990,398.8300,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID1+17,189980,571,1,1,6679.290,-1365.290,392.1810,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID1+18,189980,571,1,1,6688.502,-1112.257,397.3456,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+19,189980,571,1,1,6756.100,-1530.500,369.0680,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID1+20,189980,571,1,1,6799.450,-1602.820,354.4390,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID1+21,189980,571,1,1,6816.010,-1364.550,819.6750,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID1+22,189980,571,1,1,6821.420,-607.278,982.4290,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID1+23,189980,571,1,1,6831.780,-1599.010,352.3690,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID1+24,189980,571,1,1,6836.444,-1338.513,819.7522,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+25,189980,571,1,1,6847.579,-1230.780,806.6544,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID1+26,189980,571,1,1,6866.660,-1725.760,827.2400,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID1+27,189980,571,1,1,6867.097,-3428.810,629.1428,-1.44862,0,0,0,1,@TIMER,255,1),
(@GUID1+28,189980,571,1,1,6879.430,-1237.150,810.2590,1.39626,0,0,0,1,@TIMER,255,1),
(@GUID1+29,189980,571,1,1,6900.310,-1523.000,359.9120,-0.24435,0,0,0,1,@TIMER,255,1),
(@GUID1+30,189980,571,1,1,6927.970,-28.980,805.1720,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID1+31,189980,571,1,1,6961.172,-6.584,809.1790,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID1+32,189980,571,1,1,6979.510,-658.492,770.4860,-2.94959,0,0,0,1,@TIMER,255,1),
(@GUID1+33,189980,571,1,1,6981.886,-1205.506,810.1734,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID1+34,189980,571,1,1,6983.300,-1221.080,809.7370,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID1+35,189980,571,1,1,6986.340,-1293.410,820.2910,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+36,189980,571,1,1,6994.690,-804.125,736.4880,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID1+37,189980,571,1,1,6996.860,34.220,810.4850,2.60054,0,0,0,1,@TIMER,255,1),
(@GUID1+38,189980,571,1,1,7002.330,-19.649,811.0490,-1.97222,0,0,0,1,@TIMER,255,1),
(@GUID1+39,189980,571,1,1,7005.420,-367.084,788.1000,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID1+40,189980,571,1,1,7008.100,-503.726,745.1890,-0.13962,0,0,0,1,@TIMER,255,1),
(@GUID1+41,189980,571,1,1,7010.060,90.342,814.8490,0.34907,0,0,0,1,@TIMER,255,1),
(@GUID1+42,189980,571,1,1,7019.150,-776.146,732.3610,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID1+43,189980,571,1,1,7019.820,-1357.060,833.0070,-0.68068,0,0,0,1,@TIMER,255,1),
(@GUID1+44,189980,571,1,3,7032.890,-1319.140,820.8290,0.52360,0,0,0,1,@TIMER,255,1),
(@GUID1+45,189980,571,1,1,7051.360,-2016.770,769.8010,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID1+46,189980,571,1,3,7052.570,-1106.910,934.5030,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID1+47,189980,571,1,1,7075.710,-1920.550,774.8670,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+48,189980,571,1,1,7075.710,-1920.546,774.8665,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+49,189980,571,1,4,7080.040,-2724.640,756.8140,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+50,189980,571,1,1,7108.708,-390.674,785.4223,-2.60054,0,0,0,1,@TIMER,255,1),
(@GUID1+51,189980,571,1,2,7109.325,-2248.944,760.0534,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID1+52,189980,571,1,1,7110.417,-543.947,739.8368,-0.73304,0,0,0,1,@TIMER,255,1),
(@GUID1+53,189980,571,1,1,7122.950,-1096.950,928.4570,0.61086,0,0,0,1,@TIMER,255,1),
(@GUID1+54,189980,571,1,4,7134.020,-2760.250,786.9060,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID1+55,189980,571,1,8,7142.310,-3636.810,841.7630,2.72271,0,0,0,1,@TIMER,255,1),
(@GUID1+56,189980,571,1,4,7160.350,-2126.890,762.2910,-1.30900,0,0,0,1,@TIMER,255,1),
(@GUID1+57,189980,571,1,1,7169.138,-1110.031,933.9944,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID1+58,189980,571,1,4,7170.760,-2087.910,771.9970,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID1+59,189980,571,1,1,7171.050,-232.757,808.5810,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID1+60,189980,571,1,4,7177.672,-2048.255,768.8198,-2.05949,0,0,0,1,@TIMER,255,1),
(@GUID1+61,189980,571,1,1,7187.288,-1305.361,946.4589,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID1+62,189980,571,1,1,7187.840,220.090,793.1120,-2.74016,0,0,0,1,@TIMER,255,1),
(@GUID1+63,189980,571,1,4,7191.417,-2963.443,863.3470,0.71558,0,0,0,1,@TIMER,255,1),
(@GUID1+64,189980,571,1,4,7201.295,-1976.741,771.9154,2.70526,0,0,0,1,@TIMER,255,1),
(@GUID1+65,189980,571,1,8,7216.890,-3691.290,822.2200,1.95477,0,0,0,1,@TIMER,255,1),
(@GUID1+66,189980,571,1,1,7224.430,-993.775,926.9220,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID1+67,189980,571,1,2,7233.571,-3542.979,834.7737,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID1+68,189980,571,1,1,7247.440,-1258.090,922.4690,0.12217,0,0,0,1,@TIMER,255,1),
(@GUID1+69,189980,571,1,4,7253.561,-2213.503,765.6185,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID1+70,189980,571,1,3,7263.250,-2858.310,784.9630,3.05433,0,0,0,1,@TIMER,255,1),
(@GUID1+71,189980,571,1,1,7290.680,-158.387,791.6990,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID1+72,189980,571,1,1,7301.970,-1076.270,922.8330,2.77507,0,0,0,1,@TIMER,255,1),
(@GUID1+73,189980,571,1,4,7308.590,-2918.880,829.2740,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID1+74,189980,571,1,4,7310.649,-2244.919,759.6533,2.79252,0,0,0,1,@TIMER,255,1),
(@GUID1+75,189980,571,1,8,7343.630,-3631.950,827.0680,2.86233,0,0,0,1,@TIMER,255,1),
(@GUID1+76,189980,571,1,4,7375.280,-2741.830,755.0170,1.23918,0,0,0,1,@TIMER,255,1),
(@GUID1+77,189980,571,1,1,7402.413,-2801.713,771.3893,2.68781,0,0,0,1,@TIMER,255,1),
(@GUID1+78,189980,571,1,4,7407.630,-3292.640,865.9170,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+79,189980,571,1,1,7425.510,-124.863,794.2450,-1.06465,0,0,0,1,@TIMER,255,1),
(@GUID1+80,189980,571,1,4,7440.669,-2350.947,758.8542,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID1+81,189980,571,1,2,7471.304,-2436.701,759.9119,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID1+82,189980,571,1,1,7610.480,-1368.060,958.4000,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID1+83,189980,571,1,1,7705.490,-3346.280,889.6080,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID1+84,189980,571,1,1,7751.970,-268.932,919.1180,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID1+85,189980,571,1,1,7776.040,-3094.280,917.4480,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID1+86,189980,571,1,1,7808.350,-82.079,880.2680,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID1+87,189980,571,1,1,7828.840,-115.694,886.1690,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+88,189980,571,1,1,7854.360,49.873,1010.9600,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID1+89,189980,571,1,1,7908.766,124.441,1030.6354,-0.75049,0,0,0,1,@TIMER,255,1),
(@GUID1+90,189980,571,1,1,7923.454,-2642.304,1139.8401,0.41888,0,0,0,1,@TIMER,255,1),
(@GUID1+91,189980,571,1,1,8016.460,-2395.760,1161.8300,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+92,189980,571,1,1,8069.040,-2777.400,1050.3100,-1.23918,0,0,0,1,@TIMER,255,1),
(@GUID1+93,189980,571,1,1,8106.100,-2241.150,1167.3900,-0.34907,0,0,0,1,@TIMER,255,1),
(@GUID1+94,189980,571,1,1,8125.980,-218.974,848.5040,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+95,189980,571,1,3,8126.960,-1265.300,1018.4300,-0.99484,0,0,0,1,@TIMER,255,1),
(@GUID1+96,189980,571,1,1,8136.270,-286.253,867.3590,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID1+97,189980,571,1,1,8153.250,-392.846,1020.5000,-2.94959,0,0,0,1,@TIMER,255,1),
(@GUID1+98,189980,571,1,1,8182.390,-729.494,929.5760,1.34390,0,0,0,1,@TIMER,255,1),
(@GUID1+99,189980,571,1,1,8184.400,-2399.480,1139.6400,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID1+100,189980,571,1,1,8191.020,-2794.480,1044.1400,-2.75761,0,0,0,1,@TIMER,255,1),
(@GUID1+101,189980,571,1,1,8196.150,-2734.560,1036.6200,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID1+102,189980,571,1,1,8223.970,-674.648,933.0660,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID1+103,189980,571,1,1,8239.630,-2988.430,1087.3600,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID1+104,189980,571,1,1,8286.560,-212.827,889.2710,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+105,189980,571,1,1,8292.716,-2688.017,1036.6243,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID1+106,189980,571,1,1,8297.316,-1323.155,989.2230,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID1+107,189980,571,1,1,8443.600,-1578.120,1038.2500,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID1+108,189980,571,1,1,8569.773,-1292.149,544.9063,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+109,189980,571,1,1,8636.965,-1181.421,539.1292,-1.32645,0,0,0,1,@TIMER,255,1);
-- Rich Saronite Deposits Storm Peaks
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID2,189981,571,1,1,5973.130,-678.799,384.3029,-1.01229,0,0,0,1,@TIMER,255,1),
(@GUID2+1,189981,571,1,1,5990.065,-1015.166,446.6375,2.19911,0,0,0,1,@TIMER,255,1),
(@GUID2+2,189981,571,1,1,5990.990,-621.435,374.3110,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID2+3,189981,571,1,1,6344.363,-785.474,408.0191,-1.86750,0,0,0,1,@TIMER,255,1),
(@GUID2+4,189981,571,1,1,6394.662,-876.401,409.3433,1.27409,0,0,0,1,@TIMER,255,1),
(@GUID2+5,189981,571,1,1,6518.710,-1309.900,407.2080,2.21656,0,0,0,1,@TIMER,255,1),
(@GUID2+6,189981,571,1,1,6523.616,-1265.091,405.4821,-1.58825,0,0,0,1,@TIMER,255,1),
(@GUID2+7,189981,571,1,1,6570.893,-1050.817,432.5308,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID2+8,189981,571,1,1,6570.996,-1230.147,404.3670,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID2+9,189981,571,1,1,6571.000,-1230.150,404.3670,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID2+10,189981,571,1,1,6596.600,-1356.010,410.0870,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+11,189981,571,1,1,6600.015,-977.058,430.9555,1.06465,0,0,0,1,@TIMER,255,1),
(@GUID2+12,189981,571,1,1,6646.551,-876.419,685.5173,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+13,189981,571,1,1,6657.530,-1251.140,397.5630,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID2+14,189981,571,1,1,6666.780,-1032.980,413.8020,-0.08727,0,0,0,1,@TIMER,255,1),
(@GUID2+15,189981,571,1,1,6675.330,-1195.820,398.5400,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID2+16,189981,571,1,1,6677.080,-1207.990,398.8300,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID2+17,189981,571,1,1,6679.290,-1365.290,392.1810,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID2+18,189981,571,1,1,6688.502,-1112.257,397.3456,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+19,189981,571,1,1,6756.100,-1530.500,369.0680,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID2+20,189981,571,1,1,6799.450,-1602.820,354.4390,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID2+21,189981,571,1,1,6816.010,-1364.550,819.6750,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID2+22,189981,571,1,1,6821.420,-607.278,982.4290,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID2+23,189981,571,1,1,6831.780,-1599.010,352.3690,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID2+24,189981,571,1,1,6836.444,-1338.513,819.7522,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+25,189981,571,1,1,6847.579,-1230.780,806.6544,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID2+26,189981,571,1,1,6866.660,-1725.760,827.2400,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID2+27,189981,571,1,1,6867.097,-3428.810,629.1428,-1.44862,0,0,0,1,@TIMER,255,1),
(@GUID2+28,189981,571,1,1,6879.430,-1237.150,810.2590,1.39626,0,0,0,1,@TIMER,255,1),
(@GUID2+29,189981,571,1,1,6900.310,-1523.000,359.9120,-0.24435,0,0,0,1,@TIMER,255,1),
(@GUID2+30,189981,571,1,1,6927.970,-28.980,805.1720,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID2+31,189981,571,1,1,6961.172,-6.584,809.1790,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID2+32,189981,571,1,1,6979.510,-658.492,770.4860,-2.94959,0,0,0,1,@TIMER,255,1),
(@GUID2+33,189981,571,1,1,6981.886,-1205.506,810.1734,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID2+34,189981,571,1,1,6983.300,-1221.080,809.7370,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID2+35,189981,571,1,1,6986.340,-1293.410,820.2910,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID2+36,189981,571,1,1,6994.690,-804.125,736.4880,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID2+37,189981,571,1,1,6996.860,34.220,810.4850,2.60054,0,0,0,1,@TIMER,255,1),
(@GUID2+38,189981,571,1,1,7002.330,-19.649,811.0490,-1.97222,0,0,0,1,@TIMER,255,1),
(@GUID2+39,189981,571,1,1,7005.420,-367.084,788.1000,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID2+40,189981,571,1,1,7008.100,-503.726,745.1890,-0.13962,0,0,0,1,@TIMER,255,1),
(@GUID2+41,189981,571,1,1,7010.060,90.342,814.8490,0.34907,0,0,0,1,@TIMER,255,1),
(@GUID2+42,189981,571,1,1,7019.150,-776.146,732.3610,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID2+43,189981,571,1,1,7019.820,-1357.060,833.0070,-0.68068,0,0,0,1,@TIMER,255,1),
(@GUID2+44,189981,571,1,3,7032.890,-1319.140,820.8290,0.52360,0,0,0,1,@TIMER,255,1),
(@GUID2+45,189981,571,1,1,7051.360,-2016.770,769.8010,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID2+46,189981,571,1,3,7052.570,-1106.910,934.5030,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID2+47,189981,571,1,1,7075.710,-1920.550,774.8670,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+48,189981,571,1,1,7075.710,-1920.546,774.8665,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+49,189981,571,1,4,7080.040,-2724.640,756.8140,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+50,189981,571,1,1,7108.708,-390.674,785.4223,-2.60054,0,0,0,1,@TIMER,255,1),
(@GUID2+51,189981,571,1,2,7109.325,-2248.944,760.0534,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID2+52,189981,571,1,1,7110.417,-543.947,739.8368,-0.73304,0,0,0,1,@TIMER,255,1),
(@GUID2+53,189981,571,1,1,7122.950,-1096.950,928.4570,0.61086,0,0,0,1,@TIMER,255,1),
(@GUID2+54,189981,571,1,4,7134.020,-2760.250,786.9060,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID2+55,189981,571,1,8,7142.310,-3636.810,841.7630,2.72271,0,0,0,1,@TIMER,255,1),
(@GUID2+56,189981,571,1,4,7160.350,-2126.890,762.2910,-1.30900,0,0,0,1,@TIMER,255,1),
(@GUID2+57,189981,571,1,1,7169.138,-1110.031,933.9944,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID2+58,189981,571,1,4,7170.760,-2087.910,771.9970,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID2+59,189981,571,1,1,7171.050,-232.757,808.5810,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID2+60,189981,571,1,4,7177.672,-2048.255,768.8198,-2.05949,0,0,0,1,@TIMER,255,1),
(@GUID2+61,189981,571,1,1,7187.288,-1305.361,946.4589,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID2+62,189981,571,1,1,7187.840,220.090,793.1120,-2.74016,0,0,0,1,@TIMER,255,1),
(@GUID2+63,189981,571,1,4,7191.417,-2963.443,863.3470,0.71558,0,0,0,1,@TIMER,255,1),
(@GUID2+64,189981,571,1,4,7201.295,-1976.741,771.9154,2.70526,0,0,0,1,@TIMER,255,1),
(@GUID2+65,189981,571,1,8,7216.890,-3691.290,822.2200,1.95477,0,0,0,1,@TIMER,255,1),
(@GUID2+66,189981,571,1,1,7224.430,-993.775,926.9220,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID2+67,189981,571,1,2,7233.571,-3542.979,834.7737,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID2+68,189981,571,1,1,7247.440,-1258.090,922.4690,0.12217,0,0,0,1,@TIMER,255,1),
(@GUID2+69,189981,571,1,4,7253.561,-2213.503,765.6185,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID2+70,189981,571,1,3,7263.250,-2858.310,784.9630,3.05433,0,0,0,1,@TIMER,255,1),
(@GUID2+71,189981,571,1,1,7290.680,-158.387,791.6990,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID2+72,189981,571,1,1,7301.970,-1076.270,922.8330,2.77507,0,0,0,1,@TIMER,255,1),
(@GUID2+73,189981,571,1,4,7308.590,-2918.880,829.2740,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID2+74,189981,571,1,4,7310.649,-2244.919,759.6533,2.79252,0,0,0,1,@TIMER,255,1),
(@GUID2+75,189981,571,1,8,7343.630,-3631.950,827.0680,2.86233,0,0,0,1,@TIMER,255,1),
(@GUID2+76,189981,571,1,4,7375.280,-2741.830,755.0170,1.23918,0,0,0,1,@TIMER,255,1),
(@GUID2+77,189981,571,1,1,7402.413,-2801.713,771.3893,2.68781,0,0,0,1,@TIMER,255,1),
(@GUID2+78,189981,571,1,4,7407.630,-3292.640,865.9170,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+79,189981,571,1,1,7425.510,-124.863,794.2450,-1.06465,0,0,0,1,@TIMER,255,1),
(@GUID2+80,189981,571,1,4,7440.669,-2350.947,758.8542,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID2+81,189981,571,1,2,7471.304,-2436.701,759.9119,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID2+82,189981,571,1,1,7610.480,-1368.060,958.4000,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID2+83,189981,571,1,1,7705.490,-3346.280,889.6080,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID2+84,189981,571,1,1,7751.970,-268.932,919.1180,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID2+85,189981,571,1,1,7776.040,-3094.280,917.4480,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID2+86,189981,571,1,1,7808.350,-82.079,880.2680,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID2+87,189981,571,1,1,7828.840,-115.694,886.1690,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+88,189981,571,1,1,7854.360,49.873,1010.9600,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID2+89,189981,571,1,1,7908.766,124.441,1030.6354,-0.75049,0,0,0,1,@TIMER,255,1),
(@GUID2+90,189981,571,1,1,7923.454,-2642.304,1139.8401,0.41888,0,0,0,1,@TIMER,255,1),
(@GUID2+91,189981,571,1,1,8016.460,-2395.760,1161.8300,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+92,189981,571,1,1,8069.040,-2777.400,1050.3100,-1.23918,0,0,0,1,@TIMER,255,1),
(@GUID2+93,189981,571,1,1,8106.100,-2241.150,1167.3900,-0.34907,0,0,0,1,@TIMER,255,1),
(@GUID2+94,189981,571,1,1,8125.980,-218.974,848.5040,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+95,189981,571,1,3,8126.960,-1265.300,1018.4300,-0.99484,0,0,0,1,@TIMER,255,1),
(@GUID2+96,189981,571,1,1,8136.270,-286.253,867.3590,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID2+97,189981,571,1,1,8153.250,-392.846,1020.5000,-2.94959,0,0,0,1,@TIMER,255,1),
(@GUID2+98,189981,571,1,1,8182.390,-729.494,929.5760,1.34390,0,0,0,1,@TIMER,255,1),
(@GUID2+99,189981,571,1,1,8184.400,-2399.480,1139.6400,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID2+100,189981,571,1,1,8191.020,-2794.480,1044.1400,-2.75761,0,0,0,1,@TIMER,255,1),
(@GUID2+101,189981,571,1,1,8196.150,-2734.560,1036.6200,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID2+102,189981,571,1,1,8223.970,-674.648,933.0660,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID2+103,189981,571,1,1,8239.630,-2988.430,1087.3600,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID2+104,189981,571,1,1,8286.560,-212.827,889.2710,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+105,189981,571,1,1,8292.716,-2688.017,1036.6243,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID2+106,189981,571,1,1,8297.316,-1323.155,989.2230,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID2+107,189981,571,1,1,8443.600,-1578.120,1038.2500,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID2+108,189981,571,1,1,8569.773,-1292.149,544.9063,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+109,189981,571,1,1,8636.965,-1181.421,539.1292,-1.32645,0,0,0,1,@TIMER,255,1);
-- Titanium Deposits Storm Peaks
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID3,191133,571,1,1,5973.130,-678.799,384.3029,-1.01229,0,0,0,1,@TIMER,255,1),
(@GUID3+1,191133,571,1,1,5990.065,-1015.166,446.6375,2.19911,0,0,0,1,@TIMER,255,1),
(@GUID3+2,191133,571,1,1,5990.990,-621.435,374.3110,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID3+3,191133,571,1,1,6344.363,-785.474,408.0191,-1.86750,0,0,0,1,@TIMER,255,1),
(@GUID3+4,191133,571,1,1,6394.662,-876.401,409.3433,1.27409,0,0,0,1,@TIMER,255,1),
(@GUID3+5,191133,571,1,1,6518.710,-1309.900,407.2080,2.21656,0,0,0,1,@TIMER,255,1),
(@GUID3+6,191133,571,1,1,6523.616,-1265.091,405.4821,-1.58825,0,0,0,1,@TIMER,255,1),
(@GUID3+7,191133,571,1,1,6570.893,-1050.817,432.5308,-1.36136,0,0,0,1,@TIMER,255,1),
(@GUID3+8,191133,571,1,1,6570.996,-1230.147,404.3670,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID3+9,191133,571,1,1,6571.000,-1230.150,404.3670,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID3+10,191133,571,1,1,6596.600,-1356.010,410.0870,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID3+11,191133,571,1,1,6600.015,-977.058,430.9555,1.06465,0,0,0,1,@TIMER,255,1),
(@GUID3+12,191133,571,1,1,6646.551,-876.419,685.5173,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID3+13,191133,571,1,1,6657.530,-1251.140,397.5630,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID3+14,191133,571,1,1,6666.780,-1032.980,413.8020,-0.08727,0,0,0,1,@TIMER,255,1),
(@GUID3+15,191133,571,1,1,6675.330,-1195.820,398.5400,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID3+16,191133,571,1,1,6677.080,-1207.990,398.8300,-1.90241,0,0,0,1,@TIMER,255,1),
(@GUID3+17,191133,571,1,1,6679.290,-1365.290,392.1810,2.87979,0,0,0,1,@TIMER,255,1),
(@GUID3+18,191133,571,1,1,6688.502,-1112.257,397.3456,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+19,191133,571,1,1,6756.100,-1530.500,369.0680,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID3+20,191133,571,1,1,6799.450,-1602.820,354.4390,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID3+21,191133,571,1,1,6816.010,-1364.550,819.6750,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID3+22,191133,571,1,1,6821.420,-607.278,982.4290,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID3+23,191133,571,1,1,6831.780,-1599.010,352.3690,1.60570,0,0,0,1,@TIMER,255,1),
(@GUID3+24,191133,571,1,1,6836.444,-1338.513,819.7522,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID3+25,191133,571,1,1,6847.579,-1230.780,806.6544,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID3+26,191133,571,1,1,6866.660,-1725.760,827.2400,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID3+27,191133,571,1,1,6867.097,-3428.810,629.1428,-1.44862,0,0,0,1,@TIMER,255,1),
(@GUID3+28,191133,571,1,1,6879.430,-1237.150,810.2590,1.39626,0,0,0,1,@TIMER,255,1),
(@GUID3+29,191133,571,1,1,6900.310,-1523.000,359.9120,-0.24435,0,0,0,1,@TIMER,255,1),
(@GUID3+30,191133,571,1,1,6927.970,-28.980,805.1720,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID3+31,191133,571,1,1,6961.172,-6.584,809.1790,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID3+32,191133,571,1,1,6979.510,-658.492,770.4860,-2.94959,0,0,0,1,@TIMER,255,1),
(@GUID3+33,191133,571,1,1,6981.886,-1205.506,810.1734,2.44346,0,0,0,1,@TIMER,255,1),
(@GUID3+34,191133,571,1,1,6983.300,-1221.080,809.7370,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID3+35,191133,571,1,1,6986.340,-1293.410,820.2910,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID3+36,191133,571,1,1,6994.690,-804.125,736.4880,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID3+37,191133,571,1,1,6996.860,34.220,810.4850,2.60054,0,0,0,1,@TIMER,255,1),
(@GUID3+38,191133,571,1,1,7002.330,-19.649,811.0490,-1.97222,0,0,0,1,@TIMER,255,1),
(@GUID3+39,191133,571,1,1,7005.420,-367.084,788.1000,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID3+40,191133,571,1,1,7008.100,-503.726,745.1890,-0.13962,0,0,0,1,@TIMER,255,1),
(@GUID3+41,191133,571,1,1,7010.060,90.342,814.8490,0.34907,0,0,0,1,@TIMER,255,1),
(@GUID3+42,191133,571,1,1,7019.150,-776.146,732.3610,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID3+43,191133,571,1,1,7019.820,-1357.060,833.0070,-0.68068,0,0,0,1,@TIMER,255,1),
(@GUID3+44,191133,571,1,3,7032.890,-1319.140,820.8290,0.52360,0,0,0,1,@TIMER,255,1),
(@GUID3+45,191133,571,1,1,7051.360,-2016.770,769.8010,-0.78540,0,0,0,1,@TIMER,255,1),
(@GUID3+46,191133,571,1,3,7052.570,-1106.910,934.5030,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID3+47,191133,571,1,1,7075.710,-1920.550,774.8670,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID3+48,191133,571,1,1,7075.710,-1920.546,774.8665,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID3+49,191133,571,1,4,7080.040,-2724.640,756.8140,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID3+50,191133,571,1,1,7108.708,-390.674,785.4223,-2.60054,0,0,0,1,@TIMER,255,1),
(@GUID3+51,191133,571,1,2,7109.325,-2248.944,760.0534,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID3+52,191133,571,1,1,7110.417,-543.947,739.8368,-0.73304,0,0,0,1,@TIMER,255,1),
(@GUID3+53,191133,571,1,1,7122.950,-1096.950,928.4570,0.61086,0,0,0,1,@TIMER,255,1),
(@GUID3+54,191133,571,1,4,7134.020,-2760.250,786.9060,0.22689,0,0,0,1,@TIMER,255,1),
(@GUID3+55,191133,571,1,8,7142.310,-3636.810,841.7630,2.72271,0,0,0,1,@TIMER,255,1),
(@GUID3+56,191133,571,1,4,7160.350,-2126.890,762.2910,-1.30900,0,0,0,1,@TIMER,255,1),
(@GUID3+57,191133,571,1,1,7169.138,-1110.031,933.9944,2.56563,0,0,0,1,@TIMER,255,1),
(@GUID3+58,191133,571,1,4,7170.760,-2087.910,771.9970,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID3+59,191133,571,1,1,7171.050,-232.757,808.5810,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID3+60,191133,571,1,4,7177.672,-2048.255,768.8198,-2.05949,0,0,0,1,@TIMER,255,1),
(@GUID3+61,191133,571,1,1,7187.288,-1305.361,946.4589,0.10472,0,0,0,1,@TIMER,255,1),
(@GUID3+62,191133,571,1,1,7187.840,220.090,793.1120,-2.74016,0,0,0,1,@TIMER,255,1),
(@GUID3+63,191133,571,1,4,7191.417,-2963.443,863.3470,0.71558,0,0,0,1,@TIMER,255,1),
(@GUID3+64,191133,571,1,4,7201.295,-1976.741,771.9154,2.70526,0,0,0,1,@TIMER,255,1),
(@GUID3+65,191133,571,1,8,7216.890,-3691.290,822.2200,1.95477,0,0,0,1,@TIMER,255,1),
(@GUID3+66,191133,571,1,1,7224.430,-993.775,926.9220,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID3+67,191133,571,1,2,7233.571,-3542.979,834.7737,1.64061,0,0,0,1,@TIMER,255,1),
(@GUID3+68,191133,571,1,1,7247.440,-1258.090,922.4690,0.12217,0,0,0,1,@TIMER,255,1),
(@GUID3+69,191133,571,1,4,7253.561,-2213.503,765.6185,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID3+70,191133,571,1,3,7263.250,-2858.310,784.9630,3.05433,0,0,0,1,@TIMER,255,1),
(@GUID3+71,191133,571,1,1,7290.680,-158.387,791.6990,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID3+72,191133,571,1,1,7301.970,-1076.270,922.8330,2.77507,0,0,0,1,@TIMER,255,1),
(@GUID3+73,191133,571,1,4,7308.590,-2918.880,829.2740,2.18166,0,0,0,1,@TIMER,255,1),
(@GUID3+74,191133,571,1,4,7310.649,-2244.919,759.6533,2.79252,0,0,0,1,@TIMER,255,1),
(@GUID3+75,191133,571,1,8,7343.630,-3631.950,827.0680,2.86233,0,0,0,1,@TIMER,255,1),
(@GUID3+76,191133,571,1,4,7375.280,-2741.830,755.0170,1.23918,0,0,0,1,@TIMER,255,1),
(@GUID3+77,191133,571,1,1,7402.413,-2801.713,771.3893,2.68781,0,0,0,1,@TIMER,255,1),
(@GUID3+78,191133,571,1,4,7407.630,-3292.640,865.9170,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID3+79,191133,571,1,1,7425.510,-124.863,794.2450,-1.06465,0,0,0,1,@TIMER,255,1),
(@GUID3+80,191133,571,1,4,7440.669,-2350.947,758.8542,-2.58308,0,0,0,1,@TIMER,255,1),
(@GUID3+81,191133,571,1,2,7471.304,-2436.701,759.9119,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID3+82,191133,571,1,1,7610.480,-1368.060,958.4000,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID3+83,191133,571,1,1,7705.490,-3346.280,889.6080,-0.06981,0,0,0,1,@TIMER,255,1),
(@GUID3+84,191133,571,1,1,7751.970,-268.932,919.1180,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID3+85,191133,571,1,1,7776.040,-3094.280,917.4480,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID3+86,191133,571,1,1,7808.350,-82.079,880.2680,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID3+87,191133,571,1,1,7828.840,-115.694,886.1690,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID3+88,191133,571,1,1,7854.360,49.873,1010.9600,2.02458,0,0,0,1,@TIMER,255,1),
(@GUID3+89,191133,571,1,1,7908.766,124.441,1030.6354,-0.75049,0,0,0,1,@TIMER,255,1),
(@GUID3+90,191133,571,1,1,7923.454,-2642.304,1139.8401,0.41888,0,0,0,1,@TIMER,255,1),
(@GUID3+91,191133,571,1,1,8016.460,-2395.760,1161.8300,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID3+92,191133,571,1,1,8069.040,-2777.400,1050.3100,-1.23918,0,0,0,1,@TIMER,255,1),
(@GUID3+93,191133,571,1,1,8106.100,-2241.150,1167.3900,-0.34907,0,0,0,1,@TIMER,255,1),
(@GUID3+94,191133,571,1,1,8125.980,-218.974,848.5040,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID3+95,191133,571,1,3,8126.960,-1265.300,1018.4300,-0.99484,0,0,0,1,@TIMER,255,1),
(@GUID3+96,191133,571,1,1,8136.270,-286.253,867.3590,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID3+97,191133,571,1,1,8153.250,-392.846,1020.5000,-2.94959,0,0,0,1,@TIMER,255,1),
(@GUID3+98,191133,571,1,1,8182.390,-729.494,929.5760,1.34390,0,0,0,1,@TIMER,255,1),
(@GUID3+99,191133,571,1,1,8184.400,-2399.480,1139.6400,-0.69813,0,0,0,1,@TIMER,255,1),
(@GUID3+100,191133,571,1,1,8191.020,-2794.480,1044.1400,-2.75761,0,0,0,1,@TIMER,255,1),
(@GUID3+101,191133,571,1,1,8196.150,-2734.560,1036.6200,-2.84488,0,0,0,1,@TIMER,255,1),
(@GUID3+102,191133,571,1,1,8223.970,-674.648,933.0660,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID3+103,191133,571,1,1,8239.630,-2988.430,1087.3600,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID3+104,191133,571,1,1,8286.560,-212.827,889.2710,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+105,191133,571,1,1,8292.716,-2688.017,1036.6243,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID3+106,191133,571,1,1,8297.316,-1323.155,989.2230,3.10665,0,0,0,1,@TIMER,255,1),
(@GUID3+107,191133,571,1,1,8443.600,-1578.120,1038.2500,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID3+108,191133,571,1,1,8569.773,-1292.149,544.9063,1.43117,0,0,0,1,@TIMER,255,1),
(@GUID3+109,191133,571,1,1,8636.965,-1181.421,539.1292,-1.32645,0,0,0,1,@TIMER,255,1);
-- Pooling
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID1 AND @GUID1+@RANGE;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID2 AND @GUID2+@RANGE;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID3 AND @GUID3+@RANGE;
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+0,@POOL+0,@CHANCE1, 'Storm Peaks Ore Spawnpoint 1 Saronite'),
(@GUID2+0,@POOL+0,@CHANCE2, 'Storm Peaks Ore Spawnpoint 1 Rich Saronite'),
(@GUID3+0,@POOL+0,@CHANCE3, 'Storm Peaks Ore Spawnpoint 1 Titanium'),
(@GUID1+1,@POOL+1,@CHANCE1, 'Storm Peaks Ore Spawnpoint 2 Saronite'),
(@GUID2+1,@POOL+1,@CHANCE2, 'Storm Peaks Ore Spawnpoint 2 Rich Saronite'),
(@GUID3+1,@POOL+1,@CHANCE3, 'Storm Peaks Ore Spawnpoint 2 Titanium'),
(@GUID1+2,@POOL+2,@CHANCE1, 'Storm Peaks Ore Spawnpoint 3 Saronite'),
(@GUID2+2,@POOL+2,@CHANCE2, 'Storm Peaks Ore Spawnpoint 3 Rich Saronite'),
(@GUID3+2,@POOL+2,@CHANCE3, 'Storm Peaks Ore Spawnpoint 3 Titanium'),
(@GUID1+3,@POOL+3,@CHANCE1, 'Storm Peaks Ore Spawnpoint 4 Saronite'),
(@GUID2+3,@POOL+3,@CHANCE2, 'Storm Peaks Ore Spawnpoint 4 Rich Saronite'),
(@GUID3+3,@POOL+3,@CHANCE3, 'Storm Peaks Ore Spawnpoint 4 Titanium'),
(@GUID1+4,@POOL+4,@CHANCE1, 'Storm Peaks Ore Spawnpoint 5 Saronite'),
(@GUID2+4,@POOL+4,@CHANCE2, 'Storm Peaks Ore Spawnpoint 5 Rich Saronite'),
(@GUID3+4,@POOL+4,@CHANCE3, 'Storm Peaks Ore Spawnpoint 5 Titanium'),
(@GUID1+5,@POOL+5,@CHANCE1, 'Storm Peaks Ore Spawnpoint 6 Saronite'),
(@GUID2+5,@POOL+5,@CHANCE2, 'Storm Peaks Ore Spawnpoint 6 Rich Saronite'),
(@GUID3+5,@POOL+5,@CHANCE3, 'Storm Peaks Ore Spawnpoint 6 Titanium'),
(@GUID1+6,@POOL+6,@CHANCE1, 'Storm Peaks Ore Spawnpoint 7 Saronite'),
(@GUID2+6,@POOL+6,@CHANCE2, 'Storm Peaks Ore Spawnpoint 7 Rich Saronite'),
(@GUID3+6,@POOL+6,@CHANCE3, 'Storm Peaks Ore Spawnpoint 7 Titanium'),
(@GUID1+7,@POOL+7,@CHANCE1, 'Storm Peaks Ore Spawnpoint 8 Saronite'),
(@GUID2+7,@POOL+7,@CHANCE2, 'Storm Peaks Ore Spawnpoint 8 Rich Saronite'),
(@GUID3+7,@POOL+7,@CHANCE3, 'Storm Peaks Ore Spawnpoint 8 Titanium'),
(@GUID1+8,@POOL+8,@CHANCE1, 'Storm Peaks Ore Spawnpoint 9 Saronite'),
(@GUID2+8,@POOL+8,@CHANCE2, 'Storm Peaks Ore Spawnpoint 9 Rich Saronite'),
(@GUID3+8,@POOL+8,@CHANCE3, 'Storm Peaks Ore Spawnpoint 9 Titanium'),
(@GUID1+9,@POOL+9,@CHANCE1, 'Storm Peaks Ore Spawnpoint 10 Saronite'),
(@GUID2+9,@POOL+9,@CHANCE2, 'Storm Peaks Ore Spawnpoint 10 Rich Saronite'),
(@GUID3+9,@POOL+9,@CHANCE3, 'Storm Peaks Ore Spawnpoint 10 Titanium'),
(@GUID1+10,@POOL+10,@CHANCE1, 'Storm Peaks Ore Spawnpoint 11 Saronite'),
(@GUID2+10,@POOL+10,@CHANCE2, 'Storm Peaks Ore Spawnpoint 11 Rich Saronite'),
(@GUID3+10,@POOL+10,@CHANCE3, 'Storm Peaks Ore Spawnpoint 11 Titanium'),
(@GUID1+11,@POOL+11,@CHANCE1, 'Storm Peaks Ore Spawnpoint 12 Saronite'),
(@GUID2+11,@POOL+11,@CHANCE2, 'Storm Peaks Ore Spawnpoint 12 Rich Saronite'),
(@GUID3+11,@POOL+11,@CHANCE3, 'Storm Peaks Ore Spawnpoint 12 Titanium'),
(@GUID1+12,@POOL+12,@CHANCE1, 'Storm Peaks Ore Spawnpoint 13 Saronite'),
(@GUID2+12,@POOL+12,@CHANCE2, 'Storm Peaks Ore Spawnpoint 13 Rich Saronite'),
(@GUID3+12,@POOL+12,@CHANCE3, 'Storm Peaks Ore Spawnpoint 13 Titanium'),
(@GUID1+13,@POOL+13,@CHANCE1, 'Storm Peaks Ore Spawnpoint 14 Saronite'),
(@GUID2+13,@POOL+13,@CHANCE2, 'Storm Peaks Ore Spawnpoint 14 Rich Saronite'),
(@GUID3+13,@POOL+13,@CHANCE3, 'Storm Peaks Ore Spawnpoint 14 Titanium'),
(@GUID1+14,@POOL+14,@CHANCE1, 'Storm Peaks Ore Spawnpoint 15 Saronite'),
(@GUID2+14,@POOL+14,@CHANCE2, 'Storm Peaks Ore Spawnpoint 15 Rich Saronite'),
(@GUID3+14,@POOL+14,@CHANCE3, 'Storm Peaks Ore Spawnpoint 15 Titanium'),
(@GUID1+15,@POOL+15,@CHANCE1, 'Storm Peaks Ore Spawnpoint 16 Saronite'),
(@GUID2+15,@POOL+15,@CHANCE2, 'Storm Peaks Ore Spawnpoint 16 Rich Saronite'),
(@GUID3+15,@POOL+15,@CHANCE3, 'Storm Peaks Ore Spawnpoint 16 Titanium'),
(@GUID1+16,@POOL+16,@CHANCE1, 'Storm Peaks Ore Spawnpoint 17 Saronite'),
(@GUID2+16,@POOL+16,@CHANCE2, 'Storm Peaks Ore Spawnpoint 17 Rich Saronite'),
(@GUID3+16,@POOL+16,@CHANCE3, 'Storm Peaks Ore Spawnpoint 17 Titanium'),
(@GUID1+17,@POOL+17,@CHANCE1, 'Storm Peaks Ore Spawnpoint 18 Saronite'),
(@GUID2+17,@POOL+17,@CHANCE2, 'Storm Peaks Ore Spawnpoint 18 Rich Saronite'),
(@GUID3+17,@POOL+17,@CHANCE3, 'Storm Peaks Ore Spawnpoint 18 Titanium'),
(@GUID1+18,@POOL+18,@CHANCE1, 'Storm Peaks Ore Spawnpoint 19 Saronite'),
(@GUID2+18,@POOL+18,@CHANCE2, 'Storm Peaks Ore Spawnpoint 19 Rich Saronite'),
(@GUID3+18,@POOL+18,@CHANCE3, 'Storm Peaks Ore Spawnpoint 19 Titanium'),
(@GUID1+19,@POOL+19,@CHANCE1, 'Storm Peaks Ore Spawnpoint 20 Saronite'),
(@GUID2+19,@POOL+19,@CHANCE2, 'Storm Peaks Ore Spawnpoint 20 Rich Saronite'),
(@GUID3+19,@POOL+19,@CHANCE3, 'Storm Peaks Ore Spawnpoint 20 Titanium'),
(@GUID1+20,@POOL+20,@CHANCE1, 'Storm Peaks Ore Spawnpoint 21 Saronite'),
(@GUID2+20,@POOL+20,@CHANCE2, 'Storm Peaks Ore Spawnpoint 21 Rich Saronite'),
(@GUID3+20,@POOL+20,@CHANCE3, 'Storm Peaks Ore Spawnpoint 21 Titanium'),
(@GUID1+21,@POOL+21,@CHANCE1, 'Storm Peaks Ore Spawnpoint 22 Saronite'),
(@GUID2+21,@POOL+21,@CHANCE2, 'Storm Peaks Ore Spawnpoint 22 Rich Saronite'),
(@GUID3+21,@POOL+21,@CHANCE3, 'Storm Peaks Ore Spawnpoint 22 Titanium'),
(@GUID1+22,@POOL+22,@CHANCE1, 'Storm Peaks Ore Spawnpoint 23 Saronite'),
(@GUID2+22,@POOL+22,@CHANCE2, 'Storm Peaks Ore Spawnpoint 23 Rich Saronite'),
(@GUID3+22,@POOL+22,@CHANCE3, 'Storm Peaks Ore Spawnpoint 23 Titanium'),
(@GUID1+23,@POOL+23,@CHANCE1, 'Storm Peaks Ore Spawnpoint 24 Saronite'),
(@GUID2+23,@POOL+23,@CHANCE2, 'Storm Peaks Ore Spawnpoint 24 Rich Saronite'),
(@GUID3+23,@POOL+23,@CHANCE3, 'Storm Peaks Ore Spawnpoint 24 Titanium'),
(@GUID1+24,@POOL+24,@CHANCE1, 'Storm Peaks Ore Spawnpoint 25 Saronite'),
(@GUID2+24,@POOL+24,@CHANCE2, 'Storm Peaks Ore Spawnpoint 25 Rich Saronite'),
(@GUID3+24,@POOL+24,@CHANCE3, 'Storm Peaks Ore Spawnpoint 25 Titanium'),
(@GUID1+25,@POOL+25,@CHANCE1, 'Storm Peaks Ore Spawnpoint 26 Saronite'),
(@GUID2+25,@POOL+25,@CHANCE2, 'Storm Peaks Ore Spawnpoint 26 Rich Saronite'),
(@GUID3+25,@POOL+25,@CHANCE3, 'Storm Peaks Ore Spawnpoint 26 Titanium'),
(@GUID1+26,@POOL+26,@CHANCE1, 'Storm Peaks Ore Spawnpoint 27 Saronite'),
(@GUID2+26,@POOL+26,@CHANCE2, 'Storm Peaks Ore Spawnpoint 27 Rich Saronite'),
(@GUID3+26,@POOL+26,@CHANCE3, 'Storm Peaks Ore Spawnpoint 27 Titanium'),
(@GUID1+27,@POOL+27,@CHANCE1, 'Storm Peaks Ore Spawnpoint 28 Saronite'),
(@GUID2+27,@POOL+27,@CHANCE2, 'Storm Peaks Ore Spawnpoint 28 Rich Saronite'),
(@GUID3+27,@POOL+27,@CHANCE3, 'Storm Peaks Ore Spawnpoint 28 Titanium'),
(@GUID1+28,@POOL+28,@CHANCE1, 'Storm Peaks Ore Spawnpoint 29 Saronite'),
(@GUID2+28,@POOL+28,@CHANCE2, 'Storm Peaks Ore Spawnpoint 29 Rich Saronite'),
(@GUID3+28,@POOL+28,@CHANCE3, 'Storm Peaks Ore Spawnpoint 29 Titanium'),
(@GUID1+29,@POOL+29,@CHANCE1, 'Storm Peaks Ore Spawnpoint 30 Saronite'),
(@GUID2+29,@POOL+29,@CHANCE2, 'Storm Peaks Ore Spawnpoint 30 Rich Saronite'),
(@GUID3+29,@POOL+29,@CHANCE3, 'Storm Peaks Ore Spawnpoint 30 Titanium'),
(@GUID1+30,@POOL+30,@CHANCE1, 'Storm Peaks Ore Spawnpoint 31 Saronite'),
(@GUID2+30,@POOL+30,@CHANCE2, 'Storm Peaks Ore Spawnpoint 31 Rich Saronite'),
(@GUID3+30,@POOL+30,@CHANCE3, 'Storm Peaks Ore Spawnpoint 31 Titanium'),
(@GUID1+31,@POOL+31,@CHANCE1, 'Storm Peaks Ore Spawnpoint 32 Saronite'),
(@GUID2+31,@POOL+31,@CHANCE2, 'Storm Peaks Ore Spawnpoint 32 Rich Saronite'),
(@GUID3+31,@POOL+31,@CHANCE3, 'Storm Peaks Ore Spawnpoint 32 Titanium'),
(@GUID1+32,@POOL+32,@CHANCE1, 'Storm Peaks Ore Spawnpoint 33 Saronite'),
(@GUID2+32,@POOL+32,@CHANCE2, 'Storm Peaks Ore Spawnpoint 33 Rich Saronite'),
(@GUID3+32,@POOL+32,@CHANCE3, 'Storm Peaks Ore Spawnpoint 33 Titanium'),
(@GUID1+33,@POOL+33,@CHANCE1, 'Storm Peaks Ore Spawnpoint 34 Saronite'),
(@GUID2+33,@POOL+33,@CHANCE2, 'Storm Peaks Ore Spawnpoint 34 Rich Saronite'),
(@GUID3+33,@POOL+33,@CHANCE3, 'Storm Peaks Ore Spawnpoint 34 Titanium'),
(@GUID1+34,@POOL+34,@CHANCE1, 'Storm Peaks Ore Spawnpoint 35 Saronite'),
(@GUID2+34,@POOL+34,@CHANCE2, 'Storm Peaks Ore Spawnpoint 35 Rich Saronite'),
(@GUID3+34,@POOL+34,@CHANCE3, 'Storm Peaks Ore Spawnpoint 35 Titanium'),
(@GUID1+35,@POOL+35,@CHANCE1, 'Storm Peaks Ore Spawnpoint 36 Saronite'),
(@GUID2+35,@POOL+35,@CHANCE2, 'Storm Peaks Ore Spawnpoint 36 Rich Saronite'),
(@GUID3+35,@POOL+35,@CHANCE3, 'Storm Peaks Ore Spawnpoint 36 Titanium'),
(@GUID1+36,@POOL+36,@CHANCE1, 'Storm Peaks Ore Spawnpoint 37 Saronite'),
(@GUID2+36,@POOL+36,@CHANCE2, 'Storm Peaks Ore Spawnpoint 37 Rich Saronite'),
(@GUID3+36,@POOL+36,@CHANCE3, 'Storm Peaks Ore Spawnpoint 37 Titanium'),
(@GUID1+37,@POOL+37,@CHANCE1, 'Storm Peaks Ore Spawnpoint 38 Saronite'),
(@GUID2+37,@POOL+37,@CHANCE2, 'Storm Peaks Ore Spawnpoint 38 Rich Saronite'),
(@GUID3+37,@POOL+37,@CHANCE3, 'Storm Peaks Ore Spawnpoint 38 Titanium'),
(@GUID1+38,@POOL+38,@CHANCE1, 'Storm Peaks Ore Spawnpoint 39 Saronite'),
(@GUID2+38,@POOL+38,@CHANCE2, 'Storm Peaks Ore Spawnpoint 39 Rich Saronite'),
(@GUID3+38,@POOL+38,@CHANCE3, 'Storm Peaks Ore Spawnpoint 39 Titanium'),
(@GUID1+39,@POOL+39,@CHANCE1, 'Storm Peaks Ore Spawnpoint 40 Saronite'),
(@GUID2+39,@POOL+39,@CHANCE2, 'Storm Peaks Ore Spawnpoint 40 Rich Saronite'),
(@GUID3+39,@POOL+39,@CHANCE3, 'Storm Peaks Ore Spawnpoint 40 Titanium'),
(@GUID1+40,@POOL+40,@CHANCE1, 'Storm Peaks Ore Spawnpoint 41 Saronite'),
(@GUID2+40,@POOL+40,@CHANCE2, 'Storm Peaks Ore Spawnpoint 41 Rich Saronite'),
(@GUID3+40,@POOL+40,@CHANCE3, 'Storm Peaks Ore Spawnpoint 41 Titanium'),
(@GUID1+41,@POOL+41,@CHANCE1, 'Storm Peaks Ore Spawnpoint 42 Saronite'),
(@GUID2+41,@POOL+41,@CHANCE2, 'Storm Peaks Ore Spawnpoint 42 Rich Saronite'),
(@GUID3+41,@POOL+41,@CHANCE3, 'Storm Peaks Ore Spawnpoint 42 Titanium'),
(@GUID1+42,@POOL+42,@CHANCE1, 'Storm Peaks Ore Spawnpoint 43 Saronite'),
(@GUID2+42,@POOL+42,@CHANCE2, 'Storm Peaks Ore Spawnpoint 43 Rich Saronite'),
(@GUID3+42,@POOL+42,@CHANCE3, 'Storm Peaks Ore Spawnpoint 43 Titanium'),
(@GUID1+43,@POOL+43,@CHANCE1, 'Storm Peaks Ore Spawnpoint 44 Saronite'),
(@GUID2+43,@POOL+43,@CHANCE2, 'Storm Peaks Ore Spawnpoint 44 Rich Saronite'),
(@GUID3+43,@POOL+43,@CHANCE3, 'Storm Peaks Ore Spawnpoint 44 Titanium'),
(@GUID1+44,@POOL+44,@CHANCE1, 'Storm Peaks Ore Spawnpoint 45 Saronite'),
(@GUID2+44,@POOL+44,@CHANCE2, 'Storm Peaks Ore Spawnpoint 45 Rich Saronite'),
(@GUID3+44,@POOL+44,@CHANCE3, 'Storm Peaks Ore Spawnpoint 45 Titanium'),
(@GUID1+45,@POOL+45,@CHANCE1, 'Storm Peaks Ore Spawnpoint 46 Saronite'),
(@GUID2+45,@POOL+45,@CHANCE2, 'Storm Peaks Ore Spawnpoint 46 Rich Saronite'),
(@GUID3+45,@POOL+45,@CHANCE3, 'Storm Peaks Ore Spawnpoint 46 Titanium'),
(@GUID1+46,@POOL+46,@CHANCE1, 'Storm Peaks Ore Spawnpoint 47 Saronite'),
(@GUID2+46,@POOL+46,@CHANCE2, 'Storm Peaks Ore Spawnpoint 47 Rich Saronite'),
(@GUID3+46,@POOL+46,@CHANCE3, 'Storm Peaks Ore Spawnpoint 47 Titanium'),
(@GUID1+47,@POOL+47,@CHANCE1, 'Storm Peaks Ore Spawnpoint 48 Saronite'),
(@GUID2+47,@POOL+47,@CHANCE2, 'Storm Peaks Ore Spawnpoint 48 Rich Saronite'),
(@GUID3+47,@POOL+47,@CHANCE3, 'Storm Peaks Ore Spawnpoint 48 Titanium'),
(@GUID1+48,@POOL+48,@CHANCE1, 'Storm Peaks Ore Spawnpoint 49 Saronite'),
(@GUID2+48,@POOL+48,@CHANCE2, 'Storm Peaks Ore Spawnpoint 49 Rich Saronite'),
(@GUID3+48,@POOL+48,@CHANCE3, 'Storm Peaks Ore Spawnpoint 49 Titanium'),
(@GUID1+49,@POOL+49,@CHANCE1, 'Storm Peaks Ore Spawnpoint 50 Saronite'),
(@GUID2+49,@POOL+49,@CHANCE2, 'Storm Peaks Ore Spawnpoint 50 Rich Saronite'),
(@GUID3+49,@POOL+49,@CHANCE3, 'Storm Peaks Ore Spawnpoint 50 Titanium'),
(@GUID1+50,@POOL+50,@CHANCE1, 'Storm Peaks Ore Spawnpoint 51 Saronite'),
(@GUID2+50,@POOL+50,@CHANCE2, 'Storm Peaks Ore Spawnpoint 51 Rich Saronite'),
(@GUID3+50,@POOL+50,@CHANCE3, 'Storm Peaks Ore Spawnpoint 51 Titanium'),
(@GUID1+51,@POOL+51,@CHANCE1, 'Storm Peaks Ore Spawnpoint 52 Saronite'),
(@GUID2+51,@POOL+51,@CHANCE2, 'Storm Peaks Ore Spawnpoint 52 Rich Saronite'),
(@GUID3+51,@POOL+51,@CHANCE3, 'Storm Peaks Ore Spawnpoint 52 Titanium'),
(@GUID1+52,@POOL+52,@CHANCE1, 'Storm Peaks Ore Spawnpoint 53 Saronite'),
(@GUID2+52,@POOL+52,@CHANCE2, 'Storm Peaks Ore Spawnpoint 53 Rich Saronite'),
(@GUID3+52,@POOL+52,@CHANCE3, 'Storm Peaks Ore Spawnpoint 53 Titanium'),
(@GUID1+53,@POOL+53,@CHANCE1, 'Storm Peaks Ore Spawnpoint 54 Saronite'),
(@GUID2+53,@POOL+53,@CHANCE2, 'Storm Peaks Ore Spawnpoint 54 Rich Saronite'),
(@GUID3+53,@POOL+53,@CHANCE3, 'Storm Peaks Ore Spawnpoint 54 Titanium'),
(@GUID1+54,@POOL+54,@CHANCE1, 'Storm Peaks Ore Spawnpoint 55 Saronite'),
(@GUID2+54,@POOL+54,@CHANCE2, 'Storm Peaks Ore Spawnpoint 55 Rich Saronite'),
(@GUID3+54,@POOL+54,@CHANCE3, 'Storm Peaks Ore Spawnpoint 55 Titanium'),
(@GUID1+55,@POOL+55,@CHANCE1, 'Storm Peaks Ore Spawnpoint 56 Saronite'),
(@GUID2+55,@POOL+55,@CHANCE2, 'Storm Peaks Ore Spawnpoint 56 Rich Saronite'),
(@GUID3+55,@POOL+55,@CHANCE3, 'Storm Peaks Ore Spawnpoint 56 Titanium'),
(@GUID1+56,@POOL+56,@CHANCE1, 'Storm Peaks Ore Spawnpoint 57 Saronite'),
(@GUID2+56,@POOL+56,@CHANCE2, 'Storm Peaks Ore Spawnpoint 57 Rich Saronite'),
(@GUID3+56,@POOL+56,@CHANCE3, 'Storm Peaks Ore Spawnpoint 57 Titanium'),
(@GUID1+57,@POOL+57,@CHANCE1, 'Storm Peaks Ore Spawnpoint 58 Saronite'),
(@GUID2+57,@POOL+57,@CHANCE2, 'Storm Peaks Ore Spawnpoint 58 Rich Saronite'),
(@GUID3+57,@POOL+57,@CHANCE3, 'Storm Peaks Ore Spawnpoint 58 Titanium'),
(@GUID1+58,@POOL+58,@CHANCE1, 'Storm Peaks Ore Spawnpoint 59 Saronite'),
(@GUID2+58,@POOL+58,@CHANCE2, 'Storm Peaks Ore Spawnpoint 59 Rich Saronite'),
(@GUID3+58,@POOL+58,@CHANCE3, 'Storm Peaks Ore Spawnpoint 59 Titanium'),
(@GUID1+59,@POOL+59,@CHANCE1, 'Storm Peaks Ore Spawnpoint 60 Saronite'),
(@GUID2+59,@POOL+59,@CHANCE2, 'Storm Peaks Ore Spawnpoint 60 Rich Saronite'),
(@GUID3+59,@POOL+59,@CHANCE3, 'Storm Peaks Ore Spawnpoint 60 Titanium'),
(@GUID1+60,@POOL+60,@CHANCE1, 'Storm Peaks Ore Spawnpoint 61 Saronite'),
(@GUID2+60,@POOL+60,@CHANCE2, 'Storm Peaks Ore Spawnpoint 61 Rich Saronite'),
(@GUID3+60,@POOL+60,@CHANCE3, 'Storm Peaks Ore Spawnpoint 61 Titanium'),
(@GUID1+61,@POOL+61,@CHANCE1, 'Storm Peaks Ore Spawnpoint 62 Saronite'),
(@GUID2+61,@POOL+61,@CHANCE2, 'Storm Peaks Ore Spawnpoint 62 Rich Saronite'),
(@GUID3+61,@POOL+61,@CHANCE3, 'Storm Peaks Ore Spawnpoint 62 Titanium'),
(@GUID1+62,@POOL+62,@CHANCE1, 'Storm Peaks Ore Spawnpoint 63 Saronite'),
(@GUID2+62,@POOL+62,@CHANCE2, 'Storm Peaks Ore Spawnpoint 63 Rich Saronite'),
(@GUID3+62,@POOL+62,@CHANCE3, 'Storm Peaks Ore Spawnpoint 63 Titanium'),
(@GUID1+63,@POOL+63,@CHANCE1, 'Storm Peaks Ore Spawnpoint 64 Saronite'),
(@GUID2+63,@POOL+63,@CHANCE2, 'Storm Peaks Ore Spawnpoint 64 Rich Saronite'),
(@GUID3+63,@POOL+63,@CHANCE3, 'Storm Peaks Ore Spawnpoint 64 Titanium'),
(@GUID1+64,@POOL+64,@CHANCE1, 'Storm Peaks Ore Spawnpoint 65 Saronite'),
(@GUID2+64,@POOL+64,@CHANCE2, 'Storm Peaks Ore Spawnpoint 65 Rich Saronite'),
(@GUID3+64,@POOL+64,@CHANCE3, 'Storm Peaks Ore Spawnpoint 65 Titanium'),
(@GUID1+65,@POOL+65,@CHANCE1, 'Storm Peaks Ore Spawnpoint 66 Saronite'),
(@GUID2+65,@POOL+65,@CHANCE2, 'Storm Peaks Ore Spawnpoint 66 Rich Saronite'),
(@GUID3+65,@POOL+65,@CHANCE3, 'Storm Peaks Ore Spawnpoint 66 Titanium'),
(@GUID1+66,@POOL+66,@CHANCE1, 'Storm Peaks Ore Spawnpoint 67 Saronite'),
(@GUID2+66,@POOL+66,@CHANCE2, 'Storm Peaks Ore Spawnpoint 67 Rich Saronite'),
(@GUID3+66,@POOL+66,@CHANCE3, 'Storm Peaks Ore Spawnpoint 67 Titanium'),
(@GUID1+67,@POOL+67,@CHANCE1, 'Storm Peaks Ore Spawnpoint 68 Saronite'),
(@GUID2+67,@POOL+67,@CHANCE2, 'Storm Peaks Ore Spawnpoint 68 Rich Saronite'),
(@GUID3+67,@POOL+67,@CHANCE3, 'Storm Peaks Ore Spawnpoint 68 Titanium'),
(@GUID1+68,@POOL+68,@CHANCE1, 'Storm Peaks Ore Spawnpoint 69 Saronite'),
(@GUID2+68,@POOL+68,@CHANCE2, 'Storm Peaks Ore Spawnpoint 69 Rich Saronite'),
(@GUID3+68,@POOL+68,@CHANCE3, 'Storm Peaks Ore Spawnpoint 69 Titanium'),
(@GUID1+69,@POOL+69,@CHANCE1, 'Storm Peaks Ore Spawnpoint 70 Saronite'),
(@GUID2+69,@POOL+69,@CHANCE2, 'Storm Peaks Ore Spawnpoint 70 Rich Saronite'),
(@GUID3+69,@POOL+69,@CHANCE3, 'Storm Peaks Ore Spawnpoint 70 Titanium'),
(@GUID1+70,@POOL+70,@CHANCE1, 'Storm Peaks Ore Spawnpoint 71 Saronite'),
(@GUID2+70,@POOL+70,@CHANCE2, 'Storm Peaks Ore Spawnpoint 71 Rich Saronite'),
(@GUID3+70,@POOL+70,@CHANCE3, 'Storm Peaks Ore Spawnpoint 71 Titanium'),
(@GUID1+71,@POOL+71,@CHANCE1, 'Storm Peaks Ore Spawnpoint 72 Saronite'),
(@GUID2+71,@POOL+71,@CHANCE2, 'Storm Peaks Ore Spawnpoint 72 Rich Saronite'),
(@GUID3+71,@POOL+71,@CHANCE3, 'Storm Peaks Ore Spawnpoint 72 Titanium'),
(@GUID1+72,@POOL+72,@CHANCE1, 'Storm Peaks Ore Spawnpoint 73 Saronite'),
(@GUID2+72,@POOL+72,@CHANCE2, 'Storm Peaks Ore Spawnpoint 73 Rich Saronite'),
(@GUID3+72,@POOL+72,@CHANCE3, 'Storm Peaks Ore Spawnpoint 73 Titanium'),
(@GUID1+73,@POOL+73,@CHANCE1, 'Storm Peaks Ore Spawnpoint 74 Saronite'),
(@GUID2+73,@POOL+73,@CHANCE2, 'Storm Peaks Ore Spawnpoint 74 Rich Saronite'),
(@GUID3+73,@POOL+73,@CHANCE3, 'Storm Peaks Ore Spawnpoint 74 Titanium'),
(@GUID1+74,@POOL+74,@CHANCE1, 'Storm Peaks Ore Spawnpoint 75 Saronite'),
(@GUID2+74,@POOL+74,@CHANCE2, 'Storm Peaks Ore Spawnpoint 75 Rich Saronite'),
(@GUID3+74,@POOL+74,@CHANCE3, 'Storm Peaks Ore Spawnpoint 75 Titanium'),
(@GUID1+75,@POOL+75,@CHANCE1, 'Storm Peaks Ore Spawnpoint 76 Saronite'),
(@GUID2+75,@POOL+75,@CHANCE2, 'Storm Peaks Ore Spawnpoint 76 Rich Saronite'),
(@GUID3+75,@POOL+75,@CHANCE3, 'Storm Peaks Ore Spawnpoint 76 Titanium'),
(@GUID1+76,@POOL+76,@CHANCE1, 'Storm Peaks Ore Spawnpoint 77 Saronite'),
(@GUID2+76,@POOL+76,@CHANCE2, 'Storm Peaks Ore Spawnpoint 77 Rich Saronite'),
(@GUID3+76,@POOL+76,@CHANCE3, 'Storm Peaks Ore Spawnpoint 77 Titanium'),
(@GUID1+77,@POOL+77,@CHANCE1, 'Storm Peaks Ore Spawnpoint 78 Saronite'),
(@GUID2+77,@POOL+77,@CHANCE2, 'Storm Peaks Ore Spawnpoint 78 Rich Saronite'),
(@GUID3+77,@POOL+77,@CHANCE3, 'Storm Peaks Ore Spawnpoint 78 Titanium'),
(@GUID1+78,@POOL+78,@CHANCE1, 'Storm Peaks Ore Spawnpoint 79 Saronite'),
(@GUID2+78,@POOL+78,@CHANCE2, 'Storm Peaks Ore Spawnpoint 79 Rich Saronite'),
(@GUID3+78,@POOL+78,@CHANCE3, 'Storm Peaks Ore Spawnpoint 79 Titanium'),
(@GUID1+79,@POOL+79,@CHANCE1, 'Storm Peaks Ore Spawnpoint 80 Saronite'),
(@GUID2+79,@POOL+79,@CHANCE2, 'Storm Peaks Ore Spawnpoint 80 Rich Saronite'),
(@GUID3+79,@POOL+79,@CHANCE3, 'Storm Peaks Ore Spawnpoint 80 Titanium'),
(@GUID1+80,@POOL+80,@CHANCE1, 'Storm Peaks Ore Spawnpoint 81 Saronite'),
(@GUID2+80,@POOL+80,@CHANCE2, 'Storm Peaks Ore Spawnpoint 81 Rich Saronite'),
(@GUID3+80,@POOL+80,@CHANCE3, 'Storm Peaks Ore Spawnpoint 81 Titanium'),
(@GUID1+81,@POOL+81,@CHANCE1, 'Storm Peaks Ore Spawnpoint 82 Saronite'),
(@GUID2+81,@POOL+81,@CHANCE2, 'Storm Peaks Ore Spawnpoint 82 Rich Saronite'),
(@GUID3+81,@POOL+81,@CHANCE3, 'Storm Peaks Ore Spawnpoint 82 Titanium'),
(@GUID1+82,@POOL+82,@CHANCE1, 'Storm Peaks Ore Spawnpoint 83 Saronite'),
(@GUID2+82,@POOL+82,@CHANCE2, 'Storm Peaks Ore Spawnpoint 83 Rich Saronite'),
(@GUID3+82,@POOL+82,@CHANCE3, 'Storm Peaks Ore Spawnpoint 83 Titanium'),
(@GUID1+83,@POOL+83,@CHANCE1, 'Storm Peaks Ore Spawnpoint 84 Saronite'),
(@GUID2+83,@POOL+83,@CHANCE2, 'Storm Peaks Ore Spawnpoint 84 Rich Saronite'),
(@GUID3+83,@POOL+83,@CHANCE3, 'Storm Peaks Ore Spawnpoint 84 Titanium'),
(@GUID1+84,@POOL+84,@CHANCE1, 'Storm Peaks Ore Spawnpoint 85 Saronite'),
(@GUID2+84,@POOL+84,@CHANCE2, 'Storm Peaks Ore Spawnpoint 85 Rich Saronite'),
(@GUID3+84,@POOL+84,@CHANCE3, 'Storm Peaks Ore Spawnpoint 85 Titanium'),
(@GUID1+85,@POOL+85,@CHANCE1, 'Storm Peaks Ore Spawnpoint 86 Saronite'),
(@GUID2+85,@POOL+85,@CHANCE2, 'Storm Peaks Ore Spawnpoint 86 Rich Saronite'),
(@GUID3+85,@POOL+85,@CHANCE3, 'Storm Peaks Ore Spawnpoint 86 Titanium'),
(@GUID1+86,@POOL+86,@CHANCE1, 'Storm Peaks Ore Spawnpoint 87 Saronite'),
(@GUID2+86,@POOL+86,@CHANCE2, 'Storm Peaks Ore Spawnpoint 87 Rich Saronite'),
(@GUID3+86,@POOL+86,@CHANCE3, 'Storm Peaks Ore Spawnpoint 87 Titanium'),
(@GUID1+87,@POOL+87,@CHANCE1, 'Storm Peaks Ore Spawnpoint 88 Saronite'),
(@GUID2+87,@POOL+87,@CHANCE2, 'Storm Peaks Ore Spawnpoint 88 Rich Saronite'),
(@GUID3+87,@POOL+87,@CHANCE3, 'Storm Peaks Ore Spawnpoint 88 Titanium'),
(@GUID1+88,@POOL+88,@CHANCE1, 'Storm Peaks Ore Spawnpoint 89 Saronite'),
(@GUID2+88,@POOL+88,@CHANCE2, 'Storm Peaks Ore Spawnpoint 89 Rich Saronite'),
(@GUID3+88,@POOL+88,@CHANCE3, 'Storm Peaks Ore Spawnpoint 89 Titanium'),
(@GUID1+89,@POOL+89,@CHANCE1, 'Storm Peaks Ore Spawnpoint 90 Saronite'),
(@GUID2+89,@POOL+89,@CHANCE2, 'Storm Peaks Ore Spawnpoint 90 Rich Saronite'),
(@GUID3+89,@POOL+89,@CHANCE3, 'Storm Peaks Ore Spawnpoint 90 Titanium'),
(@GUID1+90,@POOL+90,@CHANCE1, 'Storm Peaks Ore Spawnpoint 91 Saronite'),
(@GUID2+90,@POOL+90,@CHANCE2, 'Storm Peaks Ore Spawnpoint 91 Rich Saronite'),
(@GUID3+90,@POOL+90,@CHANCE3, 'Storm Peaks Ore Spawnpoint 91 Titanium'),
(@GUID1+91,@POOL+91,@CHANCE1, 'Storm Peaks Ore Spawnpoint 92 Saronite'),
(@GUID2+91,@POOL+91,@CHANCE2, 'Storm Peaks Ore Spawnpoint 92 Rich Saronite'),
(@GUID3+91,@POOL+91,@CHANCE3, 'Storm Peaks Ore Spawnpoint 92 Titanium'),
(@GUID1+92,@POOL+92,@CHANCE1, 'Storm Peaks Ore Spawnpoint 93 Saronite'),
(@GUID2+92,@POOL+92,@CHANCE2, 'Storm Peaks Ore Spawnpoint 93 Rich Saronite'),
(@GUID3+92,@POOL+92,@CHANCE3, 'Storm Peaks Ore Spawnpoint 93 Titanium'),
(@GUID1+93,@POOL+93,@CHANCE1, 'Storm Peaks Ore Spawnpoint 94 Saronite'),
(@GUID2+93,@POOL+93,@CHANCE2, 'Storm Peaks Ore Spawnpoint 94 Rich Saronite'),
(@GUID3+93,@POOL+93,@CHANCE3, 'Storm Peaks Ore Spawnpoint 94 Titanium'),
(@GUID1+94,@POOL+94,@CHANCE1, 'Storm Peaks Ore Spawnpoint 95 Saronite'),
(@GUID2+94,@POOL+94,@CHANCE2, 'Storm Peaks Ore Spawnpoint 95 Rich Saronite'),
(@GUID3+94,@POOL+94,@CHANCE3, 'Storm Peaks Ore Spawnpoint 95 Titanium'),
(@GUID1+95,@POOL+95,@CHANCE1, 'Storm Peaks Ore Spawnpoint 96 Saronite'),
(@GUID2+95,@POOL+95,@CHANCE2, 'Storm Peaks Ore Spawnpoint 96 Rich Saronite'),
(@GUID3+95,@POOL+95,@CHANCE3, 'Storm Peaks Ore Spawnpoint 96 Titanium'),
(@GUID1+96,@POOL+96,@CHANCE1, 'Storm Peaks Ore Spawnpoint 97 Saronite'),
(@GUID2+96,@POOL+96,@CHANCE2, 'Storm Peaks Ore Spawnpoint 97 Rich Saronite'),
(@GUID3+96,@POOL+96,@CHANCE3, 'Storm Peaks Ore Spawnpoint 97 Titanium'),
(@GUID1+97,@POOL+97,@CHANCE1, 'Storm Peaks Ore Spawnpoint 98 Saronite'),
(@GUID2+97,@POOL+97,@CHANCE2, 'Storm Peaks Ore Spawnpoint 98 Rich Saronite'),
(@GUID3+97,@POOL+97,@CHANCE3, 'Storm Peaks Ore Spawnpoint 98 Titanium'),
(@GUID1+98,@POOL+98,@CHANCE1, 'Storm Peaks Ore Spawnpoint 99 Saronite'),
(@GUID2+98,@POOL+98,@CHANCE2, 'Storm Peaks Ore Spawnpoint 99 Rich Saronite'),
(@GUID3+98,@POOL+98,@CHANCE3, 'Storm Peaks Ore Spawnpoint 99 Titanium'),
(@GUID1+99,@POOL+99,@CHANCE1, 'Storm Peaks Ore Spawnpoint 100 Saronite'),
(@GUID2+99,@POOL+99,@CHANCE2, 'Storm Peaks Ore Spawnpoint 100 Rich Saronite'),
(@GUID3+99,@POOL+99,@CHANCE3, 'Storm Peaks Ore Spawnpoint 100 Titanium'),
(@GUID1+100,@POOL+100,@CHANCE1, 'Storm Peaks Ore Spawnpoint 101 Saronite'),
(@GUID2+100,@POOL+100,@CHANCE2, 'Storm Peaks Ore Spawnpoint 101 Rich Saronite'),
(@GUID3+100,@POOL+100,@CHANCE3, 'Storm Peaks Ore Spawnpoint 101 Titanium'),
(@GUID1+101,@POOL+101,@CHANCE1, 'Storm Peaks Ore Spawnpoint 102 Saronite'),
(@GUID2+101,@POOL+101,@CHANCE2, 'Storm Peaks Ore Spawnpoint 102 Rich Saronite'),
(@GUID3+101,@POOL+101,@CHANCE3, 'Storm Peaks Ore Spawnpoint 102 Titanium'),
(@GUID1+102,@POOL+102,@CHANCE1, 'Storm Peaks Ore Spawnpoint 103 Saronite'),
(@GUID2+102,@POOL+102,@CHANCE2, 'Storm Peaks Ore Spawnpoint 103 Rich Saronite'),
(@GUID3+102,@POOL+102,@CHANCE3, 'Storm Peaks Ore Spawnpoint 103 Titanium'),
(@GUID1+103,@POOL+103,@CHANCE1, 'Storm Peaks Ore Spawnpoint 104 Saronite'),
(@GUID2+103,@POOL+103,@CHANCE2, 'Storm Peaks Ore Spawnpoint 104 Rich Saronite'),
(@GUID3+103,@POOL+103,@CHANCE3, 'Storm Peaks Ore Spawnpoint 104 Titanium'),
(@GUID1+104,@POOL+104,@CHANCE1, 'Storm Peaks Ore Spawnpoint 105 Saronite'),
(@GUID2+104,@POOL+104,@CHANCE2, 'Storm Peaks Ore Spawnpoint 105 Rich Saronite'),
(@GUID3+104,@POOL+104,@CHANCE3, 'Storm Peaks Ore Spawnpoint 105 Titanium'),
(@GUID1+105,@POOL+105,@CHANCE1, 'Storm Peaks Ore Spawnpoint 106 Saronite'),
(@GUID2+105,@POOL+105,@CHANCE2, 'Storm Peaks Ore Spawnpoint 106 Rich Saronite'),
(@GUID3+105,@POOL+105,@CHANCE3, 'Storm Peaks Ore Spawnpoint 106 Titanium'),
(@GUID1+106,@POOL+106,@CHANCE1, 'Storm Peaks Ore Spawnpoint 107 Saronite'),
(@GUID2+106,@POOL+106,@CHANCE2, 'Storm Peaks Ore Spawnpoint 107 Rich Saronite'),
(@GUID3+106,@POOL+106,@CHANCE3, 'Storm Peaks Ore Spawnpoint 107 Titanium'),
(@GUID1+107,@POOL+107,@CHANCE1, 'Storm Peaks Ore Spawnpoint 108 Saronite'),
(@GUID2+107,@POOL+107,@CHANCE2, 'Storm Peaks Ore Spawnpoint 108 Rich Saronite'),
(@GUID3+107,@POOL+107,@CHANCE3, 'Storm Peaks Ore Spawnpoint 108 Titanium'),
(@GUID1+108,@POOL+108,@CHANCE1, 'Storm Peaks Ore Spawnpoint 109 Saronite'),
(@GUID2+108,@POOL+108,@CHANCE2, 'Storm Peaks Ore Spawnpoint 109 Rich Saronite'),
(@GUID3+108,@POOL+108,@CHANCE3, 'Storm Peaks Ore Spawnpoint 109 Titanium'),
(@GUID1+109,@POOL+109,@CHANCE1, 'Storm Peaks Ore Spawnpoint 110 Saronite'),
(@GUID2+109,@POOL+109,@CHANCE2, 'Storm Peaks Ore Spawnpoint 110 Rich Saronite'),
(@GUID3+109,@POOL+109,@CHANCE3, 'Storm Peaks Ore Spawnpoint 110 Titanium');
-- Add each pool to pool template
DELETE FROM `pool_template` WHERE `entry` BETWEEN @POOL AND @POOL+@RANGE;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+0,1, 'Storm Peaks Ore Spawnpoint 1'),
(@POOL+1,1, 'Storm Peaks Ore Spawnpoint 2'),
(@POOL+2,1, 'Storm Peaks Ore Spawnpoint 3'),
(@POOL+3,1, 'Storm Peaks Ore Spawnpoint 4'),
(@POOL+4,1, 'Storm Peaks Ore Spawnpoint 5'),
(@POOL+5,1, 'Storm Peaks Ore Spawnpoint 6'),
(@POOL+6,1, 'Storm Peaks Ore Spawnpoint 7'),
(@POOL+7,1, 'Storm Peaks Ore Spawnpoint 8'),
(@POOL+8,1, 'Storm Peaks Ore Spawnpoint 9'),
(@POOL+9,1, 'Storm Peaks Ore Spawnpoint 10'),
(@POOL+10,1, 'Storm Peaks Ore Spawnpoint 11'),
(@POOL+11,1, 'Storm Peaks Ore Spawnpoint 12'),
(@POOL+12,1, 'Storm Peaks Ore Spawnpoint 13'),
(@POOL+13,1, 'Storm Peaks Ore Spawnpoint 14'),
(@POOL+14,1, 'Storm Peaks Ore Spawnpoint 15'),
(@POOL+15,1, 'Storm Peaks Ore Spawnpoint 16'),
(@POOL+16,1, 'Storm Peaks Ore Spawnpoint 17'),
(@POOL+17,1, 'Storm Peaks Ore Spawnpoint 18'),
(@POOL+18,1, 'Storm Peaks Ore Spawnpoint 19'),
(@POOL+19,1, 'Storm Peaks Ore Spawnpoint 20'),
(@POOL+20,1, 'Storm Peaks Ore Spawnpoint 21'),
(@POOL+21,1, 'Storm Peaks Ore Spawnpoint 22'),
(@POOL+22,1, 'Storm Peaks Ore Spawnpoint 23'),
(@POOL+23,1, 'Storm Peaks Ore Spawnpoint 24'),
(@POOL+24,1, 'Storm Peaks Ore Spawnpoint 25'),
(@POOL+25,1, 'Storm Peaks Ore Spawnpoint 26'),
(@POOL+26,1, 'Storm Peaks Ore Spawnpoint 27'),
(@POOL+27,1, 'Storm Peaks Ore Spawnpoint 28'),
(@POOL+28,1, 'Storm Peaks Ore Spawnpoint 29'),
(@POOL+29,1, 'Storm Peaks Ore Spawnpoint 30'),
(@POOL+30,1, 'Storm Peaks Ore Spawnpoint 31'),
(@POOL+31,1, 'Storm Peaks Ore Spawnpoint 32'),
(@POOL+32,1, 'Storm Peaks Ore Spawnpoint 33'),
(@POOL+33,1, 'Storm Peaks Ore Spawnpoint 34'),
(@POOL+34,1, 'Storm Peaks Ore Spawnpoint 35'),
(@POOL+35,1, 'Storm Peaks Ore Spawnpoint 36'),
(@POOL+36,1, 'Storm Peaks Ore Spawnpoint 37'),
(@POOL+37,1, 'Storm Peaks Ore Spawnpoint 38'),
(@POOL+38,1, 'Storm Peaks Ore Spawnpoint 39'),
(@POOL+39,1, 'Storm Peaks Ore Spawnpoint 40'),
(@POOL+40,1, 'Storm Peaks Ore Spawnpoint 41'),
(@POOL+41,1, 'Storm Peaks Ore Spawnpoint 42'),
(@POOL+42,1, 'Storm Peaks Ore Spawnpoint 43'),
(@POOL+43,1, 'Storm Peaks Ore Spawnpoint 44'),
(@POOL+44,1, 'Storm Peaks Ore Spawnpoint 45'),
(@POOL+45,1, 'Storm Peaks Ore Spawnpoint 46'),
(@POOL+46,1, 'Storm Peaks Ore Spawnpoint 47'),
(@POOL+47,1, 'Storm Peaks Ore Spawnpoint 48'),
(@POOL+48,1, 'Storm Peaks Ore Spawnpoint 49'),
(@POOL+49,1, 'Storm Peaks Ore Spawnpoint 50'),
(@POOL+50,1, 'Storm Peaks Ore Spawnpoint 51'),
(@POOL+51,1, 'Storm Peaks Ore Spawnpoint 52'),
(@POOL+52,1, 'Storm Peaks Ore Spawnpoint 53'),
(@POOL+53,1, 'Storm Peaks Ore Spawnpoint 54'),
(@POOL+54,1, 'Storm Peaks Ore Spawnpoint 55'),
(@POOL+55,1, 'Storm Peaks Ore Spawnpoint 56'),
(@POOL+56,1, 'Storm Peaks Ore Spawnpoint 57'),
(@POOL+57,1, 'Storm Peaks Ore Spawnpoint 58'),
(@POOL+58,1, 'Storm Peaks Ore Spawnpoint 59'),
(@POOL+59,1, 'Storm Peaks Ore Spawnpoint 60'),
(@POOL+60,1, 'Storm Peaks Ore Spawnpoint 61'),
(@POOL+61,1, 'Storm Peaks Ore Spawnpoint 62'),
(@POOL+62,1, 'Storm Peaks Ore Spawnpoint 63'),
(@POOL+63,1, 'Storm Peaks Ore Spawnpoint 64'),
(@POOL+64,1, 'Storm Peaks Ore Spawnpoint 65'),
(@POOL+65,1, 'Storm Peaks Ore Spawnpoint 66'),
(@POOL+66,1, 'Storm Peaks Ore Spawnpoint 67'),
(@POOL+67,1, 'Storm Peaks Ore Spawnpoint 68'),
(@POOL+68,1, 'Storm Peaks Ore Spawnpoint 69'),
(@POOL+69,1, 'Storm Peaks Ore Spawnpoint 70'),
(@POOL+70,1, 'Storm Peaks Ore Spawnpoint 71'),
(@POOL+71,1, 'Storm Peaks Ore Spawnpoint 72'),
(@POOL+72,1, 'Storm Peaks Ore Spawnpoint 73'),
(@POOL+73,1, 'Storm Peaks Ore Spawnpoint 74'),
(@POOL+74,1, 'Storm Peaks Ore Spawnpoint 75'),
(@POOL+75,1, 'Storm Peaks Ore Spawnpoint 76'),
(@POOL+76,1, 'Storm Peaks Ore Spawnpoint 77'),
(@POOL+77,1, 'Storm Peaks Ore Spawnpoint 78'),
(@POOL+78,1, 'Storm Peaks Ore Spawnpoint 79'),
(@POOL+79,1, 'Storm Peaks Ore Spawnpoint 80'),
(@POOL+80,1, 'Storm Peaks Ore Spawnpoint 81'),
(@POOL+81,1, 'Storm Peaks Ore Spawnpoint 82'),
(@POOL+82,1, 'Storm Peaks Ore Spawnpoint 83'),
(@POOL+83,1, 'Storm Peaks Ore Spawnpoint 84'),
(@POOL+84,1, 'Storm Peaks Ore Spawnpoint 85'),
(@POOL+85,1, 'Storm Peaks Ore Spawnpoint 86'),
(@POOL+86,1, 'Storm Peaks Ore Spawnpoint 87'),
(@POOL+87,1, 'Storm Peaks Ore Spawnpoint 88'),
(@POOL+88,1, 'Storm Peaks Ore Spawnpoint 89'),
(@POOL+89,1, 'Storm Peaks Ore Spawnpoint 90'),
(@POOL+90,1, 'Storm Peaks Ore Spawnpoint 91'),
(@POOL+91,1, 'Storm Peaks Ore Spawnpoint 92'),
(@POOL+92,1, 'Storm Peaks Ore Spawnpoint 93'),
(@POOL+93,1, 'Storm Peaks Ore Spawnpoint 94'),
(@POOL+94,1, 'Storm Peaks Ore Spawnpoint 95'),
(@POOL+95,1, 'Storm Peaks Ore Spawnpoint 96'),
(@POOL+96,1, 'Storm Peaks Ore Spawnpoint 97'),
(@POOL+97,1, 'Storm Peaks Ore Spawnpoint 98'),
(@POOL+98,1, 'Storm Peaks Ore Spawnpoint 99'),
(@POOL+99,1, 'Storm Peaks Ore Spawnpoint 100'),
(@POOL+100,1, 'Storm Peaks Ore Spawnpoint 101'),
(@POOL+101,1, 'Storm Peaks Ore Spawnpoint 102'),
(@POOL+102,1, 'Storm Peaks Ore Spawnpoint 103'),
(@POOL+103,1, 'Storm Peaks Ore Spawnpoint 104'),
(@POOL+104,1, 'Storm Peaks Ore Spawnpoint 105'),
(@POOL+105,1, 'Storm Peaks Ore Spawnpoint 106'),
(@POOL+106,1, 'Storm Peaks Ore Spawnpoint 107'),
(@POOL+107,1, 'Storm Peaks Ore Spawnpoint 108'),
(@POOL+108,1, 'Storm Peaks Ore Spawnpoint 109'),
(@POOL+109,1, 'Storm Peaks Ore Spawnpoint 110');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER,@ACTIVE, 'Storm Peaks Ore Mother pool');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@RANGE;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+0,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 1'),
(@POOL+1,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 2'),
(@POOL+2,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 3'),
(@POOL+3,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 4'),
(@POOL+4,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 5'),
(@POOL+5,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 6'),
(@POOL+6,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 7'),
(@POOL+7,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 8'),
(@POOL+8,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 9'),
(@POOL+9,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 10'),
(@POOL+10,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 11'),
(@POOL+11,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 12'),
(@POOL+12,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 13'),
(@POOL+13,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 14'),
(@POOL+14,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 15'),
(@POOL+15,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 16'),
(@POOL+16,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 17'),
(@POOL+17,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 18'),
(@POOL+18,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 19'),
(@POOL+19,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 20'),
(@POOL+20,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 21'),
(@POOL+21,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 22'),
(@POOL+22,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 23'),
(@POOL+23,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 24'),
(@POOL+24,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 25'),
(@POOL+25,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 26'),
(@POOL+26,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 27'),
(@POOL+27,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 28'),
(@POOL+28,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 29'),
(@POOL+29,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 30'),
(@POOL+30,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 31'),
(@POOL+31,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 32'),
(@POOL+32,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 33'),
(@POOL+33,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 34'),
(@POOL+34,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 35'),
(@POOL+35,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 36'),
(@POOL+36,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 37'),
(@POOL+37,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 38'),
(@POOL+38,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 39'),
(@POOL+39,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 40'),
(@POOL+40,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 41'),
(@POOL+41,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 42'),
(@POOL+42,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 43'),
(@POOL+43,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 44'),
(@POOL+44,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 45'),
(@POOL+45,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 46'),
(@POOL+46,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 47'),
(@POOL+47,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 48'),
(@POOL+48,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 49'),
(@POOL+49,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 50'),
(@POOL+50,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 51'),
(@POOL+51,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 52'),
(@POOL+52,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 53'),
(@POOL+53,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 54'),
(@POOL+54,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 55'),
(@POOL+55,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 56'),
(@POOL+56,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 57'),
(@POOL+57,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 58'),
(@POOL+58,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 59'),
(@POOL+59,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 60'),
(@POOL+60,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 61'),
(@POOL+61,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 62'),
(@POOL+62,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 63'),
(@POOL+63,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 64'),
(@POOL+64,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 65'),
(@POOL+65,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 66'),
(@POOL+66,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 67'),
(@POOL+67,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 68'),
(@POOL+68,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 69'),
(@POOL+69,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 70'),
(@POOL+70,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 71'),
(@POOL+71,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 72'),
(@POOL+72,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 73'),
(@POOL+73,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 74'),
(@POOL+74,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 75'),
(@POOL+75,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 76'),
(@POOL+76,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 77'),
(@POOL+77,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 78'),
(@POOL+78,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 79'),
(@POOL+79,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 80'),
(@POOL+80,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 81'),
(@POOL+81,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 82'),
(@POOL+82,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 83'),
(@POOL+83,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 84'),
(@POOL+84,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 85'),
(@POOL+85,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 86'),
(@POOL+86,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 87'),
(@POOL+87,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 88'),
(@POOL+88,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 89'),
(@POOL+89,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 90'),
(@POOL+90,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 91'),
(@POOL+91,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 92'),
(@POOL+92,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 93'),
(@POOL+93,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 94'),
(@POOL+94,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 95'),
(@POOL+95,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 96'),
(@POOL+96,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 97'),
(@POOL+97,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 98'),
(@POOL+98,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 99'),
(@POOL+99,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 100'),
(@POOL+100,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 101'),
(@POOL+101,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 102'),
(@POOL+102,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 103'),
(@POOL+103,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 104'),
(@POOL+104,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 105'),
(@POOL+105,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 106'),
(@POOL+106,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 107'),
(@POOL+107,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 108'),
(@POOL+108,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 109'),
(@POOL+109,@MOTHER,0, 'Storm Peaks Ore Spawnpoint 110');
-- POOL 2 for Cobalt
-- Cobalt & Rich Cobalt Deposits Storm Peaks
INSERT INTO `gameobject` (`guid`, `id`, `map`, `spawnMask`, `phaseMask`, `position_x`, `position_y`, `position_z`, `orientation`, `rotation0`, `rotation1`, `rotation2`, `rotation3`, `spawntimesecs`, `animprogress`, `state`) VALUES
(@GUID1+239,189978,571,1,1,6749.401,-3469.023,563.5495,-1.30900,0,0,0,1,@TIMER,255,1),
(@GUID2+239,189979,571,1,1,6749.401,-3469.023,563.5495,-1.30900,0,0,0,1,@TIMER,255,1);
-- Pooling
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+239,@POOL+239,@CHANCE1, 'Storm Peaks Ore Spawnpoint 1 Cobalt'),
(@GUID2+239,@POOL+239,@CHANCE2+@CHANCE3, 'Storm Peaks Ore Spawnpoint 1 Rich Cobalt');
-- Add each pool to pool template
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+239,1, 'Storm Peaks Ore Spawnpoint 240');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER2;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER2,@ACTIVE, 'Storm Peaks Ore Mother pool 2');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+239,@MOTHER2,0, 'Storm Peaks Ore Spawnpoint 240');

-- -----------------------------------
-- -- Fixup ore spawns for Icecrown --
-- -----------------------------------
SET @RANGE    := 400;
SET @GUID1    := 163200;
SET @GUID2    := @GUID1 + @RANGE;
SET @GUID3    := @GUID2 + @RANGE;
SET @POOL     := 11400;
SET @LASTGUID := 234;
SET @CHANCE1  := 75;
SET @CHANCE2  := 15;
SET @CHANCE3  := 10;
SET @MOTHER   := 9908;
SET @ACTIVE   := 60; -- Max number of active spawns
SET @TIMER    := 600; -- Respawn timer in seconds
-- Remove Ore spawns from Icecrown
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 740 AND `position_y` > 535 AND `position_x` > 6220;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 1220 AND `position_y` > 740 AND `position_x` > 6380;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_x` > 5400 AND `position_y` > 1220 AND `position_y` < 2570;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 3360 AND `position_y` > 2570 AND `position_x` > 5600;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` > 3360 AND `position_x` > 6800;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 335 AND `position_y` > -110 AND `position_x` > 6100 AND `position_x` < 6460;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 535 AND `position_y` > 130 AND `position_x` > 6460;
DELETE FROM `gameobject` WHERE `id` IN (189978,189979,189980,189981,191133) AND `map`=571 AND `position_y` < 3835 AND `position_y` > 3360 AND `position_x` > 6450 AND `position_x` < 6800;

-- Remove old pools
DELETE FROM `pool_gameobject` WHERE `guid` NOT IN (SELECT `guid` FROM `gameobject`);
DELETE FROM `pool_template` WHERE `entry` BETWEEN 5448 AND 5616;
DELETE FROM `pool_template` WHERE `entry`=897;
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN 5448 AND 5616;
-- Saronite Deposits Icecrown
INSERT INTO `gameobject` (`guid`,`id`,`map`,`spawnMask`,`phaseMask`,`position_x`,`position_y`,`position_z`,`orientation`,`rotation0`,`rotation1`,`rotation2`,`rotation3`,`spawntimesecs`,`animprogress`,`state`) VALUES
(@GUID1+0,189980,571,1,1,6674.631,1332.353,299.6001,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID1+1,189980,571,1,1,6939.153,2862.694,435.1407,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID1+2,189980,571,1,1,7980.812,3096.596,635.4854,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID1+3,189980,571,1,1,5636.890,1931.159,517.3533,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID1+4,189980,571,1,1,5665.190,1897.490,519.6750,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID1+5,189980,571,1,1,5706.650,2046.590,-339.6590,-2.39110,0,0,0,1,@TIMER,255,1),
(@GUID1+6,189980,571,1,1,5711.610,2071.070,-340.7400,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID1+7,189980,571,1,1,5749.150,2086.660,-343.5200,-2.09439,0,0,0,1,@TIMER,255,1),
(@GUID1+8,189980,571,1,1,5753.728,2282.746,533.9716,-1.53589,0,0,0,1,@TIMER,255,1),
(@GUID1+9,189980,571,1,1,5775.480,2081.830,-342.7420,0.71559,0,0,0,1,@TIMER,255,1),
(@GUID1+10,189980,571,1,1,5790.740,2214.070,515.1540,1.30900,0,0,0,1,@TIMER,255,1),
(@GUID1+11,189980,571,1,1,5808.930,2268.290,523.3210,2.53072,0,0,0,1,@TIMER,255,1),
(@GUID1+12,189980,571,1,1,5826.980,1863.070,-345.8090,1.90241,0,0,0,1,@TIMER,255,1),
(@GUID1+13,189980,571,1,1,5842.430,1858.810,-345.3000,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID1+14,189980,571,1,1,5843.150,2256.140,520.1550,-1.06465,0,0,0,1,@TIMER,255,1),
(@GUID1+15,189980,571,1,1,5857.440,1936.720,510.8840,0.17453,0,0,0,1,@TIMER,255,1),
(@GUID1+16,189980,571,1,1,5890.500,1915.920,-345.9820,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID1+17,189980,571,1,1,5890.500,1915.920,-345.9820,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID1+18,189980,571,1,1,5894.700,1913.140,-345.9370,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID1+19,189980,571,1,1,5914.500,2015.980,516.3390,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID1+20,189980,571,1,1,5941.548,1912.958,567.5397,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID1+21,189980,571,1,1,5957.890,2517.910,537.2770,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+22,189980,571,1,1,5961.092,2412.068,519.9221,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID1+23,189980,571,1,1,5967.890,1850.520,630.5570,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID1+24,189980,571,1,1,6038.564,2326.347,514.5131,1.69297,0,0,0,1,@TIMER,255,1),
(@GUID1+25,189980,571,1,1,6171.915,2015.665,531.4319,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID1+26,189980,571,1,1,6448.210,1897.020,515.3600,0.36652,0,0,0,1,@TIMER,255,1),
(@GUID1+27,189980,571,1,1,6466.150,137.682,444.7190,2.35619,0,0,0,1,@TIMER,255,1),
(@GUID1+28,189980,571,1,1,6466.396,648.508,428.8037,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+29,189980,571,1,1,6477.440,2487.120,475.9810,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+30,189980,571,1,1,6481.970,540.381,438.7030,0.47124,0,0,0,1,@TIMER,255,1),
(@GUID1+31,189980,571,1,1,6482.543,2462.866,468.1175,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID1+32,189980,571,1,1,6483.739,1237.931,286.9318,1.37881,0,0,0,1,@TIMER,255,1),
(@GUID1+33,189980,571,1,1,6484.370,294.937,399.8210,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID1+34,189980,571,1,1,6497.030,3510.880,540.2320,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID1+35,189980,571,1,1,6514.270,896.626,290.6450,1.29154,0,0,0,1,@TIMER,255,1),
(@GUID1+36,189980,571,1,1,6533.500,907.337,294.8920,0.17453,0,0,0,1,@TIMER,255,1),
(@GUID1+37,189980,571,1,1,6541.251,1011.675,276.9524,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID1+38,189980,571,1,1,6554.230,332.830,411.5670,0.13962,0,0,0,1,@TIMER,255,1),
(@GUID1+39,189980,571,1,1,6557.070,284.192,401.7890,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID1+40,189980,571,1,1,6559.550,659.112,408.1460,-2.67035,0,0,0,1,@TIMER,255,1),
(@GUID1+41,189980,571,1,1,6561.430,1050.489,275.1745,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID1+42,189980,571,1,1,6583.151,1267.122,286.0256,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID1+43,189980,571,1,1,6604.228,1248.473,282.4915,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID1+44,189980,571,1,1,6608.890,990.280,284.7300,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID1+45,189980,571,1,1,6618.750,356.354,453.1560,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID1+46,189980,571,1,1,6622.904,1252.617,282.5027,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID1+47,189980,571,1,1,6636.596,3176.859,648.8128,1.15192,0,0,0,1,@TIMER,255,1),
(@GUID1+48,189980,571,1,1,6640.880,3346.680,677.4100,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+49,189980,571,1,1,6658.340,688.135,410.4380,2.14675,0,0,0,1,@TIMER,255,1),
(@GUID1+50,189980,571,1,1,6662.220,573.318,406.8580,-0.41888,0,0,0,1,@TIMER,255,1),
(@GUID1+51,189980,571,1,1,6664.980,615.527,410.0190,-2.86233,0,0,0,1,@TIMER,255,1),
(@GUID1+52,189980,571,1,1,6672.161,1189.572,273.2596,-2.49582,0,0,0,1,@TIMER,255,1),
(@GUID1+53,189980,571,1,1,6691.890,1520.673,466.3800,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID1+54,189980,571,1,1,6696.400,743.905,396.9640,-0.12217,0,0,0,1,@TIMER,255,1),
(@GUID1+55,189980,571,1,1,6710.980,644.300,412.4740,-1.29154,0,0,0,1,@TIMER,255,1),
(@GUID1+56,189980,571,1,1,6717.320,1228.804,275.0786,-2.86234,0,0,0,1,@TIMER,255,1),
(@GUID1+57,189980,571,1,1,6725.160,570.259,424.5290,-2.46091,0,0,0,1,@TIMER,255,1),
(@GUID1+58,189980,571,1,1,6734.880,1458.500,403.8720,0.31416,0,0,0,1,@TIMER,255,1),
(@GUID1+59,189980,571,1,1,6737.770,586.034,425.3840,1.48353,0,0,0,1,@TIMER,255,1),
(@GUID1+60,189980,571,1,1,6748.570,2727.220,435.5540,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID1+61,189980,571,1,1,6751.800,1325.140,285.5890,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID1+62,189980,571,1,1,6753.930,328.981,442.2290,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID1+63,189980,571,1,1,6754.170,2342.520,442.6880,-2.09439,0,0,0,1,@TIMER,255,1),
(@GUID1+64,189980,571,1,1,6754.800,575.615,425.3900,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID1+65,189980,571,1,1,6755.160,1224.160,276.8440,0.34907,0,0,0,1,@TIMER,255,1),
(@GUID1+66,189980,571,1,1,6755.390,974.467,312.3300,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID1+67,189980,571,1,1,6756.568,2694.843,427.8352,-2.80998,0,0,0,1,@TIMER,255,1),
(@GUID1+68,189980,571,1,1,6758.730,585.806,425.6570,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID1+69,189980,571,1,1,6766.010,2936.860,456.1350,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID1+70,189980,571,1,1,6774.690,499.547,410.7330,-0.97738,0,0,0,1,@TIMER,255,1),
(@GUID1+71,189980,571,1,1,6781.035,1131.430,278.6142,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID1+72,189980,571,1,1,6789.004,1141.311,277.1633,-1.81514,0,0,0,1,@TIMER,255,1),
(@GUID1+73,189980,571,1,1,6790.110,449.812,411.4930,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+74,189980,571,1,1,6793.867,924.565,348.8412,0.85521,0,0,0,1,@TIMER,255,1),
(@GUID1+75,189980,571,1,1,6797.174,2369.824,435.4318,-0.38397,0,0,0,1,@TIMER,255,1),
(@GUID1+76,189980,571,1,1,6804.510,1294.230,281.1890,0.50615,0,0,0,1,@TIMER,255,1),
(@GUID1+77,189980,571,1,1,6817.340,453.798,470.4500,-3.03684,0,0,0,1,@TIMER,255,1),
(@GUID1+78,189980,571,1,1,6818.782,2181.032,660.7790,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+79,189980,571,1,1,6824.141,2207.658,654.9231,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID1+80,189980,571,1,1,6830.670,762.702,409.8570,2.12930,0,0,0,1,@TIMER,255,1),
(@GUID1+81,189980,571,1,1,6833.760,2472.190,421.7130,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID1+82,189980,571,1,1,6884.590,645.147,426.5720,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID1+83,189980,571,1,1,6885.250,2378.060,427.7960,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID1+84,189980,571,1,1,6885.810,2052.910,828.6610,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID1+85,189980,571,1,1,6897.245,819.820,399.8205,-2.82743,0,0,0,1,@TIMER,255,1),
(@GUID1+86,189980,571,1,1,6898.430,786.803,405.3570,-1.48353,0,0,0,1,@TIMER,255,1),
(@GUID1+87,189980,571,1,1,6901.678,2352.561,428.5658,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID1+88,189980,571,1,1,6943.630,3630.960,830.1040,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID1+89,189980,571,1,1,6944.920,407.241,513.6190,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID1+90,189980,571,1,1,6993.890,681.144,491.2140,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID1+91,189980,571,1,1,6999.950,849.854,402.0200,-0.38397,0,0,0,1,@TIMER,255,1),
(@GUID1+92,189980,571,1,1,7010.360,702.436,473.7730,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID1+93,189980,571,1,1,7027.862,3066.551,475.0314,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID1+94,189980,571,1,1,7028.880,2508.660,409.5580,-0.54105,0,0,0,1,@TIMER,255,1),
(@GUID1+95,189980,571,1,1,7053.120,824.111,537.6430,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+96,189980,571,1,1,7064.830,1379.270,307.5810,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID1+97,189980,571,1,1,7067.230,1367.880,306.2920,2.61799,0,0,0,1,@TIMER,255,1),
(@GUID1+98,189980,571,1,1,7070.190,574.218,498.3680,-0.61086,0,0,0,1,@TIMER,255,1),
(@GUID1+99,189980,571,1,1,7102.520,3022.010,446.9720,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+100,189980,571,1,1,7115.280,1450.230,315.6940,-2.02458,0,0,0,1,@TIMER,255,1),
(@GUID1+101,189980,571,1,1,7136.144,1119.962,310.4275,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+102,189980,571,1,1,7144.400,2507.150,405.9100,-1.62316,0,0,0,1,@TIMER,255,1),
(@GUID1+103,189980,571,1,1,7162.500,2547.990,399.1830,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID1+104,189980,571,1,1,7164.714,2521.346,402.8072,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+105,189980,571,1,1,7185.228,2548.746,397.5674,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID1+106,189980,571,1,1,7215.860,2846.910,408.1010,2.89724,0,0,0,1,@TIMER,255,1),
(@GUID1+107,189980,571,1,1,7231.514,2847.632,405.2855,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+108,189980,571,1,1,7235.410,575.545,499.3020,3.12412,0,0,0,1,@TIMER,255,1),
(@GUID1+109,189980,571,1,1,7235.530,1516.760,326.9980,-1.93732,0,0,0,1,@TIMER,255,1),
(@GUID1+110,189980,571,1,1,7238.310,785.106,552.4170,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID1+111,189980,571,1,1,7240.890,2399.818,417.6793,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID1+112,189980,571,1,1,7260.710,1512.270,322.2740,2.19912,0,0,0,1,@TIMER,255,1),
(@GUID1+113,189980,571,1,1,7323.180,2252.330,461.4260,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID1+114,189980,571,1,1,7330.260,2996.150,434.1070,-1.98967,0,0,0,1,@TIMER,255,1),
(@GUID1+115,189980,571,1,1,7330.480,2485.730,392.8050,1.11701,0,0,0,1,@TIMER,255,1),
(@GUID1+116,189980,571,1,1,7343.430,602.649,615.5180,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID1+117,189980,571,1,1,7347.470,561.248,613.0550,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID1+118,189980,571,1,1,7362.550,614.322,580.0140,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID1+119,189980,571,1,1,7382.990,2443.480,387.4290,-2.37364,0,0,0,1,@TIMER,255,1),
(@GUID1+120,189980,571,1,1,7391.310,568.383,577.8610,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+121,189980,571,1,1,7399.734,2867.122,417.6852,-2.28638,0,0,0,1,@TIMER,255,1),
(@GUID1+122,189980,571,1,1,7420.410,3083.890,586.8870,-2.35619,0,0,0,1,@TIMER,255,1),
(@GUID1+123,189980,571,1,1,7420.450,632.061,497.2910,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+124,189980,571,1,1,7427.840,1463.890,324.1520,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID1+125,189980,571,1,1,7431.122,3330.435,693.0119,1.08210,0,0,0,1,@TIMER,255,1),
(@GUID1+126,189980,571,1,1,7466.787,2726.011,412.2881,-0.24435,0,0,0,1,@TIMER,255,1),
(@GUID1+127,189980,571,1,1,7471.173,2497.169,390.4092,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID1+128,189980,571,1,1,7472.370,1305.690,320.0850,-2.28638,0,0,0,1,@TIMER,255,1),
(@GUID1+129,189980,571,1,1,7476.556,1295.246,322.1502,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID1+130,189980,571,1,1,7476.560,1295.250,322.1500,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID1+131,189980,571,1,1,7488.803,1813.892,361.4976,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID1+132,189980,571,1,1,7488.803,1813.892,361.4976,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID1+133,189980,571,1,1,7490.424,2678.968,433.0785,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID1+134,189980,571,1,1,7512.870,1172.610,344.4850,-1.32645,0,0,0,1,@TIMER,255,1),
(@GUID1+135,189980,571,1,1,7517.870,1846.080,360.2560,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID1+136,189980,571,1,1,7521.310,2268.770,391.4060,-1.04720,0,0,0,1,@TIMER,255,1),
(@GUID1+137,189980,571,1,1,7523.600,2698.610,409.9320,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID1+138,189980,571,1,1,7526.180,970.248,533.5250,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID1+139,189980,571,1,1,7529.280,639.333,494.9540,-2.02458,0,0,0,1,@TIMER,255,1),
(@GUID1+140,189980,571,1,1,7541.840,896.319,489.3380,0.95993,0,0,0,1,@TIMER,255,1),
(@GUID1+141,189980,571,1,1,7542.460,2870.100,429.9170,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID1+142,189980,571,1,1,7549.750,982.975,483.2320,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+143,189980,571,1,1,7554.596,1864.645,367.2740,0.24435,0,0,0,1,@TIMER,255,1),
(@GUID1+144,189980,571,1,1,7576.460,1972.390,369.5900,-0.87266,0,0,0,1,@TIMER,255,1),
(@GUID1+145,189980,571,1,1,7595.120,1891.100,371.2320,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID1+146,189980,571,1,1,7607.160,1752.610,339.9570,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID1+147,189980,571,1,1,7633.180,716.693,484.5840,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+148,189980,571,1,1,7653.100,2792.670,414.9850,0.12217,0,0,0,1,@TIMER,255,1),
(@GUID1+149,189980,571,1,1,7656.878,1786.749,350.2715,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID1+150,189980,571,1,1,7656.880,1786.750,350.2720,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID1+151,189980,571,1,1,7664.280,1709.210,333.7010,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID1+152,189980,571,1,1,7678.119,2818.930,444.8793,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID1+153,189980,571,1,1,7679.018,1021.261,471.1822,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+154,189980,571,1,1,7685.300,1256.030,341.5660,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID1+155,189980,571,1,1,7687.900,3554.850,736.6150,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID1+156,189980,571,1,1,7688.260,1386.790,347.2900,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID1+157,189980,571,1,1,7689.330,3181.030,578.8330,0.40143,0,0,0,1,@TIMER,255,1),
(@GUID1+158,189980,571,1,1,7689.890,553.471,698.6200,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID1+159,189980,571,1,1,7712.260,1282.210,339.2810,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+160,189980,571,1,1,7720.600,1424.710,353.3610,-1.62316,0,0,0,1,@TIMER,255,1),
(@GUID1+161,189980,571,1,1,7726.390,1305.620,341.8380,-2.96704,0,0,0,1,@TIMER,255,1),
(@GUID1+162,189980,571,1,1,7733.940,1814.480,349.6280,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+163,189980,571,1,1,7744.650,1779.400,338.0610,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID1+164,189980,571,1,1,7764.360,1088.720,395.6190,-0.61086,0,0,0,1,@TIMER,255,1),
(@GUID1+165,189980,571,1,1,7765.605,2713.188,409.2500,2.68781,0,0,0,1,@TIMER,255,1),
(@GUID1+166,189980,571,1,1,7772.450,796.567,517.5690,0.41888,0,0,0,1,@TIMER,255,1),
(@GUID1+167,189980,571,1,1,7773.792,1499.624,360.2978,-2.21657,0,0,0,1,@TIMER,255,1),
(@GUID1+168,189980,571,1,1,7774.563,2665.078,405.8254,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+169,189980,571,1,1,7774.563,2665.078,405.8254,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID1+170,189980,571,1,1,7779.620,1830.560,356.3590,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID1+171,189980,571,1,1,7781.560,1106.510,395.6670,2.54818,0,0,0,1,@TIMER,255,1),
(@GUID1+172,189980,571,1,1,7784.990,1043.740,395.6190,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+173,189980,571,1,1,7793.370,1526.290,363.6070,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID1+174,189980,571,1,1,7805.900,943.421,451.6210,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+175,189980,571,1,1,7819.700,1132.740,395.6190,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+176,189980,571,1,1,7822.420,696.106,554.0000,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID1+177,189980,571,1,1,7833.479,3008.132,536.2718,-1.20428,0,0,0,1,@TIMER,255,1),
(@GUID1+178,189980,571,1,1,7834.560,818.007,501.7090,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID1+179,189980,571,1,1,7845.009,3354.724,736.6236,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID1+180,189980,571,1,1,7848.730,1108.210,395.6100,2.74016,0,0,0,1,@TIMER,255,1),
(@GUID1+181,189980,571,1,1,7854.104,1125.911,395.6191,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID1+182,189980,571,1,1,7857.740,1414.600,439.1670,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID1+183,189980,571,1,1,7867.160,1550.810,378.1740,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+184,189980,571,1,1,7894.100,1533.870,396.8620,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID1+185,189980,571,1,1,7915.382,2484.846,405.5244,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID1+186,189980,571,1,1,7926.210,2439.340,411.3850,2.67035,0,0,0,1,@TIMER,255,1),
(@GUID1+187,189980,571,1,1,7930.313,2802.014,499.5031,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID1+188,189980,571,1,1,7935.660,1579.350,411.4840,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID1+189,189980,571,1,1,7937.930,1442.640,520.4660,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID1+190,189980,571,1,1,7940.259,3483.749,694.0527,-1.65806,0,0,0,1,@TIMER,255,1),
(@GUID1+191,189980,571,1,1,7941.500,1706.580,371.8170,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+192,189980,571,1,1,7958.130,1927.860,367.0540,3.05433,0,0,0,1,@TIMER,255,1),
(@GUID1+193,189980,571,1,1,7963.188,2787.479,525.1877,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID1+194,189980,571,1,1,7980.900,1539.410,467.7100,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID1+195,189980,571,1,1,8006.929,1907.343,380.7083,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID1+196,189980,571,1,1,8044.050,1805.050,409.0340,2.09439,0,0,0,1,@TIMER,255,1),
(@GUID1+197,189980,571,1,1,8050.090,2858.940,510.4690,-1.65806,0,0,0,1,@TIMER,255,1),
(@GUID1+198,189980,571,1,1,8078.370,1646.490,553.9380,1.97222,0,0,0,1,@TIMER,255,1),
(@GUID1+199,189980,571,1,1,8128.210,1460.340,698.1700,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID1+200,189980,571,1,1,8150.700,1169.640,687.5320,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID1+201,189980,571,1,1,8160.790,1539.710,630.5920,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID1+202,189980,571,1,1,8161.500,1561.790,613.8130,2.05949,0,0,0,1,@TIMER,255,1),
(@GUID1+203,189980,571,1,1,8162.180,1286.700,785.9620,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID1+204,189980,571,1,1,8168.020,1303.410,793.5940,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID1+205,189980,571,1,1,8207.790,1281.010,775.6510,-0.87266,0,0,0,1,@TIMER,255,1),
(@GUID1+206,189980,571,1,1,8242.540,1257.540,741.1770,-1.37881,0,0,0,1,@TIMER,255,1),
(@GUID1+207,189980,571,1,1,8253.710,1842.500,563.0770,1.44862,0,0,0,1,@TIMER,255,1),
(@GUID1+208,189980,571,1,1,8266.340,1755.560,580.5210,-2.91469,0,0,0,1,@TIMER,255,1),
(@GUID1+209,189980,571,1,1,8292.690,2611.040,718.0010,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID1+210,189980,571,1,1,8308.630,3014.360,679.2830,1.44862,0,0,0,1,@TIMER,255,1),
(@GUID1+211,189980,571,1,1,8450.060,1675.780,701.8550,-2.04204,0,0,0,1,@TIMER,255,1),
(@GUID1+212,189980,571,1,1,8478.730,1445.280,641.2010,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+213,189980,571,1,1,8478.730,1445.280,650.4550,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID1+214,189980,571,1,1,8523.810,1290.220,623.7830,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID1+215,189980,571,1,1,8579.111,1431.439,615.5118,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID1+216,189980,571,1,1,8698.680,909.670,496.3710,-0.71559,0,0,0,1,@TIMER,255,1),
(@GUID1+217,189980,571,1,1,8707.630,1008.050,443.8770,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID1+218,189980,571,1,2,5915.753,1990.665,518.8197,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID1+219,189980,571,1,2,5996.645,2335.773,518.0319,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID1+220,189980,571,1,2,6367.613,1682.053,548.5184,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID1+221,189980,571,1,2,6691.890,1520.673,466.3800,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID1+222,189980,571,1,3,5715.870,2059.130,-340.3910,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID1+223,189980,571,1,3,7332.590,3024.400,440.8590,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID1+224,189980,571,1,3,8149.280,2384.140,510.6090,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID1+225,189980,571,1,4,7566.926,1642.527,348.2145,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID1+226,189980,571,1,4,7828.466,1809.705,348.0653,0.43633,0,0,0,1,@TIMER,255,1),
(@GUID1+227,189980,571,1,5,5877.630,1942.750,518.3700,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID1+228,189980,571,1,5,5889.070,2160.360,515.0020,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID1+229,189980,571,1,5,5966.520,1908.870,580.8170,0.71559,0,0,0,1,@TIMER,255,1),
(@GUID1+230,189980,571,1,64,6803.910,3634.238,743.4531,-0.33161,0,0,0,1,@TIMER,255,1),
(@GUID1+231,189980,571,1,64,7070.146,3508.667,733.4362,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID1+232,189980,571,1,256,6166.920,2004.080,541.9620,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID1+233,189980,571,1,256,6522.390,2173.170,509.0700,-3.10665,0,0,0,1,@TIMER,255,1),
(@GUID1+234,189980,571,1,256,6831.540,2201.450,663.2940,2.98450,0,0,0,1,@TIMER,255,1);
-- Rich Saronite Deposits Icecrown
INSERT INTO `gameobject` (`guid`,`id`,`map`,`spawnMask`,`phaseMask`,`position_x`,`position_y`,`position_z`,`orientation`,`rotation0`,`rotation1`,`rotation2`,`rotation3`,`spawntimesecs`,`animprogress`,`state`) VALUES
(@GUID2+0,189981,571,1,1,6674.631,1332.353,299.6001,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID2+1,189981,571,1,1,6939.153,2862.694,435.1407,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID2+2,189981,571,1,1,7980.812,3096.596,635.4854,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID2+3,189981,571,1,1,5636.890,1931.159,517.3533,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID2+4,189981,571,1,1,5665.190,1897.490,519.6750,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID2+5,189981,571,1,1,5706.650,2046.590,-339.6590,-2.39110,0,0,0,1,@TIMER,255,1),
(@GUID2+6,189981,571,1,1,5711.610,2071.070,-340.7400,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID2+7,189981,571,1,1,5749.150,2086.660,-343.5200,-2.09439,0,0,0,1,@TIMER,255,1),
(@GUID2+8,189981,571,1,1,5753.728,2282.746,533.9716,-1.53589,0,0,0,1,@TIMER,255,1),
(@GUID2+9,189981,571,1,1,5775.480,2081.830,-342.7420,0.71559,0,0,0,1,@TIMER,255,1),
(@GUID2+10,189981,571,1,1,5790.740,2214.070,515.1540,1.30900,0,0,0,1,@TIMER,255,1),
(@GUID2+11,189981,571,1,1,5808.930,2268.290,523.3210,2.53072,0,0,0,1,@TIMER,255,1),
(@GUID2+12,189981,571,1,1,5826.980,1863.070,-345.8090,1.90241,0,0,0,1,@TIMER,255,1),
(@GUID2+13,189981,571,1,1,5842.430,1858.810,-345.3000,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID2+14,189981,571,1,1,5843.150,2256.140,520.1550,-1.06465,0,0,0,1,@TIMER,255,1),
(@GUID2+15,189981,571,1,1,5857.440,1936.720,510.8840,0.17453,0,0,0,1,@TIMER,255,1),
(@GUID2+16,189981,571,1,1,5890.500,1915.920,-345.9820,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID2+17,189981,571,1,1,5890.500,1915.920,-345.9820,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID2+18,189981,571,1,1,5894.700,1913.140,-345.9370,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID2+19,189981,571,1,1,5914.500,2015.980,516.3390,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID2+20,189981,571,1,1,5941.548,1912.958,567.5397,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID2+21,189981,571,1,1,5957.890,2517.910,537.2770,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+22,189981,571,1,1,5961.092,2412.068,519.9221,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID2+23,189981,571,1,1,5967.890,1850.520,630.5570,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID2+24,189981,571,1,1,6038.564,2326.347,514.5131,1.69297,0,0,0,1,@TIMER,255,1),
(@GUID2+25,189981,571,1,1,6171.915,2015.665,531.4319,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID2+26,189981,571,1,1,6448.210,1897.020,515.3600,0.36652,0,0,0,1,@TIMER,255,1),
(@GUID2+27,189981,571,1,1,6466.150,137.682,444.7190,2.35619,0,0,0,1,@TIMER,255,1),
(@GUID2+28,189981,571,1,1,6466.396,648.508,428.8037,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID2+29,189981,571,1,1,6477.440,2487.120,475.9810,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+30,189981,571,1,1,6481.970,540.381,438.7030,0.47124,0,0,0,1,@TIMER,255,1),
(@GUID2+31,189981,571,1,1,6482.543,2462.866,468.1175,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID2+32,189981,571,1,1,6483.739,1237.931,286.9318,1.37881,0,0,0,1,@TIMER,255,1),
(@GUID2+33,189981,571,1,1,6484.370,294.937,399.8210,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID2+34,189981,571,1,1,6497.030,3510.880,540.2320,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID2+35,189981,571,1,1,6514.270,896.626,290.6450,1.29154,0,0,0,1,@TIMER,255,1),
(@GUID2+36,189981,571,1,1,6533.500,907.337,294.8920,0.17453,0,0,0,1,@TIMER,255,1),
(@GUID2+37,189981,571,1,1,6541.251,1011.675,276.9524,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID2+38,189981,571,1,1,6554.230,332.830,411.5670,0.13962,0,0,0,1,@TIMER,255,1),
(@GUID2+39,189981,571,1,1,6557.070,284.192,401.7890,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID2+40,189981,571,1,1,6559.550,659.112,408.1460,-2.67035,0,0,0,1,@TIMER,255,1),
(@GUID2+41,189981,571,1,1,6561.430,1050.489,275.1745,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID2+42,189981,571,1,1,6583.151,1267.122,286.0256,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID2+43,189981,571,1,1,6604.228,1248.473,282.4915,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID2+44,189981,571,1,1,6608.890,990.280,284.7300,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID2+45,189981,571,1,1,6618.750,356.354,453.1560,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID2+46,189981,571,1,1,6622.904,1252.617,282.5027,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID2+47,189981,571,1,1,6636.596,3176.859,648.8128,1.15192,0,0,0,1,@TIMER,255,1),
(@GUID2+48,189981,571,1,1,6640.880,3346.680,677.4100,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+49,189981,571,1,1,6658.340,688.135,410.4380,2.14675,0,0,0,1,@TIMER,255,1),
(@GUID2+50,189981,571,1,1,6662.220,573.318,406.8580,-0.41888,0,0,0,1,@TIMER,255,1),
(@GUID2+51,189981,571,1,1,6664.980,615.527,410.0190,-2.86233,0,0,0,1,@TIMER,255,1),
(@GUID2+52,189981,571,1,1,6672.161,1189.572,273.2596,-2.49582,0,0,0,1,@TIMER,255,1),
(@GUID2+53,189981,571,1,1,6691.890,1520.673,466.3800,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID2+54,189981,571,1,1,6696.400,743.905,396.9640,-0.12217,0,0,0,1,@TIMER,255,1),
(@GUID2+55,189981,571,1,1,6710.980,644.300,412.4740,-1.29154,0,0,0,1,@TIMER,255,1),
(@GUID2+56,189981,571,1,1,6717.320,1228.804,275.0786,-2.86234,0,0,0,1,@TIMER,255,1),
(@GUID2+57,189981,571,1,1,6725.160,570.259,424.5290,-2.46091,0,0,0,1,@TIMER,255,1),
(@GUID2+58,189981,571,1,1,6734.880,1458.500,403.8720,0.31416,0,0,0,1,@TIMER,255,1),
(@GUID2+59,189981,571,1,1,6737.770,586.034,425.3840,1.48353,0,0,0,1,@TIMER,255,1),
(@GUID2+60,189981,571,1,1,6748.570,2727.220,435.5540,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID2+61,189981,571,1,1,6751.800,1325.140,285.5890,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID2+62,189981,571,1,1,6753.930,328.981,442.2290,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID2+63,189981,571,1,1,6754.170,2342.520,442.6880,-2.09439,0,0,0,1,@TIMER,255,1),
(@GUID2+64,189981,571,1,1,6754.800,575.615,425.3900,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID2+65,189981,571,1,1,6755.160,1224.160,276.8440,0.34907,0,0,0,1,@TIMER,255,1),
(@GUID2+66,189981,571,1,1,6755.390,974.467,312.3300,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID2+67,189981,571,1,1,6756.568,2694.843,427.8352,-2.80998,0,0,0,1,@TIMER,255,1),
(@GUID2+68,189981,571,1,1,6758.730,585.806,425.6570,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID2+69,189981,571,1,1,6766.010,2936.860,456.1350,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID2+70,189981,571,1,1,6774.690,499.547,410.7330,-0.97738,0,0,0,1,@TIMER,255,1),
(@GUID2+71,189981,571,1,1,6781.035,1131.430,278.6142,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID2+72,189981,571,1,1,6789.004,1141.311,277.1633,-1.81514,0,0,0,1,@TIMER,255,1),
(@GUID2+73,189981,571,1,1,6790.110,449.812,411.4930,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+74,189981,571,1,1,6793.867,924.565,348.8412,0.85521,0,0,0,1,@TIMER,255,1),
(@GUID2+75,189981,571,1,1,6797.174,2369.824,435.4318,-0.38397,0,0,0,1,@TIMER,255,1),
(@GUID2+76,189981,571,1,1,6804.510,1294.230,281.1890,0.50615,0,0,0,1,@TIMER,255,1),
(@GUID2+77,189981,571,1,1,6817.340,453.798,470.4500,-3.03684,0,0,0,1,@TIMER,255,1),
(@GUID2+78,189981,571,1,1,6818.782,2181.032,660.7790,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+79,189981,571,1,1,6824.141,2207.658,654.9231,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID2+80,189981,571,1,1,6830.670,762.702,409.8570,2.12930,0,0,0,1,@TIMER,255,1),
(@GUID2+81,189981,571,1,1,6833.760,2472.190,421.7130,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID2+82,189981,571,1,1,6884.590,645.147,426.5720,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID2+83,189981,571,1,1,6885.250,2378.060,427.7960,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID2+84,189981,571,1,1,6885.810,2052.910,828.6610,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID2+85,189981,571,1,1,6897.245,819.820,399.8205,-2.82743,0,0,0,1,@TIMER,255,1),
(@GUID2+86,189981,571,1,1,6898.430,786.803,405.3570,-1.48353,0,0,0,1,@TIMER,255,1),
(@GUID2+87,189981,571,1,1,6901.678,2352.561,428.5658,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID2+88,189981,571,1,1,6943.630,3630.960,830.1040,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID2+89,189981,571,1,1,6944.920,407.241,513.6190,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID2+90,189981,571,1,1,6993.890,681.144,491.2140,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID2+91,189981,571,1,1,6999.950,849.854,402.0200,-0.38397,0,0,0,1,@TIMER,255,1),
(@GUID2+92,189981,571,1,1,7010.360,702.436,473.7730,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID2+93,189981,571,1,1,7027.862,3066.551,475.0314,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID2+94,189981,571,1,1,7028.880,2508.660,409.5580,-0.54105,0,0,0,1,@TIMER,255,1),
(@GUID2+95,189981,571,1,1,7053.120,824.111,537.6430,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+96,189981,571,1,1,7064.830,1379.270,307.5810,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID2+97,189981,571,1,1,7067.230,1367.880,306.2920,2.61799,0,0,0,1,@TIMER,255,1),
(@GUID2+98,189981,571,1,1,7070.190,574.218,498.3680,-0.61086,0,0,0,1,@TIMER,255,1),
(@GUID2+99,189981,571,1,1,7102.520,3022.010,446.9720,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID2+100,189981,571,1,1,7115.280,1450.230,315.6940,-2.02458,0,0,0,1,@TIMER,255,1),
(@GUID2+101,189981,571,1,1,7136.144,1119.962,310.4275,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+102,189981,571,1,1,7144.400,2507.150,405.9100,-1.62316,0,0,0,1,@TIMER,255,1),
(@GUID2+103,189981,571,1,1,7162.500,2547.990,399.1830,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID2+104,189981,571,1,1,7164.714,2521.346,402.8072,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+105,189981,571,1,1,7185.228,2548.746,397.5674,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID2+106,189981,571,1,1,7215.860,2846.910,408.1010,2.89724,0,0,0,1,@TIMER,255,1),
(@GUID2+107,189981,571,1,1,7231.514,2847.632,405.2855,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+108,189981,571,1,1,7235.410,575.545,499.3020,3.12412,0,0,0,1,@TIMER,255,1),
(@GUID2+109,189981,571,1,1,7235.530,1516.760,326.9980,-1.93732,0,0,0,1,@TIMER,255,1),
(@GUID2+110,189981,571,1,1,7238.310,785.106,552.4170,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID2+111,189981,571,1,1,7240.890,2399.818,417.6793,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID2+112,189981,571,1,1,7260.710,1512.270,322.2740,2.19912,0,0,0,1,@TIMER,255,1),
(@GUID2+113,189981,571,1,1,7323.180,2252.330,461.4260,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID2+114,189981,571,1,1,7330.260,2996.150,434.1070,-1.98967,0,0,0,1,@TIMER,255,1),
(@GUID2+115,189981,571,1,1,7330.480,2485.730,392.8050,1.11701,0,0,0,1,@TIMER,255,1),
(@GUID2+116,189981,571,1,1,7343.430,602.649,615.5180,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID2+117,189981,571,1,1,7347.470,561.248,613.0550,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID2+118,189981,571,1,1,7362.550,614.322,580.0140,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID2+119,189981,571,1,1,7382.990,2443.480,387.4290,-2.37364,0,0,0,1,@TIMER,255,1),
(@GUID2+120,189981,571,1,1,7391.310,568.383,577.8610,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+121,189981,571,1,1,7399.734,2867.122,417.6852,-2.28638,0,0,0,1,@TIMER,255,1),
(@GUID2+122,189981,571,1,1,7420.410,3083.890,586.8870,-2.35619,0,0,0,1,@TIMER,255,1),
(@GUID2+123,189981,571,1,1,7420.450,632.061,497.2910,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID2+124,189981,571,1,1,7427.840,1463.890,324.1520,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID2+125,189981,571,1,1,7431.122,3330.435,693.0119,1.08210,0,0,0,1,@TIMER,255,1),
(@GUID2+126,189981,571,1,1,7466.787,2726.011,412.2881,-0.24435,0,0,0,1,@TIMER,255,1),
(@GUID2+127,189981,571,1,1,7471.173,2497.169,390.4092,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID2+128,189981,571,1,1,7472.370,1305.690,320.0850,-2.28638,0,0,0,1,@TIMER,255,1),
(@GUID2+129,189981,571,1,1,7476.556,1295.246,322.1502,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID2+130,189981,571,1,1,7476.560,1295.250,322.1500,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID2+131,189981,571,1,1,7488.803,1813.892,361.4976,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID2+132,189981,571,1,1,7488.803,1813.892,361.4976,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID2+133,189981,571,1,1,7490.424,2678.968,433.0785,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID2+134,189981,571,1,1,7512.870,1172.610,344.4850,-1.32645,0,0,0,1,@TIMER,255,1),
(@GUID2+135,189981,571,1,1,7517.870,1846.080,360.2560,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID2+136,189981,571,1,1,7521.310,2268.770,391.4060,-1.04720,0,0,0,1,@TIMER,255,1),
(@GUID2+137,189981,571,1,1,7523.600,2698.610,409.9320,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID2+138,189981,571,1,1,7526.180,970.248,533.5250,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID2+139,189981,571,1,1,7529.280,639.333,494.9540,-2.02458,0,0,0,1,@TIMER,255,1),
(@GUID2+140,189981,571,1,1,7541.840,896.319,489.3380,0.95993,0,0,0,1,@TIMER,255,1),
(@GUID2+141,189981,571,1,1,7542.460,2870.100,429.9170,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID2+142,189981,571,1,1,7549.750,982.975,483.2320,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+143,189981,571,1,1,7554.596,1864.645,367.2740,0.24435,0,0,0,1,@TIMER,255,1),
(@GUID2+144,189981,571,1,1,7576.460,1972.390,369.5900,-0.87266,0,0,0,1,@TIMER,255,1),
(@GUID2+145,189981,571,1,1,7595.120,1891.100,371.2320,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID2+146,189981,571,1,1,7607.160,1752.610,339.9570,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID2+147,189981,571,1,1,7633.180,716.693,484.5840,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+148,189981,571,1,1,7653.100,2792.670,414.9850,0.12217,0,0,0,1,@TIMER,255,1),
(@GUID2+149,189981,571,1,1,7656.878,1786.749,350.2715,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID2+150,189981,571,1,1,7656.880,1786.750,350.2720,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID2+151,189981,571,1,1,7664.280,1709.210,333.7010,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID2+152,189981,571,1,1,7678.119,2818.930,444.8793,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID2+153,189981,571,1,1,7679.018,1021.261,471.1822,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+154,189981,571,1,1,7685.300,1256.030,341.5660,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID2+155,189981,571,1,1,7687.900,3554.850,736.6150,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID2+156,189981,571,1,1,7688.260,1386.790,347.2900,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID2+157,189981,571,1,1,7689.330,3181.030,578.8330,0.40143,0,0,0,1,@TIMER,255,1),
(@GUID2+158,189981,571,1,1,7689.890,553.471,698.6200,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID2+159,189981,571,1,1,7712.260,1282.210,339.2810,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+160,189981,571,1,1,7720.600,1424.710,353.3610,-1.62316,0,0,0,1,@TIMER,255,1),
(@GUID2+161,189981,571,1,1,7726.390,1305.620,341.8380,-2.96704,0,0,0,1,@TIMER,255,1),
(@GUID2+162,189981,571,1,1,7733.940,1814.480,349.6280,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+163,189981,571,1,1,7744.650,1779.400,338.0610,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID2+164,189981,571,1,1,7764.360,1088.720,395.6190,-0.61086,0,0,0,1,@TIMER,255,1),
(@GUID2+165,189981,571,1,1,7765.605,2713.188,409.2500,2.68781,0,0,0,1,@TIMER,255,1),
(@GUID2+166,189981,571,1,1,7772.450,796.567,517.5690,0.41888,0,0,0,1,@TIMER,255,1),
(@GUID2+167,189981,571,1,1,7773.792,1499.624,360.2978,-2.21657,0,0,0,1,@TIMER,255,1),
(@GUID2+168,189981,571,1,1,7774.563,2665.078,405.8254,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+169,189981,571,1,1,7774.563,2665.078,405.8254,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID2+170,189981,571,1,1,7779.620,1830.560,356.3590,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID2+171,189981,571,1,1,7781.560,1106.510,395.6670,2.54818,0,0,0,1,@TIMER,255,1),
(@GUID2+172,189981,571,1,1,7784.990,1043.740,395.6190,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+173,189981,571,1,1,7793.370,1526.290,363.6070,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID2+174,189981,571,1,1,7805.900,943.421,451.6210,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+175,189981,571,1,1,7819.700,1132.740,395.6190,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+176,189981,571,1,1,7822.420,696.106,554.0000,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID2+177,189981,571,1,1,7833.479,3008.132,536.2718,-1.20428,0,0,0,1,@TIMER,255,1),
(@GUID2+178,189981,571,1,1,7834.560,818.007,501.7090,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID2+179,189981,571,1,1,7845.009,3354.724,736.6236,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID2+180,189981,571,1,1,7848.730,1108.210,395.6100,2.74016,0,0,0,1,@TIMER,255,1),
(@GUID2+181,189981,571,1,1,7854.104,1125.911,395.6191,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID2+182,189981,571,1,1,7857.740,1414.600,439.1670,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID2+183,189981,571,1,1,7867.160,1550.810,378.1740,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+184,189981,571,1,1,7894.100,1533.870,396.8620,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID2+185,189981,571,1,1,7915.382,2484.846,405.5244,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID2+186,189981,571,1,1,7926.210,2439.340,411.3850,2.67035,0,0,0,1,@TIMER,255,1),
(@GUID2+187,189981,571,1,1,7930.313,2802.014,499.5031,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID2+188,189981,571,1,1,7935.660,1579.350,411.4840,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID2+189,189981,571,1,1,7937.930,1442.640,520.4660,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID2+190,189981,571,1,1,7940.259,3483.749,694.0527,-1.65806,0,0,0,1,@TIMER,255,1),
(@GUID2+191,189981,571,1,1,7941.500,1706.580,371.8170,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+192,189981,571,1,1,7958.130,1927.860,367.0540,3.05433,0,0,0,1,@TIMER,255,1),
(@GUID2+193,189981,571,1,1,7963.188,2787.479,525.1877,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID2+194,189981,571,1,1,7980.900,1539.410,467.7100,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID2+195,189981,571,1,1,8006.929,1907.343,380.7083,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID2+196,189981,571,1,1,8044.050,1805.050,409.0340,2.09439,0,0,0,1,@TIMER,255,1),
(@GUID2+197,189981,571,1,1,8050.090,2858.940,510.4690,-1.65806,0,0,0,1,@TIMER,255,1),
(@GUID2+198,189981,571,1,1,8078.370,1646.490,553.9380,1.97222,0,0,0,1,@TIMER,255,1),
(@GUID2+199,189981,571,1,1,8128.210,1460.340,698.1700,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID2+200,189981,571,1,1,8150.700,1169.640,687.5320,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID2+201,189981,571,1,1,8160.790,1539.710,630.5920,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID2+202,189981,571,1,1,8161.500,1561.790,613.8130,2.05949,0,0,0,1,@TIMER,255,1),
(@GUID2+203,189981,571,1,1,8162.180,1286.700,785.9620,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID2+204,189981,571,1,1,8168.020,1303.410,793.5940,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID2+205,189981,571,1,1,8207.790,1281.010,775.6510,-0.87266,0,0,0,1,@TIMER,255,1),
(@GUID2+206,189981,571,1,1,8242.540,1257.540,741.1770,-1.37881,0,0,0,1,@TIMER,255,1),
(@GUID2+207,189981,571,1,1,8253.710,1842.500,563.0770,1.44862,0,0,0,1,@TIMER,255,1),
(@GUID2+208,189981,571,1,1,8266.340,1755.560,580.5210,-2.91469,0,0,0,1,@TIMER,255,1),
(@GUID2+209,189981,571,1,1,8292.690,2611.040,718.0010,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID2+210,189981,571,1,1,8308.630,3014.360,679.2830,1.44862,0,0,0,1,@TIMER,255,1),
(@GUID2+211,189981,571,1,1,8450.060,1675.780,701.8550,-2.04204,0,0,0,1,@TIMER,255,1),
(@GUID2+212,189981,571,1,1,8478.730,1445.280,641.2010,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+213,189981,571,1,1,8478.730,1445.280,650.4550,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID2+214,189981,571,1,1,8523.810,1290.220,623.7830,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID2+215,189981,571,1,1,8579.111,1431.439,615.5118,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID2+216,189981,571,1,1,8698.680,909.670,496.3710,-0.71559,0,0,0,1,@TIMER,255,1),
(@GUID2+217,189981,571,1,1,8707.630,1008.050,443.8770,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID2+218,189981,571,1,2,5915.753,1990.665,518.8197,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID2+219,189981,571,1,2,5996.645,2335.773,518.0319,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID2+220,189981,571,1,2,6367.613,1682.053,548.5184,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID2+221,189981,571,1,2,6691.890,1520.673,466.3800,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID2+222,189981,571,1,3,5715.870,2059.130,-340.3910,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID2+223,189981,571,1,3,7332.590,3024.400,440.8590,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID2+224,189981,571,1,3,8149.280,2384.140,510.6090,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID2+225,189981,571,1,4,7566.926,1642.527,348.2145,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID2+226,189981,571,1,4,7828.466,1809.705,348.0653,0.43633,0,0,0,1,@TIMER,255,1),
(@GUID2+227,189981,571,1,5,5877.630,1942.750,518.3700,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID2+228,189981,571,1,5,5889.070,2160.360,515.0020,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID2+229,189981,571,1,5,5966.520,1908.870,580.8170,0.71559,0,0,0,1,@TIMER,255,1),
(@GUID2+230,189981,571,1,64,6803.910,3634.238,743.4531,-0.33161,0,0,0,1,@TIMER,255,1),
(@GUID2+231,189981,571,1,64,7070.146,3508.667,733.4362,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID2+232,189981,571,1,256,6166.920,2004.080,541.9620,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID2+233,189981,571,1,256,6522.390,2173.170,509.0700,-3.10665,0,0,0,1,@TIMER,255,1),
(@GUID2+234,189981,571,1,256,6831.540,2201.450,663.2940,2.98450,0,0,0,1,@TIMER,255,1);
-- Titanium Deposits Icecrown
INSERT INTO `gameobject` (`guid`,`id`,`map`,`spawnMask`,`phaseMask`,`position_x`,`position_y`,`position_z`,`orientation`,`rotation0`,`rotation1`,`rotation2`,`rotation3`,`spawntimesecs`,`animprogress`,`state`) VALUES
(@GUID3+0,191133,571,1,1,6674.631,1332.353,299.6001,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID3+1,191133,571,1,1,6939.153,2862.694,435.1407,1.57080,0,0,0,1,@TIMER,255,1),
(@GUID3+2,191133,571,1,1,7980.812,3096.596,635.4854,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID3+3,191133,571,1,1,5636.890,1931.159,517.3533,-1.50098,0,0,0,1,@TIMER,255,1),
(@GUID3+4,191133,571,1,1,5665.190,1897.490,519.6750,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID3+5,191133,571,1,1,5706.650,2046.590,-339.6590,-2.39110,0,0,0,1,@TIMER,255,1),
(@GUID3+6,191133,571,1,1,5711.610,2071.070,-340.7400,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID3+7,191133,571,1,1,5749.150,2086.660,-343.5200,-2.09439,0,0,0,1,@TIMER,255,1),
(@GUID3+8,191133,571,1,1,5753.728,2282.746,533.9716,-1.53589,0,0,0,1,@TIMER,255,1),
(@GUID3+9,191133,571,1,1,5775.480,2081.830,-342.7420,0.71559,0,0,0,1,@TIMER,255,1),
(@GUID3+10,191133,571,1,1,5790.740,2214.070,515.1540,1.30900,0,0,0,1,@TIMER,255,1),
(@GUID3+11,191133,571,1,1,5808.930,2268.290,523.3210,2.53072,0,0,0,1,@TIMER,255,1),
(@GUID3+12,191133,571,1,1,5826.980,1863.070,-345.8090,1.90241,0,0,0,1,@TIMER,255,1),
(@GUID3+13,191133,571,1,1,5842.430,1858.810,-345.3000,-2.68781,0,0,0,1,@TIMER,255,1),
(@GUID3+14,191133,571,1,1,5843.150,2256.140,520.1550,-1.06465,0,0,0,1,@TIMER,255,1),
(@GUID3+15,191133,571,1,1,5857.440,1936.720,510.8840,0.17453,0,0,0,1,@TIMER,255,1),
(@GUID3+16,191133,571,1,1,5890.500,1915.920,-345.9820,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID3+17,191133,571,1,1,5890.500,1915.920,-345.9820,-1.76278,0,0,0,1,@TIMER,255,1),
(@GUID3+18,191133,571,1,1,5894.700,1913.140,-345.9370,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID3+19,191133,571,1,1,5914.500,2015.980,516.3390,2.93214,0,0,0,1,@TIMER,255,1),
(@GUID3+20,191133,571,1,1,5941.548,1912.958,567.5397,0.97738,0,0,0,1,@TIMER,255,1),
(@GUID3+21,191133,571,1,1,5957.890,2517.910,537.2770,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID3+22,191133,571,1,1,5961.092,2412.068,519.9221,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID3+23,191133,571,1,1,5967.890,1850.520,630.5570,-0.52360,0,0,0,1,@TIMER,255,1),
(@GUID3+24,191133,571,1,1,6038.564,2326.347,514.5131,1.69297,0,0,0,1,@TIMER,255,1),
(@GUID3+25,191133,571,1,1,6171.915,2015.665,531.4319,-1.43117,0,0,0,1,@TIMER,255,1),
(@GUID3+26,191133,571,1,1,6448.210,1897.020,515.3600,0.36652,0,0,0,1,@TIMER,255,1),
(@GUID3+27,191133,571,1,1,6466.150,137.682,444.7190,2.35619,0,0,0,1,@TIMER,255,1),
(@GUID3+28,191133,571,1,1,6466.396,648.508,428.8037,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID3+29,191133,571,1,1,6477.440,2487.120,475.9810,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+30,191133,571,1,1,6481.970,540.381,438.7030,0.47124,0,0,0,1,@TIMER,255,1),
(@GUID3+31,191133,571,1,1,6482.543,2462.866,468.1175,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID3+32,191133,571,1,1,6483.739,1237.931,286.9318,1.37881,0,0,0,1,@TIMER,255,1),
(@GUID3+33,191133,571,1,1,6484.370,294.937,399.8210,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID3+34,191133,571,1,1,6497.030,3510.880,540.2320,-2.70526,0,0,0,1,@TIMER,255,1),
(@GUID3+35,191133,571,1,1,6514.270,896.626,290.6450,1.29154,0,0,0,1,@TIMER,255,1),
(@GUID3+36,191133,571,1,1,6533.500,907.337,294.8920,0.17453,0,0,0,1,@TIMER,255,1),
(@GUID3+37,191133,571,1,1,6541.251,1011.675,276.9524,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID3+38,191133,571,1,1,6554.230,332.830,411.5670,0.13962,0,0,0,1,@TIMER,255,1),
(@GUID3+39,191133,571,1,1,6557.070,284.192,401.7890,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID3+40,191133,571,1,1,6559.550,659.112,408.1460,-2.67035,0,0,0,1,@TIMER,255,1),
(@GUID3+41,191133,571,1,1,6561.430,1050.489,275.1745,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID3+42,191133,571,1,1,6583.151,1267.122,286.0256,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID3+43,191133,571,1,1,6604.228,1248.473,282.4915,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID3+44,191133,571,1,1,6608.890,990.280,284.7300,-2.77507,0,0,0,1,@TIMER,255,1),
(@GUID3+45,191133,571,1,1,6618.750,356.354,453.1560,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID3+46,191133,571,1,1,6622.904,1252.617,282.5027,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID3+47,191133,571,1,1,6636.596,3176.859,648.8128,1.15192,0,0,0,1,@TIMER,255,1),
(@GUID3+48,191133,571,1,1,6640.880,3346.680,677.4100,-0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+49,191133,571,1,1,6658.340,688.135,410.4380,2.14675,0,0,0,1,@TIMER,255,1),
(@GUID3+50,191133,571,1,1,6662.220,573.318,406.8580,-0.41888,0,0,0,1,@TIMER,255,1),
(@GUID3+51,191133,571,1,1,6664.980,615.527,410.0190,-2.86233,0,0,0,1,@TIMER,255,1),
(@GUID3+52,191133,571,1,1,6672.161,1189.572,273.2596,-2.49582,0,0,0,1,@TIMER,255,1),
(@GUID3+53,191133,571,1,1,6691.890,1520.673,466.3800,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID3+54,191133,571,1,1,6696.400,743.905,396.9640,-0.12217,0,0,0,1,@TIMER,255,1),
(@GUID3+55,191133,571,1,1,6710.980,644.300,412.4740,-1.29154,0,0,0,1,@TIMER,255,1),
(@GUID3+56,191133,571,1,1,6717.320,1228.804,275.0786,-2.86234,0,0,0,1,@TIMER,255,1),
(@GUID3+57,191133,571,1,1,6725.160,570.259,424.5290,-2.46091,0,0,0,1,@TIMER,255,1),
(@GUID3+58,191133,571,1,1,6734.880,1458.500,403.8720,0.31416,0,0,0,1,@TIMER,255,1),
(@GUID3+59,191133,571,1,1,6737.770,586.034,425.3840,1.48353,0,0,0,1,@TIMER,255,1),
(@GUID3+60,191133,571,1,1,6748.570,2727.220,435.5540,1.22173,0,0,0,1,@TIMER,255,1),
(@GUID3+61,191133,571,1,1,6751.800,1325.140,285.5890,-1.60570,0,0,0,1,@TIMER,255,1),
(@GUID3+62,191133,571,1,1,6753.930,328.981,442.2290,0.92502,0,0,0,1,@TIMER,255,1),
(@GUID3+63,191133,571,1,1,6754.170,2342.520,442.6880,-2.09439,0,0,0,1,@TIMER,255,1),
(@GUID3+64,191133,571,1,1,6754.800,575.615,425.3900,-1.41372,0,0,0,1,@TIMER,255,1),
(@GUID3+65,191133,571,1,1,6755.160,1224.160,276.8440,0.34907,0,0,0,1,@TIMER,255,1),
(@GUID3+66,191133,571,1,1,6755.390,974.467,312.3300,-2.19912,0,0,0,1,@TIMER,255,1),
(@GUID3+67,191133,571,1,1,6756.568,2694.843,427.8352,-2.80998,0,0,0,1,@TIMER,255,1),
(@GUID3+68,191133,571,1,1,6758.730,585.806,425.6570,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID3+69,191133,571,1,1,6766.010,2936.860,456.1350,-2.00713,0,0,0,1,@TIMER,255,1),
(@GUID3+70,191133,571,1,1,6774.690,499.547,410.7330,-0.97738,0,0,0,1,@TIMER,255,1),
(@GUID3+71,191133,571,1,1,6781.035,1131.430,278.6142,2.04204,0,0,0,1,@TIMER,255,1),
(@GUID3+72,191133,571,1,1,6789.004,1141.311,277.1633,-1.81514,0,0,0,1,@TIMER,255,1),
(@GUID3+73,191133,571,1,1,6790.110,449.812,411.4930,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID3+74,191133,571,1,1,6793.867,924.565,348.8412,0.85521,0,0,0,1,@TIMER,255,1),
(@GUID3+75,191133,571,1,1,6797.174,2369.824,435.4318,-0.38397,0,0,0,1,@TIMER,255,1),
(@GUID3+76,191133,571,1,1,6804.510,1294.230,281.1890,0.50615,0,0,0,1,@TIMER,255,1),
(@GUID3+77,191133,571,1,1,6817.340,453.798,470.4500,-3.03684,0,0,0,1,@TIMER,255,1),
(@GUID3+78,191133,571,1,1,6818.782,2181.032,660.7790,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID3+79,191133,571,1,1,6824.141,2207.658,654.9231,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID3+80,191133,571,1,1,6830.670,762.702,409.8570,2.12930,0,0,0,1,@TIMER,255,1),
(@GUID3+81,191133,571,1,1,6833.760,2472.190,421.7130,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID3+82,191133,571,1,1,6884.590,645.147,426.5720,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID3+83,191133,571,1,1,6885.250,2378.060,427.7960,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID3+84,191133,571,1,1,6885.810,2052.910,828.6610,0.08727,0,0,0,1,@TIMER,255,1),
(@GUID3+85,191133,571,1,1,6897.245,819.820,399.8205,-2.82743,0,0,0,1,@TIMER,255,1),
(@GUID3+86,191133,571,1,1,6898.430,786.803,405.3570,-1.48353,0,0,0,1,@TIMER,255,1),
(@GUID3+87,191133,571,1,1,6901.678,2352.561,428.5658,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID3+88,191133,571,1,1,6943.630,3630.960,830.1040,-1.46608,0,0,0,1,@TIMER,255,1),
(@GUID3+89,191133,571,1,1,6944.920,407.241,513.6190,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID3+90,191133,571,1,1,6993.890,681.144,491.2140,0.38397,0,0,0,1,@TIMER,255,1),
(@GUID3+91,191133,571,1,1,6999.950,849.854,402.0200,-0.38397,0,0,0,1,@TIMER,255,1),
(@GUID3+92,191133,571,1,1,7010.360,702.436,473.7730,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID3+93,191133,571,1,1,7027.862,3066.551,475.0314,1.78023,0,0,0,1,@TIMER,255,1),
(@GUID3+94,191133,571,1,1,7028.880,2508.660,409.5580,-0.54105,0,0,0,1,@TIMER,255,1),
(@GUID3+95,191133,571,1,1,7053.120,824.111,537.6430,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+96,191133,571,1,1,7064.830,1379.270,307.5810,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID3+97,191133,571,1,1,7067.230,1367.880,306.2920,2.61799,0,0,0,1,@TIMER,255,1),
(@GUID3+98,191133,571,1,1,7070.190,574.218,498.3680,-0.61086,0,0,0,1,@TIMER,255,1),
(@GUID3+99,191133,571,1,1,7102.520,3022.010,446.9720,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID3+100,191133,571,1,1,7115.280,1450.230,315.6940,-2.02458,0,0,0,1,@TIMER,255,1),
(@GUID3+101,191133,571,1,1,7136.144,1119.962,310.4275,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID3+102,191133,571,1,1,7144.400,2507.150,405.9100,-1.62316,0,0,0,1,@TIMER,255,1),
(@GUID3+103,191133,571,1,1,7162.500,2547.990,399.1830,1.71042,0,0,0,1,@TIMER,255,1),
(@GUID3+104,191133,571,1,1,7164.714,2521.346,402.8072,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+105,191133,571,1,1,7185.228,2548.746,397.5674,1.55334,0,0,0,1,@TIMER,255,1),
(@GUID3+106,191133,571,1,1,7215.860,2846.910,408.1010,2.89724,0,0,0,1,@TIMER,255,1),
(@GUID3+107,191133,571,1,1,7231.514,2847.632,405.2855,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+108,191133,571,1,1,7235.410,575.545,499.3020,3.12412,0,0,0,1,@TIMER,255,1),
(@GUID3+109,191133,571,1,1,7235.530,1516.760,326.9980,-1.93732,0,0,0,1,@TIMER,255,1),
(@GUID3+110,191133,571,1,1,7238.310,785.106,552.4170,0.26180,0,0,0,1,@TIMER,255,1),
(@GUID3+111,191133,571,1,1,7240.890,2399.818,417.6793,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID3+112,191133,571,1,1,7260.710,1512.270,322.2740,2.19912,0,0,0,1,@TIMER,255,1),
(@GUID3+113,191133,571,1,1,7323.180,2252.330,461.4260,2.49582,0,0,0,1,@TIMER,255,1),
(@GUID3+114,191133,571,1,1,7330.260,2996.150,434.1070,-1.98967,0,0,0,1,@TIMER,255,1),
(@GUID3+115,191133,571,1,1,7330.480,2485.730,392.8050,1.11701,0,0,0,1,@TIMER,255,1),
(@GUID3+116,191133,571,1,1,7343.430,602.649,615.5180,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID3+117,191133,571,1,1,7347.470,561.248,613.0550,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID3+118,191133,571,1,1,7362.550,614.322,580.0140,-3.01941,0,0,0,1,@TIMER,255,1),
(@GUID3+119,191133,571,1,1,7382.990,2443.480,387.4290,-2.37364,0,0,0,1,@TIMER,255,1),
(@GUID3+120,191133,571,1,1,7391.310,568.383,577.8610,-1.25664,0,0,0,1,@TIMER,255,1),
(@GUID3+121,191133,571,1,1,7399.734,2867.122,417.6852,-2.28638,0,0,0,1,@TIMER,255,1),
(@GUID3+122,191133,571,1,1,7420.410,3083.890,586.8870,-2.35619,0,0,0,1,@TIMER,255,1),
(@GUID3+123,191133,571,1,1,7420.450,632.061,497.2910,-1.79769,0,0,0,1,@TIMER,255,1),
(@GUID3+124,191133,571,1,1,7427.840,1463.890,324.1520,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID3+125,191133,571,1,1,7431.122,3330.435,693.0119,1.08210,0,0,0,1,@TIMER,255,1),
(@GUID3+126,191133,571,1,1,7466.787,2726.011,412.2881,-0.24435,0,0,0,1,@TIMER,255,1),
(@GUID3+127,191133,571,1,1,7471.173,2497.169,390.4092,-1.34390,0,0,0,1,@TIMER,255,1),
(@GUID3+128,191133,571,1,1,7472.370,1305.690,320.0850,-2.28638,0,0,0,1,@TIMER,255,1),
(@GUID3+129,191133,571,1,1,7476.556,1295.246,322.1502,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID3+130,191133,571,1,1,7476.560,1295.250,322.1500,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID3+131,191133,571,1,1,7488.803,1813.892,361.4976,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID3+132,191133,571,1,1,7488.803,1813.892,361.4976,-2.65289,0,0,0,1,@TIMER,255,1),
(@GUID3+133,191133,571,1,1,7490.424,2678.968,433.0785,-1.15192,0,0,0,1,@TIMER,255,1),
(@GUID3+134,191133,571,1,1,7512.870,1172.610,344.4850,-1.32645,0,0,0,1,@TIMER,255,1),
(@GUID3+135,191133,571,1,1,7517.870,1846.080,360.2560,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID3+136,191133,571,1,1,7521.310,2268.770,391.4060,-1.04720,0,0,0,1,@TIMER,255,1),
(@GUID3+137,191133,571,1,1,7523.600,2698.610,409.9320,2.96704,0,0,0,1,@TIMER,255,1),
(@GUID3+138,191133,571,1,1,7526.180,970.248,533.5250,0.75049,0,0,0,1,@TIMER,255,1),
(@GUID3+139,191133,571,1,1,7529.280,639.333,494.9540,-2.02458,0,0,0,1,@TIMER,255,1),
(@GUID3+140,191133,571,1,1,7541.840,896.319,489.3380,0.95993,0,0,0,1,@TIMER,255,1),
(@GUID3+141,191133,571,1,1,7542.460,2870.100,429.9170,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID3+142,191133,571,1,1,7549.750,982.975,483.2320,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+143,191133,571,1,1,7554.596,1864.645,367.2740,0.24435,0,0,0,1,@TIMER,255,1),
(@GUID3+144,191133,571,1,1,7576.460,1972.390,369.5900,-0.87266,0,0,0,1,@TIMER,255,1),
(@GUID3+145,191133,571,1,1,7595.120,1891.100,371.2320,-2.72271,0,0,0,1,@TIMER,255,1),
(@GUID3+146,191133,571,1,1,7607.160,1752.610,339.9570,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID3+147,191133,571,1,1,7633.180,716.693,484.5840,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+148,191133,571,1,1,7653.100,2792.670,414.9850,0.12217,0,0,0,1,@TIMER,255,1),
(@GUID3+149,191133,571,1,1,7656.878,1786.749,350.2715,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID3+150,191133,571,1,1,7656.880,1786.750,350.2720,-2.51327,0,0,0,1,@TIMER,255,1),
(@GUID3+151,191133,571,1,1,7664.280,1709.210,333.7010,1.85005,0,0,0,1,@TIMER,255,1),
(@GUID3+152,191133,571,1,1,7678.119,2818.930,444.8793,2.42601,0,0,0,1,@TIMER,255,1),
(@GUID3+153,191133,571,1,1,7679.018,1021.261,471.1822,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID3+154,191133,571,1,1,7685.300,1256.030,341.5660,-2.30383,0,0,0,1,@TIMER,255,1),
(@GUID3+155,191133,571,1,1,7687.900,3554.850,736.6150,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID3+156,191133,571,1,1,7688.260,1386.790,347.2900,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID3+157,191133,571,1,1,7689.330,3181.030,578.8330,0.40143,0,0,0,1,@TIMER,255,1),
(@GUID3+158,191133,571,1,1,7689.890,553.471,698.6200,0.68068,0,0,0,1,@TIMER,255,1),
(@GUID3+159,191133,571,1,1,7712.260,1282.210,339.2810,1.83259,0,0,0,1,@TIMER,255,1),
(@GUID3+160,191133,571,1,1,7720.600,1424.710,353.3610,-1.62316,0,0,0,1,@TIMER,255,1),
(@GUID3+161,191133,571,1,1,7726.390,1305.620,341.8380,-2.96704,0,0,0,1,@TIMER,255,1),
(@GUID3+162,191133,571,1,1,7733.940,1814.480,349.6280,-1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+163,191133,571,1,1,7744.650,1779.400,338.0610,3.03684,0,0,0,1,@TIMER,255,1),
(@GUID3+164,191133,571,1,1,7764.360,1088.720,395.6190,-0.61086,0,0,0,1,@TIMER,255,1),
(@GUID3+165,191133,571,1,1,7765.605,2713.188,409.2500,2.68781,0,0,0,1,@TIMER,255,1),
(@GUID3+166,191133,571,1,1,7772.450,796.567,517.5690,0.41888,0,0,0,1,@TIMER,255,1),
(@GUID3+167,191133,571,1,1,7773.792,1499.624,360.2978,-2.21657,0,0,0,1,@TIMER,255,1),
(@GUID3+168,191133,571,1,1,7774.563,2665.078,405.8254,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID3+169,191133,571,1,1,7774.563,2665.078,405.8254,-0.66322,0,0,0,1,@TIMER,255,1),
(@GUID3+170,191133,571,1,1,7779.620,1830.560,356.3590,-2.53072,0,0,0,1,@TIMER,255,1),
(@GUID3+171,191133,571,1,1,7781.560,1106.510,395.6670,2.54818,0,0,0,1,@TIMER,255,1),
(@GUID3+172,191133,571,1,1,7784.990,1043.740,395.6190,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+173,191133,571,1,1,7793.370,1526.290,363.6070,0.48869,0,0,0,1,@TIMER,255,1),
(@GUID3+174,191133,571,1,1,7805.900,943.421,451.6210,-1.09956,0,0,0,1,@TIMER,255,1),
(@GUID3+175,191133,571,1,1,7819.700,1132.740,395.6190,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID3+176,191133,571,1,1,7822.420,696.106,554.0000,1.01229,0,0,0,1,@TIMER,255,1),
(@GUID3+177,191133,571,1,1,7833.479,3008.132,536.2718,-1.20428,0,0,0,1,@TIMER,255,1),
(@GUID3+178,191133,571,1,1,7834.560,818.007,501.7090,-0.92502,0,0,0,1,@TIMER,255,1),
(@GUID3+179,191133,571,1,1,7845.009,3354.724,736.6236,0.82030,0,0,0,1,@TIMER,255,1),
(@GUID3+180,191133,571,1,1,7848.730,1108.210,395.6100,2.74016,0,0,0,1,@TIMER,255,1),
(@GUID3+181,191133,571,1,1,7854.104,1125.911,395.6191,1.88495,0,0,0,1,@TIMER,255,1),
(@GUID3+182,191133,571,1,1,7857.740,1414.600,439.1670,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID3+183,191133,571,1,1,7867.160,1550.810,378.1740,0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+184,191133,571,1,1,7894.100,1533.870,396.8620,-3.07177,0,0,0,1,@TIMER,255,1),
(@GUID3+185,191133,571,1,1,7915.382,2484.846,405.5244,0.73304,0,0,0,1,@TIMER,255,1),
(@GUID3+186,191133,571,1,1,7926.210,2439.340,411.3850,2.67035,0,0,0,1,@TIMER,255,1),
(@GUID3+187,191133,571,1,1,7930.313,2802.014,499.5031,-2.44346,0,0,0,1,@TIMER,255,1),
(@GUID3+188,191133,571,1,1,7935.660,1579.350,411.4840,-1.91986,0,0,0,1,@TIMER,255,1),
(@GUID3+189,191133,571,1,1,7937.930,1442.640,520.4660,2.26892,0,0,0,1,@TIMER,255,1),
(@GUID3+190,191133,571,1,1,7940.259,3483.749,694.0527,-1.65806,0,0,0,1,@TIMER,255,1),
(@GUID3+191,191133,571,1,1,7941.500,1706.580,371.8170,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+192,191133,571,1,1,7958.130,1927.860,367.0540,3.05433,0,0,0,1,@TIMER,255,1),
(@GUID3+193,191133,571,1,1,7963.188,2787.479,525.1877,-1.83259,0,0,0,1,@TIMER,255,1),
(@GUID3+194,191133,571,1,1,7980.900,1539.410,467.7100,1.46608,0,0,0,1,@TIMER,255,1),
(@GUID3+195,191133,571,1,1,8006.929,1907.343,380.7083,-1.13446,0,0,0,1,@TIMER,255,1),
(@GUID3+196,191133,571,1,1,8044.050,1805.050,409.0340,2.09439,0,0,0,1,@TIMER,255,1),
(@GUID3+197,191133,571,1,1,8050.090,2858.940,510.4690,-1.65806,0,0,0,1,@TIMER,255,1),
(@GUID3+198,191133,571,1,1,8078.370,1646.490,553.9380,1.97222,0,0,0,1,@TIMER,255,1),
(@GUID3+199,191133,571,1,1,8128.210,1460.340,698.1700,0.20944,0,0,0,1,@TIMER,255,1),
(@GUID3+200,191133,571,1,1,8150.700,1169.640,687.5320,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID3+201,191133,571,1,1,8160.790,1539.710,630.5920,0.76794,0,0,0,1,@TIMER,255,1),
(@GUID3+202,191133,571,1,1,8161.500,1561.790,613.8130,2.05949,0,0,0,1,@TIMER,255,1),
(@GUID3+203,191133,571,1,1,8162.180,1286.700,785.9620,2.33874,0,0,0,1,@TIMER,255,1),
(@GUID3+204,191133,571,1,1,8168.020,1303.410,793.5940,0.15708,0,0,0,1,@TIMER,255,1),
(@GUID3+205,191133,571,1,1,8207.790,1281.010,775.6510,-0.87266,0,0,0,1,@TIMER,255,1),
(@GUID3+206,191133,571,1,1,8242.540,1257.540,741.1770,-1.37881,0,0,0,1,@TIMER,255,1),
(@GUID3+207,191133,571,1,1,8253.710,1842.500,563.0770,1.44862,0,0,0,1,@TIMER,255,1),
(@GUID3+208,191133,571,1,1,8266.340,1755.560,580.5210,-2.91469,0,0,0,1,@TIMER,255,1),
(@GUID3+209,191133,571,1,1,8292.690,2611.040,718.0010,-2.93214,0,0,0,1,@TIMER,255,1),
(@GUID3+210,191133,571,1,1,8308.630,3014.360,679.2830,1.44862,0,0,0,1,@TIMER,255,1),
(@GUID3+211,191133,571,1,1,8450.060,1675.780,701.8550,-2.04204,0,0,0,1,@TIMER,255,1),
(@GUID3+212,191133,571,1,1,8478.730,1445.280,641.2010,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID3+213,191133,571,1,1,8478.730,1445.280,650.4550,1.25664,0,0,0,1,@TIMER,255,1),
(@GUID3+214,191133,571,1,1,8523.810,1290.220,623.7830,-3.00195,0,0,0,1,@TIMER,255,1),
(@GUID3+215,191133,571,1,1,8579.111,1431.439,615.5118,2.37364,0,0,0,1,@TIMER,255,1),
(@GUID3+216,191133,571,1,1,8698.680,909.670,496.3710,-0.71559,0,0,0,1,@TIMER,255,1),
(@GUID3+217,191133,571,1,1,8707.630,1008.050,443.8770,0.89012,0,0,0,1,@TIMER,255,1),
(@GUID3+218,191133,571,1,2,5915.753,1990.665,518.8197,-2.98450,0,0,0,1,@TIMER,255,1),
(@GUID3+219,191133,571,1,2,5996.645,2335.773,518.0319,-0.55850,0,0,0,1,@TIMER,255,1),
(@GUID3+220,191133,571,1,2,6367.613,1682.053,548.5184,-0.83776,0,0,0,1,@TIMER,255,1),
(@GUID3+221,191133,571,1,2,6691.890,1520.673,466.3800,-2.07694,0,0,0,1,@TIMER,255,1),
(@GUID3+222,191133,571,1,3,5715.870,2059.130,-340.3910,-2.25147,0,0,0,1,@TIMER,255,1),
(@GUID3+223,191133,571,1,3,7332.590,3024.400,440.8590,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID3+224,191133,571,1,3,8149.280,2384.140,510.6090,2.51327,0,0,0,1,@TIMER,255,1),
(@GUID3+225,191133,571,1,4,7566.926,1642.527,348.2145,1.09956,0,0,0,1,@TIMER,255,1),
(@GUID3+226,191133,571,1,4,7828.466,1809.705,348.0653,0.43633,0,0,0,1,@TIMER,255,1),
(@GUID3+227,191133,571,1,5,5877.630,1942.750,518.3700,-0.27925,0,0,0,1,@TIMER,255,1),
(@GUID3+228,191133,571,1,5,5889.070,2160.360,515.0020,-2.47837,0,0,0,1,@TIMER,255,1),
(@GUID3+229,191133,571,1,5,5966.520,1908.870,580.8170,0.71559,0,0,0,1,@TIMER,255,1),
(@GUID3+230,191133,571,1,64,6803.910,3634.238,743.4531,-0.33161,0,0,0,1,@TIMER,255,1),
(@GUID3+231,191133,571,1,64,7070.146,3508.667,733.4362,-1.22173,0,0,0,1,@TIMER,255,1),
(@GUID3+232,191133,571,1,256,6166.920,2004.080,541.9620,1.79769,0,0,0,1,@TIMER,255,1),
(@GUID3+233,191133,571,1,256,6522.390,2173.170,509.0700,-3.10665,0,0,0,1,@TIMER,255,1),
(@GUID3+234,191133,571,1,256,6831.540,2201.450,663.2940,2.98450,0,0,0,1,@TIMER,255,1);
-- Pooling
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID1 AND @GUID1+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID2 AND @GUID2+@LASTGUID;
DELETE FROM `pool_gameobject` WHERE `guid` BETWEEN @GUID3 AND @GUID3+@LASTGUID;
-- Pool different ore types to each spawnpoint
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID1+0,@POOL+0,@CHANCE1, 'Icecrown Ore Spawnpoint 1 Saronite'),
(@GUID2+0,@POOL+0,@CHANCE2, 'Icecrown Ore Spawnpoint 1 Rich Saronite'),
(@GUID3+0,@POOL+0,@CHANCE3, 'Icecrown Ore Spawnpoint 1 Titanium'),
(@GUID1+1,@POOL+1,@CHANCE1, 'Icecrown Ore Spawnpoint 2 Saronite'),
(@GUID2+1,@POOL+1,@CHANCE2, 'Icecrown Ore Spawnpoint 2 Rich Saronite'),
(@GUID3+1,@POOL+1,@CHANCE3, 'Icecrown Ore Spawnpoint 2 Titanium'),
(@GUID1+2,@POOL+2,@CHANCE1, 'Icecrown Ore Spawnpoint 3 Saronite'),
(@GUID2+2,@POOL+2,@CHANCE2, 'Icecrown Ore Spawnpoint 3 Rich Saronite'),
(@GUID3+2,@POOL+2,@CHANCE3, 'Icecrown Ore Spawnpoint 3 Titanium'),
(@GUID1+3,@POOL+3,@CHANCE1, 'Icecrown Ore Spawnpoint 4 Saronite'),
(@GUID2+3,@POOL+3,@CHANCE2, 'Icecrown Ore Spawnpoint 4 Rich Saronite'),
(@GUID3+3,@POOL+3,@CHANCE3, 'Icecrown Ore Spawnpoint 4 Titanium'),
(@GUID1+4,@POOL+4,@CHANCE1, 'Icecrown Ore Spawnpoint 5 Saronite'),
(@GUID2+4,@POOL+4,@CHANCE2, 'Icecrown Ore Spawnpoint 5 Rich Saronite'),
(@GUID3+4,@POOL+4,@CHANCE3, 'Icecrown Ore Spawnpoint 5 Titanium'),
(@GUID1+5,@POOL+5,@CHANCE1, 'Icecrown Ore Spawnpoint 6 Saronite'),
(@GUID2+5,@POOL+5,@CHANCE2, 'Icecrown Ore Spawnpoint 6 Rich Saronite'),
(@GUID3+5,@POOL+5,@CHANCE3, 'Icecrown Ore Spawnpoint 6 Titanium'),
(@GUID1+6,@POOL+6,@CHANCE1, 'Icecrown Ore Spawnpoint 7 Saronite'),
(@GUID2+6,@POOL+6,@CHANCE2, 'Icecrown Ore Spawnpoint 7 Rich Saronite'),
(@GUID3+6,@POOL+6,@CHANCE3, 'Icecrown Ore Spawnpoint 7 Titanium'),
(@GUID1+7,@POOL+7,@CHANCE1, 'Icecrown Ore Spawnpoint 8 Saronite'),
(@GUID2+7,@POOL+7,@CHANCE2, 'Icecrown Ore Spawnpoint 8 Rich Saronite'),
(@GUID3+7,@POOL+7,@CHANCE3, 'Icecrown Ore Spawnpoint 8 Titanium'),
(@GUID1+8,@POOL+8,@CHANCE1, 'Icecrown Ore Spawnpoint 9 Saronite'),
(@GUID2+8,@POOL+8,@CHANCE2, 'Icecrown Ore Spawnpoint 9 Rich Saronite'),
(@GUID3+8,@POOL+8,@CHANCE3, 'Icecrown Ore Spawnpoint 9 Titanium'),
(@GUID1+9,@POOL+9,@CHANCE1, 'Icecrown Ore Spawnpoint 10 Saronite'),
(@GUID2+9,@POOL+9,@CHANCE2, 'Icecrown Ore Spawnpoint 10 Rich Saronite'),
(@GUID3+9,@POOL+9,@CHANCE3, 'Icecrown Ore Spawnpoint 10 Titanium'),
(@GUID1+10,@POOL+10,@CHANCE1, 'Icecrown Ore Spawnpoint 11 Saronite'),
(@GUID2+10,@POOL+10,@CHANCE2, 'Icecrown Ore Spawnpoint 11 Rich Saronite'),
(@GUID3+10,@POOL+10,@CHANCE3, 'Icecrown Ore Spawnpoint 11 Titanium'),
(@GUID1+11,@POOL+11,@CHANCE1, 'Icecrown Ore Spawnpoint 12 Saronite'),
(@GUID2+11,@POOL+11,@CHANCE2, 'Icecrown Ore Spawnpoint 12 Rich Saronite'),
(@GUID3+11,@POOL+11,@CHANCE3, 'Icecrown Ore Spawnpoint 12 Titanium'),
(@GUID1+12,@POOL+12,@CHANCE1, 'Icecrown Ore Spawnpoint 13 Saronite'),
(@GUID2+12,@POOL+12,@CHANCE2, 'Icecrown Ore Spawnpoint 13 Rich Saronite'),
(@GUID3+12,@POOL+12,@CHANCE3, 'Icecrown Ore Spawnpoint 13 Titanium'),
(@GUID1+13,@POOL+13,@CHANCE1, 'Icecrown Ore Spawnpoint 14 Saronite'),
(@GUID2+13,@POOL+13,@CHANCE2, 'Icecrown Ore Spawnpoint 14 Rich Saronite'),
(@GUID3+13,@POOL+13,@CHANCE3, 'Icecrown Ore Spawnpoint 14 Titanium'),
(@GUID1+14,@POOL+14,@CHANCE1, 'Icecrown Ore Spawnpoint 15 Saronite'),
(@GUID2+14,@POOL+14,@CHANCE2, 'Icecrown Ore Spawnpoint 15 Rich Saronite'),
(@GUID3+14,@POOL+14,@CHANCE3, 'Icecrown Ore Spawnpoint 15 Titanium'),
(@GUID1+15,@POOL+15,@CHANCE1, 'Icecrown Ore Spawnpoint 16 Saronite'),
(@GUID2+15,@POOL+15,@CHANCE2, 'Icecrown Ore Spawnpoint 16 Rich Saronite'),
(@GUID3+15,@POOL+15,@CHANCE3, 'Icecrown Ore Spawnpoint 16 Titanium'),
(@GUID1+16,@POOL+16,@CHANCE1, 'Icecrown Ore Spawnpoint 17 Saronite'),
(@GUID2+16,@POOL+16,@CHANCE2, 'Icecrown Ore Spawnpoint 17 Rich Saronite'),
(@GUID3+16,@POOL+16,@CHANCE3, 'Icecrown Ore Spawnpoint 17 Titanium'),
(@GUID1+17,@POOL+17,@CHANCE1, 'Icecrown Ore Spawnpoint 18 Saronite'),
(@GUID2+17,@POOL+17,@CHANCE2, 'Icecrown Ore Spawnpoint 18 Rich Saronite'),
(@GUID3+17,@POOL+17,@CHANCE3, 'Icecrown Ore Spawnpoint 18 Titanium'),
(@GUID1+18,@POOL+18,@CHANCE1, 'Icecrown Ore Spawnpoint 19 Saronite'),
(@GUID2+18,@POOL+18,@CHANCE2, 'Icecrown Ore Spawnpoint 19 Rich Saronite'),
(@GUID3+18,@POOL+18,@CHANCE3, 'Icecrown Ore Spawnpoint 19 Titanium'),
(@GUID1+19,@POOL+19,@CHANCE1, 'Icecrown Ore Spawnpoint 20 Saronite'),
(@GUID2+19,@POOL+19,@CHANCE2, 'Icecrown Ore Spawnpoint 20 Rich Saronite'),
(@GUID3+19,@POOL+19,@CHANCE3, 'Icecrown Ore Spawnpoint 20 Titanium'),
(@GUID1+20,@POOL+20,@CHANCE1, 'Icecrown Ore Spawnpoint 21 Saronite'),
(@GUID2+20,@POOL+20,@CHANCE2, 'Icecrown Ore Spawnpoint 21 Rich Saronite'),
(@GUID3+20,@POOL+20,@CHANCE3, 'Icecrown Ore Spawnpoint 21 Titanium'),
(@GUID1+21,@POOL+21,@CHANCE1, 'Icecrown Ore Spawnpoint 22 Saronite'),
(@GUID2+21,@POOL+21,@CHANCE2, 'Icecrown Ore Spawnpoint 22 Rich Saronite'),
(@GUID3+21,@POOL+21,@CHANCE3, 'Icecrown Ore Spawnpoint 22 Titanium'),
(@GUID1+22,@POOL+22,@CHANCE1, 'Icecrown Ore Spawnpoint 23 Saronite'),
(@GUID2+22,@POOL+22,@CHANCE2, 'Icecrown Ore Spawnpoint 23 Rich Saronite'),
(@GUID3+22,@POOL+22,@CHANCE3, 'Icecrown Ore Spawnpoint 23 Titanium'),
(@GUID1+23,@POOL+23,@CHANCE1, 'Icecrown Ore Spawnpoint 24 Saronite'),
(@GUID2+23,@POOL+23,@CHANCE2, 'Icecrown Ore Spawnpoint 24 Rich Saronite'),
(@GUID3+23,@POOL+23,@CHANCE3, 'Icecrown Ore Spawnpoint 24 Titanium'),
(@GUID1+24,@POOL+24,@CHANCE1, 'Icecrown Ore Spawnpoint 25 Saronite'),
(@GUID2+24,@POOL+24,@CHANCE2, 'Icecrown Ore Spawnpoint 25 Rich Saronite'),
(@GUID3+24,@POOL+24,@CHANCE3, 'Icecrown Ore Spawnpoint 25 Titanium'),
(@GUID1+25,@POOL+25,@CHANCE1, 'Icecrown Ore Spawnpoint 26 Saronite'),
(@GUID2+25,@POOL+25,@CHANCE2, 'Icecrown Ore Spawnpoint 26 Rich Saronite'),
(@GUID3+25,@POOL+25,@CHANCE3, 'Icecrown Ore Spawnpoint 26 Titanium'),
(@GUID1+26,@POOL+26,@CHANCE1, 'Icecrown Ore Spawnpoint 27 Saronite'),
(@GUID2+26,@POOL+26,@CHANCE2, 'Icecrown Ore Spawnpoint 27 Rich Saronite'),
(@GUID3+26,@POOL+26,@CHANCE3, 'Icecrown Ore Spawnpoint 27 Titanium'),
(@GUID1+27,@POOL+27,@CHANCE1, 'Icecrown Ore Spawnpoint 28 Saronite'),
(@GUID2+27,@POOL+27,@CHANCE2, 'Icecrown Ore Spawnpoint 28 Rich Saronite'),
(@GUID3+27,@POOL+27,@CHANCE3, 'Icecrown Ore Spawnpoint 28 Titanium'),
(@GUID1+28,@POOL+28,@CHANCE1, 'Icecrown Ore Spawnpoint 29 Saronite'),
(@GUID2+28,@POOL+28,@CHANCE2, 'Icecrown Ore Spawnpoint 29 Rich Saronite'),
(@GUID3+28,@POOL+28,@CHANCE3, 'Icecrown Ore Spawnpoint 29 Titanium'),
(@GUID1+29,@POOL+29,@CHANCE1, 'Icecrown Ore Spawnpoint 30 Saronite'),
(@GUID2+29,@POOL+29,@CHANCE2, 'Icecrown Ore Spawnpoint 30 Rich Saronite'),
(@GUID3+29,@POOL+29,@CHANCE3, 'Icecrown Ore Spawnpoint 30 Titanium'),
(@GUID1+30,@POOL+30,@CHANCE1, 'Icecrown Ore Spawnpoint 31 Saronite'),
(@GUID2+30,@POOL+30,@CHANCE2, 'Icecrown Ore Spawnpoint 31 Rich Saronite'),
(@GUID3+30,@POOL+30,@CHANCE3, 'Icecrown Ore Spawnpoint 31 Titanium'),
(@GUID1+31,@POOL+31,@CHANCE1, 'Icecrown Ore Spawnpoint 32 Saronite'),
(@GUID2+31,@POOL+31,@CHANCE2, 'Icecrown Ore Spawnpoint 32 Rich Saronite'),
(@GUID3+31,@POOL+31,@CHANCE3, 'Icecrown Ore Spawnpoint 32 Titanium'),
(@GUID1+32,@POOL+32,@CHANCE1, 'Icecrown Ore Spawnpoint 33 Saronite'),
(@GUID2+32,@POOL+32,@CHANCE2, 'Icecrown Ore Spawnpoint 33 Rich Saronite'),
(@GUID3+32,@POOL+32,@CHANCE3, 'Icecrown Ore Spawnpoint 33 Titanium'),
(@GUID1+33,@POOL+33,@CHANCE1, 'Icecrown Ore Spawnpoint 34 Saronite'),
(@GUID2+33,@POOL+33,@CHANCE2, 'Icecrown Ore Spawnpoint 34 Rich Saronite'),
(@GUID3+33,@POOL+33,@CHANCE3, 'Icecrown Ore Spawnpoint 34 Titanium'),
(@GUID1+34,@POOL+34,@CHANCE1, 'Icecrown Ore Spawnpoint 35 Saronite'),
(@GUID2+34,@POOL+34,@CHANCE2, 'Icecrown Ore Spawnpoint 35 Rich Saronite'),
(@GUID3+34,@POOL+34,@CHANCE3, 'Icecrown Ore Spawnpoint 35 Titanium'),
(@GUID1+35,@POOL+35,@CHANCE1, 'Icecrown Ore Spawnpoint 36 Saronite'),
(@GUID2+35,@POOL+35,@CHANCE2, 'Icecrown Ore Spawnpoint 36 Rich Saronite'),
(@GUID3+35,@POOL+35,@CHANCE3, 'Icecrown Ore Spawnpoint 36 Titanium'),
(@GUID1+36,@POOL+36,@CHANCE1, 'Icecrown Ore Spawnpoint 37 Saronite'),
(@GUID2+36,@POOL+36,@CHANCE2, 'Icecrown Ore Spawnpoint 37 Rich Saronite'),
(@GUID3+36,@POOL+36,@CHANCE3, 'Icecrown Ore Spawnpoint 37 Titanium'),
(@GUID1+37,@POOL+37,@CHANCE1, 'Icecrown Ore Spawnpoint 38 Saronite'),
(@GUID2+37,@POOL+37,@CHANCE2, 'Icecrown Ore Spawnpoint 38 Rich Saronite'),
(@GUID3+37,@POOL+37,@CHANCE3, 'Icecrown Ore Spawnpoint 38 Titanium'),
(@GUID1+38,@POOL+38,@CHANCE1, 'Icecrown Ore Spawnpoint 39 Saronite'),
(@GUID2+38,@POOL+38,@CHANCE2, 'Icecrown Ore Spawnpoint 39 Rich Saronite'),
(@GUID3+38,@POOL+38,@CHANCE3, 'Icecrown Ore Spawnpoint 39 Titanium'),
(@GUID1+39,@POOL+39,@CHANCE1, 'Icecrown Ore Spawnpoint 40 Saronite'),
(@GUID2+39,@POOL+39,@CHANCE2, 'Icecrown Ore Spawnpoint 40 Rich Saronite'),
(@GUID3+39,@POOL+39,@CHANCE3, 'Icecrown Ore Spawnpoint 40 Titanium'),
(@GUID1+40,@POOL+40,@CHANCE1, 'Icecrown Ore Spawnpoint 41 Saronite'),
(@GUID2+40,@POOL+40,@CHANCE2, 'Icecrown Ore Spawnpoint 41 Rich Saronite'),
(@GUID3+40,@POOL+40,@CHANCE3, 'Icecrown Ore Spawnpoint 41 Titanium'),
(@GUID1+41,@POOL+41,@CHANCE1, 'Icecrown Ore Spawnpoint 42 Saronite'),
(@GUID2+41,@POOL+41,@CHANCE2, 'Icecrown Ore Spawnpoint 42 Rich Saronite'),
(@GUID3+41,@POOL+41,@CHANCE3, 'Icecrown Ore Spawnpoint 42 Titanium'),
(@GUID1+42,@POOL+42,@CHANCE1, 'Icecrown Ore Spawnpoint 43 Saronite'),
(@GUID2+42,@POOL+42,@CHANCE2, 'Icecrown Ore Spawnpoint 43 Rich Saronite'),
(@GUID3+42,@POOL+42,@CHANCE3, 'Icecrown Ore Spawnpoint 43 Titanium'),
(@GUID1+43,@POOL+43,@CHANCE1, 'Icecrown Ore Spawnpoint 44 Saronite'),
(@GUID2+43,@POOL+43,@CHANCE2, 'Icecrown Ore Spawnpoint 44 Rich Saronite'),
(@GUID3+43,@POOL+43,@CHANCE3, 'Icecrown Ore Spawnpoint 44 Titanium'),
(@GUID1+44,@POOL+44,@CHANCE1, 'Icecrown Ore Spawnpoint 45 Saronite'),
(@GUID2+44,@POOL+44,@CHANCE2, 'Icecrown Ore Spawnpoint 45 Rich Saronite'),
(@GUID3+44,@POOL+44,@CHANCE3, 'Icecrown Ore Spawnpoint 45 Titanium'),
(@GUID1+45,@POOL+45,@CHANCE1, 'Icecrown Ore Spawnpoint 46 Saronite'),
(@GUID2+45,@POOL+45,@CHANCE2, 'Icecrown Ore Spawnpoint 46 Rich Saronite'),
(@GUID3+45,@POOL+45,@CHANCE3, 'Icecrown Ore Spawnpoint 46 Titanium'),
(@GUID1+46,@POOL+46,@CHANCE1, 'Icecrown Ore Spawnpoint 47 Saronite'),
(@GUID2+46,@POOL+46,@CHANCE2, 'Icecrown Ore Spawnpoint 47 Rich Saronite'),
(@GUID3+46,@POOL+46,@CHANCE3, 'Icecrown Ore Spawnpoint 47 Titanium'),
(@GUID1+47,@POOL+47,@CHANCE1, 'Icecrown Ore Spawnpoint 48 Saronite'),
(@GUID2+47,@POOL+47,@CHANCE2, 'Icecrown Ore Spawnpoint 48 Rich Saronite'),
(@GUID3+47,@POOL+47,@CHANCE3, 'Icecrown Ore Spawnpoint 48 Titanium'),
(@GUID1+48,@POOL+48,@CHANCE1, 'Icecrown Ore Spawnpoint 49 Saronite'),
(@GUID2+48,@POOL+48,@CHANCE2, 'Icecrown Ore Spawnpoint 49 Rich Saronite'),
(@GUID3+48,@POOL+48,@CHANCE3, 'Icecrown Ore Spawnpoint 49 Titanium'),
(@GUID1+49,@POOL+49,@CHANCE1, 'Icecrown Ore Spawnpoint 50 Saronite'),
(@GUID2+49,@POOL+49,@CHANCE2, 'Icecrown Ore Spawnpoint 50 Rich Saronite'),
(@GUID3+49,@POOL+49,@CHANCE3, 'Icecrown Ore Spawnpoint 50 Titanium'),
(@GUID1+50,@POOL+50,@CHANCE1, 'Icecrown Ore Spawnpoint 51 Saronite'),
(@GUID2+50,@POOL+50,@CHANCE2, 'Icecrown Ore Spawnpoint 51 Rich Saronite'),
(@GUID3+50,@POOL+50,@CHANCE3, 'Icecrown Ore Spawnpoint 51 Titanium'),
(@GUID1+51,@POOL+51,@CHANCE1, 'Icecrown Ore Spawnpoint 52 Saronite'),
(@GUID2+51,@POOL+51,@CHANCE2, 'Icecrown Ore Spawnpoint 52 Rich Saronite'),
(@GUID3+51,@POOL+51,@CHANCE3, 'Icecrown Ore Spawnpoint 52 Titanium'),
(@GUID1+52,@POOL+52,@CHANCE1, 'Icecrown Ore Spawnpoint 53 Saronite'),
(@GUID2+52,@POOL+52,@CHANCE2, 'Icecrown Ore Spawnpoint 53 Rich Saronite'),
(@GUID3+52,@POOL+52,@CHANCE3, 'Icecrown Ore Spawnpoint 53 Titanium'),
(@GUID1+53,@POOL+53,@CHANCE1, 'Icecrown Ore Spawnpoint 54 Saronite'),
(@GUID2+53,@POOL+53,@CHANCE2, 'Icecrown Ore Spawnpoint 54 Rich Saronite'),
(@GUID3+53,@POOL+53,@CHANCE3, 'Icecrown Ore Spawnpoint 54 Titanium'),
(@GUID1+54,@POOL+54,@CHANCE1, 'Icecrown Ore Spawnpoint 55 Saronite'),
(@GUID2+54,@POOL+54,@CHANCE2, 'Icecrown Ore Spawnpoint 55 Rich Saronite'),
(@GUID3+54,@POOL+54,@CHANCE3, 'Icecrown Ore Spawnpoint 55 Titanium'),
(@GUID1+55,@POOL+55,@CHANCE1, 'Icecrown Ore Spawnpoint 56 Saronite'),
(@GUID2+55,@POOL+55,@CHANCE2, 'Icecrown Ore Spawnpoint 56 Rich Saronite'),
(@GUID3+55,@POOL+55,@CHANCE3, 'Icecrown Ore Spawnpoint 56 Titanium'),
(@GUID1+56,@POOL+56,@CHANCE1, 'Icecrown Ore Spawnpoint 57 Saronite'),
(@GUID2+56,@POOL+56,@CHANCE2, 'Icecrown Ore Spawnpoint 57 Rich Saronite'),
(@GUID3+56,@POOL+56,@CHANCE3, 'Icecrown Ore Spawnpoint 57 Titanium'),
(@GUID1+57,@POOL+57,@CHANCE1, 'Icecrown Ore Spawnpoint 58 Saronite'),
(@GUID2+57,@POOL+57,@CHANCE2, 'Icecrown Ore Spawnpoint 58 Rich Saronite'),
(@GUID3+57,@POOL+57,@CHANCE3, 'Icecrown Ore Spawnpoint 58 Titanium'),
(@GUID1+58,@POOL+58,@CHANCE1, 'Icecrown Ore Spawnpoint 59 Saronite'),
(@GUID2+58,@POOL+58,@CHANCE2, 'Icecrown Ore Spawnpoint 59 Rich Saronite'),
(@GUID3+58,@POOL+58,@CHANCE3, 'Icecrown Ore Spawnpoint 59 Titanium'),
(@GUID1+59,@POOL+59,@CHANCE1, 'Icecrown Ore Spawnpoint 60 Saronite'),
(@GUID2+59,@POOL+59,@CHANCE2, 'Icecrown Ore Spawnpoint 60 Rich Saronite'),
(@GUID3+59,@POOL+59,@CHANCE3, 'Icecrown Ore Spawnpoint 60 Titanium'),
(@GUID1+60,@POOL+60,@CHANCE1, 'Icecrown Ore Spawnpoint 61 Saronite'),
(@GUID2+60,@POOL+60,@CHANCE2, 'Icecrown Ore Spawnpoint 61 Rich Saronite'),
(@GUID3+60,@POOL+60,@CHANCE3, 'Icecrown Ore Spawnpoint 61 Titanium'),
(@GUID1+61,@POOL+61,@CHANCE1, 'Icecrown Ore Spawnpoint 62 Saronite'),
(@GUID2+61,@POOL+61,@CHANCE2, 'Icecrown Ore Spawnpoint 62 Rich Saronite'),
(@GUID3+61,@POOL+61,@CHANCE3, 'Icecrown Ore Spawnpoint 62 Titanium'),
(@GUID1+62,@POOL+62,@CHANCE1, 'Icecrown Ore Spawnpoint 63 Saronite'),
(@GUID2+62,@POOL+62,@CHANCE2, 'Icecrown Ore Spawnpoint 63 Rich Saronite'),
(@GUID3+62,@POOL+62,@CHANCE3, 'Icecrown Ore Spawnpoint 63 Titanium'),
(@GUID1+63,@POOL+63,@CHANCE1, 'Icecrown Ore Spawnpoint 64 Saronite'),
(@GUID2+63,@POOL+63,@CHANCE2, 'Icecrown Ore Spawnpoint 64 Rich Saronite'),
(@GUID3+63,@POOL+63,@CHANCE3, 'Icecrown Ore Spawnpoint 64 Titanium'),
(@GUID1+64,@POOL+64,@CHANCE1, 'Icecrown Ore Spawnpoint 65 Saronite'),
(@GUID2+64,@POOL+64,@CHANCE2, 'Icecrown Ore Spawnpoint 65 Rich Saronite'),
(@GUID3+64,@POOL+64,@CHANCE3, 'Icecrown Ore Spawnpoint 65 Titanium'),
(@GUID1+65,@POOL+65,@CHANCE1, 'Icecrown Ore Spawnpoint 66 Saronite'),
(@GUID2+65,@POOL+65,@CHANCE2, 'Icecrown Ore Spawnpoint 66 Rich Saronite'),
(@GUID3+65,@POOL+65,@CHANCE3, 'Icecrown Ore Spawnpoint 66 Titanium'),
(@GUID1+66,@POOL+66,@CHANCE1, 'Icecrown Ore Spawnpoint 67 Saronite'),
(@GUID2+66,@POOL+66,@CHANCE2, 'Icecrown Ore Spawnpoint 67 Rich Saronite'),
(@GUID3+66,@POOL+66,@CHANCE3, 'Icecrown Ore Spawnpoint 67 Titanium'),
(@GUID1+67,@POOL+67,@CHANCE1, 'Icecrown Ore Spawnpoint 68 Saronite'),
(@GUID2+67,@POOL+67,@CHANCE2, 'Icecrown Ore Spawnpoint 68 Rich Saronite'),
(@GUID3+67,@POOL+67,@CHANCE3, 'Icecrown Ore Spawnpoint 68 Titanium'),
(@GUID1+68,@POOL+68,@CHANCE1, 'Icecrown Ore Spawnpoint 69 Saronite'),
(@GUID2+68,@POOL+68,@CHANCE2, 'Icecrown Ore Spawnpoint 69 Rich Saronite'),
(@GUID3+68,@POOL+68,@CHANCE3, 'Icecrown Ore Spawnpoint 69 Titanium'),
(@GUID1+69,@POOL+69,@CHANCE1, 'Icecrown Ore Spawnpoint 70 Saronite'),
(@GUID2+69,@POOL+69,@CHANCE2, 'Icecrown Ore Spawnpoint 70 Rich Saronite'),
(@GUID3+69,@POOL+69,@CHANCE3, 'Icecrown Ore Spawnpoint 70 Titanium'),
(@GUID1+70,@POOL+70,@CHANCE1, 'Icecrown Ore Spawnpoint 71 Saronite'),
(@GUID2+70,@POOL+70,@CHANCE2, 'Icecrown Ore Spawnpoint 71 Rich Saronite'),
(@GUID3+70,@POOL+70,@CHANCE3, 'Icecrown Ore Spawnpoint 71 Titanium'),
(@GUID1+71,@POOL+71,@CHANCE1, 'Icecrown Ore Spawnpoint 72 Saronite'),
(@GUID2+71,@POOL+71,@CHANCE2, 'Icecrown Ore Spawnpoint 72 Rich Saronite'),
(@GUID3+71,@POOL+71,@CHANCE3, 'Icecrown Ore Spawnpoint 72 Titanium'),
(@GUID1+72,@POOL+72,@CHANCE1, 'Icecrown Ore Spawnpoint 73 Saronite'),
(@GUID2+72,@POOL+72,@CHANCE2, 'Icecrown Ore Spawnpoint 73 Rich Saronite'),
(@GUID3+72,@POOL+72,@CHANCE3, 'Icecrown Ore Spawnpoint 73 Titanium'),
(@GUID1+73,@POOL+73,@CHANCE1, 'Icecrown Ore Spawnpoint 74 Saronite'),
(@GUID2+73,@POOL+73,@CHANCE2, 'Icecrown Ore Spawnpoint 74 Rich Saronite'),
(@GUID3+73,@POOL+73,@CHANCE3, 'Icecrown Ore Spawnpoint 74 Titanium'),
(@GUID1+74,@POOL+74,@CHANCE1, 'Icecrown Ore Spawnpoint 75 Saronite'),
(@GUID2+74,@POOL+74,@CHANCE2, 'Icecrown Ore Spawnpoint 75 Rich Saronite'),
(@GUID3+74,@POOL+74,@CHANCE3, 'Icecrown Ore Spawnpoint 75 Titanium'),
(@GUID1+75,@POOL+75,@CHANCE1, 'Icecrown Ore Spawnpoint 76 Saronite'),
(@GUID2+75,@POOL+75,@CHANCE2, 'Icecrown Ore Spawnpoint 76 Rich Saronite'),
(@GUID3+75,@POOL+75,@CHANCE3, 'Icecrown Ore Spawnpoint 76 Titanium'),
(@GUID1+76,@POOL+76,@CHANCE1, 'Icecrown Ore Spawnpoint 77 Saronite'),
(@GUID2+76,@POOL+76,@CHANCE2, 'Icecrown Ore Spawnpoint 77 Rich Saronite'),
(@GUID3+76,@POOL+76,@CHANCE3, 'Icecrown Ore Spawnpoint 77 Titanium'),
(@GUID1+77,@POOL+77,@CHANCE1, 'Icecrown Ore Spawnpoint 78 Saronite'),
(@GUID2+77,@POOL+77,@CHANCE2, 'Icecrown Ore Spawnpoint 78 Rich Saronite'),
(@GUID3+77,@POOL+77,@CHANCE3, 'Icecrown Ore Spawnpoint 78 Titanium'),
(@GUID1+78,@POOL+78,@CHANCE1, 'Icecrown Ore Spawnpoint 79 Saronite'),
(@GUID2+78,@POOL+78,@CHANCE2, 'Icecrown Ore Spawnpoint 79 Rich Saronite'),
(@GUID3+78,@POOL+78,@CHANCE3, 'Icecrown Ore Spawnpoint 79 Titanium'),
(@GUID1+79,@POOL+79,@CHANCE1, 'Icecrown Ore Spawnpoint 80 Saronite'),
(@GUID2+79,@POOL+79,@CHANCE2, 'Icecrown Ore Spawnpoint 80 Rich Saronite'),
(@GUID3+79,@POOL+79,@CHANCE3, 'Icecrown Ore Spawnpoint 80 Titanium'),
(@GUID1+80,@POOL+80,@CHANCE1, 'Icecrown Ore Spawnpoint 81 Saronite'),
(@GUID2+80,@POOL+80,@CHANCE2, 'Icecrown Ore Spawnpoint 81 Rich Saronite'),
(@GUID3+80,@POOL+80,@CHANCE3, 'Icecrown Ore Spawnpoint 81 Titanium'),
(@GUID1+81,@POOL+81,@CHANCE1, 'Icecrown Ore Spawnpoint 82 Saronite'),
(@GUID2+81,@POOL+81,@CHANCE2, 'Icecrown Ore Spawnpoint 82 Rich Saronite'),
(@GUID3+81,@POOL+81,@CHANCE3, 'Icecrown Ore Spawnpoint 82 Titanium'),
(@GUID1+82,@POOL+82,@CHANCE1, 'Icecrown Ore Spawnpoint 83 Saronite'),
(@GUID2+82,@POOL+82,@CHANCE2, 'Icecrown Ore Spawnpoint 83 Rich Saronite'),
(@GUID3+82,@POOL+82,@CHANCE3, 'Icecrown Ore Spawnpoint 83 Titanium'),
(@GUID1+83,@POOL+83,@CHANCE1, 'Icecrown Ore Spawnpoint 84 Saronite'),
(@GUID2+83,@POOL+83,@CHANCE2, 'Icecrown Ore Spawnpoint 84 Rich Saronite'),
(@GUID3+83,@POOL+83,@CHANCE3, 'Icecrown Ore Spawnpoint 84 Titanium'),
(@GUID1+84,@POOL+84,@CHANCE1, 'Icecrown Ore Spawnpoint 85 Saronite'),
(@GUID2+84,@POOL+84,@CHANCE2, 'Icecrown Ore Spawnpoint 85 Rich Saronite'),
(@GUID3+84,@POOL+84,@CHANCE3, 'Icecrown Ore Spawnpoint 85 Titanium'),
(@GUID1+85,@POOL+85,@CHANCE1, 'Icecrown Ore Spawnpoint 86 Saronite'),
(@GUID2+85,@POOL+85,@CHANCE2, 'Icecrown Ore Spawnpoint 86 Rich Saronite'),
(@GUID3+85,@POOL+85,@CHANCE3, 'Icecrown Ore Spawnpoint 86 Titanium'),
(@GUID1+86,@POOL+86,@CHANCE1, 'Icecrown Ore Spawnpoint 87 Saronite'),
(@GUID2+86,@POOL+86,@CHANCE2, 'Icecrown Ore Spawnpoint 87 Rich Saronite'),
(@GUID3+86,@POOL+86,@CHANCE3, 'Icecrown Ore Spawnpoint 87 Titanium'),
(@GUID1+87,@POOL+87,@CHANCE1, 'Icecrown Ore Spawnpoint 88 Saronite'),
(@GUID2+87,@POOL+87,@CHANCE2, 'Icecrown Ore Spawnpoint 88 Rich Saronite'),
(@GUID3+87,@POOL+87,@CHANCE3, 'Icecrown Ore Spawnpoint 88 Titanium'),
(@GUID1+88,@POOL+88,@CHANCE1, 'Icecrown Ore Spawnpoint 89 Saronite'),
(@GUID2+88,@POOL+88,@CHANCE2, 'Icecrown Ore Spawnpoint 89 Rich Saronite'),
(@GUID3+88,@POOL+88,@CHANCE3, 'Icecrown Ore Spawnpoint 89 Titanium'),
(@GUID1+89,@POOL+89,@CHANCE1, 'Icecrown Ore Spawnpoint 90 Saronite'),
(@GUID2+89,@POOL+89,@CHANCE2, 'Icecrown Ore Spawnpoint 90 Rich Saronite'),
(@GUID3+89,@POOL+89,@CHANCE3, 'Icecrown Ore Spawnpoint 90 Titanium'),
(@GUID1+90,@POOL+90,@CHANCE1, 'Icecrown Ore Spawnpoint 91 Saronite'),
(@GUID2+90,@POOL+90,@CHANCE2, 'Icecrown Ore Spawnpoint 91 Rich Saronite'),
(@GUID3+90,@POOL+90,@CHANCE3, 'Icecrown Ore Spawnpoint 91 Titanium'),
(@GUID1+91,@POOL+91,@CHANCE1, 'Icecrown Ore Spawnpoint 92 Saronite'),
(@GUID2+91,@POOL+91,@CHANCE2, 'Icecrown Ore Spawnpoint 92 Rich Saronite'),
(@GUID3+91,@POOL+91,@CHANCE3, 'Icecrown Ore Spawnpoint 92 Titanium'),
(@GUID1+92,@POOL+92,@CHANCE1, 'Icecrown Ore Spawnpoint 93 Saronite'),
(@GUID2+92,@POOL+92,@CHANCE2, 'Icecrown Ore Spawnpoint 93 Rich Saronite'),
(@GUID3+92,@POOL+92,@CHANCE3, 'Icecrown Ore Spawnpoint 93 Titanium'),
(@GUID1+93,@POOL+93,@CHANCE1, 'Icecrown Ore Spawnpoint 94 Saronite'),
(@GUID2+93,@POOL+93,@CHANCE2, 'Icecrown Ore Spawnpoint 94 Rich Saronite'),
(@GUID3+93,@POOL+93,@CHANCE3, 'Icecrown Ore Spawnpoint 94 Titanium'),
(@GUID1+94,@POOL+94,@CHANCE1, 'Icecrown Ore Spawnpoint 95 Saronite'),
(@GUID2+94,@POOL+94,@CHANCE2, 'Icecrown Ore Spawnpoint 95 Rich Saronite'),
(@GUID3+94,@POOL+94,@CHANCE3, 'Icecrown Ore Spawnpoint 95 Titanium'),
(@GUID1+95,@POOL+95,@CHANCE1, 'Icecrown Ore Spawnpoint 96 Saronite'),
(@GUID2+95,@POOL+95,@CHANCE2, 'Icecrown Ore Spawnpoint 96 Rich Saronite'),
(@GUID3+95,@POOL+95,@CHANCE3, 'Icecrown Ore Spawnpoint 96 Titanium'),
(@GUID1+96,@POOL+96,@CHANCE1, 'Icecrown Ore Spawnpoint 97 Saronite'),
(@GUID2+96,@POOL+96,@CHANCE2, 'Icecrown Ore Spawnpoint 97 Rich Saronite'),
(@GUID3+96,@POOL+96,@CHANCE3, 'Icecrown Ore Spawnpoint 97 Titanium'),
(@GUID1+97,@POOL+97,@CHANCE1, 'Icecrown Ore Spawnpoint 98 Saronite'),
(@GUID2+97,@POOL+97,@CHANCE2, 'Icecrown Ore Spawnpoint 98 Rich Saronite'),
(@GUID3+97,@POOL+97,@CHANCE3, 'Icecrown Ore Spawnpoint 98 Titanium'),
(@GUID1+98,@POOL+98,@CHANCE1, 'Icecrown Ore Spawnpoint 99 Saronite'),
(@GUID2+98,@POOL+98,@CHANCE2, 'Icecrown Ore Spawnpoint 99 Rich Saronite'),
(@GUID3+98,@POOL+98,@CHANCE3, 'Icecrown Ore Spawnpoint 99 Titanium'),
(@GUID1+99,@POOL+99,@CHANCE1, 'Icecrown Ore Spawnpoint 100 Saronite'),
(@GUID2+99,@POOL+99,@CHANCE2, 'Icecrown Ore Spawnpoint 100 Rich Saronite'),
(@GUID3+99,@POOL+99,@CHANCE3, 'Icecrown Ore Spawnpoint 100 Titanium'),
(@GUID1+100,@POOL+100,@CHANCE1, 'Icecrown Ore Spawnpoint 101 Saronite'),
(@GUID2+100,@POOL+100,@CHANCE2, 'Icecrown Ore Spawnpoint 101 Rich Saronite'),
(@GUID3+100,@POOL+100,@CHANCE3, 'Icecrown Ore Spawnpoint 101 Titanium'),
(@GUID1+101,@POOL+101,@CHANCE1, 'Icecrown Ore Spawnpoint 102 Saronite'),
(@GUID2+101,@POOL+101,@CHANCE2, 'Icecrown Ore Spawnpoint 102 Rich Saronite'),
(@GUID3+101,@POOL+101,@CHANCE3, 'Icecrown Ore Spawnpoint 102 Titanium'),
(@GUID1+102,@POOL+102,@CHANCE1, 'Icecrown Ore Spawnpoint 103 Saronite'),
(@GUID2+102,@POOL+102,@CHANCE2, 'Icecrown Ore Spawnpoint 103 Rich Saronite'),
(@GUID3+102,@POOL+102,@CHANCE3, 'Icecrown Ore Spawnpoint 103 Titanium'),
(@GUID1+103,@POOL+103,@CHANCE1, 'Icecrown Ore Spawnpoint 104 Saronite'),
(@GUID2+103,@POOL+103,@CHANCE2, 'Icecrown Ore Spawnpoint 104 Rich Saronite'),
(@GUID3+103,@POOL+103,@CHANCE3, 'Icecrown Ore Spawnpoint 104 Titanium'),
(@GUID1+104,@POOL+104,@CHANCE1, 'Icecrown Ore Spawnpoint 105 Saronite'),
(@GUID2+104,@POOL+104,@CHANCE2, 'Icecrown Ore Spawnpoint 105 Rich Saronite'),
(@GUID3+104,@POOL+104,@CHANCE3, 'Icecrown Ore Spawnpoint 105 Titanium'),
(@GUID1+105,@POOL+105,@CHANCE1, 'Icecrown Ore Spawnpoint 106 Saronite'),
(@GUID2+105,@POOL+105,@CHANCE2, 'Icecrown Ore Spawnpoint 106 Rich Saronite'),
(@GUID3+105,@POOL+105,@CHANCE3, 'Icecrown Ore Spawnpoint 106 Titanium'),
(@GUID1+106,@POOL+106,@CHANCE1, 'Icecrown Ore Spawnpoint 107 Saronite'),
(@GUID2+106,@POOL+106,@CHANCE2, 'Icecrown Ore Spawnpoint 107 Rich Saronite'),
(@GUID3+106,@POOL+106,@CHANCE3, 'Icecrown Ore Spawnpoint 107 Titanium'),
(@GUID1+107,@POOL+107,@CHANCE1, 'Icecrown Ore Spawnpoint 108 Saronite'),
(@GUID2+107,@POOL+107,@CHANCE2, 'Icecrown Ore Spawnpoint 108 Rich Saronite'),
(@GUID3+107,@POOL+107,@CHANCE3, 'Icecrown Ore Spawnpoint 108 Titanium'),
(@GUID1+108,@POOL+108,@CHANCE1, 'Icecrown Ore Spawnpoint 109 Saronite'),
(@GUID2+108,@POOL+108,@CHANCE2, 'Icecrown Ore Spawnpoint 109 Rich Saronite'),
(@GUID3+108,@POOL+108,@CHANCE3, 'Icecrown Ore Spawnpoint 109 Titanium'),
(@GUID1+109,@POOL+109,@CHANCE1, 'Icecrown Ore Spawnpoint 110 Saronite'),
(@GUID2+109,@POOL+109,@CHANCE2, 'Icecrown Ore Spawnpoint 110 Rich Saronite'),
(@GUID3+109,@POOL+109,@CHANCE3, 'Icecrown Ore Spawnpoint 110 Titanium'),
(@GUID1+110,@POOL+110,@CHANCE1, 'Icecrown Ore Spawnpoint 111 Saronite'),
(@GUID2+110,@POOL+110,@CHANCE2, 'Icecrown Ore Spawnpoint 111 Rich Saronite'),
(@GUID3+110,@POOL+110,@CHANCE3, 'Icecrown Ore Spawnpoint 111 Titanium'),
(@GUID1+111,@POOL+111,@CHANCE1, 'Icecrown Ore Spawnpoint 112 Saronite'),
(@GUID2+111,@POOL+111,@CHANCE2, 'Icecrown Ore Spawnpoint 112 Rich Saronite'),
(@GUID3+111,@POOL+111,@CHANCE3, 'Icecrown Ore Spawnpoint 112 Titanium'),
(@GUID1+112,@POOL+112,@CHANCE1, 'Icecrown Ore Spawnpoint 113 Saronite'),
(@GUID2+112,@POOL+112,@CHANCE2, 'Icecrown Ore Spawnpoint 113 Rich Saronite'),
(@GUID3+112,@POOL+112,@CHANCE3, 'Icecrown Ore Spawnpoint 113 Titanium'),
(@GUID1+113,@POOL+113,@CHANCE1, 'Icecrown Ore Spawnpoint 114 Saronite'),
(@GUID2+113,@POOL+113,@CHANCE2, 'Icecrown Ore Spawnpoint 114 Rich Saronite'),
(@GUID3+113,@POOL+113,@CHANCE3, 'Icecrown Ore Spawnpoint 114 Titanium'),
(@GUID1+114,@POOL+114,@CHANCE1, 'Icecrown Ore Spawnpoint 115 Saronite'),
(@GUID2+114,@POOL+114,@CHANCE2, 'Icecrown Ore Spawnpoint 115 Rich Saronite'),
(@GUID3+114,@POOL+114,@CHANCE3, 'Icecrown Ore Spawnpoint 115 Titanium'),
(@GUID1+115,@POOL+115,@CHANCE1, 'Icecrown Ore Spawnpoint 116 Saronite'),
(@GUID2+115,@POOL+115,@CHANCE2, 'Icecrown Ore Spawnpoint 116 Rich Saronite'),
(@GUID3+115,@POOL+115,@CHANCE3, 'Icecrown Ore Spawnpoint 116 Titanium'),
(@GUID1+116,@POOL+116,@CHANCE1, 'Icecrown Ore Spawnpoint 117 Saronite'),
(@GUID2+116,@POOL+116,@CHANCE2, 'Icecrown Ore Spawnpoint 117 Rich Saronite'),
(@GUID3+116,@POOL+116,@CHANCE3, 'Icecrown Ore Spawnpoint 117 Titanium'),
(@GUID1+117,@POOL+117,@CHANCE1, 'Icecrown Ore Spawnpoint 118 Saronite'),
(@GUID2+117,@POOL+117,@CHANCE2, 'Icecrown Ore Spawnpoint 118 Rich Saronite'),
(@GUID3+117,@POOL+117,@CHANCE3, 'Icecrown Ore Spawnpoint 118 Titanium'),
(@GUID1+118,@POOL+118,@CHANCE1, 'Icecrown Ore Spawnpoint 119 Saronite'),
(@GUID2+118,@POOL+118,@CHANCE2, 'Icecrown Ore Spawnpoint 119 Rich Saronite'),
(@GUID3+118,@POOL+118,@CHANCE3, 'Icecrown Ore Spawnpoint 119 Titanium'),
(@GUID1+119,@POOL+119,@CHANCE1, 'Icecrown Ore Spawnpoint 120 Saronite'),
(@GUID2+119,@POOL+119,@CHANCE2, 'Icecrown Ore Spawnpoint 120 Rich Saronite'),
(@GUID3+119,@POOL+119,@CHANCE3, 'Icecrown Ore Spawnpoint 120 Titanium'),
(@GUID1+120,@POOL+120,@CHANCE1, 'Icecrown Ore Spawnpoint 121 Saronite'),
(@GUID2+120,@POOL+120,@CHANCE2, 'Icecrown Ore Spawnpoint 121 Rich Saronite'),
(@GUID3+120,@POOL+120,@CHANCE3, 'Icecrown Ore Spawnpoint 121 Titanium'),
(@GUID1+121,@POOL+121,@CHANCE1, 'Icecrown Ore Spawnpoint 122 Saronite'),
(@GUID2+121,@POOL+121,@CHANCE2, 'Icecrown Ore Spawnpoint 122 Rich Saronite'),
(@GUID3+121,@POOL+121,@CHANCE3, 'Icecrown Ore Spawnpoint 122 Titanium'),
(@GUID1+122,@POOL+122,@CHANCE1, 'Icecrown Ore Spawnpoint 123 Saronite'),
(@GUID2+122,@POOL+122,@CHANCE2, 'Icecrown Ore Spawnpoint 123 Rich Saronite'),
(@GUID3+122,@POOL+122,@CHANCE3, 'Icecrown Ore Spawnpoint 123 Titanium'),
(@GUID1+123,@POOL+123,@CHANCE1, 'Icecrown Ore Spawnpoint 124 Saronite'),
(@GUID2+123,@POOL+123,@CHANCE2, 'Icecrown Ore Spawnpoint 124 Rich Saronite'),
(@GUID3+123,@POOL+123,@CHANCE3, 'Icecrown Ore Spawnpoint 124 Titanium'),
(@GUID1+124,@POOL+124,@CHANCE1, 'Icecrown Ore Spawnpoint 125 Saronite'),
(@GUID2+124,@POOL+124,@CHANCE2, 'Icecrown Ore Spawnpoint 125 Rich Saronite'),
(@GUID3+124,@POOL+124,@CHANCE3, 'Icecrown Ore Spawnpoint 125 Titanium'),
(@GUID1+125,@POOL+125,@CHANCE1, 'Icecrown Ore Spawnpoint 126 Saronite'),
(@GUID2+125,@POOL+125,@CHANCE2, 'Icecrown Ore Spawnpoint 126 Rich Saronite'),
(@GUID3+125,@POOL+125,@CHANCE3, 'Icecrown Ore Spawnpoint 126 Titanium'),
(@GUID1+126,@POOL+126,@CHANCE1, 'Icecrown Ore Spawnpoint 127 Saronite'),
(@GUID2+126,@POOL+126,@CHANCE2, 'Icecrown Ore Spawnpoint 127 Rich Saronite'),
(@GUID3+126,@POOL+126,@CHANCE3, 'Icecrown Ore Spawnpoint 127 Titanium'),
(@GUID1+127,@POOL+127,@CHANCE1, 'Icecrown Ore Spawnpoint 128 Saronite'),
(@GUID2+127,@POOL+127,@CHANCE2, 'Icecrown Ore Spawnpoint 128 Rich Saronite'),
(@GUID3+127,@POOL+127,@CHANCE3, 'Icecrown Ore Spawnpoint 128 Titanium'),
(@GUID1+128,@POOL+128,@CHANCE1, 'Icecrown Ore Spawnpoint 129 Saronite'),
(@GUID2+128,@POOL+128,@CHANCE2, 'Icecrown Ore Spawnpoint 129 Rich Saronite'),
(@GUID3+128,@POOL+128,@CHANCE3, 'Icecrown Ore Spawnpoint 129 Titanium'),
(@GUID1+129,@POOL+129,@CHANCE1, 'Icecrown Ore Spawnpoint 130 Saronite'),
(@GUID2+129,@POOL+129,@CHANCE2, 'Icecrown Ore Spawnpoint 130 Rich Saronite'),
(@GUID3+129,@POOL+129,@CHANCE3, 'Icecrown Ore Spawnpoint 130 Titanium'),
(@GUID1+130,@POOL+130,@CHANCE1, 'Icecrown Ore Spawnpoint 131 Saronite'),
(@GUID2+130,@POOL+130,@CHANCE2, 'Icecrown Ore Spawnpoint 131 Rich Saronite'),
(@GUID3+130,@POOL+130,@CHANCE3, 'Icecrown Ore Spawnpoint 131 Titanium'),
(@GUID1+131,@POOL+131,@CHANCE1, 'Icecrown Ore Spawnpoint 132 Saronite'),
(@GUID2+131,@POOL+131,@CHANCE2, 'Icecrown Ore Spawnpoint 132 Rich Saronite'),
(@GUID3+131,@POOL+131,@CHANCE3, 'Icecrown Ore Spawnpoint 132 Titanium'),
(@GUID1+132,@POOL+132,@CHANCE1, 'Icecrown Ore Spawnpoint 133 Saronite'),
(@GUID2+132,@POOL+132,@CHANCE2, 'Icecrown Ore Spawnpoint 133 Rich Saronite'),
(@GUID3+132,@POOL+132,@CHANCE3, 'Icecrown Ore Spawnpoint 133 Titanium'),
(@GUID1+133,@POOL+133,@CHANCE1, 'Icecrown Ore Spawnpoint 134 Saronite'),
(@GUID2+133,@POOL+133,@CHANCE2, 'Icecrown Ore Spawnpoint 134 Rich Saronite'),
(@GUID3+133,@POOL+133,@CHANCE3, 'Icecrown Ore Spawnpoint 134 Titanium'),
(@GUID1+134,@POOL+134,@CHANCE1, 'Icecrown Ore Spawnpoint 135 Saronite'),
(@GUID2+134,@POOL+134,@CHANCE2, 'Icecrown Ore Spawnpoint 135 Rich Saronite'),
(@GUID3+134,@POOL+134,@CHANCE3, 'Icecrown Ore Spawnpoint 135 Titanium'),
(@GUID1+135,@POOL+135,@CHANCE1, 'Icecrown Ore Spawnpoint 136 Saronite'),
(@GUID2+135,@POOL+135,@CHANCE2, 'Icecrown Ore Spawnpoint 136 Rich Saronite'),
(@GUID3+135,@POOL+135,@CHANCE3, 'Icecrown Ore Spawnpoint 136 Titanium'),
(@GUID1+136,@POOL+136,@CHANCE1, 'Icecrown Ore Spawnpoint 137 Saronite'),
(@GUID2+136,@POOL+136,@CHANCE2, 'Icecrown Ore Spawnpoint 137 Rich Saronite'),
(@GUID3+136,@POOL+136,@CHANCE3, 'Icecrown Ore Spawnpoint 137 Titanium'),
(@GUID1+137,@POOL+137,@CHANCE1, 'Icecrown Ore Spawnpoint 138 Saronite'),
(@GUID2+137,@POOL+137,@CHANCE2, 'Icecrown Ore Spawnpoint 138 Rich Saronite'),
(@GUID3+137,@POOL+137,@CHANCE3, 'Icecrown Ore Spawnpoint 138 Titanium'),
(@GUID1+138,@POOL+138,@CHANCE1, 'Icecrown Ore Spawnpoint 139 Saronite'),
(@GUID2+138,@POOL+138,@CHANCE2, 'Icecrown Ore Spawnpoint 139 Rich Saronite'),
(@GUID3+138,@POOL+138,@CHANCE3, 'Icecrown Ore Spawnpoint 139 Titanium'),
(@GUID1+139,@POOL+139,@CHANCE1, 'Icecrown Ore Spawnpoint 140 Saronite'),
(@GUID2+139,@POOL+139,@CHANCE2, 'Icecrown Ore Spawnpoint 140 Rich Saronite'),
(@GUID3+139,@POOL+139,@CHANCE3, 'Icecrown Ore Spawnpoint 140 Titanium'),
(@GUID1+140,@POOL+140,@CHANCE1, 'Icecrown Ore Spawnpoint 141 Saronite'),
(@GUID2+140,@POOL+140,@CHANCE2, 'Icecrown Ore Spawnpoint 141 Rich Saronite'),
(@GUID3+140,@POOL+140,@CHANCE3, 'Icecrown Ore Spawnpoint 141 Titanium'),
(@GUID1+141,@POOL+141,@CHANCE1, 'Icecrown Ore Spawnpoint 142 Saronite'),
(@GUID2+141,@POOL+141,@CHANCE2, 'Icecrown Ore Spawnpoint 142 Rich Saronite'),
(@GUID3+141,@POOL+141,@CHANCE3, 'Icecrown Ore Spawnpoint 142 Titanium'),
(@GUID1+142,@POOL+142,@CHANCE1, 'Icecrown Ore Spawnpoint 143 Saronite'),
(@GUID2+142,@POOL+142,@CHANCE2, 'Icecrown Ore Spawnpoint 143 Rich Saronite'),
(@GUID3+142,@POOL+142,@CHANCE3, 'Icecrown Ore Spawnpoint 143 Titanium'),
(@GUID1+143,@POOL+143,@CHANCE1, 'Icecrown Ore Spawnpoint 144 Saronite'),
(@GUID2+143,@POOL+143,@CHANCE2, 'Icecrown Ore Spawnpoint 144 Rich Saronite'),
(@GUID3+143,@POOL+143,@CHANCE3, 'Icecrown Ore Spawnpoint 144 Titanium'),
(@GUID1+144,@POOL+144,@CHANCE1, 'Icecrown Ore Spawnpoint 145 Saronite'),
(@GUID2+144,@POOL+144,@CHANCE2, 'Icecrown Ore Spawnpoint 145 Rich Saronite'),
(@GUID3+144,@POOL+144,@CHANCE3, 'Icecrown Ore Spawnpoint 145 Titanium'),
(@GUID1+145,@POOL+145,@CHANCE1, 'Icecrown Ore Spawnpoint 146 Saronite'),
(@GUID2+145,@POOL+145,@CHANCE2, 'Icecrown Ore Spawnpoint 146 Rich Saronite'),
(@GUID3+145,@POOL+145,@CHANCE3, 'Icecrown Ore Spawnpoint 146 Titanium'),
(@GUID1+146,@POOL+146,@CHANCE1, 'Icecrown Ore Spawnpoint 147 Saronite'),
(@GUID2+146,@POOL+146,@CHANCE2, 'Icecrown Ore Spawnpoint 147 Rich Saronite'),
(@GUID3+146,@POOL+146,@CHANCE3, 'Icecrown Ore Spawnpoint 147 Titanium'),
(@GUID1+147,@POOL+147,@CHANCE1, 'Icecrown Ore Spawnpoint 148 Saronite'),
(@GUID2+147,@POOL+147,@CHANCE2, 'Icecrown Ore Spawnpoint 148 Rich Saronite'),
(@GUID3+147,@POOL+147,@CHANCE3, 'Icecrown Ore Spawnpoint 148 Titanium'),
(@GUID1+148,@POOL+148,@CHANCE1, 'Icecrown Ore Spawnpoint 149 Saronite'),
(@GUID2+148,@POOL+148,@CHANCE2, 'Icecrown Ore Spawnpoint 149 Rich Saronite'),
(@GUID3+148,@POOL+148,@CHANCE3, 'Icecrown Ore Spawnpoint 149 Titanium'),
(@GUID1+149,@POOL+149,@CHANCE1, 'Icecrown Ore Spawnpoint 150 Saronite'),
(@GUID2+149,@POOL+149,@CHANCE2, 'Icecrown Ore Spawnpoint 150 Rich Saronite'),
(@GUID3+149,@POOL+149,@CHANCE3, 'Icecrown Ore Spawnpoint 150 Titanium'),
(@GUID1+150,@POOL+150,@CHANCE1, 'Icecrown Ore Spawnpoint 151 Saronite'),
(@GUID2+150,@POOL+150,@CHANCE2, 'Icecrown Ore Spawnpoint 151 Rich Saronite'),
(@GUID3+150,@POOL+150,@CHANCE3, 'Icecrown Ore Spawnpoint 151 Titanium'),
(@GUID1+151,@POOL+151,@CHANCE1, 'Icecrown Ore Spawnpoint 152 Saronite'),
(@GUID2+151,@POOL+151,@CHANCE2, 'Icecrown Ore Spawnpoint 152 Rich Saronite'),
(@GUID3+151,@POOL+151,@CHANCE3, 'Icecrown Ore Spawnpoint 152 Titanium'),
(@GUID1+152,@POOL+152,@CHANCE1, 'Icecrown Ore Spawnpoint 153 Saronite'),
(@GUID2+152,@POOL+152,@CHANCE2, 'Icecrown Ore Spawnpoint 153 Rich Saronite'),
(@GUID3+152,@POOL+152,@CHANCE3, 'Icecrown Ore Spawnpoint 153 Titanium'),
(@GUID1+153,@POOL+153,@CHANCE1, 'Icecrown Ore Spawnpoint 154 Saronite'),
(@GUID2+153,@POOL+153,@CHANCE2, 'Icecrown Ore Spawnpoint 154 Rich Saronite'),
(@GUID3+153,@POOL+153,@CHANCE3, 'Icecrown Ore Spawnpoint 154 Titanium'),
(@GUID1+154,@POOL+154,@CHANCE1, 'Icecrown Ore Spawnpoint 155 Saronite'),
(@GUID2+154,@POOL+154,@CHANCE2, 'Icecrown Ore Spawnpoint 155 Rich Saronite'),
(@GUID3+154,@POOL+154,@CHANCE3, 'Icecrown Ore Spawnpoint 155 Titanium'),
(@GUID1+155,@POOL+155,@CHANCE1, 'Icecrown Ore Spawnpoint 156 Saronite'),
(@GUID2+155,@POOL+155,@CHANCE2, 'Icecrown Ore Spawnpoint 156 Rich Saronite'),
(@GUID3+155,@POOL+155,@CHANCE3, 'Icecrown Ore Spawnpoint 156 Titanium'),
(@GUID1+156,@POOL+156,@CHANCE1, 'Icecrown Ore Spawnpoint 157 Saronite'),
(@GUID2+156,@POOL+156,@CHANCE2, 'Icecrown Ore Spawnpoint 157 Rich Saronite'),
(@GUID3+156,@POOL+156,@CHANCE3, 'Icecrown Ore Spawnpoint 157 Titanium'),
(@GUID1+157,@POOL+157,@CHANCE1, 'Icecrown Ore Spawnpoint 158 Saronite'),
(@GUID2+157,@POOL+157,@CHANCE2, 'Icecrown Ore Spawnpoint 158 Rich Saronite'),
(@GUID3+157,@POOL+157,@CHANCE3, 'Icecrown Ore Spawnpoint 158 Titanium'),
(@GUID1+158,@POOL+158,@CHANCE1, 'Icecrown Ore Spawnpoint 159 Saronite'),
(@GUID2+158,@POOL+158,@CHANCE2, 'Icecrown Ore Spawnpoint 159 Rich Saronite'),
(@GUID3+158,@POOL+158,@CHANCE3, 'Icecrown Ore Spawnpoint 159 Titanium'),
(@GUID1+159,@POOL+159,@CHANCE1, 'Icecrown Ore Spawnpoint 160 Saronite'),
(@GUID2+159,@POOL+159,@CHANCE2, 'Icecrown Ore Spawnpoint 160 Rich Saronite'),
(@GUID3+159,@POOL+159,@CHANCE3, 'Icecrown Ore Spawnpoint 160 Titanium'),
(@GUID1+160,@POOL+160,@CHANCE1, 'Icecrown Ore Spawnpoint 161 Saronite'),
(@GUID2+160,@POOL+160,@CHANCE2, 'Icecrown Ore Spawnpoint 161 Rich Saronite'),
(@GUID3+160,@POOL+160,@CHANCE3, 'Icecrown Ore Spawnpoint 161 Titanium'),
(@GUID1+161,@POOL+161,@CHANCE1, 'Icecrown Ore Spawnpoint 162 Saronite'),
(@GUID2+161,@POOL+161,@CHANCE2, 'Icecrown Ore Spawnpoint 162 Rich Saronite'),
(@GUID3+161,@POOL+161,@CHANCE3, 'Icecrown Ore Spawnpoint 162 Titanium'),
(@GUID1+162,@POOL+162,@CHANCE1, 'Icecrown Ore Spawnpoint 163 Saronite'),
(@GUID2+162,@POOL+162,@CHANCE2, 'Icecrown Ore Spawnpoint 163 Rich Saronite'),
(@GUID3+162,@POOL+162,@CHANCE3, 'Icecrown Ore Spawnpoint 163 Titanium'),
(@GUID1+163,@POOL+163,@CHANCE1, 'Icecrown Ore Spawnpoint 164 Saronite'),
(@GUID2+163,@POOL+163,@CHANCE2, 'Icecrown Ore Spawnpoint 164 Rich Saronite'),
(@GUID3+163,@POOL+163,@CHANCE3, 'Icecrown Ore Spawnpoint 164 Titanium'),
(@GUID1+164,@POOL+164,@CHANCE1, 'Icecrown Ore Spawnpoint 165 Saronite'),
(@GUID2+164,@POOL+164,@CHANCE2, 'Icecrown Ore Spawnpoint 165 Rich Saronite'),
(@GUID3+164,@POOL+164,@CHANCE3, 'Icecrown Ore Spawnpoint 165 Titanium'),
(@GUID1+165,@POOL+165,@CHANCE1, 'Icecrown Ore Spawnpoint 166 Saronite'),
(@GUID2+165,@POOL+165,@CHANCE2, 'Icecrown Ore Spawnpoint 166 Rich Saronite'),
(@GUID3+165,@POOL+165,@CHANCE3, 'Icecrown Ore Spawnpoint 166 Titanium'),
(@GUID1+166,@POOL+166,@CHANCE1, 'Icecrown Ore Spawnpoint 167 Saronite'),
(@GUID2+166,@POOL+166,@CHANCE2, 'Icecrown Ore Spawnpoint 167 Rich Saronite'),
(@GUID3+166,@POOL+166,@CHANCE3, 'Icecrown Ore Spawnpoint 167 Titanium'),
(@GUID1+167,@POOL+167,@CHANCE1, 'Icecrown Ore Spawnpoint 168 Saronite'),
(@GUID2+167,@POOL+167,@CHANCE2, 'Icecrown Ore Spawnpoint 168 Rich Saronite'),
(@GUID3+167,@POOL+167,@CHANCE3, 'Icecrown Ore Spawnpoint 168 Titanium'),
(@GUID1+168,@POOL+168,@CHANCE1, 'Icecrown Ore Spawnpoint 169 Saronite'),
(@GUID2+168,@POOL+168,@CHANCE2, 'Icecrown Ore Spawnpoint 169 Rich Saronite'),
(@GUID3+168,@POOL+168,@CHANCE3, 'Icecrown Ore Spawnpoint 169 Titanium'),
(@GUID1+169,@POOL+169,@CHANCE1, 'Icecrown Ore Spawnpoint 170 Saronite'),
(@GUID2+169,@POOL+169,@CHANCE2, 'Icecrown Ore Spawnpoint 170 Rich Saronite'),
(@GUID3+169,@POOL+169,@CHANCE3, 'Icecrown Ore Spawnpoint 170 Titanium'),
(@GUID1+170,@POOL+170,@CHANCE1, 'Icecrown Ore Spawnpoint 171 Saronite'),
(@GUID2+170,@POOL+170,@CHANCE2, 'Icecrown Ore Spawnpoint 171 Rich Saronite'),
(@GUID3+170,@POOL+170,@CHANCE3, 'Icecrown Ore Spawnpoint 171 Titanium'),
(@GUID1+171,@POOL+171,@CHANCE1, 'Icecrown Ore Spawnpoint 172 Saronite'),
(@GUID2+171,@POOL+171,@CHANCE2, 'Icecrown Ore Spawnpoint 172 Rich Saronite'),
(@GUID3+171,@POOL+171,@CHANCE3, 'Icecrown Ore Spawnpoint 172 Titanium'),
(@GUID1+172,@POOL+172,@CHANCE1, 'Icecrown Ore Spawnpoint 173 Saronite'),
(@GUID2+172,@POOL+172,@CHANCE2, 'Icecrown Ore Spawnpoint 173 Rich Saronite'),
(@GUID3+172,@POOL+172,@CHANCE3, 'Icecrown Ore Spawnpoint 173 Titanium'),
(@GUID1+173,@POOL+173,@CHANCE1, 'Icecrown Ore Spawnpoint 174 Saronite'),
(@GUID2+173,@POOL+173,@CHANCE2, 'Icecrown Ore Spawnpoint 174 Rich Saronite'),
(@GUID3+173,@POOL+173,@CHANCE3, 'Icecrown Ore Spawnpoint 174 Titanium'),
(@GUID1+174,@POOL+174,@CHANCE1, 'Icecrown Ore Spawnpoint 175 Saronite'),
(@GUID2+174,@POOL+174,@CHANCE2, 'Icecrown Ore Spawnpoint 175 Rich Saronite'),
(@GUID3+174,@POOL+174,@CHANCE3, 'Icecrown Ore Spawnpoint 175 Titanium'),
(@GUID1+175,@POOL+175,@CHANCE1, 'Icecrown Ore Spawnpoint 176 Saronite'),
(@GUID2+175,@POOL+175,@CHANCE2, 'Icecrown Ore Spawnpoint 176 Rich Saronite'),
(@GUID3+175,@POOL+175,@CHANCE3, 'Icecrown Ore Spawnpoint 176 Titanium'),
(@GUID1+176,@POOL+176,@CHANCE1, 'Icecrown Ore Spawnpoint 177 Saronite'),
(@GUID2+176,@POOL+176,@CHANCE2, 'Icecrown Ore Spawnpoint 177 Rich Saronite'),
(@GUID3+176,@POOL+176,@CHANCE3, 'Icecrown Ore Spawnpoint 177 Titanium'),
(@GUID1+177,@POOL+177,@CHANCE1, 'Icecrown Ore Spawnpoint 178 Saronite'),
(@GUID2+177,@POOL+177,@CHANCE2, 'Icecrown Ore Spawnpoint 178 Rich Saronite'),
(@GUID3+177,@POOL+177,@CHANCE3, 'Icecrown Ore Spawnpoint 178 Titanium'),
(@GUID1+178,@POOL+178,@CHANCE1, 'Icecrown Ore Spawnpoint 179 Saronite'),
(@GUID2+178,@POOL+178,@CHANCE2, 'Icecrown Ore Spawnpoint 179 Rich Saronite'),
(@GUID3+178,@POOL+178,@CHANCE3, 'Icecrown Ore Spawnpoint 179 Titanium'),
(@GUID1+179,@POOL+179,@CHANCE1, 'Icecrown Ore Spawnpoint 180 Saronite'),
(@GUID2+179,@POOL+179,@CHANCE2, 'Icecrown Ore Spawnpoint 180 Rich Saronite'),
(@GUID3+179,@POOL+179,@CHANCE3, 'Icecrown Ore Spawnpoint 180 Titanium'),
(@GUID1+180,@POOL+180,@CHANCE1, 'Icecrown Ore Spawnpoint 181 Saronite'),
(@GUID2+180,@POOL+180,@CHANCE2, 'Icecrown Ore Spawnpoint 181 Rich Saronite'),
(@GUID3+180,@POOL+180,@CHANCE3, 'Icecrown Ore Spawnpoint 181 Titanium'),
(@GUID1+181,@POOL+181,@CHANCE1, 'Icecrown Ore Spawnpoint 182 Saronite'),
(@GUID2+181,@POOL+181,@CHANCE2, 'Icecrown Ore Spawnpoint 182 Rich Saronite'),
(@GUID3+181,@POOL+181,@CHANCE3, 'Icecrown Ore Spawnpoint 182 Titanium'),
(@GUID1+182,@POOL+182,@CHANCE1, 'Icecrown Ore Spawnpoint 183 Saronite'),
(@GUID2+182,@POOL+182,@CHANCE2, 'Icecrown Ore Spawnpoint 183 Rich Saronite'),
(@GUID3+182,@POOL+182,@CHANCE3, 'Icecrown Ore Spawnpoint 183 Titanium'),
(@GUID1+183,@POOL+183,@CHANCE1, 'Icecrown Ore Spawnpoint 184 Saronite'),
(@GUID2+183,@POOL+183,@CHANCE2, 'Icecrown Ore Spawnpoint 184 Rich Saronite'),
(@GUID3+183,@POOL+183,@CHANCE3, 'Icecrown Ore Spawnpoint 184 Titanium'),
(@GUID1+184,@POOL+184,@CHANCE1, 'Icecrown Ore Spawnpoint 185 Saronite'),
(@GUID2+184,@POOL+184,@CHANCE2, 'Icecrown Ore Spawnpoint 185 Rich Saronite'),
(@GUID3+184,@POOL+184,@CHANCE3, 'Icecrown Ore Spawnpoint 185 Titanium'),
(@GUID1+185,@POOL+185,@CHANCE1, 'Icecrown Ore Spawnpoint 186 Saronite'),
(@GUID2+185,@POOL+185,@CHANCE2, 'Icecrown Ore Spawnpoint 186 Rich Saronite'),
(@GUID3+185,@POOL+185,@CHANCE3, 'Icecrown Ore Spawnpoint 186 Titanium'),
(@GUID1+186,@POOL+186,@CHANCE1, 'Icecrown Ore Spawnpoint 187 Saronite'),
(@GUID2+186,@POOL+186,@CHANCE2, 'Icecrown Ore Spawnpoint 187 Rich Saronite'),
(@GUID3+186,@POOL+186,@CHANCE3, 'Icecrown Ore Spawnpoint 187 Titanium'),
(@GUID1+187,@POOL+187,@CHANCE1, 'Icecrown Ore Spawnpoint 188 Saronite'),
(@GUID2+187,@POOL+187,@CHANCE2, 'Icecrown Ore Spawnpoint 188 Rich Saronite'),
(@GUID3+187,@POOL+187,@CHANCE3, 'Icecrown Ore Spawnpoint 188 Titanium'),
(@GUID1+188,@POOL+188,@CHANCE1, 'Icecrown Ore Spawnpoint 189 Saronite'),
(@GUID2+188,@POOL+188,@CHANCE2, 'Icecrown Ore Spawnpoint 189 Rich Saronite'),
(@GUID3+188,@POOL+188,@CHANCE3, 'Icecrown Ore Spawnpoint 189 Titanium'),
(@GUID1+189,@POOL+189,@CHANCE1, 'Icecrown Ore Spawnpoint 190 Saronite'),
(@GUID2+189,@POOL+189,@CHANCE2, 'Icecrown Ore Spawnpoint 190 Rich Saronite'),
(@GUID3+189,@POOL+189,@CHANCE3, 'Icecrown Ore Spawnpoint 190 Titanium'),
(@GUID1+190,@POOL+190,@CHANCE1, 'Icecrown Ore Spawnpoint 191 Saronite'),
(@GUID2+190,@POOL+190,@CHANCE2, 'Icecrown Ore Spawnpoint 191 Rich Saronite'),
(@GUID3+190,@POOL+190,@CHANCE3, 'Icecrown Ore Spawnpoint 191 Titanium'),
(@GUID1+191,@POOL+191,@CHANCE1, 'Icecrown Ore Spawnpoint 192 Saronite'),
(@GUID2+191,@POOL+191,@CHANCE2, 'Icecrown Ore Spawnpoint 192 Rich Saronite'),
(@GUID3+191,@POOL+191,@CHANCE3, 'Icecrown Ore Spawnpoint 192 Titanium'),
(@GUID1+192,@POOL+192,@CHANCE1, 'Icecrown Ore Spawnpoint 193 Saronite'),
(@GUID2+192,@POOL+192,@CHANCE2, 'Icecrown Ore Spawnpoint 193 Rich Saronite'),
(@GUID3+192,@POOL+192,@CHANCE3, 'Icecrown Ore Spawnpoint 193 Titanium'),
(@GUID1+193,@POOL+193,@CHANCE1, 'Icecrown Ore Spawnpoint 194 Saronite'),
(@GUID2+193,@POOL+193,@CHANCE2, 'Icecrown Ore Spawnpoint 194 Rich Saronite'),
(@GUID3+193,@POOL+193,@CHANCE3, 'Icecrown Ore Spawnpoint 194 Titanium'),
(@GUID1+194,@POOL+194,@CHANCE1, 'Icecrown Ore Spawnpoint 195 Saronite'),
(@GUID2+194,@POOL+194,@CHANCE2, 'Icecrown Ore Spawnpoint 195 Rich Saronite'),
(@GUID3+194,@POOL+194,@CHANCE3, 'Icecrown Ore Spawnpoint 195 Titanium'),
(@GUID1+195,@POOL+195,@CHANCE1, 'Icecrown Ore Spawnpoint 196 Saronite'),
(@GUID2+195,@POOL+195,@CHANCE2, 'Icecrown Ore Spawnpoint 196 Rich Saronite'),
(@GUID3+195,@POOL+195,@CHANCE3, 'Icecrown Ore Spawnpoint 196 Titanium'),
(@GUID1+196,@POOL+196,@CHANCE1, 'Icecrown Ore Spawnpoint 197 Saronite'),
(@GUID2+196,@POOL+196,@CHANCE2, 'Icecrown Ore Spawnpoint 197 Rich Saronite'),
(@GUID3+196,@POOL+196,@CHANCE3, 'Icecrown Ore Spawnpoint 197 Titanium'),
(@GUID1+197,@POOL+197,@CHANCE1, 'Icecrown Ore Spawnpoint 198 Saronite'),
(@GUID2+197,@POOL+197,@CHANCE2, 'Icecrown Ore Spawnpoint 198 Rich Saronite'),
(@GUID3+197,@POOL+197,@CHANCE3, 'Icecrown Ore Spawnpoint 198 Titanium'),
(@GUID1+198,@POOL+198,@CHANCE1, 'Icecrown Ore Spawnpoint 199 Saronite'),
(@GUID2+198,@POOL+198,@CHANCE2, 'Icecrown Ore Spawnpoint 199 Rich Saronite'),
(@GUID3+198,@POOL+198,@CHANCE3, 'Icecrown Ore Spawnpoint 199 Titanium'),
(@GUID1+199,@POOL+199,@CHANCE1, 'Icecrown Ore Spawnpoint 200 Saronite'),
(@GUID2+199,@POOL+199,@CHANCE2, 'Icecrown Ore Spawnpoint 200 Rich Saronite'),
(@GUID3+199,@POOL+199,@CHANCE3, 'Icecrown Ore Spawnpoint 200 Titanium'),
(@GUID1+200,@POOL+200,@CHANCE1, 'Icecrown Ore Spawnpoint 201 Saronite'),
(@GUID2+200,@POOL+200,@CHANCE2, 'Icecrown Ore Spawnpoint 201 Rich Saronite'),
(@GUID3+200,@POOL+200,@CHANCE3, 'Icecrown Ore Spawnpoint 201 Titanium'),
(@GUID1+201,@POOL+201,@CHANCE1, 'Icecrown Ore Spawnpoint 202 Saronite'),
(@GUID2+201,@POOL+201,@CHANCE2, 'Icecrown Ore Spawnpoint 202 Rich Saronite'),
(@GUID3+201,@POOL+201,@CHANCE3, 'Icecrown Ore Spawnpoint 202 Titanium'),
(@GUID1+202,@POOL+202,@CHANCE1, 'Icecrown Ore Spawnpoint 203 Saronite'),
(@GUID2+202,@POOL+202,@CHANCE2, 'Icecrown Ore Spawnpoint 203 Rich Saronite'),
(@GUID3+202,@POOL+202,@CHANCE3, 'Icecrown Ore Spawnpoint 203 Titanium'),
(@GUID1+203,@POOL+203,@CHANCE1, 'Icecrown Ore Spawnpoint 204 Saronite'),
(@GUID2+203,@POOL+203,@CHANCE2, 'Icecrown Ore Spawnpoint 204 Rich Saronite'),
(@GUID3+203,@POOL+203,@CHANCE3, 'Icecrown Ore Spawnpoint 204 Titanium'),
(@GUID1+204,@POOL+204,@CHANCE1, 'Icecrown Ore Spawnpoint 205 Saronite'),
(@GUID2+204,@POOL+204,@CHANCE2, 'Icecrown Ore Spawnpoint 205 Rich Saronite'),
(@GUID3+204,@POOL+204,@CHANCE3, 'Icecrown Ore Spawnpoint 205 Titanium'),
(@GUID1+205,@POOL+205,@CHANCE1, 'Icecrown Ore Spawnpoint 206 Saronite'),
(@GUID2+205,@POOL+205,@CHANCE2, 'Icecrown Ore Spawnpoint 206 Rich Saronite'),
(@GUID3+205,@POOL+205,@CHANCE3, 'Icecrown Ore Spawnpoint 206 Titanium'),
(@GUID1+206,@POOL+206,@CHANCE1, 'Icecrown Ore Spawnpoint 207 Saronite'),
(@GUID2+206,@POOL+206,@CHANCE2, 'Icecrown Ore Spawnpoint 207 Rich Saronite'),
(@GUID3+206,@POOL+206,@CHANCE3, 'Icecrown Ore Spawnpoint 207 Titanium'),
(@GUID1+207,@POOL+207,@CHANCE1, 'Icecrown Ore Spawnpoint 208 Saronite'),
(@GUID2+207,@POOL+207,@CHANCE2, 'Icecrown Ore Spawnpoint 208 Rich Saronite'),
(@GUID3+207,@POOL+207,@CHANCE3, 'Icecrown Ore Spawnpoint 208 Titanium'),
(@GUID1+208,@POOL+208,@CHANCE1, 'Icecrown Ore Spawnpoint 209 Saronite'),
(@GUID2+208,@POOL+208,@CHANCE2, 'Icecrown Ore Spawnpoint 209 Rich Saronite'),
(@GUID3+208,@POOL+208,@CHANCE3, 'Icecrown Ore Spawnpoint 209 Titanium'),
(@GUID1+209,@POOL+209,@CHANCE1, 'Icecrown Ore Spawnpoint 210 Saronite'),
(@GUID2+209,@POOL+209,@CHANCE2, 'Icecrown Ore Spawnpoint 210 Rich Saronite'),
(@GUID3+209,@POOL+209,@CHANCE3, 'Icecrown Ore Spawnpoint 210 Titanium'),
(@GUID1+210,@POOL+210,@CHANCE1, 'Icecrown Ore Spawnpoint 211 Saronite'),
(@GUID2+210,@POOL+210,@CHANCE2, 'Icecrown Ore Spawnpoint 211 Rich Saronite'),
(@GUID3+210,@POOL+210,@CHANCE3, 'Icecrown Ore Spawnpoint 211 Titanium'),
(@GUID1+211,@POOL+211,@CHANCE1, 'Icecrown Ore Spawnpoint 212 Saronite'),
(@GUID2+211,@POOL+211,@CHANCE2, 'Icecrown Ore Spawnpoint 212 Rich Saronite'),
(@GUID3+211,@POOL+211,@CHANCE3, 'Icecrown Ore Spawnpoint 212 Titanium'),
(@GUID1+212,@POOL+212,@CHANCE1, 'Icecrown Ore Spawnpoint 213 Saronite'),
(@GUID2+212,@POOL+212,@CHANCE2, 'Icecrown Ore Spawnpoint 213 Rich Saronite'),
(@GUID3+212,@POOL+212,@CHANCE3, 'Icecrown Ore Spawnpoint 213 Titanium'),
(@GUID1+213,@POOL+213,@CHANCE1, 'Icecrown Ore Spawnpoint 214 Saronite'),
(@GUID2+213,@POOL+213,@CHANCE2, 'Icecrown Ore Spawnpoint 214 Rich Saronite'),
(@GUID3+213,@POOL+213,@CHANCE3, 'Icecrown Ore Spawnpoint 214 Titanium'),
(@GUID1+214,@POOL+214,@CHANCE1, 'Icecrown Ore Spawnpoint 215 Saronite'),
(@GUID2+214,@POOL+214,@CHANCE2, 'Icecrown Ore Spawnpoint 215 Rich Saronite'),
(@GUID3+214,@POOL+214,@CHANCE3, 'Icecrown Ore Spawnpoint 215 Titanium'),
(@GUID1+215,@POOL+215,@CHANCE1, 'Icecrown Ore Spawnpoint 216 Saronite'),
(@GUID2+215,@POOL+215,@CHANCE2, 'Icecrown Ore Spawnpoint 216 Rich Saronite'),
(@GUID3+215,@POOL+215,@CHANCE3, 'Icecrown Ore Spawnpoint 216 Titanium'),
(@GUID1+216,@POOL+216,@CHANCE1, 'Icecrown Ore Spawnpoint 217 Saronite'),
(@GUID2+216,@POOL+216,@CHANCE2, 'Icecrown Ore Spawnpoint 217 Rich Saronite'),
(@GUID3+216,@POOL+216,@CHANCE3, 'Icecrown Ore Spawnpoint 217 Titanium'),
(@GUID1+217,@POOL+217,@CHANCE1, 'Icecrown Ore Spawnpoint 218 Saronite'),
(@GUID2+217,@POOL+217,@CHANCE2, 'Icecrown Ore Spawnpoint 218 Rich Saronite'),
(@GUID3+217,@POOL+217,@CHANCE3, 'Icecrown Ore Spawnpoint 218 Titanium'),
(@GUID1+218,@POOL+218,@CHANCE1, 'Icecrown Ore Spawnpoint 219 Saronite'),
(@GUID2+218,@POOL+218,@CHANCE2, 'Icecrown Ore Spawnpoint 219 Rich Saronite'),
(@GUID3+218,@POOL+218,@CHANCE3, 'Icecrown Ore Spawnpoint 219 Titanium'),
(@GUID1+219,@POOL+219,@CHANCE1, 'Icecrown Ore Spawnpoint 220 Saronite'),
(@GUID2+219,@POOL+219,@CHANCE2, 'Icecrown Ore Spawnpoint 220 Rich Saronite'),
(@GUID3+219,@POOL+219,@CHANCE3, 'Icecrown Ore Spawnpoint 220 Titanium'),
(@GUID1+220,@POOL+220,@CHANCE1, 'Icecrown Ore Spawnpoint 221 Saronite'),
(@GUID2+220,@POOL+220,@CHANCE2, 'Icecrown Ore Spawnpoint 221 Rich Saronite'),
(@GUID3+220,@POOL+220,@CHANCE3, 'Icecrown Ore Spawnpoint 221 Titanium'),
(@GUID1+221,@POOL+221,@CHANCE1, 'Icecrown Ore Spawnpoint 222 Saronite'),
(@GUID2+221,@POOL+221,@CHANCE2, 'Icecrown Ore Spawnpoint 222 Rich Saronite'),
(@GUID3+221,@POOL+221,@CHANCE3, 'Icecrown Ore Spawnpoint 222 Titanium'),
(@GUID1+222,@POOL+222,@CHANCE1, 'Icecrown Ore Spawnpoint 223 Saronite'),
(@GUID2+222,@POOL+222,@CHANCE2, 'Icecrown Ore Spawnpoint 223 Rich Saronite'),
(@GUID3+222,@POOL+222,@CHANCE3, 'Icecrown Ore Spawnpoint 223 Titanium'),
(@GUID1+223,@POOL+223,@CHANCE1, 'Icecrown Ore Spawnpoint 224 Saronite'),
(@GUID2+223,@POOL+223,@CHANCE2, 'Icecrown Ore Spawnpoint 224 Rich Saronite'),
(@GUID3+223,@POOL+223,@CHANCE3, 'Icecrown Ore Spawnpoint 224 Titanium'),
(@GUID1+224,@POOL+224,@CHANCE1, 'Icecrown Ore Spawnpoint 225 Saronite'),
(@GUID2+224,@POOL+224,@CHANCE2, 'Icecrown Ore Spawnpoint 225 Rich Saronite'),
(@GUID3+224,@POOL+224,@CHANCE3, 'Icecrown Ore Spawnpoint 225 Titanium'),
(@GUID1+225,@POOL+225,@CHANCE1, 'Icecrown Ore Spawnpoint 226 Saronite'),
(@GUID2+225,@POOL+225,@CHANCE2, 'Icecrown Ore Spawnpoint 226 Rich Saronite'),
(@GUID3+225,@POOL+225,@CHANCE3, 'Icecrown Ore Spawnpoint 226 Titanium'),
(@GUID1+226,@POOL+226,@CHANCE1, 'Icecrown Ore Spawnpoint 227 Saronite'),
(@GUID2+226,@POOL+226,@CHANCE2, 'Icecrown Ore Spawnpoint 227 Rich Saronite'),
(@GUID3+226,@POOL+226,@CHANCE3, 'Icecrown Ore Spawnpoint 227 Titanium'),
(@GUID1+227,@POOL+227,@CHANCE1, 'Icecrown Ore Spawnpoint 228 Saronite'),
(@GUID2+227,@POOL+227,@CHANCE2, 'Icecrown Ore Spawnpoint 228 Rich Saronite'),
(@GUID3+227,@POOL+227,@CHANCE3, 'Icecrown Ore Spawnpoint 228 Titanium'),
(@GUID1+228,@POOL+228,@CHANCE1, 'Icecrown Ore Spawnpoint 229 Saronite'),
(@GUID2+228,@POOL+228,@CHANCE2, 'Icecrown Ore Spawnpoint 229 Rich Saronite'),
(@GUID3+228,@POOL+228,@CHANCE3, 'Icecrown Ore Spawnpoint 229 Titanium'),
(@GUID1+229,@POOL+229,@CHANCE1, 'Icecrown Ore Spawnpoint 230 Saronite'),
(@GUID2+229,@POOL+229,@CHANCE2, 'Icecrown Ore Spawnpoint 230 Rich Saronite'),
(@GUID3+229,@POOL+229,@CHANCE3, 'Icecrown Ore Spawnpoint 230 Titanium'),
(@GUID1+230,@POOL+230,@CHANCE1, 'Icecrown Ore Spawnpoint 231 Saronite'),
(@GUID2+230,@POOL+230,@CHANCE2, 'Icecrown Ore Spawnpoint 231 Rich Saronite'),
(@GUID3+230,@POOL+230,@CHANCE3, 'Icecrown Ore Spawnpoint 231 Titanium'),
(@GUID1+231,@POOL+231,@CHANCE1, 'Icecrown Ore Spawnpoint 232 Saronite'),
(@GUID2+231,@POOL+231,@CHANCE2, 'Icecrown Ore Spawnpoint 232 Rich Saronite'),
(@GUID3+231,@POOL+231,@CHANCE3, 'Icecrown Ore Spawnpoint 232 Titanium'),
(@GUID1+232,@POOL+232,@CHANCE1, 'Icecrown Ore Spawnpoint 233 Saronite'),
(@GUID2+232,@POOL+232,@CHANCE2, 'Icecrown Ore Spawnpoint 233 Rich Saronite'),
(@GUID3+232,@POOL+232,@CHANCE3, 'Icecrown Ore Spawnpoint 233 Titanium'),
(@GUID1+233,@POOL+233,@CHANCE1, 'Icecrown Ore Spawnpoint 234 Saronite'),
(@GUID2+233,@POOL+233,@CHANCE2, 'Icecrown Ore Spawnpoint 234 Rich Saronite'),
(@GUID3+233,@POOL+233,@CHANCE3, 'Icecrown Ore Spawnpoint 234 Titanium'),
(@GUID1+234,@POOL+234,@CHANCE1, 'Icecrown Ore Spawnpoint 235 Saronite'),
(@GUID2+234,@POOL+234,@CHANCE2, 'Icecrown Ore Spawnpoint 235 Rich Saronite'),
(@GUID3+234,@POOL+234,@CHANCE3, 'Icecrown Ore Spawnpoint 235 Titanium');
-- Add each pool to pool template
DELETE FROM `pool_template` WHERE `entry` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@POOL+0,1, 'Icecrown Ore Spawnpoint 1'),
(@POOL+1,1, 'Icecrown Ore Spawnpoint 2'),
(@POOL+2,1, 'Icecrown Ore Spawnpoint 3'),
(@POOL+3,1, 'Icecrown Ore Spawnpoint 4'),
(@POOL+4,1, 'Icecrown Ore Spawnpoint 5'),
(@POOL+5,1, 'Icecrown Ore Spawnpoint 6'),
(@POOL+6,1, 'Icecrown Ore Spawnpoint 7'),
(@POOL+7,1, 'Icecrown Ore Spawnpoint 8'),
(@POOL+8,1, 'Icecrown Ore Spawnpoint 9'),
(@POOL+9,1, 'Icecrown Ore Spawnpoint 10'),
(@POOL+10,1, 'Icecrown Ore Spawnpoint 11'),
(@POOL+11,1, 'Icecrown Ore Spawnpoint 12'),
(@POOL+12,1, 'Icecrown Ore Spawnpoint 13'),
(@POOL+13,1, 'Icecrown Ore Spawnpoint 14'),
(@POOL+14,1, 'Icecrown Ore Spawnpoint 15'),
(@POOL+15,1, 'Icecrown Ore Spawnpoint 16'),
(@POOL+16,1, 'Icecrown Ore Spawnpoint 17'),
(@POOL+17,1, 'Icecrown Ore Spawnpoint 18'),
(@POOL+18,1, 'Icecrown Ore Spawnpoint 19'),
(@POOL+19,1, 'Icecrown Ore Spawnpoint 20'),
(@POOL+20,1, 'Icecrown Ore Spawnpoint 21'),
(@POOL+21,1, 'Icecrown Ore Spawnpoint 22'),
(@POOL+22,1, 'Icecrown Ore Spawnpoint 23'),
(@POOL+23,1, 'Icecrown Ore Spawnpoint 24'),
(@POOL+24,1, 'Icecrown Ore Spawnpoint 25'),
(@POOL+25,1, 'Icecrown Ore Spawnpoint 26'),
(@POOL+26,1, 'Icecrown Ore Spawnpoint 27'),
(@POOL+27,1, 'Icecrown Ore Spawnpoint 28'),
(@POOL+28,1, 'Icecrown Ore Spawnpoint 29'),
(@POOL+29,1, 'Icecrown Ore Spawnpoint 30'),
(@POOL+30,1, 'Icecrown Ore Spawnpoint 31'),
(@POOL+31,1, 'Icecrown Ore Spawnpoint 32'),
(@POOL+32,1, 'Icecrown Ore Spawnpoint 33'),
(@POOL+33,1, 'Icecrown Ore Spawnpoint 34'),
(@POOL+34,1, 'Icecrown Ore Spawnpoint 35'),
(@POOL+35,1, 'Icecrown Ore Spawnpoint 36'),
(@POOL+36,1, 'Icecrown Ore Spawnpoint 37'),
(@POOL+37,1, 'Icecrown Ore Spawnpoint 38'),
(@POOL+38,1, 'Icecrown Ore Spawnpoint 39'),
(@POOL+39,1, 'Icecrown Ore Spawnpoint 40'),
(@POOL+40,1, 'Icecrown Ore Spawnpoint 41'),
(@POOL+41,1, 'Icecrown Ore Spawnpoint 42'),
(@POOL+42,1, 'Icecrown Ore Spawnpoint 43'),
(@POOL+43,1, 'Icecrown Ore Spawnpoint 44'),
(@POOL+44,1, 'Icecrown Ore Spawnpoint 45'),
(@POOL+45,1, 'Icecrown Ore Spawnpoint 46'),
(@POOL+46,1, 'Icecrown Ore Spawnpoint 47'),
(@POOL+47,1, 'Icecrown Ore Spawnpoint 48'),
(@POOL+48,1, 'Icecrown Ore Spawnpoint 49'),
(@POOL+49,1, 'Icecrown Ore Spawnpoint 50'),
(@POOL+50,1, 'Icecrown Ore Spawnpoint 51'),
(@POOL+51,1, 'Icecrown Ore Spawnpoint 52'),
(@POOL+52,1, 'Icecrown Ore Spawnpoint 53'),
(@POOL+53,1, 'Icecrown Ore Spawnpoint 54'),
(@POOL+54,1, 'Icecrown Ore Spawnpoint 55'),
(@POOL+55,1, 'Icecrown Ore Spawnpoint 56'),
(@POOL+56,1, 'Icecrown Ore Spawnpoint 57'),
(@POOL+57,1, 'Icecrown Ore Spawnpoint 58'),
(@POOL+58,1, 'Icecrown Ore Spawnpoint 59'),
(@POOL+59,1, 'Icecrown Ore Spawnpoint 60'),
(@POOL+60,1, 'Icecrown Ore Spawnpoint 61'),
(@POOL+61,1, 'Icecrown Ore Spawnpoint 62'),
(@POOL+62,1, 'Icecrown Ore Spawnpoint 63'),
(@POOL+63,1, 'Icecrown Ore Spawnpoint 64'),
(@POOL+64,1, 'Icecrown Ore Spawnpoint 65'),
(@POOL+65,1, 'Icecrown Ore Spawnpoint 66'),
(@POOL+66,1, 'Icecrown Ore Spawnpoint 67'),
(@POOL+67,1, 'Icecrown Ore Spawnpoint 68'),
(@POOL+68,1, 'Icecrown Ore Spawnpoint 69'),
(@POOL+69,1, 'Icecrown Ore Spawnpoint 70'),
(@POOL+70,1, 'Icecrown Ore Spawnpoint 71'),
(@POOL+71,1, 'Icecrown Ore Spawnpoint 72'),
(@POOL+72,1, 'Icecrown Ore Spawnpoint 73'),
(@POOL+73,1, 'Icecrown Ore Spawnpoint 74'),
(@POOL+74,1, 'Icecrown Ore Spawnpoint 75'),
(@POOL+75,1, 'Icecrown Ore Spawnpoint 76'),
(@POOL+76,1, 'Icecrown Ore Spawnpoint 77'),
(@POOL+77,1, 'Icecrown Ore Spawnpoint 78'),
(@POOL+78,1, 'Icecrown Ore Spawnpoint 79'),
(@POOL+79,1, 'Icecrown Ore Spawnpoint 80'),
(@POOL+80,1, 'Icecrown Ore Spawnpoint 81'),
(@POOL+81,1, 'Icecrown Ore Spawnpoint 82'),
(@POOL+82,1, 'Icecrown Ore Spawnpoint 83'),
(@POOL+83,1, 'Icecrown Ore Spawnpoint 84'),
(@POOL+84,1, 'Icecrown Ore Spawnpoint 85'),
(@POOL+85,1, 'Icecrown Ore Spawnpoint 86'),
(@POOL+86,1, 'Icecrown Ore Spawnpoint 87'),
(@POOL+87,1, 'Icecrown Ore Spawnpoint 88'),
(@POOL+88,1, 'Icecrown Ore Spawnpoint 89'),
(@POOL+89,1, 'Icecrown Ore Spawnpoint 90'),
(@POOL+90,1, 'Icecrown Ore Spawnpoint 91'),
(@POOL+91,1, 'Icecrown Ore Spawnpoint 92'),
(@POOL+92,1, 'Icecrown Ore Spawnpoint 93'),
(@POOL+93,1, 'Icecrown Ore Spawnpoint 94'),
(@POOL+94,1, 'Icecrown Ore Spawnpoint 95'),
(@POOL+95,1, 'Icecrown Ore Spawnpoint 96'),
(@POOL+96,1, 'Icecrown Ore Spawnpoint 97'),
(@POOL+97,1, 'Icecrown Ore Spawnpoint 98'),
(@POOL+98,1, 'Icecrown Ore Spawnpoint 99'),
(@POOL+99,1, 'Icecrown Ore Spawnpoint 100'),
(@POOL+100,1, 'Icecrown Ore Spawnpoint 101'),
(@POOL+101,1, 'Icecrown Ore Spawnpoint 102'),
(@POOL+102,1, 'Icecrown Ore Spawnpoint 103'),
(@POOL+103,1, 'Icecrown Ore Spawnpoint 104'),
(@POOL+104,1, 'Icecrown Ore Spawnpoint 105'),
(@POOL+105,1, 'Icecrown Ore Spawnpoint 106'),
(@POOL+106,1, 'Icecrown Ore Spawnpoint 107'),
(@POOL+107,1, 'Icecrown Ore Spawnpoint 108'),
(@POOL+108,1, 'Icecrown Ore Spawnpoint 109'),
(@POOL+109,1, 'Icecrown Ore Spawnpoint 110'),
(@POOL+110,1, 'Icecrown Ore Spawnpoint 111'),
(@POOL+111,1, 'Icecrown Ore Spawnpoint 112'),
(@POOL+112,1, 'Icecrown Ore Spawnpoint 113'),
(@POOL+113,1, 'Icecrown Ore Spawnpoint 114'),
(@POOL+114,1, 'Icecrown Ore Spawnpoint 115'),
(@POOL+115,1, 'Icecrown Ore Spawnpoint 116'),
(@POOL+116,1, 'Icecrown Ore Spawnpoint 117'),
(@POOL+117,1, 'Icecrown Ore Spawnpoint 118'),
(@POOL+118,1, 'Icecrown Ore Spawnpoint 119'),
(@POOL+119,1, 'Icecrown Ore Spawnpoint 120'),
(@POOL+120,1, 'Icecrown Ore Spawnpoint 121'),
(@POOL+121,1, 'Icecrown Ore Spawnpoint 122'),
(@POOL+122,1, 'Icecrown Ore Spawnpoint 123'),
(@POOL+123,1, 'Icecrown Ore Spawnpoint 124'),
(@POOL+124,1, 'Icecrown Ore Spawnpoint 125'),
(@POOL+125,1, 'Icecrown Ore Spawnpoint 126'),
(@POOL+126,1, 'Icecrown Ore Spawnpoint 127'),
(@POOL+127,1, 'Icecrown Ore Spawnpoint 128'),
(@POOL+128,1, 'Icecrown Ore Spawnpoint 129'),
(@POOL+129,1, 'Icecrown Ore Spawnpoint 130'),
(@POOL+130,1, 'Icecrown Ore Spawnpoint 131'),
(@POOL+131,1, 'Icecrown Ore Spawnpoint 132'),
(@POOL+132,1, 'Icecrown Ore Spawnpoint 133'),
(@POOL+133,1, 'Icecrown Ore Spawnpoint 134'),
(@POOL+134,1, 'Icecrown Ore Spawnpoint 135'),
(@POOL+135,1, 'Icecrown Ore Spawnpoint 136'),
(@POOL+136,1, 'Icecrown Ore Spawnpoint 137'),
(@POOL+137,1, 'Icecrown Ore Spawnpoint 138'),
(@POOL+138,1, 'Icecrown Ore Spawnpoint 139'),
(@POOL+139,1, 'Icecrown Ore Spawnpoint 140'),
(@POOL+140,1, 'Icecrown Ore Spawnpoint 141'),
(@POOL+141,1, 'Icecrown Ore Spawnpoint 142'),
(@POOL+142,1, 'Icecrown Ore Spawnpoint 143'),
(@POOL+143,1, 'Icecrown Ore Spawnpoint 144'),
(@POOL+144,1, 'Icecrown Ore Spawnpoint 145'),
(@POOL+145,1, 'Icecrown Ore Spawnpoint 146'),
(@POOL+146,1, 'Icecrown Ore Spawnpoint 147'),
(@POOL+147,1, 'Icecrown Ore Spawnpoint 148'),
(@POOL+148,1, 'Icecrown Ore Spawnpoint 149'),
(@POOL+149,1, 'Icecrown Ore Spawnpoint 150'),
(@POOL+150,1, 'Icecrown Ore Spawnpoint 151'),
(@POOL+151,1, 'Icecrown Ore Spawnpoint 152'),
(@POOL+152,1, 'Icecrown Ore Spawnpoint 153'),
(@POOL+153,1, 'Icecrown Ore Spawnpoint 154'),
(@POOL+154,1, 'Icecrown Ore Spawnpoint 155'),
(@POOL+155,1, 'Icecrown Ore Spawnpoint 156'),
(@POOL+156,1, 'Icecrown Ore Spawnpoint 157'),
(@POOL+157,1, 'Icecrown Ore Spawnpoint 158'),
(@POOL+158,1, 'Icecrown Ore Spawnpoint 159'),
(@POOL+159,1, 'Icecrown Ore Spawnpoint 160'),
(@POOL+160,1, 'Icecrown Ore Spawnpoint 161'),
(@POOL+161,1, 'Icecrown Ore Spawnpoint 162'),
(@POOL+162,1, 'Icecrown Ore Spawnpoint 163'),
(@POOL+163,1, 'Icecrown Ore Spawnpoint 164'),
(@POOL+164,1, 'Icecrown Ore Spawnpoint 165'),
(@POOL+165,1, 'Icecrown Ore Spawnpoint 166'),
(@POOL+166,1, 'Icecrown Ore Spawnpoint 167'),
(@POOL+167,1, 'Icecrown Ore Spawnpoint 168'),
(@POOL+168,1, 'Icecrown Ore Spawnpoint 169'),
(@POOL+169,1, 'Icecrown Ore Spawnpoint 170'),
(@POOL+170,1, 'Icecrown Ore Spawnpoint 171'),
(@POOL+171,1, 'Icecrown Ore Spawnpoint 172'),
(@POOL+172,1, 'Icecrown Ore Spawnpoint 173'),
(@POOL+173,1, 'Icecrown Ore Spawnpoint 174'),
(@POOL+174,1, 'Icecrown Ore Spawnpoint 175'),
(@POOL+175,1, 'Icecrown Ore Spawnpoint 176'),
(@POOL+176,1, 'Icecrown Ore Spawnpoint 177'),
(@POOL+177,1, 'Icecrown Ore Spawnpoint 178'),
(@POOL+178,1, 'Icecrown Ore Spawnpoint 179'),
(@POOL+179,1, 'Icecrown Ore Spawnpoint 180'),
(@POOL+180,1, 'Icecrown Ore Spawnpoint 181'),
(@POOL+181,1, 'Icecrown Ore Spawnpoint 182'),
(@POOL+182,1, 'Icecrown Ore Spawnpoint 183'),
(@POOL+183,1, 'Icecrown Ore Spawnpoint 184'),
(@POOL+184,1, 'Icecrown Ore Spawnpoint 185'),
(@POOL+185,1, 'Icecrown Ore Spawnpoint 186'),
(@POOL+186,1, 'Icecrown Ore Spawnpoint 187'),
(@POOL+187,1, 'Icecrown Ore Spawnpoint 188'),
(@POOL+188,1, 'Icecrown Ore Spawnpoint 189'),
(@POOL+189,1, 'Icecrown Ore Spawnpoint 190'),
(@POOL+190,1, 'Icecrown Ore Spawnpoint 191'),
(@POOL+191,1, 'Icecrown Ore Spawnpoint 192'),
(@POOL+192,1, 'Icecrown Ore Spawnpoint 193'),
(@POOL+193,1, 'Icecrown Ore Spawnpoint 194'),
(@POOL+194,1, 'Icecrown Ore Spawnpoint 195'),
(@POOL+195,1, 'Icecrown Ore Spawnpoint 196'),
(@POOL+196,1, 'Icecrown Ore Spawnpoint 197'),
(@POOL+197,1, 'Icecrown Ore Spawnpoint 198'),
(@POOL+198,1, 'Icecrown Ore Spawnpoint 199'),
(@POOL+199,1, 'Icecrown Ore Spawnpoint 200'),
(@POOL+200,1, 'Icecrown Ore Spawnpoint 201'),
(@POOL+201,1, 'Icecrown Ore Spawnpoint 202'),
(@POOL+202,1, 'Icecrown Ore Spawnpoint 203'),
(@POOL+203,1, 'Icecrown Ore Spawnpoint 204'),
(@POOL+204,1, 'Icecrown Ore Spawnpoint 205'),
(@POOL+205,1, 'Icecrown Ore Spawnpoint 206'),
(@POOL+206,1, 'Icecrown Ore Spawnpoint 207'),
(@POOL+207,1, 'Icecrown Ore Spawnpoint 208'),
(@POOL+208,1, 'Icecrown Ore Spawnpoint 209'),
(@POOL+209,1, 'Icecrown Ore Spawnpoint 210'),
(@POOL+210,1, 'Icecrown Ore Spawnpoint 211'),
(@POOL+211,1, 'Icecrown Ore Spawnpoint 212'),
(@POOL+212,1, 'Icecrown Ore Spawnpoint 213'),
(@POOL+213,1, 'Icecrown Ore Spawnpoint 214'),
(@POOL+214,1, 'Icecrown Ore Spawnpoint 215'),
(@POOL+215,1, 'Icecrown Ore Spawnpoint 216'),
(@POOL+216,1, 'Icecrown Ore Spawnpoint 217'),
(@POOL+217,1, 'Icecrown Ore Spawnpoint 218'),
(@POOL+218,1, 'Icecrown Ore Spawnpoint 219'),
(@POOL+219,1, 'Icecrown Ore Spawnpoint 220'),
(@POOL+220,1, 'Icecrown Ore Spawnpoint 221'),
(@POOL+221,1, 'Icecrown Ore Spawnpoint 222'),
(@POOL+222,1, 'Icecrown Ore Spawnpoint 223'),
(@POOL+223,1, 'Icecrown Ore Spawnpoint 224'),
(@POOL+224,1, 'Icecrown Ore Spawnpoint 225'),
(@POOL+225,1, 'Icecrown Ore Spawnpoint 226'),
(@POOL+226,1, 'Icecrown Ore Spawnpoint 227'),
(@POOL+227,1, 'Icecrown Ore Spawnpoint 228'),
(@POOL+228,1, 'Icecrown Ore Spawnpoint 229'),
(@POOL+229,1, 'Icecrown Ore Spawnpoint 230'),
(@POOL+230,1, 'Icecrown Ore Spawnpoint 231'),
(@POOL+231,1, 'Icecrown Ore Spawnpoint 232'),
(@POOL+232,1, 'Icecrown Ore Spawnpoint 233'),
(@POOL+233,1, 'Icecrown Ore Spawnpoint 234'),
(@POOL+234,1, 'Icecrown Ore Spawnpoint 235');
-- Add mother pool to pool template
DELETE FROM `pool_template` WHERE `entry`=@MOTHER;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@MOTHER,@ACTIVE, 'Icecrown Ore Mother pool');
-- Add each pool to pool_pool
DELETE FROM `pool_pool` WHERE `pool_id` BETWEEN @POOL AND @POOL+@LASTGUID;
INSERT INTO `pool_pool` (`pool_id`,`mother_pool`,`chance`,`description`) VALUES
(@POOL+0,@MOTHER,0, 'Icecrown Ore Spawnpoint 1'),
(@POOL+1,@MOTHER,0, 'Icecrown Ore Spawnpoint 2'),
(@POOL+2,@MOTHER,0, 'Icecrown Ore Spawnpoint 3'),
(@POOL+3,@MOTHER,0, 'Icecrown Ore Spawnpoint 4'),
(@POOL+4,@MOTHER,0, 'Icecrown Ore Spawnpoint 5'),
(@POOL+5,@MOTHER,0, 'Icecrown Ore Spawnpoint 6'),
(@POOL+6,@MOTHER,0, 'Icecrown Ore Spawnpoint 7'),
(@POOL+7,@MOTHER,0, 'Icecrown Ore Spawnpoint 8'),
(@POOL+8,@MOTHER,0, 'Icecrown Ore Spawnpoint 9'),
(@POOL+9,@MOTHER,0, 'Icecrown Ore Spawnpoint 10'),
(@POOL+10,@MOTHER,0, 'Icecrown Ore Spawnpoint 11'),
(@POOL+11,@MOTHER,0, 'Icecrown Ore Spawnpoint 12'),
(@POOL+12,@MOTHER,0, 'Icecrown Ore Spawnpoint 13'),
(@POOL+13,@MOTHER,0, 'Icecrown Ore Spawnpoint 14'),
(@POOL+14,@MOTHER,0, 'Icecrown Ore Spawnpoint 15'),
(@POOL+15,@MOTHER,0, 'Icecrown Ore Spawnpoint 16'),
(@POOL+16,@MOTHER,0, 'Icecrown Ore Spawnpoint 17'),
(@POOL+17,@MOTHER,0, 'Icecrown Ore Spawnpoint 18'),
(@POOL+18,@MOTHER,0, 'Icecrown Ore Spawnpoint 19'),
(@POOL+19,@MOTHER,0, 'Icecrown Ore Spawnpoint 20'),
(@POOL+20,@MOTHER,0, 'Icecrown Ore Spawnpoint 21'),
(@POOL+21,@MOTHER,0, 'Icecrown Ore Spawnpoint 22'),
(@POOL+22,@MOTHER,0, 'Icecrown Ore Spawnpoint 23'),
(@POOL+23,@MOTHER,0, 'Icecrown Ore Spawnpoint 24'),
(@POOL+24,@MOTHER,0, 'Icecrown Ore Spawnpoint 25'),
(@POOL+25,@MOTHER,0, 'Icecrown Ore Spawnpoint 26'),
(@POOL+26,@MOTHER,0, 'Icecrown Ore Spawnpoint 27'),
(@POOL+27,@MOTHER,0, 'Icecrown Ore Spawnpoint 28'),
(@POOL+28,@MOTHER,0, 'Icecrown Ore Spawnpoint 29'),
(@POOL+29,@MOTHER,0, 'Icecrown Ore Spawnpoint 30'),
(@POOL+30,@MOTHER,0, 'Icecrown Ore Spawnpoint 31'),
(@POOL+31,@MOTHER,0, 'Icecrown Ore Spawnpoint 32'),
(@POOL+32,@MOTHER,0, 'Icecrown Ore Spawnpoint 33'),
(@POOL+33,@MOTHER,0, 'Icecrown Ore Spawnpoint 34'),
(@POOL+34,@MOTHER,0, 'Icecrown Ore Spawnpoint 35'),
(@POOL+35,@MOTHER,0, 'Icecrown Ore Spawnpoint 36'),
(@POOL+36,@MOTHER,0, 'Icecrown Ore Spawnpoint 37'),
(@POOL+37,@MOTHER,0, 'Icecrown Ore Spawnpoint 38'),
(@POOL+38,@MOTHER,0, 'Icecrown Ore Spawnpoint 39'),
(@POOL+39,@MOTHER,0, 'Icecrown Ore Spawnpoint 40'),
(@POOL+40,@MOTHER,0, 'Icecrown Ore Spawnpoint 41'),
(@POOL+41,@MOTHER,0, 'Icecrown Ore Spawnpoint 42'),
(@POOL+42,@MOTHER,0, 'Icecrown Ore Spawnpoint 43'),
(@POOL+43,@MOTHER,0, 'Icecrown Ore Spawnpoint 44'),
(@POOL+44,@MOTHER,0, 'Icecrown Ore Spawnpoint 45'),
(@POOL+45,@MOTHER,0, 'Icecrown Ore Spawnpoint 46'),
(@POOL+46,@MOTHER,0, 'Icecrown Ore Spawnpoint 47'),
(@POOL+47,@MOTHER,0, 'Icecrown Ore Spawnpoint 48'),
(@POOL+48,@MOTHER,0, 'Icecrown Ore Spawnpoint 49'),
(@POOL+49,@MOTHER,0, 'Icecrown Ore Spawnpoint 50'),
(@POOL+50,@MOTHER,0, 'Icecrown Ore Spawnpoint 51'),
(@POOL+51,@MOTHER,0, 'Icecrown Ore Spawnpoint 52'),
(@POOL+52,@MOTHER,0, 'Icecrown Ore Spawnpoint 53'),
(@POOL+53,@MOTHER,0, 'Icecrown Ore Spawnpoint 54'),
(@POOL+54,@MOTHER,0, 'Icecrown Ore Spawnpoint 55'),
(@POOL+55,@MOTHER,0, 'Icecrown Ore Spawnpoint 56'),
(@POOL+56,@MOTHER,0, 'Icecrown Ore Spawnpoint 57'),
(@POOL+57,@MOTHER,0, 'Icecrown Ore Spawnpoint 58'),
(@POOL+58,@MOTHER,0, 'Icecrown Ore Spawnpoint 59'),
(@POOL+59,@MOTHER,0, 'Icecrown Ore Spawnpoint 60'),
(@POOL+60,@MOTHER,0, 'Icecrown Ore Spawnpoint 61'),
(@POOL+61,@MOTHER,0, 'Icecrown Ore Spawnpoint 62'),
(@POOL+62,@MOTHER,0, 'Icecrown Ore Spawnpoint 63'),
(@POOL+63,@MOTHER,0, 'Icecrown Ore Spawnpoint 64'),
(@POOL+64,@MOTHER,0, 'Icecrown Ore Spawnpoint 65'),
(@POOL+65,@MOTHER,0, 'Icecrown Ore Spawnpoint 66'),
(@POOL+66,@MOTHER,0, 'Icecrown Ore Spawnpoint 67'),
(@POOL+67,@MOTHER,0, 'Icecrown Ore Spawnpoint 68'),
(@POOL+68,@MOTHER,0, 'Icecrown Ore Spawnpoint 69'),
(@POOL+69,@MOTHER,0, 'Icecrown Ore Spawnpoint 70'),
(@POOL+70,@MOTHER,0, 'Icecrown Ore Spawnpoint 71'),
(@POOL+71,@MOTHER,0, 'Icecrown Ore Spawnpoint 72'),
(@POOL+72,@MOTHER,0, 'Icecrown Ore Spawnpoint 73'),
(@POOL+73,@MOTHER,0, 'Icecrown Ore Spawnpoint 74'),
(@POOL+74,@MOTHER,0, 'Icecrown Ore Spawnpoint 75'),
(@POOL+75,@MOTHER,0, 'Icecrown Ore Spawnpoint 76'),
(@POOL+76,@MOTHER,0, 'Icecrown Ore Spawnpoint 77'),
(@POOL+77,@MOTHER,0, 'Icecrown Ore Spawnpoint 78'),
(@POOL+78,@MOTHER,0, 'Icecrown Ore Spawnpoint 79'),
(@POOL+79,@MOTHER,0, 'Icecrown Ore Spawnpoint 80'),
(@POOL+80,@MOTHER,0, 'Icecrown Ore Spawnpoint 81'),
(@POOL+81,@MOTHER,0, 'Icecrown Ore Spawnpoint 82'),
(@POOL+82,@MOTHER,0, 'Icecrown Ore Spawnpoint 83'),
(@POOL+83,@MOTHER,0, 'Icecrown Ore Spawnpoint 84'),
(@POOL+84,@MOTHER,0, 'Icecrown Ore Spawnpoint 85'),
(@POOL+85,@MOTHER,0, 'Icecrown Ore Spawnpoint 86'),
(@POOL+86,@MOTHER,0, 'Icecrown Ore Spawnpoint 87'),
(@POOL+87,@MOTHER,0, 'Icecrown Ore Spawnpoint 88'),
(@POOL+88,@MOTHER,0, 'Icecrown Ore Spawnpoint 89'),
(@POOL+89,@MOTHER,0, 'Icecrown Ore Spawnpoint 90'),
(@POOL+90,@MOTHER,0, 'Icecrown Ore Spawnpoint 91'),
(@POOL+91,@MOTHER,0, 'Icecrown Ore Spawnpoint 92'),
(@POOL+92,@MOTHER,0, 'Icecrown Ore Spawnpoint 93'),
(@POOL+93,@MOTHER,0, 'Icecrown Ore Spawnpoint 94'),
(@POOL+94,@MOTHER,0, 'Icecrown Ore Spawnpoint 95'),
(@POOL+95,@MOTHER,0, 'Icecrown Ore Spawnpoint 96'),
(@POOL+96,@MOTHER,0, 'Icecrown Ore Spawnpoint 97'),
(@POOL+97,@MOTHER,0, 'Icecrown Ore Spawnpoint 98'),
(@POOL+98,@MOTHER,0, 'Icecrown Ore Spawnpoint 99'),
(@POOL+99,@MOTHER,0, 'Icecrown Ore Spawnpoint 100'),
(@POOL+100,@MOTHER,0, 'Icecrown Ore Spawnpoint 101'),
(@POOL+101,@MOTHER,0, 'Icecrown Ore Spawnpoint 102'),
(@POOL+102,@MOTHER,0, 'Icecrown Ore Spawnpoint 103'),
(@POOL+103,@MOTHER,0, 'Icecrown Ore Spawnpoint 104'),
(@POOL+104,@MOTHER,0, 'Icecrown Ore Spawnpoint 105'),
(@POOL+105,@MOTHER,0, 'Icecrown Ore Spawnpoint 106'),
(@POOL+106,@MOTHER,0, 'Icecrown Ore Spawnpoint 107'),
(@POOL+107,@MOTHER,0, 'Icecrown Ore Spawnpoint 108'),
(@POOL+108,@MOTHER,0, 'Icecrown Ore Spawnpoint 109'),
(@POOL+109,@MOTHER,0, 'Icecrown Ore Spawnpoint 110'),
(@POOL+110,@MOTHER,0, 'Icecrown Ore Spawnpoint 111'),
(@POOL+111,@MOTHER,0, 'Icecrown Ore Spawnpoint 112'),
(@POOL+112,@MOTHER,0, 'Icecrown Ore Spawnpoint 113'),
(@POOL+113,@MOTHER,0, 'Icecrown Ore Spawnpoint 114'),
(@POOL+114,@MOTHER,0, 'Icecrown Ore Spawnpoint 115'),
(@POOL+115,@MOTHER,0, 'Icecrown Ore Spawnpoint 116'),
(@POOL+116,@MOTHER,0, 'Icecrown Ore Spawnpoint 117'),
(@POOL+117,@MOTHER,0, 'Icecrown Ore Spawnpoint 118'),
(@POOL+118,@MOTHER,0, 'Icecrown Ore Spawnpoint 119'),
(@POOL+119,@MOTHER,0, 'Icecrown Ore Spawnpoint 120'),
(@POOL+120,@MOTHER,0, 'Icecrown Ore Spawnpoint 121'),
(@POOL+121,@MOTHER,0, 'Icecrown Ore Spawnpoint 122'),
(@POOL+122,@MOTHER,0, 'Icecrown Ore Spawnpoint 123'),
(@POOL+123,@MOTHER,0, 'Icecrown Ore Spawnpoint 124'),
(@POOL+124,@MOTHER,0, 'Icecrown Ore Spawnpoint 125'),
(@POOL+125,@MOTHER,0, 'Icecrown Ore Spawnpoint 126'),
(@POOL+126,@MOTHER,0, 'Icecrown Ore Spawnpoint 127'),
(@POOL+127,@MOTHER,0, 'Icecrown Ore Spawnpoint 128'),
(@POOL+128,@MOTHER,0, 'Icecrown Ore Spawnpoint 129'),
(@POOL+129,@MOTHER,0, 'Icecrown Ore Spawnpoint 130'),
(@POOL+130,@MOTHER,0, 'Icecrown Ore Spawnpoint 131'),
(@POOL+131,@MOTHER,0, 'Icecrown Ore Spawnpoint 132'),
(@POOL+132,@MOTHER,0, 'Icecrown Ore Spawnpoint 133'),
(@POOL+133,@MOTHER,0, 'Icecrown Ore Spawnpoint 134'),
(@POOL+134,@MOTHER,0, 'Icecrown Ore Spawnpoint 135'),
(@POOL+135,@MOTHER,0, 'Icecrown Ore Spawnpoint 136'),
(@POOL+136,@MOTHER,0, 'Icecrown Ore Spawnpoint 137'),
(@POOL+137,@MOTHER,0, 'Icecrown Ore Spawnpoint 138'),
(@POOL+138,@MOTHER,0, 'Icecrown Ore Spawnpoint 139'),
(@POOL+139,@MOTHER,0, 'Icecrown Ore Spawnpoint 140'),
(@POOL+140,@MOTHER,0, 'Icecrown Ore Spawnpoint 141'),
(@POOL+141,@MOTHER,0, 'Icecrown Ore Spawnpoint 142'),
(@POOL+142,@MOTHER,0, 'Icecrown Ore Spawnpoint 143'),
(@POOL+143,@MOTHER,0, 'Icecrown Ore Spawnpoint 144'),
(@POOL+144,@MOTHER,0, 'Icecrown Ore Spawnpoint 145'),
(@POOL+145,@MOTHER,0, 'Icecrown Ore Spawnpoint 146'),
(@POOL+146,@MOTHER,0, 'Icecrown Ore Spawnpoint 147'),
(@POOL+147,@MOTHER,0, 'Icecrown Ore Spawnpoint 148'),
(@POOL+148,@MOTHER,0, 'Icecrown Ore Spawnpoint 149'),
(@POOL+149,@MOTHER,0, 'Icecrown Ore Spawnpoint 150'),
(@POOL+150,@MOTHER,0, 'Icecrown Ore Spawnpoint 151'),
(@POOL+151,@MOTHER,0, 'Icecrown Ore Spawnpoint 152'),
(@POOL+152,@MOTHER,0, 'Icecrown Ore Spawnpoint 153'),
(@POOL+153,@MOTHER,0, 'Icecrown Ore Spawnpoint 154'),
(@POOL+154,@MOTHER,0, 'Icecrown Ore Spawnpoint 155'),
(@POOL+155,@MOTHER,0, 'Icecrown Ore Spawnpoint 156'),
(@POOL+156,@MOTHER,0, 'Icecrown Ore Spawnpoint 157'),
(@POOL+157,@MOTHER,0, 'Icecrown Ore Spawnpoint 158'),
(@POOL+158,@MOTHER,0, 'Icecrown Ore Spawnpoint 159'),
(@POOL+159,@MOTHER,0, 'Icecrown Ore Spawnpoint 160'),
(@POOL+160,@MOTHER,0, 'Icecrown Ore Spawnpoint 161'),
(@POOL+161,@MOTHER,0, 'Icecrown Ore Spawnpoint 162'),
(@POOL+162,@MOTHER,0, 'Icecrown Ore Spawnpoint 163'),
(@POOL+163,@MOTHER,0, 'Icecrown Ore Spawnpoint 164'),
(@POOL+164,@MOTHER,0, 'Icecrown Ore Spawnpoint 165'),
(@POOL+165,@MOTHER,0, 'Icecrown Ore Spawnpoint 166'),
(@POOL+166,@MOTHER,0, 'Icecrown Ore Spawnpoint 167'),
(@POOL+167,@MOTHER,0, 'Icecrown Ore Spawnpoint 168'),
(@POOL+168,@MOTHER,0, 'Icecrown Ore Spawnpoint 169'),
(@POOL+169,@MOTHER,0, 'Icecrown Ore Spawnpoint 170'),
(@POOL+170,@MOTHER,0, 'Icecrown Ore Spawnpoint 171'),
(@POOL+171,@MOTHER,0, 'Icecrown Ore Spawnpoint 172'),
(@POOL+172,@MOTHER,0, 'Icecrown Ore Spawnpoint 173'),
(@POOL+173,@MOTHER,0, 'Icecrown Ore Spawnpoint 174'),
(@POOL+174,@MOTHER,0, 'Icecrown Ore Spawnpoint 175'),
(@POOL+175,@MOTHER,0, 'Icecrown Ore Spawnpoint 176'),
(@POOL+176,@MOTHER,0, 'Icecrown Ore Spawnpoint 177'),
(@POOL+177,@MOTHER,0, 'Icecrown Ore Spawnpoint 178'),
(@POOL+178,@MOTHER,0, 'Icecrown Ore Spawnpoint 179'),
(@POOL+179,@MOTHER,0, 'Icecrown Ore Spawnpoint 180'),
(@POOL+180,@MOTHER,0, 'Icecrown Ore Spawnpoint 181'),
(@POOL+181,@MOTHER,0, 'Icecrown Ore Spawnpoint 182'),
(@POOL+182,@MOTHER,0, 'Icecrown Ore Spawnpoint 183'),
(@POOL+183,@MOTHER,0, 'Icecrown Ore Spawnpoint 184'),
(@POOL+184,@MOTHER,0, 'Icecrown Ore Spawnpoint 185'),
(@POOL+185,@MOTHER,0, 'Icecrown Ore Spawnpoint 186'),
(@POOL+186,@MOTHER,0, 'Icecrown Ore Spawnpoint 187'),
(@POOL+187,@MOTHER,0, 'Icecrown Ore Spawnpoint 188'),
(@POOL+188,@MOTHER,0, 'Icecrown Ore Spawnpoint 189'),
(@POOL+189,@MOTHER,0, 'Icecrown Ore Spawnpoint 190'),
(@POOL+190,@MOTHER,0, 'Icecrown Ore Spawnpoint 191'),
(@POOL+191,@MOTHER,0, 'Icecrown Ore Spawnpoint 192'),
(@POOL+192,@MOTHER,0, 'Icecrown Ore Spawnpoint 193'),
(@POOL+193,@MOTHER,0, 'Icecrown Ore Spawnpoint 194'),
(@POOL+194,@MOTHER,0, 'Icecrown Ore Spawnpoint 195'),
(@POOL+195,@MOTHER,0, 'Icecrown Ore Spawnpoint 196'),
(@POOL+196,@MOTHER,0, 'Icecrown Ore Spawnpoint 197'),
(@POOL+197,@MOTHER,0, 'Icecrown Ore Spawnpoint 198'),
(@POOL+198,@MOTHER,0, 'Icecrown Ore Spawnpoint 199'),
(@POOL+199,@MOTHER,0, 'Icecrown Ore Spawnpoint 200'),
(@POOL+200,@MOTHER,0, 'Icecrown Ore Spawnpoint 201'),
(@POOL+201,@MOTHER,0, 'Icecrown Ore Spawnpoint 202'),
(@POOL+202,@MOTHER,0, 'Icecrown Ore Spawnpoint 203'),
(@POOL+203,@MOTHER,0, 'Icecrown Ore Spawnpoint 204'),
(@POOL+204,@MOTHER,0, 'Icecrown Ore Spawnpoint 205'),
(@POOL+205,@MOTHER,0, 'Icecrown Ore Spawnpoint 206'),
(@POOL+206,@MOTHER,0, 'Icecrown Ore Spawnpoint 207'),
(@POOL+207,@MOTHER,0, 'Icecrown Ore Spawnpoint 208'),
(@POOL+208,@MOTHER,0, 'Icecrown Ore Spawnpoint 209'),
(@POOL+209,@MOTHER,0, 'Icecrown Ore Spawnpoint 210'),
(@POOL+210,@MOTHER,0, 'Icecrown Ore Spawnpoint 211'),
(@POOL+211,@MOTHER,0, 'Icecrown Ore Spawnpoint 212'),
(@POOL+212,@MOTHER,0, 'Icecrown Ore Spawnpoint 213'),
(@POOL+213,@MOTHER,0, 'Icecrown Ore Spawnpoint 214'),
(@POOL+214,@MOTHER,0, 'Icecrown Ore Spawnpoint 215'),
(@POOL+215,@MOTHER,0, 'Icecrown Ore Spawnpoint 216'),
(@POOL+216,@MOTHER,0, 'Icecrown Ore Spawnpoint 217'),
(@POOL+217,@MOTHER,0, 'Icecrown Ore Spawnpoint 218'),
(@POOL+218,@MOTHER,0, 'Icecrown Ore Spawnpoint 219'),
(@POOL+219,@MOTHER,0, 'Icecrown Ore Spawnpoint 220'),
(@POOL+220,@MOTHER,0, 'Icecrown Ore Spawnpoint 221'),
(@POOL+221,@MOTHER,0, 'Icecrown Ore Spawnpoint 222'),
(@POOL+222,@MOTHER,0, 'Icecrown Ore Spawnpoint 223'),
(@POOL+223,@MOTHER,0, 'Icecrown Ore Spawnpoint 224'),
(@POOL+224,@MOTHER,0, 'Icecrown Ore Spawnpoint 225'),
(@POOL+225,@MOTHER,0, 'Icecrown Ore Spawnpoint 226'),
(@POOL+226,@MOTHER,0, 'Icecrown Ore Spawnpoint 227'),
(@POOL+227,@MOTHER,0, 'Icecrown Ore Spawnpoint 228'),
(@POOL+228,@MOTHER,0, 'Icecrown Ore Spawnpoint 229'),
(@POOL+229,@MOTHER,0, 'Icecrown Ore Spawnpoint 230'),
(@POOL+230,@MOTHER,0, 'Icecrown Ore Spawnpoint 231'),
(@POOL+231,@MOTHER,0, 'Icecrown Ore Spawnpoint 232'),
(@POOL+232,@MOTHER,0, 'Icecrown Ore Spawnpoint 233'),
(@POOL+233,@MOTHER,0, 'Icecrown Ore Spawnpoint 234'),
(@POOL+234,@MOTHER,0, 'Icecrown Ore Spawnpoint 235');

