SET @Rest := 821; -- Leftover area (41 nodes)
SET @Area405 := @Rest+1; -- Area 405 (40 nodes)
SET @Area596 := @Rest+2; -- Area 596 (18 nodes)
SET @Area598 := @Rest+3; -- Area 598 (20 nodes)
SET @Area602 := @Rest+4; -- Area 602 (27 nodes)
SET @Area607 := @Rest+5; -- Area 607 (22 nodes)

DELETE FROM `pool_template` WHERE `entry` BETWEEN @Rest AND @Rest+6 ;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@Rest   ,10, 'Master Herbs Zone 405 Leftover Areas (10 out of 41 nodes)'),
(@Area405,8, 'Master Herbs Zone 405 Leftover Areas (8 out of 40 nodes)'),
(@Area596,4, 'Master Herbs Zone 405 Leftover Areas (4 out of 18 nodes)'),
(@Area598,5, 'Master Herbs Zone 405 Leftover Areas (5 out of 20 nodes)'),
(@Area602,5, 'Master Herbs Zone 405 Leftover Areas (5 out of 27 nodes)'),
(@Area607,5, 'Master Herbs Zone 405 Leftover Areas (5 out of 22 nodes)');

DELETE FROM `pool_gameobject` WHERE `pool_entry` BETWEEN @REST AND @REST+5 ;
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
-- node s are numbered based on GUID, comment shows area and type
-- Pooled per area for more randomness
(3126,@Area405,0,'Bruiseweed,Zone 405,405,node 14'),
(3196,@Area405,0,'Bruiseweed,Zone 405,405,node 16'),
(3197,@Area405,0,'Bruiseweed,Zone 405,405,node 17'),
(3198,@Area405,0,'Bruiseweed,Zone 405,405,node 18'),
(3393,@Area405,0,'Bruiseweed,Zone 405,405,node 25'),
(3588,@Area405,0,'Bruiseweed,Zone 405,405,node 32'),
(3707,@Area405,0,'Bruiseweed,Zone 405,405,node 36'),
(3814,@Area405,0,'Bruiseweed,Zone 405,405,node 44'),
(3939,@Area405,0,'Wild Steelbloom,Zone 405,405,node 47'),
(4200,@Area405,0,'Wild Steelbloom,Zone 405,405,node 51'),
(4206,@Area405,0,'Wild Steelbloom,Zone 405,405,node 52'),
(4226,@Area405,0,'Wild Steelbloom,Zone 405,405,node 53'),
(4251,@Area405,0,'Wild Steelbloom,Zone 405,405,node 54'),
(4286,@Area405,0,'Kingsblood,Zone 405,405,node 55'),
(4316,@Area405,0,'Kingsblood,Zone 405,405,node 56'),
(4334,@Area405,0,'Kingsblood,Zone 405,405,node 57'),
(4338,@Area405,0,'Kingsblood,Zone 405,405,node 58'),
(4340,@Area405,0,'Kingsblood,Zone 405,405,node 59'),
(4358,@Area405,0,'Kingsblood,Zone 405,405,node 60'),
(4389,@Area405,0,'Kingsblood,Zone 405,405,node 62'),
(4398,@Area405,0,'Kingsblood,Zone 405,405,node 63'),
(4400,@Area405,0,'Kingsblood,Zone 405,405,node 64'),
(7336,@Area405,0,'Liferoot,Zone 405,405,node 80'),
(7491,@Area405,0,'Liferoot,Zone 405,405,node 86'),
(16475,@Area405,0,'Gromsblood,Zone 405,405,node 112'),
(18619,@Area405,0,'Wild Steelbloom,Zone 405,405,node 126'),
(18624,@Area405,0,'Kingsblood,Zone 405,405,node 129'),
(18680,@Area405,0,'Grave Moss,Zone 405,405,node 133'),
(29185,@Area405,0,'Liferoot,Zone 405,405,node 135'),
(29186,@Area405,0,'Liferoot,Zone 405,405,node 136'),
(34170,@Area405,0,'Kingsblood,Zone 405,405,node 147'),
(63344,@Area405,0,'Bruiseweed,Zone 405,405,node 151'),
(63386,@Area405,0,'Kingsblood,Zone 405,405,node 152'),
(63410,@Area405,0,'Grave Moss,Zone 405,405,node 153'),
(65114,@Area405,0,'Kingsblood,Zone 405,405,node 155'),
(86317,@Area405,0,'Kingsblood,Zone 405,405,node 158'),
(86348,@Area405,0,'Grave Moss,Zone 405,405,node 160'),
(86827,@Area405,0,'Liferoot,Zone 405,405,node 162'),
(86835,@Area405,0,'Liferoot,Zone 405,405,node 163'),
(87282,@Area405,0,'Grave Moss,Zone 405,405,node 167'),
(4437,@Area596,0,'Grave Moss,Zone 405,596,node 65'),
(4441,@Area596,0,'Grave Moss,Zone 405,596,node 66'),
(4443,@Area596,0,'Grave Moss,Zone 405,596,node 67'),
(4451,@Area596,0,'Grave Moss,Zone 405,596,node 68'),
(4468,@Area596,0,'Grave Moss,Zone 405,596,node 69'),
(4476,@Area596,0,'Grave Moss,Zone 405,596,node 70'),
(4477,@Area596,0,'Grave Moss,Zone 405,596,node 71'),
(4481,@Area596,0,'Grave Moss,Zone 405,596,node 72'),
(4487,@Area596,0,'Grave Moss,Zone 405,596,node 73'),
(4489,@Area596,0,'Grave Moss,Zone 405,596,node 74'),
(4495,@Area596,0,'Grave Moss,Zone 405,596,node 75'),
(4499,@Area596,0,'Grave Moss,Zone 405,596,node 76'),
(4503,@Area596,0,'Grave Moss,Zone 405,596,node 77'),
(4505,@Area596,0,'Grave Moss,Zone 405,596,node 78'),
(4507,@Area596,0,'Grave Moss,Zone 405,596,node 79'),
(86350,@Area596,0,'Grave Moss,Zone 405,596,node 161'),
(87272,@Area596,0,'Kingsblood,Zone 405,596,node 165'),
(87483,@Area596,0,'Grave Moss,Zone 405,596,node 168'),
(4388,@Area598,0,'Kingsblood,Zone 405,598,node 61'),
(8252,@Area598,0,'Stranglekelp,Zone 405,598,node 87'),
(8257,@Area598,0,'Stranglekelp,Zone 405,598,node 88'),
(8258,@Area598,0,'Stranglekelp,Zone 405,598,node 89'),
(8326,@Area598,0,'Stranglekelp,Zone 405,598,node 91'),
(8340,@Area598,0,'Stranglekelp,Zone 405,598,node 92'),
(8352,@Area598,0,'Stranglekelp,Zone 405,598,node 93'),
(8357,@Area598,0,'Stranglekelp,Zone 405,598,node 94'),
(8397,@Area598,0,'Stranglekelp,Zone 405,598,node 95'),
(8398,@Area598,0,'Stranglekelp,Zone 405,598,node 96'),
(8503,@Area598,0,'Stranglekelp,Zone 405,598,node 99'),
(8528,@Area598,0,'Stranglekelp,Zone 405,598,node 100'),
(18620,@Area598,0,'Wild Steelbloom,Zone 405,598,node 127'),
(29195,@Area598,0,'Stranglekelp,Zone 405,598,node 138'),
(29198,@Area598,0,'Stranglekelp,Zone 405,598,node 139'),
(29199,@Area598,0,'Stranglekelp,Zone 405,598,node 140'),
(29201,@Area598,0,'Stranglekelp,Zone 405,598,node 142'),
(29202,@Area598,0,'Stranglekelp,Zone 405,598,node 143'),
(29203,@Area598,0,'Stranglekelp,Zone 405,598,node 144'),
(87274,@Area598,0,'Kingsblood,Zone 405,598,node 166'),
(2920,@Area602,0,'Bruiseweed,Zone 405,602,node 1'),
(2921,@Area602,0,'Bruiseweed,Zone 405,602,node 2'),
(2953,@Area602,0,'Bruiseweed,Zone 405,602,node 4'),
(3083,@Area602,0,'Bruiseweed,Zone 405,602,node 10'),
(3156,@Area602,0,'Bruiseweed,Zone 405,602,node 15'),
(3203,@Area602,0,'Bruiseweed,Zone 405,602,node 19'),
(3771,@Area602,0,'Bruiseweed,Zone 405,602,node 40'),
(3772,@Area602,0,'Bruiseweed,Zone 405,602,node 41'),
(3790,@Area602,0,'Bruiseweed,Zone 405,602,node 43'),
(7464,@Area602,0,'Liferoot,Zone 405,602,node 84'),
(7469,@Area602,0,'Liferoot,Zone 405,602,node 85'),
(16458,@Area602,0,'Gromsblood,Zone 405,602,node 110'),
(16464,@Area602,0,'Gromsblood,Zone 405,602,node 111'),
(16498,@Area602,0,'Gromsblood,Zone 405,602,node 113'),
(16502,@Area602,0,'Gromsblood,Zone 405,602,node 114'),
(16510,@Area602,0,'Gromsblood,Zone 405,602,node 115'),
(16523,@Area602,0,'Gromsblood,Zone 405,602,node 116'),
(16533,@Area602,0,'Gromsblood,Zone 405,602,node 117'),
(16537,@Area602,0,'Gromsblood,Zone 405,602,node 118'),
(16538,@Area602,0,'Gromsblood,Zone 405,602,node 119'),
(16539,@Area602,0,'Gromsblood,Zone 405,602,node 120'),
(16540,@Area602,0,'Gromsblood,Zone 405,602,node 121'),
(16541,@Area602,0,'Gromsblood,Zone 405,602,node 122'),
(16544,@Area602,0,'Gromsblood,Zone 405,602,node 123'),
(28646,@Area602,0,'Liferoot,Zone 405,602,node 134'),
(34831,@Area602,0,'Bruiseweed,Zone 405,602,node 150'),
(86143,@Area602,0,'Gromsblood,Zone 405,602,node 156'),
(2936,@Area607,0,'Bruiseweed,Zone 405,607,node 3'),
(2972,@Area607,0,'Bruiseweed,Zone 405,607,node 5'),
(2973,@Area607,0,'Bruiseweed,Zone 405,607,node 6'),
(3003,@Area607,0,'Bruiseweed,Zone 405,607,node 8'),
(3221,@Area607,0,'Bruiseweed,Zone 405,607,node 20'),
(3251,@Area607,0,'Bruiseweed,Zone 405,607,node 21'),
(3430,@Area607,0,'Bruiseweed,Zone 405,607,node 26'),
(3431,@Area607,0,'Bruiseweed,Zone 405,607,node 27'),
(3432,@Area607,0,'Bruiseweed,Zone 405,607,node 28'),
(3665,@Area607,0,'Bruiseweed,Zone 405,607,node 35'),
(3860,@Area607,0,'Bruiseweed,Zone 405,607,node 45'),
(3861,@Area607,0,'Bruiseweed,Zone 405,607,node 46'),
(16427,@Area607,0,'Ghost Mushroom,Zone 405,607,node 104'),
(16432,@Area607,0,'Ghost Mushroom,Zone 405,607,node 105'),
(16440,@Area607,0,'Ghost Mushroom,Zone 405,607,node 106'),
(16441,@Area607,0,'Ghost Mushroom,Zone 405,607,node 107'),
(16444,@Area607,0,'Ghost Mushroom,Zone 405,607,node 108'),
(16446,@Area607,0,'Ghost Mushroom,Zone 405,607,node 109'),
(18214,@Area607,0,'Ghost Mushroom,Zone 405,607,node 124'),
(34185,@Area607,0,'Ghost Mushroom,Zone 405,607,node 148'),
(34187,@Area607,0,'Bruiseweed,Zone 405,607,node 149'),
(86288,@Area607,0,'Bruiseweed,Zone 405,607,node 157'),
(3123,@Rest,0,'Bruiseweed,Zone 405,603,node 11'),
(3124,@Rest,0,'Bruiseweed,Zone 405,603,node 12'),
(3125,@Rest,0,'Bruiseweed,Zone 405,603,node 13'),
(3320,@Rest,0,'Bruiseweed,Zone 405,603,node 22'),
(3363,@Rest,0,'Bruiseweed,Zone 405,603,node 23'),
(3364,@Rest,0,'Bruiseweed,Zone 405,603,node 24'),
(3566,@Rest,0,'Bruiseweed,Zone 405,603,node 30'),
(3577,@Rest,0,'Bruiseweed,Zone 405,603,node 31'),
(3622,@Rest,0,'Bruiseweed,Zone 405,603,node 34'),
(3718,@Rest,0,'Bruiseweed,Zone 405,603,node 38'),
(3720,@Rest,0,'Bruiseweed,Zone 405,603,node 39'),
(18617,@Rest,0,'Bruiseweed,Zone 405,603,node 125'),
(18621,@Rest,0,'Wild Steelbloom,Zone 405,603,node 128'),
(7362,@Rest,0,'Liferoot,Zone 405,604,node 81'),
(7437,@Rest,0,'Liferoot,Zone 405,604,node 82'),
(7458,@Rest,0,'Liferoot,Zone 405,604,node 83'),
(29188,@Rest,0,'Liferoot,Zone 405,604,node 137'),
(3990,@Rest,0,'Wild Steelbloom,Zone 405,609,node 48'),
(4063,@Rest,0,'Wild Steelbloom,Zone 405,609,node 49'),
(18676,@Rest,0,'Grave Moss,Zone 405,609,node 131'),
(65072,@Rest,0,'Wild Steelbloom,Zone 405,609,node 154'),
(29200,@Rest,0,'Stranglekelp,Zone 405,2324,node 141'),
(4086,@Rest,0,'Wild Steelbloom,Zone 405,2404,node 50'),
(8542,@Rest,0,'Stranglekelp,Zone 405,2405,node 101'),
(8543,@Rest,0,'Stranglekelp,Zone 405,2405,node 102'),
(8557,@Rest,0,'Stranglekelp,Zone 405,2405,node 103'),
(8272,@Rest,0,'Stranglekelp,Zone 405,2408,node 90'),
(8404,@Rest,0,'Stranglekelp,Zone 405,2408,node 97'),
(8447,@Rest,0,'Stranglekelp,Zone 405,2408,node 98'),
(3773,@Rest,0,'Bruiseweed,Zone 405,2617,node 42'),
(18625,@Rest,0,'Kingsblood,Zone 405,2617,node 130'),
(18677,@Rest,0,'Grave Moss,Zone 405,2657,node 132'),
(2979,@Rest,0,'Bruiseweed,Zone 405,599,node 7'),
(3078,@Rest,0,'Bruiseweed,Zone 405,599,node 9'),
(3501,@Rest,0,'Bruiseweed,Zone 405,599,node 29'),
(3599,@Rest,0,'Bruiseweed,Zone 405,599,node 33'),
(3717,@Rest,0,'Bruiseweed,Zone 405,599,node 37'),
(34165,@Rest,0,'Bruiseweed,Zone 405,599,node 145'),
(34168,@Rest,0,'Wild Steelbloom,Zone 405,599,node 146'),
(86326,@Rest,0,'Kingsblood,Zone 405,599,node 159'),
(87250,@Rest,0,'Bruiseweed,Zone 405,599,node 164');
