SET @REST := 800; -- Leftover area (88 nodes)
SET @AREA17 := @REST+1; -- Area 17 (305 nodes)
SET @AREA383 := @REST+2; -- Area 383 (41 nodes)
SET @AREA385 := @REST+3; -- Area 385 (19 nodes)
SET @AREA386 := @REST+4; -- Area 386 (15 nodes)
SET @AREA387 := @REST+5; -- Area 387 (54 nodes)
SET @AREA388 := @REST+6; -- Area 388 (21 nodes)
SET @AREA390 := @REST+7; -- Area 390 (39 nodes)
SET @AREA391 := @REST+8; -- Area 391 (86 nodes)
SET @AREA1156 := @REST+9; -- Area 1156 (92 nodes)
SET @AREA1698 := @REST+10; -- Area 1698 (20 nodes)
SET @AREA1699 := @REST+11; -- Area 1699 (21 nodes)
SET @AREA1700 := @REST+12; -- Area 1700 (28 nodes)
SET @AREA1701 := @REST+13; -- Area 1701 (39 nodes)

DELETE FROM `pool_template` WHERE `entry` BETWEEN @REST AND @REST+17 ;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(@REST,18, 'Master Zone 17 Leftover Areas (18 out of 88 nodes)'),
(@AREA17,60, 'Master Zone 17 Area 17 (60 out of 305 nodes'),
(@AREA383,8, 'Master Zone 17 Area 383 (8 out of 41 nodes'),
(@AREA385,4, 'Master Zone 17 Area 385 (4 out of 19 nodes'),
(@AREA386,3, 'Master Zone 17 Area 386 (3 out of 15 nodes'),
(@AREA387,10, 'Master Zone 17 Area 387 (10 out of 54 nodes'),
(@AREA388,4, 'Master Zone 17 Area 388 (4 out of 21 nodes'),
(@AREA390,8, 'Master Zone 17 Area 390 (8 out of 39 nodes'),
(@AREA391,17, 'Master Zone 17 Area 391 (17 out of 86 nodes'),
(@AREA1156,10, 'Master Zone 17 Area 1156 (18 out of 92 nodes'),
(@AREA1698,10, 'Master Zone 17 Area 1698 (4 out of 20 nodes'),
(@AREA1699,10, 'Master Zone 17 Area 1699 (4 out of 21 nodes'),
(@AREA1700,10, 'Master Zone 17 Area 1700 (6 out of 28 nodes'),
(@AREA1701,10, 'Master Zone 17 Area 1701 (8 out of 39 nodes');

DELETE FROM `pool_gameobject` WHERE `pool_entry` BETWEEN @REST AND @REST+17 ;
INSERT INTO `pool_gameobject` (`guid`,`pool_entry`,`chance`,`description`) VALUES
-- Nodes are numbered based on GUID, comment shows area and type
-- Pooled per area for more randomness
(462,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 1'),
(473,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 2'),
(507,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 7'),
(520,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 8'),
(532,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 9'),
(533,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 10'),
(542,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 11'),
(562,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 12'),
(585,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 13'),
(589,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 14'),
(593,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 15'),
(606,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 18'),
(632,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 21'),
(659,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 23'),
(671,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 24'),
(696,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 27'),
(775,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 34'),
(782,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 35'),
(795,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 37'),
(812,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 38'),
(824,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 39'),
(879,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 43'),
(927,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 54'),
(945,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 57'),
(946,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 58'),
(947,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 59'),
(1011,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 66'),
(1034,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 69'),
(1040,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 71'),
(1082,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 74'),
(1106,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 80'),
(1131,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 83'),
(1166,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 86'),
(1168,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 87'),
(1170,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 89'),
(1193,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 90'),
(1255,@AREA17,0, 'Silverleaf,Zone 17,Area 17,node 93'),
(1355,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 96'),
(1372,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 97'),
(1376,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 100'),
(1398,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 102'),
(1404,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 103'),
(1413,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 107'),
(1429,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 110'),
(1440,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 112'),
(1470,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 115'),
(1471,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 116'),
(1485,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 120'),
(1490,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 121'),
(1512,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 126'),
(1513,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 127'),
(1514,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 128'),
(1522,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 129'),
(1528,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 131'),
(1536,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 132'),
(1544,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 135'),
(1559,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 137'),
(1560,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 138'),
(1575,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 142'),
(1606,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 146'),
(1622,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 147'),
(1634,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 150'),
(1642,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 151'),
(1644,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 152'),
(1663,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 156'),
(1677,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 160'),
(1702,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 162'),
(1704,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 163'),
(1737,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 166'),
(1742,@AREA17,0, 'Peacebloom,Zone 17,Area 17,node 167'),
(1756,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 169'),
(1764,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 173'),
(1765,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 174'),
(1767,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 175'),
(1787,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 181'),
(1796,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 184'),
(1797,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 185'),
(1802,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 187'),
(1804,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 188'),
(1807,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 189'),
(1808,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 190'),
(1809,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 191'),
(1815,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 194'),
(1816,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 195'),
(1823,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 196'),
(1833,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 198'),
(1844,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 202'),
(1845,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 203'),
(1846,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 204'),
(1852,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 205'),
(1859,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 211'),
(1861,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 212'),
(1866,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 214'),
(1868,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 215'),
(1898,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 218'),
(1899,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 219'),
(1900,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 220'),
(1902,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 222'),
(1903,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 223'),
(1905,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 224'),
(1907,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 225'),
(1908,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 226'),
(1911,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 227'),
(1913,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 228'),
(1926,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 235'),
(1930,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 237'),
(1931,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 238'),
(1932,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 239'),
(1934,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 240'),
(1935,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 241'),
(1936,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 242'),
(1942,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 243'),
(1943,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 244'),
(1944,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 245'),
(1945,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 246'),
(1946,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 247'),
(1950,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 248'),
(1961,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 253'),
(1963,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 254'),
(1965,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 255'),
(1967,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 256'),
(1968,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 257'),
(1975,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 259'),
(1977,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 260'),
(1978,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 261'),
(1979,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 262'),
(1980,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 263'),
(1986,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 266'),
(1988,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 268'),
(1989,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 269'),
(1990,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 270'),
(1991,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 271'),
(1992,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 272'),
(1995,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 273'),
(1997,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 274'),
(2003,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 277'),
(2006,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 280'),
(2007,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 281'),
(2009,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 282'),
(2019,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 286'),
(2020,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 287'),
(2021,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 288'),
(2040,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 294'),
(2041,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 295'),
(2064,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 301'),
(2067,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 303'),
(2068,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 304'),
(2069,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 305'),
(2071,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 306'),
(2072,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 307'),
(2078,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 308'),
(2079,@AREA17,0, 'Earthroot,Zone 17,Area 17,node 309'),
(2082,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 311'),
(2085,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 313'),
(2089,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 315'),
(2106,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 323'),
(2123,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 328'),
(2125,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 329'),
(2135,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 332'),
(2136,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 333'),
(2141,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 336'),
(2142,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 337'),
(2153,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 345'),
(2156,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 347'),
(2161,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 350'),
(2170,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 355'),
(2174,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 357'),
(2183,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 365'),
(2186,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 366'),
(2194,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 371'),
(2200,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 375'),
(2201,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 376'),
(2202,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 377'),
(2203,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 378'),
(2204,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 379'),
(2207,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 382'),
(2213,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 386'),
(2223,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 390'),
(2226,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 392'),
(2227,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 393'),
(2230,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 396'),
(2231,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 397'),
(2232,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 398'),
(2233,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 399'),
(2263,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 410'),
(2264,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 411'),
(2267,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 412'),
(2268,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 413'),
(2272,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 416'),
(2289,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 423'),
(2290,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 424'),
(2291,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 425'),
(2292,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 426'),
(2293,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 427'),
(2296,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 428'),
(2297,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 429'),
(2308,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 431'),
(2310,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 432'),
(2312,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 434'),
(2313,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 435'),
(2314,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 436'),
(2315,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 437'),
(2317,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 438'),
(2318,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 439'),
(2337,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 443'),
(2361,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 457'),
(2362,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 458'),
(2363,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 459'),
(2364,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 460'),
(2369,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 461'),
(2378,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 464'),
(2383,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 466'),
(2385,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 468'),
(2387,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 470'),
(2388,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 471'),
(2392,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 475'),
(2393,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 476'),
(2395,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 477'),
(2400,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 479'),
(2405,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 481'),
(2419,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 483'),
(2427,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 487'),
(2429,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 488'),
(2430,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 489'),
(2433,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 490'),
(2434,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 491'),
(2445,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 493'),
(2446,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 494'),
(2447,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 495'),
(2472,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 504'),
(2482,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 506'),
(2483,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 507'),
(2486,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 508'),
(2488,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 510'),
(2489,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 511'),
(2503,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 517'),
(2507,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 520'),
(2508,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 521'),
(2509,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 522'),
(2513,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 524'),
(2528,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 529'),
(2534,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 530'),
(2535,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 531'),
(2536,@AREA17,0, 'Mageroyal,Zone 17,Area 17,node 532'),
(2564,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 542'),
(2567,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 544'),
(2569,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 545'),
(2591,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 548'),
(2599,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 549'),
(2621,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 554'),
(2644,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 558'),
(2646,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 559'),
(2648,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 560'),
(2659,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 562'),
(2668,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 564'),
(2716,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 570'),
(2728,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 577'),
(2747,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 582'),
(2762,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 588'),
(2772,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 593'),
(2789,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 596'),
(2807,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 597'),
(2814,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 598'),
(2836,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 605'),
(2859,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 607'),
(2865,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 608'),
(2880,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 609'),
(2881,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 610'),
(2883,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 611'),
(2885,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 613'),
(2887,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 615'),
(2906,@AREA17,0, 'Briarthorn,Zone 17,Area 17,node 620'),
(2955,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 628'),
(2971,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 629'),
(3015,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 631'),
(3032,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 633'),
(3056,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 636'),
(3134,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 648'),
(3135,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 649'),
(3361,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 671'),
(3406,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 675'),
(3409,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 676'),
(3451,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 678'),
(3452,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 679'),
(3453,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 680'),
(3455,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 681'),
(3574,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 697'),
(3575,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 698'),
(3579,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 699'),
(3595,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 701'),
(3621,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 702'),
(3827,@AREA17,0, 'Bruiseweed,Zone 17,Area 17,node 716'),
(4028,@AREA17,0, 'Wild Steelbloom,Zone 17,Area 17,node 731'),
(4294,@AREA17,0, 'Kingsblood,Zone 17,Area 17,node 747'),
(4324,@AREA17,0, 'Kingsblood,Zone 17,Area 17,node 750'),
(4325,@AREA17,0, 'Kingsblood,Zone 17,Area 17,node 751'),
(8231,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 772'),
(8382,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 794'),
(8383,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 795'),
(8384,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 796'),
(8425,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 797'),
(8426,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 798'),
(8452,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 801'),
(8466,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 807'),
(8570,@AREA17,0, 'Stranglekelp,Zone 17,Area 17,node 819'),
(488,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 5'),
(489,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 6'),
(689,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 26'),
(913,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 52'),
(918,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 53'),
(1085,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 75'),
(1086,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 76'),
(1087,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 77'),
(1089,@AREA383,0, 'Silverleaf,Zone 17,Area 383,node 78'),
(1755,@AREA383,0, 'Earthroot,Zone 17,Area 383,node 168'),
(1856,@AREA383,0, 'Earthroot,Zone 17,Area 383,node 209'),
(2060,@AREA383,0, 'Earthroot,Zone 17,Area 383,node 297'),
(2061,@AREA383,0, 'Earthroot,Zone 17,Area 383,node 298'),
(2062,@AREA383,0, 'Earthroot,Zone 17,Area 383,node 299'),
(2063,@AREA383,0, 'Earthroot,Zone 17,Area 383,node 300'),
(2176,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 358'),
(2177,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 359'),
(2178,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 360'),
(2179,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 361'),
(2180,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 362'),
(2181,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 363'),
(2182,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 364'),
(2377,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 463'),
(2455,@AREA383,0, 'Mageroyal,Zone 17,Area 383,node 497'),
(2590,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 547'),
(2610,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 550'),
(2615,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 552'),
(2667,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 563'),
(2691,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 567'),
(2719,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 572'),
(2743,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 581'),
(2763,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 589'),
(2817,@AREA383,0, 'Briarthorn,Zone 17,Area 383,node 599'),
(2954,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 627'),
(3006,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 630'),
(3157,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 651'),
(3303,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 664'),
(3350,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 668'),
(3351,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 669'),
(3352,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 670'),
(3368,@AREA383,0, 'Bruiseweed,Zone 17,Area 383,node 672'),
(2122,@AREA385,0, 'Mageroyal,Zone 17,Area 385,node 327'),
(2717,@AREA385,0, 'Briarthorn,Zone 17,Area 385,node 571'),
(2732,@AREA385,0, 'Briarthorn,Zone 17,Area 385,node 579'),
(2884,@AREA385,0, 'Briarthorn,Zone 17,Area 385,node 612'),
(2886,@AREA385,0, 'Briarthorn,Zone 17,Area 385,node 614'),
(3260,@AREA385,0, 'Bruiseweed,Zone 17,Area 385,node 655'),
(3262,@AREA385,0, 'Bruiseweed,Zone 17,Area 385,node 657'),
(3342,@AREA385,0, 'Bruiseweed,Zone 17,Area 385,node 667'),
(3469,@AREA385,0, 'Bruiseweed,Zone 17,Area 385,node 685'),
(3538,@AREA385,0, 'Bruiseweed,Zone 17,Area 385,node 694'),
(3739,@AREA385,0, 'Bruiseweed,Zone 17,Area 385,node 712'),
(3793,@AREA385,0, 'Bruiseweed,Zone 17,Area 385,node 713'),
(4024,@AREA385,0, 'Wild Steelbloom,Zone 17,Area 385,node 729'),
(4288,@AREA385,0, 'Kingsblood,Zone 17,Area 385,node 746'),
(13366,@AREA385,0, 'Wild Steelbloom,Zone 17,Area 385,node 822'),
(15755,@AREA385,0, 'Stranglekelp,Zone 17,Area 385,node 831'),
(15756,@AREA385,0, 'Stranglekelp,Zone 17,Area 385,node 832'),
(65366,@AREA385,0, 'Stranglekelp,Zone 17,Area 385,node 847'),
(65367,@AREA385,0, 'Stranglekelp,Zone 17,Area 385,node 848'),
(604,@AREA386,0, 'Silverleaf,Zone 17,Area 386,node 16'),
(605,@AREA386,0, 'Silverleaf,Zone 17,Area 386,node 17'),
(1813,@AREA386,0, 'Earthroot,Zone 17,Area 386,node 192'),
(1814,@AREA386,0, 'Earthroot,Zone 17,Area 386,node 193'),
(1901,@AREA386,0, 'Earthroot,Zone 17,Area 386,node 221'),
(2066,@AREA386,0, 'Earthroot,Zone 17,Area 386,node 302'),
(2108,@AREA386,0, 'Mageroyal,Zone 17,Area 386,node 325'),
(2139,@AREA386,0, 'Mageroyal,Zone 17,Area 386,node 335'),
(2160,@AREA386,0, 'Mageroyal,Zone 17,Area 386,node 349'),
(2205,@AREA386,0, 'Mageroyal,Zone 17,Area 386,node 380'),
(2206,@AREA386,0, 'Mageroyal,Zone 17,Area 386,node 381'),
(2611,@AREA386,0, 'Briarthorn,Zone 17,Area 386,node 551'),
(2625,@AREA386,0, 'Briarthorn,Zone 17,Area 386,node 555'),
(2725,@AREA386,0, 'Briarthorn,Zone 17,Area 386,node 576'),
(2822,@AREA386,0, 'Briarthorn,Zone 17,Area 386,node 600'),
(630,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 20'),
(650,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 22'),
(700,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 28'),
(785,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 36'),
(852,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 41'),
(904,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 45'),
(905,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 46'),
(906,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 47'),
(907,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 48'),
(908,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 49'),
(909,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 50'),
(910,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 51'),
(928,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 55'),
(983,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 61'),
(994,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 62'),
(998,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 63'),
(1002,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 64'),
(1004,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 65'),
(1013,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 67'),
(1039,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 70'),
(1051,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 72'),
(1100,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 79'),
(1107,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 81'),
(1146,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 85'),
(1258,@AREA387,0, 'Silverleaf,Zone 17,Area 387,node 94'),
(2138,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 334'),
(2192,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 369'),
(2199,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 374'),
(2222,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 389'),
(2229,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 395'),
(2339,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 444'),
(2340,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 445'),
(2341,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 446'),
(2347,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 450'),
(2348,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 451'),
(2349,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 452'),
(2350,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 453'),
(2351,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 454'),
(2358,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 456'),
(2386,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 469'),
(2391,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 474'),
(2475,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 505'),
(2492,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 512'),
(2504,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 518'),
(2515,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 525'),
(2537,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 533'),
(2538,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 534'),
(2539,@AREA387,0, 'Mageroyal,Zone 17,Area 387,node 535'),
(2699,@AREA387,0, 'Briarthorn,Zone 17,Area 387,node 569'),
(2766,@AREA387,0, 'Briarthorn,Zone 17,Area 387,node 590'),
(2835,@AREA387,0, 'Briarthorn,Zone 17,Area 387,node 604'),
(3328,@AREA387,0, 'Bruiseweed,Zone 17,Area 387,node 665'),
(3812,@AREA387,0, 'Bruiseweed,Zone 17,Area 387,node 714'),
(3813,@AREA387,0, 'Bruiseweed,Zone 17,Area 387,node 715'),
(705,@AREA388,0, 'Silverleaf,Zone 17,Area 388,node 29'),
(1078,@AREA388,0, 'Silverleaf,Zone 17,Area 388,node 73'),
(1130,@AREA388,0, 'Silverleaf,Zone 17,Area 388,node 82'),
(1218,@AREA388,0, 'Silverleaf,Zone 17,Area 388,node 91'),
(1234,@AREA388,0, 'Silverleaf,Zone 17,Area 388,node 92'),
(2088,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 314'),
(2098,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 319'),
(2165,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 352'),
(2166,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 353'),
(2191,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 368'),
(2193,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 370'),
(2274,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 417'),
(2285,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 421'),
(2328,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 440'),
(2401,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 480'),
(2406,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 482'),
(2423,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 484'),
(2487,@AREA388,0, 'Mageroyal,Zone 17,Area 388,node 509'),
(2652,@AREA388,0, 'Briarthorn,Zone 17,Area 388,node 561'),
(2751,@AREA388,0, 'Briarthorn,Zone 17,Area 388,node 583'),
(2902,@AREA388,0, 'Briarthorn,Zone 17,Area 388,node 618'),
(1434,@AREA390,0, 'Peacebloom,Zone 17,Area 390,node 111'),
(1481,@AREA390,0, 'Peacebloom,Zone 17,Area 390,node 119'),
(2084,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 312'),
(2107,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 324'),
(2109,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 326'),
(2211,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 384'),
(2212,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 385'),
(2343,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 447'),
(2344,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 448'),
(2345,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 449'),
(2355,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 455'),
(2426,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 486'),
(2506,@AREA390,0, 'Mageroyal,Zone 17,Area 390,node 519'),
(2767,@AREA390,0, 'Briarthorn,Zone 17,Area 390,node 591'),
(2898,@AREA390,0, 'Briarthorn,Zone 17,Area 390,node 617'),
(2930,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 623'),
(3270,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 658'),
(3271,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 659'),
(3272,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 660'),
(3375,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 673'),
(3376,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 674'),
(3458,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 682'),
(3494,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 687'),
(3495,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 688'),
(3496,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 689'),
(3497,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 690'),
(3498,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 691'),
(3505,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 692'),
(3591,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 700'),
(3708,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 708'),
(3736,@AREA390,0, 'Bruiseweed,Zone 17,Area 390,node 711'),
(3979,@AREA390,0, 'Wild Steelbloom,Zone 17,Area 390,node 727'),
(4066,@AREA390,0, 'Wild Steelbloom,Zone 17,Area 390,node 733'),
(4227,@AREA390,0, 'Wild Steelbloom,Zone 17,Area 390,node 743'),
(4295,@AREA390,0, 'Kingsblood,Zone 17,Area 390,node 748'),
(4330,@AREA390,0, 'Kingsblood,Zone 17,Area 390,node 754'),
(4390,@AREA390,0, 'Kingsblood,Zone 17,Area 390,node 763'),
(4401,@AREA390,0, 'Kingsblood,Zone 17,Area 390,node 764'),
(87281,@AREA390,0, 'Kingsblood,Zone 17,Area 390,node 867'),
(1506,@AREA391,0, 'Peacebloom,Zone 17,Area 391,node 123'),
(1759,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 171'),
(1761,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 172'),
(1776,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 176'),
(1781,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 178'),
(1782,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 179'),
(1783,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 180'),
(1798,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 186'),
(1830,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 197'),
(1837,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 199'),
(1853,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 206'),
(1854,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 207'),
(1855,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 208'),
(1864,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 213'),
(1896,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 216'),
(1897,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 217'),
(1925,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 234'),
(1928,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 236'),
(1957,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 249'),
(1958,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 250'),
(1959,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 251'),
(1960,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 252'),
(1972,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 258'),
(1983,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 264'),
(1984,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 265'),
(2016,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 283'),
(2017,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 284'),
(2018,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 285'),
(2022,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 289'),
(2023,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 290'),
(2028,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 291'),
(2029,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 292'),
(2030,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 293'),
(2050,@AREA391,0, 'Earthroot,Zone 17,Area 391,node 296'),
(2724,@AREA391,0, 'Briarthorn,Zone 17,Area 391,node 575'),
(8232,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 773'),
(8233,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 774'),
(8256,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 776'),
(8280,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 778'),
(8281,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 779'),
(8282,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 780'),
(8294,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 783'),
(8295,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 784'),
(8296,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 785'),
(8317,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 786'),
(8360,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 792'),
(8448,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 800'),
(8457,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 802'),
(8458,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 803'),
(8459,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 804'),
(8460,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 805'),
(8461,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 806'),
(8504,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 809'),
(8505,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 810'),
(8507,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 811'),
(8508,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 812'),
(8527,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 813'),
(8547,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 816'),
(8559,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 817'),
(12594,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 820'),
(15754,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 830'),
(15757,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 833'),
(15758,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 834'),
(15761,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 836'),
(15780,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 837'),
(29187,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 840'),
(29234,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 841'),
(29235,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 842'),
(32508,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 844'),
(32866,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 846'),
(86907,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 852'),
(86909,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 853'),
(86910,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 854'),
(86912,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 855'),
(86927,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 856'),
(86942,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 857'),
(86943,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 858'),
(86946,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 859'),
(86947,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 860'),
(86948,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 861'),
(86949,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 862'),
(86950,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 863'),
(86951,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 864'),
(87006,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 865'),
(87063,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 866'),
(87572,@AREA391,0, 'Stranglekelp,Zone 17,Area 391,node 868'),
(484,@AREA1156,0, 'Silverleaf,Zone 17,Area 1156,node 4'),
(723,@AREA1156,0, 'Silverleaf,Zone 17,Area 1156,node 30'),
(729,@AREA1156,0, 'Silverleaf,Zone 17,Area 1156,node 31'),
(730,@AREA1156,0, 'Silverleaf,Zone 17,Area 1156,node 32'),
(1375,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 99'),
(1395,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 101'),
(1464,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 114'),
(1480,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 118'),
(1505,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 122'),
(1539,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 134'),
(1592,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 144'),
(1594,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 145'),
(1630,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 148'),
(1649,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 153'),
(1662,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 155'),
(1665,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 157'),
(1668,@AREA1156,0, 'Peacebloom,Zone 17,Area 1156,node 159'),
(1757,@AREA1156,0, 'Earthroot,Zone 17,Area 1156,node 170'),
(1793,@AREA1156,0, 'Earthroot,Zone 17,Area 1156,node 183'),
(2103,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 321'),
(2104,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 322'),
(2128,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 330'),
(2143,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 338'),
(2144,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 339'),
(2146,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 341'),
(2147,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 342'),
(2154,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 346'),
(2162,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 351'),
(2171,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 356'),
(2198,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 373'),
(2209,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 383'),
(2228,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 394'),
(2246,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 402'),
(2247,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 403'),
(2257,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 405'),
(2270,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 414'),
(2271,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 415'),
(2277,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 418'),
(2280,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 419'),
(2287,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 422'),
(2304,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 430'),
(2375,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 462'),
(2382,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 465'),
(2397,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 478'),
(2424,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 485'),
(2462,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 499'),
(2463,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 500'),
(2470,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 502'),
(2494,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 513'),
(2495,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 514'),
(2496,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 515'),
(2520,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 526'),
(2522,@AREA1156,0, 'Mageroyal,Zone 17,Area 1156,node 527'),
(2551,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 538'),
(2559,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 540'),
(2565,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 543'),
(2620,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 553'),
(2643,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 557'),
(2677,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 565'),
(2722,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 573'),
(2760,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 587'),
(2770,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 592'),
(2783,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 595'),
(2826,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 603'),
(2857,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 606'),
(2893,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 616'),
(2905,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 619'),
(2907,@AREA1156,0, 'Briarthorn,Zone 17,Area 1156,node 621'),
(3099,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 639'),
(3100,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 640'),
(3101,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 641'),
(3102,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 642'),
(3103,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 643'),
(3104,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 644'),
(3274,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 661'),
(3703,@AREA1156,0, 'Bruiseweed,Zone 17,Area 1156,node 707'),
(3898,@AREA1156,0, 'Wild Steelbloom,Zone 17,Area 1156,node 720'),
(4085,@AREA1156,0, 'Wild Steelbloom,Zone 17,Area 1156,node 734'),
(4103,@AREA1156,0, 'Wild Steelbloom,Zone 17,Area 1156,node 736'),
(4298,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 749'),
(4342,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 755'),
(4347,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 756'),
(4349,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 757'),
(4373,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 760'),
(4379,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 761'),
(4405,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 766'),
(13368,@AREA1156,0, 'Wild Steelbloom,Zone 17,Area 1156,node 824'),
(13370,@AREA1156,0, 'Wild Steelbloom,Zone 17,Area 1156,node 826'),
(13374,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 827'),
(86316,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 849'),
(86322,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 850'),
(86337,@AREA1156,0, 'Kingsblood,Zone 17,Area 1156,node 851'),
(2091,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 316'),
(2092,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 317'),
(2095,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 318'),
(2099,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 320'),
(2130,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 331'),
(2196,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 372'),
(2219,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 387'),
(2220,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 388'),
(2225,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 391'),
(2258,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 406'),
(2461,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 498'),
(2464,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 501'),
(2471,@AREA1698,0, 'Mageroyal,Zone 17,Area 1698,node 503'),
(2549,@AREA1698,0, 'Briarthorn,Zone 17,Area 1698,node 537'),
(3143,@AREA1698,0, 'Bruiseweed,Zone 17,Area 1698,node 650'),
(3261,@AREA1698,0, 'Bruiseweed,Zone 17,Area 1698,node 656'),
(4153,@AREA1698,0, 'Wild Steelbloom,Zone 17,Area 1698,node 737'),
(4367,@AREA1698,0, 'Kingsblood,Zone 17,Area 1698,node 759'),
(4387,@AREA1698,0, 'Kingsblood,Zone 17,Area 1698,node 762'),
(13365,@AREA1698,0, 'Wild Steelbloom,Zone 17,Area 1698,node 821'),
(620,@AREA1699,0, 'Silverleaf,Zone 17,Area 1699,node 19'),
(681,@AREA1699,0, 'Silverleaf,Zone 17,Area 1699,node 25'),
(878,@AREA1699,0, 'Silverleaf,Zone 17,Area 1699,node 42'),
(935,@AREA1699,0, 'Silverleaf,Zone 17,Area 1699,node 56'),
(1026,@AREA1699,0, 'Silverleaf,Zone 17,Area 1699,node 68'),
(1169,@AREA1699,0, 'Silverleaf,Zone 17,Area 1699,node 88'),
(1346,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 95'),
(1410,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 104'),
(1411,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 105'),
(1412,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 106'),
(1414,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 108'),
(1509,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 124'),
(1511,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 125'),
(1524,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 130'),
(1538,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 133'),
(1667,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 158'),
(1693,@AREA1699,0, 'Peacebloom,Zone 17,Area 1699,node 161'),
(2723,@AREA1699,0, 'Briarthorn,Zone 17,Area 1699,node 574'),
(2729,@AREA1699,0, 'Briarthorn,Zone 17,Area 1699,node 578'),
(2737,@AREA1699,0, 'Briarthorn,Zone 17,Area 1699,node 580'),
(2754,@AREA1699,0, 'Briarthorn,Zone 17,Area 1699,node 584'),
(1419,@AREA1700,0, 'Peacebloom,Zone 17,Area 1700,node 109'),
(1550,@AREA1700,0, 'Peacebloom,Zone 17,Area 1700,node 136'),
(1633,@AREA1700,0, 'Peacebloom,Zone 17,Area 1700,node 149'),
(1661,@AREA1700,0, 'Peacebloom,Zone 17,Area 1700,node 154'),
(1730,@AREA1700,0, 'Peacebloom,Zone 17,Area 1700,node 165'),
(1998,@AREA1700,0, 'Earthroot,Zone 17,Area 1700,node 275'),
(2080,@AREA1700,0, 'Earthroot,Zone 17,Area 1700,node 310'),
(2145,@AREA1700,0, 'Mageroyal,Zone 17,Area 1700,node 340'),
(2188,@AREA1700,0, 'Mageroyal,Zone 17,Area 1700,node 367'),
(2245,@AREA1700,0, 'Mageroyal,Zone 17,Area 1700,node 401'),
(2384,@AREA1700,0, 'Mageroyal,Zone 17,Area 1700,node 467'),
(2436,@AREA1700,0, 'Mageroyal,Zone 17,Area 1700,node 492'),
(2450,@AREA1700,0, 'Mageroyal,Zone 17,Area 1700,node 496'),
(2554,@AREA1700,0, 'Briarthorn,Zone 17,Area 1700,node 539'),
(2574,@AREA1700,0, 'Briarthorn,Zone 17,Area 1700,node 546'),
(2634,@AREA1700,0, 'Briarthorn,Zone 17,Area 1700,node 556'),
(2678,@AREA1700,0, 'Briarthorn,Zone 17,Area 1700,node 566'),
(2824,@AREA1700,0, 'Briarthorn,Zone 17,Area 1700,node 601'),
(2825,@AREA1700,0, 'Briarthorn,Zone 17,Area 1700,node 602'),
(2928,@AREA1700,0, 'Bruiseweed,Zone 17,Area 1700,node 622'),
(2952,@AREA1700,0, 'Bruiseweed,Zone 17,Area 1700,node 626'),
(3049,@AREA1700,0, 'Bruiseweed,Zone 17,Area 1700,node 635'),
(3058,@AREA1700,0, 'Bruiseweed,Zone 17,Area 1700,node 637'),
(3410,@AREA1700,0, 'Bruiseweed,Zone 17,Area 1700,node 677'),
(3852,@AREA1700,0, 'Bruiseweed,Zone 17,Area 1700,node 717'),
(4027,@AREA1700,0, 'Wild Steelbloom,Zone 17,Area 1700,node 730'),
(4275,@AREA1700,0, 'Wild Steelbloom,Zone 17,Area 1700,node 745'),
(4329,@AREA1700,0, 'Kingsblood,Zone 17,Area 1700,node 753'),
(1573,@AREA1701,0, 'Peacebloom,Zone 17,Area 1701,node 141'),
(1792,@AREA1701,0, 'Earthroot,Zone 17,Area 1701,node 182'),
(2159,@AREA1701,0, 'Mageroyal,Zone 17,Area 1701,node 348'),
(2168,@AREA1701,0, 'Mageroyal,Zone 17,Area 1701,node 354'),
(2259,@AREA1701,0, 'Mageroyal,Zone 17,Area 1701,node 407'),
(2562,@AREA1701,0, 'Briarthorn,Zone 17,Area 1701,node 541'),
(2756,@AREA1701,0, 'Briarthorn,Zone 17,Area 1701,node 585'),
(2950,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 624'),
(2951,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 625'),
(3028,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 632'),
(3098,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 638'),
(3201,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 652'),
(3226,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 653'),
(3558,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 696'),
(3692,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 704'),
(3693,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 705'),
(3694,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 706'),
(3862,@AREA1701,0, 'Bruiseweed,Zone 17,Area 1701,node 719'),
(3934,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 723'),
(3937,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 724'),
(3984,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 728'),
(4065,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 732'),
(4097,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 735'),
(4198,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 739'),
(4210,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 741'),
(4223,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 742'),
(4252,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 744'),
(4327,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 752'),
(4355,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 758'),
(4404,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 765'),
(4406,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 767'),
(4442,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 768'),
(4486,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 769'),
(4493,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 770'),
(4496,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 771'),
(13367,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 823'),
(13369,@AREA1701,0, 'Wild Steelbloom,Zone 17,Area 1701,node 825'),
(13375,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 828'),
(13378,@AREA1701,0, 'Kingsblood,Zone 17,Area 1701,node 829'),
(2151,@REST,0, 'Mageroyal,Zone 17,Area 1157,node 343'),
(2281,@REST,0, 'Mageroyal,Zone 17,Area 1157,node 420'),
(2389,@REST,0, 'Mageroyal,Zone 17,Area 1157,node 472'),
(2512,@REST,0, 'Mageroyal,Zone 17,Area 1157,node 523'),
(2523,@REST,0, 'Mageroyal,Zone 17,Area 1157,node 528'),
(3921,@REST,0, 'Wild Steelbloom,Zone 17,Area 1316,node 721'),
(3923,@REST,0, 'Wild Steelbloom,Zone 17,Area 1316,node 722'),
(3957,@REST,0, 'Wild Steelbloom,Zone 17,Area 1316,node 725'),
(3968,@REST,0, 'Wild Steelbloom,Zone 17,Area 1316,node 726'),
(3478,@REST,0, 'Bruiseweed,Zone 17,Area 1697,node 686'),
(4174,@REST,0, 'Wild Steelbloom,Zone 17,Area 1697,node 738'),
(1842,@REST,0, 'Earthroot,Zone 17,Area 1702,node 200'),
(1843,@REST,0, 'Earthroot,Zone 17,Area 1702,node 201'),
(1917,@REST,0, 'Earthroot,Zone 17,Area 1702,node 229'),
(1918,@REST,0, 'Earthroot,Zone 17,Area 1702,node 230'),
(1919,@REST,0, 'Earthroot,Zone 17,Area 1702,node 231'),
(1920,@REST,0, 'Earthroot,Zone 17,Area 1702,node 232'),
(1921,@REST,0, 'Earthroot,Zone 17,Area 1702,node 233'),
(1987,@REST,0, 'Earthroot,Zone 17,Area 1702,node 267'),
(1999,@REST,0, 'Earthroot,Zone 17,Area 1702,node 276'),
(2781,@REST,0, 'Briarthorn,Zone 17,Area 1702,node 594'),
(482,@REST,0, 'Silverleaf,Zone 17,Area 1704,node 3'),
(731,@REST,0, 'Silverleaf,Zone 17,Area 1704,node 33'),
(847,@REST,0, 'Silverleaf,Zone 17,Area 1704,node 40'),
(1373,@REST,0, 'Peacebloom,Zone 17,Area 1704,node 98'),
(1459,@REST,0, 'Peacebloom,Zone 17,Area 1704,node 113'),
(1563,@REST,0, 'Peacebloom,Zone 17,Area 1704,node 139'),
(892,@REST,0, 'Silverleaf,Zone 17,Area 2757,node 44'),
(950,@REST,0, 'Silverleaf,Zone 17,Area 2757,node 60'),
(1138,@REST,0, 'Silverleaf,Zone 17,Area 2757,node 84'),
(2152,@REST,0, 'Mageroyal,Zone 17,Area 359,node 344'),
(2390,@REST,0, 'Mageroyal,Zone 17,Area 359,node 473'),
(2758,@REST,0, 'Briarthorn,Zone 17,Area 359,node 586'),
(3105,@REST,0, 'Bruiseweed,Zone 17,Area 359,node 645'),
(3106,@REST,0, 'Bruiseweed,Zone 17,Area 359,node 646'),
(3107,@REST,0, 'Bruiseweed,Zone 17,Area 359,node 647'),
(3464,@REST,0, 'Bruiseweed,Zone 17,Area 359,node 683'),
(3465,@REST,0, 'Bruiseweed,Zone 17,Area 359,node 684'),
(3524,@REST,0, 'Bruiseweed,Zone 17,Area 359,node 693'),
(4207,@REST,0, 'Wild Steelbloom,Zone 17,Area 359,node 740'),
(1475,@REST,0, 'Peacebloom,Zone 17,Area 378,node 117'),
(1584,@REST,0, 'Peacebloom,Zone 17,Area 378,node 143'),
(3245,@REST,0, 'Bruiseweed,Zone 17,Area 378,node 654'),
(2501,@REST,0, 'Mageroyal,Zone 17,Area 381,node 516'),
(2542,@REST,0, 'Briarthorn,Zone 17,Area 381,node 536'),
(3329,@REST,0, 'Bruiseweed,Zone 17,Area 381,node 666'),
(3854,@REST,0, 'Bruiseweed,Zone 17,Area 381,node 718'),
(1567,@REST,0, 'Peacebloom,Zone 17,Area 382,node 140'),
(3047,@REST,0, 'Bruiseweed,Zone 17,Area 384,node 634'),
(3275,@REST,0, 'Bruiseweed,Zone 17,Area 384,node 662'),
(3276,@REST,0, 'Bruiseweed,Zone 17,Area 384,node 663'),
(3549,@REST,0, 'Bruiseweed,Zone 17,Area 384,node 695'),
(3667,@REST,0, 'Bruiseweed,Zone 17,Area 384,node 703'),
(3734,@REST,0, 'Bruiseweed,Zone 17,Area 384,node 709'),
(3735,@REST,0, 'Bruiseweed,Zone 17,Area 384,node 710'),
(8234,@REST,0, 'Stranglekelp,Zone 17,Area 392,node 775'),
(8444,@REST,0, 'Stranglekelp,Zone 17,Area 392,node 799'),
(15759,@REST,0, 'Stranglekelp,Zone 17,Area 392,node 835'),
(32512,@REST,0, 'Stranglekelp,Zone 17,Area 392,node 845'),
(1779,@REST,0, 'Earthroot,Zone 17,Area 401,node 177'),
(1857,@REST,0, 'Earthroot,Zone 17,Area 401,node 210'),
(8279,@REST,0, 'Stranglekelp,Zone 17,Area 401,node 777'),
(8283,@REST,0, 'Stranglekelp,Zone 17,Area 401,node 781'),
(8288,@REST,0, 'Stranglekelp,Zone 17,Area 401,node 782'),
(8345,@REST,0, 'Stranglekelp,Zone 17,Area 401,node 789'),
(8346,@REST,0, 'Stranglekelp,Zone 17,Area 401,node 790'),
(8347,@REST,0, 'Stranglekelp,Zone 17,Area 401,node 791'),
(32507,@REST,0, 'Stranglekelp,Zone 17,Area 401,node 843'),
(1714,@REST,0, 'Peacebloom,Zone 17,Area 458,node 164'),
(2261,@REST,0, 'Mageroyal,Zone 17,Area 458,node 408'),
(2262,@REST,0, 'Mageroyal,Zone 17,Area 458,node 409'),
(2695,@REST,0, 'Briarthorn,Zone 17,Area 458,node 568'),
(8318,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 787'),
(8339,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 788'),
(8369,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 793'),
(8501,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 808'),
(8534,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 814'),
(8536,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 815'),
(8566,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 818'),
(15781,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 838'),
(15782,@REST,0, 'Stranglekelp,Zone 17,Area 720,node 839'),
(2004,@REST,0, 'Earthroot,Zone 17,Area 815,node 278'),
(2005,@REST,0, 'Earthroot,Zone 17,Area 815,node 279'),
(2234,@REST,0, 'Mageroyal,Zone 17,Area 815,node 400'),
(2253,@REST,0, 'Mageroyal,Zone 17,Area 815,node 404'),
(2311,@REST,0, 'Mageroyal,Zone 17,Area 815,node 433'),
(2333,@REST,0, 'Mageroyal,Zone 17,Area 815,node 441'),
(2334,@REST,0, 'Mageroyal,Zone 17,Area 815,node 442');
