-- ---------------------------
-- -- Northrend Rare Spawns --
-- ---------------------------
SET @GUID = 151934;
SET @EQUIP = 2433;
-- ----------------------
-- -- Template Updates --
-- ----------------------
UPDATE `creature_template` SET `faction_A`=16,`faction_H`=16,`unit_flags`=64,`speed_run`=0.99206285714286 WHERE `entry`=32447; -- Zul'drak Sentinel
UPDATE `creature_template` SET `faction_A`=14,`faction_H`=14,`unit_flags`=32832,`speed_run`=1.1428571428571 WHERE `entry`=32409; -- Crazed Indu'le Survivor
UPDATE `creature_template` SET `faction_A`=14,`faction_H`=14,`unit_flags`=32832,`speed_walk`=2,`speed_run`=2 WHERE `entry`=32422; -- Grocklar
UPDATE `creature_template` SET `faction_A`=16,`faction_H`=16,`unit_flags`=32832,`speed_walk`=2,`speed_run`=2 WHERE `entry`=32429; -- Seething Hate
UPDATE `creature_model_info` SET `bounding_radius`=0.248,`combat_reach`=4,`gender`=0 WHERE `modelid`=26663; -- Grocklar
UPDATE `creature_model_info` SET `bounding_radius`=0.5,`combat_reach`=1,`gender`=2 WHERE `modelid`=18083; -- Seething Hate
UPDATE `creature_model_info` SET `bounding_radius`=0.6076385,`combat_reach`=2.625,`gender`=2 WHERE `modelid`=28284; -- Crazed Indu'le Survivor
UPDATE `creature_template` SET `equipment_id`=@EQUIP,`speed_run`=1.3857142857143 WHERE `entry`=32417; -- Scarlet Highlord Daion

-- -------------------------
-- -- Template_Addon data --
-- -------------------------
DELETE FROM `creature_template_addon` WHERE `entry` IN (32429,32422,32409,32417,32447);
INSERT INTO `creature_template_addon` (`entry`,`mount`,`bytes1`,`bytes2`,`emote`,`auras`) VALUES
(32429,0,0,1,0, '52561 0'), -- Seething Hate
(32422,0,0,1,0, NULL), -- Grocklar
(32409,0,0,1,0, NULL), -- Crazed Indu'le Survivor
(32417,19296,0,1,0, NULL), -- Scarlet Highlord Daion
(32447,0,0,1,0, NULL); -- Zul'drak Sentinel

-- --------------------
-- -- Equipment data --
-- --------------------
DELETE FROM `creature_equip_template` WHERE `entry`=@EQUIP;
INSERT INTO `creature_equip_template` (`entry`,`equipentry1`,`equipentry2`,`equipentry3`) VALUES
(@EQUIP,38175,12932,0);

-- ---------------------
-- -- Creature Spawns --
-- ---------------------
DELETE FROM `creature` WHERE `guid` BETWEEN @GUID AND @GUID+86;
INSERT INTO `creature` (`guid`,`id`,`map`,`spawnMask`,`phaseMask`,`modelid`,`equipment_id`,`position_x`,`position_y`,`position_z`,`orientation`,`spawntimesecs`,`spawndist`,`currentwaypoint`,`curhealth`,`curmana`,`DeathState`,`MovementType`) VALUES
-- Old Crystalbark
(@GUID,32357,571,1,1,0,0,3550.59,7169.73,220.75,0.130042,28800,0,0,13936,3231,0,2),
(@GUID+1,32357,571,1,1,0,0,3792.23,7329.76,196.23,5.38979,28800,0,0,13936,3231,0,2),
(@GUID+2,32357,571,1,1,0,0,3990.13,6574,180.599,2.84903,28800,0,0,13936,3231,0,2),
(@GUID+3,32357,571,1,1,0,0,3733.24,6779.39,156.379,2.8011,28800,0,0,13936,3231,0,2),
-- Fumblub Gearwind
(@GUID+4,32358,571,1,1,0,782,3766.55,4309.43,12.6436,0.814532,28800,0,0,13936,0,0,2), -- Fixed Z
-- Icehorn
(@GUID+5,32361,571,1,1,0,0,3565.27,3635.4,36.3026,1.89603,28800,20,0,13936,0,0,1),
(@GUID+6,32361,571,1,1,0,0,3131.14,3647.86,4.40561,2.64266,28800,0,0,13936,0,0,2),
(@GUID+7,32361,571,1,1,0,0,3122.88,3925.21,25.9087,2.59032,28800,20,0,13936,0,0,1),
-- Crazed Indu'le Survivor
(@GUID+8,32409,571,1,1,0,0,3425.29,1811.42,81.2668,0.434945,28800,5,0,14910,0,0,1),
-- Scarlet Highlord Daion
(@GUID+9,32417,571,1,1,0,0,4105.49,-1132.07,134.27,0.953492,28800,0,0,14910,0,0,2),
(@GUID+10,32417,571,1,1,0,0,4577.47,-602.83,155.108,3.43925,28800,0,0,14910,0,0,2),
(@GUID+11,32417,571,1,1,0,0,4739.51,-373.885,187.437,2.81958,28800,0,0,14910,0,0,2),
(@GUID+12,32417,571,1,1,0,0,4616.39,-411.872,155.531,2.32242,28800,0,0,14910,0,0,2),
-- Perobas the Bloodthirster
(@GUID+13,32377,571,1,1,0,0,2402.76,-5545.49,289.63,6.28297,28800,0,0,13936,0,0,2),
(@GUID+14,32377,571,1,1,0,0,2286.36,-5080.37,254.684,0.376,28800,0,0,13936,0,0,2),
(@GUID+15,32377,571,1,1,0,0,2667.07,-4613.32,253.45,2.52328,28800,0,0,13936,0,0,2),
-- Vigdis the War Maiden
(@GUID+16,32386,571,1,1,0,0,1091.68,-5756.49,233.888,5.71161,28800,0,0,13936,0,0,2),
(@GUID+17,32386,571,1,1,0,0,988.678,-5798.41,252.204,5.48463,28800,15,0,13936,0,0,1),
(@GUID+18,32386,571,1,1,0,0,685.78,-5894.07,289.31,3.23013,28800,15,0,13936,0,0,1),
(@GUID+19,32386,571,1,1,0,0,698.198,-5916.6,291.038,2.11171,28800,0,0,13936,0,0,2),
(@GUID+20,32386,571,1,1,0,0,1537.69,-5810.95,272.362,3.87268,28800,0,0,13936,0,0,2),
(@GUID+21,32386,571,1,1,0,0,1219.76,-5551.19,203.268,4.46259,28800,0,0,13936,0,0,2),
-- King Pin
(@GUID+22,32398,571,1,1,27950,0,827.638,-3283.51,12.2082,3.9619,28800,5,0,13936,0,0,1),
(@GUID+23,32398,571,1,1,0,0,534.88,-2934.28,-0.13,5.13,28800,5,0,13936,0,0,1),
(@GUID+24,32398,571,1,1,0,0,314.914,-3130,34.8139,3.91321,28800,5,0,13936,0,0,1),
(@GUID+25,32398,571,1,1,0,0,23.3933,-3343.96,7.06814,0.594844,28800,0,0,13936,0,0,2),
(@GUID+26,32398,571,1,1,0,0,110.217,-3455.56,10.9399,5.36934,28800,5,0,13936,0,0,1),
-- Tukemuth
(@GUID+27,32400,571,1,1,0,0,4423.2,-191.606,86.97,2.2154,28800,0,0,39760,0,0,2),
(@GUID+28,32400,571,1,1,0,0,4257.03,-245.357,71.873,0.90693,28800,0,0,39760,0,0,2),
(@GUID+29,32400,571,1,1,0,0,4171.21,-107.972,66.5049,0.678376,28800,0,0,39760,0,0,2),
(@GUID+30,32400,571,1,1,0,0,4117.19,339.269,56.2234,4.64336,28800,0,0,39760,0,0,2),
(@GUID+31,32400,571,1,1,0,0,3757.18,-256.696,76.8022,1.93109,28800,0,0,39760,0,0,2),
(@GUID+32,32400,571,1,1,0,0,3831,362.401,34.2447,4.3449,28800,0,0,39760,0,0,2),
(@GUID+33,32400,571,1,1,0,0,3327.3,632.078,83.1728,5.52535,28800,0,0,39760,0,0,2),
(@GUID+34,32400,571,1,1,0,0,3424.75,-224.108,75.47,1.22373,28800,0,0,39760,0,0,2),
-- Grocklar
(@GUID+35,32422,571,1,1,0,0,3570.74,-1748.55,160.909,0.577843,28800,0,0,41128,0,0,2),
(@GUID+36,32422,571,1,1,0,0,3568.53,-2418.75,139.732,3.53036,28800,0,0,41128,0,0,2),
(@GUID+37,32422,571,1,1,0,0,3061.42,-1840.03,66.0206,6.06678,28800,0,0,41128,0,0,2),
(@GUID+38,32422,571,1,1,0,0,4028.69,-1717.33,200.062,4.76214,28800,0,0,41128,0,0,2),
(@GUID+39,32422,571,1,1,0,0,2969.77,-2260.25,65.7,1.53929,28800,0,0,41128,0,0,2),
(@GUID+40,32422,571,1,1,0,0,3588.57,-2184.77,137.255,0.374254,28800,0,0,41128,0,0,2),
-- Seething Hate
(@GUID+41,32429,571,1,1,0,0,3913.28,-2804.43,176.136,1.75467,28800,0,0,14910,0,0,2),
(@GUID+42,32429,571,1,1,0,0,3601.19,-3275.54,222.069,4.60829,28800,0,0,14910,0,0,2),
(@GUID+43,32429,571,1,1,0,0,3972.31,-2710.12,165.749,6.28272,28800,0,0,14910,0,0,2),
-- Syreian the Bonecarver
(@GUID+44,32438,571,1,1,0,1660,4064.03,-4598.68,174.644,5.63537,28800,5,0,14910,0,0,1),
(@GUID+45,32438,571,1,1,0,1660,4263.49,-4476.45,189.827,5.73447,28800,0,0,14910,0,0,2),
(@GUID+46,32438,571,1,1,0,1660,4162.44,-4622,140.978,4.71489,28800,5,0,14910,0,0,1),
(@GUID+47,32438,571,1,1,0,1660,4341.29,-4776.17,52.0998,4.73701,28800,5,0,14910,0,0,1),
(@GUID+48,32438,571,1,1,0,1660,4435.31,-4528.65,115.486,4.76371,28800,5,0,14910,0,0,1),
(@GUID+49,32438,571,1,1,0,1660,4582.12,-4714.61,62.4486,4.75272,28800,5,0,14910,0,0,1),
-- Hildana Deathstealer
(@GUID+50,32495,571,1,1,0,0,7514.08,3663.15,623.327,5.33787,3600,0,0,18900,5991,0,0),
(@GUID+51,32495,571,1,1,0,0,8360.11,3510.63,655.052,3.11519,3600,0,0,18900,5991,0,0),
(@GUID+52,32495,571,1,1,0,0,8459.92,3147.1,588.143,3.932,3600,0,0,18900,5991,0,0),
(@GUID+53,32495,571,1,1,0,0,6800.17,1774.63,569.475,4.94124,3600,0,0,18900,5991,0,0),
-- High Thane Jorfus
(@GUID+54,32501,571,1,1,0,0,6155.1,2377.94,510.346,5.46898,28800,5,0,18900,0,0,1),
(@GUID+55,32501,571,1,1,0,0,7711.4,1029.98,446.606,4.69297,28800,5,0,18900,0,0,1),
(@GUID+56,32501,571,1,1,0,0,6525.8,3309.78,665.388,5.66139,28800,5,0,18900,0,0,1),
-- Terror Spinner
(@GUID+57,32475,571,1,1,0,0,6711.42,-4186.12,456.852,5.50739,28800,20,0,16502,0,0,1),
(@GUID+58,32475,571,1,1,0,0,6704.23,-4205.16,458.033,4.71414,28800,20,0,16502,0,0,1),
(@GUID+59,32475,571,1,1,0,0,6554.22,-4523.84,450.781,2.6564,28800,20,0,16502,0,0,1),
(@GUID+60,32475,571,1,1,0,0,6704.23,-4205.16,458.033,4.71414,28800,20,0,16502,0,0,1),
-- Griegen
(@GUID+61,32471,571,1,1,0,0,5115.49,-1652.65,234.728,2.96739,28800,0,0,15952,0,0,2),
(@GUID+62,32471,571,1,1,0,0,5326.75,-1479.26,238.009,3.02158,28800,0,0,15952,0,0,2),
(@GUID+63,32471,571,1,1,0,0,5596.75,-1742.88,239.19,0.406713,28800,0,0,15952,0,0,2),
(@GUID+64,32471,571,1,1,0,0,5314.94,-1939.21,238.942,0.458038,28800,0,0,15952,0,0,2),
(@GUID+65,32471,571,1,1,0,0,5791.11,-1302.72,234.538,4.79067,28800,10,0,15952,0,0,1),
(@GUID+66,32471,571,1,1,0,0,5327.54,-1702.84,238.882,4.63875,28800,10,0,15952,0,0,1),
(@GUID+67,32471,571,1,1,0,0,5133.37,-1853.51,245.385,4.72044,28800,10,0,15952,0,0,1),
-- King Krush
(@GUID+68,32485,571,1,1,0,0,4865.04,4679.54,-69.2385,1.14987,28800,0,0,42540,0,0,2),
(@GUID+69,32485,571,1,1,0,0,6087.94,4603.13,-96.8083,2.44102,28800,0,0,42540,0,0,2),
-- Aotona
(@GUID+70,32481,571,1,1,0,0,5368.74,4427.76,-133.397,0.206642,28800,20,0,15952,0,0,1),
(@GUID+71,32481,571,1,1,0,0,5803.02,4564.18,-135.413,2.00913,28800,20,0,15952,0,0,1),
(@GUID+72,32481,571,1,1,0,0,5286.53,4998.04,-134.7,5.46489,28800,20,0,15952,0,0,1),
(@GUID+73,32481,571,1,1,0,0,5591.7,5192.67,-133.378,0.631543,28800,20,0,15952,0,0,1),
(@GUID+74,32481,571,1,1,0,0,5777.08,5070.89,-136.107,3.63961,28800,20,0,15952,0,0,1),
(@GUID+75,32481,571,1,1,0,0,5762.37,5001.74,-127.39,3.13774,28800,20,0,15952,0,0,1),
-- Dirkee
(@GUID+76,32500,571,1,1,0,0,8392.22,-1189.11,927.468,1.73202,28800,20,0,50400,3994,0,1),
(@GUID+77,32500,571,1,1,0,0,7751.04,-1099.42,926.238,2.84729,28800,20,0,50400,3994,0,1),
(@GUID+78,32500,571,1,1,0,0,7290.77,-1119.28,938.286,0.26333,28800,20,0,50400,3994,0,1),
(@GUID+79,32500,571,1,1,0,0,7934.73,-3183.8,862.21,4.21701,28800,20,0,50400,3994,0,1),
-- Putridus the Ancient
(@GUID+80,32487,571,1,1,0,0,6726.491,2521.456,428.1825,0.130042,28800,0,0,1,0,0,2),
(@GUID+81,32487,571,1,1,0,0,7812.443,2103.041,380.3420,0.130042,28800,0,0,1,0,0,2),
(@GUID+82,32487,571,1,1,0,0,7609.677,1477.351,330.2054,0.130042,28800,0,0,1,0,0,2),
(@GUID+83,32487,571,1,1,0,0,7190.445,1270.757,302.0640,0.130042,28800,0,0,1,0,0,2),
(@GUID+84,32487,571,1,1,0,0,7049.174,1225.784,295.9547,0.130042,28800,0,0,1,0,0,2),
-- Zul Drak Sentinel
(@GUID+85,32447,571,1,1,0,0,5693.950,-2871.760,274.5770,0.130042,28800,0,0,1,0,0,2),
(@GUID+86,32447,571,1,1,0,0,4914.310,-1661.770,248.3090,0.130042,28800,0,0,1,0,0,2);

-- -------------------------------
-- -- DefiningPooling_templates --
-- -------------------------------
DELETE FROM `pool_template` WHERE `entry` BETWEEN 1086 AND 1106;
INSERT INTO `pool_template` (`entry`,`max_limit`,`description`) VALUES
(1086,1, 'Old Crystalbark Rare Spawn (1 out 4)'),
(1087,1, 'Fumblub Gearwind Rare Spawn (1 out 1)'),
(1088,1, 'Icehorn Rare Spawn (1 out 3)'),
(1089,1, 'Crazed Indu le Survivor Rare Spawn (1 out 1)'),
(1090,1, 'Scarlet Highlord Daion Rare Spawn (1 out 4)'),
(1091,1, 'Perobas the Bloodthirster Rare Spawn (1 out 3)'),
(1092,1, 'Vigdis the War Maiden Rare Spawn (1 out 6)'),
(1093,1, 'King Pin Rare Spawn (1 out 5)'),
(1094,1, 'Tukemuth Rare Spawn (1 out 8)'),
(1095,1, 'Grocklar Rare Spawn (1 out 6)'),
(1096,1, 'Seething Hate Rare Spawn (1 out 3)'),
(1097,1, 'Syreian the Bonecarver Rare Spawn (1 out 6)'),
(1098,1, 'Hildana Deathstealer Rare Spawn (1 out 4)'),
(1099,1, 'High Thane Jorfus Rare Spawn (1 out 3)'),
(1100,1, 'Terror Spinner Rare Spawn (1 out 4)'),
(1101,1, 'Griegen Rare Spawn (1 out 7)'),
(1102,1, 'King Krush Rare Spawn (1 out 2)'),
(1103,1, 'Aotona Rare Spawn (1 out 6)'),
(1104,1, 'Dirkee Rare Spawn (1 out 4)'),
(1105,1, 'Putridus the Ancient Rare Spawn (1 out 5)'),
(1106,1, 'Zul Drak Sentinel Rare Spawn (1 out 2)');
-- ------------------------
-- -- Pooling the Spawns --
-- ------------------------
DELETE FROM `pool_creature` WHERE `pool_entry` BETWEEN 1086 AND 1106;
INSERT INTO `pool_creature` (`guid`,`pool_entry`,`chance`,`description`) VALUES
(@GUID+0,1086,0,  'Old Crystalbark - Spawnlocation 1'),
(@GUID+1,1086,0,  'Old Crystalbark - Spawnlocation 2'),
(@GUID+2,1086,0,  'Old Crystalbark - Spawnlocation 3'),
(@GUID+3,1086,0,  'Old Crystalbark - Spawnlocation 4'),
(@GUID+4,1087,100, 'Fumblub Gearwind - Spawnlocation 1'),
(@GUID+5,1088,0,  'Icehorn - Spawnlocation 1'),
(@GUID+6,1088,0,  'Icehorn Spawnlocation 2'),
(@GUID+7,1088,0,  'Icehorn Spawnlocation 3'),
(@GUID+8,1089,100, 'Crazed Indu le Survivor - Spawnlocation 1'),
(@GUID+9,1090,0,  'Scarlet Highlord Daion Spawnlocation 1'),
(@GUID+10,1090,0, 'Scarlet Highlord Daion Spawnlocation 2'),
(@GUID+11,1090,0, 'Scarlet Highlord Daion Spawnlocation 3'),
(@GUID+12,1090,0, 'Scarlet Highlord Daion Spawnlocation 4'),
(@GUID+13,1091,0, 'Perobas the Bloodthirster Spawnlocation 1'),
(@GUID+14,1091,0, 'Perobas the Bloodthirster Spawnlocation 2'),
(@GUID+15,1091,0, 'Perobas the Bloodthirster Spawnlocation 3'),
(@GUID+16,1092,0, 'Vigdis the War Maiden Spawnlocation 1'),
(@GUID+17,1092,0, 'Vigdis the War Maiden Spawnlocation 2'),
(@GUID+18,1092,0, 'Vigdis the War Maiden Spawnlocation 3'),
(@GUID+19,1092,0, 'Vigdis the War Maiden Spawnlocation 4'),
(@GUID+20,1092,0, 'Vigdis the War Maiden Spawnlocation 5'),
(@GUID+21,1092,0, 'Vigdis the War Maiden Spawnlocation 6'),
(@GUID+22,1093,0, 'King Pin Spawnlocation 1'),
(@GUID+23,1093,0, 'King Pin Spawnlocation 2'),
(@GUID+24,1093,0, 'King Pin Spawnlocation 3'),
(@GUID+25,1093,0, 'King Pin Spawnlocation 4'),
(@GUID+26,1093,0, 'King Pin Spawnlocation 5'),
(@GUID+27,1094,0, 'Tukemuth Spawnlocation 1'),
(@GUID+28,1094,0, 'Tukemuth Spawnlocation 2'),
(@GUID+29,1094,0, 'Tukemuth Spawnlocation 3'),
(@GUID+30,1094,0, 'Tukemuth Spawnlocation 4'),
(@GUID+31,1094,0, 'Tukemuth Spawnlocation 5'),
(@GUID+32,1094,0, 'Tukemuth Spawnlocation 6'),
(@GUID+33,1094,0, 'Tukemuth Spawnlocation 7'),
(@GUID+34,1094,0, 'Tukemuth Spawnlocation 8'),
(@GUID+35,1095,0, 'Grocklar Spawnlocation 1'),
(@GUID+36,1095,0, 'Grocklar Spawnlocation 2'),
(@GUID+37,1095,0, 'Grocklar Spawnlocation 3'),
(@GUID+38,1095,0, 'Grocklar Spawnlocation 4'),
(@GUID+39,1095,0, 'Grocklar Spawnlocation 5'),
(@GUID+40,1095,0, 'Grocklar Spawnlocation 6'),
(@GUID+41,1096,0, 'Seething Hate Spawnlocation 1'),
(@GUID+42,1096,0, 'Seething Hate Spawnlocation 2'),
(@GUID+43,1096,0, 'Seething Hate Spawnlocation 3'),
(@GUID+44,1097,0, 'Syreian the Bonecarver Spawnlocation 1'),
(@GUID+45,1097,0, 'Syreian the Bonecarver Spawnlocation 2'),
(@GUID+46,1097,0, 'Syreian the Bonecarver Spawnlocation 3'),
(@GUID+47,1097,0, 'Syreian the Bonecarver Spawnlocation 4'),
(@GUID+48,1097,0, 'Syreian the Bonecarver Spawnlocation 5'),
(@GUID+49,1097,0, 'Syreian the Bonecarver Spawnlocation 6'),
(@GUID+50,1098,0, 'Hildana Deathstealer Spawnlocation 1'),
(@GUID+51,1098,0, 'Hildana Deathstealer Spawnlocation 2'),
(@GUID+52,1098,0, 'Hildana Deathstealer Spawnlocation 3'),
(@GUID+53,1098,0, 'Hildana Deathstealer Spawnlocation 4'),
(@GUID+54,1099,0, 'High Thane Jorfus Spawnlocation 1'),
(@GUID+55,1099,0, 'High Thane Jorfus Spawnlocation 2'),
(@GUID+56,1099,0, 'High Thane Jorfus Spawnlocation 3'),
(@GUID+57,1100,0, 'Terror Spinner Spawnlocation 1'),
(@GUID+58,1100,0, 'Terror Spinner Spawnlocation 2'),
(@GUID+59,1100,0, 'Terror Spinner Spawnlocation 3'),
(@GUID+60,1100,0, 'Terror Spinner Spawnlocation 4'),
(@GUID+61,1101,0, 'Griegen Spawnlocation 1'),
(@GUID+62,1101,0, 'Griegen Spawnlocation 2'),
(@GUID+63,1101,0, 'Griegen Spawnlocation 3'),
(@GUID+64,1101,0, 'Griegen Spawnlocation 4'),
(@GUID+65,1101,0, 'Griegen Spawnlocation 5'),
(@GUID+66,1101,0, 'Griegen Spawnlocation 6'),
(@GUID+67,1101,0, 'Griegen Spawnlocation 7'),
(@GUID+68,1102,0, 'King Krush Spawnlocation 1'),
(@GUID+69,1102,0, 'King Krush Spawnlocation 2'),
(@GUID+70,1103,0, 'Aotona Spawnlocation 1'),
(@GUID+71,1103,0, 'Aotona Spawnlocation 2'),
(@GUID+72,1103,0, 'Aotona Spawnlocation 3'),
(@GUID+73,1103,0, 'Aotona Spawnlocation 4'),
(@GUID+74,1103,0, 'Aotona Spawnlocation 5'),
(@GUID+75,1103,0, 'Aotona Spawnlocation 6'),
(@GUID+76,1104,0, 'Dirkee Spawnlocation 1'),
(@GUID+77,1104,0, 'Dirkee Spawnlocation 2'),
(@GUID+78,1104,0, 'Dirkee Spawnlocation 3'),
(@GUID+79,1104,0, 'Dirkee Spawnlocation 4'),
(@GUID+80,1105,0, 'Putridus the Ancient Spawnlocation 1'),
(@GUID+81,1105,0, 'Putridus the Ancient Spawnlocation 2'),
(@GUID+82,1105,0, 'Putridus the Ancient Spawnlocation 3'),
(@GUID+83,1105,0, 'Putridus the Ancient Spawnlocation 4'),
(@GUID+84,1105,0, 'Putridus the Ancient Spawnlocation 5'),
(@GUID+85,1106,0, 'Zul Drak Sentinel Spawnlocation 1'),
(@GUID+86,1106,0, 'Zul Drak Sentinel Spawnlocation 2');

-- -----------------------
-- -- Creature Pathings --
-- -----------------------
-- Putridus the Ancient SAI
SET @ENTRY := 32487;
SET @SPELL1 := 61080; -- Putrid Punt
SET @SPELL2 := 41534; -- War Stomp
UPDATE `creature_template` SET `AIName`='SmartAI' WHERE `entry`=@ENTRY;
DELETE FROM `smart_scripts` WHERE `source_type`=0 AND `entryorguid`=@ENTRY;
INSERT INTO `smart_scripts` (`entryorguid`,`source_type`,`id`,`link`,`event_type`,`event_phase_mask`,`event_chance`,`event_flags`,`event_param1`,`event_param2`,`event_param3`,`event_param4`,`action_type`,`action_param1`,`action_param2`,`action_param3`,`action_param4`,`action_param5`,`action_param6`,`target_type`,`target_param1`,`target_param2`,`target_param3`,`target_x`,`target_y`,`target_z`,`target_o`,`comment`) VALUES
(@ENTRY,0,0,0,0,0,100,0,7000,8000,8000,9000,11,@SPELL1,1,0,0,0,0,2,0,0,0,0,0,0,0,'Putridus the Ancient - Combat - Cast Putrid Punt'),
(@ENTRY,0,1,0,0,0,100,0,6000,7000,12000,12000,11,@SPELL2,1,0,0,0,0,2,0,0,0,0,0,0,0,'Putridus the Ancient - Combat - Cast War Stomp');
-- Pathing for Putridus the Ancient Entry: 32487
SET @PATH := @GUID+80 * 10;
DELETE FROM `creature_addon` WHERE `guid`=@GUID+80;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@GUID+80,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,6682.528,2498.002,433.9948,0,0,0,100,0),
(@PATH,2,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,3,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,4,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,5,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,6,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,7,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,8,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,9,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,10,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,11,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,12,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,13,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,14,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,15,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,16,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,17,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,18,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,19,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,20,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,21,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,22,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,23,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,24,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,25,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,26,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,27,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,28,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,29,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,30,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,31,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,32,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,33,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,34,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,35,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,36,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,37,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,38,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,39,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,40,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,41,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,42,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,43,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,44,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,45,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,46,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,47,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,48,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,49,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,50,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,51,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,52,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,53,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,54,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,55,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,56,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,57,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,58,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,59,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,60,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,61,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,62,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,63,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,64,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,65,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,66,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,67,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,68,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,69,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,70,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,71,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,72,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,73,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,74,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,75,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,76,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,77,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,78,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,79,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,80,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,81,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,82,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,83,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,84,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,85,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,86,6671.106,1128.045,274.4435,0,0,0,100,0),
(@PATH,87,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,88,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,89,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,90,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,91,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,92,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,93,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,94,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,95,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,96,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,97,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,98,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,99,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,100,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,101,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,102,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,103,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,104,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,105,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,106,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,107,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,108,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,109,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,110,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,111,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,112,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,113,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,114,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,115,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,116,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,117,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,118,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,119,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,120,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,121,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,122,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,123,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,124,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,125,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,126,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,127,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,128,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,129,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,130,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,131,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,132,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,133,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,134,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,135,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,136,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,137,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,138,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,139,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,140,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,141,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,142,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,143,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,144,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,145,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,146,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,147,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,148,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,149,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,150,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,151,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,152,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,153,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,154,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,155,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,156,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,157,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,158,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,159,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,160,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,161,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,162,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,163,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,164,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,165,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,166,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,167,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,168,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,169,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,170,6726.491,2521.456,428.1825,0,0,0,100,0);
-- Pathing for Putridus the Ancient Entry: 32487
SET @PATH := @GUID+81 * 10;
DELETE FROM `creature_addon` WHERE `guid`=@GUID+81;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@GUID+81,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,2,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,3,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,4,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,5,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,6,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,7,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,8,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,9,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,10,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,11,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,12,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,13,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,14,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,15,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,16,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,17,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,18,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,19,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,20,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,21,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,22,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,23,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,24,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,25,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,26,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,27,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,28,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,29,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,30,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,31,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,32,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,33,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,34,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,35,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,36,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,37,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,38,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,39,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,40,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,41,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,42,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,43,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,44,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,45,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,46,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,47,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,48,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,49,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,50,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,51,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,52,6671.106,1128.045,274.4435,0,0,0,100,0),
(@PATH,53,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,54,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,55,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,56,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,57,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,58,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,59,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,60,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,61,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,62,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,63,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,64,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,65,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,66,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,67,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,68,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,69,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,70,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,71,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,72,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,73,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,74,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,75,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,76,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,77,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,78,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,79,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,80,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,81,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,82,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,83,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,84,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,85,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,86,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,87,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,88,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,89,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,90,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,91,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,92,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,93,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,94,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,95,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,96,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,97,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,98,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,99,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,100,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,101,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,102,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,103,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,104,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,105,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,106,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,107,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,108,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,109,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,110,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,111,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,112,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,113,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,114,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,115,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,116,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,117,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,118,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,119,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,120,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,121,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,122,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,123,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,124,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,125,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,126,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,127,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,128,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,129,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,130,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,131,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,132,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,133,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,134,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,135,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,136,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,137,6682.528,2498.002,433.9948,0,0,0,100,0),
(@PATH,138,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,139,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,140,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,141,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,142,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,143,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,144,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,145,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,146,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,147,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,148,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,149,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,150,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,151,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,152,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,153,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,154,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,155,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,156,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,157,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,158,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,159,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,160,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,161,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,162,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,163,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,164,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,165,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,166,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,167,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,168,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,169,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,170,7812.443,2103.041,380.3420,0,0,0,100,0);
-- Pathing for Putridus the Ancient Entry: 32487
SET @PATH := @GUID+82 * 10;
DELETE FROM `creature_addon` WHERE `guid`=@GUID+82;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@GUID+82,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,2,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,3,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,4,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,5,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,6,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,7,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,8,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,9,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,10,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,11,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,12,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,13,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,14,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,15,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,16,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,17,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,18,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,19,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,20,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,21,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,22,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,23,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,24,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,25,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,26,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,27,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,28,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,29,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,30,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,31,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,32,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,33,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,34,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,35,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,36,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,37,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,38,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,39,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,40,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,41,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,42,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,43,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,44,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,45,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,46,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,47,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,48,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,49,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,50,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,51,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,52,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,53,6682.528,2498.002,433.9948,0,0,0,100,0),
(@PATH,54,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,55,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,56,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,57,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,58,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,59,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,60,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,61,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,62,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,63,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,64,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,65,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,66,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,67,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,68,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,69,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,70,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,71,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,72,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,73,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,74,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,75,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,76,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,77,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,78,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,79,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,80,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,81,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,82,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,83,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,84,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,85,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,86,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,87,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,88,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,89,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,90,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,91,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,92,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,93,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,94,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,95,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,96,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,97,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,98,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,99,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,100,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,101,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,102,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,103,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,104,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,105,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,106,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,107,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,108,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,109,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,110,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,111,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,112,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,113,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,114,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,115,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,116,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,117,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,118,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,119,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,120,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,121,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,122,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,123,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,124,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,125,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,126,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,127,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,128,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,129,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,130,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,131,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,132,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,133,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,134,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,135,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,136,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,137,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,138,6671.106,1128.045,274.4435,0,0,0,100,0),
(@PATH,139,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,140,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,141,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,142,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,143,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,144,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,145,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,146,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,147,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,148,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,149,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,150,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,151,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,152,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,153,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,154,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,155,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,156,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,157,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,158,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,159,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,160,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,161,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,162,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,163,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,164,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,165,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,166,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,167,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,168,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,169,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,170,7609.677,1477.351,330.2054,0,0,0,100,0);
-- Pathing for Putridus the Ancient Entry: 32487
SET @PATH := @GUID+83 * 10;
DELETE FROM `creature_addon` WHERE `guid`=@GUID+83;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@GUID+83,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,2,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,3,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,4,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,5,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,6,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,7,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,8,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,9,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,10,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,11,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,12,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,13,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,14,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,15,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,16,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,17,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,18,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,19,6671.106,1128.045,274.4435,0,0,0,100,0),
(@PATH,20,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,21,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,22,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,23,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,24,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,25,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,26,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,27,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,28,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,29,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,30,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,31,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,32,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,33,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,34,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,35,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,36,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,37,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,38,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,39,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,40,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,41,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,42,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,43,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,44,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,45,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,46,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,47,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,48,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,49,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,50,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,51,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,52,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,53,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,54,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,55,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,56,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,57,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,58,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,59,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,60,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,61,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,62,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,63,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,64,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,65,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,66,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,67,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,68,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,69,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,70,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,71,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,72,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,73,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,74,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,75,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,76,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,77,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,78,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,79,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,80,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,81,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,82,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,83,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,84,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,85,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,86,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,87,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,88,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,89,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,90,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,91,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,92,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,93,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,94,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,95,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,96,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,97,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,98,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,99,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,100,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,101,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,102,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,103,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,104,6682.528,2498.002,433.9948,0,0,0,100,0),
(@PATH,105,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,106,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,107,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,108,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,109,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,110,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,111,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,112,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,113,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,114,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,115,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,116,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,117,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,118,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,119,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,120,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,121,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,122,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,123,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,124,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,125,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,126,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,127,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,128,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,129,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,130,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,131,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,132,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,133,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,134,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,135,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,136,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,137,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,138,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,139,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,140,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,141,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,142,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,143,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,144,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,145,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,146,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,147,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,148,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,149,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,150,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,151,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,152,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,153,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,154,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,155,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,156,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,157,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,158,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,159,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,160,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,161,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,162,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,163,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,164,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,165,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,166,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,167,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,168,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,169,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,170,7190.445,1270.757,302.0640,0,0,0,100,0);
-- Pathing for Putridus the Ancient Entry: 32487
SET @PATH := @GUID+84 * 10;
DELETE FROM `creature_addon` WHERE `guid`=@GUID+84;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@GUID+84,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,2,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,3,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,4,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,5,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,6,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,7,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,8,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,9,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,10,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,11,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,12,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,13,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,14,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,15,6671.106,1128.045,274.4435,0,0,0,100,0),
(@PATH,16,6693.807,1148.469,273.6163,0,0,0,100,0),
(@PATH,17,6708.991,1156.622,274.5040,0,0,0,100,0),
(@PATH,18,6734.180,1152.155,275.0406,0,0,0,100,0),
(@PATH,19,6757.009,1150.346,275.5406,0,0,0,100,0),
(@PATH,20,6778.632,1167.743,275.3220,0,0,0,100,0),
(@PATH,21,6810.069,1170.602,278.5624,0,0,0,100,0),
(@PATH,22,6845.187,1154.830,281.7770,0,0,0,100,0),
(@PATH,23,6882.745,1177.818,284.5468,0,0,0,100,0),
(@PATH,24,6914.853,1191.724,288.5059,0,0,0,100,0),
(@PATH,25,6945.642,1200.520,292.3016,0,0,0,100,0),
(@PATH,26,6968.840,1205.214,302.3910,0,0,0,100,0),
(@PATH,27,6974.230,1206.504,304.6984,0,0,0,100,0),
(@PATH,28,7005.839,1214.057,306.8951,0,0,0,100,0),
(@PATH,29,7038.954,1222.982,295.8718,0,0,0,100,0),
(@PATH,30,7049.174,1225.784,295.9547,0,0,0,100,0),
(@PATH,31,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,32,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,33,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,34,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,35,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,36,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,37,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,38,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,39,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,40,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,41,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,42,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,43,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,44,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,45,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,46,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,47,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,48,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,49,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,50,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,51,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,52,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,53,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,54,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,55,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,56,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,57,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,58,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,59,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,60,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,61,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,62,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,63,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,64,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,65,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,66,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,67,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,68,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,69,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,70,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,71,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,72,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,73,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,74,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,75,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,76,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,77,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,78,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,79,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,80,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,81,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,82,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,83,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,84,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,85,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,86,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,87,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,88,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,89,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,90,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,91,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,92,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,93,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,94,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,95,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,96,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,97,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,98,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,99,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,100,6682.528,2498.002,433.9948,0,0,0,100,0),
(@PATH,101,6726.491,2521.456,428.1825,0,0,0,100,0),
(@PATH,102,6763.606,2540.764,424.1843,0,0,0,100,0),
(@PATH,103,6798.884,2566.029,418.5891,0,0,0,100,0),
(@PATH,104,6840.742,2591.737,413.0497,0,0,0,100,0),
(@PATH,105,6881.453,2615.144,409.9131,0,0,0,100,0),
(@PATH,106,6918.779,2634.562,405.9561,0,0,0,100,0),
(@PATH,107,6958.574,2641.570,401.6977,0,0,0,100,0),
(@PATH,108,7005.859,2647.866,399.2826,0,0,0,100,0),
(@PATH,109,7046.561,2646.076,397.9875,0,0,0,100,0),
(@PATH,110,7080.877,2647.094,397.3363,0,0,0,100,0),
(@PATH,111,7124.366,2648.242,395.8636,0,0,0,100,0),
(@PATH,112,7161.439,2649.354,395.0137,0,0,0,100,0),
(@PATH,113,7199.069,2648.609,394.5688,0,0,0,100,0),
(@PATH,114,7239.180,2647.334,392.9237,0,0,0,100,0),
(@PATH,115,7285.470,2636.182,393.9926,0,0,0,100,0),
(@PATH,116,7315.738,2608.110,393.2762,0,0,0,100,0),
(@PATH,117,7348.643,2572.670,392.2311,0,0,0,100,0),
(@PATH,118,7370.756,2530.682,392.1492,0,0,0,100,0),
(@PATH,119,7395.200,2496.757,391.2005,0,0,0,100,0),
(@PATH,120,7424.339,2472.582,388.7454,0,0,0,100,0),
(@PATH,121,7456.768,2452.186,385.1945,0,0,0,100,0),
(@PATH,122,7497.301,2428.523,382.9902,0,0,0,100,0),
(@PATH,123,7538.836,2402.540,380.5944,0,0,0,100,0),
(@PATH,124,7581.293,2376.074,376.8400,0,0,0,100,0),
(@PATH,125,7618.725,2352.308,374.1796,0,0,0,100,0),
(@PATH,126,7653.262,2329.615,373.0400,0,0,0,100,0),
(@PATH,127,7687.885,2305.656,370.4056,0,0,0,100,0),
(@PATH,128,7726.067,2275.610,369.6468,0,0,0,100,0),
(@PATH,129,7757.738,2242.657,369.2574,0,0,0,100,0),
(@PATH,130,7780.571,2213.544,367.9858,0,0,0,100,0),
(@PATH,131,7798.583,2186.587,366.9403,0,0,0,100,0),
(@PATH,132,7811.335,2150.569,364.6897,0,0,0,100,0),
(@PATH,133,7812.443,2103.041,380.3420,0,0,0,100,0),
(@PATH,134,7812.340,2079.998,389.7163,0,0,0,100,0),
(@PATH,135,7812.245,2058.403,392.1172,0,0,0,100,0),
(@PATH,136,7812.190,2036.709,389.5194,0,0,0,100,0),
(@PATH,137,7812.143,2014.416,380.2727,0,0,0,100,0),
(@PATH,138,7811.477,1974.489,367.6566,0,0,0,100,0),
(@PATH,139,7811.252,1937.083,365.6089,0,0,0,100,0),
(@PATH,140,7810.860,1897.173,363.0266,0,0,0,100,0),
(@PATH,141,7785.744,1870.642,361.4379,0,0,0,100,0),
(@PATH,142,7743.309,1851.258,357.4115,0,0,0,100,0),
(@PATH,143,7699.728,1829.282,355.4451,0,0,0,100,0),
(@PATH,144,7696.018,1791.864,351.5138,0,0,0,100,0),
(@PATH,145,7702.002,1751.072,346.2082,0,0,0,100,0),
(@PATH,146,7723.843,1723.729,344.1997,0,0,0,100,0),
(@PATH,147,7727.404,1690.751,342.8039,0,0,0,100,0),
(@PATH,148,7711.238,1670.327,340.3039,0,0,0,100,0),
(@PATH,149,7689.874,1631.565,336.2794,0,0,0,100,0),
(@PATH,150,7668.053,1600.292,334.6544,0,0,0,100,0),
(@PATH,151,7645.275,1559.671,332.7607,0,0,0,100,0),
(@PATH,152,7632.163,1515.536,331.6975,0,0,0,100,0),
(@PATH,153,7609.677,1477.351,330.2054,0,0,0,100,0),
(@PATH,154,7579.112,1452.958,327.5829,0,0,0,100,0),
(@PATH,155,7539.097,1427.456,324.4498,0,0,0,100,0),
(@PATH,156,7519.051,1409.884,321.9337,0,0,0,100,0),
(@PATH,157,7501.126,1376.004,319.7974,0,0,0,100,0),
(@PATH,158,7460.677,1369.438,314.6037,0,0,0,100,0),
(@PATH,159,7419.581,1363.374,312.0828,0,0,0,100,0),
(@PATH,160,7389.044,1348.929,310.1828,0,0,0,100,0),
(@PATH,161,7347.691,1344.195,308.6195,0,0,0,100,0),
(@PATH,162,7314.380,1346.306,307.6338,0,0,0,100,0),
(@PATH,163,7281.290,1348.486,306.5570,0,0,0,100,0),
(@PATH,164,7259.728,1332.310,305.3224,0,0,0,100,0),
(@PATH,165,7226.770,1301.865,302.9928,0,0,0,100,0),
(@PATH,166,7190.445,1270.757,302.0640,0,0,0,100,0),
(@PATH,167,7159.991,1271.942,300.1463,0,0,0,100,0),
(@PATH,168,7118.611,1256.946,297.7034,0,0,0,100,0),
(@PATH,169,7077.323,1235.719,296.1696,0,0,0,100,0),
(@PATH,170,7049.174,1225.784,295.9547,0,0,0,100,0);

-- Pathing for Zul'drak Sentinel Entry: 32447
SET @NPC := @GUID+85;
SET @PATH := @NPC * 10;
DELETE FROM `creature_addon` WHERE `guid`=@NPC;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@NPC,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,5724.000,-2852.640,274.5060,0,0,0,100,0),
(@PATH,2,5755.550,-2823.590,274.5150,0,0,0,100,0),
(@PATH,3,5809.330,-2835.480,274.4960,0,0,0,100,0),
(@PATH,4,5829.910,-2805.140,274.4080,0,0,0,100,0),
(@PATH,5,5828.510,-2766.280,274.7190,0,0,0,100,0),
(@PATH,6,5828.290,-2755.410,276.5500,0,0,0,100,0),
(@PATH,7,5822.310,-2702.180,276.5840,0,0,0,100,0),
(@PATH,8,5794.060,-2684.310,276.5840,0,0,0,100,0),
(@PATH,9,5761.970,-2664.910,276.5840,0,0,0,100,0),
(@PATH,10,5744.330,-2663.150,280.7680,0,0,0,100,0),
(@PATH,11,5737.410,-2654.850,280.7680,0,0,0,100,0),
(@PATH,12,5737.570,-2632.250,292.4730,0,0,0,100,0),
(@PATH,13,5750.730,-2617.920,292.3230,0,0,0,100,0),
(@PATH,14,5773.040,-2617.450,292.4190,0,0,0,100,0),
(@PATH,15,5791.980,-2617.770,292.4190,0,0,0,100,0),
(@PATH,16,5818.440,-2617.850,292.4190,0,0,0,100,0),
(@PATH,17,5842.470,-2617.850,292.4190,0,0,0,100,0),
(@PATH,18,5869.620,-2618.230,292.4190,0,0,0,100,0),
(@PATH,19,5842.470,-2617.850,292.4190,0,0,0,100,0),
(@PATH,20,5818.440,-2617.850,292.4190,0,0,0,100,0),
(@PATH,21,5791.980,-2617.770,292.4190,0,0,0,100,0),
(@PATH,22,5773.040,-2617.450,292.4190,0,0,0,100,0),
(@PATH,23,5750.730,-2617.920,292.3230,0,0,0,100,0),
(@PATH,24,5727.260,-2618.850,292.4160,0,0,0,100,0),
(@PATH,25,5705.450,-2617.610,292.4120,0,0,0,100,0),
(@PATH,26,5683.230,-2617.440,292.4180,0,0,0,100,0),
(@PATH,27,5666.380,-2618.120,292.4710,0,0,0,100,0),
(@PATH,28,5644.480,-2618.200,292.4710,0,0,0,100,0),
(@PATH,29,5618.580,-2617.640,292.4990,0,0,0,100,0),
(@PATH,30,5597.510,-2617.550,292.4990,0,0,0,100,0),
(@PATH,31,5580.090,-2617.990,292.4990,0,0,0,100,0),
(@PATH,32,5566.360,-2617.760,292.4200,0,0,0,100,0),
(@PATH,33,5580.090,-2617.990,292.4990,0,0,0,100,0),
(@PATH,34,5597.510,-2617.550,292.4990,0,0,0,100,0),
(@PATH,35,5618.580,-2617.640,292.4990,0,0,0,100,0),
(@PATH,36,5644.480,-2618.200,292.4710,0,0,0,100,0),
(@PATH,37,5666.380,-2618.120,292.4710,0,0,0,100,0),
(@PATH,38,5683.230,-2617.440,292.4180,0,0,0,100,0),
(@PATH,39,5705.450,-2617.610,292.4120,0,0,0,100,0),
(@PATH,40,5727.260,-2618.850,292.4160,0,0,0,100,0),
(@PATH,41,5737.570,-2632.250,292.4730,0,0,0,100,0),
(@PATH,42,5737.410,-2654.850,280.7680,0,0,0,100,0),
(@PATH,43,5744.330,-2663.150,280.7680,0,0,0,100,0),
(@PATH,44,5761.970,-2664.910,276.5840,0,0,0,100,0),
(@PATH,45,5794.060,-2684.310,276.5840,0,0,0,100,0),
(@PATH,46,5822.310,-2702.180,276.5840,0,0,0,100,0),
(@PATH,47,5828.290,-2755.410,276.5500,0,0,0,100,0),
(@PATH,48,5828.510,-2766.280,274.7190,0,0,0,100,0),
(@PATH,49,5829.910,-2805.140,274.4080,0,0,0,100,0),
(@PATH,50,5809.330,-2835.480,274.4960,0,0,0,100,0),
(@PATH,51,5755.550,-2823.590,274.5150,0,0,0,100,0),
(@PATH,52,5724.000,-2852.640,274.5060,0,0,0,100,0),
(@PATH,53,5693.950,-2871.760,274.5770,0,0,0,100,0),
(@PATH,54,5664.210,-2905.730,274.3850,0,0,0,100,0),
(@PATH,55,5629.240,-2933.900,274.3790,0,0,0,100,0),
(@PATH,56,5601.860,-2960.070,274.3790,0,0,0,100,0),
(@PATH,57,5594.340,-2966.000,276.5940,0,0,0,100,0),
(@PATH,58,5559.140,-2960.480,276.5840,0,0,0,100,0),
(@PATH,59,5526.130,-2965.070,276.5840,0,0,0,100,0),
(@PATH,60,5507.190,-2996.900,276.5880,0,0,0,100,0),
(@PATH,61,5490.880,-3013.770,288.0960,0,0,0,100,0),
(@PATH,62,5465.120,-3043.530,288.7970,0,0,0,100,0),
(@PATH,63,5455.740,-3053.280,292.0040,0,0,0,100,0),
(@PATH,64,5438.300,-3072.640,292.4190,0,0,0,100,0),
(@PATH,65,5408.170,-3076.490,292.4190,0,0,0,100,0),
(@PATH,66,5389.960,-3057.200,292.4190,0,0,0,100,0),
(@PATH,67,5372.570,-3028.290,292.4190,0,0,0,100,0),
(@PATH,68,5359.020,-2999.280,292.4190,0,0,0,100,0),
(@PATH,69,5343.850,-2981.210,292.4190,0,0,0,100,0),
(@PATH,70,5316.590,-2957.750,292.4180,0,0,0,100,0),
(@PATH,71,5291.510,-2936.590,292.4180,0,0,0,100,0),
(@PATH,72,5269.860,-2920.950,292.4180,0,0,0,100,0),
(@PATH,73,5248.840,-2899.650,292.4180,0,0,0,100,0),
(@PATH,74,5228.780,-2879.540,292.4180,0,0,0,100,0),
(@PATH,75,5202.560,-2855.400,292.4200,0,0,0,100,0),
(@PATH,76,5194.670,-2837.020,292.4180,0,0,0,100,0),
(@PATH,77,5216.640,-2815.020,292.4180,0,0,0,100,0),
(@PATH,78,5246.490,-2789.880,292.4180,0,0,0,100,0),
(@PATH,79,5272.980,-2764.980,292.4180,0,0,0,100,0),
(@PATH,80,5297.260,-2742.340,292.4200,0,0,0,100,0),
(@PATH,81,5323.050,-2718.580,292.4170,0,0,0,100,0),
(@PATH,82,5354.000,-2692.930,292.4190,0,0,0,100,0),
(@PATH,83,5323.050,-2718.580,292.4170,0,0,0,100,0),
(@PATH,84,5297.260,-2742.340,292.4200,0,0,0,100,0),
(@PATH,85,5272.980,-2764.980,292.4180,0,0,0,100,0),
(@PATH,86,5246.490,-2789.880,292.4180,0,0,0,100,0),
(@PATH,87,5216.640,-2815.020,292.4180,0,0,0,100,0),
(@PATH,88,5194.670,-2837.020,292.4180,0,0,0,100,0),
(@PATH,89,5172.790,-2864.270,292.4190,0,0,0,100,0),
(@PATH,90,5154.700,-2887.120,292.4190,0,0,0,100,0),
(@PATH,91,5129.290,-2891.070,292.4190,0,0,0,100,0),
(@PATH,92,5107.440,-2912.540,292.4190,0,0,0,100,0),
(@PATH,93,5083.430,-2936.790,292.4190,0,0,0,100,0),
(@PATH,94,5062.290,-2957.040,292.0600,0,0,0,100,0),
(@PATH,95,5042.170,-2976.570,292.5840,0,0,0,100,0),
(@PATH,96,5013.840,-3004.280,292.4190,0,0,0,100,0),
(@PATH,97,4990.340,-3027.050,292.4190,0,0,0,100,0),
(@PATH,98,4963.340,-3053.410,292.4190,0,0,0,100,0),
(@PATH,99,4935.050,-3080.150,292.4190,0,0,0,100,0),
(@PATH,100,4912.420,-3101.800,292.4190,0,0,0,100,0),
(@PATH,101,4886.650,-3126.440,292.4190,0,0,0,100,0),
(@PATH,102,4862.060,-3149.930,292.4190,0,0,0,100,0),
(@PATH,103,4843.120,-3168.170,292.4190,0,0,0,100,0),
(@PATH,104,4862.060,-3149.930,292.4190,0,0,0,100,0),
(@PATH,105,4886.650,-3126.440,292.4190,0,0,0,100,0),
(@PATH,106,4912.420,-3101.800,292.4190,0,0,0,100,0),
(@PATH,107,4935.050,-3080.150,292.4190,0,0,0,100,0),
(@PATH,108,4963.340,-3053.410,292.4190,0,0,0,100,0),
(@PATH,109,4990.340,-3027.050,292.4190,0,0,0,100,0),
(@PATH,110,5013.840,-3004.280,292.4190,0,0,0,100,0),
(@PATH,111,5042.170,-2976.570,292.5840,0,0,0,100,0),
(@PATH,112,5062.290,-2957.040,292.0600,0,0,0,100,0),
(@PATH,113,5083.430,-2936.790,292.4190,0,0,0,100,0),
(@PATH,114,5107.440,-2912.540,292.4190,0,0,0,100,0),
(@PATH,115,5129.290,-2891.070,292.4190,0,0,0,100,0),
(@PATH,116,5154.700,-2887.120,292.4190,0,0,0,100,0),
(@PATH,117,5172.790,-2864.270,292.4190,0,0,0,100,0),
(@PATH,118,5202.560,-2855.400,292.4200,0,0,0,100,0),
(@PATH,119,5228.780,-2879.540,292.4180,0,0,0,100,0),
(@PATH,120,5248.840,-2899.650,292.4180,0,0,0,100,0),
(@PATH,121,5269.860,-2920.950,292.4180,0,0,0,100,0),
(@PATH,122,5291.510,-2936.590,292.4180,0,0,0,100,0),
(@PATH,123,5316.590,-2957.750,292.4180,0,0,0,100,0),
(@PATH,124,5343.850,-2981.210,292.4190,0,0,0,100,0),
(@PATH,125,5359.020,-2999.280,292.4190,0,0,0,100,0),
(@PATH,126,5372.570,-3028.290,292.4190,0,0,0,100,0),
(@PATH,127,5389.960,-3057.200,292.4190,0,0,0,100,0),
(@PATH,128,5408.170,-3076.490,292.4190,0,0,0,100,0),
(@PATH,129,5438.300,-3072.640,292.4190,0,0,0,100,0),
(@PATH,130,5455.740,-3053.280,292.0040,0,0,0,100,0),
(@PATH,131,5465.120,-3043.530,288.7970,0,0,0,100,0),
(@PATH,132,5490.880,-3013.770,288.0960,0,0,0,100,0),
(@PATH,133,5507.190,-2996.900,276.5880,0,0,0,100,0),
(@PATH,134,5526.130,-2965.070,276.5840,0,0,0,100,0),
(@PATH,135,5559.140,-2960.480,276.5840,0,0,0,100,0),
(@PATH,136,5594.340,-2966.000,276.5940,0,0,0,100,0),
(@PATH,137,5601.860,-2960.070,274.3790,0,0,0,100,0),
(@PATH,138,5629.240,-2933.900,274.3790,0,0,0,100,0),
(@PATH,139,5664.210,-2905.730,274.3850,0,0,0,100,0),
(@PATH,140,5693.950,-2871.760,274.5770,0,0,0,100,0);
-- Pathing for Zul'drak Sentinel Entry: 32447
SET @NPC := @GUID+86;
SET @PATH := @NPC * 10;
DELETE FROM `creature_addon` WHERE `guid`=@NPC;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@NPC,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,4914.130,-1622.030,248.3090,0,0,0,100,0),
(@PATH,2,4912.460,-1580.230,248.3090,0,0,0,100,0),
(@PATH,3,4906.730,-1561.730,248.3680,0,0,0,100,0),
(@PATH,4,4883.310,-1539.930,248.7920,0,0,0,100,0),
(@PATH,5,4851.130,-1514.290,249.1620,0,0,0,100,0),
(@PATH,6,4883.310,-1539.930,248.7920,0,0,0,100,0),
(@PATH,7,4906.730,-1561.730,248.3680,0,0,0,100,0),
(@PATH,8,4912.460,-1580.230,248.3090,0,0,0,100,0),
(@PATH,9,4914.130,-1622.030,248.3090,0,0,0,100,0),
(@PATH,10,4914.310,-1661.770,248.3090,0,0,0,100,0),
(@PATH,11,4913.710,-1698.930,248.3080,0,0,0,100,0),
(@PATH,12,4914.110,-1730.130,248.3070,0,0,0,100,0),
(@PATH,13,4914.250,-1760.870,248.3070,0,0,0,100,0),
(@PATH,14,4914.320,-1804.820,248.3090,0,0,0,100,0),
(@PATH,15,4913.730,-1841.620,248.3090,0,0,0,100,0),
(@PATH,16,4912.850,-1875.260,248.3090,0,0,0,100,0),
(@PATH,17,4913.100,-1909.730,248.3070,0,0,0,100,0),
(@PATH,18,4913.340,-1956.600,248.3000,0,0,0,100,0),
(@PATH,19,4913.430,-1996.570,248.3090,0,0,0,100,0),
(@PATH,20,4913.280,-2029.650,248.3080,0,0,0,100,0),
(@PATH,21,4931.000,-2048.890,248.3080,0,0,0,100,0),
(@PATH,22,4966.010,-2050.800,248.3080,0,0,0,100,0),
(@PATH,23,4997.010,-2052.770,248.3080,0,0,0,100,0),
(@PATH,24,5028.930,-2055.350,248.1920,0,0,0,100,0),
(@PATH,25,5062.110,-2058.030,248.2960,0,0,0,100,0),
(@PATH,26,5083.820,-2050.360,248.1850,0,0,0,100,0),
(@PATH,27,5111.150,-2049.930,248.1180,0,0,0,100,0),
(@PATH,28,5148.310,-2050.290,248.2960,0,0,0,100,0),
(@PATH,29,5177.760,-2049.490,248.2960,0,0,0,100,0),
(@PATH,30,5211.760,-2048.980,248.2970,0,0,0,100,0),
(@PATH,31,5177.760,-2049.490,248.2960,0,0,0,100,0),
(@PATH,32,5148.310,-2050.290,248.2960,0,0,0,100,0),
(@PATH,33,5111.150,-2049.930,248.1180,0,0,0,100,0),
(@PATH,34,5083.820,-2050.360,248.1850,0,0,0,100,0),
(@PATH,35,5062.110,-2058.030,248.2960,0,0,0,100,0),
(@PATH,36,5028.930,-2055.350,248.1920,0,0,0,100,0),
(@PATH,37,4997.010,-2052.770,248.3080,0,0,0,100,0),
(@PATH,38,4966.010,-2050.800,248.3080,0,0,0,100,0),
(@PATH,39,4931.000,-2048.890,248.3080,0,0,0,100,0),
(@PATH,40,4913.280,-2029.650,248.3080,0,0,0,100,0),
(@PATH,41,4913.430,-1996.570,248.3090,0,0,0,100,0),
(@PATH,42,4913.340,-1956.600,248.3000,0,0,0,100,0),
(@PATH,43,4913.100,-1909.730,248.3070,0,0,0,100,0),
(@PATH,44,4912.850,-1875.260,248.3090,0,0,0,100,0),
(@PATH,45,4913.730,-1841.620,248.3090,0,0,0,100,0),
(@PATH,46,4914.320,-1804.820,248.3090,0,0,0,100,0),
(@PATH,47,4914.250,-1760.870,248.3070,0,0,0,100,0),
(@PATH,48,4914.110,-1730.130,248.3070,0,0,0,100,0),
(@PATH,49,4913.710,-1698.930,248.3080,0,0,0,100,0),
(@PATH,50,4914.310,-1661.770,248.3090,0,0,0,100,0);

-- Pathing for Fumblub Gearwind Entry: 32358
SET @NPC := @GUID+4;
SET @PATH := @NPC * 10;
UPDATE `creature` SET `spawndist`=0,`MovementType`=2,`position_x`=4107.777,`position_y`=4981.302,`position_z`=4.601125 WHERE `guid`=@NPC;
DELETE FROM `creature_addon` WHERE `guid`=@NPC;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@NPC,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,3996.668,5027.57,4.601125,0,0,0,100,0),
(@PATH,2,3908.403,5132.647,18.65668,0,0,0,100,0),
(@PATH,3,3762.461,5061.485,18.65668,0,0,0,100,0),
(@PATH,4,3706.78,4998.379,18.65668,0,0,0,100,0),
(@PATH,5,3626.849,4981.311,18.65668,0,0,0,100,0),
(@PATH,6,3553.993,4971.021,18.65668,0,0,0,100,0),
(@PATH,7,3562.81,4855.884,18.65668,0,0,0,100,0),
(@PATH,8,3482.353,4704.925,8.01779,0,0,0,100,0),
(@PATH,9,3476.721,4495.351,7.07335,0,0,0,100,0),
(@PATH,10,3651.377,4535.771,7.07335,0,0,0,100,0),
(@PATH,11,3797.042,4659.164,4.21224,0,0,0,100,0),
(@PATH,12,3959.966,4664.088,5.490018,0,0,0,100,0),
(@PATH,13,4050.999,4706.122,13.51779,0,0,0,100,0),
(@PATH,14,4141.185,4783.229,13.99001,0,0,0,100,0),
(@PATH,15,4250.018,4783.799,13.8789,0,0,0,100,0),
(@PATH,16,4252.546,4879.61,7.906681,0,0,0,100,0),
(@PATH,17,4107.777,4981.302,4.601125,0,0,0,100,0);


-- NR Rare Spawns
SET @GUID := 250006;

UPDATE `creature_template` SET `faction_a`=14, `faction_h`=14 WHERE entry IN (32630);
DELETE FROM `creature` WHERE `guid`=@GUID;
INSERT INTO `creature` (`guid`,`id`,`map`,`spawnMask`,`phaseMask`,`modelid`,`equipment_id`,`position_x`,`position_y`,`position_z`,`orientation`,`spawntimesecs`,`spawndist`,`currentwaypoint`,`curhealth`,`curmana`,`DeathState`,`MovementType`) VALUES
-- Vyragosa
(@GUID,32630,571,1,1,0,0,7090.247,-1566.583,958.0051,0.7234184,28800,0,0,1,0,0,2);

-- Pathing for Vyragosa Entry: 32630
SET @NPC := @GUID;
SET @PATH := @NPC * 10;
UPDATE `creature` SET `spawndist`=0,`MovementType`=2,`position_x`=6913.308,`position_y`=-1725.261,`position_z`=954.7917 WHERE `guid`=@NPC;
DELETE FROM `creature_addon` WHERE `guid`=@NPC;
INSERT INTO `creature_addon` (`guid`,`path_id`,`bytes2`,`mount`,`auras`) VALUES (@NPC,@PATH,1,0, '');
DELETE FROM `waypoint_data` WHERE `id`=@PATH;
INSERT INTO `waypoint_data` (`id`,`point`,`position_x`,`position_y`,`position_z`,`delay`,`move_flag`,`action`,`action_chance`,`wpguid`) VALUES
(@PATH,1,7025.494,-1624.87,957.3694,0,0,0,100,0),
(@PATH,2,7167.578,-1501.694,962.5693,0,0,0,100,0),
(@PATH,3,7440.402,-1295.861,997.2911,0,0,0,100,0),
(@PATH,4,7210.958,-1046.892,1006.18,0,0,0,100,0),
(@PATH,5,6998.465,-1076.847,1024.819,0,0,0,100,0),
(@PATH,6,6874.249,-1097.382,927.736,0,0,0,100,0),
(@PATH,7,6614.792,-875.7547,812.7645,0,0,0,100,0),
(@PATH,8,6563.275,-811.7673,749.8757,0,0,0,100,0),
(@PATH,9,6299.502,-797.577,529.1257,0,0,0,100,0),
(@PATH,10,6194.549,-1013.144,501.5424,0,0,0,100,0),
(@PATH,11,6319.254,-1251.661,468.6258,0,0,0,100,0),
(@PATH,12,6309.161,-1537.857,615.0423,0,0,0,100,0),
(@PATH,13,6748.211,-1664.307,919.3118,0,0,0,100,0),
(@PATH,14,6913.308,-1725.261,954.7917,0,0,0,100,0);
