set logging overwrite on
set logging file backtrace.log.temp
set style enabled off
set height unlimited
set width unlimited
set disassembly-flavor intel
handle SIG33 pass nostop noprint
set pagination 0
set logging on
echo \n--- DEBUG: --- START\n\n
run
# check if exited normally
if $_isvoid($_exitcode)
  echo \n--- DEBUG: BACKTRACE FULL\n
  # print assertion message if this is ASSERT crash
  if TrinityAssertionFailedMessage != 0
    printf "%s\n", TrinityAssertionFailedMessage
  end
  echo \n
  backtrace full
  echo \n--- DEBUG: INFO REGISTERS\n\n
  info registers
  echo \n--- DEBUG: CALLS (x/16i $pc)\n\n
  x/16i $pc
  echo \n--- DEBUG: THREAD APPLY ALL BACKTRACE\n
  thread apply all backtrace
  echo \n--- DEBUG: --- STOP\n\n
  echo Generated by crashreport.gdb script version 1.4\n
  set logging off

  # rename log file to avoid it getting overwritten by restart scripts
  shell mv backtrace.log.temp backtrace_$(date +%Y-%m-%d-%T).log
else
  # normal exit, cleanup temp file
  set logging off
  shell rm backtrace.log.temp
end
quit
