/*
 * Decompiled with CFR 0.152.
 */
package xortroll.goldleaf.quark.usb.cmd;

import java.nio.charset.StandardCharsets;
import xortroll.goldleaf.quark.Buffer;
import xortroll.goldleaf.quark.usb.USBInterface;

public class CommandBlock {
    public static final int BlockSize = 4096;
    public static final int InputMagic = 1229147207;
    public static final int OutputMagic = 1329810503;
    public static final int ResultSuccess = 0;
    public static final int InvalidCommandId = 0;
    private byte[] inner_block;
    private byte[] resp_block;
    private Buffer inner_buf;
    private Buffer resp_buf;
    private USBInterface usb_intf;

    public CommandBlock(USBInterface intf) {
        this.usb_intf = intf;
        this.inner_block = this.usb_intf.readBytes(4096);
        if (this.inner_block != null) {
            this.inner_buf = new Buffer(this.inner_block);
        }
        this.resp_block = new byte[4096];
        this.resp_buf = new Buffer(this.resp_block);
    }

    public boolean isValid() {
        return this.inner_buf != null;
    }

    public String readString() {
        int str_len = this.read32();
        return new String(this.inner_buf.readBytes(str_len), StandardCharsets.UTF_8);
    }

    public int read32() {
        return this.inner_buf.read32();
    }

    public long read64() {
        return this.inner_buf.read64();
    }

    public void write32(int val) {
        this.resp_buf.write32(val);
    }

    public void write64(long val) {
        this.resp_buf.write64(val);
    }

    public void writeString(String val) {
        byte[] raw = val.getBytes(StandardCharsets.UTF_8);
        this.write32(raw.length);
        this.resp_buf.writeBytes(raw);
    }

    public void sendBuffer(byte[] buf) {
        this.usb_intf.writeBytes(buf);
    }

    public byte[] getBuffer(int len) {
        return this.usb_intf.readBytes(len);
    }

    public int validateCommand() {
        int input_magic = this.read32();
        if (input_magic == 1229147207) {
            int cmd_id = this.read32();
            return cmd_id;
        }
        return 0;
    }

    public void responseStart() {
        this.resp_buf.write32(1329810503);
        this.resp_buf.write32(0);
    }

    public void responseEnd() {
        this.usb_intf.writeBytes(this.resp_block);
    }

    public void respondFailure(int rc) {
        this.resp_buf.write32(1329810503);
        this.resp_buf.write32(rc);
        this.responseEnd();
    }

    public void respondEmpty() {
        this.responseStart();
        this.responseEnd();
    }
}

