/*
 * Decompiled with CFR 0.152.
 */
package xortroll.goldleaf.quark.usb.cf;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.List;
import xortroll.goldleaf.quark.Logging;
import xortroll.goldleaf.quark.fs.FileSystem;
import xortroll.goldleaf.quark.ui.MainApplication;
import xortroll.goldleaf.quark.usb.cf.Command;
import xortroll.goldleaf.quark.usb.cf.CommandHandler;
import xortroll.goldleaf.quark.usb.cmd.CommandBlock;

public class CommandFramework {
    public static final int ResultExceptionCaught = 47857;
    public static final int ResultInvalidIndex = 47858;
    public static final int ResultInvalidFileMode = 47859;
    public static final int ResultSelectionCancelled = 47860;
    public static final int PathTypeInvalid = 0;
    public static final int PathTypeFile = 1;
    public static final int PathTypeDirectory = 2;
    public static final int FileModeRead = 1;
    public static final int FileModeWrite = 2;
    public static final int FileModeAppend = 3;
    private static List<String> drives;
    private static RandomAccessFile started_read_file;
    private static RandomAccessFile started_write_file;
    public static Command GetDriveCount;
    public static Command GetDriveInfo;
    public static Command StatPath;
    public static Command GetFileCount;
    public static Command GetFile;
    public static Command GetDirectoryCount;
    public static Command GetDirectory;
    public static Command StartFile;
    public static Command ReadFile;
    public static Command WriteFile;
    public static Command EndFile;
    public static Command Create;
    public static Command Delete;
    public static Command Rename;
    public static Command GetSpecialPathCount;
    public static Command GetSpecialPath;
    public static Command SelectFile;
    public static Command[] AvailableCommands;

    private static boolean isValidFileMode(int mode) {
        return mode == 1 || mode == 2 || mode == 3;
    }

    private static void ensureFileStarted(String path, int mode) throws Exception {
        if (mode == 1) {
            if (started_read_file != null) {
                started_read_file.close();
            }
            started_read_file = new RandomAccessFile(path, "r");
        } else {
            if (started_write_file != null) {
                started_write_file.close();
            }
            started_write_file = new RandomAccessFile(path, "rw");
            if (mode == 3) {
                started_write_file.seek(started_write_file.length());
            }
        }
    }

    private static void ensureFileEnded(int mode) throws Exception {
        if (mode == 1) {
            if (started_read_file != null) {
                started_read_file.close();
                started_read_file = null;
            }
        } else if (started_write_file != null) {
            started_write_file.close();
            started_write_file = null;
        }
    }

    static {
        GetDriveCount = new Command(1, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                drives = FileSystem.listDrives();
                int drive_count = drives.size();
                Logging.log("[cf] GetDriveCount() -> count: " + drive_count);
                block.responseStart();
                block.write32(drive_count);
                block.responseEnd();
            }
        });
        GetDriveInfo = new Command(2, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                int drive_idx;
                if (drives == null) {
                    drives = FileSystem.listDrives();
                }
                if ((drive_idx = block.read32()) < drives.size()) {
                    String drive_path = (String)drives.get(drive_idx);
                    String drive_name = FileSystem.getDriveLabel(drive_path);
                    long drive_total_size = 0L;
                    long drive_free_size = 0L;
                    Logging.log("[cf] GetDriveInfo(idx: " + drive_idx + ") -> path: '" + drive_path + "', name: '" + drive_name + "', total_size: " + drive_total_size + ", free_size: " + drive_free_size);
                    block.responseStart();
                    block.writeString(drive_name);
                    block.writeString(drive_path);
                    block.write64(drive_total_size);
                    block.write64(drive_free_size);
                    block.responseEnd();
                } else {
                    block.respondFailure(47858);
                }
            }
        });
        StatPath = new Command(3, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                try {
                    File f_path = new File(path);
                    int path_type = 0;
                    long file_size = 0L;
                    if (f_path.isFile()) {
                        path_type = 1;
                        file_size = f_path.length();
                    } else if (f_path.isDirectory()) {
                        path_type = 2;
                    }
                    Logging.log("[cf] StatPath(path: '" + path + "') -> path_type: " + path_type + ", file_size: " + file_size);
                    block.responseStart();
                    block.write32(path_type);
                    block.write64(file_size);
                    block.responseEnd();
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        GetFileCount = new Command(4, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                List<String> files = FileSystem.getFilesIn(path);
                int file_count = files.size();
                Logging.log("[cf] GetFileCount(path: '" + path + "') -> count: " + file_count);
                block.responseStart();
                block.write32(file_count);
                block.responseEnd();
            }
        });
        GetFile = new Command(5, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                List<String> files;
                String path = FileSystem.denormalizePath(block.readString());
                int file_idx = block.read32();
                if (file_idx < (files = FileSystem.getFilesIn(path)).size()) {
                    String file = files.get(file_idx);
                    Logging.log("[cf] GetFile(path: '" + path + "', idx: " + file_idx + ") -> file: '" + file + "'");
                    block.responseStart();
                    block.writeString(file);
                    block.responseEnd();
                } else {
                    block.respondFailure(47858);
                }
            }
        });
        GetDirectoryCount = new Command(6, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                List<String> dirs = FileSystem.getDirectoriesIn(path);
                int dir_count = dirs.size();
                Logging.log("[cf] GetDirectoryCount(path: '" + path + "') -> count: " + dir_count);
                block.responseStart();
                block.write32(dir_count);
                block.responseEnd();
            }
        });
        GetDirectory = new Command(7, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                List<String> dirs;
                String path = FileSystem.denormalizePath(block.readString());
                int subdir_idx = block.read32();
                if (subdir_idx < (dirs = FileSystem.getDirectoriesIn(path)).size()) {
                    String dir = dirs.get(subdir_idx);
                    Logging.log("[cf] GetDirectory(path: '" + path + "', idx: " + subdir_idx + ") -> dir: '" + dir + "'");
                    block.responseStart();
                    block.writeString(dir);
                    block.responseEnd();
                } else {
                    block.respondFailure(47858);
                }
            }
        });
        StartFile = new Command(8, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                int mode = block.read32();
                Logging.log("[cf] StartFile(path: '" + path + "', mode: " + mode + ")");
                try {
                    if (CommandFramework.isValidFileMode(mode)) {
                        CommandFramework.ensureFileStarted(path, mode);
                        block.respondEmpty();
                    } else {
                        block.respondFailure(47859);
                    }
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        ReadFile = new Command(9, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                long offset = block.read64();
                long size = block.read64();
                try {
                    boolean close_file = false;
                    RandomAccessFile read_file = started_read_file;
                    if (read_file == null) {
                        read_file = new RandomAccessFile(path, "r");
                        close_file = true;
                    }
                    byte[] data = new byte[(int)size];
                    read_file.seek(offset);
                    int read = read_file.read(data, 0, (int)size);
                    if (close_file) {
                        read_file.close();
                    }
                    Logging.log("[cf] ReadFile(path: '" + path + "', offset: " + offset + ", size: " + size + ") -> read_size: " + read);
                    block.responseStart();
                    block.write64(read);
                    block.responseEnd();
                    block.sendBuffer(data);
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        WriteFile = new Command(10, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                long size = block.read64();
                byte[] data = block.getBuffer((int)size);
                try {
                    boolean close_file = false;
                    RandomAccessFile write_file = started_write_file;
                    if (write_file == null) {
                        write_file = new RandomAccessFile(path, "rw");
                        close_file = true;
                    }
                    write_file.write(data);
                    if (close_file) {
                        write_file.close();
                    }
                    Logging.log("[cf] WriteFile(path: '" + path + "', size: " + size + ") -> written_size: " + size);
                    block.responseStart();
                    block.write64(size);
                    block.responseEnd();
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        EndFile = new Command(11, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                int mode = block.read32();
                Logging.log("[cf] EndFile(mode: " + mode + ")");
                try {
                    if (CommandFramework.isValidFileMode(mode)) {
                        CommandFramework.ensureFileEnded(mode);
                        block.respondEmpty();
                    } else {
                        block.respondFailure(47859);
                    }
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        Create = new Command(12, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                int path_type = block.read32();
                Logging.log("[cf] Create(path: '" + path + "', path_type: " + path_type + ")");
                try {
                    File f_path = new File(path);
                    if (path_type == 1) {
                        f_path.createNewFile();
                    } else if (path_type == 2) {
                        f_path.mkdir();
                    }
                    block.respondEmpty();
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        Delete = new Command(13, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                Logging.log("[cf] Delete(path: '" + path + "')");
                try {
                    FileSystem.deletePath(new File(path));
                    block.respondEmpty();
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        Rename = new Command(14, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = FileSystem.denormalizePath(block.readString());
                String new_name = FileSystem.denormalizePath(block.readString());
                Logging.log("[cf] Rename(path: '" + path + "', new_name: '" + new_name + "'')");
                try {
                    File f_path = new File(path);
                    f_path.renameTo(new File(f_path.getParent(), new_name));
                    block.respondEmpty();
                }
                catch (Exception e) {
                    block.respondFailure(47857);
                }
            }
        });
        GetSpecialPathCount = new Command(15, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                int special_path_count = MainApplication.getSpecialPathCount();
                Logging.log("[cf] GetSpecialPathCount() -> count: " + special_path_count);
                block.responseStart();
                block.write32(special_path_count);
                block.responseEnd();
            }
        });
        GetSpecialPath = new Command(16, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                int special_path_idx = block.read32();
                String[] special_path_info = MainApplication.getSpecialPath(special_path_idx);
                if (special_path_info != null) {
                    String special_path_name = special_path_info[0];
                    String special_path = FileSystem.normalizePath(special_path_info[1]);
                    Logging.log("[cf] GetSpecialPath(idx: " + special_path_idx + ") -> name: '" + special_path_name + "', path: '" + special_path + "'");
                    block.responseStart();
                    block.writeString(special_path_name);
                    block.writeString(special_path);
                    block.responseEnd();
                } else {
                    Logging.log("[cf] GetSpecialPath(idx: " + special_path_idx + ") -> invalid index");
                    block.respondFailure(47858);
                }
            }
        });
        SelectFile = new Command(17, new CommandHandler(){

            @Override
            public void handle(CommandBlock block) {
                String path = MainApplication.selectFile();
                if (path != null) {
                    Logging.log("[cf] SelectFile() -> path: '" + path + "'");
                    block.responseStart();
                    block.writeString(FileSystem.normalizePath(path));
                    block.responseEnd();
                } else {
                    block.respondFailure(47860);
                }
            }
        });
        AvailableCommands = new Command[]{GetDriveCount, GetDriveInfo, StatPath, GetFileCount, GetFile, GetDirectoryCount, GetDirectory, StartFile, ReadFile, WriteFile, EndFile, Create, Delete, Rename, GetSpecialPathCount, GetSpecialPath, SelectFile};
    }
}

