/*
 * Decompiled with CFR 0.152.
 */
package xortroll.goldleaf.quark.fs;

import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileSystem {
    private static final String HomePath = System.getProperty("user.home");
    private static final String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS.indexOf("windows") >= 0;
    }

    public static List<String> listDrives() {
        ArrayList<String> drives = new ArrayList<String>();
        drives.add(HomePath);
        if (FileSystem.isWindows()) {
            java.nio.file.FileSystem fs = FileSystems.getDefault();
            for (Path root : fs.getRootDirectories()) {
                try {
                    Files.getFileStore(root);
                    drives.add(root.toString().substring(0, 1));
                }
                catch (Exception exception) {}
            }
        } else {
            for (FileStore store : FileSystems.getDefault().getFileStores()) {
                String path = store.toString().split(" ")[0];
                String name = store.name();
                if (!name.startsWith("/dev/")) continue;
                drives.add(path);
            }
        }
        return drives;
    }

    public static String getDriveLabel(String drive) {
        if (drive.equals(HomePath)) {
            return "Home directory";
        }
        if (FileSystem.isWindows()) {
            Path root = Paths.get(drive + ":\\", new String[0]);
            try {
                FileStore store = Files.getFileStore(root);
                String name = store.name();
                return name;
            }
            catch (Exception e) {
                return "Drive (" + drive + ")";
            }
        }
        try {
            if (drive.equals("/")) {
                return "Root directory";
            }
            Path path = Paths.get(drive, new String[0]);
            String drive_name = path.getFileName().toString();
            return drive_name;
        }
        catch (Exception e) {
            return "Drive (" + drive + ")";
        }
    }

    public static List<String> getFilesIn(String path) {
        File[] all;
        ArrayList<String> files = new ArrayList<String>();
        for (File f : all = new File(path).listFiles()) {
            if (!f.isFile()) continue;
            files.add(f.getName());
        }
        return files;
    }

    public static List<String> getDirectoriesIn(String path) {
        File[] all;
        ArrayList<String> files = new ArrayList<String>();
        for (File f : all = new File(path).listFiles()) {
            if (!f.isDirectory()) continue;
            files.add(f.getName());
        }
        return files;
    }

    public static String normalizePath(String path) {
        String normalized = path.replace('\\', '/').replace("//", "/");
        if (!FileSystem.isWindows()) {
            return path.replace('\\', '/').replace("//", "/");
        }
        return normalized.replace("//", ":");
    }

    public static String denormalizePath(String path) {
        String denormalized = path;
        if (FileSystem.isWindows()) {
            return denormalized.replace('/', '\\');
        }
        return denormalized.replace(':', '/');
    }

    public static void deletePath(File file) {
        File[] entries;
        if (file.isDirectory() && (entries = file.listFiles()) != null) {
            for (File entry : entries) {
                FileSystem.deletePath(entry);
            }
        }
        file.delete();
    }
}

