package com.aiselp.autox.api.ui.component

import androidx.compose.material3.Icon
import androidx.compose.material3.LocalContentColor
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.painter.Painter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.res.painterResource
import coil.compose.rememberAsyncImagePainter
import com.aiselp.autox.api.ui.ComposeElement


internal object Icon : VueNativeComponent {
    override val tag: String = "Icon"

    @Composable
    override fun Render(
        modifier: Modifier,
        element: ComposeElement,
        content: @Composable () -> Unit
    ) {
        val contentDescription: String? = element.getProp("contentDescription")
        val src = element.getProp<Any>("src")
        val tint = parseColor(element.getProp("tint")) ?: LocalContentColor.current
        when (src) {
            is ImageVector -> Icon(
                modifier = modifier,
                imageVector = src,
                contentDescription = contentDescription,
                tint = tint
            )

            is Painter -> Icon(
                modifier = modifier,
                painter = src,
                contentDescription = contentDescription,
                tint = tint
            )

            is String -> run {
                parseDrawable(src)?.let {
                    Icon(
                        modifier = modifier,
                        painter = painterResource(it),
                        contentDescription = contentDescription,
                        tint = tint
                    )
                } ?: run {
                    Icon(
                        modifier = modifier,
                        painter = rememberAsyncImagePainter(model = src),
                        contentDescription = contentDescription,
                        tint = tint
                    )
                }
            }
        }

    }
}