/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.util;

import android.content.SharedPreferences;
import android.content.res.Resources;
import jackpal.androidterm.R;

public class TermSettings {
    private SharedPreferences mPrefs;
    private int mStatusBar;
    private int mActionBarMode;
    private int mOrientation;
    private int mCursorStyle;
    private int mCursorBlink;
    private int mFontSize;
    private int mColorId;
    private boolean mUTF8ByDefault;
    private int mBackKeyAction;
    private int mControlKeyId;
    private int mFnKeyId;
    private int mUseCookedIME;
    private String mShell;
    private String mFailsafeShell;
    private String mInitialCommand;
    private String mTermType;
    private boolean mCloseOnExit;
    private boolean mVerifyPath;
    private boolean mDoPathExtensions;
    private boolean mAllowPathPrepend;
    private String mHomePath;
    private String mPrependPath = null;
    private String mAppendPath = null;
    private boolean mAltSendsEsc;
    private boolean mMouseTracking;
    private boolean mUseKeyboardShortcuts;
    private static final String STATUSBAR_KEY = "statusbar";
    private static final String ACTIONBAR_KEY = "actionbar";
    private static final String ORIENTATION_KEY = "orientation";
    private static final String FONTSIZE_KEY = "fontsize";
    private static final String COLOR_KEY = "color";
    private static final String UTF8_KEY = "utf8_by_default";
    private static final String BACKACTION_KEY = "backaction";
    private static final String CONTROLKEY_KEY = "controlkey";
    private static final String FNKEY_KEY = "fnkey";
    private static final String IME_KEY = "ime";
    private static final String SHELL_KEY = "shell";
    private static final String INITIALCOMMAND_KEY = "initialcommand";
    private static final String TERMTYPE_KEY = "termtype";
    private static final String CLOSEONEXIT_KEY = "close_window_on_process_exit";
    private static final String VERIFYPATH_KEY = "verify_path";
    private static final String PATHEXTENSIONS_KEY = "do_path_extensions";
    private static final String PATHPREPEND_KEY = "allow_prepend_path";
    private static final String HOMEPATH_KEY = "home_path";
    private static final String ALT_SENDS_ESC = "alt_sends_esc";
    private static final String MOUSE_TRACKING = "mouse_tracking";
    private static final String USE_KEYBOARD_SHORTCUTS = "use_keyboard_shortcuts";
    public static final int WHITE = -1;
    public static final int BLACK = -16777216;
    public static final int BLUE = -13349187;
    public static final int GREEN = -16711936;
    public static final int AMBER = -18863;
    public static final int RED = -65261;
    public static final int HOLO_BLUE = -13388315;
    public static final int SOLARIZED_FG = -10126461;
    public static final int SOLARIZED_BG = -133405;
    public static final int SOLARIZED_DARK_FG = -8153962;
    public static final int SOLARIZED_DARK_BG = -16766154;
    public static final int LINUX_CONSOLE_WHITE = -5592406;
    public static final int[][] COLOR_SCHEMES = new int[][]{{-16777216, -1}, {-1, -16777216}, {-1, -13349187}, {-16711936, -16777216}, {-18863, -16777216}, {-65261, -16777216}, {-13388315, -16777216}, {-10126461, -133405}, {-8153962, -16766154}, {-5592406, -16777216}};
    public static final int ACTION_BAR_MODE_NONE = 0;
    public static final int ACTION_BAR_MODE_ALWAYS_VISIBLE = 1;
    public static final int ACTION_BAR_MODE_HIDES = 2;
    private static final int ACTION_BAR_MODE_MAX = 2;
    public static final int ORIENTATION_UNSPECIFIED = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int ORIENTATION_PORTRAIT = 2;
    public static final int KEYCODE_NONE = -1;
    public static final int CONTROL_KEY_ID_NONE = 7;
    public static final int[] CONTROL_KEY_SCHEMES = new int[]{23, 77, 57, 58, 24, 25, 27, -1};
    public static final int FN_KEY_ID_NONE = 7;
    public static final int[] FN_KEY_SCHEMES = new int[]{23, 77, 57, 58, 24, 25, 27, -1};
    public static final int BACK_KEY_STOPS_SERVICE = 0;
    public static final int BACK_KEY_CLOSES_WINDOW = 1;
    public static final int BACK_KEY_CLOSES_ACTIVITY = 2;
    public static final int BACK_KEY_SENDS_ESC = 3;
    public static final int BACK_KEY_SENDS_TAB = 4;
    private static final int BACK_KEY_MAX = 4;

    public TermSettings(Resources res, SharedPreferences prefs) {
        this.readDefaultPrefs(res);
        this.readPrefs(prefs);
    }

    private void readDefaultPrefs(Resources res) {
        this.mStatusBar = Integer.parseInt(res.getString(R.string.pref_statusbar_default));
        this.mActionBarMode = res.getInteger(R.integer.pref_actionbar_default);
        this.mOrientation = res.getInteger(R.integer.pref_orientation_default);
        this.mCursorStyle = Integer.parseInt(res.getString(R.string.pref_cursorstyle_default));
        this.mCursorBlink = Integer.parseInt(res.getString(R.string.pref_cursorblink_default));
        this.mFontSize = Integer.parseInt(res.getString(R.string.pref_fontsize_default));
        this.mColorId = Integer.parseInt(res.getString(R.string.pref_color_default));
        this.mUTF8ByDefault = res.getBoolean(R.bool.pref_utf8_by_default_default);
        this.mBackKeyAction = Integer.parseInt(res.getString(R.string.pref_backaction_default));
        this.mControlKeyId = Integer.parseInt(res.getString(R.string.pref_controlkey_default));
        this.mFnKeyId = Integer.parseInt(res.getString(R.string.pref_fnkey_default));
        this.mUseCookedIME = Integer.parseInt(res.getString(R.string.pref_ime_default));
        this.mShell = this.mFailsafeShell = res.getString(R.string.pref_shell_default);
        this.mInitialCommand = res.getString(R.string.pref_initialcommand_default);
        this.mTermType = res.getString(R.string.pref_termtype_default);
        this.mCloseOnExit = res.getBoolean(R.bool.pref_close_window_on_process_exit_default);
        this.mVerifyPath = res.getBoolean(R.bool.pref_verify_path_default);
        this.mDoPathExtensions = res.getBoolean(R.bool.pref_do_path_extensions_default);
        this.mAllowPathPrepend = res.getBoolean(R.bool.pref_allow_prepend_path_default);
        this.mAltSendsEsc = res.getBoolean(R.bool.pref_alt_sends_esc_default);
        this.mMouseTracking = res.getBoolean(R.bool.pref_mouse_tracking_default);
        this.mUseKeyboardShortcuts = res.getBoolean(R.bool.pref_use_keyboard_shortcuts_default);
    }

    public void readPrefs(SharedPreferences prefs) {
        this.mPrefs = prefs;
        this.mStatusBar = this.readIntPref(STATUSBAR_KEY, this.mStatusBar, 1);
        this.mActionBarMode = this.readIntPref(ACTIONBAR_KEY, this.mActionBarMode, 2);
        this.mOrientation = this.readIntPref(ORIENTATION_KEY, this.mOrientation, 2);
        this.mFontSize = this.readIntPref(FONTSIZE_KEY, this.mFontSize, 288);
        this.mColorId = this.readIntPref(COLOR_KEY, this.mColorId, COLOR_SCHEMES.length - 1);
        this.mUTF8ByDefault = this.readBooleanPref(UTF8_KEY, this.mUTF8ByDefault);
        this.mBackKeyAction = this.readIntPref(BACKACTION_KEY, this.mBackKeyAction, 4);
        this.mControlKeyId = this.readIntPref(CONTROLKEY_KEY, this.mControlKeyId, CONTROL_KEY_SCHEMES.length - 1);
        this.mFnKeyId = this.readIntPref(FNKEY_KEY, this.mFnKeyId, FN_KEY_SCHEMES.length - 1);
        this.mUseCookedIME = this.readIntPref(IME_KEY, this.mUseCookedIME, 1);
        this.mShell = this.readStringPref(SHELL_KEY, this.mShell);
        this.mInitialCommand = this.readStringPref(INITIALCOMMAND_KEY, this.mInitialCommand);
        this.mTermType = this.readStringPref(TERMTYPE_KEY, this.mTermType);
        this.mCloseOnExit = this.readBooleanPref(CLOSEONEXIT_KEY, this.mCloseOnExit);
        this.mVerifyPath = this.readBooleanPref(VERIFYPATH_KEY, this.mVerifyPath);
        this.mDoPathExtensions = this.readBooleanPref(PATHEXTENSIONS_KEY, this.mDoPathExtensions);
        this.mAllowPathPrepend = this.readBooleanPref(PATHPREPEND_KEY, this.mAllowPathPrepend);
        this.mHomePath = this.readStringPref(HOMEPATH_KEY, this.mHomePath);
        this.mAltSendsEsc = this.readBooleanPref(ALT_SENDS_ESC, this.mAltSendsEsc);
        this.mMouseTracking = this.readBooleanPref(MOUSE_TRACKING, this.mMouseTracking);
        this.mUseKeyboardShortcuts = this.readBooleanPref(USE_KEYBOARD_SHORTCUTS, this.mUseKeyboardShortcuts);
        this.mPrefs = null;
    }

    private int readIntPref(String key, int defaultValue, int maxValue) {
        int val;
        try {
            val = Integer.parseInt(this.mPrefs.getString(key, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException e) {
            val = defaultValue;
        }
        val = Math.max(0, Math.min(val, maxValue));
        return val;
    }

    private String readStringPref(String key, String defaultValue) {
        return this.mPrefs.getString(key, defaultValue);
    }

    private boolean readBooleanPref(String key, boolean defaultValue) {
        return this.mPrefs.getBoolean(key, defaultValue);
    }

    public boolean showStatusBar() {
        return this.mStatusBar != 0;
    }

    public int actionBarMode() {
        return this.mActionBarMode;
    }

    public int getScreenOrientation() {
        return this.mOrientation;
    }

    public int getCursorStyle() {
        return this.mCursorStyle;
    }

    public int getCursorBlink() {
        return this.mCursorBlink;
    }

    public int getFontSize() {
        return this.mFontSize;
    }

    public int[] getColorScheme() {
        return COLOR_SCHEMES[this.mColorId];
    }

    public boolean defaultToUTF8Mode() {
        return this.mUTF8ByDefault;
    }

    public int getBackKeyAction() {
        return this.mBackKeyAction;
    }

    public boolean backKeySendsCharacter() {
        return this.mBackKeyAction >= 3;
    }

    public boolean getAltSendsEscFlag() {
        return this.mAltSendsEsc;
    }

    public boolean getMouseTrackingFlag() {
        return this.mMouseTracking;
    }

    public boolean getUseKeyboardShortcutsFlag() {
        return this.mUseKeyboardShortcuts;
    }

    public int getBackKeyCharacter() {
        switch (this.mBackKeyAction) {
            case 3: {
                return 27;
            }
            case 4: {
                return 9;
            }
        }
        return 0;
    }

    public int getControlKeyId() {
        return this.mControlKeyId;
    }

    public int getFnKeyId() {
        return this.mFnKeyId;
    }

    public int getControlKeyCode() {
        return CONTROL_KEY_SCHEMES[this.mControlKeyId];
    }

    public int getFnKeyCode() {
        return FN_KEY_SCHEMES[this.mFnKeyId];
    }

    public boolean useCookedIME() {
        return this.mUseCookedIME != 0;
    }

    public String getShell() {
        return this.mShell;
    }

    public String getFailsafeShell() {
        return this.mFailsafeShell;
    }

    public String getInitialCommand() {
        return this.mInitialCommand;
    }

    public String getTermType() {
        return this.mTermType;
    }

    public boolean closeWindowOnProcessExit() {
        return this.mCloseOnExit;
    }

    public boolean verifyPath() {
        return this.mVerifyPath;
    }

    public boolean doPathExtensions() {
        return this.mDoPathExtensions;
    }

    public boolean allowPathPrepend() {
        return this.mAllowPathPrepend;
    }

    public void setPrependPath(String prependPath) {
        this.mPrependPath = prependPath;
    }

    public String getPrependPath() {
        return this.mPrependPath;
    }

    public void setAppendPath(String appendPath) {
        this.mAppendPath = appendPath;
    }

    public String getAppendPath() {
        return this.mAppendPath;
    }

    public void setHomePath(String homePath) {
        this.mHomePath = homePath;
    }

    public String getHomePath() {
        return this.mHomePath;
    }
}

