/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.util;

import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.UpdateCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class SessionList
extends ArrayList<TermSession> {
    LinkedList<UpdateCallback> callbacks = new LinkedList();
    LinkedList<UpdateCallback> titleChangedListeners = new LinkedList();
    UpdateCallback mTitleChangedListener = new UpdateCallback(){

        public void onUpdate() {
            SessionList.this.notifyTitleChanged();
        }
    };

    public SessionList() {
    }

    public SessionList(int capacity) {
        super(capacity);
    }

    public void addCallback(UpdateCallback callback) {
        this.callbacks.add(callback);
        callback.onUpdate();
    }

    public boolean removeCallback(UpdateCallback callback) {
        return this.callbacks.remove(callback);
    }

    private void notifyChange() {
        for (UpdateCallback callback : this.callbacks) {
            callback.onUpdate();
        }
    }

    public void addTitleChangedListener(UpdateCallback listener) {
        this.titleChangedListeners.add(listener);
        listener.onUpdate();
    }

    public boolean removeTitleChangedListener(UpdateCallback listener) {
        return this.titleChangedListeners.remove(listener);
    }

    private void notifyTitleChanged() {
        for (UpdateCallback listener : this.titleChangedListeners) {
            listener.onUpdate();
        }
    }

    @Override
    public boolean add(TermSession object) {
        boolean result = super.add(object);
        object.setTitleChangedListener(this.mTitleChangedListener);
        this.notifyChange();
        return result;
    }

    @Override
    public void add(int index, TermSession object) {
        super.add(index, object);
        object.setTitleChangedListener(this.mTitleChangedListener);
        this.notifyChange();
    }

    @Override
    public boolean addAll(Collection<? extends TermSession> collection) {
        boolean result = super.addAll(collection);
        for (TermSession termSession : collection) {
            termSession.setTitleChangedListener(this.mTitleChangedListener);
        }
        this.notifyChange();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TermSession> collection) {
        boolean result = super.addAll(index, collection);
        for (TermSession termSession : collection) {
            termSession.setTitleChangedListener(this.mTitleChangedListener);
        }
        this.notifyChange();
        return result;
    }

    @Override
    public void clear() {
        for (TermSession session : this) {
            session.setTitleChangedListener(null);
        }
        super.clear();
        this.notifyChange();
    }

    @Override
    public TermSession remove(int index) {
        TermSession object = (TermSession)super.remove(index);
        if (object != null) {
            object.setTitleChangedListener(null);
            this.notifyChange();
        }
        return object;
    }

    @Override
    public boolean remove(Object object) {
        boolean result = super.remove(object);
        if (result && object instanceof TermSession) {
            ((TermSession)object).setTitleChangedListener(null);
            this.notifyChange();
        }
        return result;
    }

    @Override
    public TermSession set(int index, TermSession object) {
        TermSession old = super.set(index, object);
        object.setTitleChangedListener(this.mTitleChangedListener);
        if (old != null) {
            old.setTitleChangedListener(null);
        }
        this.notifyChange();
        return old;
    }
}

