/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.shortcuts;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.FloatMath;

public class TextIcon {
    public static Bitmap getTextIcon(String text, int color, int width, int height) {
        text = text.trim();
        String[] lines = text.split("\\s*\n\\s*");
        int nLines = lines.length;
        Rect R2 = new Rect();
        Paint p = new Paint(1);
        p.setShadowLayer(2.0f, 10.0f, 10.0f, -16777216);
        p.setColor(color);
        p.setSubpixelText(true);
        p.setTextSize(256.0f);
        p.setTextAlign(Paint.Align.CENTER);
        float[] HH = new float[nLines];
        float H = 0.0f;
        float W = 0.0f;
        for (int i = 0; i < nLines; ++i) {
            p.getTextBounds(lines[i], 0, lines[i].length(), R2);
            float h = Float.valueOf(Math.abs(R2.top - R2.bottom)).floatValue();
            float w = Float.valueOf(Math.abs(R2.right - R2.left)).floatValue();
            if (nLines > 1) {
                h += 0.1f * h;
            }
            HH[i] = h;
            H += h;
            if (!(w > W)) continue;
            W = w;
        }
        float f = (float)width * H / (float)height;
        int hBitmap = (int)H;
        int wBitmap = (int)W;
        if (W < f) {
            wBitmap = (int)FloatMath.ceil((float)f);
            hBitmap = (int)FloatMath.ceil((float)H);
        } else {
            wBitmap = (int)FloatMath.ceil((float)W);
            hBitmap = (int)FloatMath.ceil((float)(height * wBitmap / width));
        }
        Bitmap b = Bitmap.createBitmap((int)wBitmap, (int)hBitmap, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        b.setDensity(0);
        Canvas c = new Canvas(b);
        W = (float)wBitmap / 2.0f;
        float top = (float)hBitmap / 2.0f - H / 2.0f + HH[0] / 2.0f;
        for (int i = 0; i < nLines; ++i) {
            c.drawText(lines[i], W, top += HH[i] / 2.0f, p);
            top += HH[i] / 2.0f;
        }
        return Bitmap.createScaledBitmap((Bitmap)b, (int)width, (int)height, (boolean)true);
    }
}

