/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.shortcuts;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import jackpal.androidterm.R;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class FSNavigator
extends Activity {
    private final int ACTION_THEME_SWAP = 256;
    private final int BUTTON_SIZE = 150;
    private Context context = this;
    private float textLg = 24.0f;
    private int theme = 16973829;
    private SharedPreferences SP;
    private File cd;
    private File extSdCardFile;
    private String extSdCard;
    private HashMap<Integer, LinearLayout> cachedFileView;
    private HashMap<Integer, LinearLayout> cachedDirectoryView;
    private HashMap<Integer, TextView> cachedDividerView;
    private int countFileView;
    private int countDirectoryView;
    private int countDividerView;
    private LinearLayout contentView;
    private LinearLayout titleView;
    private LinearLayout pathEntryView;
    View.OnClickListener fileListener = new View.OnClickListener(){

        public void onClick(View view) {
            String path = (String)view.getTag();
            if (path != null) {
                FSNavigator.this.setResult(-1, FSNavigator.this.getIntent().setData(Uri.fromFile((File)new File(FSNavigator.this.cd, path))));
                FSNavigator.this.finish();
            }
        }
    };
    View.OnClickListener directoryListener = new View.OnClickListener(){

        public void onClick(View view) {
            String path = (String)view.getTag();
            if (path != null) {
                File file = new File(path);
                if (file.isFile()) {
                    FSNavigator.this.setResult(-1, FSNavigator.this.getIntent().setData(Uri.fromFile((File)file)));
                    FSNavigator.this.finish();
                } else {
                    FSNavigator.this.chdir(file);
                }
                FSNavigator.this.makeView();
            }
        }
    };
    Comparator<String> stringSortComparator = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.toLowerCase().compareTo(b.toLowerCase());
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        String path;
        super.onCreate(savedInstanceState);
        this.setTitle(this.getString(R.string.fsnavigator_title));
        this.SP = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        this.theme = this.SP.getInt("theme", this.theme);
        this.setTheme(this.theme);
        this.getWindow().setSoftInputMode(3);
        Intent intent = this.getIntent();
        this.extSdCardFile = Environment.getExternalStorageDirectory();
        this.extSdCard = this.getCanonicalPath(this.extSdCardFile);
        Uri uri = intent.getData();
        String string2 = path = uri == null ? null : uri.getPath();
        if (null == path || null == this.chdir(path)) {
            this.chdir(this.extSdCard);
        }
        if (intent.hasExtra("title")) {
            this.setTitle(intent.getStringExtra("title"));
        }
        this.titleView = this.directoryEntry("..");
        this.pathEntryView = this.fileEntry(null);
        this.contentView = this.makeContentView();
        this.cachedDirectoryView = new HashMap();
        this.cachedFileView = new HashMap();
        this.cachedDividerView = new HashMap();
    }

    public void onPause() {
        super.onPause();
        this.doPause();
    }

    private void doPause() {
        this.SP.edit().putString("lastDirectory", this.getCanonicalPath(this.cd)).commit();
    }

    public void onResume() {
        super.onResume();
        this.doResume();
    }

    private void doResume() {
        this.makeView();
    }

    private void swapTheme() {
        switch (this.theme) {
            case 16973829: {
                this.theme = 16973836;
                break;
            }
            case 16973836: {
                this.theme = 16973829;
                break;
            }
            default: {
                return;
            }
        }
        this.SP.edit().putInt("theme", this.theme).commit();
        this.startActivityForResult(this.getIntent().addFlags(0x2000000), -1);
        this.finish();
    }

    private String ifAvailable(String goTo) {
        if (goTo.startsWith(this.extSdCard)) {
            String s = Environment.getExternalStorageState();
            if (s.equals("mounted") || s.equals("mounted_ro")) {
                return goTo;
            }
            this.toast(this.getString(R.string.fsnavigator_no_external_storage), 1);
            return this.extSdCard;
        }
        return goTo;
    }

    private File chdir(File file) {
        String path = this.ifAvailable(this.getCanonicalPath(file));
        System.setProperty("user.dir", path);
        this.cd = new File(path);
        return this.cd;
    }

    private File chdir(String path) {
        return this.chdir(new File(path));
    }

    private TextView entryDividerH() {
        TextView tv;
        if (this.countDividerView < this.cachedDividerView.size()) {
            tv = this.cachedDividerView.get(this.countDividerView);
        } else {
            tv = new TextView(this.context);
            tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1, 1.0f));
            this.cachedDividerView.put(this.countDividerView, tv);
        }
        ++this.countDividerView;
        return tv;
    }

    private LinearLayout fileView(boolean entryWindow) {
        EditText tv;
        LinearLayout ll = new LinearLayout(this.context);
        ll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        ll.setOrientation(0);
        ll.setGravity(119);
        if (entryWindow) {
            tv = new EditText(this.context);
            tv.setHint((CharSequence)this.getString(R.string.fsnavigator_optional_enter_path));
            tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 2.0f));
            tv.setOnKeyListener(new View.OnKeyListener((TextView)tv){
                final /* synthetic */ TextView val$tv;
                {
                    this.val$tv = textView;
                }

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (keyCode == 66) {
                        String path = this.val$tv.getText().toString();
                        File file = new File(FSNavigator.this.getCanonicalPath(path));
                        FSNavigator.this.chdir(file.getParentFile() == null ? file : file.getParentFile());
                        if (file.isFile()) {
                            FSNavigator.this.setResult(-1, FSNavigator.this.getIntent().setData(Uri.fromFile((File)file)));
                            FSNavigator.this.finish();
                        } else {
                            FSNavigator.this.chdir(file);
                            FSNavigator.this.makeView();
                        }
                        return true;
                    }
                    return false;
                }
            });
            ll.addView((View)tv);
        } else {
            tv = new TextView(this.context);
            tv.setClickable(true);
            tv.setLongClickable(true);
            tv.setOnClickListener(this.fileListener);
            tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
            HorizontalScrollView hv = new HorizontalScrollView(this.context);
            hv.setFillViewport(true);
            hv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 150, 7.0f));
            hv.addView((View)tv);
            ll.addView((View)hv);
        }
        tv.setFocusable(true);
        tv.setSingleLine();
        tv.setTextSize(this.textLg);
        tv.setTypeface(Typeface.SERIF, 1);
        tv.setGravity(19);
        tv.setPadding(10, 5, 10, 5);
        tv.setId(R.id.textview);
        return ll;
    }

    private LinearLayout fileEntry(String entry) {
        LinearLayout ll;
        if (entry == null) {
            ll = this.fileView(entry == null);
        } else {
            if (this.countFileView < this.cachedFileView.size()) {
                ll = this.cachedFileView.get(this.countFileView);
            } else {
                ll = this.fileView(entry == null);
                this.cachedFileView.put(this.countFileView, ll);
            }
            ++this.countFileView;
        }
        TextView tv = (TextView)ll.findViewById(R.id.textview);
        tv.setText((CharSequence)(entry == null ? "" : entry));
        tv.setTag((Object)(entry == null ? "" : entry));
        return ll;
    }

    private ImageView imageViewFolder(boolean up) {
        ImageView b1 = new ImageView(this.context);
        b1.setClickable(true);
        b1.setFocusable(true);
        b1.setId(R.id.imageview);
        b1.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(120, 120, 1.0f));
        b1.setImageResource(up ? R.drawable.ic_folderup : R.drawable.ic_folder);
        b1.setOnClickListener(this.directoryListener);
        b1.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        return b1;
    }

    private LinearLayout directoryView(boolean up) {
        ImageView b1 = this.imageViewFolder(up);
        TextView tv = new TextView(this.context);
        if (up) {
            tv.setGravity(19);
        } else {
            tv.setGravity(19);
        }
        tv.setClickable(true);
        tv.setLongClickable(true);
        tv.setFocusable(true);
        tv.setOnClickListener(this.directoryListener);
        tv.setMaxLines(1);
        tv.setTextSize(this.textLg);
        tv.setPadding(10, 5, 10, 5);
        tv.setId(R.id.textview);
        tv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 150, 1.0f));
        HorizontalScrollView hv = new HorizontalScrollView(this.context);
        hv.addView((View)tv);
        hv.setFillViewport(true);
        hv.setFocusable(true);
        hv.setOnClickListener(this.directoryListener);
        hv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 150, 7.0f));
        LinearLayout ll = new LinearLayout(this.context);
        ll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 150, 2.0f));
        ll.setOrientation(0);
        ll.setGravity(119);
        ll.setOnClickListener(this.directoryListener);
        ll.addView((View)b1);
        ll.addView((View)hv);
        return ll;
    }

    private LinearLayout directoryEntry(String name) {
        LinearLayout ll;
        boolean up = name.equals("..");
        if (up) {
            ll = this.directoryView(up);
        } else {
            if (this.countDirectoryView < this.cachedDirectoryView.size()) {
                ll = this.cachedDirectoryView.get(this.countDirectoryView);
            } else {
                ll = this.directoryView(up);
                this.cachedDirectoryView.put(this.countDirectoryView, ll);
            }
            ++this.countDirectoryView;
        }
        TextView tv = (TextView)ll.findViewById(R.id.textview);
        tv.setTag((Object)name);
        tv.setText((CharSequence)(up ? "[" + this.cd.getPath() + "]" : name));
        ((ImageView)ll.findViewById(R.id.imageview)).setTag((Object)name);
        return ll;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.finish();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private LinearLayout makeContentView() {
        LinearLayout ll = new LinearLayout(this.context);
        ll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        ll.setId(R.id.mainview);
        ll.setOrientation(1);
        ll.setGravity(119);
        ScrollView sv = new ScrollView(this.context);
        sv.setId(R.id.scrollview);
        sv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        sv.addView((View)ll);
        LinearLayout bg = new LinearLayout(this.context);
        bg.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        bg.setOrientation(1);
        bg.setGravity(119);
        bg.setTag((Object)ll);
        bg.addView((View)this.titleView, -1, -2);
        bg.addView((View)sv);
        bg.addView((View)this.pathEntryView, -1, -2);
        return bg;
    }

    private void makeView() {
        String[] zf;
        String path;
        this.countFileView = 0;
        this.countDirectoryView = 0;
        ScrollView sv = (ScrollView)this.contentView.findViewById(R.id.scrollview);
        LinearLayout ll = (LinearLayout)sv.findViewById(R.id.mainview);
        ll.removeAllViews();
        if (this.cd == null) {
            this.chdir("/");
        }
        if ((path = this.getCanonicalPath(this.cd)).equals("")) {
            path = "/";
            this.chdir("/");
        }
        if (path.equals("/")) {
            this.titleView.setVisibility(8);
        } else {
            this.titleView.setVisibility(0);
            this.titleView.requestLayout();
            ((TextView)this.titleView.findViewById(R.id.textview)).setText((CharSequence)("[" + this.cd.getPath() + "]"));
        }
        String[] zd = this.cd.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return new File(file, name).isDirectory();
            }
        });
        if (zd != null) {
            Arrays.sort(zd, 0, zd.length, this.stringSortComparator);
            int n = zd.length;
            for (int i = 0; i < n; ++i) {
                if (zd[i].equals(".")) continue;
                ll.addView((View)this.directoryEntry(zd[i]));
                ll.addView((View)this.entryDividerH());
            }
        }
        if ((zf = this.cd.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return !new File(file, name).isDirectory();
            }
        })) != null) {
            Arrays.sort(zf, 0, zf.length, this.stringSortComparator);
            int n = zf.length;
            for (int i = 0; i < n; ++i) {
                ll.addView((View)this.fileEntry(zf[i]));
                ll.addView((View)this.entryDividerH());
            }
        }
        ((TextView)this.pathEntryView.findViewById(R.id.textview)).setText((CharSequence)"");
        sv.scrollTo(0, 0);
        this.setContentView((View)this.contentView);
    }

    String getCanonicalPath(String path) {
        return this.getCanonicalPath(new File(path));
    }

    String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getPath();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        menu2.add(0, 256, 0, (CharSequence)this.getString(R.string.fsnavigator_change_theme));
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        super.onOptionsItemSelected(item);
        return this.doOptionsItem(item.getItemId());
    }

    private boolean doOptionsItem(int itemId) {
        switch (itemId) {
            case 256: {
                this.swapTheme();
                return true;
            }
        }
        return false;
    }

    private void toast(final String message, final int duration) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)FSNavigator.this.context, (CharSequence)message, (int)(duration == 0 ? 0 : 1)).show();
            }
        });
    }
}

