/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.compat;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ServiceForegroundCompat {
    private static Class<?>[] mSetForegroundSig = new Class[]{Boolean.TYPE};
    private static Class<?>[] mStartForegroundSig = new Class[]{Integer.TYPE, Notification.class};
    private static Class<?>[] mStopForegroundSig = new Class[]{Boolean.TYPE};
    private Service service;
    private NotificationManager mNM;
    private Method mSetForeground;
    private Method mStartForeground;
    private Method mStopForeground;
    private int notifyId;

    private void invokeMethod(Object receiver, Method method, Object ... args) {
        try {
            method.invoke(receiver, args);
        }
        catch (IllegalAccessException e) {
            Log.w((String)"ServiceCompat", (String)"Unable to invoke method", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)"ServiceCompat", (String)"Method threw exception", (Throwable)e.getCause());
        }
    }

    public void startForeground(int id, Notification notification) {
        if (this.mStartForeground != null) {
            this.invokeMethod(this.service, this.mStartForeground, id, notification);
            return;
        }
        this.invokeMethod(this.service, this.mSetForeground, Boolean.TRUE);
        this.mNM.notify(id, notification);
        this.notifyId = id;
    }

    public void stopForeground(boolean removeNotify) {
        if (this.mStopForeground != null) {
            this.invokeMethod(this.service, this.mStopForeground, removeNotify);
            return;
        }
        if (removeNotify) {
            this.mNM.cancel(this.notifyId);
        }
        this.invokeMethod(this.service, this.mSetForeground, Boolean.FALSE);
    }

    public ServiceForegroundCompat(Service service) {
        this.service = service;
        this.mNM = (NotificationManager)service.getSystemService("notification");
        Class<?> clazz = service.getClass();
        try {
            this.mStartForeground = clazz.getMethod("startForeground", mStartForegroundSig);
            this.mStopForeground = clazz.getMethod("stopForeground", mStopForegroundSig);
        }
        catch (NoSuchMethodException e) {
            this.mStopForeground = null;
            this.mStartForeground = null;
        }
        try {
            this.mSetForeground = clazz.getMethod("setForeground", mSetForegroundSig);
        }
        catch (NoSuchMethodException e) {
            this.mSetForeground = null;
        }
        if (this.mStartForeground == null && this.mSetForeground == null) {
            throw new IllegalStateException("Neither startForeground() or setForeground() present!");
        }
    }
}

