/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.app.Activity;
import android.app.ListActivity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import jackpal.androidterm.R;
import jackpal.androidterm.TermService;
import jackpal.androidterm.WindowListAdapter;
import jackpal.androidterm.compat.ActionBarCompat;
import jackpal.androidterm.compat.ActivityCompat;
import jackpal.androidterm.compat.AndroidCompat;
import jackpal.androidterm.util.SessionList;

public class WindowList
extends ListActivity {
    private SessionList sessions;
    private WindowListAdapter mWindowListAdapter;
    private TermService mTermService;
    private ServiceConnection mTSConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            TermService.TSBinder binder = (TermService.TSBinder)service;
            WindowList.this.mTermService = binder.getService();
            WindowList.this.populateList();
        }

        public void onServiceDisconnected(ComponentName arg0) {
            WindowList.this.mTermService = null;
        }
    };

    public void onCreate(Bundle icicle) {
        ActionBarCompat bar;
        super.onCreate(icicle);
        ListView listView = this.getListView();
        View newWindow = this.getLayoutInflater().inflate(R.layout.window_list_new_window, (ViewGroup)listView, false);
        listView.addHeaderView(newWindow, null, true);
        this.setResult(0);
        if (AndroidCompat.SDK >= 11 && (bar = ActivityCompat.getActionBar((Activity)this)) != null) {
            bar.setDisplayOptions(4, 4);
        }
    }

    protected void onResume() {
        super.onResume();
        Intent TSIntent = new Intent((Context)this, TermService.class);
        if (!this.bindService(TSIntent, this.mTSConnection, 1)) {
            Log.w((String)"Term", (String)"bind to service failed!");
        }
    }

    protected void onPause() {
        super.onPause();
        WindowListAdapter adapter = this.mWindowListAdapter;
        if (this.sessions != null) {
            this.sessions.removeCallback(adapter);
            this.sessions.removeTitleChangedListener(adapter);
        }
        if (adapter != null) {
            adapter.setSessions(null);
        }
        this.unbindService(this.mTSConnection);
    }

    private void populateList() {
        this.sessions = this.mTermService.getSessions();
        WindowListAdapter adapter = this.mWindowListAdapter;
        if (adapter == null) {
            adapter = new WindowListAdapter(this.sessions);
            this.setListAdapter((ListAdapter)adapter);
            this.mWindowListAdapter = adapter;
        } else {
            adapter.setSessions(this.sessions);
        }
        this.sessions.addCallback(adapter);
        this.sessions.addTitleChangedListener(adapter);
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Intent data = new Intent();
        data.putExtra("jackpal.androidterm.window_id", position - 1);
        this.setResult(-1, data);
        this.finish();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public static class CloseButton
    extends ImageView {
        public CloseButton(Context context) {
            super(context);
        }

        public CloseButton(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public CloseButton(Context context, AttributeSet attrs, int style2) {
            super(context, attrs, style2);
        }

        public void setPressed(boolean pressed) {
            if (pressed && ((View)this.getParent()).isPressed()) {
                return;
            }
            super.setPressed(pressed);
        }
    }
}

