/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Toast;
import android.widget.ViewFlipper;
import jackpal.androidterm.GenericTermSession;
import jackpal.androidterm.R;
import jackpal.androidterm.compat.AndroidCompat;
import jackpal.androidterm.emulatorview.EmulatorView;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.UpdateCallback;
import jackpal.androidterm.util.TermSettings;
import java.util.Iterator;
import java.util.LinkedList;

public class TermViewFlipper
extends ViewFlipper
implements Iterable<View> {
    private Context context;
    private Toast mToast;
    private LinkedList<UpdateCallback> callbacks;
    private boolean mStatusBarVisible = false;
    private int mCurWidth;
    private int mCurHeight;
    private Rect mVisibleRect = new Rect();
    private Rect mWindowRect = new Rect();
    private FrameLayout.LayoutParams mChildParams = null;
    private boolean mRedoLayout = false;
    private final boolean mbPollForWindowSizeChange = AndroidCompat.SDK < 8;
    private static final int SCREEN_CHECK_PERIOD = 1000;
    private final Handler mHandler = new Handler();
    private Runnable mCheckSize = new Runnable(){

        @Override
        public void run() {
            TermViewFlipper.this.adjustChildSize();
            TermViewFlipper.this.mHandler.postDelayed((Runnable)this, 1000L);
        }
    };

    public TermViewFlipper(Context context) {
        super(context);
        this.commonConstructor(context);
    }

    public TermViewFlipper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.commonConstructor(context);
    }

    private void commonConstructor(Context context) {
        this.context = context;
        this.callbacks = new LinkedList();
        this.updateVisibleRect();
        Rect visible = this.mVisibleRect;
        this.mChildParams = new FrameLayout.LayoutParams(visible.width(), visible.height(), 51);
    }

    public void updatePrefs(TermSettings settings) {
        boolean statusBarVisible = settings.showStatusBar();
        int[] colorScheme = settings.getColorScheme();
        this.setBackgroundColor(colorScheme[1]);
        this.mStatusBarVisible = statusBarVisible;
    }

    @Override
    public Iterator<View> iterator() {
        return new ViewFlipperIterator();
    }

    public void addCallback(UpdateCallback callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(UpdateCallback callback) {
        this.callbacks.remove(callback);
    }

    private void notifyChange() {
        for (UpdateCallback callback : this.callbacks) {
            callback.onUpdate();
        }
    }

    public void onPause() {
        if (this.mbPollForWindowSizeChange) {
            this.mHandler.removeCallbacks(this.mCheckSize);
        }
        this.pauseCurrentView();
    }

    public void onResume() {
        if (this.mbPollForWindowSizeChange) {
            this.mCheckSize.run();
        }
        this.resumeCurrentView();
    }

    public void pauseCurrentView() {
        EmulatorView view = (EmulatorView)this.getCurrentView();
        if (view == null) {
            return;
        }
        view.onPause();
    }

    public void resumeCurrentView() {
        EmulatorView view = (EmulatorView)this.getCurrentView();
        if (view == null) {
            return;
        }
        view.onResume();
        view.requestFocus();
    }

    private void showTitle() {
        if (this.getChildCount() == 0) {
            return;
        }
        EmulatorView view = (EmulatorView)this.getCurrentView();
        if (view == null) {
            return;
        }
        TermSession session = view.getTermSession();
        if (session == null) {
            return;
        }
        String title = this.context.getString(R.string.window_title, new Object[]{this.getDisplayedChild() + 1});
        if (session instanceof GenericTermSession) {
            title = ((GenericTermSession)session).getTitle(title);
        }
        if (this.mToast == null) {
            this.mToast = Toast.makeText((Context)this.context, (CharSequence)title, (int)0);
            this.mToast.setGravity(17, 0, 0);
        } else {
            this.mToast.setText((CharSequence)title);
        }
        this.mToast.show();
    }

    public void showPrevious() {
        this.pauseCurrentView();
        super.showPrevious();
        this.showTitle();
        this.resumeCurrentView();
        this.notifyChange();
    }

    public void showNext() {
        this.pauseCurrentView();
        super.showNext();
        this.showTitle();
        this.resumeCurrentView();
        this.notifyChange();
    }

    public void setDisplayedChild(int position) {
        this.pauseCurrentView();
        super.setDisplayedChild(position);
        this.showTitle();
        this.resumeCurrentView();
        this.notifyChange();
    }

    public void addView(View v, int index) {
        super.addView(v, index, (ViewGroup.LayoutParams)this.mChildParams);
    }

    public void addView(View v) {
        super.addView(v, (ViewGroup.LayoutParams)this.mChildParams);
    }

    private void updateVisibleRect() {
        Rect visible = this.mVisibleRect;
        Rect window = this.mWindowRect;
        this.getGlobalVisibleRect(visible);
        this.getWindowVisibleDisplayFrame(window);
        if (!this.mStatusBarVisible) {
            window.top = 0;
        }
        if (visible.width() == 0 && visible.height() == 0) {
            visible.left = window.left;
            visible.top = window.top;
        } else {
            if (visible.left < window.left) {
                visible.left = window.left;
            }
            if (visible.top < window.top) {
                visible.top = window.top;
            }
        }
        visible.right = window.right;
        visible.bottom = window.bottom;
    }

    private void adjustChildSize() {
        this.updateVisibleRect();
        Rect visible = this.mVisibleRect;
        int width = visible.width();
        int height = visible.height();
        if (this.mCurWidth != width || this.mCurHeight != height) {
            this.mCurWidth = width;
            this.mCurHeight = height;
            FrameLayout.LayoutParams params = this.mChildParams;
            params.width = width;
            params.height = height;
            for (View v : this) {
                this.updateViewLayout(v, (ViewGroup.LayoutParams)params);
            }
            this.mRedoLayout = true;
            EmulatorView currentView = (EmulatorView)this.getCurrentView();
            if (currentView != null) {
                currentView.updateSize(false);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.adjustChildSize();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mRedoLayout) {
            this.requestLayout();
            this.mRedoLayout = false;
        }
        super.onDraw(canvas);
    }

    class ViewFlipperIterator
    implements Iterator<View> {
        int pos = 0;

        ViewFlipperIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < TermViewFlipper.this.getChildCount();
        }

        @Override
        public View next() {
            return TermViewFlipper.this.getChildAt(this.pos++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

