/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.util.Log;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.GrowableIntArray;
import jackpal.androidterm.emulatorview.TermKeyListener;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.TextStyle;
import jackpal.androidterm.emulatorview.TranscriptScreen;
import jackpal.androidterm.emulatorview.UnicodeTranscript;
import jackpal.androidterm.emulatorview.UpdateCallback;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;

class TerminalEmulator {
    private TermKeyListener mKeyListener;
    private int mCursorRow;
    private int mCursorCol;
    private int mRows;
    private int mColumns;
    private TranscriptScreen mMainBuffer;
    private TranscriptScreen mAltBuffer;
    private TranscriptScreen mScreen;
    private TermSession mSession;
    private int mArgIndex;
    private static final int MAX_ESCAPE_PARAMETERS = 16;
    private int[] mArgs = new int[16];
    private byte[] mOSCArg = new byte[512];
    private int mOSCArgLength;
    private int mOSCArgTokenizerIndex;
    private static final int MAX_OSC_STRING_LENGTH = 512;
    private static final int ESC_NONE = 0;
    private static final int ESC = 1;
    private static final int ESC_POUND = 2;
    private static final int ESC_SELECT_LEFT_PAREN = 3;
    private static final int ESC_SELECT_RIGHT_PAREN = 4;
    private static final int ESC_LEFT_SQUARE_BRACKET = 5;
    private static final int ESC_LEFT_SQUARE_BRACKET_QUESTION_MARK = 6;
    private static final int ESC_PERCENT = 7;
    private static final int ESC_RIGHT_SQUARE_BRACKET = 8;
    private static final int ESC_RIGHT_SQUARE_BRACKET_ESC = 9;
    private boolean mContinueSequence;
    private int mEscapeState;
    private int mSavedCursorRow;
    private int mSavedCursorCol;
    private int mSavedEffect;
    private int mSavedDecFlags_DECSC_DECRC;
    private static final int K_132_COLUMN_MODE_MASK = 8;
    private static final int K_REVERSE_VIDEO_MASK = 32;
    private static final int K_ORIGIN_MODE_MASK = 64;
    private static final int K_WRAPAROUND_MODE_MASK = 128;
    private static final int K_SHOW_CURSOR_MASK = 0x2000000;
    private static final int K_DECSC_DECRC_MASK = 192;
    private int mDecFlags;
    private int mSavedDecFlags;
    private int mMouseTrackingMode;
    private boolean mInsertMode;
    private boolean[] mTabStop;
    private int mTopMargin;
    private int mBottomMargin;
    private boolean mAboutToAutoWrap;
    private int mLastEmittedCharWidth = 0;
    private boolean mJustWrapped = false;
    private int mProcessedCharCount;
    private int mForeColor;
    private int mDefaultForeColor;
    private int mBackColor;
    private int mDefaultBackColor;
    private int mEffect;
    private boolean mbKeypadApplicationMode;
    private boolean mAlternateCharSet;
    private static final int CHAR_SET_UK = 0;
    private static final int CHAR_SET_ASCII = 1;
    private static final int CHAR_SET_SPECIAL_GRAPHICS = 2;
    private static final int CHAR_SET_ALT_STANDARD = 3;
    private static final int CHAR_SET_ALT_SPECIAL_GRAPICS = 4;
    private int[] mCharSet = new int[2];
    private boolean mUseAlternateCharSet;
    private static final char[] mSpecialGraphicsCharMap = new char[128];
    private int mScrollCounter = 0;
    private static final int UNICODE_REPLACEMENT_CHAR = 65533;
    private boolean mDefaultUTF8Mode = false;
    private boolean mUTF8Mode = false;
    private boolean mUTF8EscapeUsed = false;
    private int mUTF8ToFollow = 0;
    private ByteBuffer mUTF8ByteBuffer;
    private CharBuffer mInputCharBuffer;
    private CharsetDecoder mUTF8Decoder;
    private UpdateCallback mUTF8ModeNotify;
    private static final boolean DEFAULT_TO_AUTOWRAP_ENABLED = true;

    public void setKeyListener(TermKeyListener l) {
        this.mKeyListener = l;
    }

    public TerminalEmulator(TermSession session, TranscriptScreen screen, int columns, int rows, ColorScheme scheme) {
        this.mSession = session;
        this.mScreen = this.mMainBuffer = screen;
        this.mAltBuffer = new TranscriptScreen(columns, rows, rows, scheme);
        this.mRows = rows;
        this.mColumns = columns;
        this.mTabStop = new boolean[this.mColumns];
        this.setColorScheme(scheme);
        this.mUTF8ByteBuffer = ByteBuffer.allocate(4);
        this.mInputCharBuffer = CharBuffer.allocate(2);
        this.mUTF8Decoder = Charset.forName("UTF-8").newDecoder();
        this.mUTF8Decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.mUTF8Decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.reset();
    }

    public TranscriptScreen getScreen() {
        return this.mScreen;
    }

    public void updateSize(int columns, int rows) {
        int end;
        if (this.mRows == rows && this.mColumns == columns) {
            return;
        }
        if (columns <= 0) {
            throw new IllegalArgumentException("rows:" + columns);
        }
        if (rows <= 0) {
            throw new IllegalArgumentException("rows:" + rows);
        }
        TranscriptScreen screen = this.mScreen;
        TranscriptScreen altScreen = screen != this.mMainBuffer ? this.mMainBuffer : this.mAltBuffer;
        int[] cursor = new int[]{this.mCursorCol, this.mCursorRow};
        boolean fastResize = screen.fastResize(columns, rows, cursor);
        GrowableIntArray cursorColor = null;
        String charAtCursor = null;
        GrowableIntArray colors = null;
        String transcriptText = null;
        if (!fastResize) {
            cursorColor = new GrowableIntArray(1);
            charAtCursor = screen.getSelectedText(cursorColor, this.mCursorCol, this.mCursorRow, this.mCursorCol, this.mCursorRow);
            screen.set(this.mCursorCol, this.mCursorRow, 27, 0);
            colors = new GrowableIntArray(1024);
            transcriptText = screen.getTranscriptText(colors);
            screen.resize(columns, rows, this.getStyle());
        }
        boolean altFastResize = true;
        GrowableIntArray altColors = null;
        String altTranscriptText = null;
        if (altScreen != null && !(altFastResize = altScreen.fastResize(columns, rows, null))) {
            altColors = new GrowableIntArray(1024);
            altTranscriptText = altScreen.getTranscriptText(altColors);
            altScreen.resize(columns, rows, this.getStyle());
        }
        if (this.mRows != rows) {
            this.mRows = rows;
            this.mTopMargin = 0;
            this.mBottomMargin = this.mRows;
        }
        if (this.mColumns != columns) {
            int oldColumns = this.mColumns;
            this.mColumns = columns;
            boolean[] oldTabStop = this.mTabStop;
            this.mTabStop = new boolean[this.mColumns];
            int toTransfer = Math.min(oldColumns, columns);
            System.arraycopy(oldTabStop, 0, this.mTabStop, 0, toTransfer);
        }
        if (!altFastResize) {
            boolean wasAboutToAutoWrap = this.mAboutToAutoWrap;
            this.mScreen = altScreen;
            this.mCursorRow = 0;
            this.mCursorCol = 0;
            this.mAboutToAutoWrap = false;
            int end2 = altTranscriptText.length() - 1;
            int colorOffset = 0;
            for (int i = 0; i <= end2; ++i) {
                char c = altTranscriptText.charAt(i);
                int style = altColors.at(i - colorOffset);
                if (Character.isHighSurrogate(c)) {
                    char cLow = altTranscriptText.charAt(++i);
                    this.emit(Character.toCodePoint(c, cLow), style);
                    ++colorOffset;
                    continue;
                }
                if (c == '\n') {
                    this.setCursorCol(0);
                    this.doLinefeed();
                    continue;
                }
                this.emit(c, style);
            }
            this.mScreen = screen;
            this.mAboutToAutoWrap = wasAboutToAutoWrap;
        }
        if (fastResize) {
            if (cursor[0] >= 0 && cursor[1] >= 0) {
                this.mCursorCol = cursor[0];
                this.mCursorRow = cursor[1];
            } else {
                this.mCursorCol = 0;
                this.mCursorRow = 0;
            }
            return;
        }
        this.mCursorRow = 0;
        this.mCursorCol = 0;
        this.mAboutToAutoWrap = false;
        int newCursorRow = -1;
        int newCursorCol = -1;
        int newCursorTranscriptPos = -1;
        for (end = transcriptText.length() - 1; end >= 0 && transcriptText.charAt(end) == '\n'; --end) {
        }
        int colorOffset = 0;
        for (int i = 0; i <= end; ++i) {
            char c = transcriptText.charAt(i);
            int style = colors.at(i - colorOffset);
            if (Character.isHighSurrogate(c)) {
                char cLow = transcriptText.charAt(++i);
                this.emit(Character.toCodePoint(c, cLow), style);
                ++colorOffset;
                continue;
            }
            if (c == '\n') {
                this.setCursorCol(0);
                this.doLinefeed();
                continue;
            }
            if (c == '\u001b') {
                newCursorRow = this.mCursorRow;
                newCursorCol = this.mCursorCol;
                newCursorTranscriptPos = screen.getActiveRows();
                if (charAtCursor == null || charAtCursor.length() <= 0) continue;
                int encodedCursorColor = cursorColor.at(0);
                this.emit(charAtCursor.toCharArray(), 0, charAtCursor.length(), encodedCursorColor);
                continue;
            }
            this.emit(c, style);
        }
        if (newCursorRow != -1 && newCursorCol != -1) {
            this.mCursorRow = newCursorRow;
            this.mCursorCol = newCursorCol;
            int scrollCount = screen.getActiveRows() - newCursorTranscriptPos;
            if (scrollCount > 0 && scrollCount <= newCursorRow) {
                this.mCursorRow -= scrollCount;
            } else if (scrollCount > newCursorRow) {
                this.mCursorRow = 0;
                this.mCursorCol = 0;
            }
        }
    }

    public final int getCursorRow() {
        return this.mCursorRow;
    }

    public final int getCursorCol() {
        return this.mCursorCol;
    }

    public final boolean getReverseVideo() {
        return (this.mDecFlags & 0x20) != 0;
    }

    public final boolean getShowCursor() {
        return (this.mDecFlags & 0x2000000) != 0;
    }

    public final boolean getKeypadApplicationMode() {
        return this.mbKeypadApplicationMode;
    }

    public final int getMouseTrackingMode() {
        return this.mMouseTrackingMode;
    }

    private void setDefaultTabStops() {
        for (int i = 0; i < this.mColumns; ++i) {
            this.mTabStop[i] = (i & 7) == 0 && i != 0;
        }
    }

    public void append(byte[] buffer, int base, int length) {
        for (int i = 0; i < length; ++i) {
            byte b = buffer[base + i];
            try {
                this.process(b);
                ++this.mProcessedCharCount;
                continue;
            }
            catch (Exception e) {
                Log.e((String)"EmulatorView", (String)("Exception while processing character " + Integer.toString(this.mProcessedCharCount) + " code " + Integer.toString(b)), (Throwable)e);
            }
        }
    }

    private void process(byte b) {
        this.process(b, true);
    }

    private void process(byte b, boolean doUTF8) {
        if (doUTF8 && this.mUTF8Mode && this.handleUTF8Sequence(b)) {
            return;
        }
        if ((b & 0x80) == 128 && (b & 0x7F) <= 31) {
            this.process((byte)27, false);
            this.process((byte)((b & 0x7F) + 64), false);
            return;
        }
        switch (b) {
            case 0: {
                break;
            }
            case 7: {
                if (this.mEscapeState != 8) break;
                this.doEscRightSquareBracket(b);
                break;
            }
            case 8: {
                this.setCursorCol(Math.max(0, this.mCursorCol - 1));
                break;
            }
            case 9: {
                this.setCursorCol(this.nextTabStop(this.mCursorCol));
                break;
            }
            case 13: {
                this.setCursorCol(0);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.doLinefeed();
                break;
            }
            case 14: {
                this.setAltCharSet(true);
                break;
            }
            case 15: {
                this.setAltCharSet(false);
                break;
            }
            case 24: 
            case 26: {
                if (this.mEscapeState == 0) break;
                this.mEscapeState = 0;
                this.emit((byte)127);
                break;
            }
            case 27: {
                if (this.mEscapeState != 8) {
                    this.startEscapeSequence(1);
                    break;
                }
                this.doEscRightSquareBracket(b);
                break;
            }
            default: {
                this.mContinueSequence = false;
                switch (this.mEscapeState) {
                    case 0: {
                        if (b < 32) break;
                        this.emit(b);
                        break;
                    }
                    case 1: {
                        this.doEsc(b);
                        break;
                    }
                    case 2: {
                        this.doEscPound(b);
                        break;
                    }
                    case 3: {
                        this.doEscSelectLeftParen(b);
                        break;
                    }
                    case 4: {
                        this.doEscSelectRightParen(b);
                        break;
                    }
                    case 5: {
                        this.doEscLeftSquareBracket(b);
                        break;
                    }
                    case 6: {
                        this.doEscLSBQuest(b);
                        break;
                    }
                    case 7: {
                        this.doEscPercent(b);
                        break;
                    }
                    case 8: {
                        this.doEscRightSquareBracket(b);
                        break;
                    }
                    case 9: {
                        this.doEscRightSquareBracketEsc(b);
                        break;
                    }
                    default: {
                        this.unknownSequence(b);
                    }
                }
                if (this.mContinueSequence) break;
                this.mEscapeState = 0;
            }
        }
    }

    private boolean handleUTF8Sequence(byte b) {
        if (this.mUTF8ToFollow == 0 && (b & 0x80) == 0) {
            return false;
        }
        if (this.mUTF8ToFollow > 0) {
            if ((b & 0xC0) != 128) {
                this.mUTF8ToFollow = 0;
                this.mUTF8ByteBuffer.clear();
                this.emit(65533);
                return this.handleUTF8Sequence(b);
            }
            this.mUTF8ByteBuffer.put(b);
            if (--this.mUTF8ToFollow == 0) {
                ByteBuffer byteBuf = this.mUTF8ByteBuffer;
                CharBuffer charBuf = this.mInputCharBuffer;
                CharsetDecoder decoder = this.mUTF8Decoder;
                byteBuf.rewind();
                decoder.reset();
                decoder.decode(byteBuf, charBuf, true);
                decoder.flush(charBuf);
                char[] chars = charBuf.array();
                if (chars[0] >= '\u0080' && chars[0] <= '\u009f') {
                    this.process((byte)chars[0], false);
                } else {
                    this.emit(chars);
                }
                byteBuf.clear();
                charBuf.clear();
            }
        } else {
            if ((b & 0xE0) == 192) {
                this.mUTF8ToFollow = 1;
            } else if ((b & 0xF0) == 224) {
                this.mUTF8ToFollow = 2;
            } else if ((b & 0xF8) == 240) {
                this.mUTF8ToFollow = 3;
            } else {
                this.emit(65533);
                return true;
            }
            this.mUTF8ByteBuffer.put(b);
        }
        return true;
    }

    private void setAltCharSet(boolean alternateCharSet) {
        this.mAlternateCharSet = alternateCharSet;
        this.computeEffectiveCharSet();
    }

    private void computeEffectiveCharSet() {
        int charSet = this.mCharSet[this.mAlternateCharSet ? 1 : 0];
        this.mUseAlternateCharSet = charSet == 2;
    }

    private int nextTabStop(int cursorCol) {
        for (int i = cursorCol + 1; i < this.mColumns; ++i) {
            if (!this.mTabStop[i]) continue;
            return i;
        }
        return this.mColumns - 1;
    }

    private int prevTabStop(int cursorCol) {
        for (int i = cursorCol - 1; i >= 0; --i) {
            if (!this.mTabStop[i]) continue;
            return i;
        }
        return 0;
    }

    private void doEscPercent(byte b) {
        switch (b) {
            case 64: {
                this.setUTF8Mode(false);
                this.mUTF8EscapeUsed = true;
                break;
            }
            case 71: {
                this.setUTF8Mode(true);
                this.mUTF8EscapeUsed = true;
                break;
            }
        }
    }

    private void doEscLSBQuest(byte b) {
        int arg = this.getArg0(0);
        int mask = this.getDecFlagsMask(arg);
        int oldFlags = this.mDecFlags;
        switch (b) {
            case 104: {
                this.mDecFlags |= mask;
                switch (arg) {
                    case 1: {
                        this.mKeyListener.setCursorKeysApplicationMode(true);
                        break;
                    }
                    case 47: 
                    case 1047: 
                    case 1049: {
                        if (this.mAltBuffer == null) break;
                        this.mScreen = this.mAltBuffer;
                    }
                }
                if (arg < 1000 || arg > 1003) break;
                this.mMouseTrackingMode = arg;
                break;
            }
            case 108: {
                this.mDecFlags &= ~mask;
                switch (arg) {
                    case 1: {
                        this.mKeyListener.setCursorKeysApplicationMode(false);
                        break;
                    }
                    case 47: 
                    case 1047: 
                    case 1049: {
                        this.mScreen = this.mMainBuffer;
                    }
                }
                if (arg < 1000 || arg > 1003) break;
                this.mMouseTrackingMode = 0;
                break;
            }
            case 114: {
                this.mDecFlags = this.mDecFlags & ~mask | this.mSavedDecFlags & mask;
                break;
            }
            case 115: {
                this.mSavedDecFlags = this.mSavedDecFlags & ~mask | this.mDecFlags & mask;
                break;
            }
            default: {
                this.parseArg(b);
            }
        }
        int newlySetFlags = ~oldFlags & this.mDecFlags;
        int changedFlags = oldFlags ^ this.mDecFlags;
        if ((changedFlags & 8) != 0) {
            this.blockClear(0, 0, this.mColumns, this.mRows);
            this.setCursorRowCol(0, 0);
        }
        if ((newlySetFlags & 0x40) != 0) {
            this.setCursorPosition(0, 0);
        }
    }

    private int getDecFlagsMask(int argument) {
        if (argument >= 1 && argument <= 32) {
            return 1 << argument;
        }
        return 0;
    }

    private void startEscapeSequence(int escapeState) {
        this.mEscapeState = escapeState;
        this.mArgIndex = 0;
        for (int j = 0; j < 16; ++j) {
            this.mArgs[j] = -1;
        }
    }

    private void doLinefeed() {
        int newCursorRow = this.mCursorRow + 1;
        if (newCursorRow >= this.mBottomMargin) {
            this.scroll();
            newCursorRow = this.mBottomMargin - 1;
        }
        this.setCursorRow(newCursorRow);
    }

    private void continueSequence() {
        this.mContinueSequence = true;
    }

    private void continueSequence(int state) {
        this.mEscapeState = state;
        this.mContinueSequence = true;
    }

    private void doEscSelectLeftParen(byte b) {
        this.doSelectCharSet(0, b);
    }

    private void doEscSelectRightParen(byte b) {
        this.doSelectCharSet(1, b);
    }

    private void doSelectCharSet(int charSetIndex, byte b) {
        int charSet;
        switch (b) {
            case 65: {
                charSet = 0;
                break;
            }
            case 66: {
                charSet = 1;
                break;
            }
            case 48: {
                charSet = 2;
                break;
            }
            case 49: {
                charSet = 3;
                break;
            }
            case 50: {
                charSet = 4;
                break;
            }
            default: {
                this.unknownSequence(b);
                return;
            }
        }
        this.mCharSet[charSetIndex] = charSet;
        this.computeEffectiveCharSet();
    }

    private void doEscPound(byte b) {
        switch (b) {
            case 56: {
                this.mScreen.blockSet(0, 0, this.mColumns, this.mRows, 69, this.getStyle());
                break;
            }
            default: {
                this.unknownSequence(b);
            }
        }
    }

    private void doEsc(byte b) {
        switch (b) {
            case 35: {
                this.continueSequence(2);
                break;
            }
            case 40: {
                this.continueSequence(3);
                break;
            }
            case 41: {
                this.continueSequence(4);
                break;
            }
            case 55: {
                this.mSavedCursorRow = this.mCursorRow;
                this.mSavedCursorCol = this.mCursorCol;
                this.mSavedEffect = this.mEffect;
                this.mSavedDecFlags_DECSC_DECRC = this.mDecFlags & 0xC0;
                break;
            }
            case 56: {
                this.setCursorRowCol(this.mSavedCursorRow, this.mSavedCursorCol);
                this.mEffect = this.mSavedEffect;
                this.mDecFlags = this.mDecFlags & 0xFFFFFF3F | this.mSavedDecFlags_DECSC_DECRC;
                break;
            }
            case 68: {
                this.doLinefeed();
                break;
            }
            case 69: {
                this.setCursorCol(0);
                this.doLinefeed();
                break;
            }
            case 70: {
                this.setCursorRowCol(0, this.mBottomMargin - 1);
                break;
            }
            case 72: {
                this.mTabStop[this.mCursorCol] = true;
                break;
            }
            case 77: {
                if (this.mCursorRow <= this.mTopMargin) {
                    this.mScreen.blockCopy(0, this.mTopMargin, this.mColumns, this.mBottomMargin - (this.mTopMargin + 1), 0, this.mTopMargin + 1);
                    this.blockClear(0, this.mTopMargin, this.mColumns);
                    break;
                }
                --this.mCursorRow;
                break;
            }
            case 78: {
                this.unimplementedSequence(b);
                break;
            }
            case 48: {
                this.unimplementedSequence(b);
                break;
            }
            case 80: {
                this.unimplementedSequence(b);
                break;
            }
            case 90: {
                this.sendDeviceAttributes();
                break;
            }
            case 91: {
                this.continueSequence(5);
                break;
            }
            case 61: {
                this.mbKeypadApplicationMode = true;
                break;
            }
            case 93: {
                this.startCollectingOSCArgs();
                this.continueSequence(8);
                break;
            }
            case 62: {
                this.mbKeypadApplicationMode = false;
                break;
            }
            default: {
                this.unknownSequence(b);
            }
        }
    }

    private void doEscLeftSquareBracket(byte b) {
        block0 : switch (b) {
            case 64: {
                int charsAfterCursor = this.mColumns - this.mCursorCol;
                int charsToInsert = Math.min(this.getArg0(1), charsAfterCursor);
                int charsToMove = charsAfterCursor - charsToInsert;
                this.mScreen.blockCopy(this.mCursorCol, this.mCursorRow, charsToMove, 1, this.mCursorCol + charsToInsert, this.mCursorRow);
                this.blockClear(this.mCursorCol, this.mCursorRow, charsToInsert);
                break;
            }
            case 65: {
                this.setCursorRow(Math.max(this.mTopMargin, this.mCursorRow - this.getArg0(1)));
                break;
            }
            case 66: {
                this.setCursorRow(Math.min(this.mBottomMargin - 1, this.mCursorRow + this.getArg0(1)));
                break;
            }
            case 67: {
                this.setCursorCol(Math.min(this.mColumns - 1, this.mCursorCol + this.getArg0(1)));
                break;
            }
            case 68: {
                this.setCursorCol(Math.max(0, this.mCursorCol - this.getArg0(1)));
                break;
            }
            case 71: {
                this.setCursorCol(Math.min(Math.max(1, this.getArg0(1)), this.mColumns) - 1);
                break;
            }
            case 72: {
                this.setHorizontalVerticalPosition();
                break;
            }
            case 74: {
                switch (this.getArg0(0)) {
                    case 0: {
                        this.blockClear(this.mCursorCol, this.mCursorRow, this.mColumns - this.mCursorCol);
                        this.blockClear(0, this.mCursorRow + 1, this.mColumns, this.mRows - (this.mCursorRow + 1));
                        break block0;
                    }
                    case 1: {
                        this.blockClear(0, 0, this.mColumns, this.mCursorRow);
                        this.blockClear(0, this.mCursorRow, this.mCursorCol + 1);
                        break block0;
                    }
                    case 2: {
                        this.blockClear(0, 0, this.mColumns, this.mRows);
                        break block0;
                    }
                }
                this.unknownSequence(b);
                break;
            }
            case 75: {
                switch (this.getArg0(0)) {
                    case 0: {
                        this.blockClear(this.mCursorCol, this.mCursorRow, this.mColumns - this.mCursorCol);
                        break block0;
                    }
                    case 1: {
                        this.blockClear(0, this.mCursorRow, this.mCursorCol + 1);
                        break block0;
                    }
                    case 2: {
                        this.blockClear(0, this.mCursorRow, this.mColumns);
                        break block0;
                    }
                }
                this.unknownSequence(b);
                break;
            }
            case 76: {
                int linesAfterCursor = this.mBottomMargin - this.mCursorRow;
                int linesToInsert = Math.min(this.getArg0(1), linesAfterCursor);
                int linesToMove = linesAfterCursor - linesToInsert;
                this.mScreen.blockCopy(0, this.mCursorRow, this.mColumns, linesToMove, 0, this.mCursorRow + linesToInsert);
                this.blockClear(0, this.mCursorRow, this.mColumns, linesToInsert);
                break;
            }
            case 77: {
                int linesAfterCursor = this.mBottomMargin - this.mCursorRow;
                int linesToDelete = Math.min(this.getArg0(1), linesAfterCursor);
                int linesToMove = linesAfterCursor - linesToDelete;
                this.mScreen.blockCopy(0, this.mCursorRow + linesToDelete, this.mColumns, linesToMove, 0, this.mCursorRow);
                this.blockClear(0, this.mCursorRow + linesToMove, this.mColumns, linesToDelete);
                break;
            }
            case 80: {
                int charsAfterCursor = this.mColumns - this.mCursorCol;
                int charsToDelete = Math.min(this.getArg0(1), charsAfterCursor);
                int charsToMove = charsAfterCursor - charsToDelete;
                this.mScreen.blockCopy(this.mCursorCol + charsToDelete, this.mCursorRow, charsToMove, 1, this.mCursorCol, this.mCursorRow);
                this.blockClear(this.mCursorCol + charsToMove, this.mCursorRow, charsToDelete);
                break;
            }
            case 84: {
                this.unimplementedSequence(b);
                break;
            }
            case 88: {
                this.blockClear(this.mCursorCol, this.mCursorRow, this.getArg0(0));
                break;
            }
            case 90: {
                this.setCursorCol(this.prevTabStop(this.mCursorCol));
                break;
            }
            case 63: {
                this.continueSequence(6);
                break;
            }
            case 99: {
                this.sendDeviceAttributes();
                break;
            }
            case 100: {
                this.setCursorRow(Math.min(Math.max(1, this.getArg0(1)), this.mRows) - 1);
                break;
            }
            case 102: {
                this.setHorizontalVerticalPosition();
                break;
            }
            case 103: {
                switch (this.getArg0(0)) {
                    case 0: {
                        this.mTabStop[this.mCursorCol] = false;
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < this.mColumns; ++i) {
                            this.mTabStop[i] = false;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 104: {
                this.doSetMode(true);
                break;
            }
            case 108: {
                this.doSetMode(false);
                break;
            }
            case 109: {
                this.selectGraphicRendition();
                break;
            }
            case 110: {
                switch (this.getArg0(0)) {
                    case 5: {
                        byte[] dsr = new byte[]{27, 91, 48, 110};
                        this.mSession.write(dsr, 0, dsr.length);
                        break block0;
                    }
                    case 6: {
                        byte[] cpr = String.format(Locale.US, "\u001b[%d;%dR", this.mCursorRow + 1, this.mCursorCol + 1).getBytes();
                        this.mSession.write(cpr, 0, cpr.length);
                        break block0;
                    }
                }
                break;
            }
            case 114: {
                int top = Math.max(0, Math.min(this.getArg0(1) - 1, this.mRows - 2));
                int bottom = Math.max(top + 2, Math.min(this.getArg1(this.mRows), this.mRows));
                this.mTopMargin = top;
                this.mBottomMargin = bottom;
                this.setCursorRowCol(this.mTopMargin, 0);
                break;
            }
            default: {
                this.parseArg(b);
            }
        }
    }

    private void selectGraphicRendition() {
        for (int i = 0; i <= this.mArgIndex; ++i) {
            int color;
            int code = this.mArgs[i];
            if (code < 0) {
                if (this.mArgIndex > 0) continue;
                code = 0;
            }
            if (code == 0) {
                this.mForeColor = this.mDefaultForeColor;
                this.mBackColor = this.mDefaultBackColor;
                this.mEffect = 0;
                continue;
            }
            if (code == 1) {
                this.mEffect |= 1;
                continue;
            }
            if (code == 3) {
                this.mEffect |= 2;
                continue;
            }
            if (code == 4) {
                this.mEffect |= 4;
                continue;
            }
            if (code == 5) {
                this.mEffect |= 8;
                continue;
            }
            if (code == 7) {
                this.mEffect |= 0x10;
                continue;
            }
            if (code == 8) {
                this.mEffect |= 0x20;
                continue;
            }
            if (code == 10) {
                this.setAltCharSet(false);
                continue;
            }
            if (code == 11) {
                this.setAltCharSet(true);
                continue;
            }
            if (code == 22) {
                this.mEffect &= 0xFFFFFFFE;
                continue;
            }
            if (code == 23) {
                this.mEffect &= 0xFFFFFFFD;
                continue;
            }
            if (code == 24) {
                this.mEffect &= 0xFFFFFFFB;
                continue;
            }
            if (code == 25) {
                this.mEffect &= 0xFFFFFFF7;
                continue;
            }
            if (code == 27) {
                this.mEffect &= 0xFFFFFFEF;
                continue;
            }
            if (code == 28) {
                this.mEffect &= 0xFFFFFFDF;
                continue;
            }
            if (code >= 30 && code <= 37) {
                this.mForeColor = code - 30;
                continue;
            }
            if (code == 38 && i + 2 <= this.mArgIndex && this.mArgs[i + 1] == 5) {
                color = this.mArgs[i + 2];
                if (this.checkColor(color)) {
                    this.mForeColor = color;
                }
                i += 2;
                continue;
            }
            if (code == 39) {
                this.mForeColor = this.mDefaultForeColor;
                continue;
            }
            if (code >= 40 && code <= 47) {
                this.mBackColor = code - 40;
                continue;
            }
            if (code == 48 && i + 2 <= this.mArgIndex && this.mArgs[i + 1] == 5) {
                this.mBackColor = this.mArgs[i + 2];
                color = this.mArgs[i + 2];
                if (this.checkColor(color)) {
                    this.mBackColor = color;
                }
                i += 2;
                continue;
            }
            if (code == 49) {
                this.mBackColor = this.mDefaultBackColor;
                continue;
            }
            if (code >= 90 && code <= 97) {
                this.mForeColor = code - 90 + 8;
                continue;
            }
            if (code < 100 || code > 107) continue;
            this.mBackColor = code - 100 + 8;
        }
    }

    private boolean checkColor(int color) {
        boolean result = this.isValidColor(color);
        if (!result) {
            // empty if block
        }
        return result;
    }

    private boolean isValidColor(int color) {
        return color >= 0 && color < 260;
    }

    private void doEscRightSquareBracket(byte b) {
        switch (b) {
            case 7: {
                this.doOSC();
                break;
            }
            case 27: {
                this.continueSequence(9);
                break;
            }
            default: {
                this.collectOSCArgs(b);
            }
        }
    }

    private void doEscRightSquareBracketEsc(byte b) {
        switch (b) {
            case 92: {
                this.doOSC();
                break;
            }
            default: {
                this.collectOSCArgs((byte)27);
                this.collectOSCArgs(b);
                this.continueSequence(8);
            }
        }
    }

    private void doOSC() {
        this.startTokenizingOSC();
        int ps = this.nextOSCInt(59);
        switch (ps) {
            case 0: 
            case 1: 
            case 2: {
                this.changeTitle(ps, this.nextOSCString(-1));
                break;
            }
            default: {
                this.unknownParameter(ps);
            }
        }
        this.finishSequence();
    }

    private void changeTitle(int parameter, String title) {
        if (parameter == 0 || parameter == 2) {
            this.mSession.setTitle(title);
        }
    }

    private void blockClear(int sx, int sy, int w) {
        this.blockClear(sx, sy, w, 1);
    }

    private void blockClear(int sx, int sy, int w, int h) {
        this.mScreen.blockSet(sx, sy, w, h, 32, this.getStyle());
    }

    private int getForeColor() {
        return this.mForeColor;
    }

    private int getBackColor() {
        return this.mBackColor;
    }

    private int getEffect() {
        return this.mEffect;
    }

    private int getStyle() {
        return TextStyle.encode(this.getForeColor(), this.getBackColor(), this.getEffect());
    }

    private void doSetMode(boolean newValue) {
        int modeBit = this.getArg0(0);
        switch (modeBit) {
            case 4: {
                this.mInsertMode = newValue;
                break;
            }
            default: {
                this.unknownParameter(modeBit);
            }
        }
    }

    private void setHorizontalVerticalPosition() {
        this.setCursorPosition(this.getArg1(1) - 1, this.getArg0(1) - 1);
    }

    private void setCursorPosition(int x, int y) {
        int effectiveTopMargin = 0;
        int effectiveBottomMargin = this.mRows;
        if ((this.mDecFlags & 0x40) != 0) {
            effectiveTopMargin = this.mTopMargin;
            effectiveBottomMargin = this.mBottomMargin;
        }
        int newRow = Math.max(effectiveTopMargin, Math.min(effectiveTopMargin + y, effectiveBottomMargin - 1));
        int newCol = Math.max(0, Math.min(x, this.mColumns - 1));
        this.setCursorRowCol(newRow, newCol);
    }

    private void sendDeviceAttributes() {
        byte[] attributes = new byte[]{27, 91, 63, 49, 59, 50, 99};
        this.mSession.write(attributes, 0, attributes.length);
    }

    private void scroll() {
        ++this.mScrollCounter;
        this.mScreen.scroll(this.mTopMargin, this.mBottomMargin, this.getStyle());
    }

    private void parseArg(byte b) {
        if (b >= 48 && b <= 57) {
            if (this.mArgIndex < this.mArgs.length) {
                int oldValue = this.mArgs[this.mArgIndex];
                int thisDigit = b - 48;
                int value = oldValue >= 0 ? oldValue * 10 + thisDigit : thisDigit;
                this.mArgs[this.mArgIndex] = value;
            }
            this.continueSequence();
        } else if (b == 59) {
            if (this.mArgIndex < this.mArgs.length) {
                ++this.mArgIndex;
            }
            this.continueSequence();
        } else {
            this.unknownSequence(b);
        }
    }

    private int getArg0(int defaultValue) {
        return this.getArg(0, defaultValue, true);
    }

    private int getArg1(int defaultValue) {
        return this.getArg(1, defaultValue, true);
    }

    private int getArg(int index, int defaultValue, boolean treatZeroAsDefault) {
        int result = this.mArgs[index];
        if (result < 0 || result == 0 && treatZeroAsDefault) {
            result = defaultValue;
        }
        return result;
    }

    private void startCollectingOSCArgs() {
        this.mOSCArgLength = 0;
    }

    private void collectOSCArgs(byte b) {
        if (this.mOSCArgLength < 512) {
            this.mOSCArg[this.mOSCArgLength++] = b;
            this.continueSequence();
        } else {
            this.unknownSequence(b);
        }
    }

    private void startTokenizingOSC() {
        this.mOSCArgTokenizerIndex = 0;
    }

    private String nextOSCString(int delimiter) {
        byte b;
        int start;
        int end = start = this.mOSCArgTokenizerIndex;
        while (this.mOSCArgTokenizerIndex < this.mOSCArgLength && (b = this.mOSCArg[this.mOSCArgTokenizerIndex++]) != delimiter) {
            ++end;
        }
        if (start == end) {
            return "";
        }
        try {
            return new String(this.mOSCArg, start, end - start, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.mOSCArg, start, end - start);
        }
    }

    private int nextOSCInt(int delimiter) {
        byte b;
        int value = -1;
        while (this.mOSCArgTokenizerIndex < this.mOSCArgLength && (b = this.mOSCArg[this.mOSCArgTokenizerIndex++]) != delimiter) {
            if (b >= 48 && b <= 57) {
                if (value < 0) {
                    value = 0;
                }
                value = value * 10 + b - 48;
                continue;
            }
            this.unknownSequence(b);
        }
        return value;
    }

    private void unimplementedSequence(byte b) {
        this.finishSequence();
    }

    private void unknownSequence(byte b) {
        this.finishSequence();
    }

    private void unknownParameter(int parameter) {
    }

    private void logError(String errorType, byte b) {
    }

    private void logError(String error) {
        this.finishSequence();
    }

    private void finishSequence() {
        this.mEscapeState = 0;
    }

    private boolean autoWrapEnabled() {
        return (this.mDecFlags & 0x80) != 0;
    }

    private void emit(int c, int style) {
        int destCol;
        boolean autoWrap = this.autoWrapEnabled();
        int width = UnicodeTranscript.charWidth(c);
        if (autoWrap && this.mCursorCol == this.mColumns - 1 && (this.mAboutToAutoWrap || width == 2)) {
            this.mScreen.setLineWrap(this.mCursorRow);
            this.mCursorCol = 0;
            this.mJustWrapped = true;
            if (this.mCursorRow + 1 < this.mBottomMargin) {
                ++this.mCursorRow;
            } else {
                this.scroll();
            }
        }
        if (this.mInsertMode & width != 0 && (destCol = this.mCursorCol + width) < this.mColumns) {
            this.mScreen.blockCopy(this.mCursorCol, this.mCursorRow, this.mColumns - destCol, 1, destCol, this.mCursorRow);
        }
        if (width == 0) {
            if (this.mJustWrapped) {
                this.mScreen.set(this.mColumns - this.mLastEmittedCharWidth, this.mCursorRow - 1, c, style);
            } else {
                this.mScreen.set(this.mCursorCol - this.mLastEmittedCharWidth, this.mCursorRow, c, style);
            }
        } else {
            this.mScreen.set(this.mCursorCol, this.mCursorRow, c, style);
            this.mJustWrapped = false;
        }
        if (autoWrap) {
            boolean bl = this.mAboutToAutoWrap = this.mCursorCol == this.mColumns - 1;
            if (this.mAboutToAutoWrap) {
                this.mScreen.setLineWrap(this.mCursorRow);
            }
        }
        this.mCursorCol = Math.min(this.mCursorCol + width, this.mColumns - 1);
        if (width > 0) {
            this.mLastEmittedCharWidth = width;
        }
    }

    private void emit(int c) {
        this.emit(c, this.getStyle());
    }

    private void emit(byte b) {
        if (this.mUseAlternateCharSet && b < 128) {
            this.emit(mSpecialGraphicsCharMap[b]);
        } else {
            this.emit((int)b);
        }
    }

    private void emit(char[] c) {
        if (Character.isHighSurrogate(c[0])) {
            this.emit(Character.toCodePoint(c[0], c[1]));
        } else {
            this.emit(c[0]);
        }
    }

    private void emit(char[] c, int offset, int length, int style) {
        for (int i = offset; i < length && c[i] != '\u0000'; ++i) {
            if (Character.isHighSurrogate(c[i])) {
                this.emit(Character.toCodePoint(c[i], c[i + 1]), style);
                ++i;
                continue;
            }
            this.emit(c[i], style);
        }
    }

    private void setCursorRow(int row) {
        this.mCursorRow = row;
        this.mAboutToAutoWrap = false;
    }

    private void setCursorCol(int col) {
        this.mCursorCol = col;
        this.mAboutToAutoWrap = false;
    }

    private void setCursorRowCol(int row, int col) {
        this.mCursorRow = Math.min(row, this.mRows - 1);
        this.mCursorCol = Math.min(col, this.mColumns - 1);
        this.mAboutToAutoWrap = false;
    }

    public int getScrollCounter() {
        return this.mScrollCounter;
    }

    public void clearScrollCounter() {
        this.mScrollCounter = 0;
    }

    public void reset() {
        this.mCursorRow = 0;
        this.mCursorCol = 0;
        this.mArgIndex = 0;
        this.mContinueSequence = false;
        this.mEscapeState = 0;
        this.mSavedCursorRow = 0;
        this.mSavedCursorCol = 0;
        this.mSavedEffect = 0;
        this.mSavedDecFlags_DECSC_DECRC = 0;
        this.mDecFlags = 0;
        this.mDecFlags |= 0x80;
        this.mDecFlags |= 0x2000000;
        this.mSavedDecFlags = 0;
        this.mInsertMode = false;
        this.mTopMargin = 0;
        this.mBottomMargin = this.mRows;
        this.mAboutToAutoWrap = false;
        this.mForeColor = this.mDefaultForeColor;
        this.mBackColor = this.mDefaultBackColor;
        this.mbKeypadApplicationMode = false;
        this.mAlternateCharSet = false;
        this.mCharSet[0] = 1;
        this.mCharSet[1] = 2;
        this.computeEffectiveCharSet();
        this.setDefaultTabStops();
        this.blockClear(0, 0, this.mColumns, this.mRows);
        this.setUTF8Mode(this.mDefaultUTF8Mode);
        this.mUTF8EscapeUsed = false;
        this.mUTF8ToFollow = 0;
        this.mUTF8ByteBuffer.clear();
        this.mInputCharBuffer.clear();
    }

    public void setDefaultUTF8Mode(boolean defaultToUTF8Mode) {
        this.mDefaultUTF8Mode = defaultToUTF8Mode;
        if (!this.mUTF8EscapeUsed) {
            this.setUTF8Mode(defaultToUTF8Mode);
        }
    }

    public void setUTF8Mode(boolean utf8Mode) {
        if (utf8Mode && !this.mUTF8Mode) {
            this.mUTF8ToFollow = 0;
            this.mUTF8ByteBuffer.clear();
            this.mInputCharBuffer.clear();
        }
        this.mUTF8Mode = utf8Mode;
        if (this.mUTF8ModeNotify != null) {
            this.mUTF8ModeNotify.onUpdate();
        }
    }

    public boolean getUTF8Mode() {
        return this.mUTF8Mode;
    }

    public void setUTF8ModeUpdateCallback(UpdateCallback utf8ModeNotify) {
        this.mUTF8ModeNotify = utf8ModeNotify;
    }

    public void setColorScheme(ColorScheme scheme) {
        this.mDefaultForeColor = 256;
        this.mDefaultBackColor = 257;
        this.mMainBuffer.setColorScheme(scheme);
        if (this.mAltBuffer != null) {
            this.mAltBuffer.setColorScheme(scheme);
        }
    }

    public String getSelectedText(int x1, int y1, int x2, int y2) {
        return this.mScreen.getSelectedText(x1, y1, x2, y2);
    }

    public void finish() {
        if (this.mAltBuffer != null) {
            this.mAltBuffer.finish();
            this.mAltBuffer = null;
        }
    }

    static {
        for (int i = 0; i < 128; i = (int)((char)(i + 1))) {
            TerminalEmulator.mSpecialGraphicsCharMap[i] = i;
        }
        TerminalEmulator.mSpecialGraphicsCharMap[95] = 32;
        TerminalEmulator.mSpecialGraphicsCharMap[98] = 9225;
        TerminalEmulator.mSpecialGraphicsCharMap[99] = 9228;
        TerminalEmulator.mSpecialGraphicsCharMap[100] = 9229;
        TerminalEmulator.mSpecialGraphicsCharMap[101] = 9226;
        TerminalEmulator.mSpecialGraphicsCharMap[104] = 9252;
        TerminalEmulator.mSpecialGraphicsCharMap[105] = 9227;
        TerminalEmulator.mSpecialGraphicsCharMap[125] = 163;
        TerminalEmulator.mSpecialGraphicsCharMap[102] = 176;
        TerminalEmulator.mSpecialGraphicsCharMap[96] = 11045;
        TerminalEmulator.mSpecialGraphicsCharMap[126] = 8226;
        TerminalEmulator.mSpecialGraphicsCharMap[121] = 8804;
        TerminalEmulator.mSpecialGraphicsCharMap[124] = 8800;
        TerminalEmulator.mSpecialGraphicsCharMap[122] = 8805;
        TerminalEmulator.mSpecialGraphicsCharMap[103] = 177;
        TerminalEmulator.mSpecialGraphicsCharMap[123] = 960;
        TerminalEmulator.mSpecialGraphicsCharMap[46] = 9660;
        TerminalEmulator.mSpecialGraphicsCharMap[44] = 9664;
        TerminalEmulator.mSpecialGraphicsCharMap[43] = 9654;
        TerminalEmulator.mSpecialGraphicsCharMap[45] = 9650;
        TerminalEmulator.mSpecialGraphicsCharMap[104] = 35;
        TerminalEmulator.mSpecialGraphicsCharMap[97] = 9618;
        TerminalEmulator.mSpecialGraphicsCharMap[48] = 9608;
        TerminalEmulator.mSpecialGraphicsCharMap[113] = 9472;
        TerminalEmulator.mSpecialGraphicsCharMap[120] = 9474;
        TerminalEmulator.mSpecialGraphicsCharMap[109] = 9492;
        TerminalEmulator.mSpecialGraphicsCharMap[106] = 9496;
        TerminalEmulator.mSpecialGraphicsCharMap[108] = 9484;
        TerminalEmulator.mSpecialGraphicsCharMap[107] = 9488;
        TerminalEmulator.mSpecialGraphicsCharMap[119] = 9516;
        TerminalEmulator.mSpecialGraphicsCharMap[117] = 9508;
        TerminalEmulator.mSpecialGraphicsCharMap[116] = 9500;
        TerminalEmulator.mSpecialGraphicsCharMap[118] = 9524;
        TerminalEmulator.mSpecialGraphicsCharMap[110] = 9532;
        TerminalEmulator.mSpecialGraphicsCharMap[111] = 9146;
        TerminalEmulator.mSpecialGraphicsCharMap[112] = 9147;
        TerminalEmulator.mSpecialGraphicsCharMap[114] = 9148;
        TerminalEmulator.mSpecialGraphicsCharMap[115] = 9149;
    }
}

