/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import jackpal.androidterm.emulatorview.BaseTextRenderer;
import jackpal.androidterm.emulatorview.ByteQueue;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.TermKeyListener;
import jackpal.androidterm.emulatorview.TerminalEmulator;
import jackpal.androidterm.emulatorview.TranscriptScreen;
import jackpal.androidterm.emulatorview.UpdateCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class TermSession {
    private TermKeyListener mKeyListener;
    private ColorScheme mColorScheme = BaseTextRenderer.defaultColorScheme;
    private UpdateCallback mNotify;
    private OutputStream mTermOut;
    private InputStream mTermIn;
    private String mTitle;
    private TranscriptScreen mTranscriptScreen;
    private TerminalEmulator mEmulator;
    private boolean mDefaultUTF8Mode;
    private Thread mReaderThread;
    private ByteQueue mByteQueue;
    private byte[] mReceiveBuffer;
    private Thread mWriterThread;
    private ByteQueue mWriteQueue;
    private Handler mWriterHandler;
    private CharBuffer mWriteCharBuffer;
    private ByteBuffer mWriteByteBuffer;
    private CharsetEncoder mUTF8Encoder;
    private static final int TRANSCRIPT_ROWS = 10000;
    private static final int NEW_INPUT = 1;
    private static final int NEW_OUTPUT = 2;
    private static final int FINISH = 3;
    private static final int EOF = 4;
    private FinishCallback mFinishCallback;
    private boolean mIsRunning = false;
    private Handler mMsgHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (!TermSession.this.mIsRunning) {
                return;
            }
            if (msg.what == 1) {
                TermSession.this.readFromProcess();
            } else if (msg.what == 4) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        TermSession.this.onProcessExit();
                    }
                });
            }
        }
    };
    private UpdateCallback mTitleChangedListener;

    public void setKeyListener(TermKeyListener l) {
        this.mKeyListener = l;
    }

    public TermSession() {
        this(false);
    }

    public TermSession(final boolean exitOnEOF) {
        this.mWriteCharBuffer = CharBuffer.allocate(2);
        this.mWriteByteBuffer = ByteBuffer.allocate(4);
        this.mUTF8Encoder = Charset.forName("UTF-8").newEncoder();
        this.mUTF8Encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.mUTF8Encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.mReceiveBuffer = new byte[4096];
        this.mByteQueue = new ByteQueue(4096);
        this.mReaderThread = new Thread(){
            private byte[] mBuffer = new byte[4096];

            @Override
            public void run() {
                try {
                    int read;
                    while ((read = TermSession.this.mTermIn.read(this.mBuffer)) != -1) {
                        int offset = 0;
                        while (read > 0) {
                            int written = TermSession.this.mByteQueue.write(this.mBuffer, offset, read);
                            offset += written;
                            read -= written;
                            TermSession.this.mMsgHandler.sendMessage(TermSession.this.mMsgHandler.obtainMessage(1));
                        }
                    }
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (exitOnEOF) {
                    TermSession.this.mMsgHandler.sendMessage(TermSession.this.mMsgHandler.obtainMessage(4));
                }
            }
        };
        this.mReaderThread.setName("TermSession input reader");
        this.mWriteQueue = new ByteQueue(4096);
        this.mWriterThread = new Thread(){
            private byte[] mBuffer = new byte[4096];

            @Override
            public void run() {
                Looper.prepare();
                TermSession.this.mWriterHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        if (msg.what == 2) {
                            this.writeToOutput();
                        } else if (msg.what == 3) {
                            Looper.myLooper().quit();
                        }
                    }
                };
                this.writeToOutput();
                Looper.loop();
            }

            private void writeToOutput() {
                ByteQueue writeQueue = TermSession.this.mWriteQueue;
                byte[] buffer = this.mBuffer;
                OutputStream termOut = TermSession.this.mTermOut;
                int bytesAvailable = writeQueue.getBytesAvailable();
                int bytesToWrite = Math.min(bytesAvailable, buffer.length);
                if (bytesToWrite == 0) {
                    return;
                }
                try {
                    writeQueue.read(buffer, 0, bytesToWrite);
                    termOut.write(buffer, 0, bytesToWrite);
                    termOut.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        this.mWriterThread.setName("TermSession output writer");
    }

    protected void onProcessExit() {
        this.finish();
    }

    public void initializeEmulator(int columns, int rows) {
        this.mTranscriptScreen = new TranscriptScreen(columns, 10000, rows, this.mColorScheme);
        this.mEmulator = new TerminalEmulator(this, this.mTranscriptScreen, columns, rows, this.mColorScheme);
        this.mEmulator.setDefaultUTF8Mode(this.mDefaultUTF8Mode);
        this.mEmulator.setKeyListener(this.mKeyListener);
        this.mIsRunning = true;
        this.mReaderThread.start();
        this.mWriterThread.start();
    }

    public void write(byte[] data, int offset, int count) {
        try {
            while (count > 0) {
                int written = this.mWriteQueue.write(data, offset, count);
                offset += written;
                count -= written;
                this.notifyNewOutput();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void write(String data) {
        try {
            byte[] bytes = data.getBytes("UTF-8");
            this.write(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void write(int codePoint) {
        ByteBuffer byteBuf = this.mWriteByteBuffer;
        if (codePoint < 128) {
            byte[] buf = byteBuf.array();
            buf[0] = (byte)codePoint;
            this.write(buf, 0, 1);
            return;
        }
        CharBuffer charBuf = this.mWriteCharBuffer;
        CharsetEncoder encoder = this.mUTF8Encoder;
        charBuf.clear();
        byteBuf.clear();
        Character.toChars(codePoint, charBuf.array(), 0);
        encoder.reset();
        encoder.encode(charBuf, byteBuf, true);
        encoder.flush(byteBuf);
        this.write(byteBuf.array(), 0, byteBuf.position() - 1);
    }

    private void notifyNewOutput() {
        Handler writerHandler = this.mWriterHandler;
        if (writerHandler == null) {
            return;
        }
        writerHandler.sendEmptyMessage(2);
    }

    public OutputStream getTermOut() {
        return this.mTermOut;
    }

    public void setTermOut(OutputStream termOut) {
        this.mTermOut = termOut;
    }

    public InputStream getTermIn() {
        return this.mTermIn;
    }

    public void setTermIn(InputStream termIn) {
        this.mTermIn = termIn;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    TranscriptScreen getTranscriptScreen() {
        return this.mTranscriptScreen;
    }

    TerminalEmulator getEmulator() {
        return this.mEmulator;
    }

    public void setUpdateCallback(UpdateCallback notify) {
        this.mNotify = notify;
    }

    protected void notifyUpdate() {
        if (this.mNotify != null) {
            this.mNotify.onUpdate();
        }
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
        this.notifyTitleChanged();
    }

    public void setTitleChangedListener(UpdateCallback listener) {
        this.mTitleChangedListener = listener;
    }

    protected void notifyTitleChanged() {
        UpdateCallback listener = this.mTitleChangedListener;
        if (listener != null) {
            listener.onUpdate();
        }
    }

    public void updateSize(int columns, int rows) {
        if (this.mEmulator == null) {
            this.initializeEmulator(columns, rows);
        } else {
            this.mEmulator.updateSize(columns, rows);
        }
    }

    public String getTranscriptText() {
        return this.mTranscriptScreen.getTranscriptText();
    }

    private void readFromProcess() {
        int bytesAvailable = this.mByteQueue.getBytesAvailable();
        int bytesToRead = Math.min(bytesAvailable, this.mReceiveBuffer.length);
        int bytesRead = 0;
        try {
            bytesRead = this.mByteQueue.read(this.mReceiveBuffer, 0, bytesToRead);
        }
        catch (InterruptedException e) {
            return;
        }
        this.processInput(this.mReceiveBuffer, 0, bytesRead);
        this.notifyUpdate();
    }

    protected void processInput(byte[] data, int offset, int count) {
        this.mEmulator.append(data, offset, count);
    }

    protected final void appendToEmulator(byte[] data, int offset, int count) {
        this.mEmulator.append(data, offset, count);
    }

    public void setColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            scheme = BaseTextRenderer.defaultColorScheme;
        }
        this.mColorScheme = scheme;
        if (this.mEmulator == null) {
            return;
        }
        this.mEmulator.setColorScheme(scheme);
    }

    public void setDefaultUTF8Mode(boolean utf8ByDefault) {
        this.mDefaultUTF8Mode = utf8ByDefault;
        if (this.mEmulator == null) {
            return;
        }
        this.mEmulator.setDefaultUTF8Mode(utf8ByDefault);
    }

    public boolean getUTF8Mode() {
        if (this.mEmulator == null) {
            return this.mDefaultUTF8Mode;
        }
        return this.mEmulator.getUTF8Mode();
    }

    public void setUTF8ModeUpdateCallback(UpdateCallback utf8ModeNotify) {
        if (this.mEmulator != null) {
            this.mEmulator.setUTF8ModeUpdateCallback(utf8ModeNotify);
        }
    }

    public void reset() {
        this.mEmulator.reset();
        this.notifyUpdate();
    }

    public void setFinishCallback(FinishCallback callback) {
        this.mFinishCallback = callback;
    }

    public void finish() {
        this.mIsRunning = false;
        this.mEmulator.finish();
        if (this.mTranscriptScreen != null) {
            this.mTranscriptScreen.finish();
        }
        if (this.mWriterHandler != null) {
            this.mWriterHandler.sendEmptyMessage(3);
        }
        try {
            this.mTermIn.close();
            this.mTermOut.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.mFinishCallback != null) {
            this.mFinishCallback.onSessionFinish(this);
        }
    }

    public static interface FinishCallback {
        public void onSessionFinish(TermSession var1);
    }
}

