/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.FloatMath;
import jackpal.androidterm.emulatorview.BaseTextRenderer;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.TextStyle;

class PaintRenderer
extends BaseTextRenderer {
    private Paint mTextPaint = new Paint();
    private float mCharWidth;
    private int mCharHeight;
    private int mCharAscent;
    private int mCharDescent;
    private static final char[] EXAMPLE_CHAR = new char[]{'X'};

    public PaintRenderer(int fontSize, ColorScheme scheme) {
        super(scheme);
        this.mTextPaint.setTypeface(Typeface.MONOSPACE);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize((float)fontSize);
        this.mCharHeight = (int)FloatMath.ceil((float)this.mTextPaint.getFontSpacing());
        this.mCharAscent = (int)FloatMath.ceil((float)this.mTextPaint.ascent());
        this.mCharDescent = this.mCharHeight + this.mCharAscent;
        this.mCharWidth = this.mTextPaint.measureText(EXAMPLE_CHAR, 0, 1);
    }

    @Override
    public void drawTextRun(Canvas canvas, float x, float y, int lineOffset, int runWidth, char[] text, int index, int count, boolean selectionStyle, int textStyle, int cursorOffset, int cursorIndex, int cursorIncr, int cursorWidth, int cursorMode) {
        boolean invisible;
        boolean blink;
        int foreColor = TextStyle.decodeForeColor(textStyle);
        int backColor = TextStyle.decodeBackColor(textStyle);
        int effect = TextStyle.decodeEffect(textStyle);
        boolean inverse = this.mReverseVideo ^ (effect & 0x12) != 0;
        if (inverse) {
            int temp = foreColor;
            foreColor = backColor;
            backColor = temp;
        }
        if (selectionStyle) {
            backColor = 259;
        }
        boolean bl = blink = (effect & 8) != 0;
        if (blink && backColor < 8) {
            backColor += 8;
        }
        this.mTextPaint.setColor(this.mPalette[backColor]);
        float left = x + (float)lineOffset * this.mCharWidth;
        canvas.drawRect(left, y + (float)this.mCharAscent - (float)this.mCharDescent, left + (float)runWidth * this.mCharWidth, y, this.mTextPaint);
        boolean cursorVisible = lineOffset <= cursorOffset && cursorOffset < lineOffset + runWidth;
        float cursorX = 0.0f;
        if (cursorVisible) {
            cursorX = x + (float)cursorOffset * this.mCharWidth;
            this.drawCursorImp(canvas, (int)cursorX, y, (float)cursorWidth * this.mCharWidth, this.mCharHeight, cursorMode);
        }
        boolean bl2 = invisible = (effect & 0x20) != 0;
        if (!invisible) {
            boolean underline;
            boolean bold = (effect & 1) != 0;
            boolean bl3 = underline = (effect & 4) != 0;
            if (bold) {
                this.mTextPaint.setFakeBoldText(true);
            }
            if (underline) {
                this.mTextPaint.setUnderlineText(true);
            }
            int textPaintColor = foreColor < 8 && bold ? this.mPalette[foreColor + 8] : this.mPalette[foreColor];
            this.mTextPaint.setColor(textPaintColor);
            float textOriginY = y - (float)this.mCharDescent;
            if (cursorVisible) {
                int countBeforeCursor = cursorIndex - index;
                int countAfterCursor = count - (countBeforeCursor + cursorIncr);
                if (countBeforeCursor > 0) {
                    canvas.drawText(text, index, countBeforeCursor, left, textOriginY, this.mTextPaint);
                }
                this.mTextPaint.setColor(this.mPalette[258]);
                canvas.drawText(text, cursorIndex, cursorIncr, cursorX, textOriginY, this.mTextPaint);
                if (countAfterCursor > 0) {
                    this.mTextPaint.setColor(textPaintColor);
                    canvas.drawText(text, cursorIndex + cursorIncr, countAfterCursor, cursorX + (float)cursorWidth * this.mCharWidth, textOriginY, this.mTextPaint);
                }
            } else {
                canvas.drawText(text, index, count, left, textOriginY, this.mTextPaint);
            }
            if (bold) {
                this.mTextPaint.setFakeBoldText(false);
            }
            if (underline) {
                this.mTextPaint.setUnderlineText(false);
            }
        }
    }

    @Override
    public int getCharacterHeight() {
        return this.mCharHeight;
    }

    @Override
    public float getCharacterWidth() {
        return this.mCharWidth;
    }

    @Override
    public int getTopMargin() {
        return this.mCharDescent;
    }
}

