/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

public class ColorScheme {
    private int foreColor;
    private int backColor;
    private int cursorForeColor;
    private int cursorBackColor;
    private static final int sDefaultCursorBackColor = -8355712;

    private void setDefaultCursorColors() {
        int backDistance;
        this.cursorBackColor = -8355712;
        int foreDistance = ColorScheme.distance(this.foreColor, this.cursorBackColor);
        this.cursorForeColor = foreDistance * 2 >= (backDistance = ColorScheme.distance(this.backColor, this.cursorBackColor)) ? this.foreColor : this.backColor;
    }

    private static int distance(int a, int b) {
        return ColorScheme.channelDistance(a, b, 0) * 3 + ColorScheme.channelDistance(a, b, 1) * 5 + ColorScheme.channelDistance(a, b, 2);
    }

    private static int channelDistance(int a, int b, int channel) {
        return Math.abs(ColorScheme.getChannel(a, channel) - ColorScheme.getChannel(b, channel));
    }

    private static int getChannel(int color, int channel) {
        return 0xFF & color >> (2 - channel) * 8;
    }

    public ColorScheme(int foreColor, int backColor) {
        this.foreColor = foreColor;
        this.backColor = backColor;
        this.setDefaultCursorColors();
    }

    public ColorScheme(int foreColor, int backColor, int cursorForeColor, int cursorBackColor) {
        this.foreColor = foreColor;
        this.backColor = backColor;
        this.cursorForeColor = cursorForeColor;
        this.cursorBackColor = cursorBackColor;
    }

    public ColorScheme(int[] scheme) {
        int schemeLength = scheme.length;
        if (schemeLength != 2 && schemeLength != 4) {
            throw new IllegalArgumentException();
        }
        this.foreColor = scheme[0];
        this.backColor = scheme[1];
        if (schemeLength == 2) {
            this.setDefaultCursorColors();
        } else {
            this.cursorForeColor = scheme[2];
            this.cursorBackColor = scheme[3];
        }
    }

    public int getForeColor() {
        return this.foreColor;
    }

    public int getBackColor() {
        return this.backColor;
    }

    public int getCursorForeColor() {
        return this.cursorForeColor;
    }

    public int getCursorBackColor() {
        return this.cursorBackColor;
    }
}

