/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.os.Build;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import jackpal.androidterm.FdHelperHoneycomb;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TermExec {
    public static final String SERVICE_ACTION_V1 = "jackpal.androidterm.action.START_TERM.v1";
    private static Field descriptorField;
    private final List<String> command;
    private final Map<String, String> environment;

    public TermExec(String ... command) {
        this(new ArrayList<String>(Arrays.asList(command)));
    }

    public TermExec(@NonNull List<String> command) {
        this.command = command;
        this.environment = new Hashtable<String, String>(System.getenv());
    }

    @NonNull
    public List<String> command() {
        return this.command;
    }

    @NonNull
    public Map<String, String> environment() {
        return this.environment;
    }

    @NonNull
    public TermExec command(String ... command) {
        return this.command(new ArrayList<String>(Arrays.asList(command)));
    }

    @NonNull
    public TermExec command(List<String> command) {
        command.clear();
        command.addAll(command);
        return this;
    }

    public int start(@NonNull ParcelFileDescriptor ptmxFd) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IllegalStateException("This method must not be called from the main thread!");
        }
        if (this.command.size() == 0) {
            throw new IllegalStateException("Empty command!");
        }
        String cmd = this.command.remove(0);
        String[] cmdArray = this.command.toArray(new String[this.command.size()]);
        String[] envArray = new String[this.environment.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : this.environment.entrySet()) {
            envArray[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return TermExec.createSubprocess(ptmxFd, cmd, cmdArray, envArray);
    }

    public static native int waitFor(int var0);

    public static native void sendSignal(int var0, int var1);

    static int createSubprocess(ParcelFileDescriptor masterFd, String cmd, String[] args, String[] envVars) throws IOException {
        int integerFd;
        if (Build.VERSION.SDK_INT >= 12) {
            integerFd = FdHelperHoneycomb.getFd(masterFd);
        } else {
            try {
                if (descriptorField == null) {
                    descriptorField = FileDescriptor.class.getDeclaredField("descriptor");
                    descriptorField.setAccessible(true);
                }
                integerFd = descriptorField.getInt(masterFd.getFileDescriptor());
            }
            catch (Exception e) {
                throw new IOException("Unable to obtain file descriptor on this OS version: " + e.getMessage());
            }
        }
        return TermExec.createSubprocessInternal(cmd, args, envVars, integerFd);
    }

    private static native int createSubprocessInternal(String var0, String[] var1, String[] var2, int var3);

    static {
        System.loadLibrary("jackpal-termexec2");
    }
}

