/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.compat.AndroidCompat;
import jackpal.androidterm.emulatorview.compat.KeyCharacterMapCompat;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class TermKeyListener {
    private static final String TAG = "TermKeyListener";
    private static final boolean LOG_MISC = false;
    private static final boolean LOG_KEYS = false;
    private static final boolean LOG_COMBINING_ACCENT = false;
    private static final boolean SUPPORT_8_BIT_META = false;
    private static final int KEYMOD_ALT = Integer.MIN_VALUE;
    private static final int KEYMOD_CTRL = 0x40000000;
    private static final int KEYMOD_SHIFT = 0x20000000;
    private static final int KEYMOD_SCAN = 0x10000000;
    private static Map<Integer, String> mKeyMap;
    private String[] mKeyCodes = new String[256];
    private String[] mAppKeyCodes = new String[256];
    private ModifierKey mAltKey = new ModifierKey();
    private ModifierKey mCapKey = new ModifierKey();
    private ModifierKey mControlKey = new ModifierKey();
    private ModifierKey mFnKey = new ModifierKey();
    private int mCursorMode;
    private boolean mHardwareControlKey;
    private TermSession mTermSession;
    private int mBackKeyCode;
    private boolean mAltSendsEsc;
    private int mCombiningAccent;
    public static final int KEYCODE_OFFSET = 0xA00000;

    private void initKeyCodes() {
        mKeyMap = new HashMap<Integer, String>();
        mKeyMap.put(536870933, "\u001b[1;2D");
        mKeyMap.put(-2147483627, "\u001b[1;3D");
        mKeyMap.put(-1610612715, "\u001b[1;4D");
        mKeyMap.put(1073741845, "\u001b[1;5D");
        mKeyMap.put(1610612757, "\u001b[1;6D");
        mKeyMap.put(-1073741803, "\u001b[1;7D");
        mKeyMap.put(-536870891, "\u001b[1;8D");
        mKeyMap.put(536870934, "\u001b[1;2C");
        mKeyMap.put(-2147483626, "\u001b[1;3C");
        mKeyMap.put(-1610612714, "\u001b[1;4C");
        mKeyMap.put(1073741846, "\u001b[1;5C");
        mKeyMap.put(0x60000016, "\u001b[1;6C");
        mKeyMap.put(-1073741802, "\u001b[1;7C");
        mKeyMap.put(-536870890, "\u001b[1;8C");
        mKeyMap.put(536870931, "\u001b[1;2A");
        mKeyMap.put(-2147483629, "\u001b[1;3A");
        mKeyMap.put(-1610612717, "\u001b[1;4A");
        mKeyMap.put(1073741843, "\u001b[1;5A");
        mKeyMap.put(1610612755, "\u001b[1;6A");
        mKeyMap.put(-1073741805, "\u001b[1;7A");
        mKeyMap.put(-536870893, "\u001b[1;8A");
        mKeyMap.put(536870932, "\u001b[1;2B");
        mKeyMap.put(-2147483628, "\u001b[1;3B");
        mKeyMap.put(-1610612716, "\u001b[1;4B");
        mKeyMap.put(0x40000014, "\u001b[1;5B");
        mKeyMap.put(1610612756, "\u001b[1;6B");
        mKeyMap.put(-1073741804, "\u001b[1;7B");
        mKeyMap.put(-536870892, "\u001b[1;8B");
        mKeyMap.put(0x20000070, "\u001b[3;2~");
        mKeyMap.put(-2147483536, "\u001b[3;3~");
        mKeyMap.put(0x40000070, "\u001b[3;5~");
        mKeyMap.put(536871036, "\u001b[2;2~");
        mKeyMap.put(-2147483524, "\u001b[2;3~");
        mKeyMap.put(1073741948, "\u001b[2;5~");
        mKeyMap.put(1073741946, "\u001b[1;5H");
        mKeyMap.put(1073741947, "\u001b[1;5F");
        mKeyMap.put(-2147483582, "\u001b\r");
        mKeyMap.put(0x40000042, "\n");
        mKeyMap.put(1073741886, "\u0000");
        mKeyMap.put(536871043, "\u001b[1;2P");
        mKeyMap.put(536871044, "\u001b[1;2Q");
        mKeyMap.put(536871045, "\u001b[1;2R");
        mKeyMap.put(536871046, "\u001b[1;2S");
        mKeyMap.put(536871047, "\u001b[15;2~");
        mKeyMap.put(0x20000088, "\u001b[17;2~");
        mKeyMap.put(536871049, "\u001b[18;2~");
        mKeyMap.put(536871050, "\u001b[19;2~");
        mKeyMap.put(536871051, "\u001b[20;2~");
        mKeyMap.put(536871052, "\u001b[21;2~");
        this.mKeyCodes[23] = "\r";
        this.mKeyCodes[19] = "\u001b[A";
        this.mKeyCodes[20] = "\u001b[B";
        this.mKeyCodes[22] = "\u001b[C";
        this.mKeyCodes[21] = "\u001b[D";
        this.setFnKeys("vt100");
        this.mKeyCodes[120] = "\u001b[32~";
        this.mKeyCodes[121] = "\u001b[34~";
        this.mKeyCodes[61] = "\t";
        this.mKeyCodes[66] = "\r";
        this.mKeyCodes[111] = "\u001b";
        this.mKeyCodes[124] = "\u001b[2~";
        this.mKeyCodes[112] = "\u001b[3~";
        this.mKeyCodes[92] = "\u001b[5~";
        this.mKeyCodes[93] = "\u001b[6~";
        this.mKeyCodes[67] = "\u007f";
        this.mKeyCodes[143] = "\u001bOP";
        this.mKeyCodes[154] = "/";
        this.mKeyCodes[155] = "*";
        this.mKeyCodes[156] = "-";
        this.mKeyCodes[157] = "+";
        this.mKeyCodes[160] = "\r";
        this.mKeyCodes[161] = "=";
        this.mKeyCodes[159] = ",";
        this.mKeyCodes[158] = this.mKeyCodes[112];
        this.mKeyCodes[144] = this.mKeyCodes[124];
        this.mKeyCodes[145] = this.mKeyCodes[123];
        this.mKeyCodes[146] = this.mKeyCodes[20];
        this.mKeyCodes[147] = this.mKeyCodes[93];
        this.mKeyCodes[148] = this.mKeyCodes[21];
        this.mKeyCodes[149] = "5";
        this.mKeyCodes[150] = this.mKeyCodes[22];
        this.mKeyCodes[151] = this.mKeyCodes[122];
        this.mKeyCodes[152] = this.mKeyCodes[19];
        this.mKeyCodes[153] = this.mKeyCodes[92];
        this.mAppKeyCodes[154] = "\u001bOo";
        this.mAppKeyCodes[155] = "\u001bOj";
        this.mAppKeyCodes[156] = "\u001bOm";
        this.mAppKeyCodes[157] = "\u001bOk";
        this.mAppKeyCodes[160] = "\u001bOM";
        this.mAppKeyCodes[161] = "\u001bOX";
        this.mAppKeyCodes[158] = "\u001bOn";
        this.mAppKeyCodes[159] = "\u001bOl";
        this.mAppKeyCodes[144] = "\u001bOp";
        this.mAppKeyCodes[145] = "\u001bOq";
        this.mAppKeyCodes[146] = "\u001bOr";
        this.mAppKeyCodes[147] = "\u001bOs";
        this.mAppKeyCodes[148] = "\u001bOt";
        this.mAppKeyCodes[149] = "\u001bOu";
        this.mAppKeyCodes[150] = "\u001bOv";
        this.mAppKeyCodes[151] = "\u001bOw";
        this.mAppKeyCodes[152] = "\u001bOx";
        this.mAppKeyCodes[153] = "\u001bOy";
    }

    public void setCursorKeysApplicationMode(boolean val) {
        if (val) {
            this.mKeyCodes[19] = "\u001bOA";
            this.mKeyCodes[152] = "\u001bOA";
            this.mKeyCodes[20] = "\u001bOB";
            this.mKeyCodes[146] = "\u001bOB";
            this.mKeyCodes[22] = "\u001bOC";
            this.mKeyCodes[150] = "\u001bOC";
            this.mKeyCodes[21] = "\u001bOD";
            this.mKeyCodes[148] = "\u001bOD";
        } else {
            this.mKeyCodes[19] = "\u001b[A";
            this.mKeyCodes[152] = "\u001b[A";
            this.mKeyCodes[20] = "\u001b[B";
            this.mKeyCodes[146] = "\u001b[B";
            this.mKeyCodes[22] = "\u001b[C";
            this.mKeyCodes[150] = "\u001b[C";
            this.mKeyCodes[21] = "\u001b[D";
            this.mKeyCodes[148] = "\u001b[D";
        }
    }

    public TermKeyListener(TermSession termSession) {
        this.mTermSession = termSession;
        this.initKeyCodes();
        this.updateCursorMode();
    }

    public void setBackKeyCharacter(int code) {
        this.mBackKeyCode = code;
    }

    public void setAltSendsEsc(boolean flag) {
        this.mAltSendsEsc = flag;
    }

    public void handleHardwareControlKey(boolean down) {
        this.mHardwareControlKey = down;
    }

    public void onPause() {
        this.mHardwareControlKey = false;
    }

    public void onResume() {
    }

    public void handleControlKey(boolean down) {
        if (down) {
            this.mControlKey.onPress();
        } else {
            this.mControlKey.onRelease();
        }
        this.updateCursorMode();
    }

    public void handleFnKey(boolean down) {
        if (down) {
            this.mFnKey.onPress();
        } else {
            this.mFnKey.onRelease();
        }
        this.updateCursorMode();
    }

    public void setTermType(String termType) {
        this.setFnKeys(termType);
    }

    private void setFnKeys(String termType) {
        if (termType.equals("xterm")) {
            this.mKeyCodes[122] = "\u001bOH";
            this.mKeyCodes[151] = "\u001bOH";
            this.mKeyCodes[123] = "\u001bOF";
            this.mKeyCodes[145] = "\u001bOF";
        } else {
            this.mKeyCodes[122] = "\u001b[1~";
            this.mKeyCodes[151] = "\u001b[1~";
            this.mKeyCodes[123] = "\u001b[4~";
            this.mKeyCodes[145] = "\u001b[4~";
        }
        if (termType.equals("vt100")) {
            this.mKeyCodes[131] = "\u001bOP";
            this.mKeyCodes[132] = "\u001bOQ";
            this.mKeyCodes[133] = "\u001bOR";
            this.mKeyCodes[134] = "\u001bOS";
            this.mKeyCodes[135] = "\u001bOt";
            this.mKeyCodes[136] = "\u001bOu";
            this.mKeyCodes[137] = "\u001bOv";
            this.mKeyCodes[138] = "\u001bOl";
            this.mKeyCodes[139] = "\u001bOw";
            this.mKeyCodes[140] = "\u001bOx";
            this.mKeyCodes[141] = "\u001b[23~";
            this.mKeyCodes[142] = "\u001b[24~";
        } else if (termType.startsWith("linux")) {
            this.mKeyCodes[131] = "\u001b[[A";
            this.mKeyCodes[132] = "\u001b[[B";
            this.mKeyCodes[133] = "\u001b[[C";
            this.mKeyCodes[134] = "\u001b[[D";
            this.mKeyCodes[135] = "\u001b[[E";
            this.mKeyCodes[136] = "\u001b[17~";
            this.mKeyCodes[137] = "\u001b[18~";
            this.mKeyCodes[138] = "\u001b[19~";
            this.mKeyCodes[139] = "\u001b[20~";
            this.mKeyCodes[140] = "\u001b[21~";
            this.mKeyCodes[141] = "\u001b[23~";
            this.mKeyCodes[142] = "\u001b[24~";
        } else {
            this.mKeyCodes[131] = "\u001bOP";
            this.mKeyCodes[132] = "\u001bOQ";
            this.mKeyCodes[133] = "\u001bOR";
            this.mKeyCodes[134] = "\u001bOS";
            this.mKeyCodes[135] = "\u001b[15~";
            this.mKeyCodes[136] = "\u001b[17~";
            this.mKeyCodes[137] = "\u001b[18~";
            this.mKeyCodes[138] = "\u001b[19~";
            this.mKeyCodes[139] = "\u001b[20~";
            this.mKeyCodes[140] = "\u001b[21~";
            this.mKeyCodes[141] = "\u001b[23~";
            this.mKeyCodes[142] = "\u001b[24~";
        }
    }

    public int mapControlChar(int ch) {
        return this.mapControlChar(this.mHardwareControlKey || this.mControlKey.isActive(), this.mFnKey.isActive(), ch);
    }

    public int mapControlChar(boolean control, boolean fn, int ch) {
        int result = ch;
        if (control) {
            if (result >= 97 && result <= 122) {
                result = (char)(result - 97 + 1);
            } else if (result >= 65 && result <= 90) {
                result = (char)(result - 65 + 1);
            } else if (result == 32 || result == 50) {
                result = 0;
            } else if (result == 91 || result == 51) {
                result = 27;
            } else if (result == 92 || result == 52) {
                result = 28;
            } else if (result == 93 || result == 53) {
                result = 29;
            } else if (result == 94 || result == 54) {
                result = 30;
            } else if (result == 95 || result == 55) {
                result = 31;
            } else if (result == 56) {
                result = 127;
            } else if (result == 57) {
                result = 10485901;
            } else if (result == 48) {
                result = 10485902;
            }
        } else if (fn) {
            if (result == 119 || result == 87) {
                result = 10485779;
            } else if (result == 97 || result == 65) {
                result = 10485781;
            } else if (result == 115 || result == 83) {
                result = 10485780;
            } else if (result == 100 || result == 68) {
                result = 10485782;
            } else if (result == 112 || result == 80) {
                result = 10485852;
            } else if (result == 110 || result == 78) {
                result = 10485853;
            } else if (result == 116 || result == 84) {
                result = 10485821;
            } else if (result == 108 || result == 76) {
                result = 124;
            } else if (result == 117 || result == 85) {
                result = 95;
            } else if (result == 101 || result == 69) {
                result = 27;
            } else if (result == 46) {
                result = 28;
            } else if (result > 48 && result <= 57) {
                result = (char)(result + 0xA00000 + 131 - 1);
            } else if (result == 48) {
                result = 10485900;
            } else if (result == 105 || result == 73) {
                result = 10485884;
            } else if (result == 120 || result == 88) {
                result = 0xA00070;
            } else if (result == 104 || result == 72) {
                result = 0xA0007A;
            } else if (result == 102 || result == 70) {
                result = 10485883;
            }
        }
        if (result > -1) {
            this.mAltKey.adjustAfterKeypress();
            this.mCapKey.adjustAfterKeypress();
            this.mControlKey.adjustAfterKeypress();
            this.mFnKey.adjustAfterKeypress();
            this.updateCursorMode();
        }
        return result;
    }

    public void keyDown(int keyCode, KeyEvent event, boolean appMode, boolean allowToggle) throws IOException {
        boolean effectiveFn;
        boolean effectiveControl;
        if (this.handleKeyCode(keyCode, event, appMode)) {
            return;
        }
        int result = -1;
        boolean chordedCtrl = false;
        boolean setHighBit = false;
        switch (keyCode) {
            case 57: 
            case 58: {
                if (!allowToggle) break;
                this.mAltKey.onPress();
                this.updateCursorMode();
                break;
            }
            case 59: 
            case 60: {
                if (!allowToggle) break;
                this.mCapKey.onPress();
                this.updateCursorMode();
                break;
            }
            case 113: 
            case 114: {
                return;
            }
            case 115: {
                return;
            }
            case 119: {
                return;
            }
            case 4: {
                result = this.mBackKeyCode;
                break;
            }
            default: {
                int metaState = event.getMetaState();
                chordedCtrl = (0x1000 & metaState) != 0;
                boolean effectiveCaps = allowToggle && this.mCapKey.isActive();
                boolean effectiveAlt = allowToggle && this.mAltKey.isActive();
                int effectiveMetaState = metaState & 0xFFFF8FFF;
                if (effectiveCaps) {
                    effectiveMetaState |= 1;
                }
                if (!allowToggle && (effectiveMetaState & 2) != 0) {
                    effectiveAlt = true;
                }
                if (effectiveAlt) {
                    if (this.mAltSendsEsc) {
                        this.mTermSession.write(new byte[]{27}, 0, 1);
                        effectiveMetaState &= 0xFFFFFFCD;
                    } else {
                        effectiveMetaState |= 2;
                    }
                }
                if ((metaState & 0x10000) != 0 && this.mAltSendsEsc) {
                    this.mTermSession.write(new byte[]{27}, 0, 1);
                    effectiveMetaState &= 0xFFF8FFFF;
                }
                if (((result = event.getUnicodeChar(effectiveMetaState)) & Integer.MIN_VALUE) != 0) {
                    this.mCombiningAccent = result & Integer.MAX_VALUE;
                    return;
                }
                if (this.mCombiningAccent == 0) break;
                int unaccentedChar = result;
                result = KeyCharacterMap.getDeadChar((int)this.mCombiningAccent, (int)unaccentedChar);
                this.mCombiningAccent = 0;
                break;
            }
        }
        if ((result = this.mapControlChar(effectiveControl = chordedCtrl || this.mHardwareControlKey || allowToggle && this.mControlKey.isActive(), effectiveFn = allowToggle && this.mFnKey.isActive(), result)) >= 0xA00000) {
            this.handleKeyCode(result - 0xA00000, null, appMode);
        } else if (result >= 0) {
            if (setHighBit) {
                result |= 0x80;
            }
            this.mTermSession.write(result);
        }
    }

    public int getCombiningAccent() {
        return this.mCombiningAccent;
    }

    public int getCursorMode() {
        return this.mCursorMode;
    }

    private void updateCursorMode() {
        this.mCursorMode = TermKeyListener.getCursorModeHelper(this.mCapKey, 0) | TermKeyListener.getCursorModeHelper(this.mAltKey, 2) | TermKeyListener.getCursorModeHelper(this.mControlKey, 4) | TermKeyListener.getCursorModeHelper(this.mFnKey, 6);
    }

    private static int getCursorModeHelper(ModifierKey key, int shift) {
        return key.getUIMode() << shift;
    }

    static boolean isEventFromToggleDevice(KeyEvent event) {
        if (AndroidCompat.SDK < 11) {
            return true;
        }
        KeyCharacterMapCompat kcm = KeyCharacterMapCompat.wrap(KeyCharacterMap.load((int)event.getDeviceId()));
        return kcm.getModifierBehaviour() == 1;
    }

    public boolean handleKeyCode(int keyCode, KeyEvent event, boolean appMode) throws IOException {
        String code = null;
        if (event != null) {
            int keyMod = 0;
            if (this.mHardwareControlKey || this.mControlKey.isActive()) {
                keyMod |= 0x40000000;
            }
            if ((event.getMetaState() & 2) != 0) {
                keyMod |= Integer.MIN_VALUE;
            }
            if ((event.getMetaState() & 1) != 0) {
                keyMod |= 0x20000000;
            }
            if ((code = mKeyMap.get(event.getScanCode() | 0x10000000 | keyMod)) == null) {
                code = mKeyMap.get(keyCode | keyMod);
            }
        }
        if (code == null && keyCode >= 0 && keyCode < this.mKeyCodes.length) {
            if (appMode) {
                code = this.mAppKeyCodes[keyCode];
            }
            if (code == null) {
                code = this.mKeyCodes[keyCode];
            }
        }
        if (code != null) {
            this.mTermSession.write(code);
            return true;
        }
        return false;
    }

    public void keyUp(int keyCode, KeyEvent event) {
        boolean allowToggle = TermKeyListener.isEventFromToggleDevice(event);
        switch (keyCode) {
            case 57: 
            case 58: {
                if (!allowToggle) break;
                this.mAltKey.onRelease();
                this.updateCursorMode();
                break;
            }
            case 59: 
            case 60: {
                if (!allowToggle) break;
                this.mCapKey.onRelease();
                this.updateCursorMode();
                break;
            }
            case 113: 
            case 114: {
                break;
            }
        }
    }

    public boolean getAltSendsEsc() {
        return this.mAltSendsEsc;
    }

    public boolean isAltActive() {
        return this.mAltKey.isActive();
    }

    public boolean isCtrlActive() {
        return this.mControlKey.isActive();
    }

    private class ModifierKey {
        private int mState = 0;
        private static final int UNPRESSED = 0;
        private static final int PRESSED = 1;
        private static final int RELEASED = 2;
        private static final int USED = 3;
        private static final int LOCKED = 4;

        public void onPress() {
            switch (this.mState) {
                case 1: {
                    break;
                }
                case 2: {
                    this.mState = 4;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.mState = 0;
                    break;
                }
                default: {
                    this.mState = 1;
                }
            }
        }

        public void onRelease() {
            switch (this.mState) {
                case 3: {
                    this.mState = 0;
                    break;
                }
                case 1: {
                    this.mState = 2;
                    break;
                }
            }
        }

        public void adjustAfterKeypress() {
            switch (this.mState) {
                case 1: {
                    this.mState = 3;
                    break;
                }
                case 2: {
                    this.mState = 0;
                    break;
                }
            }
        }

        public boolean isActive() {
            return this.mState != 0;
        }

        public int getUIMode() {
            switch (this.mState) {
                default: {
                    return 0;
                }
                case 1: 
                case 2: 
                case 3: {
                    return 1;
                }
                case 4: 
            }
            return 2;
        }
    }
}

