/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import jackpal.androidterm.emulatorview.BaseTextRenderer;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.R;
import jackpal.androidterm.emulatorview.TextStyle;
import jackpal.androidterm.emulatorview.compat.AndroidCompat;

class Bitmap4x8FontRenderer
extends BaseTextRenderer {
    private static final int kCharacterWidth = 4;
    private static final int kCharacterHeight = 8;
    private Bitmap mFont;
    private int mCurrentForeColor;
    private int mCurrentBackColor;
    private float[] mColorMatrix;
    private Paint mPaint;
    private static final float BYTE_SCALE = 0.003921569f;

    public Bitmap4x8FontRenderer(Resources resources, ColorScheme scheme) {
        super(scheme);
        int fontResource = AndroidCompat.SDK <= 3 ? R.drawable.atari_small : R.drawable.atari_small_nodpi;
        this.mFont = BitmapFactory.decodeResource((Resources)resources, (int)fontResource);
        this.mPaint = new Paint();
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }

    @Override
    public float getCharacterWidth() {
        return 4.0f;
    }

    @Override
    public int getCharacterHeight() {
        return 8;
    }

    @Override
    public int getTopMargin() {
        return 0;
    }

    @Override
    public void drawTextRun(Canvas canvas, float x, float y, int lineOffset, int runWidth, char[] text, int index, int count, boolean selectionStyle, int textStyle, int cursorOffset, int cursorIndex, int cursorIncr, int cursorWidth, int cursorMode) {
        boolean invisible;
        boolean blink;
        boolean bold;
        int foreColor = TextStyle.decodeForeColor(textStyle);
        int backColor = TextStyle.decodeBackColor(textStyle);
        int effect = TextStyle.decodeEffect(textStyle);
        boolean inverse = this.mReverseVideo ^ (effect & 0x12) != 0;
        if (inverse) {
            int temp = foreColor;
            foreColor = backColor;
            backColor = temp;
        }
        boolean bl = bold = (effect & 1) != 0;
        if (bold && foreColor < 8) {
            foreColor += 8;
        }
        boolean bl2 = blink = (effect & 8) != 0;
        if (blink && backColor < 8) {
            backColor += 8;
        }
        if (selectionStyle) {
            backColor = 259;
        }
        boolean bl3 = invisible = (effect & 0x20) != 0;
        if (invisible) {
            foreColor = backColor;
        }
        this.drawTextRunHelper(canvas, x, y, lineOffset, text, index, count, foreColor, backColor);
        if (lineOffset <= cursorOffset && cursorOffset < lineOffset + count) {
            this.drawTextRunHelper(canvas, x, y, cursorOffset, text, cursorOffset - lineOffset, 1, 258, 259);
        }
    }

    private void drawTextRunHelper(Canvas canvas, float x, float y, int lineOffset, char[] text, int index, int count, int foreColor, int backColor) {
        this.setColorMatrix(this.mPalette[foreColor], this.mPalette[backColor]);
        int destX = (int)x + 4 * lineOffset;
        int destY = (int)y;
        Rect srcRect = new Rect();
        Rect destRect = new Rect();
        destRect.top = destY - 8;
        destRect.bottom = destY;
        boolean drawSpaces = this.mPalette[backColor] != this.mPalette[257];
        for (int i = 0; i < count; ++i) {
            char c = text[i + index];
            if (c < '\u0080' && (c != ' ' || drawSpaces)) {
                int cellX = c & 0x1F;
                int cellY = c >> 5 & 3;
                int srcX = cellX * 4;
                int srcY = cellY * 8;
                srcRect.set(srcX, srcY, srcX + 4, srcY + 8);
                destRect.left = destX;
                destRect.right = destX + 4;
                canvas.drawBitmap(this.mFont, srcRect, destRect, this.mPaint);
            }
            destX += 4;
        }
    }

    private void setColorMatrix(int foreColor, int backColor) {
        if (foreColor != this.mCurrentForeColor || backColor != this.mCurrentBackColor || this.mColorMatrix == null) {
            this.mCurrentForeColor = foreColor;
            this.mCurrentBackColor = backColor;
            if (this.mColorMatrix == null) {
                this.mColorMatrix = new float[20];
                this.mColorMatrix[18] = 1.0f;
            }
            for (int component = 0; component < 3; ++component) {
                int rightShift = 2 - component << 3;
                int fore = 0xFF & foreColor >> rightShift;
                int back = 0xFF & backColor >> rightShift;
                int delta = back - fore;
                this.mColorMatrix[component * 6] = (float)delta * 0.003921569f;
                this.mColorMatrix[component * 5 + 4] = fore;
            }
            this.mPaint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.mColorMatrix));
        }
    }
}

