/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.shortcuts;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import jackpal.androidterm.R;
import jackpal.androidterm.RemoteInterface;
import jackpal.androidterm.RunShortcut;
import jackpal.androidterm.compat.AlertDialogCompat;
import jackpal.androidterm.compat.PRNGFixes;
import jackpal.androidterm.shortcuts.ColorValue;
import jackpal.androidterm.shortcuts.FSNavigator;
import jackpal.androidterm.shortcuts.TextIcon;
import jackpal.androidterm.util.ShortcutEncryption;
import java.io.File;
import java.security.GeneralSecurityException;

public class AddShortcut
extends Activity {
    private final int OP_MAKE_SHORTCUT = 1;
    private final Context context = this;
    private SharedPreferences SP;
    private int ix = 0;
    private final int PATH = this.ix++;
    private final int ARGS = this.ix++;
    private final int NAME = this.ix++;
    private final EditText[] et = new EditText[5];
    private String path;
    private String name = "";
    private String[] iconText = new String[]{"", null};

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.SP = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        String action = this.getIntent().getAction();
        if (action != null && action.equals("android.intent.action.CREATE_SHORTCUT")) {
            this.makeShortcut();
        } else {
            this.finish();
        }
    }

    void makeShortcut() {
        if (this.path == null) {
            this.path = "";
        }
        AlertDialog.Builder alert = AlertDialogCompat.newInstanceBuilder(this.context, AlertDialogCompat.THEME_HOLO_DARK);
        LinearLayout lv = new LinearLayout(this.context);
        lv.setOrientation(1);
        int n = this.et.length;
        for (int i = 0; i < n; ++i) {
            this.et[i] = new EditText(this.context);
            this.et[i].setSingleLine(true);
        }
        if (!this.path.equals("")) {
            this.et[0].setText((CharSequence)this.path);
        }
        this.et[this.PATH].setHint((CharSequence)this.getString(R.string.addshortcut_command_hint));
        this.et[this.NAME].setText((CharSequence)this.name);
        this.et[this.ARGS].setHint((CharSequence)this.getString(R.string.addshortcut_example_hint));
        this.et[this.ARGS].setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean focus) {
                String s;
                if (!focus && AddShortcut.this.et[AddShortcut.this.NAME].getText().toString().equals("") && !(s = AddShortcut.this.et[AddShortcut.this.ARGS].getText().toString()).equals("")) {
                    AddShortcut.this.et[AddShortcut.this.NAME].setText((CharSequence)s.split("\\s")[0]);
                }
            }
        });
        Button btn_path = new Button(this.context);
        btn_path.setText((CharSequence)this.getString(R.string.addshortcut_button_find_command));
        btn_path.setOnClickListener(new View.OnClickListener(){

            public void onClick(View p1) {
                String lastPath = AddShortcut.this.SP.getString("lastPath", null);
                File get = lastPath == null ? Environment.getExternalStorageDirectory() : new File(lastPath).getParentFile();
                Intent pickerIntent = new Intent();
                if (AddShortcut.this.SP.getBoolean("useInternalScriptFinder", false)) {
                    pickerIntent.setClass(AddShortcut.this.getApplicationContext(), FSNavigator.class).setData(Uri.fromFile((File)get)).putExtra("title", AddShortcut.this.getString(R.string.addshortcut_navigator_title));
                } else {
                    pickerIntent.putExtra("CONTENT_TYPE", "*/*").setAction("android.intent.action.PICK");
                }
                AddShortcut.this.startActivityForResult(pickerIntent, 1);
            }
        });
        lv.addView((View)this.layoutTextViewH(this.getString(R.string.addshortcut_command_window_instructions), null, false));
        lv.addView((View)this.layoutViewViewH((View)btn_path, (View)this.et[this.PATH]));
        lv.addView((View)this.layoutTextViewH(this.getString(R.string.addshortcut_arguments_label), (View)this.et[this.ARGS]));
        lv.addView((View)this.layoutTextViewH(this.getString(R.string.addshortcut_shortcut_label), (View)this.et[this.NAME]));
        final ImageView img = new ImageView(this.context);
        img.setImageResource(R.drawable.ic_launcher);
        img.setMaxHeight(100);
        img.setTag((Object)-1);
        img.setMaxWidth(100);
        img.setAdjustViewBounds(true);
        img.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        Button btn_color = new Button(this.context);
        btn_color.setText((CharSequence)this.getString(R.string.addshortcut_button_text_icon));
        btn_color.setOnClickListener(new View.OnClickListener(){

            public void onClick(View p1) {
                new ColorValue(AddShortcut.this.context, img, AddShortcut.this.iconText);
            }
        });
        lv.addView((View)this.layoutTextViewH(this.getString(R.string.addshortcut_text_icon_instructions), null, false));
        lv.addView((View)this.layoutViewViewH((View)btn_color, (View)img));
        ScrollView sv = new ScrollView(this.context);
        sv.setFillViewport(true);
        sv.addView((View)lv);
        alert.setView((View)sv);
        alert.setTitle((CharSequence)this.getString(R.string.addshortcut_title));
        alert.setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AddShortcut.this.buildShortcut(AddShortcut.this.path, AddShortcut.this.et[AddShortcut.this.ARGS].getText().toString(), AddShortcut.this.et[AddShortcut.this.NAME].getText().toString(), AddShortcut.this.iconText[1], (Integer)img.getTag());
            }
        });
        alert.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AddShortcut.this.finish();
            }
        });
        alert.show();
    }

    LinearLayout layoutTextViewH(String text, View vw) {
        return this.layoutTextViewH(text, vw, true);
    }

    LinearLayout layoutTextViewH(String text, View vw, boolean attributes) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        TextView tv = new TextView(this.context);
        tv.setText((CharSequence)text);
        if (attributes) {
            tv.setTypeface(Typeface.DEFAULT_BOLD);
        }
        if (attributes) {
            tv.setGravity(21);
        }
        tv.setPadding(10, tv.getPaddingTop(), 10, tv.getPaddingBottom());
        LinearLayout lh = new LinearLayout(this.context);
        lh.setOrientation(0);
        lh.addView((View)tv, (ViewGroup.LayoutParams)lp);
        if (vw != null) {
            lh.addView(vw, (ViewGroup.LayoutParams)lp);
        }
        return lh;
    }

    LinearLayout layoutViewViewH(View vw1, View vw2) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        LinearLayout lh = new LinearLayout(this.context);
        lh.setOrientation(0);
        lh.addView(vw1, (ViewGroup.LayoutParams)lp);
        if (vw2 != null) {
            lh.addView(vw2, (ViewGroup.LayoutParams)lp);
        }
        return lh;
    }

    void buildShortcut(String path, String arguments, String shortcutName, String shortcutText, int shortcutColor) {
        PRNGFixes.apply();
        ShortcutEncryption.Keys keys = ShortcutEncryption.getKeys(this.context);
        if (keys == null) {
            try {
                keys = ShortcutEncryption.generateKeys();
            }
            catch (GeneralSecurityException e) {
                Log.e((String)"Term", (String)("Generating shortcut encryption keys failed: " + e.toString()));
                throw new RuntimeException(e);
            }
            ShortcutEncryption.saveKeys(this.context, keys);
        }
        StringBuilder cmd = new StringBuilder();
        if (path != null && !path.equals("")) {
            cmd.append(RemoteInterface.quoteForBash(path));
        }
        if (arguments != null && !arguments.equals("")) {
            cmd.append(" " + arguments);
        }
        String cmdStr = cmd.toString();
        String cmdEnc = null;
        try {
            cmdEnc = ShortcutEncryption.encrypt(cmdStr, keys);
        }
        catch (GeneralSecurityException e) {
            Log.e((String)"Term", (String)("Shortcut encryption failed: " + e.toString()));
            throw new RuntimeException(e);
        }
        Intent target = new Intent().setClass(this.context, RunShortcut.class);
        target.setAction("jackpal.androidterm.RUN_SHORTCUT");
        target.putExtra("jackpal.androidterm.iShortcutCommand", cmdEnc);
        target.putExtra("jackpal.androidterm.window_handle", shortcutName);
        target.addFlags(0x10000000);
        Intent wrapper = new Intent();
        wrapper.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
        wrapper.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)target);
        if (shortcutName != null && !shortcutName.equals("")) {
            wrapper.putExtra("android.intent.extra.shortcut.NAME", shortcutName);
        }
        if (shortcutText != null && !shortcutText.equals("")) {
            wrapper.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)TextIcon.getTextIcon(shortcutText, shortcutColor, 96, 96));
        } else {
            wrapper.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)this.context, (int)R.drawable.ic_launcher));
        }
        this.setResult(-1, wrapper);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Uri uri = null;
        this.path = null;
        switch (requestCode) {
            case 1: {
                if (data != null && (uri = data.getData()) != null && (this.path = uri.getPath()) != null) {
                    this.SP.edit().putString("lastPath", this.path).commit();
                    this.et[this.PATH].setText((CharSequence)this.path);
                    this.name = this.path.replaceAll(".*/", "");
                    if (this.et[this.NAME].getText().toString().equals("")) {
                        this.et[this.NAME].setText((CharSequence)this.name);
                    }
                    if (this.iconText[0] == null || !this.iconText[0].equals("")) break;
                    this.iconText[0] = this.name;
                    break;
                }
                this.finish();
            }
        }
    }
}

