/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.ResultReceiver;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import jackpal.androidterm.BoundSession;
import jackpal.androidterm.GenericTermSession;
import jackpal.androidterm.R;
import jackpal.androidterm.Term;
import jackpal.androidterm.compat.ServiceForegroundCompat;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.libtermexec.v1.ITerminal;
import jackpal.androidterm.util.SessionList;
import jackpal.androidterm.util.TermSettings;
import java.util.UUID;

public class TermService
extends Service
implements TermSession.FinishCallback {
    private static final int COMPAT_START_STICKY = 1;
    private static final int RUNNING_NOTIFICATION = 1;
    private ServiceForegroundCompat compat;
    private SessionList mTermSessions;
    private final IBinder mTSBinder = new TSBinder();

    public void onStart(Intent intent, int flags) {
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    public IBinder onBind(Intent intent) {
        if ("jackpal.androidterm.action.START_TERM.v1".equals(intent.getAction())) {
            Log.i((String)"TermService", (String)"Outside process called onBind()");
            return new RBinder();
        }
        Log.i((String)"TermService", (String)"Activity called onBind()");
        return this.mTSBinder;
    }

    public void onCreate() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext());
        SharedPreferences.Editor editor = prefs.edit();
        String defValue = this.getDir("HOME", 0).getAbsolutePath();
        String homePath = prefs.getString("home_path", defValue);
        editor.putString("home_path", homePath);
        editor.commit();
        this.compat = new ServiceForegroundCompat(this);
        this.mTermSessions = new SessionList();
        Notification notification = new Notification(R.drawable.ic_stat_service_notification_icon, this.getText(R.string.service_notify_text), System.currentTimeMillis());
        notification.flags |= 2;
        Intent notifyIntent = new Intent((Context)this, Term.class);
        notifyIntent.addFlags(0x10000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)notifyIntent, (int)0);
        notification.setLatestEventInfo((Context)this, this.getText(R.string.application_terminal), this.getText(R.string.service_notify_text), pendingIntent);
        this.compat.startForeground(1, notification);
        Log.d((String)"Term", (String)"TermService started");
    }

    public void onDestroy() {
        this.compat.stopForeground(true);
        for (TermSession session : this.mTermSessions) {
            session.setFinishCallback(null);
            session.finish();
        }
        this.mTermSessions.clear();
    }

    public SessionList getSessions() {
        return this.mTermSessions;
    }

    public void onSessionFinish(TermSession session) {
        this.mTermSessions.remove(session);
    }

    private final class RBinderCleanupCallback
    implements TermSession.FinishCallback {
        private final PendingIntent result;
        private final ResultReceiver callback;

        public RBinderCleanupCallback(PendingIntent result, ResultReceiver callback) {
            this.result = result;
            this.callback = callback;
        }

        public void onSessionFinish(TermSession session) {
            this.result.cancel();
            this.callback.send(0, new Bundle());
            TermService.this.mTermSessions.remove(session);
        }
    }

    private final class RBinder
    extends ITerminal.Stub {
        private RBinder() {
        }

        public IntentSender startSession(final ParcelFileDescriptor pseudoTerminalMultiplexerFd, final ResultReceiver callback) {
            final String sessionHandle = UUID.randomUUID().toString();
            Intent switchIntent = new Intent("jackpal.androidterm.private.OPEN_NEW_WINDOW").setData(Uri.parse((String)sessionHandle)).addCategory("android.intent.category.DEFAULT").addFlags(0x10000000).putExtra("jackpal.androidterm.private.target_window", sessionHandle);
            final PendingIntent result = PendingIntent.getActivity((Context)TermService.this.getApplicationContext(), (int)sessionHandle.hashCode(), (Intent)switchIntent, (int)0);
            PackageManager pm = TermService.this.getPackageManager();
            String[] pkgs = pm.getPackagesForUid(RBinder.getCallingUid());
            if (pkgs == null || pkgs.length == 0) {
                return null;
            }
            for (String packageName : pkgs) {
                try {
                    CharSequence label;
                    PackageInfo pkgInfo = pm.getPackageInfo(packageName, 0);
                    ApplicationInfo appInfo = pkgInfo.applicationInfo;
                    if (appInfo == null || TextUtils.isEmpty((CharSequence)(label = pm.getApplicationLabel(appInfo)))) continue;
                    final String niceName = label.toString();
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                GenericTermSession session = null;
                                try {
                                    TermSettings settings = new TermSettings(TermService.this.getResources(), PreferenceManager.getDefaultSharedPreferences((Context)TermService.this.getApplicationContext()));
                                    session = new BoundSession(pseudoTerminalMultiplexerFd, settings, niceName);
                                    TermService.this.mTermSessions.add(session);
                                    session.setHandle(sessionHandle);
                                    session.setFinishCallback(new RBinderCleanupCallback(result, callback));
                                    session.setTitle("");
                                    session.initializeEmulator(80, 24);
                                }
                                catch (Exception whatWentWrong) {
                                    Log.e((String)"TermService", (String)("Failed to bootstrap AIDL session: " + whatWentWrong.getMessage()));
                                    if (session == null) break block2;
                                    session.finish();
                                }
                            }
                        }
                    });
                    return result.getIntentSender();
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public class TSBinder
    extends Binder {
        TermService getService() {
            Log.i((String)"TermService", (String)"Activity binding to service");
            return TermService.this;
        }
    }
}

