/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextMenu;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import jackpal.androidterm.GenericTermSession;
import jackpal.androidterm.R;
import jackpal.androidterm.ShellTermSession;
import jackpal.androidterm.TermPreferences;
import jackpal.androidterm.TermService;
import jackpal.androidterm.TermView;
import jackpal.androidterm.TermViewFlipper;
import jackpal.androidterm.WindowList;
import jackpal.androidterm.WindowListAdapter;
import jackpal.androidterm.compat.ActionBarCompat;
import jackpal.androidterm.compat.ActivityCompat;
import jackpal.androidterm.compat.AndroidCompat;
import jackpal.androidterm.compat.MenuItemCompat;
import jackpal.androidterm.emulatorview.EmulatorView;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.UpdateCallback;
import jackpal.androidterm.emulatorview.compat.ClipboardManagerCompat;
import jackpal.androidterm.emulatorview.compat.ClipboardManagerCompatFactory;
import jackpal.androidterm.util.SessionList;
import jackpal.androidterm.util.TermSettings;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class Term
extends Activity
implements UpdateCallback,
SharedPreferences.OnSharedPreferenceChangeListener {
    private TermViewFlipper mViewFlipper;
    private static final int VIEW_FLIPPER = R.id.view_flipper;
    private SessionList mTermSessions;
    private TermSettings mSettings;
    private static final int SELECT_TEXT_ID = 0;
    private static final int COPY_ALL_ID = 1;
    private static final int PASTE_ID = 2;
    private static final int SEND_CONTROL_KEY_ID = 3;
    private static final int SEND_FN_KEY_ID = 4;
    private boolean mAlreadyStarted = false;
    private boolean mStopServiceOnFinish = false;
    private Intent TSIntent;
    public static final int REQUEST_CHOOSE_WINDOW = 1;
    public static final String EXTRA_WINDOW_ID = "jackpal.androidterm.window_id";
    private int onResumeSelectWindow = -1;
    private ComponentName mPrivateAlias;
    private PowerManager.WakeLock mWakeLock;
    private WifiManager.WifiLock mWifiLock;
    private static final int WIFI_MODE_FULL_HIGH_PERF = 3;
    private boolean mBackKeyPressed;
    private static final String ACTION_PATH_BROADCAST = "jackpal.androidterm.broadcast.APPEND_TO_PATH";
    private static final String ACTION_PATH_PREPEND_BROADCAST = "jackpal.androidterm.broadcast.PREPEND_TO_PATH";
    private static final String PERMISSION_PATH_BROADCAST = "jackpal.androidterm.permission.APPEND_TO_PATH";
    private static final String PERMISSION_PATH_PREPEND_BROADCAST = "jackpal.androidterm.permission.PREPEND_TO_PATH";
    private int mPendingPathBroadcasts = 0;
    private BroadcastReceiver mPathReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String path = Term.this.makePathFromBundle(this.getResultExtras(false));
            if (intent.getAction().equals(Term.ACTION_PATH_PREPEND_BROADCAST)) {
                Term.this.mSettings.setPrependPath(path);
            } else {
                Term.this.mSettings.setAppendPath(path);
            }
            Term.this.mPendingPathBroadcasts--;
            if (Term.this.mPendingPathBroadcasts <= 0 && Term.this.mTermService != null) {
                Term.this.populateViewFlipper();
                Term.this.populateWindowList();
            }
        }
    };
    private static final int FLAG_INCLUDE_STOPPED_PACKAGES = 32;
    private TermService mTermService;
    private ServiceConnection mTSConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            Log.i((String)"Term", (String)"Bound to TermService");
            TermService.TSBinder binder = (TermService.TSBinder)service;
            Term.this.mTermService = binder.getService();
            if (Term.this.mPendingPathBroadcasts <= 0) {
                Term.this.populateViewFlipper();
                Term.this.populateWindowList();
            }
        }

        public void onServiceDisconnected(ComponentName arg0) {
            Term.this.mTermService = null;
        }
    };
    private ActionBarCompat mActionBar;
    private int mActionBarMode = 0;
    private WindowListAdapter mWinListAdapter;
    private ActionBarCompat.OnNavigationListener mWinListItemSelected = new ActionBarCompat.OnNavigationListener(){

        @Override
        public boolean onNavigationItemSelected(int position, long id2) {
            int oldPosition = Term.this.mViewFlipper.getDisplayedChild();
            if (position != oldPosition) {
                if (position >= Term.this.mViewFlipper.getChildCount()) {
                    Term.this.mViewFlipper.addView((View)Term.this.createEmulatorView((TermSession)Term.this.mTermSessions.get(position)));
                }
                Term.this.mViewFlipper.setDisplayedChild(position);
                if (Term.this.mActionBarMode == 2) {
                    Term.this.mActionBar.hide();
                }
            }
            return true;
        }
    };
    private boolean mHaveFullHwKeyboard = false;
    private boolean mUseKeyboardShortcuts;
    private View.OnKeyListener mKeyListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            return this.backkeyInterceptor(keyCode, event) || this.keyboardShortcuts(keyCode, event);
        }

        private boolean keyboardShortcuts(int keyCode, KeyEvent event) {
            boolean isShiftPressed;
            if (event.getAction() != 0) {
                return false;
            }
            if (!Term.this.mUseKeyboardShortcuts) {
                return false;
            }
            boolean isCtrlPressed = (event.getMetaState() & 0x1000) != 0;
            boolean bl = isShiftPressed = (event.getMetaState() & 1) != 0;
            if (keyCode == 61 && isCtrlPressed) {
                if (isShiftPressed) {
                    Term.this.mViewFlipper.showPrevious();
                } else {
                    Term.this.mViewFlipper.showNext();
                }
                return true;
            }
            if (keyCode == 42 && isCtrlPressed && isShiftPressed) {
                Term.this.doCreateNewWindow();
                return true;
            }
            if (keyCode == 50 && isCtrlPressed && isShiftPressed) {
                Term.this.doPaste();
                return true;
            }
            return false;
        }

        private boolean backkeyInterceptor(int keyCode, KeyEvent event) {
            if (keyCode == 4 && Term.this.mActionBarMode == 2 && Term.this.mActionBar != null && Term.this.mActionBar.isShowing()) {
                Term.this.onKeyUp(keyCode, event);
                return true;
            }
            return false;
        }
    };
    private Handler mHandler = new Handler();

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String s) {
        this.mSettings.readPrefs(sharedPreferences);
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Log.v((String)"Term", (String)"onCreate");
        this.mPrivateAlias = new ComponentName((Context)this, "jackpal.androidterm.TermInternal");
        if (icicle == null) {
            this.onNewIntent(this.getIntent());
        }
        SharedPreferences mPrefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.mSettings = new TermSettings(this.getResources(), mPrefs);
        mPrefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        Intent broadcast = new Intent(ACTION_PATH_BROADCAST);
        if (AndroidCompat.SDK >= 12) {
            broadcast.addFlags(32);
        }
        ++this.mPendingPathBroadcasts;
        this.sendOrderedBroadcast(broadcast, PERMISSION_PATH_BROADCAST, this.mPathReceiver, null, -1, null, null);
        broadcast = new Intent(broadcast);
        broadcast.setAction(ACTION_PATH_PREPEND_BROADCAST);
        ++this.mPendingPathBroadcasts;
        this.sendOrderedBroadcast(broadcast, PERMISSION_PATH_PREPEND_BROADCAST, this.mPathReceiver, null, -1, null, null);
        this.TSIntent = new Intent((Context)this, TermService.class);
        this.startService(this.TSIntent);
        if (AndroidCompat.SDK >= 11) {
            int actionBarMode;
            this.mActionBarMode = actionBarMode = this.mSettings.actionBarMode();
            if (AndroidCompat.V11ToV20) {
                switch (actionBarMode) {
                    case 1: {
                        this.setTheme(R.style.Theme_Holo);
                        break;
                    }
                    case 2: {
                        this.setTheme(R.style.Theme_Holo_ActionBarOverlay);
                    }
                }
            }
        } else {
            this.mActionBarMode = 1;
        }
        this.setContentView(R.layout.term_activity);
        this.mViewFlipper = (TermViewFlipper)this.findViewById(VIEW_FLIPPER);
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "Term");
        WifiManager wm = (WifiManager)this.getSystemService("wifi");
        int wifiLockMode = 1;
        if (AndroidCompat.SDK >= 12) {
            wifiLockMode = 3;
        }
        this.mWifiLock = wm.createWifiLock(wifiLockMode, "Term");
        ActionBarCompat actionBar = ActivityCompat.getActionBar(this);
        if (actionBar != null) {
            this.mActionBar = actionBar;
            actionBar.setNavigationMode(1);
            actionBar.setDisplayOptions(0, 8);
            if (this.mActionBarMode == 2) {
                actionBar.hide();
            }
        }
        this.mHaveFullHwKeyboard = this.checkHaveFullHwKeyboard(this.getResources().getConfiguration());
        this.updatePrefs();
        this.mAlreadyStarted = true;
    }

    private String makePathFromBundle(Bundle extras) {
        if (extras == null || extras.size() == 0) {
            return "";
        }
        String[] keys = new String[extras.size()];
        keys = extras.keySet().toArray(keys);
        Collator collator = Collator.getInstance(Locale.US);
        Arrays.sort(keys, collator);
        StringBuilder path = new StringBuilder();
        for (String key : keys) {
            String dir = extras.getString(key);
            if (dir == null || dir.equals("")) continue;
            path.append(dir);
            path.append(":");
        }
        return path.substring(0, path.length() - 1);
    }

    protected void onStart() {
        super.onStart();
        if (!this.bindService(this.TSIntent, this.mTSConnection, 1)) {
            throw new IllegalStateException("Failed to bind to TermService!");
        }
    }

    private void populateViewFlipper() {
        if (this.mTermService != null) {
            this.mTermSessions = this.mTermService.getSessions();
            if (this.mTermSessions.size() == 0) {
                try {
                    this.mTermSessions.add(this.createTermSession());
                }
                catch (IOException e) {
                    Toast.makeText((Context)this, (CharSequence)"Failed to start terminal session", (int)1).show();
                    this.finish();
                    return;
                }
            }
            this.mTermSessions.addCallback(this);
            for (TermSession session : this.mTermSessions) {
                TermView view = this.createEmulatorView(session);
                this.mViewFlipper.addView((View)view);
            }
            this.updatePrefs();
            if (this.onResumeSelectWindow >= 0) {
                this.mViewFlipper.setDisplayedChild(this.onResumeSelectWindow);
                this.onResumeSelectWindow = -1;
            }
            this.mViewFlipper.onResume();
        }
    }

    private void populateWindowList() {
        if (this.mActionBar == null) {
            return;
        }
        if (this.mTermSessions != null) {
            int position = this.mViewFlipper.getDisplayedChild();
            if (this.mWinListAdapter == null) {
                this.mWinListAdapter = new WindowListActionBarAdapter(this.mTermSessions);
                this.mActionBar.setListNavigationCallbacks((SpinnerAdapter)this.mWinListAdapter, this.mWinListItemSelected);
            } else {
                this.mWinListAdapter.setSessions(this.mTermSessions);
            }
            this.mViewFlipper.addCallback(this.mWinListAdapter);
            this.mActionBar.setSelectedNavigationItem(position);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        PreferenceManager.getDefaultSharedPreferences((Context)this).unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        if (this.mStopServiceOnFinish) {
            this.stopService(this.TSIntent);
        }
        this.mTermService = null;
        this.mTSConnection = null;
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
    }

    private void restart() {
        this.startActivity(this.getIntent());
        this.finish();
    }

    protected static TermSession createTermSession(Context context, TermSettings settings, String initialCommand) throws IOException {
        ShellTermSession session = new ShellTermSession(settings, initialCommand);
        ((GenericTermSession)session).setProcessExitMessage(context.getString(R.string.process_exit_message));
        return session;
    }

    private TermSession createTermSession() throws IOException {
        TermSettings settings = this.mSettings;
        TermSession session = Term.createTermSession((Context)this, settings, settings.getInitialCommand());
        session.setFinishCallback((TermSession.FinishCallback)this.mTermService);
        return session;
    }

    private TermView createEmulatorView(TermSession session) {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        TermView emulatorView = new TermView((Context)this, session, metrics);
        emulatorView.setExtGestureListener((GestureDetector.OnGestureListener)new EmulatorViewGestureListener(emulatorView));
        emulatorView.setOnKeyListener(this.mKeyListener);
        this.registerForContextMenu((View)emulatorView);
        return emulatorView;
    }

    private TermSession getCurrentTermSession() {
        SessionList sessions = this.mTermSessions;
        if (sessions == null) {
            return null;
        }
        return (TermSession)sessions.get(this.mViewFlipper.getDisplayedChild());
    }

    private EmulatorView getCurrentEmulatorView() {
        return (EmulatorView)this.mViewFlipper.getCurrentView();
    }

    private void updatePrefs() {
        int desiredFlag;
        this.mUseKeyboardShortcuts = this.mSettings.getUseKeyboardShortcutsFlag();
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        this.mViewFlipper.updatePrefs(this.mSettings);
        for (View v : this.mViewFlipper) {
            ((EmulatorView)v).setDensity(metrics);
            ((TermView)v).updatePrefs(this.mSettings);
        }
        if (this.mTermSessions != null) {
            for (TermSession session : this.mTermSessions) {
                ((GenericTermSession)session).updatePrefs(this.mSettings);
            }
        }
        Window win = this.getWindow();
        WindowManager.LayoutParams params = win.getAttributes();
        int FULLSCREEN = 1024;
        int n = desiredFlag = this.mSettings.showStatusBar() ? 0 : 1024;
        if (desiredFlag != (params.flags & 0x400) || AndroidCompat.SDK >= 11 && this.mActionBarMode != this.mSettings.actionBarMode()) {
            if (this.mAlreadyStarted) {
                this.restart();
            } else {
                win.setFlags(desiredFlag, 1024);
                if (this.mActionBarMode == 2 && this.mActionBar != null) {
                    this.mActionBar.hide();
                }
            }
        }
        int orientation = this.mSettings.getScreenOrientation();
        int o = 0;
        if (orientation == 0) {
            o = -1;
        } else if (orientation == 1) {
            o = 0;
        } else if (orientation == 2) {
            o = 1;
        }
        this.setRequestedOrientation(o);
    }

    public void onPause() {
        super.onPause();
        if (AndroidCompat.SDK < 5) {
            this.mBackKeyPressed = false;
        }
        final IBinder token = this.mViewFlipper.getWindowToken();
        new Thread(){

            @Override
            public void run() {
                InputMethodManager imm = (InputMethodManager)Term.this.getSystemService("input_method");
                imm.hideSoftInputFromWindow(token, 0);
            }
        }.start();
    }

    protected void onStop() {
        this.mViewFlipper.onPause();
        if (this.mTermSessions != null) {
            this.mTermSessions.removeCallback(this);
            if (this.mWinListAdapter != null) {
                this.mTermSessions.removeCallback(this.mWinListAdapter);
                this.mTermSessions.removeTitleChangedListener(this.mWinListAdapter);
                this.mViewFlipper.removeCallback(this.mWinListAdapter);
            }
        }
        this.mViewFlipper.removeAllViews();
        this.unbindService(this.mTSConnection);
        super.onStop();
    }

    private boolean checkHaveFullHwKeyboard(Configuration c) {
        return c.keyboard == 2 && c.hardKeyboardHidden == 1;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mHaveFullHwKeyboard = this.checkHaveFullHwKeyboard(newConfig);
        EmulatorView v = (EmulatorView)this.mViewFlipper.getCurrentView();
        if (v != null) {
            v.updateSize(false);
        }
        if (this.mWinListAdapter != null) {
            this.mWinListAdapter.notifyDataSetChanged();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.main, menu2);
        MenuItemCompat.setShowAsAction(menu2.findItem(R.id.menu_new_window), 2);
        MenuItemCompat.setShowAsAction(menu2.findItem(R.id.menu_close_window), 1);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.menu_preferences) {
            this.doPreferences();
        } else if (id2 == R.id.menu_new_window) {
            this.doCreateNewWindow();
        } else if (id2 == R.id.menu_close_window) {
            this.confirmCloseWindow();
        } else if (id2 == R.id.menu_window_list) {
            this.startActivityForResult(new Intent((Context)this, WindowList.class), 1);
        } else if (id2 == R.id.menu_reset) {
            this.doResetTerminal();
            Toast toast = Toast.makeText((Context)this, (int)R.string.reset_toast_notification, (int)1);
            toast.setGravity(17, 0, 0);
            toast.show();
        } else if (id2 == R.id.menu_send_email) {
            this.doEmailTranscript();
        } else if (id2 == R.id.menu_special_keys) {
            this.doDocumentKeys();
        } else if (id2 == R.id.menu_toggle_soft_keyboard) {
            this.doToggleSoftKeyboard();
        } else if (id2 == R.id.menu_toggle_wakelock) {
            this.doToggleWakeLock();
        } else if (id2 == R.id.menu_toggle_wifilock) {
            this.doToggleWifiLock();
        } else if (id2 == R.id.action_help) {
            Intent openHelp = new Intent("android.intent.action.VIEW", Uri.parse((String)this.getString(R.string.help_url)));
            this.startActivity(openHelp);
        }
        if (this.mActionBarMode == 2) {
            this.mActionBar.hide();
        }
        return super.onOptionsItemSelected(item);
    }

    private void doCreateNewWindow() {
        if (this.mTermSessions == null) {
            Log.w((String)"Term", (String)"Couldn't create new window because mTermSessions == null");
            return;
        }
        try {
            TermSession session = this.createTermSession();
            this.mTermSessions.add(session);
            TermView view = this.createEmulatorView(session);
            view.updatePrefs(this.mSettings);
            this.mViewFlipper.addView((View)view);
            this.mViewFlipper.setDisplayedChild(this.mViewFlipper.getChildCount() - 1);
        }
        catch (IOException e) {
            Toast.makeText((Context)this, (CharSequence)"Failed to create a session", (int)0).show();
        }
    }

    private void confirmCloseWindow() {
        AlertDialog.Builder b = new AlertDialog.Builder((Context)this);
        b.setIcon(17301543);
        b.setMessage(R.string.confirm_window_close_message);
        final Runnable closeWindow = new Runnable(){

            @Override
            public void run() {
                Term.this.doCloseWindow();
            }
        };
        b.setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.dismiss();
                Term.this.mHandler.post(closeWindow);
            }
        });
        b.setNegativeButton(17039369, null);
        b.show();
    }

    private void doCloseWindow() {
        if (this.mTermSessions == null) {
            return;
        }
        EmulatorView view = this.getCurrentEmulatorView();
        if (view == null) {
            return;
        }
        TermSession session = this.mTermSessions.remove(this.mViewFlipper.getDisplayedChild());
        view.onPause();
        session.finish();
        this.mViewFlipper.removeView((View)view);
        if (this.mTermSessions.size() != 0) {
            this.mViewFlipper.showNext();
        }
    }

    protected void onActivityResult(int request, int result, Intent data) {
        switch (request) {
            case 1: {
                if (result == -1 && data != null) {
                    int position = data.getIntExtra(EXTRA_WINDOW_ID, -2);
                    if (position >= 0) {
                        this.onResumeSelectWindow = position;
                        break;
                    }
                    if (position != -1) break;
                    this.doCreateNewWindow();
                    this.onResumeSelectWindow = this.mTermSessions.size() - 1;
                    break;
                }
                if (this.mTermSessions != null && this.mTermSessions.size() != 0) break;
                this.mStopServiceOnFinish = true;
                this.finish();
            }
        }
    }

    protected void onNewIntent(Intent intent) {
        if ((intent.getFlags() & 0x100000) != 0) {
            return;
        }
        String action = intent.getAction();
        if (TextUtils.isEmpty((CharSequence)action) || !this.mPrivateAlias.equals((Object)intent.getComponent())) {
            return;
        }
        switch (action) {
            case "jackpal.androidterm.private.OPEN_NEW_WINDOW": {
                this.onResumeSelectWindow = Integer.MAX_VALUE;
                break;
            }
            case "jackpal.androidterm.private.SWITCH_WINDOW": {
                int target = intent.getIntExtra("jackpal.androidterm.private.target_window", -1);
                if (target < 0) break;
                this.onResumeSelectWindow = target;
            }
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        MenuItem wakeLockItem = menu2.findItem(R.id.menu_toggle_wakelock);
        MenuItem wifiLockItem = menu2.findItem(R.id.menu_toggle_wifilock);
        if (this.mWakeLock.isHeld()) {
            wakeLockItem.setTitle(R.string.disable_wakelock);
        } else {
            wakeLockItem.setTitle(R.string.enable_wakelock);
        }
        if (this.mWifiLock.isHeld()) {
            wifiLockItem.setTitle(R.string.disable_wifilock);
        } else {
            wifiLockItem.setTitle(R.string.enable_wifilock);
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu2, v, menuInfo);
        menu2.setHeaderTitle(R.string.edit_text);
        menu2.add(0, 0, 0, R.string.select_text);
        menu2.add(0, 1, 0, R.string.copy_all);
        menu2.add(0, 2, 0, R.string.paste);
        menu2.add(0, 3, 0, R.string.send_control_key);
        menu2.add(0, 4, 0, R.string.send_fn_key);
        if (!this.canPaste()) {
            menu2.getItem(2).setEnabled(false);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 0: {
                this.getCurrentEmulatorView().toggleSelectingText();
                return true;
            }
            case 1: {
                this.doCopyAll();
                return true;
            }
            case 2: {
                this.doPaste();
                return true;
            }
            case 3: {
                this.doSendControlKey();
                return true;
            }
            case 4: {
                this.doSendFnKey();
                return true;
            }
        }
        return super.onContextItemSelected(item);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (AndroidCompat.SDK < 5 && keyCode == 4) {
            this.mBackKeyPressed = true;
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (AndroidCompat.SDK < 5) {
                    if (!this.mBackKeyPressed) {
                        return false;
                    }
                    this.mBackKeyPressed = false;
                }
                if (this.mActionBarMode == 2 && this.mActionBar != null && this.mActionBar.isShowing()) {
                    this.mActionBar.hide();
                    return true;
                }
                switch (this.mSettings.getBackKeyAction()) {
                    case 0: {
                        this.mStopServiceOnFinish = true;
                    }
                    case 2: {
                        this.finish();
                        return true;
                    }
                    case 1: {
                        this.doCloseWindow();
                        return true;
                    }
                }
                return false;
            }
            case 82: {
                if (this.mActionBar != null && !this.mActionBar.isShowing()) {
                    this.mActionBar.show();
                    return true;
                }
                return super.onKeyUp(keyCode, event);
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public void onUpdate() {
        SessionList sessions = this.mTermSessions;
        if (sessions == null) {
            return;
        }
        if (sessions.size() == 0) {
            this.mStopServiceOnFinish = true;
            this.finish();
        } else if (sessions.size() < this.mViewFlipper.getChildCount()) {
            for (int i = 0; i < this.mViewFlipper.getChildCount(); ++i) {
                EmulatorView v = (EmulatorView)this.mViewFlipper.getChildAt(i);
                if (sessions.contains(v.getTermSession())) continue;
                v.onPause();
                this.mViewFlipper.removeView((View)v);
                --i;
            }
        }
    }

    private boolean canPaste() {
        ClipboardManagerCompat clip = ClipboardManagerCompatFactory.getManager((Context)this.getApplicationContext());
        return clip.hasText();
    }

    private void doPreferences() {
        this.startActivity(new Intent((Context)this, TermPreferences.class));
    }

    private void doResetTerminal() {
        TermSession session = this.getCurrentTermSession();
        if (session != null) {
            session.reset();
        }
    }

    private void doEmailTranscript() {
        TermSession session = this.getCurrentTermSession();
        if (session != null) {
            String addr = "user@example.com";
            Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)("mailto:" + addr)));
            String subject = this.getString(R.string.email_transcript_subject);
            String title = session.getTitle();
            if (title != null) {
                subject = subject + " - " + title;
            }
            intent.putExtra("android.intent.extra.SUBJECT", subject);
            intent.putExtra("android.intent.extra.TEXT", session.getTranscriptText().trim());
            try {
                this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getString(R.string.email_transcript_chooser_title)));
            }
            catch (ActivityNotFoundException e) {
                Toast.makeText((Context)this, (int)R.string.email_transcript_no_email_activity_found, (int)1).show();
            }
        }
    }

    private void doCopyAll() {
        ClipboardManagerCompat clip = ClipboardManagerCompatFactory.getManager((Context)this.getApplicationContext());
        clip.setText((CharSequence)this.getCurrentTermSession().getTranscriptText().trim());
    }

    private void doPaste() {
        if (!this.canPaste()) {
            return;
        }
        ClipboardManagerCompat clip = ClipboardManagerCompatFactory.getManager((Context)this.getApplicationContext());
        CharSequence paste = clip.getText();
        this.getCurrentTermSession().write(paste.toString());
    }

    private void doSendControlKey() {
        this.getCurrentEmulatorView().sendControlKey();
    }

    private void doSendFnKey() {
        this.getCurrentEmulatorView().sendFnKey();
    }

    private void doDocumentKeys() {
        AlertDialog.Builder dialog = new AlertDialog.Builder((Context)this);
        Resources r = this.getResources();
        dialog.setTitle((CharSequence)r.getString(R.string.control_key_dialog_title));
        dialog.setMessage((CharSequence)(this.formatMessage(this.mSettings.getControlKeyId(), 7, r, R.array.control_keys_short_names, R.string.control_key_dialog_control_text, R.string.control_key_dialog_control_disabled_text, "CTRLKEY") + "\n\n" + this.formatMessage(this.mSettings.getFnKeyId(), 7, r, R.array.fn_keys_short_names, R.string.control_key_dialog_fn_text, R.string.control_key_dialog_fn_disabled_text, "FNKEY")));
        dialog.show();
    }

    private String formatMessage(int keyId, int disabledKeyId, Resources r, int arrayId, int enabledId, int disabledId, String regex) {
        if (keyId == disabledKeyId) {
            return r.getString(disabledId);
        }
        String[] keyNames = r.getStringArray(arrayId);
        String keyName = keyNames[keyId];
        String template = r.getString(enabledId);
        String result = template.replaceAll(regex, keyName);
        return result;
    }

    private void doToggleSoftKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        imm.toggleSoftInput(2, 0);
    }

    private void doToggleWakeLock() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        } else {
            this.mWakeLock.acquire();
        }
        ActivityCompat.invalidateOptionsMenu(this);
    }

    private void doToggleWifiLock() {
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        } else {
            this.mWifiLock.acquire();
        }
        ActivityCompat.invalidateOptionsMenu(this);
    }

    private void doToggleActionBar() {
        ActionBarCompat bar = this.mActionBar;
        if (bar == null) {
            return;
        }
        if (bar.isShowing()) {
            bar.hide();
        } else {
            bar.show();
        }
    }

    private void doUIToggle(int x, int y, int width, int height) {
        switch (this.mActionBarMode) {
            case 0: {
                if (AndroidCompat.SDK >= 11 && (this.mHaveFullHwKeyboard || y < height / 2)) {
                    this.openOptionsMenu();
                    return;
                }
                this.doToggleSoftKeyboard();
                break;
            }
            case 1: {
                if (this.mHaveFullHwKeyboard) break;
                this.doToggleSoftKeyboard();
                break;
            }
            case 2: {
                if (this.mHaveFullHwKeyboard || y < height / 2) {
                    this.doToggleActionBar();
                    return;
                }
                this.doToggleSoftKeyboard();
            }
        }
        this.getCurrentEmulatorView().requestFocus();
    }

    private void execURL(String link) {
        Uri webLink = Uri.parse((String)link);
        Intent openLink = new Intent("android.intent.action.VIEW", webLink);
        PackageManager pm = this.getPackageManager();
        List handlers = pm.queryIntentActivities(openLink, 0);
        if (handlers.size() > 0) {
            this.startActivity(openLink);
        }
    }

    private class EmulatorViewGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private EmulatorView view;

        public EmulatorViewGestureListener(EmulatorView view) {
            this.view = view;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (this.view.isMouseTrackingActive()) {
                return false;
            }
            String link = this.view.getURLat(e.getX(), e.getY());
            if (link != null) {
                Term.this.execURL(link);
            } else {
                Term.this.doUIToggle((int)e.getX(), (int)e.getY(), this.view.getVisibleWidth(), this.view.getVisibleHeight());
            }
            return true;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            float absVelocityY;
            float absVelocityX = Math.abs(velocityX);
            if ((double)absVelocityX > Math.max(1000.0, 2.0 * (double)(absVelocityY = Math.abs(velocityY)))) {
                if (velocityX > 0.0f) {
                    Term.this.mViewFlipper.showPrevious();
                } else {
                    Term.this.mViewFlipper.showNext();
                }
                return true;
            }
            return false;
        }
    }

    private class WindowListActionBarAdapter
    extends WindowListAdapter
    implements UpdateCallback {
        private static final int TextAppearance_Holo_Widget_ActionBar_Title = 16974098;

        public WindowListActionBarAdapter(SessionList sessions) {
            super(sessions);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView label = new TextView((Context)Term.this);
            String title = this.getSessionTitle(position, Term.this.getString(R.string.window_title, new Object[]{position + 1}));
            label.setText((CharSequence)title);
            if (AndroidCompat.SDK >= 13) {
                label.setTextAppearance((Context)Term.this, 16974098);
            } else {
                label.setTextAppearance((Context)Term.this, 16973892);
            }
            return label;
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return super.getView(position, convertView, parent);
        }

        @Override
        public void onUpdate() {
            this.notifyDataSetChanged();
            Term.this.mActionBar.setSelectedNavigationItem(Term.this.mViewFlipper.getDisplayedChild());
        }
    }
}

