/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.preference.PreferenceManager;
import android.util.Log;
import jackpal.androidterm.GenericTermSession;
import jackpal.androidterm.Term;
import jackpal.androidterm.TermService;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.util.SessionList;
import jackpal.androidterm.util.TermSettings;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class RemoteInterface
extends Activity {
    protected static final String PRIVACT_OPEN_NEW_WINDOW = "jackpal.androidterm.private.OPEN_NEW_WINDOW";
    protected static final String PRIVACT_SWITCH_WINDOW = "jackpal.androidterm.private.SWITCH_WINDOW";
    protected static final String PRIVEXTRA_TARGET_WINDOW = "jackpal.androidterm.private.target_window";
    protected static final String PRIVACT_ACTIVITY_ALIAS = "jackpal.androidterm.TermInternal";
    private TermSettings mSettings;
    private TermService mTermService;
    private Intent mTSIntent;
    private ServiceConnection mTSConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            TermService.TSBinder binder = (TermService.TSBinder)service;
            RemoteInterface.this.mTermService = binder.getService();
            RemoteInterface.this.handleIntent();
        }

        public void onServiceDisconnected(ComponentName className) {
            RemoteInterface.this.mTermService = null;
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        Intent TSIntent;
        super.onCreate(savedInstanceState);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.mSettings = new TermSettings(this.getResources(), prefs);
        this.mTSIntent = TSIntent = new Intent((Context)this, TermService.class);
        this.startService(TSIntent);
        if (!this.bindService(TSIntent, this.mTSConnection, 1)) {
            Log.e((String)"Term", (String)"bind to service failed!");
            this.finish();
        }
    }

    public void finish() {
        ServiceConnection conn = this.mTSConnection;
        if (conn != null) {
            SessionList sessions;
            this.unbindService(conn);
            TermService service = this.mTermService;
            if (service != null && ((sessions = service.getSessions()) == null || sessions.size() == 0)) {
                this.stopService(this.mTSIntent);
            }
            this.mTSConnection = null;
            this.mTermService = null;
        }
        super.finish();
    }

    protected TermService getTermService() {
        return this.mTermService;
    }

    protected void handleIntent() {
        TermService service = this.getTermService();
        if (service == null) {
            this.finish();
            return;
        }
        Intent myIntent = this.getIntent();
        String action = myIntent.getAction();
        if (action.equals("android.intent.action.SEND") && myIntent.hasExtra("android.intent.extra.STREAM")) {
            Object extraStream = myIntent.getExtras().get("android.intent.extra.STREAM");
            if (extraStream instanceof Uri) {
                String path = ((Uri)extraStream).getPath();
                File file = new File(path);
                String dirPath = file.isDirectory() ? path : file.getParent();
                this.openNewWindow("cd " + RemoteInterface.quoteForBash(dirPath));
            }
        } else {
            this.openNewWindow(null);
        }
        this.finish();
    }

    public static String quoteForBash(String s) {
        StringBuilder builder = new StringBuilder();
        String specialChars = "\"\\$`!";
        builder.append('\"');
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (specialChars.indexOf(c) >= 0) {
                builder.append('\\');
            }
            builder.append(c);
        }
        builder.append('\"');
        return builder.toString();
    }

    protected String openNewWindow(String iInitialCommand) {
        TermService service = this.getTermService();
        String initialCommand = this.mSettings.getInitialCommand();
        if (iInitialCommand != null) {
            initialCommand = initialCommand != null ? initialCommand + "\r" + iInitialCommand : iInitialCommand;
        }
        try {
            TermSession session = Term.createTermSession((Context)this, this.mSettings, initialCommand);
            session.setFinishCallback((TermSession.FinishCallback)service);
            service.getSessions().add(session);
            String handle = UUID.randomUUID().toString();
            ((GenericTermSession)session).setHandle(handle);
            Intent intent = new Intent(PRIVACT_OPEN_NEW_WINDOW);
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            this.startActivity(intent);
            return handle;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String appendToWindow(String handle, String iInitialCommand) {
        int index;
        TermService service = this.getTermService();
        SessionList sessions = service.getSessions();
        GenericTermSession target = null;
        for (index = 0; index < sessions.size(); ++index) {
            GenericTermSession session = (GenericTermSession)((Object)sessions.get(index));
            String h = session.getHandle();
            if (h == null || !h.equals(handle)) continue;
            target = session;
            break;
        }
        if (target == null) {
            return this.openNewWindow(iInitialCommand);
        }
        if (iInitialCommand != null) {
            target.write(iInitialCommand);
            target.write(13);
        }
        Intent intent = new Intent(PRIVACT_SWITCH_WINDOW);
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addFlags(0x10000000);
        intent.putExtra(PRIVEXTRA_TARGET_WINDOW, index);
        this.startActivity(intent);
        return handle;
    }
}

