/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import jackpal.androidterm.Exec;
import jackpal.androidterm.FdHelperHoneycomb;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.UpdateCallback;
import jackpal.androidterm.util.TermSettings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;

class GenericTermSession
extends TermSession {
    private static final boolean VTTEST_MODE = false;
    private static Field descriptorField;
    private final long createdAt;
    private String mHandle;
    final ParcelFileDescriptor mTermFd;
    TermSettings mSettings;
    public static final int PROCESS_EXIT_FINISHES_SESSION = 0;
    public static final int PROCESS_EXIT_DISPLAYS_MESSAGE = 1;
    private String mProcessExitMessage;
    private UpdateCallback mUTF8ModeNotify = new UpdateCallback(){

        public void onUpdate() {
            GenericTermSession.this.setPtyUTF8Mode(GenericTermSession.this.getUTF8Mode());
        }
    };

    GenericTermSession(ParcelFileDescriptor mTermFd, TermSettings settings, boolean exitOnEOF) {
        super(exitOnEOF);
        this.mTermFd = mTermFd;
        this.createdAt = System.currentTimeMillis();
        this.updatePrefs(settings);
    }

    public void updatePrefs(TermSettings settings) {
        this.mSettings = settings;
        this.setColorScheme(new ColorScheme(settings.getColorScheme()));
        this.setDefaultUTF8Mode(settings.defaultToUTF8Mode());
    }

    public void initializeEmulator(int columns, int rows) {
        super.initializeEmulator(columns, rows);
        this.setPtyUTF8Mode(this.getUTF8Mode());
        this.setUTF8ModeUpdateCallback(this.mUTF8ModeNotify);
    }

    public void updateSize(int columns, int rows) {
        this.setPtyWindowSize(rows, columns, 0, 0);
        super.updateSize(columns, rows);
    }

    public void setProcessExitMessage(String message) {
        this.mProcessExitMessage = message;
    }

    protected void onProcessExit() {
        if (this.mSettings.closeWindowOnProcessExit()) {
            this.finish();
        } else if (this.mProcessExitMessage != null) {
            try {
                byte[] msg = ("\r\n[" + this.mProcessExitMessage + "]").getBytes("UTF-8");
                this.appendToEmulator(msg, 0, msg.length);
                this.notifyUpdate();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public void finish() {
        try {
            this.mTermFd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finish();
    }

    public String getTitle(String defaultTitle) {
        String title = this.getTitle();
        if (title != null && title.length() > 0) {
            return title;
        }
        return defaultTitle;
    }

    public void setHandle(String handle) {
        if (this.mHandle != null) {
            throw new IllegalStateException("Cannot change handle once set");
        }
        this.mHandle = handle;
    }

    public String getHandle() {
        return this.mHandle;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '(' + this.createdAt + ',' + this.mHandle + ')';
    }

    void setPtyWindowSize(int row, int col, int xpixel, int ypixel) {
        block3: {
            if (!this.mTermFd.getFileDescriptor().valid()) {
                return;
            }
            try {
                Exec.setPtyWindowSizeInternal(GenericTermSession.getIntFd(this.mTermFd), row, col, xpixel, ypixel);
            }
            catch (IOException e) {
                Log.e((String)"exec", (String)("Failed to set window size: " + e.getMessage()));
                if (!this.isFailFast()) break block3;
                throw new IllegalStateException(e);
            }
        }
    }

    void setPtyUTF8Mode(boolean utf8Mode) {
        block3: {
            if (!this.mTermFd.getFileDescriptor().valid()) {
                return;
            }
            try {
                Exec.setPtyUTF8ModeInternal(GenericTermSession.getIntFd(this.mTermFd), utf8Mode);
            }
            catch (IOException e) {
                Log.e((String)"exec", (String)("Failed to set UTF mode: " + e.getMessage()));
                if (!this.isFailFast()) break block3;
                throw new IllegalStateException(e);
            }
        }
    }

    boolean isFailFast() {
        return false;
    }

    private static void cacheDescField() throws NoSuchFieldException {
        if (descriptorField != null) {
            return;
        }
        descriptorField = FileDescriptor.class.getDeclaredField("descriptor");
        descriptorField.setAccessible(true);
    }

    private static int getIntFd(ParcelFileDescriptor parcelFd) throws IOException {
        if (Build.VERSION.SDK_INT >= 12) {
            return FdHelperHoneycomb.getFd((ParcelFileDescriptor)parcelFd);
        }
        try {
            GenericTermSession.cacheDescField();
            return descriptorField.getInt(parcelFd.getFileDescriptor());
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain file descriptor on this OS version: " + e.getMessage());
        }
    }
}

