/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import jackpal.androidterm.GenericTermSession;
import jackpal.androidterm.util.TermSettings;
import java.io.InputStream;
import java.io.OutputStream;

class BoundSession
extends GenericTermSession {
    private final String issuerTitle;
    private boolean fullyInitialized;

    BoundSession(ParcelFileDescriptor ptmxFd, TermSettings settings, String issuerTitle) {
        super(ptmxFd, settings, true);
        this.issuerTitle = issuerTitle;
        this.setTermIn((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(ptmxFd));
        this.setTermOut((OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream(ptmxFd));
    }

    public String getTitle() {
        String extraTitle = super.getTitle();
        return TextUtils.isEmpty((CharSequence)extraTitle) ? this.issuerTitle : this.issuerTitle + " \u2014 " + extraTitle;
    }

    @Override
    public void initializeEmulator(int columns, int rows) {
        super.initializeEmulator(columns, rows);
        this.fullyInitialized = true;
    }

    @Override
    boolean isFailFast() {
        return !this.fullyInitialized;
    }
}

