/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import jackpal.androidterm.compat.Base64;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class ShortcutEncryption {
    public static final String ENC_ALGORITHM = "AES";
    public static final String ENC_SYSTEM = "AES/CBC/PKCS5Padding";
    public static final int ENC_BLOCKSIZE = 16;
    public static final String MAC_ALGORITHM = "HmacSHA256";
    public static final int KEYLEN = 128;
    public static final int BASE64_DFLAGS = 0;
    public static final int BASE64_EFLAGS = 3;
    private static final String SHORTCUT_KEYS_PREF = "shortcut_keys";
    private static final Pattern COLON = Pattern.compile(":");

    public static Keys getKeys(Context ctx) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        String keyEnc = prefs.getString(SHORTCUT_KEYS_PREF, null);
        if (keyEnc == null) {
            return null;
        }
        try {
            return Keys.decode(keyEnc);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void saveKeys(Context ctx, Keys keys) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString(SHORTCUT_KEYS_PREF, keys.encode());
        edit.commit();
    }

    public static Keys generateKeys() throws GeneralSecurityException {
        KeyGenerator gen = KeyGenerator.getInstance(ENC_ALGORITHM);
        gen.init(128);
        SecretKey encKey = gen.generateKey();
        gen = KeyGenerator.getInstance(MAC_ALGORITHM);
        gen.init(128);
        SecretKey macKey = gen.generateKey();
        return new Keys(encKey, macKey);
    }

    public static String decrypt(String encrypted, Keys keys) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENC_SYSTEM);
        String[] data = COLON.split(encrypted);
        if (data.length != 3) {
            throw new GeneralSecurityException("Invalid encrypted data!");
        }
        String mac = data[0];
        String iv = data[1];
        String cipherText = data[2];
        String dataToAuth = iv + ":" + cipherText;
        if (!ShortcutEncryption.computeMac(dataToAuth, keys.getMacKey()).equals(mac)) {
            throw new GeneralSecurityException("Incorrect MAC!");
        }
        byte[] ivBytes = ShortcutEncryption.decodeBase64(iv);
        cipher.init(2, (Key)keys.getEncKey(), new IvParameterSpec(ivBytes));
        byte[] bytes = cipher.doFinal(ShortcutEncryption.decodeBase64(cipherText));
        CharsetDecoder decoder = Charset.defaultCharset().newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer out = CharBuffer.allocate(bytes.length);
        CoderResult result = decoder.decode(ByteBuffer.wrap(bytes), out, true);
        if (result.isError()) {
            throw new GeneralSecurityException("Corrupt decrypted data!");
        }
        decoder.flush(out);
        return out.flip().toString();
    }

    public static String encrypt(String data, Keys keys) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(ENC_SYSTEM);
        SecureRandom rng = new SecureRandom();
        byte[] ivBytes = new byte[16];
        rng.nextBytes(ivBytes);
        String iv = ShortcutEncryption.encodeToBase64(ivBytes);
        cipher.init(1, (Key)keys.getEncKey(), new IvParameterSpec(ivBytes));
        byte[] bytes = data.getBytes();
        String cipherText = ShortcutEncryption.encodeToBase64(cipher.doFinal(bytes));
        String dataToAuth = iv + ":" + cipherText;
        String mac = ShortcutEncryption.computeMac(dataToAuth, keys.getMacKey());
        return mac + ":" + dataToAuth;
    }

    private static String computeMac(String data, SecretKey key) throws GeneralSecurityException {
        Mac mac = Mac.getInstance(MAC_ALGORITHM);
        mac.init(key);
        byte[] macBytes = mac.doFinal(data.getBytes());
        return ShortcutEncryption.encodeToBase64(macBytes);
    }

    private static String encodeToBase64(byte[] data) {
        return Base64.encodeToString(data, 3);
    }

    private static byte[] decodeBase64(String data) {
        return Base64.decode(data, 0);
    }

    private ShortcutEncryption() {
        throw new UnsupportedOperationException();
    }

    public static final class Keys {
        private final SecretKey encKey;
        private final SecretKey macKey;

        public Keys(SecretKey encKey, SecretKey macKey) {
            this.encKey = encKey;
            this.macKey = macKey;
        }

        public SecretKey getEncKey() {
            return this.encKey;
        }

        public SecretKey getMacKey() {
            return this.macKey;
        }

        public String encode() {
            return ShortcutEncryption.encodeToBase64(this.encKey.getEncoded()) + ":" + ShortcutEncryption.encodeToBase64(this.macKey.getEncoded());
        }

        public static Keys decode(String encodedKeys) {
            String[] keys = COLON.split(encodedKeys);
            if (keys.length != 2) {
                throw new IllegalArgumentException("Invalid encoded keys!");
            }
            SecretKeySpec encKey = new SecretKeySpec(ShortcutEncryption.decodeBase64(keys[0]), ShortcutEncryption.ENC_ALGORITHM);
            SecretKeySpec macKey = new SecretKeySpec(ShortcutEncryption.decodeBase64(keys[1]), ShortcutEncryption.MAC_ALGORITHM);
            return new Keys(encKey, macKey);
        }
    }
}

