/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.shortcuts;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.SeekBar;
import android.widget.TextView;
import jackpal.androidterm.R;
import jackpal.androidterm.compat.AlertDialogCompat;
import jackpal.androidterm.shortcuts.TextIcon;

public class ColorValue
implements CompoundButton.OnCheckedChangeListener {
    private final Context context;
    private EditText value;
    private final int[] color = new int[]{255, 0, 0, 0};
    private boolean started = false;
    private AlertDialog.Builder builder;
    private boolean barLock = false;
    private final boolean[] locks = new boolean[]{false, false, false, false};
    private final int FP = -1;
    private final int WC = -2;
    private final ImageView imgview;
    private final String[] result;
    private String imgtext = "";

    public ColorValue(Context context, ImageView imgview, String[] result) {
        this.context = context;
        this.imgtext = result[0];
        this.imgview = imgview;
        this.result = result;
        this.colorValue();
    }

    public void colorValue() {
        int arraySizes = 4;
        this.builder = AlertDialogCompat.newInstanceBuilder(this.context, AlertDialogCompat.THEME_HOLO_DARK);
        LinearLayout lv = new LinearLayout(this.context);
        lv.setOrientation(1);
        String[] lab = new String[]{this.context.getString(R.string.colorvalue_letter_alpha) + " ", this.context.getString(R.string.colorvalue_letter_red) + " ", this.context.getString(R.string.colorvalue_letter_green) + " ", this.context.getString(R.string.colorvalue_letter_blue) + " "};
        int[] clr = new int[]{-1, -65536, -16711936, -16776961};
        int n = (Integer)this.imgview.getTag();
        for (int i = 0; i < 4; ++i) {
            this.color[i] = n >> 24 - i * 8 & 0xFF;
        }
        TextView lt = new TextView(this.context);
        lt.setText((CharSequence)this.context.getString(R.string.colorvalue_label_lock_button_column));
        lt.setPadding(lt.getPaddingLeft(), lt.getPaddingTop(), 5, lt.getPaddingBottom());
        lt.setGravity(5);
        this.value = new EditText(this.context);
        this.value.setText((CharSequence)this.imgtext);
        this.value.setSingleLine(false);
        this.value.setGravity(17);
        this.value.setTextColor(((Integer)this.imgview.getTag()).intValue());
        this.value.setBackgroundColor(-16746599);
        LinearLayout vh = new LinearLayout(this.context);
        vh.setOrientation(0);
        vh.setGravity(1);
        vh.addView((View)this.value);
        this.value.setHint((CharSequence)this.context.getString(R.string.colorvalue_icon_text_entry_hint));
        lv.addView((View)vh);
        lv.addView((View)lt);
        final SeekBar[] sb = new SeekBar[5];
        CheckBox[] lk = new CheckBox[4];
        final TextView[] hexWindow = new TextView[4];
        for (int i = 0; i < 4; ++i) {
            LinearLayout lh = new LinearLayout(this.context);
            lh.setGravity(16);
            TextView tv = new TextView(this.context);
            tv.setTypeface(Typeface.MONOSPACE);
            tv.setText((CharSequence)lab[i]);
            tv.setTextColor(clr[i]);
            sb[i] = new SeekBar(this.context);
            sb[i].setMax(255);
            sb[i].setProgress(this.color[i]);
            sb[i].setSecondaryProgress(this.color[i]);
            sb[i].setTag((Object)i);
            sb[i].setBackgroundColor(0xFF000000 | this.color[i] << 24 - i * 8);
            sb[i].setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
            sb[i].setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    this.doProgressChanged(seekBar, progress, fromUser);
                }

                private void doProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                    if (fromUser && ColorValue.this.started) {
                        int end;
                        int start;
                        int me = (Integer)seekBar.getTag();
                        int k = ColorValue.this.color[0] << 24 | ColorValue.this.color[1] << 16 | ColorValue.this.color[2] << 8 | ColorValue.this.color[3];
                        ColorValue.this.value.setTextColor(k);
                        if (ColorValue.this.barLock && ColorValue.this.locks[me]) {
                            start = 0;
                            end = 3;
                        } else {
                            start = end = ((Integer)seekBar.getTag()).intValue();
                        }
                        for (int i = start; i <= end; ++i) {
                            if (i != me && (!ColorValue.this.barLock || !ColorValue.this.locks[i])) continue;
                            ((ColorValue)ColorValue.this).color[i] = progress;
                            ColorValue.this.toHexWindow(hexWindow[i], ColorValue.this.color[i]);
                            sb[i].setBackgroundColor(0xFF000000 | progress << 24 - i * 8);
                            sb[i].setProgress(progress);
                        }
                    }
                }

                public void onStartTrackingTouch(SeekBar seekBar) {
                    this.doProgressChanged(seekBar, seekBar.getProgress(), true);
                }

                public void onStopTrackingTouch(SeekBar seekBar) {
                    this.doProgressChanged(seekBar, seekBar.getProgress(), true);
                }
            });
            lk[i] = new CheckBox(this.context);
            lk[i].setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
            lk[i].setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
            lk[i].setTag((Object)i);
            lh.addView((View)tv);
            lh.addView((View)sb[i]);
            lh.addView((View)lk[i]);
            lv.addView((View)lh, -1, -2);
        }
        LinearLayout lh = new LinearLayout(this.context);
        lh.setGravity(17);
        for (int i = 0; i < 4; ++i) {
            hexWindow[i] = new TextView(this.context);
            this.toHexWindow(hexWindow[i], this.color[i]);
            lh.addView((View)hexWindow[i]);
        }
        lv.addView((View)lh);
        ScrollView sv = new ScrollView(this.context);
        sv.addView((View)lv);
        this.builder.setView((View)sv);
        DialogInterface.OnClickListener ocl = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ColorValue.this.buttonHit(which, ColorValue.this.color[0] << 24 | ColorValue.this.color[1] << 16 | ColorValue.this.color[2] << 8 | ColorValue.this.color[3]);
            }
        };
        String Title = this.context.getString(R.string.addshortcut_make_text_icon);
        this.builder.setTitle((CharSequence)Title);
        this.builder.setPositiveButton(17039379, ocl);
        this.builder.setNegativeButton(0x1040000, ocl);
        this.builder.show();
        this.started = true;
    }

    public void toHexWindow(TextView tv, int k) {
        String HEX = "0123456789ABCDEF";
        String s = "";
        int n = 8;
        k = (int)((long)k & 0xFFL);
        n -= 4;
        while (n >= 0) {
            s = s + HEX.charAt(k >> n & 0xF);
            n -= 4;
        }
        tv.setText((CharSequence)s);
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int view = (Integer)buttonView.getTag();
        this.locks[view] = isChecked;
        this.barLock = false;
        for (int i = 0; i < this.locks.length; ++i) {
            if (!this.locks[i]) continue;
            this.barLock = true;
        }
    }

    private void buttonHit(int hit, int color2) {
        switch (hit) {
            case -2: {
                return;
            }
            case -1: {
                this.result[1] = this.imgtext = this.value.getText().toString();
                this.imgview.setTag((Object)color2);
                if (!this.imgtext.equals("")) {
                    this.imgview.setImageBitmap(TextIcon.getTextIcon(this.imgtext, color2, 96, 96));
                }
                return;
            }
        }
    }
}

