/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import jackpal.androidterm.GenericTermSession;
import jackpal.androidterm.R;
import jackpal.androidterm.emulatorview.TermSession;
import jackpal.androidterm.emulatorview.UpdateCallback;
import jackpal.androidterm.util.SessionList;

public class WindowListAdapter
extends BaseAdapter
implements UpdateCallback {
    private SessionList mSessions;

    public WindowListAdapter(SessionList sessions) {
        this.setSessions(sessions);
    }

    public void setSessions(SessionList sessions) {
        this.mSessions = sessions;
        if (sessions != null) {
            sessions.addCallback(this);
            sessions.addTitleChangedListener(this);
        } else {
            this.onUpdate();
        }
    }

    public int getCount() {
        if (this.mSessions != null) {
            return this.mSessions.size();
        }
        return 0;
    }

    public Object getItem(int position) {
        return this.mSessions.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    protected String getSessionTitle(int position, String defaultTitle) {
        TermSession session = (TermSession)this.mSessions.get(position);
        if (session != null && session instanceof GenericTermSession) {
            return ((GenericTermSession)session).getTitle(defaultTitle);
        }
        return defaultTitle;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Activity act = WindowListAdapter.findActivityFromContext(parent.getContext());
        View child = act.getLayoutInflater().inflate(R.layout.window_list_item, parent, false);
        View close = child.findViewById(R.id.window_list_close);
        TextView label = (TextView)child.findViewById(R.id.window_list_label);
        String defaultTitle = act.getString(R.string.window_title, new Object[]{position + 1});
        label.setText((CharSequence)this.getSessionTitle(position, defaultTitle));
        final SessionList sessions = this.mSessions;
        final int closePosition = position;
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TermSession session = sessions.remove(closePosition);
                if (session != null) {
                    session.finish();
                    WindowListAdapter.this.notifyDataSetChanged();
                }
            }
        });
        return child;
    }

    public void onUpdate() {
        this.notifyDataSetChanged();
    }

    private static Activity findActivityFromContext(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            ContextWrapper cw = (ContextWrapper)context;
            return WindowListAdapter.findActivityFromContext(cw.getBaseContext());
        }
        return null;
    }
}

