/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import jackpal.androidterm.GenericTermSession;
import jackpal.androidterm.TermExec;
import jackpal.androidterm.compat.FileCompat;
import jackpal.androidterm.util.TermSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ShellTermSession
extends GenericTermSession {
    private int mProcId;
    private Thread mWatcherThread;
    private String mInitialCommand;
    private static final int PROCESS_EXITED = 1;
    private Handler mMsgHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (!ShellTermSession.this.isRunning()) {
                return;
            }
            if (msg.what == 1) {
                ShellTermSession.this.onProcessExit((Integer)msg.obj);
            }
        }
    };

    public ShellTermSession(TermSettings settings, String initialCommand) throws IOException {
        super(ParcelFileDescriptor.open((File)new File("/dev/ptmx"), (int)0x30000000), settings, false);
        this.initializeSession();
        this.setTermOut((OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream(this.mTermFd));
        this.setTermIn((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.mTermFd));
        this.mInitialCommand = initialCommand;
        this.mWatcherThread = new Thread(){

            @Override
            public void run() {
                Log.i((String)"Term", (String)("waiting for: " + ShellTermSession.this.mProcId));
                int result = TermExec.waitFor((int)ShellTermSession.this.mProcId);
                Log.i((String)"Term", (String)("Subprocess exited: " + result));
                ShellTermSession.this.mMsgHandler.sendMessage(ShellTermSession.this.mMsgHandler.obtainMessage(1, (Object)result));
            }
        };
        this.mWatcherThread.setName("Process watcher");
    }

    private void initializeSession() throws IOException {
        TermSettings settings = this.mSettings;
        String path = System.getenv("PATH");
        if (settings.doPathExtensions()) {
            String prependPath;
            String appendPath = settings.getAppendPath();
            if (appendPath != null && appendPath.length() > 0) {
                path = path + ":" + appendPath;
            }
            if (settings.allowPathPrepend() && (prependPath = settings.getPrependPath()) != null && prependPath.length() > 0) {
                path = prependPath + ":" + path;
            }
        }
        if (settings.verifyPath()) {
            path = this.checkPath(path);
        }
        String[] env = new String[]{"TERM=" + settings.getTermType(), "PATH=" + path, "HOME=" + settings.getHomePath()};
        this.mProcId = this.createSubprocess(settings.getShell(), env);
    }

    private String checkPath(String path) {
        String[] dirs = path.split(":");
        StringBuilder checkedPath = new StringBuilder(path.length());
        for (String dirname : dirs) {
            File dir = new File(dirname);
            if (!dir.isDirectory() || !FileCompat.canExecute(dir)) continue;
            checkedPath.append(dirname);
            checkedPath.append(":");
        }
        return checkedPath.substring(0, checkedPath.length() - 1);
    }

    @Override
    public void initializeEmulator(int columns, int rows) {
        super.initializeEmulator(columns, rows);
        this.mWatcherThread.start();
        this.sendInitialCommand(this.mInitialCommand);
    }

    private void sendInitialCommand(String initialCommand) {
        if (initialCommand.length() > 0) {
            this.write(initialCommand + '\r');
        }
    }

    private int createSubprocess(String shell, String[] env) throws IOException {
        String[] args;
        String arg0;
        ArrayList<String> argList = this.parse(shell);
        try {
            arg0 = argList.get(0);
            File file = new File(arg0);
            if (!file.exists()) {
                Log.e((String)"Term", (String)("Shell " + arg0 + " not found!"));
                throw new FileNotFoundException(arg0);
            }
            if (!FileCompat.canExecute(file)) {
                Log.e((String)"Term", (String)("Shell " + arg0 + " not executable!"));
                throw new FileNotFoundException(arg0);
            }
            args = argList.toArray(new String[1]);
        }
        catch (Exception e) {
            argList = this.parse(this.mSettings.getFailsafeShell());
            arg0 = argList.get(0);
            args = argList.toArray(new String[1]);
        }
        return TermExec.createSubprocess((ParcelFileDescriptor)this.mTermFd, (String)arg0, (String[])args, (String[])env);
    }

    private ArrayList<String> parse(String cmd) {
        boolean PLAIN = false;
        boolean WHITESPACE = true;
        int INQUOTE = 2;
        int state = 1;
        ArrayList<String> result = new ArrayList<String>();
        int cmdLen = cmd.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < cmdLen; ++i) {
            char c = cmd.charAt(i);
            if (state == 0) {
                if (Character.isWhitespace(c)) {
                    result.add(builder.toString());
                    builder.delete(0, builder.length());
                    state = 1;
                    continue;
                }
                if (c == '\"') {
                    state = 2;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (state == 1) {
                if (Character.isWhitespace(c)) continue;
                if (c == '\"') {
                    state = 2;
                    continue;
                }
                state = 0;
                builder.append(c);
                continue;
            }
            if (state != 2) continue;
            if (c == '\\') {
                if (i + 1 >= cmdLen) continue;
                builder.append(cmd.charAt(++i));
                continue;
            }
            if (c == '\"') {
                state = 0;
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        return result;
    }

    private void onProcessExit(int result) {
        this.onProcessExit();
    }

    @Override
    public void finish() {
        this.hangupProcessGroup();
        super.finish();
    }

    void hangupProcessGroup() {
        TermExec.sendSignal((int)(-this.mProcId), (int)1);
    }
}

