/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import jackpal.androidterm.RemoteInterface;
import jackpal.androidterm.TermService;
import jackpal.androidterm.util.ShortcutEncryption;
import java.security.GeneralSecurityException;

public final class RunShortcut
extends RemoteInterface {
    public static final String ACTION_RUN_SHORTCUT = "jackpal.androidterm.RUN_SHORTCUT";
    public static final String EXTRA_WINDOW_HANDLE = "jackpal.androidterm.window_handle";
    public static final String EXTRA_SHORTCUT_COMMAND = "jackpal.androidterm.iShortcutCommand";

    @Override
    protected void handleIntent() {
        TermService service = this.getTermService();
        if (service == null) {
            this.finish();
            return;
        }
        Intent myIntent = this.getIntent();
        String action = myIntent.getAction();
        if (action.equals(ACTION_RUN_SHORTCUT)) {
            String command;
            String encCommand = myIntent.getStringExtra(EXTRA_SHORTCUT_COMMAND);
            if (encCommand == null) {
                Log.e((String)"Term", (String)"No command provided in shortcut!");
                this.finish();
                return;
            }
            ShortcutEncryption.Keys keys = ShortcutEncryption.getKeys((Context)this);
            if (keys == null) {
                Log.e((String)"Term", (String)"No shortcut encryption keys found!");
                this.finish();
                return;
            }
            try {
                command = ShortcutEncryption.decrypt(encCommand, keys);
            }
            catch (GeneralSecurityException e) {
                Log.e((String)"Term", (String)("Invalid shortcut: " + e.toString()));
                this.finish();
                return;
            }
            String handle = myIntent.getStringExtra(EXTRA_WINDOW_HANDLE);
            handle = handle != null ? this.appendToWindow(handle, command) : this.openNewWindow(command);
            Intent result = new Intent();
            result.putExtra(EXTRA_WINDOW_HANDLE, handle);
            this.setResult(-1, result);
        }
        this.finish();
    }
}

