/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm;

import android.content.Intent;
import android.net.Uri;
import jackpal.androidterm.RemoteInterface;
import jackpal.androidterm.TermService;

public final class RunScript
extends RemoteInterface {
    private static final String ACTION_RUN_SCRIPT = "jackpal.androidterm.RUN_SCRIPT";
    private static final String EXTRA_WINDOW_HANDLE = "jackpal.androidterm.window_handle";
    private static final String EXTRA_INITIAL_COMMAND = "jackpal.androidterm.iInitialCommand";

    @Override
    protected void handleIntent() {
        TermService service = this.getTermService();
        if (service == null) {
            this.finish();
            return;
        }
        Intent myIntent = this.getIntent();
        String action = myIntent.getAction();
        if (action.equals(ACTION_RUN_SCRIPT)) {
            String s;
            String handle = myIntent.getStringExtra(EXTRA_WINDOW_HANDLE);
            String command = null;
            Uri uri = myIntent.getData();
            if (uri != null && (s = uri.getScheme()) != null && s.toLowerCase().equals("file")) {
                command = uri.getPath();
                if (command == null) {
                    command = "";
                }
                if (!command.equals("")) {
                    command = RunScript.quoteForBash(command);
                }
                if (null != (s = uri.getFragment())) {
                    command = command + " " + s;
                }
            }
            if (command == null) {
                command = myIntent.getStringExtra(EXTRA_INITIAL_COMMAND);
            }
            handle = handle != null ? this.appendToWindow(handle, command) : this.openNewWindow(command);
            Intent result = new Intent();
            result.putExtra(EXTRA_WINDOW_HANDLE, handle);
            this.setResult(-1, result);
            this.finish();
        } else {
            super.handleIntent();
        }
    }
}

