/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview.compat;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import jackpal.androidterm.emulatorview.compat.ClipboardManagerCompat;

@SuppressLint(value={"NewApi"})
public class ClipboardManagerCompatV11
implements ClipboardManagerCompat {
    private final ClipboardManager clip;

    public ClipboardManagerCompatV11(Context context) {
        this.clip = (ClipboardManager)context.getApplicationContext().getSystemService("clipboard");
    }

    @Override
    public CharSequence getText() {
        ClipData.Item item = this.clip.getPrimaryClip().getItemAt(0);
        return item.getText();
    }

    @Override
    public boolean hasText() {
        return this.clip.hasPrimaryClip() && this.clip.getPrimaryClipDescription().hasMimeType("text/plain");
    }

    @Override
    public void setText(CharSequence text) {
        ClipData clipData = ClipData.newPlainText((CharSequence)"simple text", (CharSequence)text);
        this.clip.setPrimaryClip(clipData);
    }
}

