/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.util.Log;
import jackpal.androidterm.emulatorview.FullUnicodeLine;
import jackpal.androidterm.emulatorview.StyleRow;
import jackpal.androidterm.emulatorview.compat.AndroidCharacterCompat;
import jackpal.androidterm.emulatorview.compat.AndroidCompat;

class UnicodeTranscript {
    private static final String TAG = "UnicodeTranscript";
    private Object[] mLines;
    private StyleRow[] mColor;
    private boolean[] mLineWrap;
    private int mTotalRows;
    private int mScreenRows;
    private int mColumns;
    private int mActiveTranscriptRows = 0;
    private int mDefaultStyle = 0;
    private int mScreenFirstRow = 0;
    private char[] tmpLine;
    private StyleRow tmpColor;
    static final int HANGUL_CONJOINING_MIN_SDK = 16;

    public UnicodeTranscript(int columns, int totalRows, int screenRows, int defaultStyle) {
        this.mColumns = columns;
        this.mTotalRows = totalRows;
        this.mScreenRows = screenRows;
        this.mLines = new Object[totalRows];
        this.mColor = new StyleRow[totalRows];
        this.mLineWrap = new boolean[totalRows];
        this.tmpColor = new StyleRow(defaultStyle, this.mColumns);
        this.mDefaultStyle = defaultStyle;
    }

    public void setDefaultStyle(int defaultStyle) {
        this.mDefaultStyle = defaultStyle;
    }

    public int getDefaultStyle() {
        return this.mDefaultStyle;
    }

    public int getActiveTranscriptRows() {
        return this.mActiveTranscriptRows;
    }

    public int getActiveRows() {
        return this.mActiveTranscriptRows + this.mScreenRows;
    }

    private int externalToInternalRow(int extRow) {
        if (extRow < -this.mActiveTranscriptRows || extRow > this.mScreenRows) {
            String errorMessage = "externalToInternalRow " + extRow + " " + this.mScreenRows + " " + this.mActiveTranscriptRows;
            Log.e((String)TAG, (String)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (extRow >= 0) {
            return (this.mScreenFirstRow + extRow) % this.mTotalRows;
        }
        if (-extRow > this.mScreenFirstRow) {
            return this.mTotalRows + this.mScreenFirstRow + extRow;
        }
        return this.mScreenFirstRow + extRow;
    }

    public void setLineWrap(int row) {
        this.mLineWrap[this.externalToInternalRow((int)row)] = true;
    }

    public boolean getLineWrap(int row) {
        return this.mLineWrap[this.externalToInternalRow(row)];
    }

    public boolean resize(int newColumns, int newRows, int[] cursor) {
        if (newColumns != this.mColumns || newRows > this.mTotalRows) {
            return false;
        }
        int screenRows = this.mScreenRows;
        int shift = screenRows - newRows;
        int activeTranscriptRows = this.mActiveTranscriptRows;
        if (shift < -activeTranscriptRows) {
            Object[] lines = this.mLines;
            StyleRow[] color = this.mColor;
            boolean[] lineWrap = this.mLineWrap;
            int screenFirstRow = this.mScreenFirstRow;
            int totalRows = this.mTotalRows;
            for (int i = 0; i < activeTranscriptRows - shift; ++i) {
                int index = (screenFirstRow + screenRows + i) % totalRows;
                lines[index] = null;
                color[index] = null;
                lineWrap[index] = false;
            }
            shift = -activeTranscriptRows;
        } else if (shift > 0 && cursor != null && cursor[1] != screenRows - 1) {
            Object[] lines = this.mLines;
            for (int i = screenRows - 1; i > cursor[1]; --i) {
                int j;
                int index = this.externalToInternalRow(i);
                if (lines[index] == null) {
                    if (--shift != 0) continue;
                    break;
                }
                char[] line = lines[index] instanceof char[] ? (char[])lines[index] : ((FullUnicodeLine)lines[index]).getLine();
                int len = line.length;
                for (j = 0; j < len; ++j) {
                    if (line[j] == '\u0000') {
                        j = len;
                        break;
                    }
                    if (line[j] != ' ') break;
                }
                if (j != len || --shift == 0) break;
            }
        }
        if (shift > 0 || shift < 0 && this.mScreenFirstRow >= -shift) {
            this.mScreenFirstRow = (this.mScreenFirstRow + shift) % this.mTotalRows;
        } else if (shift < 0) {
            this.mScreenFirstRow = this.mTotalRows + this.mScreenFirstRow + shift;
        }
        this.mActiveTranscriptRows = this.mActiveTranscriptRows + shift < 0 ? 0 : (this.mActiveTranscriptRows += shift);
        if (cursor != null) {
            cursor[1] = cursor[1] - shift;
        }
        this.mScreenRows = newRows;
        return true;
    }

    private void blockCopyLines(int src, int len, int shift) {
        int totalRows = this.mTotalRows;
        int dst = src + shift >= 0 ? (src + shift) % totalRows : totalRows + src + shift;
        if (src + len <= totalRows && dst + len <= totalRows) {
            System.arraycopy(this.mLines, src, this.mLines, dst, len);
            System.arraycopy(this.mColor, src, this.mColor, dst, len);
            System.arraycopy(this.mLineWrap, src, this.mLineWrap, dst, len);
            return;
        }
        if (shift < 0) {
            for (int i = 0; i < len; ++i) {
                this.mLines[(dst + i) % totalRows] = this.mLines[(src + i) % totalRows];
                this.mColor[(dst + i) % totalRows] = this.mColor[(src + i) % totalRows];
                this.mLineWrap[(dst + i) % totalRows] = this.mLineWrap[(src + i) % totalRows];
            }
        } else {
            for (int i = len - 1; i >= 0; --i) {
                this.mLines[(dst + i) % totalRows] = this.mLines[(src + i) % totalRows];
                this.mColor[(dst + i) % totalRows] = this.mColor[(src + i) % totalRows];
                this.mLineWrap[(dst + i) % totalRows] = this.mLineWrap[(src + i) % totalRows];
            }
        }
    }

    public void scroll(int topMargin, int bottomMargin, int style) {
        if (topMargin > bottomMargin - 1) {
            throw new IllegalArgumentException();
        }
        if (topMargin < 0) {
            throw new IllegalArgumentException();
        }
        if (bottomMargin > this.mScreenRows) {
            throw new IllegalArgumentException();
        }
        int screenRows = this.mScreenRows;
        int totalRows = this.mTotalRows;
        if (topMargin == 0 && bottomMargin == screenRows) {
            this.mScreenFirstRow = (this.mScreenFirstRow + 1) % totalRows;
            if (this.mActiveTranscriptRows < totalRows - screenRows) {
                ++this.mActiveTranscriptRows;
            }
            int blankRow = this.externalToInternalRow(bottomMargin - 1);
            this.mLines[blankRow] = null;
            this.mColor[blankRow] = new StyleRow(style, this.mColumns);
            this.mLineWrap[blankRow] = false;
            return;
        }
        int screenFirstRow = this.mScreenFirstRow;
        int topMarginInt = this.externalToInternalRow(topMargin);
        int bottomMarginInt = this.externalToInternalRow(bottomMargin);
        Object[] lines = this.mLines;
        StyleRow[] color = this.mColor;
        boolean[] lineWrap = this.mLineWrap;
        Object scrollLine = lines[topMarginInt];
        StyleRow scrollColor = color[topMarginInt];
        boolean scrollLineWrap = lineWrap[topMarginInt];
        this.blockCopyLines(screenFirstRow, topMargin, 1);
        this.blockCopyLines(bottomMarginInt, screenRows - bottomMargin, 1);
        lines[screenFirstRow] = scrollLine;
        color[screenFirstRow] = scrollColor;
        lineWrap[screenFirstRow] = scrollLineWrap;
        this.mScreenFirstRow = (screenFirstRow + 1) % totalRows;
        if (this.mActiveTranscriptRows < totalRows - screenRows) {
            ++this.mActiveTranscriptRows;
        }
        int blankRow = this.externalToInternalRow(bottomMargin - 1);
        lines[blankRow] = null;
        color[blankRow] = new StyleRow(style, this.mColumns);
        lineWrap[blankRow] = false;
    }

    public void blockCopy(int sx, int sy, int w, int h, int dx, int dy) {
        if (sx < 0 || sx + w > this.mColumns || sy < 0 || sy + h > this.mScreenRows || dx < 0 || dx + w > this.mColumns || dy < 0 || dy + h > this.mScreenRows) {
            throw new IllegalArgumentException();
        }
        Object[] lines = this.mLines;
        StyleRow[] color = this.mColor;
        if (sy > dy) {
            for (int y = 0; y < h; ++y) {
                int srcRow = this.externalToInternalRow(sy + y);
                int dstRow = this.externalToInternalRow(dy + y);
                if (lines[srcRow] instanceof char[] && lines[dstRow] instanceof char[]) {
                    System.arraycopy(lines[srcRow], sx, lines[dstRow], dx, w);
                } else {
                    int extDstRow = dy + y;
                    char[] tmp = this.getLine(sy + y, sx, sx + w, true);
                    if (tmp == null) {
                        this.blockSet(dx, extDstRow, w, 1, 32, this.mDefaultStyle);
                        continue;
                    }
                    char cHigh = '\u0000';
                    int x = 0;
                    int columns = this.mColumns;
                    for (int i = 0; i < tmp.length && tmp[i] != '\u0000' && dx + x < columns; ++i) {
                        if (Character.isHighSurrogate(tmp[i])) {
                            cHigh = tmp[i];
                            continue;
                        }
                        if (Character.isLowSurrogate(tmp[i])) {
                            int codePoint = Character.toCodePoint(cHigh, tmp[i]);
                            this.setChar(dx + x, extDstRow, codePoint);
                            x += UnicodeTranscript.charWidth(codePoint);
                            continue;
                        }
                        this.setChar(dx + x, extDstRow, tmp[i]);
                        x += UnicodeTranscript.charWidth(tmp[i]);
                    }
                }
                color[srcRow].copy(sx, color[dstRow], dx, w);
            }
        } else {
            for (int y = 0; y < h; ++y) {
                int y2 = h - (y + 1);
                int srcRow = this.externalToInternalRow(sy + y2);
                int dstRow = this.externalToInternalRow(dy + y2);
                if (lines[srcRow] instanceof char[] && lines[dstRow] instanceof char[]) {
                    System.arraycopy(lines[srcRow], sx, lines[dstRow], dx, w);
                } else {
                    int extDstRow = dy + y2;
                    char[] tmp = this.getLine(sy + y2, sx, sx + w, true);
                    if (tmp == null) {
                        this.blockSet(dx, extDstRow, w, 1, 32, this.mDefaultStyle);
                        continue;
                    }
                    char cHigh = '\u0000';
                    int x = 0;
                    int columns = this.mColumns;
                    for (int i = 0; i < tmp.length && tmp[i] != '\u0000' && dx + x < columns; ++i) {
                        if (Character.isHighSurrogate(tmp[i])) {
                            cHigh = tmp[i];
                            continue;
                        }
                        if (Character.isLowSurrogate(tmp[i])) {
                            int codePoint = Character.toCodePoint(cHigh, tmp[i]);
                            this.setChar(dx + x, extDstRow, codePoint);
                            x += UnicodeTranscript.charWidth(codePoint);
                            continue;
                        }
                        this.setChar(dx + x, extDstRow, tmp[i]);
                        x += UnicodeTranscript.charWidth(tmp[i]);
                    }
                }
                color[srcRow].copy(sx, color[dstRow], dx, w);
            }
        }
    }

    public void blockSet(int sx, int sy, int w, int h, int val, int style) {
        if (sx < 0 || sx + w > this.mColumns || sy < 0 || sy + h > this.mScreenRows) {
            Log.e((String)TAG, (String)("illegal arguments! " + sx + " " + sy + " " + w + " " + h + " " + val + " " + this.mColumns + " " + this.mScreenRows));
            throw new IllegalArgumentException();
        }
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                this.setChar(sx + x, sy + y, val, style);
            }
        }
    }

    public static int charWidth(int codePoint) {
        if (codePoint > 31 && codePoint < 127) {
            return 1;
        }
        if (codePoint == 27) {
            return 1;
        }
        switch (Character.getType(codePoint)) {
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                return 0;
            }
        }
        if (codePoint >= 4448 && codePoint <= 4607 || codePoint >= 55216 && codePoint <= 55295) {
            if (AndroidCompat.SDK >= 16) {
                return 0;
            }
            return 2;
        }
        if (Character.charCount(codePoint) == 1) {
            switch (AndroidCharacterCompat.getEastAsianWidth((char)codePoint)) {
                case 3: 
                case 5: {
                    return 2;
                }
            }
        } else {
            switch (codePoint >> 16 & 0xF) {
                case 2: 
                case 3: {
                    return 2;
                }
            }
        }
        return 1;
    }

    public static int charWidth(char cHigh, char cLow) {
        return UnicodeTranscript.charWidth(Character.toCodePoint(cHigh, cLow));
    }

    public static int charWidth(char[] chars, int index) {
        char c = chars[index];
        if (Character.isHighSurrogate(c)) {
            return UnicodeTranscript.charWidth(c, chars[index + 1]);
        }
        return UnicodeTranscript.charWidth(c);
    }

    public char[] getLine(int row, int x1, int x2) {
        return this.getLine(row, x1, x2, false);
    }

    public char[] getLine(int row) {
        return this.getLine(row, 0, this.mColumns, true);
    }

    private char[] getLine(int row, int x1, int x2, boolean strictBounds) {
        if (row < -this.mActiveTranscriptRows || row > this.mScreenRows - 1) {
            throw new IllegalArgumentException();
        }
        int columns = this.mColumns;
        if (this.mLines[row = this.externalToInternalRow(row)] == null) {
            return null;
        }
        if (this.mLines[row] instanceof char[]) {
            if (x1 == 0 && x2 == columns) {
                return (char[])this.mLines[row];
            }
            if (this.tmpLine == null || this.tmpLine.length < columns + 1) {
                this.tmpLine = new char[columns + 1];
            }
            int length = x2 - x1;
            System.arraycopy(this.mLines[row], x1, this.tmpLine, 0, length);
            this.tmpLine[length] = '\u0000';
            return this.tmpLine;
        }
        FullUnicodeLine line = (FullUnicodeLine)this.mLines[row];
        char[] rawLine = line.getLine();
        if (x1 == 0 && x2 == columns) {
            int spaceUsed = line.getSpaceUsed();
            if (spaceUsed < rawLine.length) {
                rawLine[spaceUsed] = '\u0000';
            }
            return rawLine;
        }
        x1 = line.findStartOfColumn(x1);
        if (x2 < columns) {
            int endCol = x2;
            x2 = line.findStartOfColumn(endCol);
            if (!strictBounds && endCol > 0 && endCol < columns - 1 && x2 == line.findStartOfColumn(endCol - 1)) {
                x2 = line.findStartOfColumn(endCol + 1);
            }
        } else {
            x2 = line.getSpaceUsed();
        }
        int length = x2 - x1;
        if (this.tmpLine == null || this.tmpLine.length < length + 1) {
            this.tmpLine = new char[length + 1];
        }
        System.arraycopy(rawLine, x1, this.tmpLine, 0, length);
        this.tmpLine[length] = '\u0000';
        return this.tmpLine;
    }

    public StyleRow getLineColor(int row, int x1, int x2) {
        return this.getLineColor(row, x1, x2, false);
    }

    public StyleRow getLineColor(int row) {
        return this.getLineColor(row, 0, this.mColumns, true);
    }

    private StyleRow getLineColor(int row, int x1, int x2, boolean strictBounds) {
        if (row < -this.mActiveTranscriptRows || row > this.mScreenRows - 1) {
            throw new IllegalArgumentException();
        }
        row = this.externalToInternalRow(row);
        StyleRow color = this.mColor[row];
        StyleRow tmp = this.tmpColor;
        if (color != null) {
            int columns = this.mColumns;
            if (!strictBounds && this.mLines[row] != null && this.mLines[row] instanceof FullUnicodeLine) {
                FullUnicodeLine line = (FullUnicodeLine)this.mLines[row];
                if (x1 > 0 && line.findStartOfColumn(x1 - 1) == line.findStartOfColumn(x1)) {
                    --x1;
                }
                if (x2 < columns - 1 && line.findStartOfColumn(x2 + 1) == line.findStartOfColumn(x2)) {
                    ++x2;
                }
            }
            if (x1 == 0 && x2 == columns) {
                return color;
            }
            color.copy(x1, tmp, 0, x2 - x1);
            return tmp;
        }
        return null;
    }

    boolean isBasicLine(int row) {
        if (row < -this.mActiveTranscriptRows || row > this.mScreenRows - 1) {
            throw new IllegalArgumentException();
        }
        return this.mLines[this.externalToInternalRow(row)] instanceof char[];
    }

    public boolean getChar(int row, int column) {
        return this.getChar(row, column, 0);
    }

    public boolean getChar(int row, int column, int charIndex) {
        return this.getChar(row, column, charIndex, new char[1], 0);
    }

    public boolean getChar(int row, int column, int charIndex, char[] out, int offset) {
        if (row < -this.mActiveTranscriptRows || row > this.mScreenRows - 1) {
            throw new IllegalArgumentException();
        }
        if (this.mLines[row = this.externalToInternalRow(row)] instanceof char[]) {
            char[] line = (char[])this.mLines[row];
            out[offset] = line[column];
            return false;
        }
        FullUnicodeLine line = (FullUnicodeLine)this.mLines[row];
        return line.getChar(column, charIndex, out, offset);
    }

    private boolean isBasicChar(int codePoint) {
        return UnicodeTranscript.charWidth(codePoint) == 1 && Character.charCount(codePoint) == 1;
    }

    private char[] allocateBasicLine(int row, int columns) {
        char[] line = new char[columns];
        for (int i = 0; i < columns; ++i) {
            line[i] = 32;
        }
        this.mLines[row] = line;
        if (this.mColor[row] == null) {
            this.mColor[row] = new StyleRow(0, columns);
        }
        return line;
    }

    private FullUnicodeLine allocateFullLine(int row, int columns) {
        FullUnicodeLine line = new FullUnicodeLine(columns);
        this.mLines[row] = line;
        if (this.mColor[row] == null) {
            this.mColor[row] = new StyleRow(0, columns);
        }
        return line;
    }

    public boolean setChar(int column, int row, int codePoint, int style) {
        if (!this.setChar(column, row, codePoint)) {
            return false;
        }
        row = this.externalToInternalRow(row);
        this.mColor[row].set(column, style);
        return true;
    }

    public boolean setChar(int column, int row, int codePoint) {
        Object line;
        if (row >= this.mScreenRows || column >= this.mColumns) {
            Log.e((String)TAG, (String)("illegal arguments! " + row + " " + column + " " + this.mScreenRows + " " + this.mColumns));
            throw new IllegalArgumentException();
        }
        row = this.externalToInternalRow(row);
        int basicMode = -1;
        if (this.mLines[row] == null) {
            if (this.isBasicChar(codePoint)) {
                this.allocateBasicLine(row, this.mColumns);
                basicMode = 1;
            } else {
                this.allocateFullLine(row, this.mColumns);
                basicMode = 0;
            }
        }
        if (this.mLines[row] instanceof char[]) {
            line = (char[])this.mLines[row];
            if (basicMode == -1) {
                basicMode = this.isBasicChar(codePoint) ? 1 : 0;
            }
            if (basicMode == 1) {
                line[column] = (char)codePoint;
                return true;
            }
            this.mLines[row] = new FullUnicodeLine((char[])line);
        }
        line = (FullUnicodeLine)this.mLines[row];
        ((FullUnicodeLine)line).setChar(column, codePoint);
        return true;
    }
}

