/*
 * Decompiled with CFR 0.152.
 */
package jackpal.androidterm.emulatorview;

import android.graphics.Canvas;
import jackpal.androidterm.emulatorview.ColorScheme;
import jackpal.androidterm.emulatorview.GrowableIntArray;
import jackpal.androidterm.emulatorview.Screen;
import jackpal.androidterm.emulatorview.StyleRow;
import jackpal.androidterm.emulatorview.TextRenderer;
import jackpal.androidterm.emulatorview.TextStyle;
import jackpal.androidterm.emulatorview.UnicodeTranscript;
import java.util.Arrays;

class TranscriptScreen
implements Screen {
    private int mColumns;
    private int mTotalRows;
    private int mScreenRows;
    private UnicodeTranscript mData;

    public TranscriptScreen(int columns, int totalRows, int screenRows, ColorScheme scheme) {
        this.init(columns, totalRows, screenRows, TextStyle.kNormalTextStyle);
    }

    private void init(int columns, int totalRows, int screenRows, int style) {
        this.mColumns = columns;
        this.mTotalRows = totalRows;
        this.mScreenRows = screenRows;
        this.mData = new UnicodeTranscript(columns, totalRows, screenRows, style);
        this.mData.blockSet(0, 0, this.mColumns, this.mScreenRows, 32, style);
    }

    public void setColorScheme(ColorScheme scheme) {
        this.mData.setDefaultStyle(TextStyle.kNormalTextStyle);
    }

    public void finish() {
        this.mData = null;
    }

    @Override
    public void setLineWrap(int row) {
        this.mData.setLineWrap(row);
    }

    @Override
    public void set(int x, int y, int codePoint, int style) {
        this.mData.setChar(x, y, codePoint, style);
    }

    @Override
    public void set(int x, int y, byte b, int style) {
        this.mData.setChar(x, y, b, style);
    }

    @Override
    public void scroll(int topMargin, int bottomMargin, int style) {
        this.mData.scroll(topMargin, bottomMargin, style);
    }

    @Override
    public void blockCopy(int sx, int sy, int w, int h, int dx, int dy) {
        this.mData.blockCopy(sx, sy, w, h, dx, dy);
    }

    @Override
    public void blockSet(int sx, int sy, int w, int h, int val, int style) {
        this.mData.blockSet(sx, sy, w, h, val, style);
    }

    public final void drawText(int row, Canvas canvas, float x, float y, TextRenderer renderer, int cx, int selx1, int selx2, String imeText, int cursorMode) {
        int index;
        int incr;
        StyleRow color;
        char[] line;
        int cursorWidth = 1;
        try {
            line = this.mData.getLine(row);
            color = this.mData.getLineColor(row);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (NullPointerException e) {
            return;
        }
        int defaultStyle = this.mData.getDefaultStyle();
        if (line == null) {
            char[] blank;
            if (selx1 != selx2) {
                blank = new char[selx2 - selx1];
                Arrays.fill(blank, ' ');
                renderer.drawTextRun(canvas, x, y, selx1, selx2 - selx1, blank, 0, 1, true, defaultStyle, cx, 0, 1, 1, cursorMode);
            }
            if (cx != -1) {
                blank = new char[1];
                Arrays.fill(blank, ' ');
                renderer.drawTextRun(canvas, x, y, cx, 1, blank, 0, 1, true, defaultStyle, cx, 0, 1, 1, cursorMode);
            }
            return;
        }
        int columns = this.mColumns;
        int lineLen = line.length;
        int lastStyle = 0;
        boolean lastSelectionStyle = false;
        int runWidth = 0;
        int lastRunStart = -1;
        int lastRunStartIndex = -1;
        boolean forceFlushRun = false;
        int column = 0;
        int nextColumn = 0;
        int displayCharWidth = 0;
        int cursorIndex = 0;
        int cursorIncr = 0;
        for (index = 0; column < columns && index < lineLen && line[index] != '\u0000'; index += incr) {
            int width;
            incr = 1;
            if (Character.isHighSurrogate(line[index])) {
                width = UnicodeTranscript.charWidth(line, index);
                ++incr;
            } else {
                width = UnicodeTranscript.charWidth(line[index]);
            }
            if (width > 0) {
                column = nextColumn;
                displayCharWidth = width;
            }
            int style = color.get(column);
            boolean selectionStyle = false;
            if ((column >= selx1 || displayCharWidth == 2 && column == selx1 - 1) && column <= selx2) {
                selectionStyle = true;
            }
            if (style != lastStyle || selectionStyle != lastSelectionStyle || width > 0 && forceFlushRun) {
                if (lastRunStart >= 0) {
                    renderer.drawTextRun(canvas, x, y, lastRunStart, runWidth, line, lastRunStartIndex, index - lastRunStartIndex, lastSelectionStyle, lastStyle, cx, cursorIndex, cursorIncr, cursorWidth, cursorMode);
                }
                lastStyle = style;
                lastSelectionStyle = selectionStyle;
                runWidth = 0;
                lastRunStart = column;
                lastRunStartIndex = index;
                forceFlushRun = false;
            }
            if (cx == column) {
                if (width > 0) {
                    cursorIndex = index;
                    cursorIncr = incr;
                    cursorWidth = width;
                } else {
                    cursorIncr += incr;
                }
            }
            runWidth += width;
            nextColumn += width;
            if (width <= 1) continue;
            forceFlushRun = true;
        }
        if (lastRunStart >= 0) {
            renderer.drawTextRun(canvas, x, y, lastRunStart, runWidth, line, lastRunStartIndex, index - lastRunStartIndex, lastSelectionStyle, lastStyle, cx, cursorIndex, cursorIncr, cursorWidth, cursorMode);
        }
        if (cx >= 0 && imeText.length() > 0) {
            int imeLength = Math.min(columns, imeText.length());
            int imeOffset = imeText.length() - imeLength;
            int imePosition = Math.min(cx, columns - imeLength);
            renderer.drawTextRun(canvas, x, y, imePosition, imeLength, imeText.toCharArray(), imeOffset, imeLength, true, TextStyle.encode(15, 0, 0), -1, 0, 0, 0, 0);
        }
    }

    @Override
    public int getActiveRows() {
        return this.mData.getActiveRows();
    }

    public int getActiveTranscriptRows() {
        return this.mData.getActiveTranscriptRows();
    }

    @Override
    public String getTranscriptText() {
        return this.internalGetTranscriptText(null, 0, -this.mData.getActiveTranscriptRows(), this.mColumns, this.mScreenRows);
    }

    @Override
    public String getTranscriptText(GrowableIntArray colors) {
        return this.internalGetTranscriptText(colors, 0, -this.mData.getActiveTranscriptRows(), this.mColumns, this.mScreenRows);
    }

    @Override
    public String getSelectedText(int selX1, int selY1, int selX2, int selY2) {
        return this.internalGetTranscriptText(null, selX1, selY1, selX2, selY2);
    }

    @Override
    public String getSelectedText(GrowableIntArray colors, int selX1, int selY1, int selX2, int selY2) {
        return this.internalGetTranscriptText(colors, selX1, selY1, selX2, selY2);
    }

    private String internalGetTranscriptText(GrowableIntArray colors, int selX1, int selY1, int selX2, int selY2) {
        StringBuilder builder = new StringBuilder();
        UnicodeTranscript data = this.mData;
        int columns = this.mColumns;
        StyleRow rowColorBuffer = null;
        if (selY1 < -data.getActiveTranscriptRows()) {
            selY1 = -data.getActiveTranscriptRows();
        }
        if (selY2 >= this.mScreenRows) {
            selY2 = this.mScreenRows - 1;
        }
        for (int row = selY1; row <= selY2; ++row) {
            char c;
            int i;
            int x2;
            int x1 = 0;
            if (row == selY1) {
                x1 = selX1;
            }
            if (row == selY2) {
                x2 = selX2 + 1;
                if (x2 > columns) {
                    x2 = columns;
                }
            } else {
                x2 = columns;
            }
            char[] line = data.getLine(row, x1, x2);
            if (colors != null) {
                rowColorBuffer = data.getLineColor(row, x1, x2);
            }
            if (line == null) {
                if (data.getLineWrap(row) || row >= selY2 || row >= this.mScreenRows - 1) continue;
                builder.append('\n');
                if (colors == null) continue;
                colors.append(0);
                continue;
            }
            int defaultColor = this.mData.getDefaultStyle();
            int lastPrintingChar = -1;
            int lineLen = line.length;
            int column = 0;
            for (i = 0; i < lineLen && (c = line[i]) != '\u0000'; ++i) {
                int style = defaultColor;
                try {
                    if (rowColorBuffer != null) {
                        style = rowColorBuffer.get(column);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    style = defaultColor;
                }
                if (c != ' ' || style != defaultColor) {
                    lastPrintingChar = i;
                }
                if (Character.isLowSurrogate(c)) continue;
                column += UnicodeTranscript.charWidth(line, i);
            }
            if (data.getLineWrap(row) && lastPrintingChar > -1 && x2 == columns) {
                lastPrintingChar = i - 1;
            }
            builder.append(line, 0, lastPrintingChar + 1);
            if (colors != null) {
                int j;
                if (rowColorBuffer != null) {
                    column = 0;
                    for (j = 0; j <= lastPrintingChar; ++j) {
                        colors.append(rowColorBuffer.get(column));
                        column += UnicodeTranscript.charWidth(line, j);
                        if (!Character.isHighSurrogate(line[j])) continue;
                        ++j;
                    }
                } else {
                    for (j = 0; j <= lastPrintingChar; ++j) {
                        colors.append(defaultColor);
                        char c2 = line[j];
                        if (!Character.isHighSurrogate(c2)) continue;
                        ++j;
                    }
                }
            }
            if (data.getLineWrap(row) || row >= selY2 || row >= this.mScreenRows - 1) continue;
            builder.append('\n');
            if (colors == null) continue;
            colors.append(0);
        }
        return builder.toString();
    }

    @Override
    public boolean fastResize(int columns, int rows, int[] cursor) {
        if (this.mData == null) {
            return true;
        }
        if (this.mData.resize(columns, rows, cursor)) {
            this.mColumns = columns;
            this.mScreenRows = rows;
            return true;
        }
        return false;
    }

    @Override
    public void resize(int columns, int rows, int style) {
        if (rows > this.mTotalRows) {
            this.mTotalRows = rows;
        }
        this.init(columns, this.mTotalRows, rows, style);
    }

    char[] getScriptLine(int row) {
        try {
            return this.mData.getLine(row);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    boolean getScriptLineWrap(int row) {
        return this.mData.getLineWrap(row);
    }

    boolean isBasicLine(int row) {
        if (this.mData != null) {
            return this.mData.isBasicLine(row);
        }
        return true;
    }
}

